<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use backend\models\ItEasyMaterialHistory;
use backend\models\ItEasyVendor;
use backend\models\ItEasyProductMaterial;
use common\models\User;
use backend\models\ItEasyTax;
use kartik\date\DatePicker;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyMaterialHistory $model */
/** @var yii\widgets\ActiveForm $form */
?>

<style type="text/css">
    .btn-main-greeenarry{
        background-color:#bdd51f !important;
        color: #fcfcfc;
    }
</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">
            
            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <div class="pr-1 mb-xl-0">
                        <a href="<?= BASE_URL ?>material-history"><button type="button" class="btn btn-info btn-icon mr-2" title="List-Page"><i class="icon ion-ios-list-box"></i></button></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <?php $form = ActiveForm::begin(); ?>
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="main-content-label mg-b-5">
                        <?= Html::encode($this->title) ?>
                    </div>
            <p class="mg-b-20">Please create material history according to you !!</p>
        <div class="pd-30 pd-sm-40 bg-gray-200">
            <div class="row row-xs">
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_vendor_id')->dropDownList(
        ArrayHelper::map(ItEasyVendor::find()->select(['it_easy_id', 'it_easy_vendor_name'])->where(['it_easy_status' => 'Active'])->asArray()->all(),'it_easy_id','it_easy_vendor_name'),[
                 'prompt' => 'Please Select'])->label('Vendor Name') ?>
        </div>
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_material_id')->dropDownList(
        ArrayHelper::map(ItEasyProductMaterial::find()->select(['it_easy_id', 'it_easy_material_name'])->where(['it_easy_status' => 'Active'])->asArray()->all(),'it_easy_id','it_easy_material_name'),[
                 'prompt' => 'Please Select'])->label('Material Name') ?>
        </div>

    <div class="col-md-4">
    <?= $form->field($model, 'it_easy_invoice_number')->textInput(['maxlength' => true]) ?>
        </div>
    
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_amount_status')->dropDownList(['Pending' => 'Pending', 'Cleared' => 'Cleared'], ['prompt' => 'Select Payment Status']) ?>
        </div>
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_material_quantity')->textInput(['maxlength' => true]) ?>
        </div>
        
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_per_kg')->textInput(['maxlength' => true])->label('Price On One Weight Item') ?>
        </div>
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_total_price')->textInput(['maxlength' => true]) ?>
        </div>
         <div class="col-md-4">
    <?= $form->field($model, 'it_easy_gst_type')->dropDownList(
        ArrayHelper::map(ItEasyTax::find()->select(['it_easy_tax_id', 'it_easy_tax_name'])->where(['it_easy_tax_status' => 'Active'])->asArray()->all(),'it_easy_tax_id','it_easy_tax_name'),[
                 'prompt' => 'Please Select'])->label('GST Name') ?>
        </div>
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_gst_amount')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-md-6">
    <?= $form->field($model, 'it_easy_received_by')->dropDownList(
        ArrayHelper::map(User::find()->select(['id', 'it_easy_firstname'])->where(['status' => 'Active'])->andWhere(['it_easy_dept_id'=>2])->asArray()->all(),'id','it_easy_firstname'),[
                 'prompt' => 'Please Select'])->label('Product Received By') ?>
        </div>
        <div class="col-md-6">
        <?php echo '<label>Produt Received Date</label>'; ?>
        <?= DatePicker::widget([
        'name' => 'ItEasyMaterialHistory[it_easy_received_date]', 
        'value' => "$model->it_easy_received_date",
        'pluginOptions' => [
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true
            ]
        ]) ?>
        </div>

    
        <div class="row">
              <div class="col-md-1">
                <?= Html::submitButton('Save', ['class' => 'btn btn-dark btn-block']) ?>
                </div>
                <div class="col-md-1">
         
            <?= Html::a('Cancel', ['index'], ['class' => 'btn bg-maroon btn-flat btn btn btn-danger','onclick' => 'return confirm("Are you sure? You want to Exit?");']) ?>
                </div>

            </div>
                 </div>
                </div>
                </div>
            </div>
        </div>
        
    </div>
    <?php ActiveForm::end(); ?>

</div>
