<?php

use backend\models\ItEasyOrder;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyOrderSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Agent Sales Growth Analysis';
$this->params['breadcrumbs'][] = $this->title;
// echo "<pre>"; print_r($searchModel); die;

?>
<style type="text/css">

  .bg-gray-200{
    border-radius: 8px; 
  }
  .font-weight-bold{
      color: #2cac81;
      font-size: 22px;
      margin-top: 13px;
      margin-bottom: 15px;
      font-weight: bolder;
      font-family: cursive;
  }
  .mb-1{
    font-weight: 700;
    font-size: 12px;
    margin-top: 15px;
  }
  .card-order-total{
    border-radius: 0px !important;
    border: none !important;
  }
  textarea{
    border-radius: 10px !important;
    background-color: #ffffff !important;
    border: 2px solid #fdfdfd !important;
  }
</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">
                

            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <div class="row row-sm">
        <div class="col-xl-12 col-md-12">
              <div class="col-md-12">
    <?php $formsearch = ActiveForm::begin(['action' => ['agentwise'],'method' => 'get']); ?>
                
                  <div class="col-md-2">
                    <?php if((Yii::$app->user->identity->it_easy_type_id != '4' && Yii::$app->user->identity->it_easy_type_id != '5')){ ?>
                        <?= $formsearch->field($searchModel, 'it_easy_assigned_by')->dropDownList($tl_data, [ 'prompt' => 'Search by TL Name'])->label(false); ?>

                      <?php } ?>
                    </div>
                    <div class="col-md-2">
                        <?= $formsearch->field($searchModel, 'it_easy_assigned_to')->dropDownList($agent_data, [ 'prompt' => 'Search by Agent Name'])->label(false); ?>
                    </div>

                    <div class="col-md-2">
                        <?= $formsearch->field($searchModel, 'it_easy_first_status')->dropDownlist(['Lead' => 'Lead', 'COD' => 'COD', 'Prepaid' => 'Prepaid'], ['prompt' => 'Search by First Status'])->label(false); ?>
                    </div>

                    <div class="col-md-2">
                        <?= $formsearch->field($searchModel, 'date_type_filter')->dropDownList(['Date Added' => 'Date Added', 'Date Modified' => 'Date Modified', 'Date Assigned' => 'Date Assigned', 'Date Converted' => 'Date Converted', 'Date Dispatched' => 'Date Dispatched', 'Date Delivered' => 'Date Delivered'])->label(false); ?>
                    </div>
                <div class="col-md-2">
                <div class="form-group field-iteasyordersearch-date_from_date">
                  <?= DatePicker::widget([
                  'name' => 'ItEasyOrderSearch[date_from_date]', 
                  'value' => empty($searchModel->date_from_date) ? date('Y-m').'-01' : $searchModel->date_from_date,
                  'options' => ['placeholder' => 'From date', 'id' => 'iteasyordersearch-date_from_date'],
                  'pluginOptions' => [
                  'format' => 'yyyy-mm-dd',
                  'todayHighlight' => true,
                  'autoclose' => true,
                  'placeholder' => 'Search by From date'
                      ]
                  ]) ?>
                </div>
                </div>
                <div class="col-md-2">
                <div class="form-group field-iteasyordersearch-date_to_date">
                    <?= DatePicker::widget([
                    'name' => 'ItEasyOrderSearch[date_to_date]', 
                    'value' => empty($searchModel->date_to_date) ? date('Y-m-d') : $searchModel->date_to_date,
                    'options' => ['placeholder' => 'To date', 'id' => 'iteasyordersearch-date_to_date'],
                    'pluginOptions' => [
                    'format' => 'yyyy-mm-dd',
                    'todayHighlight' => true,
                    'autoclose' => true,
                        ]
                    ]) ?>
                </div>
                </div>
            
            <div class="col-md-2" style="float: right;">
                <?= Html::submitButton('Search', ['class' => 'btn btn-secondary btn-block']) ?>
            </div>
      <?php ActiveForm::end(); ?>
              <br>
              <h4 style="float: right; color: #3e3e6e;font-family: ui-monospace;">by default This Month data</4>
            <br>
            </div>
             
        </div>
      </div>




    <div class="row row-sm">
      <div class="col-md-12">
        <div class="col-xl-6 col-md-6">
            <div class="pd-30 pd-sm-40 bg-gray-200">
              <div class="row">
                <div class="col-md-12">
                  <div class="col-xl-6 col-lg-6 col-sm-6 col-md-6">
                    <div class="card card-order-total text-center">
                      <div class="card-body ">
                        
                        <h6 class="mb-1 text-muted">Assigned<br> Leads</h6>
                        <h3 class="font-weight-bold"><b><?= !empty($agentwise_total_report['total_assign']) ? $agentwise_total_report['total_assign'] : '0'; ?></b></h3>
                      </div>
                    </div>
                  </div>
                  <div class="col-xl-6 col-lg-6 col-sm-6 col-md-6">
                    <div class="card card-order-total text-center">
                      <div class="card-body ">
                        
                        <h6 class="mb-1 text-muted">Approval<br>Pending</h6>
                        <h3 class="font-weight-bold"><b><?= !empty($agentwise_total_report['approval_pending_count']) ? $agentwise_total_report['approval_pending_count'] : '0'; ?></b></h3>
                      </div>
                    </div>
                  </div>
                  <div class="col-xl-6 col-lg-6 col-sm-6 col-md-6">
                    <div class="card card-order-total text-center">
                      <div class="card-body ">
                        <h6 class="mb-1 text-muted">Dispatched<br>Order</h6>
                        <h3 class="font-weight-bold"><b><?= !empty($agentwise_total_report['dispatched_order_count']) ? $agentwise_total_report['dispatched_order_count'] : '0'; ?></b></h3>
                      </div>
                    </div>
                  </div>
                  <div class="col-xl-6 col-lg-6 col-sm-6 col-md-6">
                    <div class="card card-order-total text-center">
                      <div class="card-body ">
                        <h6 class="mb-1 text-muted">RTO<br>Order</h6>
                        <h3 class="font-weight-bold"><b><?= !empty($agentwise_total_report['rto_order_count']) ? $agentwise_total_report['rto_order_count'] : '0'; ?></b></h3>
                      </div>
                    </div>
                  </div>
                  <div class="col-xl-6 col-lg-6 col-sm-6 col-md-6">
                    <div class="card card-order-total text-center">
                      <div class="card-body ">
                        
                        <h6 class="mb-1 text-muted">Confirmed<br> Orders</h6>
                        <h3 class="font-weight-bold"><b><?= !empty($agentwise_total_report['confirm_count']) ? $agentwise_total_report['confirm_count'] : '0'; ?></b></h3>
                      </div>
                    </div>
                  </div>
                  <div class="col-xl-6 col-lg-6 col-sm-6 col-md-6">
                    <div class="card card-order-total text-center">
                      <div class="card-body ">
                        
                        <h6 class="mb-1 text-muted">On Hold<br>Order</h6>
                        <h3 class="font-weight-bold"><b><?= !empty($agentwise_total_report['hold_order_count']) ? $agentwise_total_report['hold_order_count'] : '0'; ?></b></h3>
                      </div>
                    </div>
                  </div>
                  <div class="col-xl-6 col-lg-6 col-sm-6 col-md-6">
                    <div class="card card-order-total text-center">
                      <div class="card-body ">
                        <h6 class="mb-1 text-muted">Delivered<br>Order</h6>
                        <h3 class="font-weight-bold"><b><?= !empty($agentwise_total_report['delivered_order_count']) ? $agentwise_total_report['delivered_order_count'] : '0'; ?></b></h3>
                      </div>
                    </div>
                  </div>
                  <div class="col-xl-6 col-lg-6 col-sm-6 col-md-6">
                    <div class="card card-order-total text-center">
                      <div class="card-body ">
                        <h6 class="mb-1 text-muted">Shipment<br>Lost</h6>
                        <h3 class="font-weight-bold"><b><?= !empty($agentwise_total_report['lost_order_count']) ? $agentwise_total_report['lost_order_count'] : '0'; ?></b></h3>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
        </div>
        <div class="col-xl-6 col-md-6">
            <div class="pd-30 pd-sm-40 bg-gray-200">
              <div class="row">
                <div class="col-md-12">
                  <div class="col-xl-6 col-lg-6 col-sm-6 col-md-6">
                    <div class="card card-order-total text-center">
                      <div class="card-body ">
                        
                        <h6 class="mb-1 text-muted">Assigned<br> Leads Amount</h6>
                        <h3 class="font-weight-bold"><b><?= !empty($agentwise_total_report['sum_assign_total']) ? $agentwise_total_report['sum_assign_total'] : '0'; ?></b></h3>
                      </div>
                    </div>
                  </div>
                  <div class="col-xl-6 col-lg-6 col-sm-6 col-md-6">
                    <div class="card card-order-total text-center">
                      <div class="card-body ">
                        
                        <h6 class="mb-1 text-muted">Pending<br>Order Amount</h6>
                        <h3 class="font-weight-bold"><b><?= !empty($agentwise_total_report['approval_pending_sum']) ? $agentwise_total_report['approval_pending_sum'] : '0'; ?></b></h3>
                      </div>
                    </div>
                  </div>
                  <div class="col-xl-6 col-lg-6 col-sm-6 col-md-6">
                    <div class="card card-order-total text-center">
                      <div class="card-body ">
                        <h6 class="mb-1 text-muted">Dispatched<br>Order Amount</h6>
                        <h3 class="font-weight-bold"><b><?= !empty($agentwise_total_report['dispatched_order_sum']) ? $agentwise_total_report['dispatched_order_sum'] : '0'; ?></b></h3>
                      </div>
                    </div>
                  </div>
                  <div class="col-xl-6 col-lg-6 col-sm-6 col-md-6">
                    <div class="card card-order-total text-center">
                      <div class="card-body ">
                        <h6 class="mb-1 text-muted">RTO<br>Order Amount</h6>
                        <h3 class="font-weight-bold"><b><?= !empty($agentwise_total_report['rto_order_sum']) ? $agentwise_total_report['rto_order_sum'] : '0'; ?></b></h3>
                      </div>
                    </div>
                  </div>
                  <div class="col-xl-6 col-lg-6 col-sm-6 col-md-6">
                    <div class="card card-order-total text-center">
                      <div class="card-body ">
                        
                        <h6 class="mb-1 text-muted">Confirmed<br> Orders Amount</h6>
                        <h3 class="font-weight-bold"><b><?= !empty($agentwise_total_report['confirm_sum']) ? $agentwise_total_report['confirm_sum'] : '0'; ?></b></h3>
                      </div>
                    </div>
                  </div>
                  <div class="col-xl-6 col-lg-6 col-sm-6 col-md-6">
                    <div class="card card-order-total text-center">
                      <div class="card-body ">
                        
                        <h6 class="mb-1 text-muted">Average<br>Ticket Size</h6>
                        <h3 class="font-weight-bold"><b><?= !empty($agentwise_total_report['average_ticket']) ? $agentwise_total_report['average_ticket'] : '0'; ?></b></h3>
                      </div>
                    </div>
                  </div>
                  <div class="col-xl-6 col-lg-6 col-sm-6 col-md-6">
                    <div class="card card-order-total text-center">
                      <div class="card-body ">
                        <h6 class="mb-1 text-muted">Delivered<br>Order Amount</h6>
                        <h3 class="font-weight-bold"><b><?= !empty($agentwise_total_report['delivered_order_sum']) ? $agentwise_total_report['delivered_order_sum'] : '0'; ?></b></h3>
                      </div>
                    </div>
                  </div>
                  <div class="col-xl-6 col-lg-6 col-sm-6 col-md-6">
                    <div class="card card-order-total text-center">
                      <div class="card-body ">
                        <h6 class="mb-1 text-muted">Shipment<br>Lost Amount</h6>
                        <h3 class="font-weight-bold"><b><?= !empty($agentwise_total_report['lost_order_sum']) ? $agentwise_total_report['lost_order_sum'] : '0'; ?></b></h3>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
        </div>
    </div>
    </div>

    <br>

    <div class="row row-sm">
      <div class="col-md-12 col-lg-12  col-xl-12 col-sm-12" style="padding: 0px 22px;">
        <div class="card" style="padding: 0px 22px;">
          <div class="card-header">
            <div class="d-flex justify-content-between">
              <h4 class="card-title" style="font-family: system-ui;font-size: 18px;">State Wise Analysis Data</h4>
              <i class="mdi mdi-dots-vertical"></i>
            </div>
            <p class="tx-12 tx-gray-500 mb-0">You will see now the state in which your conversion will be going more and more.</p>
          </div><!-- card-header -->
          <div class="card-body p-0" style="margin-bottom: 30px;">

            <table class="table card-table country-table mb-0">
              <tbody>
                <tr>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">StateName</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Assign Order</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Confirm Order</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Dispatch Order</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Delivered Order</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">RTO Order</td>
                </tr>
            <?php if(!empty($agentwise_state_report)){
              foreach ($agentwise_state_report as $key => $state_report) {
                $confirm_percentage = round(($state_report['confirm_count']  / $state_report['total_assign'] ) * 100, 0, 2);
                if(!empty($state_report['confirm_count'])){
                $dispatch_percentage = round(($state_report['dispatched_order_count']  / $state_report['confirm_count'] ) * 100, 0, 2);
                }else{
                  $dispatch_percentage = '0';
                }
                if(!empty($state_report['confirm_count'])){
                $delivered_percentage = round(($state_report['delivered_order_count']  / $state_report['confirm_count'] ) * 100, 0, 2);
                }else{
                  $delivered_percentage = '0';
                }
                if(!empty($state_report['confirm_count'])){
                  $rto_percentage = round(($state_report['rto_order_count']  / $state_report['confirm_count'] ) * 100, 0, 2);
                }else{
                  $rto_percentage = '0';
                }  

         ?>
                <tr>
                  <td style="text-align: center;"><?= $state_report['it_easy_state']; ?></td>
                  <td style="text-align: center;"><?= $state_report['total_assign']; ?></td>
                  <td style="text-align: center;"><?= $state_report['confirm_count']; ?>&nbsp;&nbsp;&nbsp;
                    <?php if($confirm_percentage < 12){ ?>
                    <span class="text-danger"><i class="fe fe-arrow-down"></i><?= $confirm_percentage; ?>%</span>
                    <?php }else{ ?>
                    <span class="text-success fs-15"><i class="fe fe-arrow-up"></i><?= $confirm_percentage; ?>%</span>
                    <?php } ?> 
                  </td>
                  <td style="text-align: center;"><?= $state_report['dispatched_order_count']; ?>&nbsp;&nbsp;&nbsp;
                    <?php if($dispatch_percentage < 95){ ?>
                    <span class="text-danger"><i class="fe fe-arrow-down"></i><?= $dispatch_percentage; ?>%</span>
                    <?php }else{ ?>
                    <span class="text-success fs-15"><i class="fe fe-arrow-up"></i><?= $dispatch_percentage; ?>%</span>
                    <?php } ?> 
                  </td>
                  <td style="text-align: center;"><?= $state_report['delivered_order_count']; ?>&nbsp;&nbsp;&nbsp;
                    <?php if($delivered_percentage < 75){ ?>
                    <span class="text-danger"><i class="fe fe-arrow-down"></i><?= $delivered_percentage; ?>%</span>
                    <?php }else{ ?>
                    <span class="text-success fs-15"><i class="fe fe-arrow-up"></i><?= $delivered_percentage; ?>%</span>
                    <?php } ?> 
                  </td>
                  <td style="text-align: center;"><?= $state_report['rto_order_count']; ?>&nbsp;&nbsp;&nbsp;
                    <?php if($rto_percentage > 20){ ?>
                    <span class="text-danger"><i class="fe fe-arrow-down"></i><?= $rto_percentage; ?>%</span>
                    <?php }else{ ?>
                    <span class="text-success fs-15"><i class="fe fe-arrow-up"></i><?= $rto_percentage; ?>%</span>
                    <?php } ?> 
                  </td>
                </tr>
             <?php } } ?>    
              </tbody>
            </table>





            
          </div>
        </div><!-- card -->
      </div>
    </div>


    <br>
    <div class="row row-sm">
      <div class="col-md-12 col-lg-12  col-xl-12 col-sm-12" style="padding: 0px 22px;">
        <div class="card" style="padding: 0px 22px;">
          <div class="card-header">
            <div class="d-flex justify-content-between">
              <h4 class="card-title" style="font-family: system-ui;font-size: 18px;">Product Wise Analysis Data</h4>
              <i class="mdi mdi-dots-vertical"></i>
            </div>
            <p class="tx-12 tx-gray-500 mb-0">In this row, due to multiple products, the assigned order count can be high, so you can check on the particular product that How many orders have I made for the product and what has been its performance?</p>
          </div><!-- card-header -->
          <div class="card-body p-0" style="margin-bottom: 30px;">

            <table class="table card-table country-table mb-0">
              <tbody>
                <tr>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Product Name</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Total Order</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Total Order Value</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Product Quantity</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Ticket Size</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Confirm Order</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Confirm Total</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Dispatch Order</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Dispatch Total</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Delivered Order</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Delivered Total</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">RTO Order</td>
                </tr>
            <?php if(!empty($agentwise_product_report)){
              foreach ($agentwise_product_report as $key => $state_report) {
                //   echo "<pre>"; print_r($state_report);
                  $product_data = ItEasyOrder::OneProductWiseAgentwisegettotalReport($params, $state_report['it_easy_product_id'], $state_report['it_easy_variation_id']);
                //   echo "<pre>"; print_r($product_data); die;
                 if(!empty($product_data['confirm_count'])){  
                $confirm_percentage = round(($product_data['confirm_count']  / $product_data['total_assign'] ) * 100);
                 }else{
                     $confirm_percentage = '0';
                 }
                if(!empty($product_data['confirm_count'])){
                $dispatch_percentage = round(($product_data['dispatched_order_count']  / $product_data['confirm_count'] ) * 100);
                }else{
                  $dispatch_percentage = '0';
                }  
                if(!empty($product_data['confirm_count'])){
                $delivered_percentage = round(($product_data['delivered_order_count']  / $product_data['confirm_count'] ) * 100);
                }else{
                  $delivered_percentage = '0';
                }
                if(!empty($product_data['confirm_count'])){
                $rto_percentage = round(($product_data['rto_order_count']  / $product_data['confirm_count'] ) * 100);
                }else{
                  $rto_percentage = '0';
                }

         ?>
                <tr>
                  <td style="text-align: center;"><?= !empty($product_data['it_easy_product_name']) ? $product_data['it_easy_product_name'] : ''; ?> (<span style="font-size: 12px;"><?= !empty($product_data['it_easy_variation_name']) ? $product_data['it_easy_variation_name'] : ''; ?></span> )</td>
                  <td style="text-align: center;"><?= !empty( $product_data['total_assign']) ? $product_data['total_assign'] : ''; ?></td>
                  <td style="text-align: center;"><?= !empty( $product_data['ordered_ammount']) ? $product_data['ordered_ammount'] : ''; ?></td>
                  <td style="text-align: center;"><?= !empty($product_data['product_quantity']) ? $product_data['product_quantity'] : ''; ?></td>
                  
                  <td style="text-align: center;"><?= !empty($product_data['average_ticket_size']) ? $product_data['average_ticket_size'] : ''; ?>&nbsp;
                
                  </td>
                  <td style="text-align: center;"><?= !empty($product_data['confirm_count']) ? $product_data['confirm_count'] : ''; ?>&nbsp;&nbsp;&nbsp;
                    <?php if($confirm_percentage < 75){ ?>
                    <span class="text-danger"><i class="fe fe-arrow-down"></i><?= $confirm_percentage; ?>%</span>
                    <?php }else{ ?>
                    <span class="text-success fs-15"><i class="fe fe-arrow-up"></i><?= $confirm_percentage; ?>%</span>
                    <?php } ?> 
                  </td>
                  <td style="text-align: center;"><?= !empty($product_data['confirm_sum']) ? $product_data['confirm_sum'] : ''; ?>&nbsp;
                
                  </td>
                  <td style="text-align: center;"><?= !empty($product_data['dispatched_order_count']) ? $product_data['dispatched_order_count'] : ''; ?>&nbsp;&nbsp;&nbsp;
                    <?php if($dispatch_percentage < 95){ ?>
                    <span class="text-danger"><i class="fe fe-arrow-down"></i><?= $dispatch_percentage; ?>%</span>
                    <?php }else{ ?>
                    <span class="text-success fs-15"><i class="fe fe-arrow-up"></i><?= $dispatch_percentage; ?>%</span>
                    <?php } ?> 
                  </td>
                  <td style="text-align: center;"><?= !empty($product_data['dispatched_order_sum']) ? $product_data['dispatched_order_sum'] : ''; ?>&nbsp;
                
                  </td>
                  <td style="text-align: center;"><?= !empty($product_data['delivered_order_count']) ? $product_data['delivered_order_count'] : ''; ?>&nbsp;&nbsp;&nbsp;
                    <?php if($delivered_percentage < 75){ ?>
                    <span class="text-danger"><i class="fe fe-arrow-down"></i><?= $delivered_percentage; ?>%</span>
                    <?php }else{ ?>
                    <span class="text-success fs-15"><i class="fe fe-arrow-up"></i><?= $delivered_percentage; ?>%</span>
                    <?php } ?> 
                  </td>
                  <td style="text-align: center;"><?= !empty($product_data['delivered_order_sum']) ? $product_data['delivered_order_sum'] : ''; ?>&nbsp;
                
                  </td>
                  <td style="text-align: center;"><?= !empty($product_data['rto_order_count']) ? $product_data['rto_order_count'] : ''; ?>&nbsp;&nbsp;&nbsp;
                    <?php if($rto_percentage > 20){ ?>
                    <span class="text-danger"><i class="fe fe-arrow-down"></i><?= $rto_percentage; ?>%</span>
                    <?php }else{ ?>
                    <span class="text-success fs-15"><i class="fe fe-arrow-up"></i><?= $rto_percentage; ?>%</span>
                    <?php } ?> 
                  </td>
                </tr>
             <?php } } ?>    
              </tbody>
            </table>





            
          </div>
        </div><!-- card -->
      </div>
    </div>


    <br> 

  
    <!-- row opened -->
    <div class="row row-sm">
      <div class="col-md-12">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive border-top userlist-table">
                        <br>
                        <br>
            <?= GridView::widget([
                'dataProvider' => $dataProvider,
                
                'columns' => [
                    // ['class' => 'yii\grid\SerialColumn'],

                    [
                       'label' => 'T-Assign',
                       'format' => 'raw',
                       'attribute' =>'total_assign',
                       'value' => function ($model) {
                            return $model['total_assign'];  
                       }
                    ],
                    [
                       'label' => 'CallBack',
                       'format' => 'raw',
                       'attribute' =>'callback_req_count',
                       'value' => function ($model) {
                            return $model['callback_req_count'];  
                       }
                    ],
                    [
                       'label' => 'N.Connect',
                       'format' => 'raw',
                       'attribute' =>'not_connected_count',
                       'value' => function ($model) {
                            return $model['not_connected_count'];  
                       }
                    ],
                    [
                       'label' => 'N.I.',
                       'format' => 'raw',
                       'attribute' =>'not_intrested_count',
                       'value' => function ($model) {
                            return $model['not_intrested_count'];  
                       }
                    ],
                    [
                       'label' => 'Duplicate',
                       'format' => 'raw',
                       'attribute' =>'duplicate_count',
                       'value' => function ($model) {
                            return $model['duplicate_count'];  
                       }
                    ],

                    [
                       'label' => 'Fake',
                       'format' => 'raw',
                       'attribute' =>'fake_order_count',
                       'value' => function ($model) {
                            return $model['fake_order_count'];  
                       }
                    ],

                    [
                       'label' => 'NotService',
                       'format' => 'raw',
                       'attribute' =>'area_not_ser_count',
                       'value' => function ($model) {
                            return $model['area_not_ser_count'];  
                       }
                    ],
                    [
                       'label' => 'C.Discnnect',
                       'format' => 'raw',
                       'attribute' =>'call_disconnected_count',
                       'value' => function ($model) {
                            return $model['call_disconnected_count'];  
                       }
                    ],
                    [
                       'label' => 'Medical',
                       'format' => 'raw',
                       'attribute' =>'medical_condition_count',
                       'value' => function ($model) {
                            return $model['medical_condition_count'];  
                       }
                    ],
                    [
                       'label' => 'Language',
                       'format' => 'raw',
                       'attribute' =>'language_arrier',
                       'value' => function ($model) {
                            return $model['language_arrier'];  
                       }
                    ],
                    [
                       'label' => 'Promise Order',
                       'format' => 'raw',
                       'attribute' =>'promise_To_order_count',
                       'value' => function ($model) {
                            return $model['promise_To_order_count'];  
                       }
                    ],
                    [
                       'label' => 'Order Placed',
                       'format' => 'raw',
                       'attribute' =>'order_placed_count',
                       'value' => function ($model) {
                            return $model['order_placed_count'];  
                       }
                    ],
                ],
            ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <!--/div-->
      </div>
    </div>
    <div class="row row-sm">
      <div class="col-md-12">
      <div class="breadcrumb-header justify-content-between">
          <div class="my-auto">
              <div class="d-flex">
                  <h4 class="content-title mb-0 my-auto">Raise Request</h4>
              </div>
          </div>
      </div>
      </div>
    </div>
    <div class="row row-sm">
      <div class="col-md-12">
        <div class="col-xl-8 col-md-8">
          <?php $form = ActiveForm::begin(); ?>
            <div class="col-md-12">
              <?= $form->field($model2, 'it_easy_raise_comment')->textArea(['rows' => 9, 'placeholder' => 'Enter Your Request here'])->label(false); ?>
            </div>
            <div class="col-md-12">
              <?= Html::submitButton('SUMBIT', ['class' => 'btn btn-secondary btn-block']) ?>
            </div>
            <?php ActiveForm::end(); ?>
        </div>
        <div class="col-xl-4 col-md-4">
          <div class="card text-center" style="background-color: #ecf0fa !important; ">
              <div class="card-body " style="border: 2px solid #3E3E6E;border-radius: 11px;padding: 45px 0px;width: 80%;">
                <div class="feature widget-2 text-center mt-0 mb-3">
                  <i class="fa fa-clipboard" style="font-size: 100px; color: #3E3E6E;"></i>
                </div>
                <h6 class="mb-1 text-muted" style=" color: #3E3E6E !important;font-size: 20px; font-weight: 900;">Check Request Log</h6>
              </div>
            </div>
        </div>

    </div>
    </div>
      <br>
      <br>


      <div class="row row-sm">
        <div class="col-md-12">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive border-top userlist-table">
                        <br>
                        <br>
            <?= GridView::widget([
                'dataProvider' => $dataProvider2,
                // 'filterModel' => $searchModel,
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],

                    [
                       'label' => 'UserName',
                       'format' => 'raw',
                       'attribute' =>'it_easy_user_id',
                      
                       'value' => function ($model) {
                            $get_agent_tl_name = ItEasyOrder::getTLandAgentName($model->it_easy_user_id, '0');
                            return $get_agent_tl_name;
                            
                       }
                    ],
                    [
                       'label' => 'Raise-Request',
                       'format' => 'raw',
                       'attribute' =>'it_easy_raise_comment',
                       'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                       'value' => function ($model) {
                            
                            return $model->it_easy_raise_comment;
                            
                       }
                    ],

                    [
                       'label' => 'Solve-Comment',
                       'format' => 'raw',
                       'attribute' =>'it_easy_solve_comment',
                       'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                       'value' => function ($model) {
                            
                            return $model->it_easy_solve_comment;
                            
                       }
                    ],

                    [
                       'label' => 'Solve-Comment',
                       'format' => 'raw',
                       'attribute' =>'it_easy_status',
                       'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                       'value' => function ($model) {
                            
                            return $model->it_easy_status;
                            
                       }
                    ],

                    
                    [
                        'label' => 'Satisfied-Status',
                        'format' => 'raw',
                        'attribute' => 'it_easy_satisfied',
                        'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                        'value' => function ($model) {

                            if($model->it_easy_satisfied == '0'){
                                return "No";
                            }else{
                                return "Yes";
                            }
                        }
                    ],

                    [
                       'label' => 'Created',
                       'format' => 'raw',
                       'attribute' =>'it_easy_created_time',
                       'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                       'value' => function ($model) {
                            
                            return $model->it_easy_created_time;
                            
                       }
                    ],

                    [
                       'label' => 'Updated',
                       'format' => 'raw',
                       'attribute' =>'it_easy_updated_time',
                       'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                       'value' => function ($model) {
                            
                            return $model->it_easy_updated_time;
                            
                       }
                    ],  
                ],
            ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <!--/div-->
      </div>
    </div>





</div>
