<?php

namespace backend\controllers;

use backend\models\ItEasyCoupon;
use backend\models\ItEasyCouponSearch;
use backend\models\Pincodecity;
use backend\models\ItEasyShippingPaymentMethod;
use backend\models\ItEasyCustomer;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use yii\filters\AccessControl;
use yii\db\Query;
use backend\models\ItEasyProduct;
use backend\models\ItEasyProductVariation;
use backend\models\ItEasyOrder;
use backend\models\ItEasyCouponHistory;
use backend\models\CallAwbService1;
use backend\models\ItEasyClickpostCourier;
use backend\models\ApiCall;


/**
 * CouponController implements the CRUD actions for ItEasyCoupon model.
 */
class AjaxController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }
    
    public function actionAssigncourierclickpost(){
        $api_call = new ApiCall();
        $shiping_id = Yii::$app->request->post()['api_id'];
        $order_id = Yii::$app->request->post()['order_id'];
        $click_post_courier = ItEasyClickpostCourier::find()->where(['cp_id' => $shiping_id])->one();
        $get_order_data =  ItEasyOrder::find()->where(['it_easy_order_id' => $order_id])->asArray()->one();
        $get_value = [];
        
        $xb_value = $api_call->getClickpost($get_order_data,$shiping_id,$click_post_courier->account_name);
        $get_value[] = $xb_value;
        echo json_encode($get_value);
        exit();
    }
  
  
  	public function actionAssigncourier(){
        $api_call = new ApiCall();
        $shiping_id = Yii::$app->request->post()['api_id'];
        $order_id = Yii::$app->request->post()['order_id'];
        $get_order_data =  ItEasyOrder::find()->where(['it_easy_order_id' => $order_id])->asArray()->one();
        $get_value = [];
        // echo "<pre>"; print_r($shiping_id);
        
        // echo "<pre>"; print_r($get_order_data); die;
            
        switch($shiping_id) {
          case 1:   // Delhivery//   

          $delhivery = $api_call->getDelhiVery($get_order_data,$shiping_id);
          $get_value[] = $delhivery;
          break;
          case 2:   // EcomExpress//   

          $ecom = $api_call->getEcomExpress($get_order_data,$shiping_id);
          $get_value[] = $ecom;   
          break;

          case 6:   // EcomExpress AIR//   

          $ecom = $api_call->getEcomExpressair($get_order_data,$shiping_id);
          $get_value[] = $ecom;   
          break;

          case 3:   // Xpressbees//    

          $xb_value = $api_call->getXpressbees($get_order_data,$shiping_id);
          $get_value[] = $xb_value;

          break;

          case 4:   // shipdelight//    

          $xb_value = $api_call->getShipdelight($get_order_data,$shiping_id);
          $get_value[] = $xb_value;

          break; 
          
          case 7:   // smartship// 
            // echo "<pre>";print_r($shiping_id);die;
            $post = array('username' =>'finance@heebs.com', 'password'=>'f6de7bf592c7074d7b4e6503c07ff64c','client_id' =>'WIU7XKIS4H7W7322KBLGS','client_secret'=>'8OUX4%0I85Y24H6$T6OS^' , 'grant_type' =>'password');
            $json = json_encode($post);
            $url = 'http://oauth.smartship.in/loginToken.php';
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
            $curl_exicute = curl_exec($ch);  
          
            $decodedata = json_decode($curl_exicute, true);
          
            curl_close($ch);          
           // $token = '4c748c367699c5f8b99f0c8ab28ca560da07b02b';
            $smartship_value = $api_call->getSmartship($get_order_data,$shiping_id,$decodedata['access_token']);
            // $xb_value = $api_call->getSmartship($value,$shiping_id,$token);
            $get_value[] = $smartship_value;
                    
            break;
            
            case 8:   // BLuedart //   
                
                        $url = "https://apigateway.bluedart.com/in/transportation/token/v1/login";

                        $curl = curl_init($url);
                        curl_setopt($curl, CURLOPT_URL, $url);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                        
                        $headers = array(
                           "ClientID: IIbLPYByHXhToj3qetfR7b7jRxgB59kM",
                           "clientSecret: YbL9nwZZaRzLdQMk",
                        );
                        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                        $resp = curl_exec($curl);
                        $result = json_decode($resp);
                        // echo "<pre>"; print_r($result); die;
                        $access_token = $result->JWTToken;
                        $awbcall = new CallAwbService1();
                        $bluedart = $awbcall->getCallAwbService($get_order_data,$shiping_id, $access_token);
                        $get_value[] = $bluedart;   
                break;
            
            case 9:   // smartr// 
                             
                    
                    $url = "https://api.smartr.in/api/v1/get-token/";

                    $curl = curl_init($url);
                    curl_setopt($curl, CURLOPT_URL, $url);
                    curl_setopt($curl, CURLOPT_POST, true);
                    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                    
                    $headers = array(
                       "Content-Type: application/json",
                    );
                    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                    
                    $data['username'] = "DELNUTRI001";
                    $data['password'] = "8VkKDIgaZizXfAQYxgM";
                    
                    curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
                    
                    $resp = curl_exec($curl);
                    $result = json_decode($resp);
                    
                    curl_close($curl);
                    $token = $result->data->access_token;
                    
                    
                    $xb_value = $api_call->getSmartr($get_order_data,$shiping_id,$token);
                    
                    $get_value[] = $xb_value;
                    
            break;
            
            case 10:   // shipdelight//    
                  
                        $xb_value = $api_call->getIthink($get_order_data,$shiping_id);
                        $get_value[] = $xb_value;
                        
                break; 
                
                
                case 11:   // Rapidsyp//    
                  
                        $xb_value = $api_call->getRapidsyp($get_order_data,$shiping_id);
                        $get_value[] = $xb_value;
                        
                break; 
                
                
                
                case 12:   // shiprocket// 
                        $url = "https://apiv2.shiprocket.in/v1/external/auth/login";

                        $curl = curl_init($url);
                        curl_setopt($curl, CURLOPT_URL, $url);
                        curl_setopt($curl, CURLOPT_POST, true);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                        
                        $headers = array(
                           "Content-Type: application/json",
                        );
                        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                        
                        $data['email'] = "head@moneybhaiyaa.com";
                        $data['password'] = "OzEb8^0o&@i4Y&1S";
                        
                        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
                        
                        
                        $resp = curl_exec($curl);
                        $decodedata = json_decode($resp, true);
                        // echo "<pre>"; print_r($decodedata); die;
                        curl_close($curl);          
                       // $token = '4c748c367699c5f8b99f0c8ab28ca560da07b02b';
                        $xb_value = $api_call->getShiprocket($get_order_data,$shiping_id,$decodedata['token']);
                        // $xb_value = $api_call->getSmartship($value,$shiping_id,$token);
                        $get_value[] = $xb_value;
                        
                break;
                
                
                case 13:   // pickndel// 
                
                        $url = "https://www.bsaapps.co.in/backoffice/api/account/login";
                        $data = [];
                        $data['Control']['RequestId'] = Yii::$app->security->generateRandomString(32);
                        $data['Control']['Source'] = 3;
                        $data['Control']['RequestTime'] = time();
                        $data['Control']['Version'] = "1.3";
                        $data['Control']['Username'] = "nutriherbs";
                        $data['Control']['Password'] = "Pikndel@123";
                        $data['Control']['GrantType'] = "password";
                        $curl = curl_init($url);
                        curl_setopt($curl, CURLOPT_URL, $url);
                        curl_setopt($curl, CURLOPT_POST, true);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                        
                        $headers = array(
                           "Content-Type: application/json",
                        );
                        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                        
                    
                        
                        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
                        
                        
                        $resp = curl_exec($curl);    
            
                        $decodedata = json_decode($resp, true);
                      
                        curl_close($ch);          
                       // $token = '4c748c367699c5f8b99f0c8ab28ca560da07b02b';
                        $xb_value = $api_call->getPickndel($get_order_data,$shiping_id,$decodedata['Data']['Token']);
                        // $xb_value = $api_call->getSmartship($value,$shiping_id,$token);
                        $get_value[] = $xb_value;
                        
                break;
                
                case 14:   // Professional//    
                        //echo "<pre>"; print_r($value); die;
                        $xb_value = $api_call->getProfessional($get_order_data,$shiping_id);
                        $get_value[] = $xb_value;
                        
                break;
                
                
                case 15:   // Blitz// 
                
                        $url = "https://oyvm2iv4xj.execute-api.ap-south-1.amazonaws.com/v1/auth";
                        $data = [];
                        $data['request_type'] = "authenticate";
                        // $data['payload']['username'] = "NRy1JI7hD7Mf";
                        $data['payload']['username'] = "ekUUKKzJr0Rj";
                        $data['payload']['password'] = "0rGKZnZl*5~Zn";
                            
                        
                        //$data['payload']['password'] = "L0{we2N-|7]Zg";
                        $curl = curl_init($url);
                        curl_setopt($curl, CURLOPT_URL, $url);
                        curl_setopt($curl, CURLOPT_POST, true);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                        
                        $headers = array(
                           "Content-Type: application/json",
                        );
                        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                        
                    
                        
                        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
                        
                        
                        $resp = curl_exec($curl);    
            
                        $decodedata = json_decode($resp, true);
                        // echo "<pre>"; print_r($decodedata); die;
                        curl_close($curl);          
                       // $token = '4c748c367699c5f8b99f0c8ab28ca560da07b02b';
                        $xb_value = $api_call->getBlitz($get_order_data,$shiping_id,$decodedata['id_token']);
                        // $xb_value = $api_call->getSmartship($value,$shiping_id,$token);
                        $get_value[] = $xb_value;
                        
                break;
                
                case 16:   // DTDC//    
                  
                        $xb_value = $api_call->getDtdc($get_order_data,$shiping_id);
                        $get_value[] = $xb_value;
                        
                break; 
                
                case 17:   // Prozo//    
                
                        $curl = curl_init();

                        curl_setopt_array($curl, array(
                          CURLOPT_URL => 'https://proship.prozo.com/api/auth/signin',
                          CURLOPT_RETURNTRANSFER => true,
                          CURLOPT_ENCODING => '',
                          CURLOPT_MAXREDIRS => 10,
                          CURLOPT_TIMEOUT => 0,
                          CURLOPT_FOLLOWLOCATION => true,
                          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                          CURLOPT_CUSTOMREQUEST => 'POST',
                          CURLOPT_POSTFIELDS =>'{
                            "username":"sushil@nutriherbs.in",
                            "password":"Nutriherbs@123"
                        }',
                          CURLOPT_HTTPHEADER => array(
                            'Content-Type: application/json'
                          ),
                        ));
                        
                        $response = curl_exec($curl);
                        $decodedata = json_decode($response, true);
                        // echo "<pre>"; print_r($decodedata); die;
                        curl_close($curl);
                    
                        $xb_value = $api_call->getProzo($get_order_data,$shiping_id, $decodedata['accessToken']);
                        $get_value[] = $xb_value;
                        
                break;
                
                case 19:   // Quickshift//    
                  
                        $xb_value = $api_call->getQuickshift($get_order_data,$shiping_id);
                        $get_value[] = $xb_value;
                        
                break; 
                
                case 20:   // Ekart// 
                        $curl = curl_init();

                        curl_setopt_array($curl, array(
                          CURLOPT_URL => 'https://api.ekartlogistics.com/auth/token',
                          CURLOPT_RETURNTRANSFER => true,
                          CURLOPT_ENCODING => '',
                          CURLOPT_MAXREDIRS => 10,
                          CURLOPT_TIMEOUT => 0,
                          CURLOPT_FOLLOWLOCATION => true,
                          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                          CURLOPT_CUSTOMREQUEST => 'POST',
                          CURLOPT_HTTPHEADER => array(
                            'HTTP_X_MERCHANT_CODE: SKG',
                            'Authorization: Basic c2t5Z2FpbnNrZzprNm43NUozT0RKMGw4YUQ4',
                            'Content-Type: application/json'
                          ),
                        ));
                        
                        $response = curl_exec($curl);
                        
                        $decodedata = json_decode($response, true);
                      
                        curl_close($curl); 
                        $xb_value = $api_call->getEkart($get_order_data,$shiping_id,$decodedata['Authorization']);
                        $get_value[] = $xb_value;
                        
                break;
                
                
                case 21:   // Urbanbolt// 
                        $post_data['username'] = "UBC0119_TNEKxzElkv5N3Q_prod_api";
                        $post_data['password'] = "jkqaBooqp3ocBKxjw8rX3g";
                        $curl = curl_init();

                        curl_setopt_array($curl, array(
                          CURLOPT_URL => 'https://api.urbanebolt.in/api/v1/auth/getToken/',
                          CURLOPT_RETURNTRANSFER => true,
                          CURLOPT_ENCODING => '',
                          CURLOPT_MAXREDIRS => 10,
                          CURLOPT_TIMEOUT => 0,
                          CURLOPT_FOLLOWLOCATION => true,
                          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                          CURLOPT_CUSTOMREQUEST => 'POST',
                          CURLOPT_POSTFIELDS => json_encode($post_data),
                          CURLOPT_HTTPHEADER => array(
                            'Content-Type: application/json',
                            'Cookie: csrftoken=SuZfjeJQJQNlDaNxRJgaMqylRWlqogsL; csrftoken=xCmYoWZ7t4OOj3wekRymGL1fENoqklQj; sessionid=0j97z96157wx1po5saryvd5l9yo3a7ot; csrftoken=VOGH379uEECz8RnM2M6fRcUKDTyPT7m1; sessionid=h2e2tsro313lbp25lb306i3ryp62jyl1'
                          ),
                        ));
                        
                        $response = curl_exec($curl);
                        
                        $decodedata = json_decode($response, true);
                        //echo "<pre>"; print_r($decodedata); die;
                        curl_close($curl); 
                        $xb_value = $api_call->getUrbanbolt($get_order_data,$shiping_id,$decodedata['access_token']);
                        $get_value[] = $xb_value;
                        
                break;
                
                 case 22:   // Delhivery One//   

          $delhivery = $api_call->getDelhiVeryOne($get_order_data,$shiping_id);
          $get_value[] = $delhivery;
          break;
        
        
            
            
        }
              
        echo json_encode($get_value);
        exit();
    }
  
  
        public function actionOneAssigncourier(){
        $api_call = new ApiCall();

        $shiping_id = Yii::$app->request->post()['api_id'];
        $order_id = Yii::$app->request->post()['order_id'];
        $india_post_courier_awb = Yii::$app->request->post()['india_post_courier_awb'];

        $get_order_data =  ItEasyOrder::find()->where(['it_easy_order_id' => $order_id])->asArray()->one();
        // echo $shiping_id; die;
        // echo "<pre>"; print_r($get_order_data); die;
        $get_value = [];
        // $click_post_courier = ItEasyClickpostCourier::find()->where(['cp_id' => $shiping_id])->one();
        // $xb_value = $api_call->getClickpost($get_order_data,$shiping_id,$click_post_courier->account_name);
        // $get_value[] = $xb_value;
    
            
        switch($shiping_id) {
          case 1:   // Delhivery//   

          $delhivery = $api_call->getDelhiVery($get_order_data,$shiping_id);
          $get_value[] = $delhivery;
          break;
          case 2:   // EcomExpress//   

          $ecom = $api_call->getEcomExpress($get_order_data,$shiping_id);
          $get_value[] = $ecom;   
          break;

          case 6:   // EcomExpress AIR//   

          $ecom = $api_call->getEcomExpressair($get_order_data,$shiping_id);
          $get_value[] = $ecom;   
          break;

          case 3:   // Xpressbees//    

          $xb_value = $api_call->getXpressbees($get_order_data,$shiping_id);
          $get_value[] = $xb_value;

          break;

          case 4:   // shipdelight//    

          $xb_value = $api_call->getShipdelight($get_order_data,$shiping_id);
          $get_value[] = $xb_value;

          break; 
          
          case 7:   // smartship// 
            // echo "<pre>";print_r($shiping_id);die;
            $post = array('username' =>'finance@heebs.com', 'password'=>'f6de7bf592c7074d7b4e6503c07ff64c','client_id' =>'WIU7XKIS4H7W7322KBLGS','client_secret'=>'8OUX4%0I85Y24H6$T6OS^' , 'grant_type' =>'password');
            $json = json_encode($post);
            $url = 'http://oauth.smartship.in/loginToken.php';
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
            $curl_exicute = curl_exec($ch);  
          
            $decodedata = json_decode($curl_exicute, true);
          
            curl_close($ch);          
           // $token = '4c748c367699c5f8b99f0c8ab28ca560da07b02b';
            $smartship_value = $api_call->getSmartship($get_order_data,$shiping_id,$decodedata['access_token']);
            // $xb_value = $api_call->getSmartship($value,$shiping_id,$token);
            $get_value[] = $smartship_value;
                    
            break;
            
            case 8:   // BLuedart //   
                
                        $url = "https://apigateway.bluedart.com/in/transportation/token/v1/login";

                        $curl = curl_init($url);
                        curl_setopt($curl, CURLOPT_URL, $url);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                        
                        $headers = array(
                           "ClientID: IIbLPYByHXhToj3qetfR7b7jRxgB59kM",
                           "clientSecret: YbL9nwZZaRzLdQMk",
                        );
                        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                        $resp = curl_exec($curl);
                        $result = json_decode($resp);
                        //echo "<pre>"; print_r($result); die;
                        $access_token = $result->JWTToken;
                        $awbcall = new CallAwbService1();
                        $bluedart = $awbcall->getCallAwbService($get_order_data,$shiping_id, $access_token);
                        $get_value[] = $bluedart;   
                break;
            
            case 9:   // smartr// 
                             
                    
                    $url = "https://api.smartr.in/api/v1/get-token/";

                    $curl = curl_init($url);
                    curl_setopt($curl, CURLOPT_URL, $url);
                    curl_setopt($curl, CURLOPT_POST, true);
                    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                    
                    $headers = array(
                       "Content-Type: application/json",
                    );
                    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                    
                    $data['username'] = "DELNUTRI001";
                    $data['password'] = "8VkKDIgaZizXfAQYxgM";
                    
                    curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
                    
                    $resp = curl_exec($curl);
                    $result = json_decode($resp);
                    
                    curl_close($curl);
                    $token = $result->data->access_token;
                    
                    
                    $xb_value = $api_call->getSmartr($get_order_data,$shiping_id,$token);
                    
                    $get_value[] = $xb_value;
                    
            break;
            
            case 10:   // shipdelight//    
                  
                        $xb_value = $api_call->getIthink($get_order_data,$shiping_id);
                        $get_value[] = $xb_value;
                        
                break; 
                
                
                case 11:   // Rapidsyp//    
                  
                        $xb_value = $api_call->getRapidsyp($get_order_data,$shiping_id);
                        $get_value[] = $xb_value;
                        
                break; 
                
                
                
                case 12:   // shiprocket// 
                        $url = "https://apiv2.shiprocket.in/v1/external/auth/login";

                        $curl = curl_init($url);
                        curl_setopt($curl, CURLOPT_URL, $url);
                        curl_setopt($curl, CURLOPT_POST, true);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                        
                        $headers = array(
                           "Content-Type: application/json",
                        );
                        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                        
                        $data['email'] = "head@moneybhaiyaa.com";
                        $data['password'] = "OzEb8^0o&@i4Y&1S";
                        
                        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
                        
                        
                        $resp = curl_exec($curl);
                        $decodedata = json_decode($resp, true);
                        // echo "<pre>"; print_r($decodedata); die;
                        curl_close($curl);          
                       // $token = '4c748c367699c5f8b99f0c8ab28ca560da07b02b';
                        $xb_value = $api_call->getShiprocket($get_order_data,$shiping_id,$decodedata['token']);
                        // $xb_value = $api_call->getSmartship($value,$shiping_id,$token);
                        $get_value[] = $xb_value;
                        
                break;
                
                
                case 13:   // pickndel// 
                
                        $url = "https://www.bsaapps.co.in/backoffice/api/account/login";
                        $data = [];
                        $data['Control']['RequestId'] = Yii::$app->security->generateRandomString(32);
                        $data['Control']['Source'] = 3;
                        $data['Control']['RequestTime'] = time();
                        $data['Control']['Version'] = "1.3";
                        $data['Control']['Username'] = "nutriherbs";
                        $data['Control']['Password'] = "Pikndel@123";
                        $data['Control']['GrantType'] = "password";
                        $curl = curl_init($url);
                        curl_setopt($curl, CURLOPT_URL, $url);
                        curl_setopt($curl, CURLOPT_POST, true);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                        
                        $headers = array(
                           "Content-Type: application/json",
                        );
                        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                        
                    
                        
                        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
                        
                        
                        $resp = curl_exec($curl);    
            
                        $decodedata = json_decode($resp, true);
                      
                        curl_close($ch);          
                       // $token = '4c748c367699c5f8b99f0c8ab28ca560da07b02b';
                        $xb_value = $api_call->getPickndel($get_order_data,$shiping_id,$decodedata['Data']['Token']);
                        // $xb_value = $api_call->getSmartship($value,$shiping_id,$token);
                        $get_value[] = $xb_value;
                        
                break;
                
                case 14:   // Professional//    
                        //echo "<pre>"; print_r($value); die;
                        $xb_value = $api_call->getProfessional($get_order_data,$shiping_id);
                        $get_value[] = $xb_value;
                        
                break;
                
                
                case 15:   // Blitz// 
                
                        $url = "https://oyvm2iv4xj.execute-api.ap-south-1.amazonaws.com/v1/auth";
                        $data = [];
                        $data['request_type'] = "authenticate";
                        // $data['payload']['username'] = "NRy1JI7hD7Mf";
                        $data['payload']['username'] = "ekUUKKzJr0Rj";
                        $data['payload']['password'] = "0rGKZnZl*5~Zn";
                            
                        
                        //$data['payload']['password'] = "L0{we2N-|7]Zg";
                        $curl = curl_init($url);
                        curl_setopt($curl, CURLOPT_URL, $url);
                        curl_setopt($curl, CURLOPT_POST, true);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                        
                        $headers = array(
                           "Content-Type: application/json",
                        );
                        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                        
                    
                        
                        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
                        
                        
                        $resp = curl_exec($curl);    
            
                        $decodedata = json_decode($resp, true);
                        // echo "<pre>"; print_r($decodedata); die;
                        curl_close($curl);          
                       // $token = '4c748c367699c5f8b99f0c8ab28ca560da07b02b';
                        $xb_value = $api_call->getBlitz($get_order_data,$shiping_id,$decodedata['id_token']);
                        // $xb_value = $api_call->getSmartship($value,$shiping_id,$token);
                        $get_value[] = $xb_value;
                        
                break;
                
                case 16:   // DTDC//    
                  
                        $xb_value = $api_call->getDtdc($get_order_data,$shiping_id);
                        $get_value[] = $xb_value;
                        
                break; 
                
                case 17:   // Prozo//    
                
                        $curl = curl_init();

                        curl_setopt_array($curl, array(
                          CURLOPT_URL => 'https://proship.prozo.com/api/auth/signin',
                          CURLOPT_RETURNTRANSFER => true,
                          CURLOPT_ENCODING => '',
                          CURLOPT_MAXREDIRS => 10,
                          CURLOPT_TIMEOUT => 0,
                          CURLOPT_FOLLOWLOCATION => true,
                          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                          CURLOPT_CUSTOMREQUEST => 'POST',
                          CURLOPT_POSTFIELDS =>'{
                            "username":"sushil@nutriherbs.in",
                            "password":"Nutriherbs@123"
                        }',
                          CURLOPT_HTTPHEADER => array(
                            'Content-Type: application/json'
                          ),
                        ));
                        
                        $response = curl_exec($curl);
                        $decodedata = json_decode($response, true);
                        // echo "<pre>"; print_r($decodedata); die;
                        curl_close($curl);
                    
                        $xb_value = $api_call->getProzo($get_order_data,$shiping_id, $decodedata['accessToken']);
                        $get_value[] = $xb_value;
                        
                break;
                
                case 19:   // Quickshift//    
                  
                        $xb_value = $api_call->getQuickshift($get_order_data,$shiping_id);
                        $get_value[] = $xb_value;
                        
                break; 
                
                case 20:   // Ekart// 
                        $curl = curl_init();

                        curl_setopt_array($curl, array(
                          CURLOPT_URL => 'https://api.ekartlogistics.com/auth/token',
                          CURLOPT_RETURNTRANSFER => true,
                          CURLOPT_ENCODING => '',
                          CURLOPT_MAXREDIRS => 10,
                          CURLOPT_TIMEOUT => 0,
                          CURLOPT_FOLLOWLOCATION => true,
                          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                          CURLOPT_CUSTOMREQUEST => 'POST',
                          CURLOPT_HTTPHEADER => array(
                            'HTTP_X_MERCHANT_CODE: SKG',
                            'Authorization: Basic c2t5Z2FpbnNrZzprNm43NUozT0RKMGw4YUQ4',
                            'Content-Type: application/json'
                          ),
                        ));
                        
                        $response = curl_exec($curl);
                        
                        $decodedata = json_decode($response, true);
                      
                        curl_close($curl); 
                        $xb_value = $api_call->getEkart($get_order_data,$shiping_id,$decodedata['Authorization']);
                        $get_value[] = $xb_value;
                        
                break;
                
                
                case 21:   // Urbanbolt// 
                        $post_data['username'] = "UBC0119_TNEKxzElkv5N3Q_prod_api";
                        $post_data['password'] = "jkqaBooqp3ocBKxjw8rX3g";
                        $curl = curl_init();

                        curl_setopt_array($curl, array(
                          CURLOPT_URL => 'https://api.urbanebolt.in/api/v1/auth/getToken/',
                          CURLOPT_RETURNTRANSFER => true,
                          CURLOPT_ENCODING => '',
                          CURLOPT_MAXREDIRS => 10,
                          CURLOPT_TIMEOUT => 0,
                          CURLOPT_FOLLOWLOCATION => true,
                          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                          CURLOPT_CUSTOMREQUEST => 'POST',
                          CURLOPT_POSTFIELDS => json_encode($post_data),
                          CURLOPT_HTTPHEADER => array(
                            'Content-Type: application/json',
                            'Cookie: csrftoken=SuZfjeJQJQNlDaNxRJgaMqylRWlqogsL; csrftoken=xCmYoWZ7t4OOj3wekRymGL1fENoqklQj; sessionid=0j97z96157wx1po5saryvd5l9yo3a7ot; csrftoken=VOGH379uEECz8RnM2M6fRcUKDTyPT7m1; sessionid=h2e2tsro313lbp25lb306i3ryp62jyl1'
                          ),
                        ));
                        
                        $response = curl_exec($curl);
                        
                        $decodedata = json_decode($response, true);
                        //echo "<pre>"; print_r($decodedata); die;
                        curl_close($curl); 
                        $xb_value = $api_call->getUrbanbolt($get_order_data,$shiping_id,$decodedata['access_token']);
                        $get_value[] = $xb_value;
                        
                break;
          
        }

        if($get_value[0]['responce'] == 'success'){
        Yii::$app->session->setFlash('success', "Assigned successfully"); 
        if(Yii::$app->request->post()['identitiy'] == 'assignawbmani'){ 
        Yii::$app->response->redirect(['order-dispatch/manifest']);
        }else{
            Yii::$app->response->redirect(['order-dispatch/assign']);
        }
        }else{
        Yii::$app->session->setFlash('error', "Not Assigned"); 
        if(Yii::$app->request->post()['identitiy'] == 'assignawbmani'){ 
        Yii::$app->response->redirect(['order-dispatch/manifest']);
        }else{
            Yii::$app->response->redirect(['order-dispatch/assign']);
        }
        }
    }
    
    public function actionGetcity(){
        $get = Yii::$app->request->get();
        $get_value = $get['pincode'];
        
        if(!empty($get_value)){
            
            $get_pincode =  Pincodecity::find()->where(['pincode' => $get_value])->asArray()->one();
            if(empty($get_pincode)){
                $get_pincode = '';
            }else{
                $get_pincode = json_encode($get_pincode);
            }
            $courier_id = ItEasyOrder::getServicealAPIbyPincode($get_value);
            
            $get_serviceable_name = ItEasyOrder::GetServiceableCourierName($courier_id);
            $str_serviceable = '';
            if(!empty($get_serviceable_name)){
                $count_serviceable = count($get_serviceable_name);
                $check_serviceable = $count_serviceable - 1; 
                foreach ($get_serviceable_name as $key => $service){
                    $c_key =  $key +1;
                    if($key == $check_serviceable){
                        $str_serviceable .= $c_key.'. '.$service->it_easy_name;
                    }else{
                        $str_serviceable .= $c_key.'. '.$service->it_easy_name.' &nbsp;&nbsp;&nbsp;';
                    }
                }
            }else if(empty($str_serviceable)){
                $str_serviceable = "❌  Couriers Service not available for this location.";
            }
        
            return $get_pincode.'####'.$str_serviceable;
            die;
        }
    }

    public function actionCustomer()
    {   
        
        $get = Yii::$app->request->post();
        $get_value = $get['input'];
        if(strlen($get_value) > 1){
            $getcustomer_data = ItEasyCustomer::find()->select(['it_easy_customer_id', 'it_easy_firstname', 'it_easy_lastname', 'it_easy_mobile_number'])
                                ->andWhere(['<>', 'it_easy_status', 'Blocked'])
                                ->andWhere(['or', ['like', 'it_easy_firstname', $get_value], ['like', 'it_easy_mobile_number', $get_value] ])->limit(10)
                                ->asArray()->all();

            // echo "<pre>";  print_r($getcustomer_data); die;                    
            if(!empty($getcustomer_data)){
                $str = '';
                $str .= '<ul class="tiny-add-customer" onchange="javascript:handleSelect(this)">';
                $str .= '<li class="add_ul_li menu-item add_customer_popup" data-value="0" data-target="#scrollmodal" data-toggle="modal" id="add_customer_popup"><i class="icon ion-md-add-circle"></i> Add customer</li>';
                foreach ($getcustomer_data as $key => $value) {
                    $str .= '<li class="menu-item add_customer_popup" data-target="#scrollmodal" data-value="'.$value['it_easy_customer_id'].'" data-toggle="modal" id="'.$value['it_easy_customer_id'].'">'.$value['it_easy_firstname'].' '.$value['it_easy_lastname'].' '.$value['it_easy_mobile_number'].'</li>';
                }
                $str .= '</ul>';

                echo $str;
                die;
            }else{
                $str = '';
                $str .= '<ul class="tiny-add-customer" onchange="javascript:handleSelect(this)">';
                $str .= '<li class="add_ul_li menu-item add_customer_popup" data-value="0" data-target="#scrollmodal" data-toggle="modal" id="add_customer_popup"><i class="icon ion-md-add-circle"></i> Add customer</li>';
                $str .= '</ul>';
                echo $str;
                die;
            }
        }else{
            $str = '';
            $str .= '<ul class="tiny-add-customer" onchange="javascript:handleSelect(this)">';
            $str .= '<li class="add_ul_li menu-item add_customer_popup" data-value="0" data-target="#scrollmodal" data-toggle="modal" id="add_customer_popup"><i class="icon ion-md-add-circle"></i> Add customer</li>';
            $str .= '</ul>';
            echo $str;
            die;
        }
    }


    
    public function actionGetpaymentcode()
    {
        $post = Yii::$app->request->post();
        $value = $post['value'];
        $getshipping_method = ItEasyShippingPaymentMethod::find()->select(['it_easy_method_value_type', 'it_easy_add_value_type', 'it_easy_method_value'])->where(['it_easy_method_code' => $value])->asArray()->one();

        echo $getshipping_method['it_easy_method_value_type'].'###'.$getshipping_method['it_easy_add_value_type'].'###'.$getshipping_method['it_easy_method_value'];
        die;
    }

    public function actionGetcouponid()
    {
        $post = Yii::$app->request->post();
        // echo json_encode($post); die;
        $coupon_id = $post['coupon_id'];
        $order_id = $post['order_id'];
        
        
            
            $getshipping_method = ItEasyCoupon::find()->select(['it_easy_coupon_code', 'it_easy_coupon_type', 'it_easy_discount', 'it_easy_discount_type', 'it_easy_number', 'it_easy_start_date', 'it_easy_end_date', 'it_easy_status'])->where(['it_easy_id' => $coupon_id])->andWhere(['it_easy_status' => 'Active'])->asArray()->one();
        if(!empty($getshipping_method)){
            if(empty($getshipping_method['it_easy_start_date']) && empty($getshipping_method['it_easy_end_date']) && empty($getshipping_method['it_easy_number'])){
                $var = '1111';
            }else{
                if(!empty($getshipping_method['it_easy_number'])){
                    if(!empty($getshipping_method['it_easy_number']) && empty($getshipping_method['it_easy_end_date']) && empty($getshipping_method['it_easy_start_date'])){
                        $coupon_history = ItEasyCouponHistory::find()->select(['COUNT(`it_easy_id`) as total'])->where(['it_easy_coupon_id' => $coupon_id])->groupBy(['it_easy_coupon_id'])->asArray()->one();
                        if($getshipping_method['it_easy_number'] >= $coupon_history['total']){
                            $var = '1111';
                        }else{
                            $var = '9999';
                        }


                    }else if(!empty($getshipping_method['it_easy_number']) &&  !empty($getshipping_method['it_easy_end_date']) && empty($getshipping_method['it_easy_start_date'])){

                        if($getshipping_method['it_easy_end_date'] >= date('Y-m-d H:i:s')){
                            $coupon_history = ItEasyCouponHistory::find()->select(['COUNT(`it_easy_id`) as total'])->where(['it_easy_coupon_id' => $coupon_id])->andWhere(['<=', 'it_easy_created_time', $getshipping_method['it_easy_end_date'] ])->groupBy(['it_easy_coupon_id'])->asArray()->one();

                            if($getshipping_method['it_easy_number'] >= $coupon_history['total']){
                                $var = '1111';
                            }else{
                                $var = '9999';
                            }
                        }else{
                            $var = '9999';
                        }
                    }else if(!empty($getshipping_method['it_easy_number']) &&  empty($getshipping_method['it_easy_end_date']) && !empty($getshipping_method['it_easy_start_date'])){
                        if($getshipping_method['it_easy_start_date'] <= date('Y-m-d H:i:s')){
                            $coupon_history = ItEasyCouponHistory::find()->select(['COUNT(`it_easy_id`) as total'])->where(['it_easy_coupon_id' => $coupon_id])->andWhere(['>=', 'it_easy_created_time', $getshipping_method['it_easy_start_date'] ])->groupBy(['it_easy_coupon_id'])->asArray()->one();

                            if($getshipping_method['it_easy_number'] >= $coupon_history['total']){
                                $var = '1111';
                            }else{
                                $var = '9999';
                            }
                        }else{
                            $var = '9999';
                        }

                    }else if(!empty($getshipping_method['it_easy_number']) &&  !empty($getshipping_method['it_easy_end_date']) && !empty($getshipping_method['it_easy_start_date'])){
                        if($getshipping_method['it_easy_end_date'] >= date('Y-m-d H:i:s') && $getshipping_method['it_easy_start_date'] <= date('Y-m-d H:i:s')){
                            $coupon_history = ItEasyCouponHistory::find()->select(['COUNT(`it_easy_id`) as total'])->where(['it_easy_coupon_id' => $coupon_id])->andWhere(['>=', 'it_easy_created_time', $getshipping_method['it_easy_start_date'] ])->andWhere(['<=', 'it_easy_created_time', $getshipping_method['it_easy_end_date'] ])->asArray()->one();

                            if($getshipping_method['it_easy_number'] >= $coupon_history['total']){
                                $var = '1111';
                            }else{
                                $var = '9999';
                            }
                        }else{
                            $var = '9999';
                        }
                    }

                }else{
                    if(!empty($getshipping_method['it_easy_start_date']) && empty($getshipping_method['it_easy_end_date'])){
                        if($getshipping_method['it_easy_start_date'] <= date('Y-m-d H:i:s')){
                            $var = '1111';
                        }else{
                            $var = '9999';
                        }
                    }else if(empty($getshipping_method['it_easy_start_date']) && !empty($getshipping_method['it_easy_end_date'])){
                        if($getshipping_method['it_easy_end_date'] >= date('Y-m-d H:i:s')){
                            $var = '1111';
                        }else{
                            $var = '9999';
                        }
                    }else if(!empty($getshipping_method['it_easy_start_date']) && !empty($getshipping_method['it_easy_end_date'])){
                        if($getshipping_method['it_easy_end_date'] >= date('Y-m-d H:i:s') && $getshipping_method['it_easy_start_date'] <= date('Y-m-d H:i:s')){
                            $var = '1111';
                        }else{
                            $var = '9999';
                        }
                    }
                }    

            }
        }else{
            $var = '9999';
        }
        $coupon_history2 = ItEasyCouponHistory::find()->andWhere(['it_easy_order_id' => $order_id])->asArray()->one();
        
        // echo json_encode($coupon_history2); die;
        if(!empty($coupon_history2)){
            $old_value = $coupon_history2['it_easy_coupon_discount'];
        }else{
            $old_value = 0;
        }

        echo $var.'###'.$getshipping_method['it_easy_discount'].'###'.$getshipping_method['it_easy_coupon_code'].'###'.$getshipping_method['it_easy_coupon_type'].'###'.$old_value;
        die;
    }


    
    public function actionGetcustomer()
    {
            $post = Yii::$app->request->post();
            // echo json_encode($post); die;
            $get_value = $post['customer_id'];
            $customer_data = ItEasyCustomer::find()->select(['it_easy_customer_id', 'it_easy_firstname', 'it_easy_lastname', 'it_easy_mobile_number', 'it_easy_alternative_mobile','it_easy_email', 'it_easy_address_1', 'it_easy_address_2', 'it_easy_city', 'it_easy_state_id', 'it_easy_pincode'])->andWhere(['it_easy_customer_id' => $get_value ])
                ->asArray()->one();
           // echo $customer_data = ItEasyCustomer::find()->select(['it_easy_customer_id', 'it_easy_firstname', 'it_easy_lastname', 'it_easy_mobile_number', 'it_easy_alternative_mobile','it_easy_email', 'it_easy_address_1', 'it_easy_address_2', 'it_easy_city', 'it_easy_state_id', 'it_easy_pincode'])->andWhere(['it_easy_customer_id' => $get_value ])->createCommand()->rawSql; die;

            echo json_encode($customer_data); die;
    }


    public function actionGetproductname()
    {
            $post = Yii::$app->request->post();
            
            $product_id = $post['product_id'];
            $variation_id = $post['variation_id'];
            $product_variation_data = ItEasyProductVariation::find()->select(['it_easy_product_name', 'it_easy_variation_name', 'it_easy_product_id', 'it_easy_id', 'it_easy_variation_id', 'it_easy_varation_price', 'it_easy_tax_price', 'it_easy_product_tax', 'it_easy_price_without_tax', 'it_easy_varation_quantity', 'it_easy_product_stock_id', 'it_easy_status'])->andWhere(['it_easy_product_id' => $product_id, 'it_easy_variation_id' => $variation_id])->andWhere(['it_easy_status' => 'Active'])->asArray()->one();
            $product_data = ItEasyProduct::find()->select(['it_easy_product_id', 'it_easy_product_image', 'it_easy_product_name', 'it_easy_product_included_exclude_tax'])->where(['it_easy_product_id' => $product_id])->andWhere(['it_easy_product_status' => 'Active'])->one();
            // echo "<pre>"; print_r($product_variation_data); die;
            if(empty($product_data->it_easy_product_image)){
                    $product_data->it_easy_product_image = 'dummy_product.png';
            }

            if($product_data->it_easy_product_included_exclude_tax == 'include'){
                $product_total_price = $product_variation_data['it_easy_varation_price'];
            }else{
                $product_total_price = $product_variation_data['it_easy_tax_price'] + $product_variation_data['it_easy_price_without_tax'];
            }

            $arry_key = $post['trrowCount'];
            $ar_key = $post['trrowCount'] + 1;    

            $str = '<tr class="row_for_product_'.$arry_key.'" data-id="'.$ar_key.'"><td class="w-1"><img height="80" width="80" src="'.BASE_URL.'upload/'.$product_data->it_easy_product_image.'" alt="flags" class=""></td><td><h6>'.$product_data->it_easy_product_name.' ( '.$product_variation_data['it_easy_variation_name'].' )</h6><p>₹'.$product_variation_data['it_easy_varation_price'].'</p>
                                    <div class="progress progress-sm mt-1">
                                        <div class="progress-bar bg-primary wd-200"></div>
                                        
                                        <input type="hidden" name="ItEasyOrderProduct['.$arry_key.'][it_easy_id]" value="0" >
                                        <input type="hidden" name="ItEasyOrderProduct['.$arry_key.'][it_easy_product_id]" value="'.$product_variation_data['it_easy_product_id'].'" >
                                        <input type="hidden" name="ItEasyOrderProduct['.$arry_key.'][it_easy_variation_id]" value="'.$product_variation_data['it_easy_variation_id'].'" >
                                        
                                        <input type="hidden" name="ItEasyOrderProduct['.$arry_key.'][it_easy_product_total]" value="'.$product_variation_data['it_easy_varation_price'].'" >
                                        
                                    </div>
                                </td>
                                <td class="w-1 text-right"><input type="number" name="ItEasyOrderProduct['.$arry_key.'][it_easy_product_quantity]"  class="form-control quantity_row_product" id="quantity_row_product" data-id="'.$arry_key.'" data-value="'.$product_variation_data['it_easy_price_without_tax'].'$$$'.$product_variation_data['it_easy_tax_price'].'$$$'.$product_total_price.'" value="1" min="1" style="width: 60px;float: right;" ><span class="last_time_quantity_check_'.$arry_key.'" style="display:none;">1<span></td>
                                <td class="w-1 text-right"><b><span class="row_product_price_'.$arry_key.'" data-id="'.$arry_key.'" data-value="'.$product_variation_data['it_easy_varation_price'].'" style="font-size:16px;">₹'.$product_variation_data['it_easy_varation_price'].'</span></b></td>
                                <td class="w-1 text-right"><h4><i class="fa fa-times remove_tr_product" style="cursor:pointer;" data-id="'.$arry_key.'" data-value="'.$product_variation_data['it_easy_price_without_tax'].'$$$'.$product_variation_data['it_easy_tax_price'].'$$$'.$product_total_price.'"></i></h4></td>
                            </tr>';
            echo $str.'###'.$product_variation_data['it_easy_price_without_tax'].'###'.$product_variation_data['it_easy_tax_price'].'###'.$product_total_price; die;
    }


    public function actionGetstate($q = null, $id = null) {
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        $out = ['results' => ['id' => '', 'text' => '']];
        if (!is_null($q)) {
            $query = new Query;
            $query->select('it_easy_id as id, it_easy_state_name AS text')
                ->from('it_easy_state')
                ->where(['like', 'it_easy_state_name', $q])
                ->limit(20);
            $command = $query->createCommand();
            $data = $command->queryAll();
            $out['results'] = array_values($data);
        }
        elseif ($id > 0) {
            $out['results'] = ['id' => $id, 'text' => ItEasyState::find($id)->it_easy_state_name];
        }
        return $out;
    }


    public function actionGetproduct($q = null, $id = null) {
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        $out = ['results' => ['id' => '', 'text' => '']];
        if (!is_null($q)) {
            $query = new Query;
            $query->select('it_easy_product_id as id, it_easy_product_name AS text')
                ->from('it_easy_product')
                ->where(['like', 'it_easy_product_name', $q])
                ->andWhere(['it_easy_product_status' => 'Active'])
                ->limit(20);
            $command = $query->createCommand();
            $data = $command->queryAll();
            $out['results'] = array_values($data);
        }
        elseif ($id > 0) {
            $out['results'] = ['id' => $id, 'text' => ItEasyProduct::find($id)->it_easy_product_name];
        }
        return $out;
    }


    public function actionGetcoupon($q = null, $id = null) {
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        $out = ['results' => ['id' => '', 'text' => '']];
        if (!is_null($q)) {
            $query = new Query;
            $query->select('it_easy_id as id, it_easy_coupon_code AS text')
                ->from('it_easy_coupon')
                ->where(['like', 'it_easy_coupon_code', $q])
                ->limit(20);
            $command = $query->createCommand();
            $data = $command->queryAll();
            $out['results'] = array_values($data);
        }
        elseif ($id > 0) {
            $out['results'] = ['id' => $id, 'text' => ItEasyCoupon::find($id)->it_easy_coupon_code];
        }
        return $out;
    }

    


}
