<?php

namespace backend\controllers;

use Yii;
use backend\models\ItEasyApi;
use backend\models\ItEasyApiSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;

/**
 * ApiController implements the CRUD actions for ItEasyApi model .
 */
class ApiController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyApi models.
     *
     * @return string
     */
     
    public function actionEcompincode(){
        date_default_timezone_set("Asia/Kolkata");
        $create_date=date("Y-m-d H:i:s");
        
        $getawbstring = array('username' =>'SKYGAINNUTRICAREPRIVATELIMITED211975', 'password' =>'U3cpYr4Tvq3S');
        // echo "<pre>"; print_r($courier_link);
        // echo "<pre>"; print_r($getawbstring); die;
        $awb = curl_init();
        curl_setopt($awb, CURLOPT_URL, 'https://api.ecomexpress.in/apiv2/pincode/');
        curl_setopt($awb, CURLOPT_POST, true);
        curl_setopt($awb, CURLOPT_POSTFIELDS, $getawbstring);
        curl_setopt($awb, CURLOPT_RETURNTRANSFER, 1);
        $awbresponce = curl_exec($awb);  
        $getawbarray = json_decode($awbresponce, true);		
        // echo "<pre>"; print_r($getawbarray); die;			
        curl_close($awb);
        
        
        if(!empty($getawbarray)){      
            foreach($getawbarray as $pincode_array){
            	$pincode = $pincode_array['pincode'];
            	$state_code = $pincode_array['state_code'];
            	$city = $pincode_array['city'];
            	$dccode = $pincode_array['dccode'];
            	$route = $pincode_array['route'];
            	$state = $pincode_array['state'];
            	$city_code = $pincode_array['city_code'];
            	$active = $pincode_array['active'];
            	$status = $pincode_array['status'];
                $save_data[] = [$pincode, '1', '1',  $status, $active,  $dccode, $state, $route, $city, $city_code, $dccode, $state_code, '1', $create_date];
            }
            if(!empty($save_data)){
                Yii::$app->db->createCommand()->truncateTable('it_easy_ecom_pincodes')->execute();
                Yii::$app->db->createCommand()->batchInsert('it_easy_ecom_pincodes', ['it_easy_pincode', 'it_easy_cod', 'it_easy_prepaid', 'it_easy_status', 'active','it_easy_area', 'it_easy_state', 'it_easy_route', 'it_easy_city_code',  'it_easy_city_type', 'it_easy_dccode', 'it_easy_state_code', 'created_by', 'created_time'], $save_data)->execute();
            }
        }
    } 
     
    public function actionIndex()
    {
        $searchModel = new ItEasyApiSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }


    /**
     * Creates a new ItEasyApi model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new ItEasyApi();

           if ($this->request->isPost) {
            if ($model->load(Yii::$app->request->post())){
                 date_default_timezone_set("Asia/Kolkata");
                 $create_date=date("Y-m-d H:i:s");
                 $model->it_easy_created_time = $create_date; 
                 $model->it_easy_created_by = Yii::$app->user->identity->id;
                 
                 $model->save();
                 Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
                 return $this->redirect(['index']);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing ItEasyApi model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_id It Easy ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_id)
    {
        $model = $this->findModel($it_easy_id);

          if ($this->request->isPost) {
        if ($model->load(Yii::$app->request->post())){
            date_default_timezone_set("Asia/Kolkata");
            $create_date=date("Y-m-d H:i:s");
            $model->it_easy_updated_time = $create_date; 
            $model->it_easy_updated_by = Yii::$app->user->identity->id;
            $model->save();
            Yii::$app->session->setFlash('success', 'Your Data has been updated successfully.');
            return $this->redirect(['index']);
            }
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }



    /**
     * Finds the ItEasyApi model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_id It Easy ID
     * @return ItEasyApi the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_id)
    {
        if (($model = ItEasyApi::findOne(['it_easy_id' => $it_easy_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
