<?php

namespace backend\controllers;

use Yii;
use backend\models\ItEasyApiTemplate;
use backend\models\ItEasyApiTemplateSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;

/**
 * ApiTemplateController implements the CRUD actions for ItEasyApiTemplate model.
 */
class ApiTemplateController extends Controller
{
    /**
     * @inheritDoc
     */
     public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyApiTemplate models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyApiTemplateSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }


    /**
     * Creates a new ItEasyApiTemplate model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new ItEasyApiTemplate();

             if ($this->request->isPost) {
            if ($model->load(Yii::$app->request->post())){
                // echo "<pre>";print_r(Yii::$app->request->post());die;
                 date_default_timezone_set("Asia/Kolkata");
                 $create_date=date("Y-m-d H:i:s");
                 $model->it_easy_created_time = $create_date; 
                 $model->it_easy_created_by = Yii::$app->user->identity->id;
                 if(!empty(Yii::$app->request->post()['ItEasyApiTemplate']['it_easy_template_text_sms'])){
                 $model->it_easy_template_text = Yii::$app->request->post()['ItEasyApiTemplate']['it_easy_template_text_sms']; 
                }
                 $model->save(false);
                 Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
                 return $this->redirect(['index']);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing ItEasyApiTemplate model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_id It Easy ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_id)
    {
        $model = $this->findModel($it_easy_id);

                if ($this->request->isPost) {
        if ($model->load(Yii::$app->request->post())){
            date_default_timezone_set("Asia/Kolkata");
            $create_date=date("Y-m-d H:i:s");
            $model->it_easy_updated_time = $create_date; 
            $model->it_easy_updated_by = Yii::$app->user->identity->id;
             if(!empty(Yii::$app->request->post()['ItEasyApiTemplate']['it_easy_template_text_sms'])){
                 $model->it_easy_template_text = Yii::$app->request->post()['ItEasyApiTemplate']['it_easy_template_text_sms']; 
                }
            $model->save(false);
            Yii::$app->session->setFlash('success', 'Your Data has been updated successfully.');
            return $this->redirect(['index']);
            }
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Finds the ItEasyApiTemplate model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_id It Easy ID
     * @return ItEasyApiTemplate the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_id)
    {
        if (($model = ItEasyApiTemplate::findOne(['it_easy_id' => $it_easy_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
