<?php

namespace backend\controllers;

use Yii;
use backend\models\ItEasyBlitzPincodes;
use backend\models\ItEasyBlitzPincodesSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\filters\AccessControl;
use yii2tech\spreadsheet\Spreadsheet;
use yii\data\ArrayDataProvider;
/**
 * EcomPincodesController implements the CRUD actions for ItEasyBlitzPincodes model.
 */
class BlitzPincodesController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyBlitzPincodes models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyBlitzPincodesSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ItEasyBlitzPincodes model.
     * @param int $it_easy_id It Easy ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionExport()
    {
        $data = ItEasyBlitzPincodes::find()->asArray()->all();
        
        $exporter = new Spreadsheet([
                'dataProvider' => new ArrayDataProvider([
                    'allModels' => $data,
                ]),
                'columns' => [
                    [   'attribute' => 'it_easy_pincode'],
                    [   'attribute' => 'it_easy_city'],
                    [   'attribute' => 'it_easy_state'],
                    [   'attribute' => 'it_easy_cod'],
                  	[   'attribute' => 'it_easy_prepaid'],
                ],
            ]);
            return $exporter->send('BLITZ-pincode.xlsx');
    }

    /**
     * Creates a new ItEasyBlitzPincodes model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public $file;
    public function actionCreate()
    {
        $model = new ItEasyBlitzPincodes();

        if ($model->load(Yii::$app->request->post())) {
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');
            ItEasyBlitzPincodes::deleteAll();
            $model->file = UploadedFile::getInstance($model, 'file');

            if ($model->file) {
                $time = time();
                $model->file->saveAs('csv/' . $time . '.' . $model->file->extension);
                $model->file = 'csv/' . $time . '.' . $model->file->extension;
                $getdata = fopen($model->file, "r");
                $cnount = 0;
                while (($fileopen = fgetcsv($getdata, 1000, ",")) !== false) {
                    if ($cnount != 0) {
                        $model = new ItEasyBlitzPincodes();
                       
                        $model->it_easy_pincode = trim($fileopen[0]);
                        $model->it_easy_city = trim($fileopen[1]);
                        $model->it_easy_state = trim($fileopen[2]);
                        $model->it_easy_cod = trim($fileopen[4]);
                        $model->it_easy_prepaid = trim($fileopen[3]);
                        $model->created_by = Yii::$app->user->identity->id;
                      
                        $model->it_easy_date_added =$currentDateTime;
                        $model->save(false);
                    }
                    $cnount++;
                }
                return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
            }
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing ItEasyBlitzPincodes model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_id It Easy ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_id)
    {
        $model = $this->findModel($it_easy_id);

        if ($model->load(Yii::$app->request->post())) {
            $post = Yii::$app->request->post();
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');
            $time = time();
            $model->updated_by = Yii::$app->user->identity->id;
            $model->updated_time = $currentDateTime;
            
            $model->save(false);
            

            Yii::$app->session->setFlash('success', 'Form has been updated');
            return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing ItEasyBlitzPincodes model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $it_easy_id It Easy ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($it_easy_id)
    {
        $this->findModel($it_easy_id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the ItEasyBlitzPincodes model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_id It Easy ID
     * @return ItEasyBlitzPincodes the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_id)
    {
        if (($model = ItEasyBlitzPincodes::findOne(['it_easy_id' => $it_easy_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    public function actionBlitzPincodes()
{
    $model = new \backend\models\ItEasyBlitzPincodes();

    if ($model->load(Yii::$app->request->post())) {
        if ($model->validate()) {
            // form inputs are valid, do something here
            return;
        }
    }

    return $this->render('BlitzPincodes', [
        'model' => $model,
    ]);
}
}
