<?php

namespace backend\controllers;

use Yii;
use backend\models\ItEasyBuildHistory;
use backend\models\ItEasyBuildHistorySearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use backend\models\ItEasyBuildIngredient;
use yii\filters\AccessControl;
use backend\models\ItEasyProductMaterial;
use backend\models\ItEasyProductVariation;
use backend\models\ItEasyProduct;
/**
 * BuildHistoryController implements the CRUD actions for ItEasyBuildHistory model.
 */
class BuildHistoryController extends Controller
{
    /**
     * @inheritDoc
     */
     public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyBuildHistory models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyBuildHistorySearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Creates a new ItEasyBuildHistory model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new ItEasyBuildHistory();
        $model2 = new ItEasyBuildIngredient();
        if ($model->load(Yii::$app->request->post())){
                $post = Yii::$app->request->post();
                date_default_timezone_set('Asia/kolkata');
                $currentDateTime = date('Y-m-d H:i:s');
                $time = time();
                $model->created_by = Yii::$app->user->identity->id;
                $model->created_time = $currentDateTime;
                $model->save(false);

                $productid = $post['ItEasyBuildHistory']['it_easy_product_id'];
                $variation_id = $post['ItEasyBuildHistory']['it_easy_variation_id'];
                $quantity = $post['ItEasyBuildHistory']['it_easy_product_quantity'];

                $check_Product_quanity = ItEasyProduct::find()->where(['it_easy_product_id'=>$productid])->One();
                $check_variation_quanity = ItEasyProductVariation::find()->where(['it_easy_product_id'=>$productid])->andWhere(['it_easy_variation_id'=>$variation_id])->One();

                    /* For Variation Addition Code */
                        $add_variation = $quantity + $check_variation_quanity->it_easy_varation_quantity;
                        $check_variation_quanity->it_easy_varation_quantity = $add_variation;
                        if($check_variation_quanity->it_easy_varation_quantity == '0'){
                            $product_stock = 'out-of-stock';
                         }elseif ($check_variation_quanity->it_easy_varation_quantity < 26) {
                             $product_stock = 'low-quantity';
                         }elseif ($check_variation_quanity->it_easy_varation_quantity > 25) {
                             $product_stock = 'in-stock';
                         }
                         $check_variation_quanity->it_easy_product_stock_id = $product_stock;

                         $check_variation_quanity->save(false);
                         // variation code end here


                         /* For Product Addition Code */
                        $get_act = $quantity + $check_Product_quanity->it_easy_product_quantity;
                        $check_Product_quanity->it_easy_product_quantity = $get_act;
                        $get_stock = $check_Product_quanity->it_easy_product_quantity;
                         if($get_stock == '0'){
                            $product_stock = 'out-of-stock';
                         }elseif ($get_stock < 26) {
                             $product_stock = 'low-quantity';
                         }elseif ($get_stock > 25) {
                             $product_stock = 'in-stock';
                         }
                         $check_Product_quanity->it_easy_product_stock_id = $product_stock;
                         $check_Product_quanity->save(false);
                        /* End Product Addition Code */

                if(!empty($_POST['ItEasyBuildIngredient'])){
                    foreach($_POST['ItEasyBuildIngredient'] as $key => $value){
                        $modelbuild = new ItEasyBuildIngredient();
                        $modelbuild->it_easy_build_id = $model->it_easy_id;
                        $modelbuild->it_easy_material_id  = !empty($value['it_easy_material_id']) ? $value['it_easy_material_id'] : '';
                        $modelbuild->it_easy_add_quantity = !empty($value['it_easy_add_quantity']) ? $value['it_easy_add_quantity'] : '';
                        $modelbuild->it_easy_weight_type = !empty($value['it_easy_weight_type']) ? $value['it_easy_weight_type'] : '';
                        // $modelbuild->it_easy_material_name =  ItEasyProductMaterial::findOne($model->it_easy_id)->it_easy_material_name;
                        $model->created_time = $currentDateTime;
                        $modelbuild->save(false);
                    }
                }
                Yii::$app->session->setFlash('success', "Your data has been saved!");
                return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
        }

        return $this->render('create', [
            'model' => $model,
            'model2' => $model2,
        ]);
    }

    /**
     * Updates an existing ItEasyBuildHistory model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_id It Easy ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_id)
    {
        $model = $this->findModel($it_easy_id);
        $unoqueNumber = $this->generateRandom(6);
        $model2 = ItEasyBuildIngredient::findAll(['it_easy_build_id' => $it_easy_id]);
              if ($model->load(Yii::$app->request->post())){
                $post = Yii::$app->request->post();
                // echo "<pre>";print_r($post);die;
                date_default_timezone_set('Asia/kolkata');
               
                // quanity update code start here
                $productid = $post['ItEasyBuildHistory']['it_easy_product_id'];
                $variation_id = $post['ItEasyBuildHistory']['it_easy_variation_id'];
                $quantity = $post['ItEasyBuildHistory']['it_easy_product_quantity'];
                $check_Product_quanity = ItEasyProduct::find()->where(['it_easy_product_id'=>$productid])->One();
                $check_variation_quanity = ItEasyProductVariation::find()->where(['it_easy_product_id'=>$productid])->andWhere(['it_easy_variation_id'=>$variation_id])->One();
				//echo"<pre>";print_r($check_variation_quanity);die;
                $oldattribute = $model->oldAttributes['it_easy_product_quantity'];
              
                   switch (true) {
                    case $quantity == $oldattribute:
                        
                        break;
                    case $quantity > $oldattribute:
                        $get_actual = $quantity - $oldattribute;
                        /* For Variation Addition Code */
                        $add_variation = $get_actual + $check_variation_quanity->it_easy_varation_quantity;
                        $check_variation_quanity->it_easy_varation_quantity = $add_variation;
                        if($check_variation_quanity->it_easy_varation_quantity == '0'){
                            $product_stock = 'out-of-stock';
                         }elseif ($check_variation_quanity->it_easy_varation_quantity < 26) {
                             $product_stock = 'low-quantity';
                         }elseif ($check_variation_quanity->it_easy_varation_quantity > 25) {
                             $product_stock = 'in-stock';
                         }
                         $check_variation_quanity->it_easy_product_stock_id = $product_stock;

                         $check_variation_quanity->save(false);
                         /* End Variation Addition Code */

                         /* For Product Addition Code */
                        $get_act = $get_actual + $check_Product_quanity->it_easy_product_quantity;
                        $check_Product_quanity->it_easy_product_quantity = $get_act;
                        $get_stock = $check_Product_quanity->it_easy_product_quantity;
                         if($get_stock == '0'){
                            $product_stock = 'out-of-stock';
                         }elseif ($get_stock < 26) {
                             $product_stock = 'low-quantity';
                         }elseif ($get_stock > 25) {
                             $product_stock = 'in-stock';
                         }
                         $check_Product_quanity->it_easy_product_stock_id = $product_stock;
                         $check_Product_quanity->save(false);
                        /* End Product Addition Code */
                        
                        break;
                        
                        case $quantity < $oldattribute:
                        $get_actual = $quantity - $oldattribute;
                        $add_variation = $get_actual + $check_variation_quanity->it_easy_varation_quantity;
                        /* For Variation Addition Code */
                        if ($add_variation < 0){
                            Yii::$app->session->setFlash('error', "Please check your quantity!");
                            return $this->redirect(['update', 'it_easy_id' => $model->it_easy_id]);
                        }else{
                            
                            $check_variation_quanity->it_easy_varation_quantity = $add_variation;
                            if($check_variation_quanity->it_easy_varation_quantity == '0'){
                                $product_stock = 'out-of-stock';
                             }elseif ($check_variation_quanity->it_easy_varation_quantity < 26) {
                                 $product_stock = 'low-quantity';
                             }elseif ($check_variation_quanity->it_easy_varation_quantity > 25) {
                                 $product_stock = 'in-stock';
                             }
                             $check_variation_quanity->it_easy_product_stock_id = $product_stock;

                             $check_variation_quanity->save(false);
                        }
                        /* End Variation Addition Code */

                        /* For Product Addition Code */

                        $get_act = $get_actual + $check_Product_quanity->it_easy_product_quantity;
                        if ($get_act < 0){
                            Yii::$app->session->setFlash('error', "Please check your quantity!");
                            return $this->redirect(['update', 'it_easy_id' => $model->it_easy_id]);
                        }else{
                        $check_Product_quanity->it_easy_product_quantity = $get_act;
                         $get_stock = $check_Product_quanity->it_easy_product_quantity;
                         if($get_stock == '0'){
                            $product_stock = 'out-of-stock';
                         }elseif ($get_stock < 26) {
                             $product_stock = 'low-quantity';
                         }elseif ($get_stock > 25) {
                             $product_stock = 'in-stock';
                         }
                         $check_Product_quanity->it_easy_product_stock_id = $product_stock;

                        $check_Product_quanity->save(false);
                        /* End Product Addition Code */
                       
                        }
                         break;
                    }
                
                    $currentDateTime = date('Y-m-d H:i:s');
                    $time = time();
                    $model->created_by = Yii::$app->user->identity->id;
                    $model->created_time = $currentDateTime;
                    $model->save(false);

                // quanity update code end here
              
                if(!empty($_POST['ItEasyBuildIngredient'])){
                    foreach($_POST['ItEasyBuildIngredient'] as $key => $value){
                        if(isset($value['it_easy_id'])){
                            $modelingredent = $this->findModel2($value['it_easy_id']);
                        }else if(!isset($value['it_easy_id'])){
                          $modelingredent = new ItEasyBuildIngredient();  
                        }
                        if(isset($value['it_easy_material_id']) && isset($value['it_easy_add_quantity']) && isset($value['it_easy_weight_type'])){
                                $modelingredent->it_easy_build_id = $model->it_easy_id;
                                $modelingredent->it_easy_material_id  = !empty($value['it_easy_material_id']) ? $value['it_easy_material_id'] : '';
                                $modelingredent->it_easy_add_quantity = !empty($value['it_easy_add_quantity']) ? $value['it_easy_add_quantity'] : '';
                                $modelingredent->it_easy_weight_type = !empty($value['it_easy_weight_type']) ? $value['it_easy_weight_type'] : '';
                                // $modelbuild->it_easy_material_name =  'test';
                                $model->created_time = $currentDateTime;
                                $modelingredent->save();
                                $array_build_material[] = $modelingredent->it_easy_id;
                        }
                    }
                }
                ItEasyBuildIngredient::deleteAll(['AND', 'it_easy_build_id'  => $model->it_easy_id, ['NOT IN', 'it_easy_id',$array_build_material ] ]);
                Yii::$app->session->setFlash('success', "Your data has been saved!");
                return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
        }

        return $this->render('update', [
            'model' => $model,
            'model2' => $model2,
            'unoqueNumber' => $unoqueNumber
        ]);
    }

        public function actionMaterialhtml(){
       
        $this->layout = false;
        $model2 = new ItEasyBuildIngredient();
        $materialdata = $model2->getMaterialData();
        $unoqueNumber = $this->generateRandom(6);
        $getid = $_GET['getid'];
        return $this->renderPartial("materialhtml", ['unoqueNumber' => $unoqueNumber, 'materialdata' => $materialdata,'fetchid'=>$getid]);
    }

    public function generateRandom($length = 8){
        $intMin = (10 ** $length) / 10; // 100...
        $intMax = (10 ** $length) - 1;  // 999...
        $codeRandom = mt_rand($intMin, $intMax);
        return $codeRandom;
    }


    public function actionVariationName(){
        $model = new ItEasyBuildHistory();
        $productid = $_REQUEST['setid'];
        $model->getVaritionData($productid);

    }
    /**
     * Finds the ItEasyBuildHistory model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_id It Easy ID
     * @return ItEasyBuildHistory the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_id)
    {
        if (($model = ItEasyBuildHistory::findOne(['it_easy_id' => $it_easy_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

        protected function findModel2($it_easy_id)
    {
        if (($model = ItEasyBuildIngredient::findOne(['it_easy_id' => $it_easy_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }




}
