<?php

namespace backend\controllers;

use Yii;
use backend\models\ItEasyBuyProduct;
use backend\models\ItEasyBuyProductSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use backend\models\ItEasyVendor;
use backend\models\ItEasyProduct;
use backend\models\ItEasyProductVariation;
use yii\db\QueryBuilder;
use yii\filters\AccessControl;


/**
 * BuyProductController implements the CRUD actions for ItEasyBuyProduct model.
 */
class BuyProductController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyBuyProduct models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyBuyProductSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }


    /**
     * Creates a new ItEasyBuyProduct model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new ItEasyBuyProduct();

             if ($model->load(Yii::$app->request->post())){
                $post = Yii::$app->request->post();
                date_default_timezone_set('Asia/kolkata');
                $currentDateTime = date('Y-m-d H:i:s');
                $time = time();

                $received_date = $post['ItEasyBuyProduct']['it_easy_received_date'];
                $time=strtotime($received_date);
                $month=date("m",$time);
                $year=date("Y",$time);

                $it_easy_vendor_id = $post['ItEasyBuyProduct']['it_easy_vendor_id'];
                $productid = $post['ItEasyBuyProduct']['it_easy_product_id'];
                $quantity = $post['ItEasyBuyProduct']['it_easy_product_quantity'];
                $variation_id = $post['ItEasyBuyProduct']['it_easy_variation_id'];
                $model->it_easy_vendor_name = ItEasyVendor::find()->select(['it_easy_vendor_name'])->where(['it_easy_id' => $it_easy_vendor_id])->asArray()->One()['it_easy_vendor_name'];

                $product_model = ItEasyProduct::find()->where(['it_easy_product_id' => $productid])->One();

                $model->it_easy_product_name  = $product_model->it_easy_product_name;
                $model->it_easy_buy_month = $month;
                $model->it_easy_buy_year = $year;
                $model->it_easy_approved_status  = 'Pending';
                $model->created_by = Yii::$app->user->identity->id;
                $model->created_time = $currentDateTime; 
                $model->save(false);

                $check_variation_quanity = ItEasyProductVariation::find()->where(['it_easy_product_id'=>$productid])->andWhere(['it_easy_variation_id'=>$variation_id])->One();
                        /* For Variation Addition Code */
                        $add_variation = $quantity + $check_variation_quanity->it_easy_varation_quantity;
                        $check_variation_quanity->it_easy_varation_quantity = $add_variation;
                        if($check_variation_quanity->it_easy_varation_quantity == '0'){
                            $product_stock = 'out-of-stock';
                         }elseif ($check_variation_quanity->it_easy_varation_quantity < 26) {
                             $product_stock = 'low-quantity';
                         }elseif ($check_variation_quanity->it_easy_varation_quantity > 25) {
                             $product_stock = 'in-stock';
                         }
                         $check_variation_quanity->it_easy_product_stock_id = $product_stock;

                         $check_variation_quanity->save(false);
                         /* End Variation Addition Code */

                         /* For Product Addition Code */
                        $get_act = $quantity + $product_model->it_easy_product_quantity;
                        $product_model->it_easy_product_quantity = $get_act;
                        
                         if($product_model->it_easy_product_quantity == '0'){
                            $product_stock = 'out-of-stock';
                         }elseif ($product_model->it_easy_product_quantity < 26) {
                             $product_stock = 'low-quantity';
                         }elseif ($product_model->it_easy_product_quantity > 25) {
                             $product_stock = 'in-stock';
                         }
                         $product_model->it_easy_product_stock_id = $product_stock;
                         $product_model->save(false);
                        /* End Product Addition Code */

                Yii::$app->session->setFlash('success', "Your data has been saved!");
                return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing ItEasyBuyProduct model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_id It Easy ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_id)
    {
        $model = $this->findModel($it_easy_id);

              if ($model->load(Yii::$app->request->post())){
                $post = Yii::$app->request->post();
                date_default_timezone_set('Asia/kolkata');
                $currentDateTime = date('Y-m-d H:i:s');
                $time = time();
                $received_date = $post['ItEasyBuyProduct']['it_easy_received_date'];
                $time=strtotime($received_date);
                $month=date("m",$time);
                $year=date("Y",$time);
                $it_easy_vendor_id = $post['ItEasyBuyProduct']['it_easy_vendor_id'];
                $productid = $post['ItEasyBuyProduct']['it_easy_product_id'];
                $quantity = $post['ItEasyBuyProduct']['it_easy_product_quantity'];
                $variation_id = $post['ItEasyBuyProduct']['it_easy_variation_id'];

                $model->it_easy_vendor_name = ItEasyVendor::find()->select(['it_easy_vendor_name'])->where(['it_easy_id' => $it_easy_vendor_id])->asArray()->One()['it_easy_vendor_name'];

                $oldattribute = $model->oldAttributes['it_easy_product_quantity'];

                $product_model = ItEasyProduct::find()->where(['it_easy_product_id' => $productid])->One();
			

                $check_variation_quanity = ItEasyProductVariation::find()->where(['it_easy_product_id'=>$productid])->andWhere(['it_easy_variation_id'=>$variation_id])->One();
              
				$model->it_easy_product_name  = $product_model->it_easy_product_name;
                $model->it_easy_buy_month = $month;
                $model->it_easy_buy_year = $year; 
                $model->updated_by = Yii::$app->user->identity->id;
                $model->updated_time = $currentDateTime; 
                $model->save(false);

                switch (true) {
                    case $quantity == $oldattribute:
                        // Yii::$app->session->setFlash('success', "Your data has been saved!");
                        // return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
                        break;
                    case $quantity > $oldattribute:
                        $get_actual = $quantity - $oldattribute;

                        /* For Variation Addition Code */
                        $add_variation = $get_actual + $check_variation_quanity->it_easy_varation_quantity;
                        $check_variation_quanity->it_easy_varation_quantity = $add_variation;
                        if($check_variation_quanity->it_easy_varation_quantity == '0'){
                            $product_stock = 'out-of-stock';
                         }elseif ($check_variation_quanity->it_easy_varation_quantity < 26) {
                             $product_stock = 'low-quantity';
                         }elseif ($check_variation_quanity->it_easy_varation_quantity > 25) {
                             $product_stock = 'in-stock';
                         }
                         $check_variation_quanity->it_easy_product_stock_id = $product_stock;

                         $check_variation_quanity->save(false);
                         /* End Variation Addition Code */

                         /* For Product Addition Code */
                        $get_act = $get_actual + $product_model->it_easy_product_quantity;
                        $product_model->it_easy_product_quantity = $get_act;
                        $get_stock = $product_model->it_easy_product_quantity;
                         if($get_stock == '0'){
                            $product_stock = 'out-of-stock';
                         }elseif ($get_stock < 26) {
                             $product_stock = 'low-quantity';
                         }elseif ($get_stock > 25) {
                             $product_stock = 'in-stock';
                         }
                         $product_model->it_easy_product_stock_id = $product_stock;
                         $product_model->save(false);
                        /* End Product Addition Code */
                        
                        break;
                        
                    case $quantity < $oldattribute:
                        $get_actual = $quantity - $oldattribute;

                       $add_variation = $get_actual + $check_variation_quanity->it_easy_varation_quantity;
                        /* For Variation Addition Code */
                        if ($add_variation < 0){
                            Yii::$app->session->setFlash('error', "Please check your quantity!");
                            return $this->redirect(['update', 'it_easy_id' => $model->it_easy_id]);
                        }else{
                            
                            $check_variation_quanity->it_easy_varation_quantity = $add_variation;
                            if($check_variation_quanity->it_easy_varation_quantity == '0'){
                                $product_stock = 'out-of-stock';
                             }elseif ($check_variation_quanity->it_easy_varation_quantity < 26) {
                                 $product_stock = 'low-quantity';
                             }elseif ($check_variation_quanity->it_easy_varation_quantity > 25) {
                                 $product_stock = 'in-stock';
                             }
                             $check_variation_quanity->it_easy_product_stock_id = $product_stock;

                             $check_variation_quanity->save(false);
                        }
                        /* End Variation Addition Code */

                         /* For Product Addition Code */

                        $get_act = $get_actual + $product_model->it_easy_product_quantity;
                        if ($get_act < 0){
                            Yii::$app->session->setFlash('error', "Please check your quantity!");
                            return $this->redirect(['update', 'it_easy_id' => $model->it_easy_id]);
                        }else{
                        $product_model->it_easy_product_quantity = $get_act;
                         $get_stock = $product_model->it_easy_product_quantity;
                         if($get_stock == '0'){
                            $product_stock = 'out-of-stock';
                         }elseif ($get_stock < 26) {
                             $product_stock = 'low-quantity';
                         }elseif ($get_stock > 25) {
                             $product_stock = 'in-stock';
                         }
                         $product_model->it_easy_product_stock_id = $product_stock;

                        $product_model->save(false);
                        }
                        break;
                    
                }
               

                Yii::$app->session->setFlash('success', "Your data has been saved!");
                return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }


            public function actionBuyproductName(){
                $model = new ItEasyBuyProduct();
                $productid = $_REQUEST['setid'];
                $model->getVaritionData($productid);

            }

        public function actionProductList($q = null, $id = null) {
            \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
            $out = ['results' => ['id' => '', 'text' => '']];
            if (!is_null($q)) {
                $query = new \yii\db\Query;
                $query->select('it_easy_product_id as id, it_easy_product_name AS text')
                    ->from('it_easy_product')
                    ->where(['like', 'it_easy_product_name', $q])
                    ->limit(20);
                $command = $query->createCommand();
                $data = $command->queryAll();
                $out['results'] = array_values($data);
            }
            elseif ($id > 0) {
                $out['results'] = ['id' => $id, 'text' => ItEasyProduct::find($id)->it_easy_product_name];
            }
            return $out;
        }

    /**
     * Finds the ItEasyBuyProduct model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_id It Easy ID
     * @return ItEasyBuyProduct the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_id)
    {
        if (($model = ItEasyBuyProduct::findOne(['it_easy_id' => $it_easy_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
