<?php

namespace backend\controllers;
use Yii;
use backend\models\ItEasyChanel;
use backend\models\ItEasyOrder;
use backend\models\ItEasyOrderTrack;
use backend\models\ItEasyState;
use backend\models\ItEasyOrderDispatch;
use backend\models\ItEasyOrderDispositionHistory;
use backend\models\ItEasyOrderStatusHistory;
use backend\models\ItEasyOrderProduct;
use backend\models\ItEasyCustomer;
use backend\models\ItEasyChanelSearch;
use backend\models\ItEasyZonePincode;
use backend\models\ItEasyProductVariation;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;

/**
 * ChanelController implements the CRUD actions for ItEasyChanel model.
 */
class ChanelController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }
    
    
    public function actionProduct(){
        $request_url = "https://nutriherbs2.myshopify.com/admin/api/2023-01/products.json";
        
        $username = 'd6154e3f68d5e20805a028b8af849bda';
        //$username = '3b995aa264af00948231c2382e00a433';         
        $password = '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'; 
                    
        $request_handle = curl_init($request_url);
        curl_setopt($request_handle, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($request_handle, CURLOPT_USERPWD, $username . ":" . $password); 
        curl_setopt($request_handle, CURLOPT_RETURNTRANSFER, true);
         $request_result = curl_exec($request_handle);
        
        $data_val = json_decode($request_result);
        echo "<pre>"; print_r($data_val); 
    }
    
    public function actionFullfill(){
        $get_data_fullfill_data = ItEasyOrder::find()->from(['or' => ItEasyOrder::tablename()])->select(['or.*', 'od.it_easy_shipping_id', 'od.it_easy_awb_number', 'od.it_easy_order_type', 'od.it_easy_courier_name', 'od.it_easy_subcourier_name'])->leftJoin(ItEasyOrderDispatch::tablename().' as od', 'or.it_easy_order_id = od.it_easy_order_id')
            ->andWhere(['<>', 'shopify_order_id', ''])->andWhere(['it_easy_push_status' => '0'])->andWhere(['IN', 'it_easy_order_status_id', ['3', '4', '5', '6','9', '14', '15', '16', '22', '23', '26', '27', '28', '29', '30', '31', '47']])->orderBy(['it_easy_order_id' => SORT_ASC])->limit(20)->asArray()->all();
            // echo "<pre>"; print_r($get_data_fullfill_data); die;
        if(!empty($get_data_fullfill_data)){
            foreach($get_data_fullfill_data as $key => $full_fill){
                // echo "<pre>"; print_r($full_fill); die;
                $order_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $full_fill['it_easy_order_id']])->asArray()->all();
                // echo "<pre>"; print_r($order_product); 
                $count_product = count($order_product);
                $shopify_order = $full_fill['shopify_order_id'];
                $request_url = "https://nutriherbs2.myshopify.com/admin/api/2022-10/orders/".$shopify_order."/fulfillment_orders.json";
                
                $username = 'd6154e3f68d5e20805a028b8af849bda';
                //$username = '3b995aa264af00948231c2382e00a433';         
                $password = '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'; 
                            
                $request_handle = curl_init($request_url);
                curl_setopt($request_handle, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
                curl_setopt($request_handle, CURLOPT_USERPWD, $username . ":" . $password); 
                curl_setopt($request_handle, CURLOPT_RETURNTRANSFER, true);
                 $request_result = curl_exec($request_handle);
                
                $data_val = json_decode($request_result);
                // echo "<pre>"; print_r($data_val);  die;
                if(!empty($data_val)){
                    $count_line_item = count($data_val->fulfillment_orders[0]->line_items);
                    // echo $count_line_item; echo "<br>"; 
                    // echo $count_product; echo "<br>"; die;
                    if($count_product == $count_line_item){
                        $xs = 0;
                        foreach($order_product as $key2 => $o_product){
                            $product_Variation = ItEasyProductVariation::find()->where(['it_easy_product_id' => $o_product['it_easy_product_id']])->andWhere(['it_easy_variation_id' => $o_product['it_easy_variation_id'] ])->asArray()->one();
                             
                            if($product_Variation['shopify_veriant_id'] == '43552215695605'){
                                
                                if(array_search($product_Variation['shopify_veriant_id'], array_column($data_val->fulfillment_orders[0]->line_items, 'variant_id')) !== FALSE){
                                    
                                    
                                    $xs +=$o_product['it_easy_product_quantity'];
                                }else if(array_search('43565384859893', array_column($data_val->fulfillment_orders[0]->line_items, 'variant_id')) !== FALSE){
                                    
                                    
                                    $xs +=$o_product['it_easy_product_quantity'];
                                }else if(array_search('43565387579637', array_column($data_val->fulfillment_orders[0]->line_items, 'variant_id')) !== FALSE){
                                    
                                    $xs +=$o_product['it_easy_product_quantity'];
                                }else if(array_search('43565387645173', array_column($data_val->fulfillment_orders[0]->line_items, 'variant_id')) !== FALSE){
                                    
                                    $xs +=$o_product['it_easy_product_quantity'];
                                }else if(array_search('43565387612405', array_column($data_val->fulfillment_orders[0]->line_items, 'variant_id')) !== FALSE){
                                    
                                    $xs +=$o_product['it_easy_product_quantity'];
                                }else if(array_search('43565384892661', array_column($data_val->fulfillment_orders[0]->line_items, 'variant_id')) !== FALSE){
                                    
                                    $xs +=$o_product['it_easy_product_quantity'];
                                }else if(array_search('43565384827125', array_column($data_val->fulfillment_orders[0]->line_items, 'variant_id')) !== FALSE){
                                    
                                    $xs +=$o_product['it_easy_product_quantity'];
                                }else{
                                    
                                }
                
                                
                            }else if($product_Variation['shopify_veriant_id'] == '43552215728373'){
                                if(array_search($product_Variation['shopify_veriant_id'], array_column($data_val->fulfillment_orders[0]->line_items, 'variant_id')) !== FALSE){
                                    
                                    $xs +=$o_product['it_easy_product_quantity'];
                                }else if(array_search('43565387579637', array_column($data_val->fulfillment_orders[0]->line_items, 'variant_id')) !== FALSE){
                                    
                                    $xs +=$o_product['it_easy_product_quantity'];
                                }else if(array_search('43565384859893', array_column($data_val->fulfillment_orders[0]->line_items, 'variant_id')) !== FALSE){
                                    
                                    $xs +=$o_product['it_easy_product_quantity'];
                                }else if(array_search('43552215695605', array_column($data_val->fulfillment_orders[0]->line_items, 'variant_id')) !== FALSE){
                                    
                                    $xs +=$o_product['it_easy_product_quantity'];
                                }else if(array_search('43552215728373', array_column($data_val->fulfillment_orders[0]->line_items, 'variant_id')) !== FALSE){
                                    
                                    $xs +=$o_product['it_easy_product_quantity'];
                                }else{
                                    
                                }
                                
                            }else if($product_Variation['shopify_veriant_id'] == '43552215761141'){
                                if(array_search($product_Variation['shopify_veriant_id'], array_column($data_val->fulfillment_orders[0]->line_items, 'variant_id')) !== FALSE){
                                    
                                    $xs +=$o_product['it_easy_product_quantity'];
                                }else if(array_search('43565387645173', array_column($data_val->fulfillment_orders[0]->line_items, 'variant_id')) !== FALSE){
                                    
                                    $xs +=$o_product['it_easy_product_quantity'];
                                }else if(array_search('43565384859893', array_column($data_val->fulfillment_orders[0]->line_items, 'variant_id')) !== FALSE){
                                    
                                    $xs +=$o_product['it_easy_product_quantity'];
                                }else if(array_search('43552215695605', array_column($data_val->fulfillment_orders[0]->line_items, 'variant_id')) !== FALSE){
                                    
                                    $xs +=$o_product['it_easy_product_quantity'];
                                }else if(array_search('43552215728373', array_column($data_val->fulfillment_orders[0]->line_items, 'variant_id')) !== FALSE){
                                    
                                    $xs +=$o_product['it_easy_product_quantity'];
                                }else if(array_search('43552215761141', array_column($data_val->fulfillment_orders[0]->line_items, 'variant_id')) !== FALSE){
                                    
                                    $xs +=$o_product['it_easy_product_quantity'];
                                }else{
                                    
                                }
                            }else if(array_search($product_Variation['shopify_veriant_id'], array_column($data_val->fulfillment_orders[0]->line_items, 'variant_id'))){
                                
                                    $xs +=$o_product['it_easy_product_quantity'];
                            }
                            
                        }
                        // echo $xs; echo "<br>"; 
                        // echo $count_line_item; echo "<br>"; die;
                        if($xs == $count_line_item){
                            $line_item =  $data_val->fulfillment_orders[0]->line_items[0]->id;
                            $fullfilled_id = $data_val->fulfillment_orders[0]->line_items[0]->fulfillment_order_id;
                            $fullfilled_array = [];
                            foreach($data_val->fulfillment_orders[0]->line_items as $key6 => $line_items){
                                $fullfilled_array[$key6]['id'] = $line_items->id;
                                $fullfilled_array[$key6]['quantity'] = $line_items->quantity;
                            }
                            
                            $awb_number = $full_fill['it_easy_awb_number'];
                    	    if($full_fill['it_easy_shipping_id'] == '2'){
                    	        $courier_name = 'Ecom Express';
                    	        $courier_url = "https://ecomexpress.in/tracking/";
                    	    }else if($full_fill['it_easy_shipping_id'] == '3'){
                    	        $courier_name = 'XPRESSBEES';
                    	        $courier_url = "https://www.xpressbees.com/track";
                    	    }else if($full_fill['it_easy_shipping_id'] == '1'){
                    	        $courier_name = 'Delhivery';
                    	        $courier_url = "https://www.delhivery.com/";
                    	    }else if($full_fill['it_easy_shipping_id'] == '4'){
                    	        $courier_name = 'Shipdelight';
                    	        $courier_url = "https://track.shipdelight.com/";
                    	    }else if($full_fill['it_easy_shipping_id'] == '6'){
                    	        $courier_name = 'Ecom Express AIR';
                    	        $courier_url = "https://ecomexpress.in/tracking/";
                    	    }else if($full_fill['it_easy_shipping_id'] == '5'){
                    	        $courier_name = 'India Post';
                    	        $courier_url = "https://www.indiapost.gov.in/vas/Pages/IndiaPostHome.aspx";
                    	    }else if($full_fill['it_easy_shipping_id'] == '7'){
                    	        if($full_fill['it_easy_subcourier_name'] == 'Bluedart- Surface'){
                    	        $courier_name = 'Bluedart';
                    	        $courier_url = "https://www.bluedart.com/tracking";
                    	        }else{
                    	            $courier_name = 'Delhivery';
                        	        $courier_url = "https://www.delhivery.com/";
                    	        }
                    	    }
                    	    
                    	    
                    	    
                    	    
                            $request_url = "https://nutriherbs2.myshopify.com/admin/api/2022-10/fulfillments.json";
                            //echo $request_url; 
                            $username = 'd6154e3f68d5e20805a028b8af849bda';
                              
                            $password = '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';          
                                        
                            $request_handle2 = curl_init($request_url);
                            curl_setopt($request_handle2, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
                            curl_setopt($request_handle2, CURLOPT_USERPWD, $username . ":" . $password); 
                            $headers = array(
                               "Content-Type: application/json",
                            );
                            curl_setopt($request_handle2, CURLOPT_HTTPHEADER, $headers);
                            
                             $jayParsedAry = [
                              "fulfillment" => [
                                     "message" => "The package was shipped this morning.", 
                                     "notify_customer" => false, 
                                     "tracking_info" => [
                                        "number" => $awb_number, 
                                        "url" => $courier_url, 
                                        "company" => $courier_name 
                                     ], 
                                     "line_items_by_fulfillment_order" => [
                                          [
                                              "fulfillment_order_id" => $fullfilled_id, 
                                              "fulfillment_order_line_items" => $fullfilled_array 
                                          ] 
                                        ] 
                                  ] 
                            ]; 
                            
                            
                            // echo "<pre>"; print_r($jayParsedAry); die;
        
                            curl_setopt($request_handle2, CURLOPT_POSTFIELDS, json_encode($jayParsedAry));
                            
                            curl_setopt($request_handle2, CURLOPT_RETURNTRANSFER, true);
                            $request_result2 = curl_exec($request_handle2);
                            
                            $data_val2 = json_decode($request_result2);
                            // echo "<pre>"; print_r($data_val2);
                            if(isset($data_val2->fulfillment->id) && !empty($data_val2->fulfillment->id)){
                                $find_order = ItEasyOrder::findOne(['it_easy_order_id' => $full_fill['it_easy_order_id']]);
                                $find_order->shopify_fullfillment_id = $fullfilled_id;
                                
                                $find_order->it_easy_push_status = '1';
                                $find_order->save(false);
                            }else{
                                echo "<pre>"; print_r($data_val2);
                                $find_order = ItEasyOrder::findOne(['it_easy_order_id' => $full_fill['it_easy_order_id']]);
                                $find_order->shopify_fullfillment_id = $fullfilled_id;
                                
                                $find_order->it_easy_push_status = '1';
                                $find_order->save(false);
                                echo "<pre>"; print_r($find_order);
                            }
                            
                            // die;
                            
                        }else{
                            $variation_array_order = [];
                            $total_product_price = 0;
                            foreach($order_product as $key2 => $o_product){
                                $total_product_price += $o_product['it_easy_product_total'];
                                $exact_product_priceu = $o_product['it_easy_product_total']/ $o_product['it_easy_product_quantity'];
                                $product_Variation = ItEasyProductVariation::find()->where(['it_easy_product_id' => $o_product['it_easy_product_id']])->andWhere(['it_easy_variation_id' => $o_product['it_easy_variation_id'] ])->asArray()->one();
                                $variation_array_order[$key2]['variant_id'] = $product_Variation['shopify_veriant_id'];
                                $variation_array_order[$key2]['quantity'] = $o_product['it_easy_product_quantity'];
                                $variation_array_order[$key2]['price'] = $exact_product_priceu;
                                
                            
                            }
                            $coupon_data = ItEasyOrder::getCoouponbyid($full_fill['it_easy_coupon_id']);
                            if(!empty($coupon_data)){
                                $coupon_discnt = $coupon_data['it_easy_discount'];
                                $coupon_data_apply = [["code" => $coupon_data['it_easy_coupon_code'],"amount"=>$coupon_data['it_easy_discount'],"type"=>"fixed_amount"]];
                            }else{
                                $coupon_data_apply = [["code" => 'Add_Random',"amount"=>'0',"type"=>"fixed_amount"]];
                                $coupon_discnt = 0;
                            }
                            if($full_fill['it_easy_total_price'] < $total_product_price){
                                if(empty($coupon_discnt)){
                                    $coupon_discnt = $total_product_price - $full_fill['it_easy_total_price'];
                                    $coupon_data_apply = [["code" => 'Add_Random',"amount"=>$coupon_discnt,"type"=>"fixed_amount"]];
                                }
                            }
                            // echo $total_product_price; echo "<br>";
                            // echo $full_fill['it_easy_total_price']; echo "<br>";
                            // echo $coupon_discnt; echo "<br>"; 
                            // echo "<pre>"; print_r($full_fill); 
                            // die;
                            $value_after_discount = $total_product_price - $coupon_discnt;
                            
                            $add_tax = $full_fill['it_easy_total_price'] - $value_after_discount;

                            if($full_fill['it_easy_payment_code'] == 'COD'){
                                $financial_status = "pending";
                            }else{
                                $financial_status = "paid";
                            }
                            $jayParsedAry = [
                               "order" => [
                                     "line_items" => $variation_array_order, 
                                     "customer" => ["first_name" => $full_fill['it_easy_firstname'], "last_name" => $full_fill['it_easy_lastname'],"email" => $full_fill['it_easy_email']], 
                                     "billing_address" => ["first_name" => $full_fill['it_easy_billing_firstname'], "last_name" => $full_fill['it_easy_billing_lastname'],"address1" => $full_fill['it_easy_billing_address_1'].' '.$full_fill['it_easy_billing_address_2'], "phone" => $full_fill['it_easy_billing_mobile'],"city" => $full_fill['it_easy_billing_city'],"province" => $full_fill['it_easy_billing_state'], "country" =>"IN","zip"=>$full_fill['it_easy_billing_pincode']], 
                                     "shipping_address" => ["first_name" => $full_fill['it_easy_shipping_firstname'], "last_name" => $full_fill['it_easy_shipping_lastname'],"address1" => $full_fill['it_easy_shipping_address_1'].' '.$full_fill['it_easy_shipping_address_2'], "phone" => $full_fill['it_easy_shipping_mobile_number'],"city" => $full_fill['it_easy_shipping_city'],"province" => $full_fill['it_easy_shipping_state'], "country" =>"IN","zip"=>$full_fill['it_easy_shipping_pincode']], 
                            
                                     "email" => $full_fill['it_easy_email'],
                            
                                     "financial_status" => $financial_status,
                                     "discount_codes" => $coupon_data_apply,
                                     "total_tax" => $add_tax, 
                                     "currency" => "INR", 
                                     "tags" => $full_fill['it_easy_other_order_id'], 
                                  ],
                                  
                            ]; 
                            // echo "<pre>"; print_r($jayParsedAry); die;
                            
                            $request_url4 = "https://nutriherbs2.myshopify.com/admin/api/2022-04/orders.json";
                            
                            $username = 'd6154e3f68d5e20805a028b8af849bda';
                            $password = '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'; 
                                        
                            $request_handle4 = curl_init($request_url4);
                            curl_setopt($request_handle4, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
                            curl_setopt($request_handle4, CURLOPT_USERPWD, $username . ":" . $password); 
                            
                            curl_setopt($request_handle4, CURLOPT_POST, true);
                            
                            $headers = array(
                               "Content-Type: application/json",
                            );
                            curl_setopt($request_handle4, CURLOPT_HTTPHEADER, $headers);
                            
                            curl_setopt($request_handle4, CURLOPT_POSTFIELDS, json_encode($jayParsedAry));
                            curl_setopt($request_handle4, CURLOPT_RETURNTRANSFER, true);
                             $request_result4 = curl_exec($request_handle4);
                            // echo $request_result; die;
                            $data_val4 = json_decode($request_result4);
                            // echo "<pre>"; print_r($data_val4); die;
                            if(!empty($data_val4->order->id) && isset($data_val4->order->id)){
                                $find_order = ItEasyOrder::findOne(['it_easy_order_id' => $full_fill['it_easy_order_id']]);
                                $find_order->shopify_order_id = $data_val4->order->id;
                                
                                $find_order->it_easy_other_order_id = str_replace("#","s",$data_val4->order->name);
                                $find_order->save(false);
                                
                                
$shopify_order9 = $find_order->shopify_order_id;
$request_url8 = "https://nutriherbs2.myshopify.com/admin/api/2022-10/orders/".$shopify_order9."/fulfillment_orders.json";

$username = 'd6154e3f68d5e20805a028b8af849bda';
//$username = '3b995aa264af00948231c2382e00a433';         
$password = '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'; 
            
$request_handle8 = curl_init($request_url8);
curl_setopt($request_handle8, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
curl_setopt($request_handle8, CURLOPT_USERPWD, $username . ":" . $password); 
curl_setopt($request_handle8, CURLOPT_RETURNTRANSFER, true);
 $request_result8 = curl_exec($request_handle8);

$data_val8 = json_decode($request_result8);
echo "<pre>"; print_r($data_val); 
if(!empty($data_val8)){
    
    $line_item8 =  $data_val8->fulfillment_orders[0]->line_items[0]->id;
    $fullfilled_id8 = $data_val8->fulfillment_orders[0]->line_items[0]->fulfillment_order_id;
    $fullfilled_array2 = [];
    foreach($data_val8->fulfillment_orders[0]->line_items as $key6 => $line_items){
        $fullfilled_array2[$key6]['id'] = $line_items->id;
        $fullfilled_array2[$key6]['quantity'] = $line_items->quantity;
    }
    
    // echo "<pre>"; print_r($full_fill); die;
    
    
    $awb_number = $full_fill['it_easy_awb_number'];
    if($full_fill['it_easy_shipping_id'] == '2'){
        $courier_name = 'Ecom Express';
        $courier_url = "https://ecomexpress.in/tracking/";
    }else if($full_fill['it_easy_shipping_id'] == '3'){
        $courier_name = 'XPRESSBEES';
        $courier_url = "https://www.xpressbees.com/track";
    }else if($full_fill['it_easy_shipping_id'] == '1'){
        $courier_name = 'Delhivery';
        $courier_url = "https://www.delhivery.com/";
    }else if($full_fill['it_easy_shipping_id'] == '4'){
        $courier_name = 'Shipdelight';
        $courier_url = "https://track.shipdelight.com/";
    }else if($full_fill['it_easy_shipping_id'] == '6'){
        $courier_name = 'Ecom Express AIR';
        $courier_url = "https://ecomexpress.in/tracking/";
    }else if($full_fill['it_easy_shipping_id'] == '5'){
        $courier_name = 'India Post';
        $courier_url = "https://www.indiapost.gov.in/vas/Pages/IndiaPostHome.aspx";
    }else if($full_fill['it_easy_shipping_id'] == '7'){
        if($full_fill['it_easy_subcourier_name'] == 'Bluedart- Surface'){
        $courier_name = 'Bluedart';
        $courier_url = "https://www.bluedart.com/tracking";
        }else{
            $courier_name = 'Delhivery';
	        $courier_url = "https://www.delhivery.com/";
        }
    }
    
    
    $request_url9 = "https://nutriherbs2.myshopify.com/admin/api/2022-10/fulfillments.json";
    //echo $request_url; 
    $username = 'd6154e3f68d5e20805a028b8af849bda';
      
    $password = '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';          
                
    $request_handle9 = curl_init($request_url9);
    curl_setopt($request_handle9, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    curl_setopt($request_handle9, CURLOPT_USERPWD, $username . ":" . $password); 
    $headers = array(
       "Content-Type: application/json",
    );
    curl_setopt($request_handle9, CURLOPT_HTTPHEADER, $headers);
    
     $jayParsedAry2 = [
      "fulfillment" => [
             "message" => "The package was shipped this morning.", 
             "notify_customer" => false, 
             "tracking_info" => [
                "number" => $awb_number, 
                "url" => $courier_url, 
                "company" => $courier_name 
             ], 
             "line_items_by_fulfillment_order" => [
                  [
                      "fulfillment_order_id" => $fullfilled_id8, 
                      "fulfillment_order_line_items" => $fullfilled_array2 
                  ] 
                ] 
          ] 
    ]; 
    

    curl_setopt($request_handle9, CURLOPT_POSTFIELDS, json_encode($jayParsedAry2));
    
    curl_setopt($request_handle9, CURLOPT_RETURNTRANSFER, true);
    $request_result9 = curl_exec($request_handle9);
    
    $data_val9 = json_decode($request_result9);
    echo "<pre>"; print_r($data_val9); 
    if(isset($data_val9->fulfillment->id) && !empty($data_val9->fulfillment->id)){
        $find_order = ItEasyOrder::findOne(['it_easy_order_id' => $full_fill['it_easy_order_id']]);
        $find_order->shopify_fullfillment_id = $fullfilled_id8;
        
        $find_order->it_easy_push_status = '1';
        $find_order->save(false);
        $shopify_order = $full_fill['shopify_order_id'];
        $request_url15 = "https://nutriherbs2.myshopify.com/admin/api/2023-01/orders/".$shopify_order."/cancel.json";

        $username = 'd6154e3f68d5e20805a028b8af849bda';
        $password = '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'; 
                    
        $request_handle15 = curl_init($request_url15);
        curl_setopt($request_handle15, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($request_handle15, CURLOPT_USERPWD, $username . ":" . $password); 
        
        curl_setopt($request_handle15, CURLOPT_POST, true);
        
        $headers = array(
           "Content-Type: application/json",
        );
        curl_setopt($request_handle15, CURLOPT_HTTPHEADER, $headers);
        
        curl_setopt($request_handle15, CURLOPT_RETURNTRANSFER, true);
         $request_result15 = curl_exec($request_handle15);
        // echo $request_result; die;
        $data_val15 = json_decode($request_result15);
        echo "<pre>"; print_r($data_val15);

        echo "<pre>"; print_r($find_order); 
    }
    
    
    
    
}




                            }
                            
                        }
                        
                        
                    }else{
                        
                        
                            $variation_array_order = [];
                            $total_product_price = 0;
                            // echo "<pre>"; print_r($order_product);  die;
                            foreach($order_product as $key2 => $o_product){
                                $total_product_price += $o_product['it_easy_product_total'];
                                $exact_product_priceu = $o_product['it_easy_product_total']/ $o_product['it_easy_product_quantity'];
                                $product_Variation = ItEasyProductVariation::find()->where(['it_easy_product_id' => $o_product['it_easy_product_id']])->andWhere(['it_easy_variation_id' => $o_product['it_easy_variation_id'] ])->asArray()->one();
                                // echo "<pre>"; print_r($product_Variation); die;
                                $variation_array_order[$key2]['variant_id'] = $product_Variation['shopify_veriant_id'];
                                $variation_array_order[$key2]['quantity'] = $o_product['it_easy_product_quantity'];
                                $variation_array_order[$key2]['price'] = $exact_product_priceu;
                                
                            
                            }
                            // echo "<pre>"; print_r($variation_array_order);
                            // die;
                            // echo $total_product_price; echo "<br>";
                            $coupon_data = ItEasyOrder::getCoouponbyid($full_fill['it_easy_coupon_id']);
                            if(!empty($coupon_data)){
                                $coupon_discnt = $coupon_data['it_easy_discount'];
                                $coupon_data_apply = [["code" => $coupon_data['it_easy_coupon_code'],"amount"=>$coupon_data['it_easy_discount'],"type"=>"fixed_amount"]];
                            }else{
                                $coupon_data_apply = [["code" => 'Add_Random',"amount"=>'0',"type"=>"fixed_amount"]];
                                $coupon_discnt = 0;
                            }
                            
                            if($full_fill['it_easy_total_price'] < $total_product_price){
                                if(empty($coupon_discnt)){
                                    $coupon_discnt = $total_product_price - $full_fill['it_easy_total_price'];
                                    $coupon_data_apply = [["code" => 'Add_Random',"amount"=>$coupon_discnt,"type"=>"fixed_amount"]];
                                }
                            }
                            
                            $value_after_discount = $total_product_price - $coupon_discnt;
                            // echo $value_after_discount; echo "<br>"; die;
                            $add_tax = $full_fill['it_easy_total_price'] - $value_after_discount;

                            if($full_fill['it_easy_payment_code'] == 'COD'){
                                $financial_status = "pending";
                            }else{
                                $financial_status = "paid";
                            }
                            
                            // echo $total_product_price; echo "<br>";
                            // echo $full_fill['it_easy_total_price']; echo "<br>";
                            // echo $coupon_discnt; echo "<br>"; 
                            // echo "<pre>"; print_r($full_fill); 
                            // die;
                            
                            $jayParsedAry = [
                               "order" => [
                                     "line_items" => $variation_array_order, 
                                     "customer" => ["first_name" => $full_fill['it_easy_firstname'], "last_name" => $full_fill['it_easy_lastname'],"email" => $full_fill['it_easy_email']], 
                                     "billing_address" => ["first_name" => $full_fill['it_easy_billing_firstname'], "last_name" => $full_fill['it_easy_billing_lastname'],"address1" => $full_fill['it_easy_billing_address_1'].' '.$full_fill['it_easy_billing_address_2'], "phone" => $full_fill['it_easy_billing_mobile'],"city" => $full_fill['it_easy_billing_city'],"province" => $full_fill['it_easy_billing_state'], "country" =>"IN","zip"=>$full_fill['it_easy_billing_pincode']], 
                                     "shipping_address" => ["first_name" => $full_fill['it_easy_shipping_firstname'], "last_name" => $full_fill['it_easy_shipping_lastname'],"address1" => $full_fill['it_easy_shipping_address_1'].' '.$full_fill['it_easy_shipping_address_2'], "phone" => $full_fill['it_easy_shipping_mobile_number'],"city" => $full_fill['it_easy_shipping_city'],"province" => $full_fill['it_easy_shipping_state'], "country" =>"IN","zip"=>$full_fill['it_easy_shipping_pincode']], 
                            
                                     "email" => $full_fill['it_easy_email'],
                            
                                     "financial_status" => $financial_status,
                                     "discount_codes" => $coupon_data_apply,
                                     "total_tax" => $add_tax, 
                                     "currency" => "INR", 
                                     "tags" => $full_fill['it_easy_other_order_id'], 
                                  ],
                                  
                            ]; 
                            
                            echo "<pre>"; print_r($jayParsedAry); 
                            $request_url4 = "https://nutriherbs2.myshopify.com/admin/api/2022-04/orders.json";
                            
                            $username = 'd6154e3f68d5e20805a028b8af849bda';
                            $password = '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'; 
                                        
                            $request_handle4 = curl_init($request_url4);
                            curl_setopt($request_handle4, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
                            curl_setopt($request_handle4, CURLOPT_USERPWD, $username . ":" . $password); 
                            
                            curl_setopt($request_handle4, CURLOPT_POST, true);
                            
                            $headers = array(
                               "Content-Type: application/json",
                            );
                            curl_setopt($request_handle4, CURLOPT_HTTPHEADER, $headers);
                            
                            curl_setopt($request_handle4, CURLOPT_POSTFIELDS, json_encode($jayParsedAry));
                            curl_setopt($request_handle4, CURLOPT_RETURNTRANSFER, true);
                             $request_result4 = curl_exec($request_handle4);
                            // echo $request_result; die;
                            $data_val4 = json_decode($request_result4);
                            // echo "<pre>"; print_r($data_val4); die;
                            if(!empty($data_val4->order->id) && isset($data_val4->order->id)){
                                $find_order = ItEasyOrder::findOne(['it_easy_order_id' => $full_fill['it_easy_order_id']]);
                                $find_order->shopify_order_id = $data_val4->order->id;
                                
                                $find_order->it_easy_other_order_id = str_replace("#","s",$data_val4->order->name);
                                $find_order->save(false);
                                
                                
$shopify_order9 = $find_order->shopify_order_id;
$request_url8 = "https://nutriherbs2.myshopify.com/admin/api/2022-10/orders/".$shopify_order9."/fulfillment_orders.json";

$username = 'd6154e3f68d5e20805a028b8af849bda';
//$username = '3b995aa264af00948231c2382e00a433';         
$password = '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'; 
            
$request_handle8 = curl_init($request_url8);
curl_setopt($request_handle8, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
curl_setopt($request_handle8, CURLOPT_USERPWD, $username . ":" . $password); 
curl_setopt($request_handle8, CURLOPT_RETURNTRANSFER, true);
 $request_result8 = curl_exec($request_handle8);

$data_val8 = json_decode($request_result8);
echo "<pre>"; print_r($data_val); 
if(!empty($data_val8)){
    
    $line_item8 =  $data_val8->fulfillment_orders[0]->line_items[0]->id;
    $fullfilled_id8 = $data_val8->fulfillment_orders[0]->line_items[0]->fulfillment_order_id;
    $fullfilled_array2 = [];
    foreach($data_val8->fulfillment_orders[0]->line_items as $key6 => $line_items){
        $fullfilled_array2[$key6]['id'] = $line_items->id;
        $fullfilled_array2[$key6]['quantity'] = $line_items->quantity;
    }
    
    
    
    
    $awb_number = $full_fill['it_easy_awb_number'];
    if($full_fill['it_easy_shipping_id'] == '2'){
        $courier_name = 'Ecom Express';
        $courier_url = "https://ecomexpress.in/tracking/";
    }else if($full_fill['it_easy_shipping_id'] == '3'){
        $courier_name = 'XPRESSBEES';
        $courier_url = "https://www.xpressbees.com/track";
    }else if($full_fill['it_easy_shipping_id'] == '1'){
        $courier_name = 'Delhivery';
        $courier_url = "https://www.delhivery.com/";
    }else if($full_fill['it_easy_shipping_id'] == '4'){
        $courier_name = 'Shipdelight';
        $courier_url = "https://track.shipdelight.com/";
    }else if($full_fill['it_easy_shipping_id'] == '6'){
        $courier_name = 'Ecom Express AIR';
        $courier_url = "https://ecomexpress.in/tracking/";
    }else if($full_fill['it_easy_shipping_id'] == '5'){
        $courier_name = 'India Post';
        $courier_url = "https://www.indiapost.gov.in/vas/Pages/IndiaPostHome.aspx";
    }else if($full_fill['it_easy_shipping_id'] == '7'){
        if($full_fill['it_easy_subcourier_name'] == 'Bluedart- Surface'){
        $courier_name = 'Bluedart';
        $courier_url = "https://www.bluedart.com/tracking";
        }else{
            $courier_name = 'Delhivery';
	        $courier_url = "https://www.delhivery.com/";
        }
    }
    
    
    $request_url9 = "https://nutriherbs2.myshopify.com/admin/api/2022-10/fulfillments.json";
    //echo $request_url; 
    $username = 'd6154e3f68d5e20805a028b8af849bda';
      
    $password = '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';          
                
    $request_handle9 = curl_init($request_url9);
    curl_setopt($request_handle9, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    curl_setopt($request_handle9, CURLOPT_USERPWD, $username . ":" . $password); 
    $headers = array(
       "Content-Type: application/json",
    );
    curl_setopt($request_handle9, CURLOPT_HTTPHEADER, $headers);
    
     $jayParsedAry2 = [
      "fulfillment" => [
             "message" => "The package was shipped this morning.", 
             "notify_customer" => false, 
             "tracking_info" => [
                "number" => $awb_number, 
                "url" => $courier_url, 
                "company" => $courier_name 
             ], 
             "line_items_by_fulfillment_order" => [
                  [
                      "fulfillment_order_id" => $fullfilled_id8, 
                      "fulfillment_order_line_items" => $fullfilled_array2 
                  ] 
                ] 
          ] 
    ]; 
    

    curl_setopt($request_handle9, CURLOPT_POSTFIELDS, json_encode($jayParsedAry2));
    
    curl_setopt($request_handle9, CURLOPT_RETURNTRANSFER, true);
    $request_result9 = curl_exec($request_handle9);
    
    $data_val9 = json_decode($request_result9);
    echo "<pre>"; print_r($data_val9);
    if(isset($data_val9->fulfillment->id) && !empty($data_val9->fulfillment->id)){
        $find_order = ItEasyOrder::findOne(['it_easy_order_id' => $full_fill['it_easy_order_id']]);
        $find_order->shopify_fullfillment_id = $fullfilled_id8;
        
        $find_order->it_easy_push_status = '1';
        $find_order->save(false);
        
        $shopify_order = $full_fill['shopify_order_id'];
        $request_url15 = "https://nutriherbs2.myshopify.com/admin/api/2023-01/orders/".$shopify_order."/cancel.json";

        $username = 'd6154e3f68d5e20805a028b8af849bda';
        $password = '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'; 
                    
        $request_handle15 = curl_init($request_url15);
        curl_setopt($request_handle15, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($request_handle15, CURLOPT_USERPWD, $username . ":" . $password); 
        
        curl_setopt($request_handle15, CURLOPT_POST, true);
        
        $headers = array(
           "Content-Type: application/json",
        );
        curl_setopt($request_handle15, CURLOPT_HTTPHEADER, $headers);
        
        curl_setopt($request_handle15, CURLOPT_RETURNTRANSFER, true);
         $request_result15 = curl_exec($request_handle15);
        // echo $request_result; die;
        $data_val15 = json_decode($request_result15);
        echo "<pre>"; print_r($data_val15);

        echo "<pre>"; print_r($find_order);
    }
    
    
    
    
    
}




                            }
                        
                        
                        
                    
                    }
                }
                
                // echo "<pre>"; print_r($order_product); 
                // echo "<pre>"; print_r($full_fill); 
            }
        }    
    }
    
    public function actionTrackOrder(){
        date_default_timezone_set("Asia/Kolkata");
        $current_date = date('Y-m-d H:i:s');
        // $cronModel = new CronTest();
        // $cronModel->type = 'Ecom-track';
        // $cronModel->created_time = $current_date;
        // $cronModel->save(false);
        //$array = ['failed', 'Pending_order', 'RTO DELIVERED', 'DELIVERED'];
        $shipping_id = '1';
        // $orders = ItEasyOrderDispatch::find()->select(['it_easy_awb_number'])->where(['not in','it_easy_order_status',$array])->andWhere(['it_easy_shipping_id' => $shipping_id])->limit(600)->asArray()->all();
        $orders = ItEasyOrderDispatch::find()->select(['it_easy_awb_number'])->andWhere(['it_easy_shipping_id' => $shipping_id])->andWhere(['it_easy_order_id' => '11433'])->limit(80)->asArray()->all();
        // echo "<pre>"; print_r($orders); die;
            $awb_number = [];
            $r = 1;
            $s =0;
        foreach($orders as $key => $value){
            if($r < 11){
                $awb_number[$s][] = $value['it_easy_awb_number'];
                $r++;
            }else{
                $r = 1;
                $s++;
                $awb_number[$s][] = $value['it_easy_awb_number'];
                $r++;
            }
        }
        $orderModel = new ItEasyOrderTrack();
        $awb_details = $orderModel->getTrackDelhivery($awb_number);
    }

    public function actionSaveoldOrder(){
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        $query = (new \yii\db\Query())->from('oc_order')->orderBy(['order_id' => SORT_ASC])->limit(500)->offset(17000);
        // ->offset(16000)
        $command = $query->createCommand();
        $data = $command->queryAll();

        // echo "<pre>"; print_r($data);


        if(!empty($data)){
            foreach ($data as $key => $order) {
                $find_order = ItEasyOrder::findOne(['it_easy_order_id' => $order['order_id']]);
                if(empty($find_order)){
                    $state_id = ItEasyState::getStatedatabyStateName($order['payment_zone']);
                    if(empty($state_id)){
                        echo "<pre>"; print_r($order); die;
                    }
                    $orderModel = new ItEasyOrder(); 
                    $orderModel->it_easy_order_id = $order['order_id']; //$orderModel->it_easy_financial_year = '2023_2024';
                    $orderModel->it_easy_financial_year = '2025_2026';
                    $orderModel->it_easy_order_number = $order['order_id']; $orderModel->it_easy_store_id = '1';
                    $orderModel->it_easy_invoice_number = $order['invoice_prefix'].'-'.$order['invoice_no']; $orderModel->it_easy_store_name = 'Nutriherbs';
                    $orderModel->it_easy_other_order_id = $order['heeb_id']; $orderModel->it_easy_firstname = $order['firstname'];
                    $orderModel->it_easy_lastname = $order['lastname']; $orderModel->it_easy_mobile_number = $order['telephone'];
                    $orderModel->it_easy_alternate_number = $order['alternate_telephone']; $orderModel->it_easy_email = $order['email'];
                    $orderModel->it_easy_address_1 = $order['payment_address_1']; $orderModel->it_easy_address_2 = $order['payment_address_2'];
                    $orderModel->it_easy_city = $order['payment_city']; $orderModel->it_easy_state = $order['payment_zone'];
                    $orderModel->it_easy_state_id = $state_id->it_easy_id; $orderModel->it_easy_pincode = $order['payment_postcode'];
                    $orderModel->it_easy_fax = $order['order_id']; $orderModel->it_easy_country = 'IN';
                    $orderModel->it_easy_disease_name = ''; $orderModel->it_easy_course_duration = '1 month';
                    $orderModel->it_easy_age = ''; $orderModel->it_easy_shipping_firstname = $order['firstname']; 
                    $orderModel->it_easy_shipping_lastname =  $order['lastname']; $orderModel->it_easy_shipping_mobile_number = $order['telephone']; 
                    $orderModel->it_easy_shipping_alternate_number =  $order['alternate_telephone']; $orderModel->it_easy_shipping_email = $order['email']; 
                    $orderModel->it_easy_shipping_address_1 = $order['payment_address_1']; $orderModel->it_easy_shipping_address_2 = $order['payment_address_1'];
                    $orderModel->it_easy_shipping_city = $order['payment_address_1']; $orderModel->it_easy_shipping_state = $order['payment_zone']; 
                    $orderModel->it_easy_shipping_state_id = $state_id->it_easy_id; $orderModel->it_easy_shipping_pincode = $order['payment_postcode']; 
                    $orderModel->it_easy_shipping_country = 'IN'; $orderModel->it_easy_billing_company_name = '';
                    $orderModel->it_easy_billing_gst_status = 'No'; $orderModel->it_easy_billing_gst = ''; 
                    $orderModel->it_easy_billing_firstname = $order['firstname']; $orderModel->it_easy_billing_lastname = $order['lastname']; 
                    $orderModel->it_easy_billing_mobile = $order['telephone']; $orderModel->it_easy_billing_alternate_number = $order['alternate_telephone'];
                    $orderModel->it_easy_billing_email = $order['email']; $orderModel->it_easy_billing_address_1 = $order['payment_address_1']; 
                    $orderModel->it_easy_billing_address_2 = $order['payment_address_2']; $orderModel->it_easy_billing_city = $order['payment_city']; 
                    $orderModel->it_easy_billing_state = $order['payment_zone']; $orderModel->it_easy_billing_state_id = $state_id->it_easy_id;
                    $orderModel->it_easy_billing_pincode = $order['payment_postcode']; $orderModel->it_easy_billing_country = 'IN'; 
                    if($order['payment_code']  == 'cod'){
                        if( $order['payment_method'] == 'razorpay'){
                            $orderModel->it_easy_payment_code = 'Prepaid';
                            $orderModel->it_easy_payment_method = 'Razor Pay/Payment Gateway';
                        }else if($order['payment_method'] == 'Razorpay Secure'){
                            $orderModel->it_easy_payment_code = 'Prepaid';
                            $orderModel->it_easy_payment_method = 'Razor Pay/Payment Gateway';
                        }else{
                            $orderModel->it_easy_payment_code = 'COD';
                            $orderModel->it_easy_payment_method = 'Cash on Delivery';
                        }
                    }else if($order['payment_code']  == 'paytm'){
                        $orderModel->it_easy_payment_code = 'UPI';
                        $orderModel->it_easy_payment_method = 'UPI Transfer';
                    }else if($order['payment_code']  == 'payu'){
                        $orderModel->it_easy_payment_code = 'Prepaid';
                        $orderModel->it_easy_payment_method = 'Razor Pay/Payment Gateway';
                    }


                    $orderModel->it_easy_shipping_method = 'Free Shipping'; $orderModel->it_easy_shipping_code = 'Free Shipping';
                    $orderModel->it_easy_order_serviceable = ItEasyOrder::getServicealAPIbyPincode($order['payment_postcode']); $orderModel->it_easy_ordered_amount = $order['total']; 
                    $orderModel->it_easy_total_price = $order['total']; $orderModel->it_easy_gst_price = round($order['total'] * 12 / 100); 
                    $orderModel->it_easy_product_quantity = '1'; 
                    
                    
                    $orderModel->it_easy_order_status_id = $this->getStatusid($order['order_status_id']);
                    $orderModel->it_easy_order_disposition_id = $this->getDispositionid($order['order_disposition_id']);
                    

                    if($order['initial_order_status_id']  == 'cod'){
                        $orderModel->it_easy_first_status = 'COD';
                    }else if($order['initial_order_status_id']  == 'lead'){
                        $orderModel->it_easy_first_status = 'Lead';
                    }

                    $orderModel->it_easy_department_id = '4';
                    


                    if($order['assigned_from']  == '287'){
                        $orderModel->it_easy_assigned_by = '18';
                    }

                    if($order['assigned_to']  == '190'){
                        $orderModel->it_easy_assigned_to = '3';
                    }else if($order['assigned_to']  == '221'){
                        $orderModel->it_easy_assigned_to = '4';
                    }else if($order['assigned_to']  == '229'){
                        $orderModel->it_easy_assigned_to = '5';
                    }else if($order['assigned_to']  == '254'){
                        $orderModel->it_easy_assigned_to = '6';
                    }else if($order['assigned_to']  == '289'){
                        $orderModel->it_easy_assigned_to = '7';
                    }else if($order['assigned_to']  == '293'){
                        $orderModel->it_easy_assigned_to = '8';
                    }else if($order['assigned_to']  == '299'){
                        $orderModel->it_easy_assigned_to = '9';
                    }else if($order['assigned_to']  == '302'){
                        $orderModel->it_easy_assigned_to = '10';
                    }else if($order['assigned_to']  == '328'){
                        $orderModel->it_easy_assigned_to = '11';
                    }else if($order['assigned_to']  == '339'){
                        $orderModel->it_easy_assigned_to = '12';
                    }else if($order['assigned_to']  == '343'){
                        $orderModel->it_easy_assigned_to = '13';
                    }else if($order['assigned_to']  == '357'){
                        $orderModel->it_easy_assigned_to = '14';
                    }else if($order['assigned_to']  == '364'){
                        $orderModel->it_easy_assigned_to = '15';
                    }else if($order['assigned_to']  == '369'){
                        $orderModel->it_easy_assigned_to = '16';
                    }else if($order['assigned_to']  == '376'){
                        $orderModel->it_easy_assigned_to = '17';
                    }
                    $orderModel->it_easy_marketer_publisher = $order['affiliate'];
                    $orderModel->it_easy_read_status = $order['read_status'];

                    $orderModel->it_easy_address_verify_by = '2';

                    $orderModel->shopify_order_id = $order['shopify_order_id'];

                    $orderModel->it_easy_created_time = $order['date_added'];

                    $orderModel->it_easy_updated_time = $order['date_modified'];

                    $orderModel->it_easy_assign_time = '';

                    $orderModel->it_easy_lead_assign = $order['lead_assign_date'];

                    $orderModel->it_easy_converted_time = '';
                    $orderModel->it_easy_placed_time = $order['order_placed_date'];

                    $orderModel->it_easy_delivered_time = '';
                    // $orderModel->save(false);
                    $find_customer_data = ItEasyCustomer::FindCustomerbyMobile($order['telephone']);



                    if(empty($find_customer_data)){
                        $find_customer_data = ItEasyCustomer::SavecustomerModelFromMobileArray($orderModel, $orderModel->it_easy_order_id);
                        $orderModel->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
                    }else{
                        $orderModel->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
                        if(!empty($find_customer_data->it_easy_order_ids)){
                            $customer_it_easy_order_ids = explode(',', $find_customer_data->it_easy_order_ids);
                            if (!in_array($orderModel->it_easy_order_id, $customer_it_easy_order_ids)){
                                $find_customer_data->it_easy_order_ids = $find_customer_data->it_easy_order_ids.','.$orderModel->it_easy_order_id;
                                $find_customer_data->save();
                            }
                        }
                    }

                    $status_query = (new \yii\db\Query())->from('oc_order_history')->where(['order_id' => $order['order_id']]);
                    $status_command = $status_query->createCommand();
                    $status_data = $status_command->queryAll();
                    if(!empty($status_data)){
                        foreach ($status_data as $key => $status) {
                            $status_id_order = $this->getStatusid($status['order_status_id']);
                            $model_status = new ItEasyOrderStatusHistory();
                            $model_status->it_easy_order_id = $orderModel->it_easy_order_id;
                            $model_status->it_easy_order_status_id = $status_id_order;
                            $model_status->it_easy_comment = $status['comment'];
                            $model_status->it_easy_created_time = $status['date_added'];
                            $model_status->save(false);
                        }
                    }

                    $disposition_query = (new \yii\db\Query())->from('oc_dispotion_order_history')->where(['order_id' => $order['order_id']]);
                    $disposition_command = $disposition_query->createCommand();
                    $disposition_data = $disposition_command->queryAll();
                    if(!empty($disposition_data)){
                        foreach ($disposition_data as $key => $disposition) {
                            $disposition_id_order = $this->getDispositionid($disposition['dispotion_id']);
                            $model_status2 = new ItEasyOrderDispositionHistory();
                            $model_status2->it_easy_order_id = $orderModel->it_easy_order_id;
                            $model_status2->it_easy_order_disposition_id = $disposition_id_order;
                            $model_status2->it_easy_comment = $disposition['comment'];
                            $model_status2->it_easy_created_time = $disposition['date_added'];
                            $model_status2->save(false);
                        }
                    }


                    $product_query = (new \yii\db\Query())->from('oc_order_product')->where(['order_id' => $order['order_id']]);
                    $product_command = $product_query->createCommand();
                    $product_data = $product_command->queryAll();
                    // echo "<pre>"; print_r($product_data); 
                    if(!empty($product_data)){
                        foreach($product_data as $key => $product){
                            
                            $orderProductModel = new ItEasyOrderProduct();
                            $orderProductModel->it_easy_order_id = $orderModel->it_easy_order_id;
                            
                            switch ($product['name']) {
                              case "Ashwagandha with Tribulus Terrestris":
                                $orderProductModel->it_easy_product_id = '12';
                                $orderProductModel->it_easy_variation_id = '4';
                                $orderProductModel->it_easy_product_name = 'Ashwagandha with Tribulus Terrestris';
                                $orderProductModel->it_easy_variation_name = 'Combo Pack of 2';
                                break;
                              case "Nutriherbs Ashwagandha with Tribulus Terrestris 60 capsule Pack 1":
                                $orderProductModel->it_easy_product_id = '28';
                                $orderProductModel->it_easy_variation_id = '1';
                                $orderProductModel->it_easy_product_name = 'Ashwagandha with Tribulus Terrestris 60 capsule';
                                $orderProductModel->it_easy_variation_name = 'Pack of 1';
                                break;
                                case "Ashwagandha with Tribulus Terrestris 60 capsule Pack 1":
                                $orderProductModel->it_easy_product_id = '28';
                                $orderProductModel->it_easy_variation_id = '1';
                                $orderProductModel->it_easy_product_name = 'Ashwagandha with Tribulus Terrestris 60 capsule';
                                $orderProductModel->it_easy_variation_name = 'Pack of 1';
                                break;
                                
                                case "NutriHerbs Glow Builder with the Blend of 48 Super Food (15 Sachets)":
                                $orderProductModel->it_easy_product_id = '1';
                                $orderProductModel->it_easy_variation_id = '8';
                                $orderProductModel->it_easy_product_name = 'Glow Builder with the Blend of 48 Super Food';
                                $orderProductModel->it_easy_variation_name = '15 sachets';
                                break;
                                
                                case "Nutriherbs Guggul Extract an Anti-Inflammatory Supplement 60Caps":
                                $orderProductModel->it_easy_product_id = '38';
                                $orderProductModel->it_easy_variation_id = '11';
                                $orderProductModel->it_easy_product_name = 'Guggul Extract ';
                                $orderProductModel->it_easy_variation_name = '60 Capsules';
                                break;
                                
                                case "Nutriherbs Safed Musli 800 Mg 60 Capsules 100% Natural &amp; Organic (Pack Of 1)":
                                $orderProductModel->it_easy_product_id = '10';
                                $orderProductModel->it_easy_variation_id = '11';
                                $orderProductModel->it_easy_product_name = 'Safed Musli Extract Boosts Performance';
                                $orderProductModel->it_easy_variation_name = '60 Capsules';
                                break;
                                
                                
                                
                                
                                case "Nutriherbs Raspberry Ketone for Slimmer Body":
                                $orderProductModel->it_easy_product_id = '44';
                                $orderProductModel->it_easy_variation_id = '11';
                                $orderProductModel->it_easy_product_name = 'Raspberry Ketone ';
                                $orderProductModel->it_easy_variation_name = '60 Capsules';
                                break;
                                
                                case "Nutriherbs Oh Yes Capsules Boosts Energy &amp; Stamina Pack of 1":
                                $orderProductModel->it_easy_product_id = '43';
                                $orderProductModel->it_easy_variation_id = '11';
                                $orderProductModel->it_easy_product_name = 'Nutriherbs Oh Yes Capsules ';
                                $orderProductModel->it_easy_variation_name = '60 Capsules';
                                break;
                                
                                
                                
                                
                                case "NutriHerbs Glow Builder with the Blend of 48 Super Food (Sachets)":
                                $orderProductModel->it_easy_product_id = '1';
                                $orderProductModel->it_easy_variation_id = '10';
                                $orderProductModel->it_easy_product_name = 'Glow Builder with the Blend of 48 Super Food';
                                $orderProductModel->it_easy_variation_name = '15 sachets';
                                break;
                                
                                
                                case "NutriHerbs Glow Builder with the Blend of 48 Super Food ( Sachets )":
                                $orderProductModel->it_easy_product_id = '1';
                                $orderProductModel->it_easy_variation_id = '10';
                                $orderProductModel->it_easy_product_name = 'Glow Builder with the Blend of 48 Super Food';
                                $orderProductModel->it_easy_variation_name = '60 sachets';
                                break;
                                
                                case "Nutriherbs Brain Tea (Infusion Bags) Pack of 1":
                                $orderProductModel->it_easy_product_id = '18';
                                $orderProductModel->it_easy_variation_id = '11';
                                $orderProductModel->it_easy_product_name = 'Brain Tea (Infusion Bags)';
                                $orderProductModel->it_easy_variation_name = '60 Capsules';
                                break;
                                
                                case "Nutriherbs Slimfast Fat Burner for Men and Women":
                                $orderProductModel->it_easy_product_id = '17';
                                $orderProductModel->it_easy_variation_id = '11';
                                $orderProductModel->it_easy_product_name = 'Slimfast Fat Burner for Men and Women';
                                $orderProductModel->it_easy_variation_name = '60 Capsules';
                                break;
                                
                                case "NutriHerbs Glow Builder with the Blend of 48 Super Food (30 Sachets)":
                                $orderProductModel->it_easy_product_id = '1';
                                $orderProductModel->it_easy_variation_id = '9';
                                $orderProductModel->it_easy_product_name = 'Glow Builder with the Blend of 48 Super Food';
                                $orderProductModel->it_easy_variation_name = '30 sachets';
                                break;
                                
                                case "Nutriherbs L Glutathione Capsules With Vitamin C, E & Grape Seed Extract":
                                $orderProductModel->it_easy_product_id = '3';
                                $orderProductModel->it_easy_variation_id = '1';
                                $orderProductModel->it_easy_product_name = 'Glutathione Capsules With Vitamin C, E & Grape Seed Extract';
                                $orderProductModel->it_easy_variation_name = 'Pack of 1';
                                break;
                                
                                
                                case "Nutriherbs L Glutathione Capsules With Vitamin C, E &amp; Grape Seed Extract":
                                $orderProductModel->it_easy_product_id = '3';
                                $orderProductModel->it_easy_variation_id = '2';
                                $orderProductModel->it_easy_product_name = 'Glutathione Capsules With Vitamin C, E & Grape Seed Extract';
                                $orderProductModel->it_easy_variation_name = 'Pack of 2';
                                break;
                                
                                
                                case "Nutriherbs Shilajit with Ashwagandha (60 Caps)":
                                $orderProductModel->it_easy_product_id = '11';
                                $orderProductModel->it_easy_variation_id = '11';
                                $orderProductModel->it_easy_product_name = 'Shilajit Extract Capsules for Muscle Growth & Endurance';
                                $orderProductModel->it_easy_variation_name = '60 Capsules';
                                break;
                                
                                
                                case "Nutriherbs Shilajit Resin with Kesar-15gm":
                                $orderProductModel->it_easy_product_id = '5';
                                $orderProductModel->it_easy_variation_id = '5';
                                $orderProductModel->it_easy_product_name = 'Shilajit Resin kesar Flavour';
                                $orderProductModel->it_easy_variation_name = '15 gram';
                                break;
                                
                                case "Pure Shilajit Resin with Kesar":
                                $orderProductModel->it_easy_product_id = '5';
                                $orderProductModel->it_easy_variation_id = '5';
                                $orderProductModel->it_easy_product_name = 'Shilajit Resin kesar Flavour';
                                $orderProductModel->it_easy_variation_name = '15 gram';
                                break;
                                
                                case "Nutriherbs Shilajit Resin with Kesar-15gm (Pack of 3)":
                                $orderProductModel->it_easy_product_id = '5';
                                $orderProductModel->it_easy_variation_id = '7';
                                $orderProductModel->it_easy_product_name = 'Shilajit Resin kesar Flavour';
                                $orderProductModel->it_easy_variation_name = '45 gram';
                                break;
                                
                                
                                case "Nutriherbs Shilajit Resin with Kesar-15gm (Pack of 2)":
                                $orderProductModel->it_easy_product_id = '5';
                                $orderProductModel->it_easy_variation_id = '6';
                                $orderProductModel->it_easy_product_name = 'Shilajit Resin kesar Flavour';
                                $orderProductModel->it_easy_variation_name = '30 gram';
                                break;
                                
                                case "Nutriherbs Shilajit Resin-15gm (Pack of 3)":
                                $orderProductModel->it_easy_product_id = '26';
                                $orderProductModel->it_easy_variation_id = '7';
                                $orderProductModel->it_easy_product_name = 'Shilajit Resin Normal Flavour';
                                $orderProductModel->it_easy_variation_name = '45 gram';
                                break;
                                
                                
                                
                                case "Nutriherbs Shilajit Resin":
                                $orderProductModel->it_easy_product_id = '26';
                                $orderProductModel->it_easy_variation_id = '5';
                                $orderProductModel->it_easy_product_name = 'Shilajit Resin Normal Flavour';
                                $orderProductModel->it_easy_variation_name = '15 gram';
                                break;
                                
                                
                                case "Nutriherbs Shilajit Resin-15gm":
                                $orderProductModel->it_easy_product_id = '26';
                                $orderProductModel->it_easy_variation_id = '5';
                                $orderProductModel->it_easy_product_name = 'Shilajit Resin Normal Flavour';
                                $orderProductModel->it_easy_variation_name = '15 gram';
                                break;
                                
                                case "Shilajit Resin":
                                $orderProductModel->it_easy_product_id = '26';
                                $orderProductModel->it_easy_variation_id = '5';
                                $orderProductModel->it_easy_product_name = 'Shilajit Resin Normal Flavour';
                                $orderProductModel->it_easy_variation_name = '15 gram';
                                break;
                                
                                case "Shilajit Resin":
                                $orderProductModel->it_easy_product_id = '26';
                                $orderProductModel->it_easy_variation_id = '5';
                                $orderProductModel->it_easy_product_name = 'Shilajit Resin Normal Flavour';
                                $orderProductModel->it_easy_variation_name = '15 gram';
                                break;
                                
                              case "Shilajit Resin Pack of 1":
                                $orderProductModel->it_easy_product_id = '26';
                                $orderProductModel->it_easy_variation_id = '5';
                                $orderProductModel->it_easy_product_name = 'Shilajit Resin Normal Flavour';
                                $orderProductModel->it_easy_variation_name = '15 gram';
                                break;
                              default:
                                $orderProductModel->it_easy_product_id = '0';
                                $orderProductModel->it_easy_variation_id = '1';
                                $orderProductModel->it_easy_product_name = $product['name'];
                                $orderProductModel->it_easy_variation_name = 'Pack of 1';
                            }

                            $orderProductModel->it_easy_product_quantity = $product['quantity'];
                            
                            $orderProductModel->it_easy_product_tax = round($product['total'] * 12 / 100);
                            
                            $orderProductModel->it_easy_product_total = $product['total'];
                            $orderProductModel->it_easy_product_price = $product['total'] - $orderProductModel->it_easy_product_tax;
                            
                            $orderProductModel->created_time = date('Y-m-d H:i:s');
                            // echo "<pre>"; print_r($orderProductModel);
                            $orderProductModel->save(false);
                        }
                    }
                            // die;

                    if($orderModel->it_easy_payment_code == 'COD'){
                        $ordet_type = 'COD';
                        $collective_price = $orderModel->it_easy_total_price;
                    }else{
                        $ordet_type = 'Prepaid';
                        $collective_price = '0.00';
                    }
                    $awb_query = (new \yii\db\Query())->from('oc_order_awb_number')->where(['order_id' => $order['order_id']]);
                    $awb_command = $awb_query->createCommand();
                    $awb_data = $awb_command->queryOne();
                    // echo "<pre>"; print_r($awb_data); 
                    if(!empty($awb_data)){
                        if($awb_data['api_id'] == '18'){
                            $shipid = '3';
                            $shiping_courier_name = 'Xpressbees';
                        }else if($awb_data['api_id'] == '4'){
                            $shipid = '2';
                            $shiping_courier_name = 'Ecom Express';
                        }else if($awb_data['api_id'] == '8'){
                            $shipid = '1';
                            $shiping_courier_name = 'Delhivery';
                        }else if($awb_data['api_id'] == '13'){
                            $shipid = '5';
                            $shiping_courier_name = 'India Post';
                        }else if($awb_data['api_id'] == '16'){
                            $shipid = '4';
                            $shiping_courier_name = 'Shipdelight';
                        }else if($awb_data['api_id'] == '27'){
                            $shipid = '6';
                            $shiping_courier_name = 'Ecom Express AIR';
                        }
                        $zone_name = ItEasyZonePincode::find()->where(['it_easy_pincode' => $order['payment_postcode'] ])->one();
                        // echo $order['payment_postcode'];
                        // echo "<pre>"; print_r($zone_name); die;


                        $order_dispatch = new ItEasyOrderDispatch();
                        $order_dispatch->it_easy_order_id              = $orderModel->it_easy_order_id;
                        $order_dispatch->it_easy_order_number          = $orderModel->it_easy_order_number;
                        $order_dispatch->it_easy_shipping_id           = $shipid;
                        $order_dispatch->it_easy_user_id               = $orderModel->it_easy_customer_id;
                        $order_dispatch->it_easy_department_id         = '6';
                        $order_dispatch->it_easy_awb_number            = $awb_data['awb_number'];
                        $order_dispatch->it_easy_order_type            = $ordet_type;
                        $order_dispatch->it_easy_firstname             = $orderModel->it_easy_shipping_firstname;
                        $order_dispatch->it_easy_lastname              = $orderModel->it_easy_shipping_lastname;
                        $order_dispatch->it_easy_address_1             = $orderModel->it_easy_shipping_address_1;
                        $order_dispatch->it_easy_address_2             = $orderModel->it_easy_shipping_address_2;
                        $order_dispatch->it_easy_city                  = $orderModel->it_easy_shipping_city;
                        $order_dispatch->it_easy_state                 = $orderModel->it_easy_shipping_state;
                        $order_dispatch->it_easy_state_id              = $orderModel->it_easy_shipping_state_id;
                        $order_dispatch->it_easy_pincode               = $orderModel->it_easy_shipping_pincode;
                        $order_dispatch->it_easy_mobile                = $orderModel->it_easy_shipping_mobile_number;
                        $order_dispatch->it_easy_email                 = $orderModel->it_easy_shipping_email;
                        $order_dispatch->it_easy_alternate_mobile      = $orderModel->it_easy_shipping_alternate_number;
                        $order_dispatch->it_easy_price                 = $orderModel->it_easy_total_price;
                        $order_dispatch->it_easy_collective_price      = $collective_price;
                        $order_dispatch->it_easy_order_date            = '';
                        $order_dispatch->it_easy_dispatch_time         = '';
                        $order_dispatch->it_easy_awb_time           =  $awb_data['date_added'];
                        $order_dispatch->it_easy_return_awb            = '';
                        $order_dispatch->it_easy_pickup_time           = '';
                        if(!empty($zone_name)){
                            $order_dispatch->it_easy_zone_name             = $zone_name->it_easy_zone_name;
                        }else{
                            $order_dispatch->it_easy_zone_name             = 'Zone A';
                        }
                        $order_dispatch->it_easy_courier_name          = $shiping_courier_name;
                        $order_dispatch->it_easy_subcourier_name       = $shiping_courier_name;
                        $order_dispatch->it_easy_order_status          = 'Order Manifest';
                        $order_dispatch->it_easy_courier_comment       = '';
                        $order_dispatch->it_easy_status_updated_at     = $awb_data['pickup_date_added'];
                        $order_dispatch->it_easy_first_scan_date       = '';
                        $order_dispatch->it_easy_last_scan_date        = '';
                        $order_dispatch->it_easy_first_attempted_date  = '';
                        $order_dispatch->it_easy_last_attempted_date   = '';
                        $order_dispatch->it_easy_delivery_date         = '';
                        $order_dispatch->it_easy_route_code            = '';
                        $order_dispatch->it_easy_picked                = '1';
                        $order_dispatch->it_easy_auto_rto_date         = '';
                        $order_dispatch->it_easy_rto_date              = '';
                        $order_dispatch->it_easy_attempt_count         = '';
                        $order_dispatch->it_easy_courier_price         = '';
                        $order_dispatch->it_easy_rto_updated_by        = '';
                        $order_dispatch->save(false);
                    }

                    $orderModel->save(false);
                }
            }
        }
    }
    
    public function actionSaveoldOrderawb(){
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        $query = (new \yii\db\Query())->from('oc_order')->orderBy(['order_id' => SORT_ASC])->limit(500)->offset(17000);
        // ->offset(16000)
        $command = $query->createCommand();
        $data = $command->queryAll();

        // echo "<pre>"; print_r($data);


        if(!empty($data)){
            foreach ($data as $key => $order) {
                $orderModel = ItEasyOrder::findOne(['it_easy_order_id' => $order['order_id']]);
                if(!empty($orderModel)){
                    
                    
                            // die;

                    if($orderModel->it_easy_payment_code == 'COD'){
                        $ordet_type = 'COD';
                        $collective_price = $orderModel->it_easy_total_price;
                    }else{
                        $ordet_type = 'Prepaid';
                        $collective_price = '0.00';
                    }
                    $awb_query = (new \yii\db\Query())->from('oc_order_awb_number')->where(['order_id' => $order['order_id']]);
                    $awb_command = $awb_query->createCommand();
                    $awb_data = $awb_command->queryOne(); 
                    if(!empty($awb_data)){
                        
                        $order_dispatch_model = ItEasyOrderDispatch::findOne(['it_easy_order_id' => $order['order_id']]);
                            
                        if(empty($order_dispatch_model)){
                            $state_id = ItEasyState::getStatedatabyStateName($order['payment_zone']);
                            if($awb_data['api_id'] == '18'){
                                $shipid = '3';
                                $shiping_courier_name = 'Xpressbees';
                            }else if($awb_data['api_id'] == '4'){
                                $shipid = '2';
                                $shiping_courier_name = 'Ecom Express';
                            }else if($awb_data['api_id'] == '8'){
                                $shipid = '1';
                                $shiping_courier_name = 'Delhivery';
                            }else if($awb_data['api_id'] == '13'){
                                $shipid = '5';
                                $shiping_courier_name = 'India Post';
                            }else if($awb_data['api_id'] == '16'){
                                $shipid = '4';
                                $shiping_courier_name = 'Shipdelight';
                            }else if($awb_data['api_id'] == '27'){
                                $shipid = '6';
                                $shiping_courier_name = 'Ecom Express AIR';
                            }
                            $zone_name = ItEasyZonePincode::find()->where(['it_easy_pincode' => $order['payment_postcode'] ])->one();
                            // echo $order['payment_postcode'];
                            // echo "<pre>"; print_r($zone_name); die;
    
    
                            $order_dispatch = new ItEasyOrderDispatch();
                            $order_dispatch->it_easy_order_id              = $orderModel->it_easy_order_id;
                            $order_dispatch->it_easy_order_number          = $orderModel->it_easy_order_number;
                            $order_dispatch->it_easy_shipping_id           = $shipid;
                            $order_dispatch->it_easy_user_id               = $orderModel->it_easy_customer_id;
                            $order_dispatch->it_easy_department_id         = '6';
                            $order_dispatch->it_easy_awb_number            = $awb_data['awb_number'];
                            $order_dispatch->it_easy_order_type            = $ordet_type;
                            $order_dispatch->it_easy_firstname             = $orderModel->it_easy_shipping_firstname;
                            $order_dispatch->it_easy_lastname              = $orderModel->it_easy_shipping_lastname;
                            $order_dispatch->it_easy_address_1             = $orderModel->it_easy_shipping_address_1;
                            $order_dispatch->it_easy_address_2             = $orderModel->it_easy_shipping_address_2;
                            $order_dispatch->it_easy_city                  = $orderModel->it_easy_shipping_city;
                            $order_dispatch->it_easy_state                 = $orderModel->it_easy_shipping_state;
                            $order_dispatch->it_easy_state_id              = $orderModel->it_easy_shipping_state_id;
                            $order_dispatch->it_easy_pincode               = $orderModel->it_easy_shipping_pincode;
                            $order_dispatch->it_easy_mobile                = $orderModel->it_easy_shipping_mobile_number;
                            $order_dispatch->it_easy_email                 = $orderModel->it_easy_shipping_email;
                            $order_dispatch->it_easy_alternate_mobile      = $orderModel->it_easy_shipping_alternate_number;
                            $order_dispatch->it_easy_price                 = $orderModel->it_easy_total_price;
                            $order_dispatch->it_easy_collective_price      = $collective_price;
                            $order_dispatch->it_easy_order_date            = '';
                            $order_dispatch->it_easy_dispatch_time         = '';
                            $order_dispatch->it_easy_awb_time           =  $awb_data['date_added'];
                            $order_dispatch->it_easy_return_awb            = '';
                            $order_dispatch->it_easy_pickup_time           = '';
                            if(!empty($zone_name)){
                                $order_dispatch->it_easy_zone_name             = $zone_name->it_easy_zone_name;
                            }else{
                                $order_dispatch->it_easy_zone_name             = 'Zone A';
                            }
                            $order_dispatch->it_easy_courier_name          = $shiping_courier_name;
                            $order_dispatch->it_easy_subcourier_name       = $shiping_courier_name;
                            $order_dispatch->it_easy_order_status          = 'Order Manifest';
                            $order_dispatch->it_easy_courier_comment       = '';
                            $order_dispatch->it_easy_status_updated_at     = $awb_data['pickup_date_added'];
                            $order_dispatch->it_easy_first_scan_date       = '';
                            $order_dispatch->it_easy_last_scan_date        = '';
                            $order_dispatch->it_easy_first_attempted_date  = '';
                            $order_dispatch->it_easy_last_attempted_date   = '';
                            $order_dispatch->it_easy_delivery_date         = '';
                            $order_dispatch->it_easy_route_code            = '';
                            $order_dispatch->it_easy_picked                = '1';
                            $order_dispatch->it_easy_auto_rto_date         = '';
                            $order_dispatch->it_easy_rto_date              = '';
                            $order_dispatch->it_easy_attempt_count         = '';
                            $order_dispatch->it_easy_courier_price         = '';
                            $order_dispatch->it_easy_rto_updated_by        = '';
                            $order_dispatch->save(false);
                        
                        }
                        
                    }
                }
            }
        }
    }
    /**
     * Lists all ItEasyChanel models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyChanelSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    
    public function actionCreate()
    {
        $model = new ItEasyChanel();

        if ($model->load(Yii::$app->request->post())){
            $post = Yii::$app->request->post('ItEasyChanel');
            date_default_timezone_set("Asia/Kolkata");
            $create_date=date("Y-m-d H:i:s");
            $model->updated_time = $create_date; 
            $model->fetch_Type = $post['fetch_Type'];
            $model->updated_by = Yii::$app->user->identity->id;
            $model->save(false);
            Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
            return $this->redirect(['index']);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing ItEasyChanel model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $id ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())){
            $post = Yii::$app->request->post('ItEasyChanel');
            date_default_timezone_set("Asia/Kolkata");
            $create_date=date("Y-m-d H:i:s");
            $model->updated_time = $create_date; 
            $model->fetch_Type = $post['fetch_Type'];
            $model->updated_by = Yii::$app->user->identity->id;
            $model->save(false);
            Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
            return $this->redirect(['index']);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    
    protected function getStatusid($status_id){

        if($status_id == '18'){
            $it_easy_order_status_id = '5';
        }else if($status_id  == '20'){
            $it_easy_order_status_id = '2';
        }else if($status_id  == '7'){
            $it_easy_order_status_id = '8';
        }else if($status_id  == '14'){
            $it_easy_order_status_id = '15';
        }else if($status_id  == '17'){
            $it_easy_order_status_id = '1';
        }else if($status_id  == '19'){
            $it_easy_order_status_id = '12';
        }else if($status_id  == '22'){
            $it_easy_order_status_id = '3';
        }else if($status_id  == '28'){
            $it_easy_order_status_id = '18';
        }else if($status_id  == '30'){
            $it_easy_order_status_id = '19';
        }else if($status_id  == '34'){
            $it_easy_order_status_id = '7';
        }else if($status_id == '35'){
            $it_easy_order_status_id = '21';
        }else if($status_id  == '41'){
            $it_easy_order_status_id = '24';
        }else if($status_id  == '20'){
            $it_easy_order_status_id = '2';
        }else if($status_id  == '37'){
            $it_easy_order_status_id = '6';
        }else if($status_id  == '38'){
            $it_easy_order_status_id = '45';
        }else{
            $it_easy_order_status_id = $status_id;
        }

        return $it_easy_order_status_id;
    }

    protected function getDispositionid($disposition_id){
        if($disposition_id  == '1'){
            $it_easy_order_disposition_id = '3';
        }else if($disposition_id  == '2'){
            $it_easy_order_disposition_id = '1';
        }else if($disposition_id  == '3'){
            $it_easy_order_disposition_id = '4';
        }else if($disposition_id  == '4'){
            $it_easy_order_disposition_id = '5';
        }else if($disposition_id  == '5'){
            $it_easy_order_disposition_id = '6';
        }else if($disposition_id  == '6'){
            $it_easy_order_disposition_id = '33';
        }else if($disposition_id  == '7'){
            $it_easy_order_disposition_id = '7';
        }else if($disposition_id  == '8'){
            $it_easy_order_disposition_id = '8';
        }else if($disposition_id  == '9'){
            $it_easy_order_disposition_id = '9';
        }else if($disposition_id  == '10'){
            $it_easy_order_disposition_id = '11';
        }else if($disposition_id  == '12'){
            $it_easy_order_disposition_id = '13';
        }else if($disposition_id  == '13'){
            $it_easy_order_disposition_id = '10';
        }else if($disposition_id  == '14'){
            $it_easy_order_disposition_id = '12';
        }else if($disposition_id  == '15'){
            $it_easy_order_disposition_id = '4';
        }else if($disposition_id  == '16'){
            $it_easy_order_disposition_id = '14';
        }else if($disposition_id  == '17'){
            $it_easy_order_disposition_id = '15';
        }else if($disposition_id  == '18'){
            $it_easy_order_disposition_id = '16';
        }else if($disposition_id  == '20'){
            $it_easy_order_disposition_id = '17';
        }else if($disposition_id  == '21'){
            $it_easy_order_disposition_id = '18';
        }else if($disposition_id  == '25'){
            $it_easy_order_disposition_id = '21';
        }else if($disposition_id  == '26'){
            $it_easy_order_disposition_id = '22';
        }else if($disposition_id  == '27'){
            $it_easy_order_disposition_id = '35';
        }else if($disposition_id  == '29'){
            $it_easy_order_disposition_id = '34';
        }else{
            $it_easy_order_disposition_id = $disposition_id;
        }
        return $it_easy_order_disposition_id;
    }

    protected function findModel($id)
    {
        if (($model = ItEasyChanel::findOne(['id' => $id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    
}
