<?php

namespace backend\controllers;

use Yii;
use backend\models\ItEasyClickpostCourier;
use backend\models\ItEasyClickpostCourierSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;

/**
 * ClickPostController implements the CRUD actions for ItEasyApi model.
 */
class ClickPostController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyApi models.
     *
     * @return string
     */
     
    
     
    public function actionIndex()
    {
        $searchModel = new ItEasyClickpostCourierSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }


    /**
     * Creates a new ItEasyApi model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new ItEasyClickpostCourier();

           if ($this->request->isPost) {
            if ($model->load(Yii::$app->request->post())){
                 date_default_timezone_set("Asia/Kolkata");
                 $create_date=date("Y-m-d H:i:s");
                 $model->created_time = $create_date; 
                 $model->created_by = Yii::$app->user->identity->id;
                 
                 $model->save();
                 Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
                 return $this->redirect(['index']);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing ItEasyApi model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_id It Easy ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

          if ($this->request->isPost) {
        if ($model->load(Yii::$app->request->post())){
            date_default_timezone_set("Asia/Kolkata");
            $create_date=date("Y-m-d H:i:s");
            $model->updated_time = $create_date; 
            $model->updated_by = Yii::$app->user->identity->id;
            $model->save();
            Yii::$app->session->setFlash('success', 'Your Data has been updated successfully.');
            return $this->redirect(['index']);
            }
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }



    /**
     * Finds the ItEasyApi model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_id It Easy ID
     * @return ItEasyApi the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = ItEasyClickpostCourier::findOne(['id' => $id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
