<?php

namespace backend\controllers;

use backend\models\ItEasyCustomer;
use backend\models\ItEasyCustomerSearch;
use backend\models\ItEasyDiseasesName;
use backend\models\ItEasyDiseasesNameSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use yii\filters\AccessControl;
/**
 * CustomerController implements the CRUD actions for ItEasyCustomer model.
 */
class CustomerController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyCustomer models.
     *
     * @return string
     */
    public function actionIndex()
    {	
      if(Yii::$app->user->identity->it_easy_dept_id == '8' || Yii::$app->user->identity->it_easy_dept_id == '4'){
          $get_disease_name = ItEasyDiseasesName::ArrayHelperDiseaseName();
          $searchModel = new ItEasyCustomerSearch();
          $dataProvider = $searchModel->search($this->request->queryParams);


          return $this->render('index', [
              'searchModel' => $searchModel,
              'dataProvider' => $dataProvider,
              'get_disease_name' => $get_disease_name
          ]);
      }else{
          throw new NotFoundHttpException('The requested page does not exist.');
      }
    }

    
    protected function findModel($it_easy_customer_id)
    {
        if (($model = ItEasyCustomer::findOne(['it_easy_customer_id' => $it_easy_customer_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    public function actionCustomer()
    {
        $model = new \backend\models\ItEasyCustomer();

        if ($model->load(Yii::$app->request->post())) {
            if ($model->validate()) {
                // form inputs are valid, do something here
                return;
            }
        }

        return $this->render('customer', [
            'model' => $model,
        ]);
    }
}
