<?php

namespace backend\controllers;

use backend\models\ItEasyDelhiveryPincodes;
use backend\models\ItEasyDelhiveryPincodesSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use yii\web\UploadedFile;
use yii\filters\AccessControl;
/**
 * DelhiveryPincodesController implements the CRUD actions for ItEasyDelhiveryPincodes model.
 */
class DelhiveryPincodesController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyDelhiveryPincodes models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyDelhiveryPincodesSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }
    /**
     * Creates a new ItEasyDelhiveryPincodes model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */

    public function actionCreate()
    {
        $model = new ItEasyDelhiveryPincodes();
        if ($model->load(Yii::$app->request->post())) {
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');
            ItEasyDelhiveryPincodes::deleteAll();
            $model->file = UploadedFile::getInstance($model, 'file');

            if ($model->file) {
                $time = time();
                $model->file->saveAs('csv/' . $time . '.' . $model->file->extension);
                $model->file = 'csv/' . $time . '.' . $model->file->extension;
                $getdata = fopen($model->file, "r");
                $cnount = 0;
                while (($fileopen = fgetcsv($getdata, 1000, ",")) !== false) {
                    if ($cnount != 0) {
                        $model = new ItEasyDelhiveryPincodes();
                      	$model->it_easy_pincode = trim($fileopen[0]);
                        $model->it_easy_city = trim($fileopen[1]);
                        $model->it_easy_state = trim($fileopen[2]);
                        $model->it_easy_cod = trim($fileopen[4]);
                        $model->it_easy_prepaid = trim($fileopen[3]);
                        $model->created_by = Yii::$app->user->identity->id;
                        $model->created_time = $currentDateTime;
                        $model->save(false);
                    }
                    $cnount++;
                }
                return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
            }
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing ItEasyDelhiveryPincodes model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_id It Easy ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_id)
    {
        $model = $this->findModel($it_easy_id);

        if ($model->load(Yii::$app->request->post())) {
            $post = Yii::$app->request->post();
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');
            $time = time();
            $model->updated_by = Yii::$app->user->identity->id;
            $model->updated_time = $currentDateTime;
            
            $model->save(false);
            

            Yii::$app->session->setFlash('success', 'Form has been updated');
            return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }
    public function actionDelete($it_easy_id)
    {
        $this->findModel($it_easy_id)->delete();

        return $this->redirect(['index']);
    }
    /**
     * Finds the ItEasyDelhiveryPincodes model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_id It Easy ID
     * @return ItEasyDelhiveryPincodes the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_id)
    {
        if (($model = ItEasyDelhiveryPincodes::findOne(['it_easy_id' => $it_easy_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
