<?php

namespace backend\controllers;

use Yii;
use backend\models\ItEasyDepartment;
use backend\models\ItEasyDepartmentSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;

/**
 * DepartmentController implements the CRUD actions for ItEasyDepartment model.
 */
class DepartmentController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyDepartment models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyDepartmentSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    
    public function actionCreate()
    {
        $model = new ItEasyDepartment();

        if ($this->request->isPost) {
            if ($model->load(Yii::$app->request->post())){
                 date_default_timezone_set("Asia/Kolkata");
                 $create_date=date("Y-m-d H:i:s");
                 $model->created_time = $create_date; 
                 $model->created_by = Yii::$app->user->identity->id;
                 
                 $model->save();
                 Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
                 return $this->redirect(['index']);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing ItEasyDepartment model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_id It Easy ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_id)
    {
        $model = $this->findModel($it_easy_id);

        if ($this->request->isPost) {
            if ($model->load(Yii::$app->request->post())){
                date_default_timezone_set("Asia/Kolkata");
                $create_date=date("Y-m-d H:i:s");
                $model->updated_time = $create_date; 
                $model->updated_by = Yii::$app->user->identity->id;
                $model->save();
                Yii::$app->session->setFlash('success', 'Your Data has been updated successfully.');
                return $this->redirect(['index']);
            }
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }


    protected function findModel($it_easy_id)
    {
        if (($model = ItEasyDepartment::findOne(['it_easy_id' => $it_easy_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
