<?php

namespace backend\controllers;

use backend\models\ItEasyDiseaseType;
use backend\models\ItEasyOrder;
use backend\models\ItEasyState;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\filters\AccessControl;
/**
 * DepartmentController implements the CRUD actions for ItEasyDepartment model.
 */
class DiseaseTypeController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyDepartment models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyDiseaseType();
        
        $dataProvider = $searchModel->search($this->request->queryParams);
        $tl_data = ItEasyOrder::getAHelperTLdata();
        $agent_data = ItEasyOrder::getAHelperAgentdata();
        $stateList = ItEasyState::getStateallData();
        $statedata = ArrayHelper::map($stateList, 'it_easy_id', 'it_easy_state_name');
        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'agent_data' => $agent_data,
            'tl_data' => $tl_data,
            'statedata' => $statedata
        ]);
    }

  
    
   
}
