<?php

namespace backend\controllers;

use backend\models\ItEasyOrder;
use backend\models\ItEasyOrderSearch;
use backend\models\ItEasyStore;
use backend\models\ItEasyProductVariation;
use backend\models\ItEasyShippingPaymentMethod;
use backend\models\ItEasyCouponHistory;
use backend\models\ItEasyState;
use backend\models\ItEasyCustomer;
use backend\models\ItEasyFinancialYear;
use backend\models\ItEasyOrderProduct;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use yii\filters\AccessControl;
use yii\helpers\ArrayHelper;
use backend\models\ItEasyOrderStatusHistory;
use backend\models\ItEasyOrderDispositionHistory;
use backend\models\ItEasyOrderHistory;
use backend\models\ItEasyRaiseRequestSearch;
use backend\models\ItEasyRaiseRequest;
use yii2tech\spreadsheet\Spreadsheet;
use yii\data\ActiveDataProvider;
use yii\data\ArrayDataProvider;




/**
 * OrderController implements the CRUD actions for ItEasyOrder model.
 */
class DispatchReportController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyOrder models.
     *
     * @return string
     */
    public function actionIndex()
    {
         if((Yii::$app->user->identity->it_easy_dept_id == '6' || Yii::$app->user->identity->it_easy_dept_id == '2' || Yii::$app->user->identity->it_easy_dept_id == '7' || Yii::$app->user->identity->it_easy_dept_id == '8')){
            $searchModel = new ItEasyOrderSearch();
            $courierwiseReport = ItEasyOrder::ReportCourierWiseReport($this->request->queryParams);
             $productwiseReport = ItEasyOrder::ReportProductWiseReport($this->request->queryParams);
            if(isset($this->request->queryParams)){
                if(isset($this->request->queryParams['ItEasyOrderSearch']['date_type_filter'])){
                  $searchModel->date_type_filter = $this->request->queryParams['ItEasyOrderSearch']['date_type_filter'];
                }
                if(isset($this->request->queryParams['ItEasyOrderSearch']['date_to_date'])){
                  $searchModel->date_to_date = $this->request->queryParams['ItEasyOrderSearch']['date_to_date'];
                }
                if(isset($this->request->queryParams['ItEasyOrderSearch']['date_from_date'])){
                  $searchModel->date_from_date = $this->request->queryParams['ItEasyOrderSearch']['date_from_date'];
                }
              }
            return $this->render('index', [
                'searchModel' => $searchModel,
                'courierwiseReport' => $courierwiseReport,
                'productwiseReport'=>$productwiseReport,
                'Params' => $this->request->queryParams
            ]);
        }else{
            throw new \yii\web\HttpException(404, 'You Are Not Authorized To Access This Page.');
        }
    }
}