<?php

namespace backend\controllers;

use backend\models\ItEasyOrder;
use backend\models\ItEasyProductVariation;
use backend\models\ItEasyOrderProduct;
use backend\models\ItEasyProduct;
use backend\models\ItEasyOrderDispatch;
use backend\models\ItEasyWarehouseProductQuantity;
use yii\data\ArrayDataProvider;
use Yii;
use backend\models\view;
use backend\models\ViewSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;

/**
 * ViewController implements the CRUD actions for view model.
 */
class LogisController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        $model = new ItEasyOrder();

        if ($this->request->isPost) {

            $post = Yii::$app->request->post();

            if ($post['ItEasyOrder']['it_easy_order_number'] == 'Order ID') {
                $order_array = explode(',', $post['ItEasyOrder']['it_easy_other_order_id']);
                // echo "<pre>"; print_r($order_array); die;
                $find_array_order = [];
                foreach ($order_array as $key => $value) {
                    $orderDispatchMode = ItEasyOrderDispatch::find()->where(['it_easy_order_id' => $value])->one();
                    // echo "<pre>"; print_r($orderDispatchMode);
                    if(!empty($orderDispatchMode)){
                        $order_Model = ItEasyOrder::find()->where(['it_easy_order_id' => $orderDispatchMode->it_easy_order_id])->one();
                    }else{
                        $order_Model = [];
                        $order_Modelss = ItEasyOrder::find()->where(['it_easy_order_id' => $value])->one();
                        if(!empty($order_Modelss)){
                            if ($order_Modelss->it_easy_order_status_id != $post['ItEasyOrder']['it_easy_first_status']) {
                                if ($post['ItEasyOrder']['it_easy_first_status'] == '11') {
                                    $order_Model->it_easy_order_status_id = $post['ItEasyOrder']['it_easy_first_status'];
                                    $order_Model->it_easy_updated_time = date('Y-m-d H:i:s');
                                    $order_Model->save(false);
                                }
                            }
                        }
                        
                    }
                    // echo "<pre>"; print_r($order_Model); die;
                    if (!empty($order_Model)) {
                        if ($order_Model->it_easy_order_status_id != $post['ItEasyOrder']['it_easy_first_status']) {
                            $find_array_order['order_id'][] = $value;
                            $dispatch_model = ItEasyOrderDispatch::findOne(['it_easy_order_id' => $order_Model->it_easy_order_id]);
                            
                            if ($post['ItEasyOrder']['it_easy_first_status'] == '5') {
                                $dispatch_model->it_easy_order_status = 'Order Picked';
                                $order_Model->it_easy_placed_time = date('Y-m-d H:i:s');
                                $find_order_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $value])->all();
                                if (!empty($find_order_product)) {
                                    foreach ($find_order_product as $ke => $product_loop) {
                                        $findproduct_varition = ItEasyProductVariation::find()->where(['it_easy_product_id' => $product_loop->it_easy_product_id])->andWhere(['it_easy_variation_id' => $product_loop->it_easy_variation_id])->one();
                                        if (!empty($findproduct_varition)) {
                                            $findproduct_varition->it_easy_varation_quantity = $findproduct_varition->it_easy_varation_quantity - $product_loop->it_easy_product_quantity;
                                            $findproduct_varition->save();
                                        }
                                        $findproduct = ItEasyProduct::find()->where(['it_easy_product_id' => $product_loop->it_easy_product_id])->one();
                                        if (!empty($findproduct)) {
                                            $findproduct->it_easy_product_quantity = $findproduct->it_easy_product_quantity - $findproduct->it_easy_product_quantity;
                                            $findproduct->save(false);
                                        }
                                        $warehouse_product = ItEasyWarehouseProductQuantity::find()->where(['product_id' => $product_loop->it_easy_product_id])->andWhere(['variation_id' => $product_loop->it_easy_variation_id])->andWhere(['warehouse_id' => $orderDispatchMode->it_easy_warehouse_id])->one();
                                        if (!empty($warehouse_product)) {
                                            $warehouse_product->quantity = $warehouse_product->quantity - $product_loop->it_easy_product_quantity;
                                            $warehouse_product->save(false);
                                        }

                                    }
                                }
                            } else if ($post['ItEasyOrder']['it_easy_first_status'] == '15') {
                                $find_order_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $value])->all();
                                $dispatch_model->it_easy_order_status = 'RTO Delivered';
                                if (!empty($find_order_product)) {
                                    foreach ($find_order_product as $ke => $product_loop) {
                                        $findproduct_varition = ItEasyProductVariation::find()->where(['it_easy_product_id' => $product_loop->it_easy_product_id])->andWhere(['it_easy_variation_id' => $product_loop->it_easy_variation_id])->one();
                                        if (!empty($findproduct_varition)) {
                                            $findproduct_varition->it_easy_varation_quantity = $findproduct_varition->it_easy_varation_quantity + $product_loop->it_easy_product_quantity;
                                            $findproduct_varition->save();
                                        }
                                        $findproduct = ItEasyProduct::find()->where(['it_easy_product_id' => $product_loop->it_easy_product_id])->one();
                                        if (!empty($findproduct)) {
                                            $findproduct->it_easy_product_quantity = $findproduct->it_easy_product_quantity + $findproduct->it_easy_product_quantity;
                                            $findproduct->save();
                                        }

                                        $warehouse_product = ItEasyWarehouseProductQuantity::find()->where(['product_id' => $product_loop->it_easy_product_id])->andWhere(['variation_id' => $product_loop->it_easy_variation_id])->andWhere(['warehouse_id' => $orderDispatchMode->it_easy_warehouse_id])->one();
                                        if (!empty($warehouse_product)) {
                                            $warehouse_product->it_easy_varation_quantity = $warehouse_product->it_easy_varation_quantity + $product_loop->it_easy_product_quantity;
                                            $warehouse_product->save();
                                        }
                                    }
                                }
                            }
                            
                            if($post['ItEasyOrder']['it_easy_first_status'] == '3'){
                                if($order_Model->it_easy_order_status_id != '3'){
                                $order_Model->it_easy_delivered_time = date('Y-m-d H:i:s');
                                    $dispatch_model->it_easy_order_status = 'Delivered';
                                    $dispatch_model->it_easy_delivery_date = date('Y-m-d H:i:s');
                                }
                            }
                            $order_Model->it_easy_order_status_id = $post['ItEasyOrder']['it_easy_first_status'];
                            $order_Model->it_easy_updated_time = date('Y-m-d H:i:s');
                            $dispatch_model->it_easy_status_updated_at = date('Y-m-d H:i:s');
                            $dispatch_model->save(false);
                            $order_Model->save(false);
                            $addDispositionStatusHistory = ItEasyOrder::addOrderStatusHistory($value, $post['ItEasyOrder']['it_easy_first_status'], "Status Updated");
                        } else {
                            $find_array_order['not_match_order_id'][] = $value;
                        }
                    } else {
                        $find_array_order['not_match_order_id'][] = $value;
                    }
                }
            
        } else {
           
            $order_array = explode(',', $post['ItEasyOrder']['it_easy_other_order_id']);
            $find_array_order = [];
            foreach ($order_array as $key => $value) {
                $value = trim($value);
                $orderDispatchMode = ItEasyOrderDispatch::find()->where(['it_easy_awb_number' => $value])->one();
                if(!empty($orderDispatchMode)){
                    $order_Model = ItEasyOrder::find()->where(['it_easy_order_id' => $orderDispatchMode->it_easy_order_id])->one();
                }else{
                   $order_Model = []; 
                }
                if (!empty($order_Model)) {
                    if ($order_Model->it_easy_order_status_id != $post['ItEasyOrder']['it_easy_first_status']) {
                        $find_array_order['order_id'][] = $value;
                        $dispatch_model = ItEasyOrderDispatch::findOne(['it_easy_order_id' => $order_Model->it_easy_order_id]);
                        if ($post['ItEasyOrder']['it_easy_first_status'] == '5') {
                            $order_Model->it_easy_placed_time = date('Y-m-d H:i:s');
                            $dispatch_model->it_easy_order_status = 'Order Picked';
                            $find_order_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_Model->it_easy_order_id])->all();
                            if (!empty($find_order_product)) {
                                foreach ($find_order_product as $ke => $product_loop) {
                                    $findproduct_varition = ItEasyProductVariation::find()->where(['it_easy_product_id' => $product_loop->it_easy_product_id])->andWhere(['it_easy_variation_id ' => $product_loop->it_easy_variation_id])->one();
                                    if (!empty($findproduct_varition)) {
                                        $product_loop->it_easy_varation_quantity = $product_loop->it_easy_varation_quantity - $product_loop->it_easy_product_quantity;
                                        $$product_loop->save();
                                    }
                                    $findproduct = ItEasyProduct::find()->where(['it_easy_product_id' => $product_loop->it_easy_product_id])->one();
                                    if (!empty($findproduct)) {
                                        $findproduct->it_easy_product_quantity = $findproduct->it_easy_product_quantity - $findproduct->it_easy_product_quantity;
                                        $findproduct->save();
                                    }
                                    $warehouse_product = ItEasyWarehouseProductQuantity::find()->where(['product_id' => $product_loop->it_easy_product_id])->andWhere(['variation_id' => $product_loop->it_easy_variation_id])->andWhere(['warehouse_id' => $orderDispatchMode->it_easy_warehouse_id])->one();
                                    if (!empty($warehouse_product)) {
                                        $warehouse_product->quantity = $warehouse_product->quantity - $product_loop->it_easy_product_quantity;
                                        $warehouse_product->save();
                                    }
                                }
                            }
                        } else if ($post['ItEasyOrder']['it_easy_first_status'] == '15') {
                            $dispatch_model->it_easy_order_status = 'RTO Delivered';
                            $find_order_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_Model->it_easy_order_id])->all();
                            if (!empty($find_order_product)) {
                                foreach ($find_order_product as $ke => $product_loop) {
                                    $findproduct_varition = ItEasyProductVariation::find()->where(['it_easy_product_id' => $product_loop->it_easy_product_id])->andWhere(['it_easy_variation_id ' => $product_loop->it_easy_variation_id])->one();
                                    if (!empty($findproduct_varition)) {
                                        $product_loop->it_easy_varation_quantity = $product_loop->it_easy_varation_quantity + $product_loop->it_easy_product_quantity;
                                        $$product_loop->save();
                                    }
                                    $findproduct = ItEasyProduct::find()->where(['it_easy_product_id' => $product_loop->it_easy_product_id])->one();
                                    if (!empty($findproduct)) {
                                        $findproduct->it_easy_product_quantity = $findproduct->it_easy_product_quantity + $findproduct->it_easy_product_quantity;
                                        $findproduct->save();
                                    }

                                    $warehouse_product = ItEasyWarehouseProductQuantity::find()->where(['product_id' => $product_loop->it_easy_product_id])->andWhere(['variation_id' => $product_loop->it_easy_variation_id])->andWhere(['warehouse_id' => $orderDispatchMode->it_easy_warehouse_id])->one();
                                    if (!empty($warehouse_product)) {
                                        $warehouse_product->quantity = $warehouse_product->quantity + $product_loop->it_easy_product_quantity;
                                        $warehouse_product->save();
                                    }
                                }
                            }
                        }
                        
                        
                        
                        
                        
                        if($post['ItEasyOrder']['it_easy_first_status'] == '3'){
                            if($order_Model->it_easy_order_status_id != '3'){
                            $order_Model->it_easy_delivered_time = date('Y-m-d H:i:s');
                                $dispatch_model->it_easy_order_status = 'Delivered';
                                $dispatch_model->it_easy_delivery_date = date('Y-m-d H:i:s');
                            }
                        }
                        $order_Model->it_easy_order_status_id = $post['ItEasyOrder']['it_easy_first_status'];
                        $order_Model->it_easy_updated_time = date('Y-m-d H:i:s');
                        $dispatch_model->it_easy_status_updated_at = date('Y-m-d H:i:s');
                        $dispatch_model->save();
                        $order_Model->save();
                        $addDispositionStatusHistory = ItEasyOrder::addOrderStatusHistory($value, $post['ItEasyOrder']['it_easy_first_status'], "Status Updated");
                    } else {
                        $find_array_order['not_match_order_id'][] = $value;
                    }
                } else {
                    $find_array_order['not_match_order_id'][] = $value;
                }
            }

        }
        
        $urlencode = urlencode(json_encode($find_array_order));
        Yii::$app->response->redirect(['logis/updatestatus', 'params' => $urlencode]);
    }
        
        //return $this->redirect (['upda','what_id' => $model->what_id]);;
        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing view model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $view_id View ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */

    protected function findModel($view_id)
    {
        if (($model = view::findOne(['view_id' => $view_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    public function actionUpdatestatus()
    {   
        
        if (isset($this->request->get()['params']) && !empty($this->request->get()['params'])) {


            $json_pra = urldecode($this->request->get()['params']);
            
            $json_array = json_decode($json_pra);
            
            // 
            $array_dataprovider = [];
            $r = 0;
            // echo "<pre>"; print_r($json_array); 
            foreach($json_array as $key => $value_array){
                
                if($key == 'not_match_order_id'){
                    foreach($value_array as $ar){
                        $array_dataprovider[$r]['order_id'] =  $ar;
                        $array_dataprovider[$r]['message'] = 'Failed';
                        $r++;
                    }
                }else{
                    foreach($value_array as $ar){
                        $array_dataprovider[$r]['order_id'] =  $ar;
                        $array_dataprovider[$r]['message'] = 'Success';
                        $r++;
                    }
                }
                
            }
            // echo "<pre>"; print_r($array_dataprovider); die;
        } else {
            $array_dataprovider = [];
        }
        $provider = new ArrayDataProvider([
            'allModels' => $array_dataprovider,
        ]);

        $provider->pagination->pageSize = 500;
        return $this->render('updatestatus', [
            'dataProvider' => $provider,

        ]);
    }
    
    //logic by break refactor
    
    public function actionTest2()
{
    $model = new ItEasyOrder();
    $table_name=$model->tableName();
    // echo "<pre>";
   
    // print_r($table_name);die;

    if ($this->request->isPost) {
          //echo "here";die;
        $post = Yii::$app->request->post();
        // echo "<pre>";
        // print_r($post);die;
        $orderArray = $this->getOrderArray($post['ItEasyOrder']['it_easy_other_order_id']);

        if (empty($orderArray)) {
            Yii::$app->session->setFlash('error', 'No order data provided.');
            return $this->render('create', ['model' => $model]);
        }

        $result = [];

        if ($post['ItEasyOrder']['it_easy_order_number'] === 'Order ID') {
            $result = $this->processOrdersByOrderId($orderArray, $post);
            echo "<pre>";
            print_r($result);die;
        } else {
            $result = $this->processOrdersByAwbNumber($orderArray, $post);
        }

        $urlencode = urlencode(json_encode($result));
        print_r($urlencode);die;
        return $this->redirect(['logis/updatestatus', 'params' => $urlencode]);
    }

    return $this->render('create1', ['model' => $model]);
}

//helper fucntion for index

private function getOrderArray($input)
{
    if (empty($input)) {
        return [];
    }

    return array_filter(array_map('trim', explode(',', $input)));
}

//handiling order id type

private function processOrdersByOrderId(array $orderArray, array $post)
{
    $result = [
        'order_id' => [],
        'not_match_order_id' => [],
        'errors' => []
    ];
  $model = new ItEasyOrderDispatch();
       $table_name=$model->tableName();
    // echo "<pre>";
   
    //  print_r($table_name);die;
    foreach ($orderArray as $orderId) {
        // 1. Check dispatch
      
        $dispatch = ItEasyOrderDispatch::find()->where(['it_easy_order_id' => $orderId])->one();

        // 2. Get order by dispatch or directly
        $order = $dispatch 
            ? ItEasyOrder::find()->where(['it_easy_order_id' => $dispatch->it_easy_order_id])->one()
            : ItEasyOrder::find()->where(['it_easy_order_id' => $orderId])->one();
//             echo "<pre>";
// print_r($order);die;
        // 3. Order not found
        if (!$order) {
            // echo "here";die;
            $result['not_match_order_id'][] = $orderId;
            $result['errors'][] = [
                'order_id' => $orderId,
                'reason' => 'Order not found in database'
            ];
            continue;
        }
//         echo $order->it_easy_order_status_id;
//       echo $post['ItEasyOrder']['it_easy_first_status'];
        
 echo "here oe";
        // 4. Status already matches
        
        if ($order->it_easy_order_status_id == $post['ItEasyOrder']['it_easy_first_status']) {
          
            echo $orderId,
            $result['not_match_order_id'][] = $orderId;
            $result['errors'][] = [
                'order_id' => $orderId,
                'reason' => 'Order already has the selected status'
            ];
            continue;
        }
        echo "here";

        // 5. Update status
        try {
            $this->updateOrderStatus($order, $dispatch, $post['ItEasyOrder']['it_easy_first_status']);
            $result['order_id'][] = $orderId;
        } catch (\Throwable $e) {
            // Catch unexpected errors (DB, logic, etc.)
            $result['errors'][] = [
                'order_id' => $orderId,
                'reason' => 'Exception: ' . $e->getMessage()
            ];
            $result['not_match_order_id'][] = $orderId;
        }
    }

    return $result;
}


//logic to update order status

private function updateOrderStatus($order, $dispatch, $statusId)
{
    print_r($dispatch);die;
    echo "here i am";
   // print_r($order);
    echo $statusId;
   echo $order->it_easy_order_status_id;
    
    $now = date('Y-m-d H:i:s');

    // Order Picked
    if ($statusId == '5') {
        $order->it_easy_placed_time = $now;
        $dispatch->it_easy_order_status = 'Order Picked';
        $this->updateInventory($order->it_easy_order_id, $dispatch, 'decrease');
    }

    // Delivered
    if ($statusId == '3' && $order->it_easy_order_status_id != '3') {
       // echo "here enter";die;
        $order->it_easy_delivered_time = $now;
        $dispatch->it_easy_order_status = 'Delivered';
        $dispatch->it_easy_delivery_date = $now;
    }

    // RTO Delivered
    if ($statusId == '15') {
        $dispatch->it_easy_order_status = 'RTO Delivered';
        $this->updateInventory($order->it_easy_order_id, $dispatch, 'increase');
    }

    $order->it_easy_order_status_id = $statusId;
    $order->it_easy_updated_time = $now;
    $dispatch->it_easy_status_updated_at = $now;

    $order->save(false);
    $dispatch->save(false);

    ItEasyOrder::addOrderStatusHistory($order->it_easy_order_id, $statusId, "Status Updated");
}

//invendtory update handler

private function updateInventory($orderId, $dispatch, $mode = 'decrease')
{
    $products = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $orderId])->all();

    foreach ($products as $product) {
        $variation = ItEasyProductVariation::find()
            ->where(['it_easy_product_id' => $product->it_easy_product_id])
            ->andWhere(['it_easy_variation_id' => $product->it_easy_variation_id])
            ->one();

        $mainProduct = ItEasyProduct::find()->where(['it_easy_product_id' => $product->it_easy_product_id])->one();

        $warehouseProduct = ItEasyWarehouseProductQuantity::find()
            ->where([
                'product_id' => $product->it_easy_product_id,
                'variation_id' => $product->it_easy_variation_id,
                'warehouse_id' => $dispatch->it_easy_warehouse_id
            ])
            ->one();

        $qtyChange = $mode === 'decrease' ? -$product->it_easy_product_quantity : $product->it_easy_product_quantity;

        if ($variation) {
            $variation->it_easy_varation_quantity += $qtyChange;
            $variation->save(false);
        }

        if ($mainProduct) {
            $mainProduct->it_easy_product_quantity += $qtyChange;
            $mainProduct->save(false);
        }

        if ($warehouseProduct) {
            $warehouseProduct->quantity += $qtyChange;
            $warehouseProduct->save(false);
        }
    }
}




//handling AWB type 
private function processOrdersByAwbNumber(array $awbArray, array $post)
{
    $result = [];

    foreach ($awbArray as $awbNumber) {
        $dispatch = ItEasyOrderDispatch::find()->where(['it_easy_awb_number' => $awbNumber])->one();
        $order = $dispatch 
            ? ItEasyOrder::find()->where(['it_easy_order_id' => $dispatch->it_easy_order_id])->one()
            : null;

        if (!$order) {
            $result['not_match_order_id'][] = $awbNumber;
            continue;
        }

        if ($order->it_easy_order_status_id == $post['ItEasyOrder']['it_easy_first_status']) {
            $result['not_match_order_id'][] = $awbNumber;
            continue;
        }

        $this->updateOrderStatus($order, $dispatch, $post['ItEasyOrder']['it_easy_first_status']);
        $result['order_id'][] = $awbNumber;
    }

    return $result;
}


//test functionality

    public function actionTest()
    {
        $model = new ItEasyOrder();

        if ($this->request->isPost) {

            $post = Yii::$app->request->post();

            if ($post['ItEasyOrder']['it_easy_order_number'] == 'Order ID') {
                $order_array = explode(',', $post['ItEasyOrder']['it_easy_other_order_id']);
                // echo "<pre>"; print_r($order_array); die;
                $find_array_order = [];
                foreach ($order_array as $key => $value) {
                    $orderDispatchMode = ItEasyOrderDispatch::find()->where(['it_easy_order_id' => $value])->one();
                    // echo "<pre>"; print_r($orderDispatchMode);
                    if(!empty($orderDispatchMode)){
                        // echo "heredispatch";die;
                        $order_Model = ItEasyOrder::find()->where(['it_easy_order_id' => $orderDispatchMode->it_easy_order_id])->one();
                    }else{
                          echo "heredispatch2";
                       // $order_Model = [];
                       $order_Model = null; // initialize properly
                        $order_Modelss = ItEasyOrder::find()->where(['it_easy_order_id' => $value])->one();
                        // echo "<pre>";
                        // print_r($order_Modelss);die;
                        if(!empty($order_Modelss)){
                            if ($order_Modelss->it_easy_order_status_id != $post['ItEasyOrder']['it_easy_first_status']) {
                                if ($post['ItEasyOrder']['it_easy_first_status'] == '11') {
                                    $order_Model->it_easy_order_status_id = $post['ItEasyOrder']['it_easy_first_status'];
                                    $order_Model->it_easy_updated_time = date('Y-m-d H:i:s');
                                    $order_Model->save(false);
                                }
                            }
                              $order_Model = $order_Modelss;
                        }
                        
                    }
                    // echo "here test";
                    // echo "<pre>"; print_r($order_Model); die;
                    if (!empty($order_Model)) {
                        if ($order_Model->it_easy_order_status_id != $post['ItEasyOrder']['it_easy_first_status']) {
                            $find_array_order['order_id'][] = $value;
                            $dispatch_model = ItEasyOrderDispatch::findOne(['it_easy_order_id' => $order_Model->it_easy_order_id]);
                            echo $order_Model->it_easy_order_id;
                            // echo $order_Model->it_easy_order_status_id;
                            //  echo $post['ItEasyOrder']['it_easy_first_status'];
                            //echo ItEasyOrderDispatch::tableName();
                           
                            echo "areadd";
                            echo "<pre>";
                            print_r($dispatch_model);die;
                            
                            if ($post['ItEasyOrder']['it_easy_first_status'] == '5') {
                                $dispatch_model->it_easy_order_status = 'Order Picked';
                                $order_Model->it_easy_placed_time = date('Y-m-d H:i:s');
                                $find_order_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $value])->all();
                                if (!empty($find_order_product)) {
                                    foreach ($find_order_product as $ke => $product_loop) {
                                        $findproduct_varition = ItEasyProductVariation::find()->where(['it_easy_product_id' => $product_loop->it_easy_product_id])->andWhere(['it_easy_variation_id' => $product_loop->it_easy_variation_id])->one();
                                        if (!empty($findproduct_varition)) {
                                            $findproduct_varition->it_easy_varation_quantity = $findproduct_varition->it_easy_varation_quantity - $product_loop->it_easy_product_quantity;
                                            $findproduct_varition->save();
                                        }
                                        $findproduct = ItEasyProduct::find()->where(['it_easy_product_id' => $product_loop->it_easy_product_id])->one();
                                        if (!empty($findproduct)) {
                                            $findproduct->it_easy_product_quantity = $findproduct->it_easy_product_quantity - $findproduct->it_easy_product_quantity;
                                            $findproduct->save(false);
                                        }
                                        $warehouse_product = ItEasyWarehouseProductQuantity::find()->where(['product_id' => $product_loop->it_easy_product_id])->andWhere(['variation_id' => $product_loop->it_easy_variation_id])->andWhere(['warehouse_id' => $orderDispatchMode->it_easy_warehouse_id])->one();
                                        if (!empty($warehouse_product)) {
                                            $warehouse_product->quantity = $warehouse_product->quantity - $product_loop->it_easy_product_quantity;
                                            $warehouse_product->save(false);
                                        }

                                    }
                                }
                            } else if ($post['ItEasyOrder']['it_easy_first_status'] == '15') {
                                $find_order_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $value])->all();
                                $dispatch_model->it_easy_order_status = 'RTO Delivered';
                                if (!empty($find_order_product)) {
                                    foreach ($find_order_product as $ke => $product_loop) {
                                        $findproduct_varition = ItEasyProductVariation::find()->where(['it_easy_product_id' => $product_loop->it_easy_product_id])->andWhere(['it_easy_variation_id' => $product_loop->it_easy_variation_id])->one();
                                        if (!empty($findproduct_varition)) {
                                            $findproduct_varition->it_easy_varation_quantity = $findproduct_varition->it_easy_varation_quantity + $product_loop->it_easy_product_quantity;
                                            $findproduct_varition->save();
                                        }
                                        $findproduct = ItEasyProduct::find()->where(['it_easy_product_id' => $product_loop->it_easy_product_id])->one();
                                        if (!empty($findproduct)) {
                                            $findproduct->it_easy_product_quantity = $findproduct->it_easy_product_quantity + $findproduct->it_easy_product_quantity;
                                            $findproduct->save();
                                        }

                                        $warehouse_product = ItEasyWarehouseProductQuantity::find()->where(['product_id' => $product_loop->it_easy_product_id])->andWhere(['variation_id' => $product_loop->it_easy_variation_id])->andWhere(['warehouse_id' => $orderDispatchMode->it_easy_warehouse_id])->one();
                                        if (!empty($warehouse_product)) {
                                            $warehouse_product->it_easy_varation_quantity = $warehouse_product->it_easy_varation_quantity + $product_loop->it_easy_product_quantity;
                                            $warehouse_product->save();
                                        }
                                    }
                                }
                            }
                            
                            if($post['ItEasyOrder']['it_easy_first_status'] == '3'){
                                if($order_Model->it_easy_order_status_id != '3'){
                                $order_Model->it_easy_delivered_time = date('Y-m-d H:i:s');
                                    $dispatch_model->it_easy_order_status = 'Delivered';
                                    $dispatch_model->it_easy_delivery_date = date('Y-m-d H:i:s');
                                }
                            }
                            $order_Model->it_easy_order_status_id = $post['ItEasyOrder']['it_easy_first_status'];
                            $order_Model->it_easy_updated_time = date('Y-m-d H:i:s');
                            $dispatch_model->it_easy_status_updated_at = date('Y-m-d H:i:s');
                            $dispatch_model->save(false);
                            $order_Model->save(false);
                            $addDispositionStatusHistory = ItEasyOrder::addOrderStatusHistory($value, $post['ItEasyOrder']['it_easy_first_status'], "Status Updated");
                        } else {
                            echo "here in second else";
                            $find_array_order['not_match_order_id'][] = $value;
                        }
                    } else {
                         echo "here in fiest else";
                        $find_array_order['not_match_order_id'][] = $value;
                    }
                    echo "end";die;
                }
            
        } else {
           
            $order_array = explode(',', $post['ItEasyOrder']['it_easy_other_order_id']);
            $find_array_order = [];
            foreach ($order_array as $key => $value) {
                $value = trim($value);
                $orderDispatchMode = ItEasyOrderDispatch::find()->where(['it_easy_awb_number' => $value])->one();
                if(!empty($orderDispatchMode)){
                    $order_Model = ItEasyOrder::find()->where(['it_easy_order_id' => $orderDispatchMode->it_easy_order_id])->one();
                }else{
                   $order_Model = []; 
                }
                if (!empty($order_Model)) {
                    if ($order_Model->it_easy_order_status_id != $post['ItEasyOrder']['it_easy_first_status']) {
                        $find_array_order['order_id'][] = $value;
                        $dispatch_model = ItEasyOrderDispatch::findOne(['it_easy_order_id' => $order_Model->it_easy_order_id]);
                        if ($post['ItEasyOrder']['it_easy_first_status'] == '5') {
                            $order_Model->it_easy_placed_time = date('Y-m-d H:i:s');
                            $dispatch_model->it_easy_order_status = 'Order Picked';
                            $find_order_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_Model->it_easy_order_id])->all();
                            if (!empty($find_order_product)) {
                                foreach ($find_order_product as $ke => $product_loop) {
                                    $findproduct_varition = ItEasyProductVariation::find()->where(['it_easy_product_id' => $product_loop->it_easy_product_id])->andWhere(['it_easy_variation_id ' => $product_loop->it_easy_variation_id])->one();
                                    if (!empty($findproduct_varition)) {
                                        $product_loop->it_easy_varation_quantity = $product_loop->it_easy_varation_quantity - $product_loop->it_easy_product_quantity;
                                        $$product_loop->save();
                                    }
                                    $findproduct = ItEasyProduct::find()->where(['it_easy_product_id' => $product_loop->it_easy_product_id])->one();
                                    if (!empty($findproduct)) {
                                        $findproduct->it_easy_product_quantity = $findproduct->it_easy_product_quantity - $findproduct->it_easy_product_quantity;
                                        $findproduct->save();
                                    }
                                    $warehouse_product = ItEasyWarehouseProductQuantity::find()->where(['product_id' => $product_loop->it_easy_product_id])->andWhere(['variation_id' => $product_loop->it_easy_variation_id])->andWhere(['warehouse_id' => $orderDispatchMode->it_easy_warehouse_id])->one();
                                    if (!empty($warehouse_product)) {
                                        $warehouse_product->quantity = $warehouse_product->quantity - $product_loop->it_easy_product_quantity;
                                        $warehouse_product->save();
                                    }
                                }
                            }
                        } else if ($post['ItEasyOrder']['it_easy_first_status'] == '15') {
                            $dispatch_model->it_easy_order_status = 'RTO Delivered';
                            $find_order_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $order_Model->it_easy_order_id])->all();
                            if (!empty($find_order_product)) {
                                foreach ($find_order_product as $ke => $product_loop) {
                                    $findproduct_varition = ItEasyProductVariation::find()->where(['it_easy_product_id' => $product_loop->it_easy_product_id])->andWhere(['it_easy_variation_id ' => $product_loop->it_easy_variation_id])->one();
                                    if (!empty($findproduct_varition)) {
                                        $product_loop->it_easy_varation_quantity = $product_loop->it_easy_varation_quantity + $product_loop->it_easy_product_quantity;
                                        $$product_loop->save();
                                    }
                                    $findproduct = ItEasyProduct::find()->where(['it_easy_product_id' => $product_loop->it_easy_product_id])->one();
                                    if (!empty($findproduct)) {
                                        $findproduct->it_easy_product_quantity = $findproduct->it_easy_product_quantity + $findproduct->it_easy_product_quantity;
                                        $findproduct->save();
                                    }

                                    $warehouse_product = ItEasyWarehouseProductQuantity::find()->where(['product_id' => $product_loop->it_easy_product_id])->andWhere(['variation_id' => $product_loop->it_easy_variation_id])->andWhere(['warehouse_id' => $orderDispatchMode->it_easy_warehouse_id])->one();
                                    if (!empty($warehouse_product)) {
                                        $warehouse_product->quantity = $warehouse_product->quantity + $product_loop->it_easy_product_quantity;
                                        $warehouse_product->save();
                                    }
                                }
                            }
                        }
                        
                        
                        
                        
                        
                        if($post['ItEasyOrder']['it_easy_first_status'] == '3'){
                            if($order_Model->it_easy_order_status_id != '3'){
                            $order_Model->it_easy_delivered_time = date('Y-m-d H:i:s');
                                $dispatch_model->it_easy_order_status = 'Delivered';
                                $dispatch_model->it_easy_delivery_date = date('Y-m-d H:i:s');
                            }
                        }
                        $order_Model->it_easy_order_status_id = $post['ItEasyOrder']['it_easy_first_status'];
                        $order_Model->it_easy_updated_time = date('Y-m-d H:i:s');
                        $dispatch_model->it_easy_status_updated_at = date('Y-m-d H:i:s');
                        $dispatch_model->save();
                        $order_Model->save();
                        $addDispositionStatusHistory = ItEasyOrder::addOrderStatusHistory($value, $post['ItEasyOrder']['it_easy_first_status'], "Status Updated");
                    } else {
                        $find_array_order['not_match_order_id'][] = $value;
                    }
                } else {
                    $find_array_order['not_match_order_id'][] = $value;
                }
            }

        }
        
        $urlencode = urlencode(json_encode($find_array_order));
        echo "<pre>";
        print_r($urlencode);die;
        Yii::$app->response->redirect(['logis/updatestatus', 'params' => $urlencode]);
    }
        
        //return $this->redirect (['upda','what_id' => $model->what_id]);;
        return $this->render('create1', [
            'model' => $model,
        ]);
    }





}
