<?php

namespace backend\controllers;

use backend\models\ItEasyOrder;
use backend\models\ItEasyOrderSearch;
use backend\models\ItEasyStore;
use backend\models\ItEasyProductVariation;
use backend\models\ItEasyShippingPaymentMethod;
use backend\models\ItEasyCouponHistory;
use backend\models\ItEasyState;
use backend\models\ItEasyCustomer;
use backend\models\ItEasyFinancialYear;
use backend\models\ItEasyOrderProduct;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use yii\filters\AccessControl;
use yii\helpers\ArrayHelper;
use backend\models\ItEasyOrderStatusHistory;
use backend\models\ItEasyOrderDispositionHistory;
use backend\models\ItEasyOrderHistory;
use backend\models\ItEasyRaiseRequestSearch;
use backend\models\ItEasyRaiseRequest;
use yii2tech\spreadsheet\Spreadsheet;
use yii\data\ActiveDataProvider;
use yii\data\ArrayDataProvider;




/**
 * OrderController implements the CRUD actions for ItEasyOrder model.
 */
class LogisticController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyOrder models.
     *
     * @return string
     */
    public function actionIndex()
    {
        
            $searchModel = new ItEasyOrderSearch();
            $courierwiseReport = ItEasyOrder::ReportFromOrderCourierWiseReport($this->request->queryParams);
            $arreyHelper_courier = ItEasyOrder::ArrayHelperCourierData();
            // echo "<pre>"; print_r($dataProvider); die;
            
            $courierzonewiseReport = ItEasyOrder::ReportFromOrderCourierZoneWiseReport($this->request->queryParams);

            $courierstatewiseReport = ItEasyOrder::ReportFromOrderCourierStateWiseReport($this->request->queryParams);

            $state_id_name = ItEasyOrder::getStateArrayDistinct($this->request->queryParams);

            // echo "<pre>"; print_r($courierstatewiseReport2); die;

            $courierlivewiseReport = ItEasyOrder::ReportFromOrderCourierLiveWiseReport($this->request->queryParams);

            if(isset($this->request->queryParams)){
                if(isset($this->request->queryParams['ItEasyOrderSearch']['it_easy_assigned_by'])){
                  $searchModel->it_easy_assigned_by = $this->request->queryParams['ItEasyOrderSearch']['it_easy_assigned_by'];
                }
                if(isset($this->request->queryParams['ItEasyOrderSearch']['it_easy_assigned_to'])){
                  $searchModel->it_easy_assigned_to = $this->request->queryParams['ItEasyOrderSearch']['it_easy_assigned_to'];
                }
                if(isset($this->request->queryParams['ItEasyOrderSearch']['it_easy_first_status'])){
                  $searchModel->it_easy_first_status = $this->request->queryParams['ItEasyOrderSearch']['it_easy_first_status'];
                }
                if(isset($this->request->queryParams['ItEasyOrderSearch']['it_easy_platform'])){
                  $searchModel->it_easy_platform = $this->request->queryParams['ItEasyOrderSearch']['it_easy_platform'];
                }
                if(isset($this->request->queryParams['ItEasyOrderSearch']['date_type_filter'])){
                  $searchModel->date_type_filter = $this->request->queryParams['ItEasyOrderSearch']['date_type_filter'];
                }
                if(isset($this->request->queryParams['ItEasyOrderSearch']['date_to_date'])){
                  $searchModel->date_to_date = $this->request->queryParams['ItEasyOrderSearch']['date_to_date'];
                }
                if(isset($this->request->queryParams['ItEasyOrderSearch']['date_from_date'])){
                  $searchModel->date_from_date = $this->request->queryParams['ItEasyOrderSearch']['date_from_date'];
                }
              }
            return $this->render('index', [
                'searchModel' => $searchModel,
                'courierwiseReport' => $courierwiseReport,
                'state_id_name' => $state_id_name,
                'arreyHelper_courier' => $arreyHelper_courier,
                'courierzonewiseReport' => $courierzonewiseReport,
                'courierstatewiseReport' => $courierstatewiseReport,
                'courierlivewiseReport' => $courierlivewiseReport,
                'Params' => $this->request->queryParams
            ]);
        
    }
}