<?php

namespace backend\controllers;

use backend\models\ItEasyMarketer;
use backend\models\ItEasyMarketerSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use yii\filters\AccessControl;
/**
 * MarketerController implements the CRUD actions for ItEasyMarketer model.
 */
class MarketerController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyMarketer models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyMarketerSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ItEasyMarketer model.
     * @param int $it_easy_id It Easy ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
  

    /**
     * Creates a new ItEasyMarketer model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new ItEasyMarketer();

        if ($this->request->isPost) {
            if ($model->load(Yii::$app->request->post())){
                 date_default_timezone_set("Asia/Kolkata");
                 $create_date=date("Y-m-d H:i:s");
                    
                 $model->created_time = $create_date; 
                 $model->created_by = Yii::$app->user->identity->id;
                 
                 $model->save(false);
               
                 Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
                 return $this->redirect(['index']);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing ItEasyMarketer model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_id It Easy ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_id)
    {
        $model = $this->findModel($it_easy_id);

        if ($this->request->isPost) {
            if ($model->load(Yii::$app->request->post())){
                date_default_timezone_set("Asia/Kolkata");
                $create_date=date("Y-m-d H:i:s");
                $model->updated_time = $create_date; 
                $model->updated_by = Yii::$app->user->identity->id;
                $model->save();
                Yii::$app->session->setFlash('success', 'Your Data has been updated successfully.');
                return $this->redirect(['index']);
            }
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing ItEasyMarketer model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $it_easy_id It Easy ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
  
    /**
     * Finds the ItEasyMarketer model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_id It Easy ID
     * @return ItEasyMarketer the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_id)
    {
        if (($model = ItEasyMarketer::findOne(['it_easy_id' => $it_easy_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    public function actionMarketer()
{
    $model = new \backend\models\ItEasyMarketer();

    if ($model->load(Yii::$app->request->post())) {
        if ($model->validate()) {
            // form inputs are valid, do something here
            return;
        }
    }

    return $this->render('marketer', [
        'model' => $model,
    ]);
}
}
