<?php

namespace backend\controllers;

use Yii;
use backend\models\ItEasyMaterialHistory;
use backend\models\ItEasyMaterialHistorySearch;
use backend\models\ItEasyProductMaterial;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;

/**
 * MaterialHistoryController implements the CRUD actions for ItEasyMaterialHistory model.
 */
class MaterialHistoryController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyMaterialHistory models.
     *
     * @return string
     */
    public function actionIndex()
    {	if(Yii::$app->user->identity->it_easy_dept_id == '8' || Yii::$app->user->identity->it_easy_dept_id == '2'){
            $searchModel = new ItEasyMaterialHistorySearch();
            $dataProvider = $searchModel->search($this->request->queryParams);

            return $this->render('index', [
                'searchModel' => $searchModel,
                'dataProvider' => $dataProvider,
            ]);
      	}else{
          throw new NotFoundHttpException('The requested page does not exist.');
      	}
    }



    /**
     * Creates a new ItEasyMaterialHistory model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {	
      	if(Yii::$app->user->identity->it_easy_dept_id == '8' || Yii::$app->user->identity->it_easy_dept_id == '2'){
            $model = new ItEasyMaterialHistory();

            if ($model->load(Yii::$app->request->post())){
                $post = Yii::$app->request->post();

                date_default_timezone_set('Asia/kolkata');
                $currentDateTime = date('Y-m-d H:i:s');
                $time = time();

                $received_date = $post['ItEasyMaterialHistory']['it_easy_received_date'];
                // add quanity in product maerial code start
                $material_quantity = $post['ItEasyMaterialHistory']['it_easy_material_quantity'];
                
                $material_id = $post['ItEasyMaterialHistory']['it_easy_material_id'];
                $check_material_quanity = ItEasyProductMaterial::find()->where(['it_easy_id'=>$material_id])->One();
                $model->it_easy_weight_type = $check_material_quanity->it_easy_material_weight_type;
                $product_material_quantity = $check_material_quanity->it_easy_material_quantity;
                $final_quantity = $material_quantity + $product_material_quantity;
                $check_material_quanity->it_easy_material_quantity = $final_quantity;
                $check_material_quanity->save(false);
                 
                // add quanity in product maerial code end here
                $time=strtotime($received_date);
                $month=date("m",$time);
                $year=date("Y",$time);
                $model->it_easy_approved_status = 'Pending';
                $model->it_easy_buy_month = $month;
                $model->it_easy_buy_year = $year;
                $model->created_by = Yii::$app->user->identity->id;
                $model->created_time = $currentDateTime; 
                $model->save();
                Yii::$app->session->setFlash('success', "Your data has been saved!");
                return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
            }

            return $this->render('create', [
                'model' => $model,
            ]);
          
        }else{
          throw new NotFoundHttpException('The requested page does not exist.');
      	}
    }

    /**
     * Finds the ItEasyMaterialHistory model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_id It Easy ID
     * @return ItEasyMaterialHistory the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_id)
    {
        if (($model = ItEasyMaterialHistory::findOne(['it_easy_id' => $it_easy_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
