<?php

namespace backend\controllers;

use Yii;
use backend\models\ApiCall;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use backend\models\ItEasyNdr;
use backend\models\ItEasyOrder;
use yii\data\ArrayDataProvider;
use backend\models\ItEasyOrderStatusHistory;
use backend\models\ItEasyOrderProduct;
use backend\models\ItEasyOrderDispositionHistory;
use backend\models\ItEasyOrderHistory;
use yii\helpers\ArrayHelper;
use yii2tech\spreadsheet\Spreadsheet;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyShippingPaymentMethod;
use backend\models\ItEasyState;
use backend\models\ItEasyOrderNdrStatusHistory;
use backend\models\ItEasyOrderNdrdispositionHistory;
use backend\models\ItEasyOrderDispatch;
use backend\models\ItEasyOrderTrack;
use backend\models\ItEasyFinancialYear;
use backend\models\ItEasyClickpostTracking;
use backend\models\ItEasyQueryTracking;
use backend\models\ItEasyUser;


/**
 * UserTypeController implements the CRUD actions for ItEasyUserType model.
 */
class NdrController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyUserType models.
     *
     * @return string
     */
    public function actionIndex()
    {   
       
        $model = new ItEasyNdr();
        $dataProvider = $model->ndrdata($this->request->queryParams);
      	$array_helper_courier = ItEasyOrder::ArrayHelperCourierData();
      	$order_status_list = ItEasyOrder::getAHelperOrderStatusForAgent();    
        $order_statusdata = ArrayHelper::map($order_status_list, 'it_easy_order_status_id', 'it_easy_order_status_name');
        $disposition_status_list = ItEasyOrder::getAHelperDispositionStatusForAgent();
        $order_dispositiondata = ArrayHelper::map($disposition_status_list, 'it_easy_order_disposition_id', 'it_easy_order_disposition_name');
      
      	$ndr_status_list = ItEasyOrder::getAHelperndrOrderStatusForAgent();    
        $ndr_statusdata = ArrayHelper::map($ndr_status_list, 'it_easy_order_status_id', 'it_easy_order_status_name');
        $disposition_ndr_list = ItEasyOrder::getAHelperndrDispositionStatusForAgent();
        $ndr_dispositiondata = ArrayHelper::map($disposition_ndr_list, 'it_easy_order_disposition_id', 'it_easy_order_disposition_name');
        $dataProvider->pagination->pageSize = 50;
        
        
        if(isset($this->request->queryParams)){
            if(isset($this->request->queryParams['ItEasyNdr']['it_easy_order_number'])){
              $model->it_easy_order_number = $this->request->queryParams['ItEasyNdr']['it_easy_order_number'];
            }
            if(isset($this->request->queryParams['ItEasyNdr']['it_easy_mobile_number'])){
              $model->it_easy_mobile_number = $this->request->queryParams['ItEasyNdr']['it_easy_mobile_number'];
            }
            if(isset($this->request->queryParams['ItEasyNdr']['it_easy_awb_number'])){
              $model->it_easy_awb_number = $this->request->queryParams['ItEasyNdr']['it_easy_awb_number'];
            }
            if(isset($this->request->queryParams['ItEasyNdr']['it_easy_courier_name'])){
              $model->it_easy_courier_name = $this->request->queryParams['ItEasyNdr']['it_easy_courier_name'];
            }
            if(isset($this->request->queryParams['ItEasyNdr']['it_easy_order_status_id'])){
              $model->it_easy_order_status_id = $this->request->queryParams['ItEasyNdr']['it_easy_order_status_id'];
            }
            if(isset($this->request->queryParams['ItEasyNdr']['it_easy_order_disposition_id'])){
              $model->it_easy_order_disposition_id = $this->request->queryParams['ItEasyNdr']['it_easy_order_disposition_id'];
            }
            if(isset($this->request->queryParams['ItEasyNdr']['it_easy_ndr_status_id'])){
              $model->it_easy_ndr_status_id = $this->request->queryParams['ItEasyNdr']['it_easy_ndr_status_id'];
            }
            if(isset($this->request->queryParams['ItEasyNdr']['it_easy_ndr_disposition_id'])){
              $model->it_easy_ndr_disposition_id = $this->request->queryParams['ItEasyNdr']['it_easy_ndr_disposition_id'];
            }
            if(isset($this->request->queryParams['ItEasyNdr']['date_type_filter'])){
              $model->date_type_filter = $this->request->queryParams['ItEasyNdr']['date_type_filter'];
            }
            if(isset($this->request->queryParams['ItEasyOrderSearch']['date_to_date'])){
              $model->date_to_date = $this->request->queryParams['ItEasyOrderSearch']['date_to_date'];
            }
            if(isset($this->request->queryParams['ItEasyOrderSearch']['date_from_date'])){
                $model->date_from_date = $this->request->queryParams['ItEasyOrderSearch']['date_from_date'];
            }
        }
        
        $today_report = ItEasyOrder::Orderndrnumbers($this->request->queryParams);
        // echo "<pre>"; print_r($today_report); die;
        return $this->render('index', [
            'model' => $model,
            'dataProvider' => $dataProvider,
          	'array_helper_courier' => $array_helper_courier,
          	'order_dispositiondata' => $order_dispositiondata,
          	'order_statusdata' => $order_statusdata,
          	'ndr_dispositiondata' => $ndr_dispositiondata,
          	'ndr_statusdata' => $ndr_statusdata,
            'Params' => $this->request->queryParams,
            'today_report' => $today_report
        ]);
    }
    
    public function actionUnideliveredOrders()
    {   
       
        $model = new ItEasyNdr();
        $dataProvider = $model->ndrdataunidelivered($this->request->queryParams);
      	$array_helper_courier = ItEasyOrder::ArrayHelperCourierData();
      	$order_status_list = ItEasyOrder::getAHelperOrderStatusForAgent();    
        $order_statusdata = ArrayHelper::map($order_status_list, 'it_easy_order_status_id', 'it_easy_order_status_name');
        $disposition_status_list = ItEasyOrder::getAHelperDispositionStatusForAgent();
        $order_dispositiondata = ArrayHelper::map($disposition_status_list, 'it_easy_order_disposition_id', 'it_easy_order_disposition_name');
      
      	$ndr_status_list = ItEasyOrder::getAHelperndrOrderStatusForAgent();    
        $ndr_statusdata = ArrayHelper::map($ndr_status_list, 'it_easy_order_status_id', 'it_easy_order_status_name');
        $disposition_ndr_list = ItEasyOrder::getAHelperndrDispositionStatusForAgent();
        $ndr_dispositiondata = ArrayHelper::map($disposition_ndr_list, 'it_easy_order_disposition_id', 'it_easy_order_disposition_name');
        $dataProvider->pagination->pageSize = 50;
        
        
        if(isset($this->request->queryParams)){
            if(isset($this->request->queryParams['ItEasyNdr']['it_easy_order_number'])){
              $model->it_easy_order_number = $this->request->queryParams['ItEasyNdr']['it_easy_order_number'];
            }
            if(isset($this->request->queryParams['ItEasyNdr']['it_easy_mobile_number'])){
              $model->it_easy_mobile_number = $this->request->queryParams['ItEasyNdr']['it_easy_mobile_number'];
            }
            if(isset($this->request->queryParams['ItEasyNdr']['it_easy_awb_number'])){
              $model->it_easy_awb_number = $this->request->queryParams['ItEasyNdr']['it_easy_awb_number'];
            }
            if(isset($this->request->queryParams['ItEasyNdr']['it_easy_courier_name'])){
              $model->it_easy_courier_name = $this->request->queryParams['ItEasyNdr']['it_easy_courier_name'];
            }
            if(isset($this->request->queryParams['ItEasyNdr']['it_easy_order_status_id'])){
              $model->it_easy_order_status_id = $this->request->queryParams['ItEasyNdr']['it_easy_order_status_id'];
            }
            if(isset($this->request->queryParams['ItEasyNdr']['it_easy_order_disposition_id'])){
              $model->it_easy_order_disposition_id = $this->request->queryParams['ItEasyNdr']['it_easy_order_disposition_id'];
            }
            if(isset($this->request->queryParams['ItEasyNdr']['it_easy_ndr_status_id'])){
              $model->it_easy_ndr_status_id = $this->request->queryParams['ItEasyNdr']['it_easy_ndr_status_id'];
            }
            if(isset($this->request->queryParams['ItEasyNdr']['it_easy_ndr_disposition_id'])){
              $model->it_easy_ndr_disposition_id = $this->request->queryParams['ItEasyNdr']['it_easy_ndr_disposition_id'];
            }
            if(isset($this->request->queryParams['ItEasyNdr']['date_type_filter'])){
              $model->date_type_filter = $this->request->queryParams['ItEasyNdr']['date_type_filter'];
            }
            if(isset($this->request->queryParams['ItEasyOrderSearch']['date_to_date'])){
              $model->date_to_date = $this->request->queryParams['ItEasyOrderSearch']['date_to_date'];
            }
            if(isset($this->request->queryParams['ItEasyOrderSearch']['date_from_date'])){
                $model->date_from_date = $this->request->queryParams['ItEasyOrderSearch']['date_from_date'];
            }
        }
        
        $today_report = ItEasyOrder::Orderndrnumbers($this->request->queryParams);
        // echo "<pre>"; print_r($today_report); die;
        return $this->render('unidelivered-process', [
            'model' => $model,
            'dataProvider' => $dataProvider,
          	'array_helper_courier' => $array_helper_courier,
          	'order_dispositiondata' => $order_dispositiondata,
          	'order_statusdata' => $order_statusdata,
          	'ndr_dispositiondata' => $ndr_dispositiondata,
          	'ndr_statusdata' => $ndr_statusdata,
            'Params' => $this->request->queryParams,
            'today_report' => $today_report
        ]);
    }

     public function actionAddStatus()
    {

          if (Yii::$app->request->post()){
            $order_model = new ItEasyOrder();
            $status_history = new ItEasyOrderStatusHistory();
            $model = ItEasyOrder::find()->where(['it_easy_order_id'=>$_REQUEST['ItEasyNdr']['it_easy_order_id']])->One();
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');
            $model->it_easy_ndr_status_id = $_REQUEST['ItEasyNdr']['it_easy_ndr_status_id'];
            $model->updated_by  = Yii::$app->user->identity->id;
            $model->it_easy_updated_time  = $currentDateTime;
            $model->save(false);
            // save status history data here
             ItEasyOrder::addOrderStatusHistory($_REQUEST['ItEasyNdr']['it_easy_order_id'],$_REQUEST['ItEasyNdr']['it_easy_ndr_status_id'],$_REQUEST['ItEasyNdr']['it_easy_comment']);
                Yii::$app->session->setFlash('success', "Your data has been saved!");
                return $this->redirect(['index']);
            }
    }

    public function actionAddDisposition()
    {
          if (Yii::$app->request->post()){

            $model = ItEasyOrder::find()->where(['it_easy_order_id'=>$_REQUEST['ItEasyNdr']['it_easy_order_id']])->One();
                date_default_timezone_set('Asia/kolkata');
                $currentDateTime = date('Y-m-d H:i:s');
                $model->it_easy_ndr_disposition_id = $_REQUEST['ItEasyNdr']['it_easy_ndr_disposition_id'];
                $model->it_easy_arrange_time = $_REQUEST['ItEasyNdr']['it_easy_arrange_time'];
                $model->updated_by  = Yii::$app->user->identity->id;
                $model->it_easy_updated_time  = $currentDateTime;
                $model->save(false);
                // save status history data here
                ItEasyOrder::addDispositionStatusHistory($_REQUEST['ItEasyNdr']['it_easy_order_id'],$_REQUEST['ItEasyNdr']['it_easy_ndr_disposition_id'],$_REQUEST['ItEasyNdr']['it_easy_comment']);
                Yii::$app->session->setFlash('success', "Your data has been saved!");
                return $this->redirect(Yii::$app->request->referrer);
            }
    }

    public function actionAssignNdr(){
        $ndr_tl = Yii::$app->request->get()['ItEasyNdr']['it_easy_ndr_tl'];
        $ndr_agent = Yii::$app->request->get()['ItEasyNdr']['it_easy_ndr_agent'];
        $ndr_agent_username = ItEasyUser::findOne(['id' => $ndr_agent]);
        $order_id = Yii::$app->request->get()['selection'];
        foreach($order_id as $key => $o_id){
            $order_status_id = ItEasyOrder::findOne(['it_easy_order_id' => $o_id]);
            ItEasyOrder::addOrderStatusHistory($o_id,$order_status_id->it_easy_order_status_id,'NDR Leads Assign to'.$ndr_agent_username->it_easy_username );
        }
        
        
        ItEasyOrder::updateAll(['it_easy_ndr_tl' =>$ndr_tl,'it_easy_ndr_agent'=>$ndr_agent, 'it_easy_updated_time' => date('Y-m-d H:i:s')], ['in','it_easy_order_id',$order_id]);
        Yii::$app->session->setFlash('success', "Record has been assigned successfuly");
        return $this->redirect(['index',$this->request->queryParams]);
    }
	
  
  
  	public function actionUpdate($it_easy_order_id)
    {
        $model = $this->findModel($it_easy_order_id);
        $product_model = new ItEasyOrderProduct();
      	$statusmodel = new ItEasyOrderStatusHistory();
        $dispositionmodel = new ItEasyOrderDispositionHistory();
        $statusndrmodel = new ItEasyOrderNdrStatusHistory();
        $dispositionndrmodel = new ItEasyOrderNdrdispositionHistory();
        $commentmodel = new ItEasyOrderHistory();

        if ($this->request->isPost && $model->load($this->request->post())) {
            $post = $this->request->post();
            // echo "<pre>"; print_r($post); die;
            if(isset($post['ItEasyOrder']['it_easy_shipping_code'])){
            $ipaddress = ItEasyOrder::getIpaddress();
            $get_device = ItEasyOrder::getDevicename();
            $browser = ItEasyOrder::getBrowsername();
            $get_financial_year = ItEasyFinancialYear::getFinancialyear();
            if(isset($post['ItEasyOrder']['it_easy_state_id'])){
                $get_state_data = ItEasyState::getStatedatabyId($post['ItEasyOrder']['it_easy_state_id']);
                $find_customer_data = ItEasyCustomer::FindCustomerbyMobile($post['ItEasyOrder']['it_easy_mobile_number']);
                if(empty($find_customer_data)){
                    $find_customer_data = ItEasyCustomer::SavecustomerModelFromMobile($post['ItEasyOrder'], $model->it_easy_order_id);
                    $model->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
                }else{
                    $model->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
                    if(!empty($find_customer_data->it_easy_order_ids)){
                        $customer_it_easy_order_ids = explode(',', $find_customer_data->it_easy_order_ids);
                        if (!in_array($model->it_easy_order_id, $customer_it_easy_order_ids)){
                            $find_customer_data->it_easy_order_ids = $find_customer_data->it_easy_order_ids.','.$model->it_easy_order_id;
                            $find_customer_data->save();
                        }
                    }
                }
                $model->it_easy_state = $get_state_data->it_easy_state_name;
                $model->it_easy_shipping_state = $get_state_data->it_easy_state_name;
                $model->it_easy_billing_state = $get_state_data->it_easy_state_name;
                $model->save();
                Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
                return $this->redirect(['update', 'it_easy_order_id' => $model->it_easy_order_id]);
            }

            $quantity_order = 0;
            $it_easy_total_price = 0;
            $it_easy_gst_price = 0;
            foreach ($post['ItEasyOrderProduct'] as $key => $value) {
                    if(isset($value['it_easy_product_id'])){
                        $quantity_order +=$value['it_easy_product_quantity'];
                        
                        $product_variation = ItEasyOrder::getProductVariationData($value['it_easy_product_id'], $value['it_easy_variation_id']);
                        
                        
                        $p_data = ItEasyOrder::FindProductbyid($value['it_easy_product_id']);
                        // echo "<pre>"; print_r($p_data); die;
                        $p_data_tax_percentage = $p_data->it_easy_product_tax;
                        if(!empty($p_data_tax_percentage)){
                            $tax_price_p = ROUND(($value['it_easy_product_total'] * $p_data_tax_percentage )/100, 2);
                        }else{
                            $tax_price_p = ROUND(($value['it_easy_product_total'] * 12 )/100, 2);
                        }
                        
                        // echo "<pre>"; print_r($p_data_tax_percentage); die;
                        $product_taxe = $value['it_easy_product_quantity'] * $tax_price_p;
                        $t_product_price = $value['it_easy_product_total'] * $value['it_easy_product_quantity'];
                        $it_easy_total_price +=  $t_product_price;
                        $it_easy_gst_price += $product_taxe;
                        $check_product_model = ItEasyOrder::getOrderProductbyOrderId($model->it_easy_order_id, $value['it_easy_product_id'], $value['it_easy_variation_id']);
                        if(empty($check_product_model)){
                            $orderProductModel = new ItEasyOrderProduct();
                            $orderProductModel->it_easy_order_id = $model->it_easy_order_id;
                        }else{
                            $orderProductModel = $check_product_model;
                        }
                        $orderProductModel->it_easy_product_id = $value['it_easy_product_id'];
                        $orderProductModel->it_easy_product_name = $product_variation['it_easy_product_name'];
                        $orderProductModel->it_easy_product_sku = $product_variation['it_easy_product_name'];
                        $orderProductModel->it_easy_variation_name = $product_variation['it_easy_variation_name']; 
                        $orderProductModel->it_easy_variation_id = $value['it_easy_variation_id'];
                        $orderProductModel->it_easy_product_quantity = $value['it_easy_product_quantity'];
                        $orderProductModel->it_easy_product_total = $t_product_price;
                        $orderProductModel->it_easy_product_price = $t_product_price - $product_taxe;
                        $orderProductModel->it_easy_product_tax = $product_taxe;
                        $orderProductModel->updated_time = date('Y-m-d H:i:s');
                        $orderProductModel->save();
                    } 
            }

            $model->save();
            if(!empty($model->it_easy_coupon_id)){
                $coupon_model = new ItEasyCouponHistory();
                $get_coupon_data = ItEasyOrder::getCoouponbyid($model->it_easy_coupon_id);
                    
                if($get_coupon_data->it_easy_coupon_type == 'Flat'){
                    $dis_coupon_value = $get_coupon_data->it_easy_discount;
                    $it_easy_total_price = $it_easy_total_price - $get_coupon_data->it_easy_discount;
                }else{
                    $dis_coupon_value = $it_easy_total_price * $get_coupon_data->it_easy_discount /  100;
                    $it_easy_total_price = $it_easy_total_price - $dis_coupon_value;
                }    
                $coupon_model->it_easy_order_id = $model->it_easy_order_id;
                $coupon_model->it_easy_coupon_id = $model->it_easy_coupon_id;
                $coupon_model->it_easy_customer_id  = $model->it_easy_customer_id;
                $coupon_model->it_easy_table_name = 'it_easy_order_'.$get_financial_year;
                $coupon_model->it_easy_coupon_code = $get_coupon_data->it_easy_coupon_code;
                $coupon_model->it_easy_coupon_discount = $dis_coupon_value;
                $coupon_model->it_easy_created_time = date('Y-m-d H:i:s');
                $coupon_model->save();
            }

            $get_paymentmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode($post['ItEasyOrder']['it_easy_payment_code']);
            $get_shippingmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode($post['ItEasyOrder']['it_easy_shipping_code']);
            if(!empty($get_shippingmethod->it_easy_method_value)){
                if($get_shippingmethod->it_easy_add_value_type == 'Flat'){
                    if($get_shippingmethod->it_easy_method_value_type == 'Add-Amount'){
                        $it_easy_total_price = $it_easy_total_price + $get_shippingmethod->it_easy_method_value;
                    }else{
                        $it_easy_total_price = $it_easy_total_price - $get_shippingmethod->it_easy_method_value;
                    }
                }else{
                    if($get_shippingmethod->it_easy_method_value_type == 'Add-Amount'){
                        $get_percentage_value = $it_easy_total_price * $get_shippingmethod->it_easy_method_value / 100;
                        $it_easy_total_price = $it_easy_total_price + $get_percentage_value;
                    }else{
                        $get_percentage_value = $it_easy_total_price * $get_shippingmethod->it_easy_method_value / 100;
                        $it_easy_total_price = $it_easy_total_price - $get_percentage_value;
                    }
                }
            }
             
            if(!empty($get_paymentmethod->it_easy_method_value)){
                if($get_paymentmethod->it_easy_add_value_type == 'Flat'){
                    if($get_paymentmethod->it_easy_method_value_type == 'Add-Amount'){
                         
                        $it_easy_total_price = $it_easy_total_price + $get_paymentmethod->it_easy_method_value;
                    }else{
                        $it_easy_total_price = $it_easy_total_price - $get_paymentmethod->it_easy_method_value;
                    }
                }else{
                    if($get_paymentmethod->it_easy_method_value_type == 'Add-Amount'){
                        $get_percentage_value = $it_easy_total_price * $get_paymentmethod->it_easy_method_value / 100;
                        $it_easy_total_price = $it_easy_total_price + $get_percentage_value;
                    }else{
                        $get_percentage_value = $it_easy_total_price * $get_paymentmethod->it_easy_method_value / 100;
                        $it_easy_total_price = $it_easy_total_price - $get_percentage_value;
                    }
                }
            }
			
            $model->it_easy_server_ip = $ipaddress;
            $model->it_easy_device = $get_device;
            $model->it_easy_browser = $browser; 
            $model->updated_by = Yii::$app->user->identity->id;
            $model->it_easy_updated_time = date('Y-m-d H:i:s');  
            $model->it_easy_total_price = $it_easy_total_price;
            $model->it_easy_gst_price = $it_easy_gst_price;
            $model->it_easy_product_quantity = $quantity_order;
            $model->save();
            Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
            return $this->redirect(['index', 'it_easy_order_id' => $model->it_easy_order_id]);
        }
        }
        if ($this->request->isPost && $statusndrmodel->load($this->request->post())) {
            $post = $this->request->post();
            if(isset($post['ItEasyOrderNdrStatusHistory']['it_easy_order_status_id'])){
              	if($model->it_easy_ndr_status_id != $post['ItEasyOrderNdrStatusHistory']['it_easy_order_status_id']){
                  if($post['ItEasyOrderNdrStatusHistory']['it_easy_order_status_id'] == '1'){
                    	$model->it_easy_converted_time = date('Y-m-d H:i:s');
                  }
                }
              			$model->it_easy_ndr_status_id = $post['ItEasyOrderNdrStatusHistory']['it_easy_order_status_id'];
              			$model->it_easy_updated_time = date('Y-m-d H:i:s');
              			$model->save();
                $addOrderStatusHistory = ItEasyOrder::addndrOrderStatusHistory($model->it_easy_order_id, $post['ItEasyOrderNdrStatusHistory']['it_easy_order_status_id'], $post['ItEasyOrderNdrStatusHistory']['it_easy_comment']);
                Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
                return $this->redirect(['update', 'it_easy_order_id' => $model->it_easy_order_id]);
            }
        }
        if ($this->request->isPost && $dispositionndrmodel->load($this->request->post())) {
            $post = $this->request->post();
            if(isset($post['ItEasyOrderNdrdispositionHistory']['it_easy_order_disposition_id'])){
                $addOrderStatusHistory = ItEasyOrder::addndrDispositionStatusHistory($model->it_easy_order_id, $post['ItEasyOrderNdrdispositionHistory']['it_easy_order_disposition_id'], $post['ItEasyOrderNdrdispositionHistory']['it_easy_comment']);
              
              	$model->it_easy_order_disposition_id = $post['ItEasyOrderNdrdispositionHistory']['it_easy_order_disposition_id'];
              	if(!empty($post['ItEasyOrder']['it_easy_arrange_time'])){
              	    $model->it_easy_arrange_time = $post['ItEasyOrder']['it_easy_arrange_time'];
              	}
                $model->it_easy_updated_time = date('Y-m-d H:i:s');
                $model->save();
                Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
                return $this->redirect(['update', 'it_easy_order_id' => $model->it_easy_order_id]);
            }
        }
    
        if ($this->request->isPost && $statusmodel->load($this->request->post())) {
            $post = $this->request->post();
            if(isset($post['ItEasyOrderStatusHistory']['it_easy_order_status_id'])){
              	if($model->it_easy_order_status_id != $post['ItEasyOrderStatusHistory']['it_easy_order_status_id']){
                  if($post['ItEasyOrderStatusHistory']['it_easy_order_status_id'] == '1'){
                    	$model->it_easy_converted_time = date('Y-m-d H:i:s');
                  }
                }
              			$model->it_easy_order_status_id = $post['ItEasyOrderStatusHistory']['it_easy_order_status_id'];
              			$model->it_easy_updated_time = date('Y-m-d H:i:s');
              			$model->save();
                $addOrderStatusHistory = ItEasyOrder::addOrderStatusHistory($model->it_easy_order_id, $post['ItEasyOrderStatusHistory']['it_easy_order_status_id'], $post['ItEasyOrderStatusHistory']['it_easy_comment']);
                Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
                return $this->redirect(['update', 'it_easy_order_id' => $model->it_easy_order_id]);
            }
        }
        if ($this->request->isPost && $dispositionmodel->load($this->request->post())) {
            $post = $this->request->post();
            if(isset($post['ItEasyOrderDispositionHistory']['it_easy_order_disposition_id'])){
                $addOrderStatusHistory = ItEasyOrder::addDispositionStatusHistory($model->it_easy_order_id, $post['ItEasyOrderDispositionHistory']['it_easy_order_disposition_id'], $post['ItEasyOrderDispositionHistory']['it_easy_comment']);
              
              	$model->it_easy_order_disposition_id = $post['ItEasyOrderDispositionHistory']['it_easy_order_disposition_id'];
                $model->it_easy_updated_time = date('Y-m-d H:i:s');
                $model->save();
                Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
                return $this->redirect(['update', 'it_easy_order_id' => $model->it_easy_order_id]);
            }
        }
        if ($this->request->isPost && $commentmodel->load($this->request->post())) {
            $post = $this->request->post();
            if(isset($post['ItEasyOrderHistory']['it_easy_comment'])){
                $addOrderStatusHistory = ItEasyOrder::addOrderSHistory($model->it_easy_order_id, $post['ItEasyOrderHistory']['it_easy_comment']);
              	$model->it_easy_comment = $post['ItEasyOrderHistory']['it_easy_comment'];
                $model->it_easy_updated_time = date('Y-m-d H:i:s');
                $model->save();
                Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
                return $this->redirect(['update', 'it_easy_order_id' => $model->it_easy_order_id]);
            }
        }
        $prod_model = $this->findProductModel($it_easy_order_id);
        $get_coupon_data = ItEasyOrder::getCoouponbyidArrayHelper($model->it_easy_coupon_id);
        $coupon_data = ArrayHelper::map($get_coupon_data, 'it_easy_id', 'it_easy_coupon_code');
        $get_paymentmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode($model->it_easy_payment_code);
        $get_shippingmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode($model->it_easy_shipping_code);
        if(!empty($model->it_easy_coupon_id)){
            $get_coupon_data = ItEasyOrder::getCoouponHistorybyOrderid($model->it_easy_order_id);
        }
        $order_status_history = ItEasyOrder::getOrderStatusHistorybyOrderId($model->it_easy_order_id);
        $order_disposition_history = ItEasyOrder::getOrderDispositionHistorybyOrderId($model->it_easy_order_id);
      	$order_ndrstatus_history = ItEasyOrder::getOrderndrStatusHistorybyOrderId($model->it_easy_order_id);
        $order_ndrdisposition_history = ItEasyOrder::getOrderndrDispositionHistorybyOrderId($model->it_easy_order_id);
        $order_history = ItEasyOrder::getOrderHistorybyOrderId($model->it_easy_order_id);

        $stateList = ItEasyState::getStateallData();
        $statedata = ArrayHelper::map($stateList, 'it_easy_id', 'it_easy_state_name');
        $order_status_list = ItEasyOrder::getAHelperOrderStatusForAgent();    
        $order_statusdata = ArrayHelper::map($order_status_list, 'it_easy_order_status_id', 'it_easy_order_status_name');
        $disposition_status_list = ItEasyOrder::getAHelperndrDispositionStatusForAgent();
        $order_dispositiondata = ArrayHelper::map($disposition_status_list, 'it_easy_order_disposition_id', 'it_easy_order_disposition_name');
      	$ndr_status_list = ItEasyOrder::getAHelperndrOrderStatusForAgent();    
        $ndr_statusdata = ArrayHelper::map($ndr_status_list, 'it_easy_order_status_id', 'it_easy_order_status_name');
        $disposition_ndr_list = ItEasyOrder::getAHelperndrDispositionStatusForAgent();
        $ndr_dispositiondata = ArrayHelper::map($disposition_ndr_list, 'it_easy_order_disposition_id', 'it_easy_order_disposition_name');
        $shippingmethod_list_data = ItEasyOrder::getAHelperShippingMethod();
        $shipping_method = ArrayHelper::map($shippingmethod_list_data, 'it_easy_method_code', 'it_easy_method_name' );
        $payemntmethod_list_data = ItEasyOrder::getAHelperPaymentMethod();
        $payment_method = ArrayHelper::map($payemntmethod_list_data, 'it_easy_method_code', 'it_easy_method_name' );
      
      	$order_dispatch_details = ItEasyOrderDispatch::findOne(['it_easy_order_id' => $model->it_easy_order_id]);
      
      	if(!empty($order_dispatch_details)){
          	$trackModel = ItEasyOrderTrack::find()->andWhere(['or', ['it_easy_awb_number' => $order_dispatch_details->it_easy_awb_number], ['it_easy_sec_awb_number' => $order_dispatch_details->it_easy_return_awb ] ])->orderBy(['it_easy_courier_time' => SORT_DESC])->all();
        }else{
         	$trackModel = []; 
          	$order_dispatch_details = [];
        }

        return $this->render('update', [
            'model' => $model,
            'product_model' => $product_model,
            'coupon_data' => $coupon_data,
            'statedata' => $statedata,
            'prod_model' => $prod_model,
            'get_paymentmethod' => $get_paymentmethod,
            'get_shippingmethod' => $get_shippingmethod,
            'get_coupon_data' => $get_coupon_data,
            'order_status_history' => $order_status_history,
            'order_history' => $order_history,
            'order_disposition_history' => $order_disposition_history,
            'statusmodel' => $statusmodel,
            'dispositionmodel' => $dispositionmodel,
            'commentmodel' => $commentmodel,
            'order_statusdata' => $order_statusdata,
            'order_dispositiondata' => $order_dispositiondata,
            'shipping_method' => $shipping_method,
            'payment_method' => $payment_method,
          	'statusndrmodel' => $statusndrmodel,
          	'dispositionndrmodel' => $dispositionndrmodel,
          	'order_ndrstatus_history' => $order_ndrstatus_history,
          	'order_ndrdisposition_history' => $order_ndrdisposition_history,
          	'order_dispositiondata' => $order_dispositiondata,
          	'ndr_statusdata' => $ndr_statusdata,
          	'order_dispatch_details' => $order_dispatch_details,
          	'trackModel' => $trackModel,
          	
          
        ]);
    }
  
  
  	public function actionTrackhistory($it_easy_order_id='',$awbnumber=''){
       if(isset($it_easy_order_id) && !empty($it_easy_order_id)){
      	    $order_dispatch_details = ItEasyOrderDispatch::findOne(['it_easy_order_id' => $it_easy_order_id]);
        }else{
            $order_dispatch_details = ItEasyOrderDispatch::findOne(['it_easy_awb_number' => $awbnumber]);
        }
      
      	if(!empty($order_dispatch_details)){
          	$trackModel = ItEasyQueryTracking::find()->andWhere(['awb_number' => $order_dispatch_details->it_easy_awb_number ])->orderBy(['status_time' => SORT_DESC])->all();
        }else{
         	$trackModel = []; 
          	$order_dispatch_details = [];
        }
        
      	return $this->render('track-order', [
            'trackModel' => $trackModel,
            'order_dispatch_details' => $order_dispatch_details,
        ]);
      	
    }
    
    
    //sunil test function
    	public function actionTrackhistory1($it_easy_order_id='',$awbnumber=''){
       if(isset($it_easy_order_id) && !empty($it_easy_order_id)){
      	    $order_dispatch_details = ItEasyOrderDispatch::findOne(['it_easy_order_id' => $it_easy_order_id]);
        }else{
            $order_dispatch_details = ItEasyOrderDispatch::findOne(['it_easy_awb_number' => $awbnumber]);
        }
      
      	if(!empty($order_dispatch_details)){
          	$trackModel = ItEasyQueryTracking::find()->andWhere(['awb_number' => $order_dispatch_details->it_easy_awb_number ])->orderBy(['status_time' => SORT_DESC])->all();
          	echo "<pre>";
          	print_r($trackModel);die;
        }else{
         	$trackModel = []; 
          	$order_dispatch_details = [];
        }
        
      	return $this->render('track-order', [
            'trackModel' => $trackModel,
            'order_dispatch_details' => $order_dispatch_details,
        ]);
      	
    }
    
    
    //end
    
    public function actionAwbTracking(){

    return $this->render('awb-tracking');

    }
  	
  	protected function findProductModel($it_easy_order_id)
    {
        if (($model = ItEasyOrderProduct::findAll(['it_easy_order_id' => $it_easy_order_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
  
  	protected function findModel($it_easy_order_id)
    {
        if (($model = ItEasyOrder::findOne(['it_easy_order_id' => $it_easy_order_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    
    public function actionExportunidelier()
    {   
  
        $searchModel = new ItEasyNdr();
        $query = $searchModel->ndrdataunidelivered($this->request->queryParams);
        $data_fetch = $query->asArray()->all();
        
        $array = []; 
        $r = 0;
        foreach ($data_fetch as $key1 => $value1) {
                $array[$r] =$value1;
                $array[$r]['pickup_pincode'] = '110020';
                $array[$r]['pickup_city'] = 'Delhi';
                $array[$r]['pickup_state'] = 'New Delhi';
                $r++;
        }
        // foreach ($data_fetch as $key1 => $value1) {
        //     $product = ItEasyOrder::GrtOrderProducts($value1['order_id']);
        //     foreach ($product as $key => $value) {
        //         if($key  == 0){
        //             $array[$r] =$value1;
        //             $array[$r]['variation_name'] =$value['it_easy_variation_name'];
        //             $array[$r]['product_name'] =$value['it_easy_product_name'];
        //             $array[$r]['quantity'] =$value['it_easy_product_quantity'];
        //             $array[$r]['without_GST'] =$value['it_easy_product_price'];
        //             $array[$r]['product_total_price'] =$value['it_easy_product_total'];
        //             $array[$r]['product_tax'] =$value['it_easy_product_tax'];

        //         }else{
        //             $array[$r]['order_number'] = '';
        //             $array[$r]['other_order_id'] = '';
        //             $array[$r]['invoice_number'] = '';
        //             $array[$r]['order_type'] = '';
        //           	$array[$r]['awb_number'] = '';
        //           	$array[$r]['courier_name'] = '';
        //             $array[$r]['total_price'] = '';
        //             $array[$r]['GST_Price'] = '';
        //             $array[$r]['First_Status'] = '';
        //             $array[$r]['Status_Name'] = '';
        //             $array[$r]['Disposition_Name'] = '';
        //           	$array[$r]['ndr_Status_Name'] = '';
        //             $array[$r]['ndr_Disposition_Name'] = '';
        //           	$array[$r]['it_easy_arrange_time'] = '';
        //             $array[$r]['customer'] = '';
        //             $array[$r]['mobile_number'] = '';
        //             $array[$r]['Address_1'] = '';
        //             $array[$r]['Address_2'] = '';
        //             $array[$r]['City'] = '';
        //             $array[$r]['State'] = '';
        //             $array[$r]['Pincode'] = '';
        //             $array[$r]['TL_username'] = '';
        //             $array[$r]['Agent_Username'] = '';
        //             $array[$r]['Marketer_Publisher'] = '';
        //             $array[$r]['Click_ID'] = '';
        //             $array[$r]['Created_Time'] = '';
        //             $array[$r]['Updated_Time'] = '';
        //             $array[$r]['Assigned_Time'] = '';
        //             $array[$r]['Placed_Time'] = '';
        //             $array[$r]['Confirmation_Time'] = '';
        //             $array[$r]['variation_name'] =$value['it_easy_variation_name'];
        //             $array[$r]['product_name'] =$value['it_easy_product_name'];
        //             $array[$r]['quantity'] =$value['it_easy_product_quantity'];
        //             $array[$r]['without_GST'] =$value['it_easy_product_price'];
        //             $array[$r]['product_total_price'] =$value['it_easy_product_total'];
        //             $array[$r]['product_tax'] =$value['it_easy_product_tax'];
        //         }

        //         $r++;
        //     }
        //  }
        //  echo "<pre>";print_r($array);die;
        $exporter = new Spreadsheet([
            'dataProvider' => new ArrayDataProvider([
                'allModels' => $array,
            ]),
            'columns' => [
                [   'attribute' => 'platform_name'],
                [   'attribute' => 'order_number'],
                [   'attribute' => 'courier_name'],
                [   'attribute' => 'sub_courier_name'],
              	[   'attribute' => 'awb_number'],
                [   'attribute' => 'Status_Name'],
                [   'attribute' => 'total_price'],
                [   'attribute' => 'collective_price'],
                [   'attribute' => 'order_type'],
                [   'attribute' => 'payment_method'],
                [   'attribute' => 'customer'],
                [   'attribute' => 'mobile_number'],
                [   'attribute' => 'Address_1'],
                [   'attribute' => 'Address_2'],
                [   'attribute' => 'Pincode'],
                [   'attribute' => 'City'],
                [   'attribute' => 'State'],
                [   'attribute' => 'pickup_pincode'],
                [   'attribute' => 'pickup_city'],
                [   'attribute' => 'pickup_state'],
                [   'attribute' => 'awb_time'],
                [   'attribute' => 'pickup_time'],
              	[   'attribute' => 'first_attempt_date'],
                [   'attribute' => 'first_ndr_reason'],
                [   'attribute' => 'second_attempt_date'],
                [   'attribute' => 'second_ndr_reason'],
                [   'attribute' => 'third_attempt_date'],
                [   'attribute' => 'third_ndr_reason'],
                [   'attribute' => 'last_scan_date'],
                [   'attribute' => 'last_ndr_reason'],
              	[   'attribute' => 'SCAN_REASON'],
              	[   'attribute' => 'ndr_Disposition_Name'],
              	[   'attribute' => 'attempt_count'],
                [   'attribute' => 'Delivered_Time'],
                [   'attribute' => 'rto_initiate_date'],
                [   'attribute' => 'rto_date'],
                [   'attribute' => 'ndr_Disposition_Name'],
           
            ],
        ]);
        return $exporter->send('NDR-Export.xlsx');
        
    }
    
    
  	public function actionExport()
    {   
  
        $searchModel = new ItEasyNdr();
        $query = $searchModel->ndrdata($this->request->queryParams);
        $data_fetch = $query->asArray()->all();
  
        $array = []; 
        $r = 0;
        foreach ($data_fetch as $key1 => $value1) {
            $product = ItEasyOrder::GrtOrderProducts($value1['order_id']);
            foreach ($product as $key => $value) {
                if($key  == 0){
                    $array[$r] =$value1;
                    $array[$r]['variation_name'] =$value['it_easy_variation_name'];
                    $array[$r]['product_name'] =$value['it_easy_product_name'];
                    $array[$r]['quantity'] =$value['it_easy_product_quantity'];
                    $array[$r]['without_GST'] =$value['it_easy_product_price'];
                    $array[$r]['product_total_price'] =$value['it_easy_product_total'];
                    $array[$r]['product_tax'] =$value['it_easy_product_tax'];

                }else{
                    $array[$r]['order_number'] = '';
                    $array[$r]['other_order_id'] = '';
                    $array[$r]['invoice_number'] = '';
                    $array[$r]['order_type'] = '';
                  	$array[$r]['awb_number'] = '';
                  	$array[$r]['courier_name'] = '';
                    $array[$r]['total_price'] = '';
                    $array[$r]['GST_Price'] = '';
                    $array[$r]['First_Status'] = '';
                    $array[$r]['Status_Name'] = '';
                    $array[$r]['Disposition_Name'] = '';
                  	$array[$r]['ndr_Status_Name'] = '';
                    $array[$r]['ndr_Disposition_Name'] = '';
                  	$array[$r]['it_easy_arrange_time'] = '';
                    $array[$r]['customer'] = '';
                    $array[$r]['mobile_number'] = '';
                    $array[$r]['Address_1'] = '';
                    $array[$r]['Address_2'] = '';
                    $array[$r]['City'] = '';
                    $array[$r]['State'] = '';
                    $array[$r]['Pincode'] = '';
                    $array[$r]['TL_username'] = '';
                    $array[$r]['Agent_Username'] = '';
                    $array[$r]['Marketer_Publisher'] = '';
                    $array[$r]['Click_ID'] = '';
                    $array[$r]['Created_Time'] = '';
                    $array[$r]['Updated_Time'] = '';
                    $array[$r]['Assigned_Time'] = '';
                    $array[$r]['Placed_Time'] = '';
                    $array[$r]['Confirmation_Time'] = '';
                    $array[$r]['variation_name'] =$value['it_easy_variation_name'];
                    $array[$r]['product_name'] =$value['it_easy_product_name'];
                    $array[$r]['quantity'] =$value['it_easy_product_quantity'];
                    $array[$r]['without_GST'] =$value['it_easy_product_price'];
                    $array[$r]['product_total_price'] =$value['it_easy_product_total'];
                    $array[$r]['product_tax'] =$value['it_easy_product_tax'];
                }

                $r++;
            }
         }
        // echo "<pre>";print_r($array);die;
        $exporter = new Spreadsheet([
            'dataProvider' => new ArrayDataProvider([
                'allModels' => $array,
            ]),
            'columns' => [
                [   'attribute' => 'order_number'],
                [   'attribute' => 'other_order_id'],
                [   'attribute' => 'invoice_number'],
                [   'attribute' => 'order_type'],
              	[   'attribute' => 'courier_name'],
              	[   'attribute' => 'awb_number'],
                [   'attribute' => 'total_price'],
                [   'attribute' => 'GST_Price'],
                [   'attribute' => 'First_Status'],
                [   'attribute' => 'Status_Name'],
                [   'attribute' => 'Disposition_Name'],
              	[   'attribute' => 'ndr_Status_Name'],
              	[   'attribute' => 'ndr_Disposition_Name'],
              	[   'attribute' => 'it_easy_arrange_time'],
                [   'attribute' => 'customer'],
                [   'attribute' => 'mobile_number'],
                [   'attribute' => 'Address_1'],
                [   'attribute' => 'Address_2'],
                [   'attribute' => 'City'],
                [   'attribute' => 'State'],
                [   'attribute' => 'Pincode'],
                [   'attribute' => 'TL_username'],
                [   'attribute' => 'Agent_Username'],
                [   'attribute' => 'Marketer_Publisher'],
                [   'attribute' => 'Click_ID'],
                [   'attribute' => 'Created_Time'],
                [   'attribute' => 'Updated_Time'],
                [   'attribute' => 'Assigned_Time'],
                [   'attribute' => 'Confirmation_Time'],
                [   'attribute' => 'product_name'],
                [   'attribute' => 'variation_name'],
                [   'attribute' => 'quantity'],
                [   'attribute' => 'without_GST'],
                [   'attribute' => 'product_tax'],
                [   'attribute' => 'product_total_price'],
           
            ],
        ]);
        return $exporter->send('Order-Export.xlsx');
        
    }
  	
  	
}
