<?php

namespace backend\controllers;

use backend\models\ItEasyOrder;
use backend\models\ItEasyOrderSearch;
use backend\models\ItEasyStore;
use backend\models\ItEasyProductVariation;
use backend\models\ItEasyShippingPaymentMethod;
use backend\models\ItEasyCouponHistory;
use backend\models\ItEasyState;
use backend\models\ItEasyCustomer;
use backend\models\ItEasyFinancialYear;
use backend\models\ItEasyOrderProduct;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use yii\filters\AccessControl;
use yii\helpers\ArrayHelper;
use backend\models\ItEasyOrderStatusHistory;
use backend\models\ItEasyOrderDispositionHistory;
use backend\models\ItEasyOrderHistory;
use backend\models\ItEasyRaiseRequestSearch;
use backend\models\ItEasyRaiseRequest;
use yii2tech\spreadsheet\Spreadsheet;
use yii\data\ActiveDataProvider;
use yii\data\ArrayDataProvider;
use backend\models\ItEasyOrderDispatch;
use backend\models\ItEasyOrderTrack;
use backend\models\ItEasyOrderStatus;
use backend\models\ItEasyOrderDisposition;
use backend\models\ItEasyChanel;
use common\models\User;
use backend\components\webhookSender;




/**
 * OrderController implements the CRUD actions for ItEasyOrder model.
 */
class OrderController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyOrder models.
     *
     * @return string
     */
    
    public function actionTrack(){
        date_default_timezone_set("Asia/Kolkata");
        $current_date = date('Y-m-d H:i:s');
        $array = ['failed', 'Pending_order', 'Return Delivered', 'RTO Delivered', 'Delivered'];
        $shipping_id = '3';
        $orders = ItEasyOrderDispatch::find()->select(['it_easy_order_id', 'it_easy_awb_number'])->where(['not in','it_easy_order_status',$array])->andWhere(['it_easy_shipping_id' => $shipping_id])->limit(100)->offset(400)->orderBy(['it_easy_order_id' => SORT_ASC])->asArray()->all();
        echo "<pre>"; print_r($orders);
            $awb_number = [];
            $r = 1;
            $s =0;
        foreach($orders as $key => $value){
            if($r < 11){
                $awb_number[$s][] = $value['it_easy_awb_number'];
                $r++;
            }else{
                $r = 1;
                $s++;
                $awb_number[$s][] = $value['it_easy_awb_number'];
                $r++;
            }
        }
        // echo "<pre>"; print_r($awb_number); die;
        $orderModel = new ItEasyOrderTrack();
        $awb_details = $orderModel->getTrackxpressbees($awb_number);
    }
  	
  	public function actionFetch(){
        $shopifyOrder = ItEasyChanel::find()->where(['status' => 'Active'])->andWhere(['fetch_Type' => 'Auto'])->limit(5)->asArray()->all();
      
        if(!empty($shopifyOrder)){
            foreach($shopifyOrder as $key => $value){
                
                $url = $value['shop_url'];
                $username = $value['api_key'];
                $password = $value['api_password'];
                date_default_timezone_set("Asia/Kolkata");
                $c_date=date("Y-m-d H:i:s");
                switch ($value['channel_name']) {
                	case 'Shopify':
                		$today_date =date('Y-m-d',strtotime("-1 days"));
                        $today_time = date('H:i:s');
                        $request_url = $url."/admin/api/2020-04/orders.json?created_at_min=".$today_date."T".$today_time."&limit=250&fulfillment_status=unfulfilled";
                        $request_handle = curl_init($request_url);
                        curl_setopt($request_handle, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
                        curl_setopt($request_handle, CURLOPT_USERPWD, $username . ":" . $password); 
                        curl_setopt($request_handle, CURLOPT_RETURNTRANSFER, true);
                        $request_result = curl_exec($request_handle);
                        $data_val = json_decode($request_result);
                  		// echo "<pre>"; print_r($data_val); die;
                        if(!empty($data_val->orders)) {
                            $save_data = [];
                          	$xr = 0;
                            foreach($data_val->orders as $key => $orders){
                            //   echo "<pre>"; print_r($orders); die;
                            $order_number = 's'.str_replace("#","",$orders->name);
                            $created_Date = date("Y-m-d H:i:s");
                            $created_t_date =  date("Y-m-d H:i:s", strtotime($orders->created_at));
                        
                            $addingFiveMinutes= strtotime($created_t_date.' + 25 minute');
                            $check_date = date('Y-m-d H:i:s', $addingFiveMinutes);
                            if($check_date <  $created_Date){
                            $chk_order = ItEasyOrder::find()->where(['it_easy_other_order_id' => $order_number])->asArray()->one();
                                if(empty($chk_order)){
                                    
                                    // echo "<pre>";  print_r($orders); die;
                                  	$model = new ItEasyOrder();
                                    
                                    $model->it_easy_other_order_id = 's'.str_replace("#","",$orders->name);
                                  	$model->shopify_order_id = $orders->id;
                                    if( (isset($orders->payment_gateway_names[0]) && ($orders->payment_gateway_names[0] == 'razorpay' || $orders->payment_gateway_names[0] == 'Razorpay Secure')) || (str_contains($orders->tags, 'ONLINE'))  ){
                                        $payment_mode = 'Prepaid';
                                      	$first_status = 'Prepaid';
                                        $cod_amount = $orders->total_price;
                                      	$order_status = '21';
                                    }else{
                                      	$payment_mode = 'COD';
                                      	$first_status = 'COD';
                                        $cod_amount = $orders->total_price;
                                      	$order_status = '21'; 
                                    }
                                    if((str_contains($orders->tags, 'ONLINE')) && $orders->payment_gateway_names[0] == 'shopflo'){
                                        $order_status = '1';
                                        $model->it_easy_order_disposition_id = '3';
                                        $model->it_easy_assigned_by = '1';
                                        $model->it_easy_assigned_to = '231';
                                    }else{
                                        $order_status = '21';
                                        $model->it_easy_assigned_by = '0';
                                        $model->it_easy_assigned_to = '0';
                                        $model->it_easy_order_disposition_id = '0';
                                    }
                                  	$partially_paid = $orders->total_price - $orders->total_outstanding;
                                    $total_outstanding = $orders->total_outstanding;
                                    $price = $orders->total_price;
                                  	$height = 0;
                                    $length = 0;
                                    $width = 0;
                                    $weight = 0.5;
                                  	$order_product = [];
                                  	$product_quantity = 0;
                                  	if(!empty($orders->line_items)){
                                      	foreach($orders->line_items as $key => $items){
                                          	$product_quantity +=$items->fulfillable_quantity;
                                          	$order_product[$key]['shopify_product_id'] = $items->product_id;
                                          	$order_product[$key]['shopify_variant_id'] = $items->variant_id;
                                          	$order_product[$key]['product_name'] = $items->title;
                                        if(!empty($items->variant_title)){  	$order_product[$key]['variation_name'] = $items->variant_title;
                                        }else{
                                            $order_product[$key]['variation_name'] = 'Pack of 1';
                                        }
                                          	$order_product[$key]['quantity'] = $items->fulfillable_quantity;
                                          	$order_product[$key]['price'] = $items->price;
                                        }
                                    }
                                  	$model->it_easy_product_quantity = $product_quantity;
                                  	if(!isset($orders->billing_address) || empty($orders->billing_address)){
                                      	if(isset($orders->shipping_address)){
                                          	$orders->billing_address = $orders->shipping_address;
                                          
                                        }
                                      	
                                	}
                                  	
                                  	$ipaddress = $orders->browser_ip;
                                    $get_device = $orders->device_id;
                                    $browser = ItEasyOrder::getBrowsername();
                                    $get_financial_year = ItEasyFinancialYear::getFinancialrealyear();
                                    $model->it_easy_financial_year = $get_financial_year;
                                    $model->it_easy_store_id = ItEasyStore::getStorename()->it_easy_id;
                                    $model->it_easy_store_name = ItEasyStore::getStorename()->it_easy_store_name;
                                  	if(!empty($orders->billing_address->province) && isset($orders->billing_address->province)){
                                      	
                                  		$get_state_data = ItEasyState::getStatedatabyStateName($orders->billing_address->province);
                                      	if(empty($get_state_data)){
                                          	$model->it_easy_state = 'Delhi';
                                            $model->it_easy_shipping_state = 'Delhi';
                                            $model->it_easy_billing_state = 'Delhi';
                                        }else{
                                          $model->it_easy_state_id = $get_state_data->it_easy_id;
                                          $model->it_easy_shipping_state_id = $get_state_data->it_easy_id;
                                          $model->it_easy_billing_state_id = $get_state_data->it_easy_id;
                                          $model->it_easy_state = $get_state_data->it_easy_state_name;
                                          $model->it_easy_shipping_state = $get_state_data->it_easy_state_name;
                                          $model->it_easy_billing_state = $get_state_data->it_easy_state_name;
                                        }
                                    }else{
                                      	$model->it_easy_state = 'Missing Orders';
                                        $model->it_easy_shipping_state = 'Missing Orders';
                                        $model->it_easy_billing_state = 'Missing Orders';
                                    }
                                    $get_paymentmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode($payment_mode);
                                    
                                    
                                    if(isset($orders->total_shipping_price_set->shop_money->amount) && !empty($orders->total_shipping_price_set->shop_money->amount) && ($orders->total_shipping_price_set->shop_money->amount == '50.00')){
                                        $get_shippingmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode('Flat Shipping 50 Rs.');
                                    }else if(isset($orders->total_shipping_price_set->shop_money->amount) && !empty($orders->total_shipping_price_set->shop_money->amount) && ($orders->total_shipping_price_set->shop_money->amount == '100.00')){
                                        $get_shippingmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode('Flat Shipping 100 Rs.');
                                    }else{
                                        $get_shippingmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode('Free Shipping');
                                    }
                                    
                                    
                                  	if(isset($orders->billing_address->first_name)){
                                  		$model->it_easy_firstname = $orders->billing_address->first_name;
                                      	$model->it_easy_shipping_firstname = $orders->billing_address->first_name;
                                      	$model->it_easy_billing_firstname = $orders->billing_address->first_name;
                                    }else{
                                      	$model->it_easy_firstname = '';
                                      	$model->it_easy_shipping_firstname = '';
                                      	$model->it_easy_billing_firstname = '';
                                      	
                                    }
                                    if(!empty($orders->billing_address->last_name) && isset($orders->billing_address->last_name)){
                                        $model->it_easy_lastname = $orders->billing_address->last_name;
                                        $model->it_easy_shipping_lastname = $orders->billing_address->last_name;
                                        $model->it_easy_billing_lastname = $orders->billing_address->last_name;
                                    }else{
                                        $model->it_easy_lastname = $model->it_easy_firstname;
                                        $model->it_easy_shipping_lastname = $model->it_easy_firstname;
                                        $model->it_easy_billing_lastname = $model->it_easy_firstname;
                                    }
                                    if(empty($model->it_easy_firstname)){
                                        if(empty($model->it_easy_lastname)){
                                            $model->it_easy_firstname = 'Missing Order';
                                          	$model->it_easy_shipping_firstname = 'Missing Order';
                                          	$model->it_easy_billing_firstname = 'Missing Order';
                                        }else{
                                            $model->it_easy_firstname = $orders->billing_address->last_name;
                                            $model->it_easy_shipping_firstname = $orders->billing_address->last_name;
                                            $model->it_easy_billing_firstname = $orders->billing_address->last_name;
                                        }
                                    }
                                    if(empty($model->it_easy_lastname)){
                                        $model->it_easy_lastname = 'Missing Order';
                                        $model->it_easy_shipping_lastname = 'Missing Order';
                                      	$model->it_easy_billing_lastname = 'Missing Order';
                                    }

                                    
                                    if(empty($orders->billing_address->address1) && !isset($orders->billing_address->address1)){
                                        $model->it_easy_address_1 = 'Missing-Order';
                                      	$model->it_easy_shipping_address_1 = 'Missing-Order';
                                      	$model->it_easy_billing_address_1 = 'Missing-Order';
                                    }else{
                                      	$model->it_easy_address_1 = $orders->billing_address->address1;
                                        $model->it_easy_shipping_address_1 = $orders->billing_address->address1;
                                        $model->it_easy_billing_address_1 = $orders->billing_address->address1;
                                    }
                                    
                                    if(empty($orders->billing_address->address2) && !isset($orders->billing_address->address2)){
                                        $model->it_easy_address_2 = 'Missing-Order';
                                      	$model->it_easy_shipping_address_2 = 'Missing-Order';
                                      	$model->it_easy_billing_address_2 = 'Missing-Order';
                                    }else{
                                      	$model->it_easy_address_2 = $orders->billing_address->address2;
                                        $model->it_easy_shipping_address_2 = $orders->billing_address->address2;
                                        $model->it_easy_billing_address_2 = $orders->billing_address->address2;
                                    }

                                    
                                    if(empty($orders->billing_address->city)  && !isset($orders->billing_address->city)){
                                        $model->it_easy_city = 'Missing';
                                      	$model->it_easy_shipping_city = 'Missing';
                                  		$model->it_easy_billing_city = 'Missing';
                                    }else{
                                      	$model->it_easy_city = $orders->billing_address->city;
                                        $model->it_easy_shipping_city = $orders->billing_address->city;
                                        $model->it_easy_billing_city = $orders->billing_address->city;
                                    }
                                  	
                                  	
                                    if(empty($orders->billing_address->zip) && !isset($orders->billing_address->zip)){
                                        $model->it_easy_pincode = '000000';
                                      	$model->it_easy_shipping_pincode = '000000';
                                  		$model->it_easy_billing_pincode = '000000';
                                    }else{
                                      	$model->it_easy_pincode = $orders->billing_address->zip;
                                      	$recommand =  ItEasyOrder::getServicealAPIbyPincode($model->it_easy_pincode);
                                      	
                                      	$model->it_easy_order_serviceable = $recommand;
                                        $model->it_easy_shipping_pincode = $orders->billing_address->zip;
                                        $model->it_easy_billing_pincode = $orders->billing_address->zip;
                                    }
                                    if(!empty($orders->email)){
                                        $model->it_easy_billing_email = $orders->email;
                                      	$model->it_easy_shipping_email = $orders->email;
                                      	$model->it_easy_email = $orders->email;
                                    }
                                    if(!empty($orders->billing_address->phone) && isset($orders->billing_address->phone)){
                                        $model->it_easy_mobile_number = $orders->billing_address->phone;
                                      	$model->it_easy_shipping_mobile_number = $orders->billing_address->phone;
                                      	$model->it_easy_billing_mobile = $orders->billing_address->phone;
                                    }else{
                                        $model->it_easy_mobile_number = 'MissingOrder';
                                      	$model->it_easy_shipping_mobile_number = 'MissingOrder';
                                      	$model->it_easy_billing_mobile = 'MissingOrder';
                                    }
                                    $address_model = new ItEasyOrder();
                                    $f_name = $model->it_easy_shipping_firstname.' '.$model->it_easy_lastname;
                                    $f_address = $model->it_easy_shipping_address_1.' '.$model->it_easy_shipping_address_2.' '.$model->it_easy_shipping_city;
                                    $address_validator = $address_model->getAddressValidator($f_name, $model->it_easy_shipping_email, $f_address, $model->it_easy_shipping_state, $model->it_easy_shipping_pincode, $order_number);
                                    
                                    if(!empty($address_validator)){
                                        if($address_validator->meta->status == '200'){
                                            $model->address_validator_response =     $address_validator->result->address_category.'-'.$address_validator->result->pincode_rto_risk.'-'.$address_validator->result->address_incomplete_reason;
                                        }
                                    }
                                 
                                  	$model->it_easy_ordered_amount = $price;
                                  	$model->it_easy_total_price = $price;
                                  	$model->it_easy_partially_paid = $partially_paid;
                                  	$model->it_easy_total_understanding = $total_outstanding;
                                  	$model->it_easy_gst_price = '0.00';
                                  	$model->it_easy_order_status_id = $order_status;
                                  	$model->it_easy_first_status = $first_status;
                                  	
                                  	$model->it_easy_department_id = '4';
                                    $model->it_easy_payment_method = $get_paymentmethod->it_easy_method_name;
                                    $model->it_easy_payment_code = $get_paymentmethod->it_easy_method_code;
                                    $model->it_easy_shipping_method = $get_shippingmethod->it_easy_method_name;
                                    $model->it_easy_shipping_code = $get_shippingmethod->it_easy_method_code;
                                    $model->it_easy_country = 'IN';
                                    $model->it_easy_shipping_country = 'IN';
                                    $model->it_easy_billing_country = 'IN';
                                    
                                    $model->it_easy_server_ip = $ipaddress;
                                    $model->it_easy_device = $get_device;
                                    $model->it_easy_browser = $browser;
                                  	$model->it_easy_created_time = date("Y-m-d H:i:s", strtotime($orders->created_at));
                                  	
                                    $live_users = User::find()->where(['login_status' => '1'])->andwhere(['it_easy_dept_id' => '4'])->andwhere(['or', ['it_easy_type_id' => '4'], ['it_easy_type_id' => '5'],  ['it_easy_type_id' => '3']])->all();
                                  	$count_user = count($live_users);
                                //   	if($xr == $count_user){
                                //       	$xr = 0;
                                //     }
                                //   	foreach($live_users as $key => $live_user){
                                //         if($xr == $key){
                                //             $model->it_easy_assigned_by = '1';
                                //             $model->it_easy_assigned_to = $live_user->id;
                                //         }
                                //     }
                                
                                
                                  	if($model->it_easy_mobile_number == 'MissingOrder'){
                                      	$model->it_easy_customer_id = '0';
                                    }else{
                                      	$find_customer_data = ItEasyCustomer::FindCustomerbyMobile($model->it_easy_mobile_number);
                                    }
                                  	$model->save(false);
                                  
                                  	if(empty($find_customer_data)){
                                        $find_customer_data = ItEasyCustomer::SavecustomerModelFromMobileArray($model, $model->it_easy_order_id);
                                        $model->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
                                    }else{

                                        $model->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
                                        if(!empty($find_customer_data->it_easy_order_ids)){
                                            $customer_it_easy_order_ids = explode(',', $find_customer_data->it_easy_order_ids);
                                            if (!in_array($model->it_easy_order_id, $customer_it_easy_order_ids)){
                                                $find_customer_data->it_easy_order_ids = $find_customer_data->it_easy_order_ids.','.$model->it_easy_order_id;
                                                $find_customer_data->save();
                                            }
                                        }
                                    }
                                  	$it_easy_gst_price = 0;
                                  	$it_easy_total_price = 0;
                                  	$quantity_order = 0;
                                  	foreach ($order_product as $key => $value_product) {
                                      	
                                      	
                                      	$check_product_data = ItEasyProductVariation::find()->where(['shopify_product_id' => $value_product['shopify_product_id']])->andWhere(['shopify_veriant_id' =>$value_product['shopify_variant_id'] ])->andWhere(['it_easy_status' => 'Active'])->asArray()->one();
                                      	
                                      	
                                      	
                                      	
                                      	
                                      	
                                      	$quantity_order += $value_product['quantity'];
                                      		
                                        
                                        $orderProductModel = new ItEasyOrderProduct();
                                        $orderProductModel->it_easy_order_id = $model->it_easy_order_id;
                                        
                                        if(!empty($check_product_data)){
                                            $orderProductModel->it_easy_product_id = $check_product_data['it_easy_product_id'];
                                                $orderProductModel->it_easy_variation_id = $check_product_data['it_easy_variation_id'];
                                                $orderProductModel->it_easy_product_name = $check_product_data['it_easy_product_name']; 
                                                $orderProductModel->it_easy_variation_name = $check_product_data['it_easy_variation_name'];
                                        }else{
                                        
                                        switch ($value_product['product_name']) {
                                              case "Ashwagandha with Tribulus Terrestris":
                                                $orderProductModel->it_easy_product_id = '28';
                                                $orderProductModel->it_easy_variation_id = '2';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name']; 
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                              case "Nutriherbs Ashwagandha with Tribulus Terrestris 60 capsule Pack 1":
                                                $orderProductModel->it_easy_product_id = '28';
                                                $orderProductModel->it_easy_variation_id = '1';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                case "Ashwagandha with Tribulus Terrestris 60 capsule Pack 1":
                                                $orderProductModel->it_easy_product_id = '28';
                                                $orderProductModel->it_easy_variation_id = '1';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                case "NutriHerbs Glow Builder with the Blend of 48 Super Food (15 Sachets)":
                                                $orderProductModel->it_easy_product_id = '1';
                                                if($value_product['variation_name'] == '15 Sachets'){
                                                $orderProductModel->it_easy_variation_id = '8';
                                                }else if($value_product['variation_name'] == '30 Sachets'){
                                                    $orderProductModel->it_easy_variation_id = '9';
                                                }else if($value_product['variation_name'] == '60 sachets'){
                                                    $orderProductModel->it_easy_variation_id = '10';
                                                }else{
                                                    $orderProductModel->it_easy_variation_id = '8';
                                                }
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                case "NutriHerbs Glow Builder with the Blend of 48 Super Food ( Sachets )":
                                                $orderProductModel->it_easy_product_id = '1';
                                                if($value_product['variation_name'] == '15 Sachets'){
                                                $orderProductModel->it_easy_variation_id = '8';
                                                }else if($value_product['variation_name'] == '30 Sachets'){
                                                    $orderProductModel->it_easy_variation_id = '9';
                                                }else if($value_product['variation_name'] == '60 sachets'){
                                                    $orderProductModel->it_easy_variation_id = '10';
                                                }else{
                                                    $orderProductModel->it_easy_variation_id = '8';
                                                }
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                case "NutriHerbs Glow Builder with the Blend of 48 Super Food (30 Sachets)":
                                                $orderProductModel->it_easy_product_id = '1';
                                                if($value_product['variation_name'] == '15 Sachets'){
                                                $orderProductModel->it_easy_variation_id = '8';
                                                }else if($value_product['variation_name'] == '30 Sachets'){
                                                    $orderProductModel->it_easy_variation_id = '9';
                                                }else if($value_product['variation_name'] == '60 sachets'){
                                                    $orderProductModel->it_easy_variation_id = '10';
                                                }else{
                                                    $orderProductModel->it_easy_variation_id = '8';
                                                }
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                case "Nutriherbs L Glutathione Capsules With Vitamin C, E & Grape Seed Extract":
                                                $orderProductModel->it_easy_product_id = '3';
                                                $orderProductModel->it_easy_variation_id = '1';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                
                                                case "Nutriherbs L Glutathione Capsules With Vitamin C, E &amp; Grape Seed Extract":
                                                $orderProductModel->it_easy_product_id = '3';
                                                $orderProductModel->it_easy_variation_id = '2';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                
                                                case "Nutriherbs Shilajit with Ashwagandha (60 Caps)":
                                                $orderProductModel->it_easy_product_id = '11';
                                                $orderProductModel->it_easy_variation_id = '11';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                
                                                case "Nutriherbs Shilajit Resin with Kesar-15gm":
                                                $orderProductModel->it_easy_product_id = '5';
                                                $orderProductModel->it_easy_variation_id = '5';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                case "Pure Shilajit Resin with Kesar":
                                                $orderProductModel->it_easy_product_id = '5';
                                                $orderProductModel->it_easy_variation_id = '5';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                case "Nutriherbs Shilajit Resin with Kesar-15gm (Pack of 3)":
                                                $orderProductModel->it_easy_product_id = '5';
                                                $orderProductModel->it_easy_variation_id = '7';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                
                                                case "Nutriherbs Shilajit Resin with Kesar-15gm (Pack of 2)":
                                                $orderProductModel->it_easy_product_id = '5';
                                                $orderProductModel->it_easy_variation_id = '6';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                case "Nutriherbs Shilajit Resin":
                                                $orderProductModel->it_easy_product_id = '26';
                                                $orderProductModel->it_easy_variation_id = '5';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                
                                                case "Nutriherbs Shilajit Resin-15gm":
                                                $orderProductModel->it_easy_product_id = '26';
                                                $orderProductModel->it_easy_variation_id = '5';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                case "Shilajit Resin":
                                                
                                                if($value_product['variation_name'] == 'kesar Flavour : 15 gm'){    
                                                $orderProductModel->it_easy_product_id = '5';
                                                $orderProductModel->it_easy_variation_id = '5';
                                                }else if($value_product['variation_name'] == 'Normal Flavour: 15 gm'){    
                                                $orderProductModel->it_easy_product_id = '26';
                                                $orderProductModel->it_easy_variation_id = '5';
                                                }else if($value_product['variation_name'] == 'Normal Flavour: 30 gm'){    
                                                $orderProductModel->it_easy_product_id = '26';
                                                $orderProductModel->it_easy_variation_id = '6';
                                                }else if($value_product['variation_name'] == 'kesar Flavour : 30 gm'){    
                                                $orderProductModel->it_easy_product_id = '5';
                                                $orderProductModel->it_easy_variation_id = '6';
                                                }else if($value_product['variation_name'] == 'kesar Flavour : 45 gm'){    
                                                $orderProductModel->it_easy_product_id = '5';
                                                $orderProductModel->it_easy_variation_id = '7';
                                                }else if($value_product['variation_name'] == 'Normal Flavour: 45 gm'){    
                                                $orderProductModel->it_easy_product_id = '26';
                                                $orderProductModel->it_easy_variation_id = '7';
                                                }else{
                                                  $orderProductModel->it_easy_product_id = '26';
                                                $orderProductModel->it_easy_variation_id = '5';   
                                                }
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                        
                                                
                                              case "Shilajit Resin Pack of 1":
                                                $orderProductModel->it_easy_product_id = '26';
                                                $orderProductModel->it_easy_variation_id = '5';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                case "Skin Glow Tablets":
                                                $orderProductModel->it_easy_product_id = '204';
                                                if($value_product['variation_name'] == 'Orange' ){
                                                    $orderProductModel->it_easy_variation_id = '41';
                                                    $orderProductModel->it_easy_product_name = "(NH) Skin Glow ) Orange flavour";
                                                    $orderProductModel->it_easy_variation_name = "Tablet-15";
                                                }else{
                                                    $orderProductModel->it_easy_variation_id = '41';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                }
                                                
                                                
                                                
                                                break;
                                                
                                                
                                                case "Original Shilajit Resin Ashwagold - 10 gram":
                                                $orderProductModel->it_easy_product_id = '190';
                                                if($value_product['variation_name'] == '10 Gram' ){
                                                    $orderProductModel->it_easy_variation_id = '34';
                                                    $orderProductModel->it_easy_product_name = "(NH) Pure Shilajit Resin Ashwagold  - Trail Pack (Prepaid)";
                                                    $orderProductModel->it_easy_variation_name = "10gm";
                                                }else if($value_product['variation_name'] == '20 Gram' ){
                                                    $orderProductModel->it_easy_variation_id = '34';
                                                    $orderProductModel->it_easy_product_name = "(NH) Pure Shilajit Resin Ashwagold  - Trail Pack (Prepaid)";
                                                    $orderProductModel->it_easy_variation_name = "20gm";
                                                }else{
                                                    $orderProductModel->it_easy_variation_id = '34';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                }
                
                                                break;
                                                
                                                
                                              default:
                                                $orderProductModel->it_easy_product_id = '0';
                                                $orderProductModel->it_easy_variation_id = '1';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                            }
                                            
                                            
                                        }    
                                            
                                            
                                        $product_variation = ItEasyProductVariation::find()->where(['it_easy_product_name' => $orderProductModel->it_easy_product_name])
                                          												   ->andWhere(['it_easy_variation_name' => $orderProductModel->it_easy_variation_name])
                                          												   ->asArray()->one();
                                      	if(empty($product_variation)){
                                          	$product_variation['it_easy_product_id'] = 0;
                                          	$product_variation['it_easy_variation_id'] = 0;
                                          	$product_taxe = 0;
                                          	$t_product_price = $value_product['price'] * $value_product['quantity'];
                                          	$it_easy_total_price += $value_product['price'] * $value_product['quantity'];
                                          	$it_easy_gst_price +=0;
                                          	$product_variation_price = $value_product['price'] * $value_product['quantity'];
                                        }else{
                                            
            $p_data = ItEasyOrder::FindProductbyid($product_variation['it_easy_product_id']);
            // echo "<pre>"; print_r($p_data); die;
            $p_data_tax_percentage = $p_data->it_easy_product_tax;
            if(!empty($p_data_tax_percentage)){
                $tax_price_p = ROUND((($value_product['price'] * $value_product['quantity']) * $p_data_tax_percentage )/100, 2);
            }else{
                $tax_price_p = ROUND((($value_product['price'] * $value_product['quantity']) * 12 )/100, 2);
            }
                                            
                                            
                                            
                                            if(!empty($value_product['quantity'])){
                                            $one_bottle_price = $value_product['price'] * $value_product['quantity']/$value_product['quantity'];
                                            }else{
                                                $one_bottle_price = '0';
                                            }
                                          	$product_taxe = $value_product['quantity'] * $tax_price_p;
                                            $t_product_price = $one_bottle_price * $value_product['quantity'];
                                            $it_easy_total_price +=  $t_product_price;
                                            $it_easy_gst_price += $product_taxe;
                                        
                                        $price_without_tax_1 =   $t_product_price -  $product_taxe;
                                          	$product_variation_price = $price_without_tax_1 * $value_product['quantity'];
                                        }    
                                        
                                        $orderProductModel->it_easy_product_sku = $value_product['product_name'];
                                        
                                        $orderProductModel->it_easy_product_quantity = $value_product['quantity'];
                                        $orderProductModel->it_easy_product_total = $t_product_price;
                                        $orderProductModel->it_easy_product_price = $product_variation_price;
                                        $orderProductModel->it_easy_product_tax = $product_taxe;
                                        $orderProductModel->created_time = date('Y-m-d H:i:s');
                                        $orderProductModel->save();
                                           
                                  	}
                                  
                                  	$model->it_easy_total_price = $it_easy_total_price;
                                    $model->it_easy_gst_price = $it_easy_gst_price;
                                    if(!empty($orders->note)){
                                        $model->it_easy_marketer_publisher = 'Funnelish_'.$orders->note;
                                    }else if(!empty($orders->tags)){
                                        $model->it_easy_marketer_publisher = str_replace(", ","_",$orders->tags);
                                    }else if(!empty($orders->landing_site_ref)){
                                        $model->it_easy_marketer_publisher = $orders->landing_site_ref;
                                    }else{
                                        $model->it_easy_marketer_publisher = 'Direct';
                                    }
                                    $model->it_easy_product_quantity = $quantity_order;
                                    
                                    
                                    $model->save(false); 
                                    $model->it_easy_order_number = 'NH'.$model->it_easy_order_id;
                                    $model->it_easy_invoice_number = 'NH-'.$get_financial_year.'-'.$model->it_easy_order_id;
                                    $model->save(false); 
                                  
                                  	$xr++;
                                }  
                                }
                            }
                            
                            
                        }
                		break;
                		
                /*	case 'Woocommerce':
                  
                  
                		$today_date =date('Y-m-d',strtotime("-1 days"));
                        $today_time = date('H:i:s');
                        
                        $woocommerce = new Client(
                            $url, 
                            $username, 
                            $password,
                            [
                                'version' => 'wc/v1',
                            ]
                        );
                        $order_list = $woocommerce->get('orders', $parameters = ['after' => $today_date."T".$today_time]);
                
                        if(empty($order_list)){
                            $message = 'Order value null';
                        }
                        if(!empty($order_list)) {
                            $save_data = [];
                            foreach($order_list as $key => $orders){
                            $order_number = 'wooco'.$orders->id;
                            $chk_order = SolLogisOrders::find()->where(['vendor_id' => $user_id, 'extra_id' => $order_number])->asArray()->one();
                            if(empty($chk_order)){
                                $pincode = $orders->shipping->postcode;
                                $shipping_priority = SolLogisShippingPriority::find()->where(['user_id' => $user_id])->andWhere(['status' => 'Active'])->orderBy(['seq' => SORT_ASC])->asArray()->all();
                                if(!empty($shipping_priority)){
                                    $count_ship = count($shipping_priority);
                                    if($count_ship == '1'){
                                        if($shipping_priority[0]['shipping_id'] == '2'){
                                        
                                            
                                            $pincode_check = SolLogisDelhiveryPincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                            if(!empty($pincode_check)){
                                                $shipping_id = '2';
                                                $courier_name = 'Delhivery_Express'; 
                                            }else{
                                                $shipping_id = '';
                                            }
                                        }else if($shipping_priority[0]['shipping_id'] == '4'){
                                        
                                            
                                            $pincode_check = SolLogisShipdelightPincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                            if(!empty($pincode_check)){
                                                $shipping_id = '4';
                                                $courier_name = 'shipdelight'; 
                                            }else{
                                                $shipping_id = '';
                                            }
                                        }else if($shipping_priority[0]['shipping_id'] == '6'){
                                            
                                            
                                            $pincode_check = SolLogisXpressbeesPincodes::find()->where(['Pincode' => $pincode])->asArray()->one();
                                            if(!empty($pincode_check)){
                                                $shipping_id = '6';
                                                $courier_name = 'xpressbess';
                                            }else{
                                                $shipping_id = '';
                                            }
                                        }else if($shipping_priority[0]['shipping_id'] == '7'){
                                            
                                            
                                            $pincode_check = SolLogisEkartPincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                            if(!empty($pincode_check)){
                                                $shipping_id = '7';
                                                $courier_name = 'Ekart';
                                            }else{
                                                $shipping_id = '';
                                            }
                                        }else if($shipping_priority[0]['shipping_id'] == '8'){
                                            
                                            
                                            $pincode_check = SolLogisShadowfaxPincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                            if(!empty($pincode_check)){
                                                $shipping_id = '8';
                                                $courier_name = 'Shadowfax';
                                            }else{
                                                $shipping_id = '';
                                            }
                                        }else if($shipping_priority[0]['shipping_id'] == '9'){
                                            
                                            
                                            $pincode_check = SolLogisBluedartPincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                            if(!empty($pincode_check)){
                                                $shipping_id = '9';
                                                $courier_name = 'Bluedart';
                                            }else{
                                                $shipping_id = '';
                                            }
                                        }else if($ship_choose['shipping_id'] == '10'){
                                                $pincode_check = SolLogisDelhiverysurfacePincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                                
                                                if(!empty($pincode_check)){
                                                    $shipping_id = '10';
                                                    $courier_name = 'Delhivery_Surface';
                                                    $x = 1;
                                                }else{
                                                     $shipping_id = '';
                                                }
                                            }
                                    }else{
                                        
                                        $x = 0;
                                        foreach($shipping_priority as $ship_choose){
                                            if($x == 1){
                                                break;
                                            }
                                            
                                            if($shipping_priority[0]['shipping_id'] == '2'){
                                        
                                            
                                            $pincode_check = SolLogisDelhiveryPincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                            if(!empty($pincode_check)){
                                                $x = 1;
                                                $shipping_id = '2';
                                                $courier_name = 'Delhivery_Express'; 
                                            }else{
                                                $shipping_id = '';
                                            }
                                        }else if($ship_choose['shipping_id'] == '4'){
                                                $pincode_check = SolLogisShipdelightPincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                                if(!empty($pincode_check)){
                                                    $x = 1;
                                                    $shipping_id = '4';
                                                    $courier_name = 'shipdelight';
                                                }else{
                                                     $shipping_id = '';
                                                }
                                            }else if($ship_choose['shipping_id'] == '6'){
                                                $pincode_check = SolLogisXpressbeesPincodes::find()->where(['Pincode' => $pincode])->asArray()->one();
                                                
                                                if(!empty($pincode_check)){
                                                    $shipping_id = '6';
                                                    $courier_name = 'xpressbees';
                                                    $x = 1;
                                                }else{
                                                     $shipping_id = '';
                                                }
                                            }else if($ship_choose['shipping_id'] == '7'){
                                                $pincode_check = SolLogisEkartPincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                                
                                                if(!empty($pincode_check)){
                                                    $shipping_id = '7';
                                                    $courier_name = 'Ekart';
                                                    $x = 1;
                                                }else{
                                                     $shipping_id = ''; 
                                                }
                                            }else if($ship_choose['shipping_id'] == '8'){
                                                $pincode_check = SolLogisShadowfaxPincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                                
                                                if(!empty($pincode_check)){
                                                    $shipping_id = '8';
                                                    $courier_name = 'Shadowfax';
                                                    $x = 1;
                                                }else{
                                                     $shipping_id = '';
                                                }
                                            }else if($ship_choose['shipping_id'] == '9'){
                                                $pincode_check = SolLogisShadowfaxPincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                                
                                                if(!empty($pincode_check)){
                                                    $shipping_id = '9';
                                                    $courier_name = 'Bluedart';
                                                    $x = 1;
                                                }else{
                                                     $shipping_id = '';
                                                }
                                            }else if($ship_choose['shipping_id'] == '10'){
                                                $pincode_check = SolLogisDelhiverysurfacePincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                                
                                                if(!empty($pincode_check)){
                                                    $shipping_id = '10';
                                                    $courier_name = 'Delhivery_Surface';
                                                    $x = 1;
                                                }else{
                                                     $shipping_id = '';
                                                }
                                            }
                                        }
                                    }
                                    if($orders->payment_method == 'cod'){
                                        $payment_mode = 'COD';
                                        $cod_amount = $orders->total;
                                    }else{
                                        $payment_mode = 'Prepaid';
                                        $cod_amount = 0;
                                    }
                                    $product_name = '';
                                    $product_descrition = '';
                                    $quantity = 0;
                                    $price = $orders->total;
                                    $height = 0;
                                    $length = 0;
                                    $width = 0;
                                    $weight = 0.5;
                                    $order_status = 'Pending_order'; 
                                    
                                    
                                    
                                    foreach($orders->line_items as $key => $product){
                                        $product_name .= $product->name;
                                        $product_descrition .= $product->name;
                                        $quantity += $product->quantity;
                                        
                                    }
                                    if(!empty($shipping_id)){
                                        $save_data[] = [$order_number, $orders->id, $shipping_id, $user_id, $orders->id, $payment_mode, $orders->shipping->first_name, $orders->shipping->last_name, $orders->shipping->address_1, $orders->shipping->address_2, $orders->shipping->city, $orders->shipping->state, $orders->shipping->postcode, $orders->billing->phone, $orders->billing->phone, $product_name, $product_descrition, $quantity, $price, $cod_amount, $height, $length, $width, $weight, $courier_name, $order_status, $c_date, '1'];
                                    }
                                }
                            
                            }
                            }
                            
                            $user_Detail = User::findOne(['id' => $user_id]);
                            if($user_Detail->wallet_user_type == 'Prepaid'){
                                $count_shipment = count($save_data);
                                $amount_for_shipment = $count_shipment * 100;
                                if($user_Detail->wallet_amount < $amount_for_shipment){
                                    if(!empty($save_data)){
                                        Yii::$app->db->createCommand()->batchInsert('sol_logis_orders', ['extra_id', 'order_number', 'shipping_id', 'vendor_id', 'transaction_id', 'payment_mode', 'customer_firstname', 'customer_lastname', 'address_1', 'address_2', 'city', 'state', 'postcode', 'mobile', 'alternate_number', 'product_name', 'item_description', 'quantity', 'price', 'collective_price', 'height', 'length', 'width', 'weight', 'courier_name', 'order_status', 'created_time', 'created_by'], $save_data)->execute();
                                    }
                                }
                            }else{
                                if(!empty($save_data)){
                                    Yii::$app->db->createCommand()->batchInsert('sol_logis_orders', ['extra_id','order_number', 'shipping_id', 'vendor_id', 'transaction_id', 'payment_mode', 'customer_firstname', 'customer_lastname', 'address_1', 'address_2', 'city', 'state', 'postcode', 'mobile', 'alternate_number', 'product_name', 'item_description', 'quantity', 'price', 'collective_price', 'height', 'length', 'width', 'weight', 'courier_name', 'order_status', 'created_time', 'created_by'], $save_data)->execute();
                                }
                            }
                        }
                        
                        
                        
                		break;	 
                	
                	default:
                	    
                		break; */
                }
                
                
                
                 
                
            }
        }
    }
  
  
  
    public function actionIndex()
    {   
        ini_set('memory_limit','-1');
        
        $searchModel = new ItEasyOrderSearch();
        $model = new ItEasyOrder();
        $today_report = ItEasyOrder::Ordernumbers($this->request->queryParams);
        
        // echo "<pre>"; print_r($this->request->queryParams); die;
        
        if(Yii::$app->user->identity->id == '53'){
            // echo "<pre>"; print_r($today_report); die;
         }
        $dataProvider = $searchModel->search($this->request->queryParams);
        $stateList = ItEasyState::getStateallData();
        
        $statedata = ArrayHelper::map($stateList, 'it_easy_id', 'it_easy_state_name');
        
        $disposition_status_list = ItEasyOrder::getAHelperDispositionStatusForAgent();
        
        $order_dispositiondata = ArrayHelper::map($disposition_status_list, 'it_easy_order_disposition_id', 'it_easy_order_disposition_name');
        
        $payemntmethod_list_data = ItEasyOrder::getAHelperPaymentMethod();
        
        $payment_method = ArrayHelper::map($payemntmethod_list_data, 'it_easy_method_code', 'it_easy_method_name' );
         $array_helper_courier = ItEasyOrder::ArrayHelperCourierData();
        
        $tl_data = ItEasyOrder::getAHelperTLdata();
        // echo "11111"; die;
        $agent_data = ItEasyOrder::getAHelperAgentdata();
        $order_status_list = ItEasyOrder::getAHelperOrderStatusForAgentsw();    
        $order_statusdata = ArrayHelper::map($order_status_list, 'it_easy_order_status_id', 'it_easy_order_status_name');
        $search_status_list = ItEasyOrder::getAHelperOrderStatusForAgent();    
        $search_statusdata = ArrayHelper::map($search_status_list, 'it_easy_order_status_id', 'it_easy_order_status_name');
        $dataProvider->pagination->pageSize = 50;
        $order_status_list_view = ItEasyOrder::getAHelperOrderStatusForAgentLogistic();
        $order_statusdata_view = ArrayHelper::map($order_status_list_view, 'it_easy_order_status_id', 'it_easy_order_status_name');
        
        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'order_dispositiondata' => $order_dispositiondata,
            'statedata' => $statedata,
            'payment_method' => $payment_method,
            'agent_data' => $agent_data,
            'tl_data' => $tl_data,
          	'model'=>$model,
          	'order_statusdata'=>$order_statusdata,
          	'search_statusdata' => $search_statusdata,
          	'today_report'=>$today_report,
          	'order_statusdata_view'=> $order_statusdata_view,
          	'array_helper_courier' => $array_helper_courier
        ]);
    }
    
    
    public function actionConfirmStatus(){
            if (Yii::$app->request->post()){
            $model = ItEasyOrder::find()->where(['it_easy_order_id'=>$_REQUEST['ItEasyOrder']['it_easy_order_id']])->One();
                date_default_timezone_set('Asia/kolkata');
                $currentDateTime = date('Y-m-d H:i:s');
                $model->it_easy_order_status_id = $_REQUEST['ItEasyOrder']['it_easy_order_status_id'];
                $model->updated_by  = Yii::$app->user->identity->id;
                $model->it_easy_confirmation_id  = Yii::$app->user->identity->it_easy_username;
                $model->it_easy_flag = $_REQUEST['ItEasyOrder']['it_easy_flag'];
                $model->it_easy_converted_time = $currentDateTime;
                $model->it_easy_updated_time  = $currentDateTime;
                $model->save(false);
                // save status history data here
                ItEasyOrder::addOrderStatusHistory($_REQUEST['ItEasyOrder']['it_easy_order_id'],$_REQUEST['ItEasyOrder']['it_easy_order_status_id'],'confirm');
                Yii::$app->session->setFlash('success', "Order has been successfully confirmed");
                return $this->redirect(Yii::$app->request->referrer);
            }
    }
    
    public function actionDisapprovedStatus(){
            if (Yii::$app->request->post()){
            $model = ItEasyOrder::find()->where(['it_easy_order_id'=>$_REQUEST['ItEasyOrder']['it_easy_order_id']])->One();
                date_default_timezone_set('Asia/kolkata');
                $currentDateTime = date('Y-m-d H:i:s');
                $model->it_easy_order_status_id = $_REQUEST['ItEasyOrder']['it_easy_order_status_id'];
                $model->updated_by  = Yii::$app->user->identity->id;
                $model->it_easy_converted_time = $currentDateTime;
                $model->it_easy_updated_time  = $currentDateTime;
                $model->save(false);
                // save status history data here
                ItEasyOrder::addOrderStatusHistory($_REQUEST['ItEasyOrder']['it_easy_order_id'],$_REQUEST['ItEasyOrder']['it_easy_order_status_id'],$_REQUEST['ItEasyOrder']['it_easy_flag']);
                Yii::$app->session->setFlash('success', "Order has been successfully Cancelled");
                return $this->redirect(Yii::$app->request->referrer);
            }
    }

    public function actionFetchServiceable(){
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        if(isset($_GET['it_easy_order_id']) && !empty($_GET['it_easy_order_id'])){
          $order_lists = ItEasyOrder::find()->andwhere(['it_easy_order_id' => $_GET['it_easy_order_id']])->all();
        }else{
          $order_lists = ItEasyOrder::find()->andwhere(['IN', 'it_easy_order_status_id', ['24']])->orderBy(['it_easy_order_id' => SORT_DESC])->limit(1000)->all();
        }
        
        
        foreach ($order_lists as $key => $order) {
            $order->it_easy_order_serviceable = ItEasyOrder::getServicealAPIbyPincode($order->it_easy_pincode);
            $order->save(false); 
        }

        Yii::$app->session->setFlash('success', 'Your Service pincode has been successfully fetched.');
        return $this->redirect(Yii::$app->request->referrer);
    }
    
    public function actionFetchServiceableall(){
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        if(isset($_GET['it_easy_order_id']) && !empty($_GET['it_easy_order_id'])){
          $order_lists = ItEasyOrder::find()->andwhere(['it_easy_order_id' => $_GET['it_easy_order_id']])->all();
        }else{
          $order_lists = ItEasyOrder::find()->andwhere(['IN', 'it_easy_order_status_id', ['24','2','4']])->orderBy(['it_easy_order_id' => SORT_DESC])->limit(1000)->all();
        }
        
        
        foreach ($order_lists as $key => $order) {
            $order->it_easy_order_serviceable = ItEasyOrder::getServicealAPIbyPincode($order->it_easy_pincode);
            $order->save(false); 
        }

        Yii::$app->session->setFlash('success', 'Your Service pincode has been successfully fetched.');
        return $this->redirect(Yii::$app->request->referrer);
    }


    public function actionAgentwise()
    {   
        ini_set('memory_limit', '2048M');
        $searchModel = new ItEasyOrderSearch();
        $searchModel2 = new ItEasyRaiseRequestSearch(); 
        $dataProvider2 = $searchModel2->search($data = '');
        $model2 = new ItEasyRaiseRequest();
        $tl_data = ItEasyOrder::getAHelperTLdata();
        $agent_data = ItEasyOrder::getAHelperAgentdata();
        $agentwise_total_report = ItEasyOrder::AgentwisegettotalReport($this->request->queryParams);
        $agentwise_disposition_report = ItEasyOrder::AgentwisegettotaldispositionReport($this->request->queryParams);
        $agentwise_state_report = ItEasyOrder::StateWiseAgentwisegettotalReport($this->request->queryParams);
        $agentwise_product_report = ItEasyOrder::ProductWiseAgentwisegettotalReport($this->request->queryParams);
        
        // echo "<pre>"; print_r($agentwise_product_report); die;

        $dataProvider = new ArrayDataProvider([
            'allModels' => $agentwise_disposition_report,
        ]);
        if ($this->request->isPost) {
            if ($model2->load(Yii::$app->request->post())){
                 date_default_timezone_set("Asia/Kolkata");
                 $create_date=date("Y-m-d H:i:s");
                 $model2->it_easy_user_id = Yii::$app->user->identity->id;
                 $model2->it_easy_created_time = $create_date; 
                 $model2->it_easy_created_by = Yii::$app->user->identity->id;
                 
                 $model2->save();
                 Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
                 return $this->redirect(['agentwise']);
            }
        }


          if(isset($this->request->queryParams)){
            if(isset($this->request->queryParams['ItEasyOrderSearch']['it_easy_assigned_by'])){
              $searchModel->it_easy_assigned_by = $this->request->queryParams['ItEasyOrderSearch']['it_easy_assigned_by'];
            }
            if(isset($this->request->queryParams['ItEasyOrderSearch']['it_easy_assigned_to'])){
              $searchModel->it_easy_assigned_to = $this->request->queryParams['ItEasyOrderSearch']['it_easy_assigned_to'];
            }
            if(isset($this->request->queryParams['ItEasyOrderSearch']['it_easy_first_status'])){
              $searchModel->it_easy_first_status = $this->request->queryParams['ItEasyOrderSearch']['it_easy_first_status'];
            }
            if(isset($this->request->queryParams['ItEasyOrderSearch']['date_type_filter'])){
              $searchModel->date_type_filter = $this->request->queryParams['ItEasyOrderSearch']['date_type_filter'];
            }
            if(isset($this->request->queryParams['ItEasyOrderSearch']['date_to_date'])){
              $searchModel->date_to_date = $this->request->queryParams['ItEasyOrderSearch']['date_to_date'];
            }
            if(isset($this->request->queryParams['ItEasyOrderSearch']['date_from_date'])){
              $searchModel->date_from_date = $this->request->queryParams['ItEasyOrderSearch']['date_from_date'];
            }
          } 
        // echo "<pre>"; print_r($searchModel); die;

        return $this->render('agentwise', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'agent_data' => $agent_data,
            'tl_data' => $tl_data,
            'agentwise_state_report' => $agentwise_state_report,
            'model2' => $model2,
            'dataProvider2' => $dataProvider2,
            'agentwise_total_report' => $agentwise_total_report,
            'agentwise_product_report' => $agentwise_product_report,
            'params' => $this->request->queryParams
        ]);
    }

    public function actionReportSale(){
        ini_set('memory_limit', '2048M');
        if((Yii::$app->user->identity->it_easy_type_id != '4' && Yii::$app->user->identity->it_easy_type_id != '5')){
            $searchModel = new ItEasyOrderSearch();
            $dataProvider = ItEasyOrder::ReportFromOrderGroupByagentname($this->request->queryParams);
            // echo "<pre>"; print_r($dataProvider); die;
            $dataProvider = new ArrayDataProvider([
                'allModels' => $dataProvider,
            ]);
            $dataProvider->pagination->pageSize = 40;
            $dataProvider2 = ItEasyOrder::ReportDispositionFromOrderGroupByagentname($this->request->queryParams);
            $dataProvider2->pagination->pageSize = 40;
            $tl_data = ItEasyOrder::getAHelperTLdata();

            if(isset($this->request->queryParams)){
              if(isset($this->request->queryParams['ItEasyOrderSearch']['it_easy_assigned_by'])){
                $searchModel->it_easy_assigned_by = $this->request->queryParams['ItEasyOrderSearch']['it_easy_assigned_by'];
              }
              if(isset($this->request->queryParams['ItEasyOrderSearch']['it_easy_assigned_to'])){
                $searchModel->it_easy_assigned_to = $this->request->queryParams['ItEasyOrderSearch']['it_easy_assigned_to'];
              }
            //   if(isset($this->request->queryParams['ItEasyOrderSearch']['it_easy_first_status'])){
            //     $searchModel->it_easy_first_status = $this->request->queryParams['ItEasyOrderSearch']['it_easy_first_status'];
            //   }
              if(isset($this->request->queryParams['ItEasyOrderSearch']['it_easy_platform'])){
                $searchModel->it_easy_platform = $this->request->queryParams['ItEasyOrderSearch']['it_easy_platform'];
              }
              if(isset($this->request->queryParams['ItEasyOrderSearch']['date_type_filter'])){
                $searchModel->date_type_filter = $this->request->queryParams['ItEasyOrderSearch']['date_type_filter'];
              }
              if(isset($this->request->queryParams['ItEasyOrderSearch']['date_to_date'])){
                $searchModel->date_to_date = $this->request->queryParams['ItEasyOrderSearch']['date_to_date'];
              }
              if(isset($this->request->queryParams['ItEasyOrderSearch']['date_from_date'])){
                $searchModel->date_from_date = $this->request->queryParams['ItEasyOrderSearch']['date_from_date'];
              }
            } 
            return $this->render('report_total_agent', [
                'searchModel' => $searchModel,
                'dataProvider' => $dataProvider,
                'tl_data' => $tl_data,
                'dataProvider2' => $dataProvider2,
            ]);
        }else{
            throw new \yii\web\HttpException(404, 'The requested Item could not be found.');
        }
    }
    
    
    public function actionReportSaleexport(){
        set_time_limit(0);
  	    ini_set('max_execution_time', 0);
  	    ini_set("memory_limit", "-1");
        if((Yii::$app->user->identity->it_easy_type_id != '4' && Yii::$app->user->identity->it_easy_type_id != '5')){
            $searchModel = new ItEasyOrderSearch();
            $dataProvider = ItEasyOrder::ReportFromOrderGroupByagentname($this->request->queryParams);
            $array_fetch = [];
            foreach ($dataProvider as $key => $value) {
                $array_fetch[$key] = $value;
                $user_data= User::find()->select(['it_easy_username'])->where(['id' => $value['it_easy_assigned_to']])->asArray()->One();
                if(!empty($user_data)){
                    $array_fetch[$key]['username'] = $user_data['it_easy_username'];
                }else{
                    $array_fetch[$key]['username'] = "";
                }
            }
            
                $exporter = new Spreadsheet([
                'dataProvider' => new ArrayDataProvider([
                    'allModels' => $array_fetch,
                ]),
                'columns' => [
            [   'attribute' => 'username', 'label' => 'Username'],
            [   'attribute' => 'total_assign_number', 'label' => 'Assign Number' ],
            [   'attribute' => 'sum_assign_total', 'label' => 'Sum of Assign Number' ],
          	[   'attribute' => 'confirm_count','label' => 'Confirm Number' ],
          	[   'attribute' => 'confirm_sum','label' => 'Sum of Confirm Number'],
            [   'attribute' => 'ordered_confirm_sum', 'label' =>  'Sum of Ordered Amount'],
            [   'attribute' => 'hold_order_count', 'label' => 'Hold Order'],
            [   'attribute' => 'hold_order_sum', 'label' => 'Sum of Hold Order'],
            [   'attribute' => 'dispatched_order_count', 'label' => 'Dispatch Order'],
            [   'attribute' => 'dispatched_order_sum', 'label' => 'Sum of Dispatch Order'],
            [   'attribute' => 'delivered_order_count', 'label' => 'Delivered Order'],
            [   'attribute' => 'delivered_order_sum', 'label' => 'Sum of Delivered Order'],
            [   'attribute' => 'rto_order_count', 'label' => 'RTO Order'],
            [   'attribute' => 'rto_order_sum', 'label' => 'Sum of RTO Order'],
            [   'attribute' => 'cancelled_order_count', 'label' => 'Cancelled Order'],
            [   'attribute' => 'cancelled_order_sum', 'label' => 'Sum of Cancelled Order'],
            [   'attribute' => 'prepaid_order_count', 'label' => 'Prepaid Order'],
            [   'attribute' => 'preapaid_order_sum',  'label' => 'Sum of Prepaid Order']
                ],
            ]);
            return $exporter->send('Order-Export.xlsx');
        }else{
            throw new \yii\web\HttpException(404, 'The requested Item could not be found.');
        }
    }
    
    
    public function actionReportSaledispositionexport(){
        set_time_limit(0);
  	    ini_set('max_execution_time', 0);
  	    ini_set("memory_limit", "-1");
        if((Yii::$app->user->identity->it_easy_type_id != '4' && Yii::$app->user->identity->it_easy_type_id != '5')){
            $searchModel = new ItEasyOrderSearch();
            $dataProvider = ItEasyOrder::ReportDispositionFromOrderGroupByagentname($this->request->queryParams);
            
            $array_fetch = [];
            foreach ($dataProvider as $key => $value) {
                
                $array_fetch[$key] = $value;
                $user_data= User::find()->select(['it_easy_username'])->where(['id' => $value['it_easy_assigned_to']])->asArray()->One();
                if(!empty($user_data)){
                    $array_fetch[$key]['username'] = $user_data['it_easy_username'];
                }else{
                    $array_fetch[$key]['username'] = "";
                }
            }
            
                $exporter = new Spreadsheet([
                'dataProvider' => new ArrayDataProvider([
                    'allModels' => $array_fetch,
                ]),
                'columns' => [
            [   'attribute' => 'username', 'label' => 'Username'],
            [   'attribute' => 'total_assign', 'label' => 'Assign Number' ],
            [   'attribute' => 'callback_req_count', 'label' => 'Callback Required Number' ],
          	[   'attribute' => 'not_connected_count','label' => 'Not Connected Number' ],
          	[   'attribute' => 'confirm_sum','label' => 'Not Interested Number'],
            [   'attribute' => 'duplicate_count', 'label' =>  'Duplicate Number'],
            [   'attribute' => 'fake_order_count', 'label' => 'Fake Order Count'],
            [   'attribute' => 'area_not_ser_count', 'label' => 'Area Not Serviceable'],
            [   'attribute' => 'call_disconnected_count', 'label' => 'Call Disconnected Number'],
            [   'attribute' => 'promise_To_order_count', 'label' => 'Promise to Pay Online'],
            [   'attribute' => 'order_placed_count', 'label' => 'Order Place Count'],
            [   'attribute' => 'language_arrier', 'label' => 'Language Barrier'],
            
                ],
            ]);
            return $exporter->send('Disposition-Export.xlsx');
        }else{
            throw new \yii\web\HttpException(404, 'The requested Item could not be found.');
        }
    }
    
    
    public function actionReportProper(){
        ini_set('memory_limit', '2048M');
        if((Yii::$app->user->identity->it_easy_type_id != '4' && Yii::$app->user->identity->it_easy_type_id != '5')){
            $searchModel = new ItEasyOrderSearch();
            $dataProvider = ItEasyOrder::ReportFromOrderProper($this->request->queryParams);
            // echo "<pre>"; print_r($dataProvider); die;
            $array_full_data = [];
            $count_array = count($dataProvider) - 1;
            foreach($dataProvider as $key => $order_count){
                 if(isset($this->request->queryParams['ItEasyOrderSearch']['it_easy_first_status']) && $this->request->queryParams['ItEasyOrderSearch']['it_easy_first_status'] == 'Retention'){
                     $array_full_data[$key]  = $order_count;
                     if(empty($order_count['it_easy_marketer_publisher'])){
                         $array_full_data[$key]['it_easy_marketer_publisher'] = "Retention";
                     }
                    
                    // echo "<pre>"; print_r($dataProvider); die;
                 }else if(isset($this->request->queryParams['ItEasyOrderSearch']['it_easy_first_status']) && $this->request->queryParams['ItEasyOrderSearch']['it_easy_first_status'] == 'Abondoned'){
                     $array_full_data[$key]  = $order_count;
                     if(empty($order_count['it_easy_marketer_publisher'])){
                         $array_full_data[$key]['it_easy_marketer_publisher'] = "Abondoned";
                     }
                    
                    // echo "<pre>"; print_r($dataProvider); die;
                 }else{
                     if(empty($order_count['it_easy_marketer_publisher'])){
                         $array_full_data['Retention']['it_easy_marketer_publisher'] = 'Retention';
                        if(!isset($array_full_data['Retention']['total_order_number'])){
                            $array_full_data['Retention']['total_order_number'] = 0;
                            $array_full_data['Retention']['sum_assign_total'] = 0;
                            $array_full_data['Retention']['confirm_count'] = 0;
                            $array_full_data['Retention']['confirm_sum'] = 0;
                            $array_full_data['Retention']['pending_count'] = 0;
                            $array_full_data['Retention']['pending_sum'] = 0;
                            $array_full_data['Retention']['awb_assign_number'] = 0;
                            $array_full_data['Retention']['awb_assign_sum'] = 0;
                            $array_full_data['Retention']['dispatch_number'] = 0;
                            $array_full_data['Retention']['dispatch_sum'] = 0;
                            $array_full_data['Retention']['delivered_order_count'] = 0;
                            $array_full_data['Retention']['delivered_order_sum'] = 0;
                        }
                        
                        $array_full_data['Retention']['total_order_number'] += $order_count['total_order_number'];
                        $array_full_data['Retention']['sum_assign_total'] += $order_count['sum_assign_total'];
                        $array_full_data['Retention']['confirm_count'] += $order_count['confirm_count'];
                        $array_full_data['Retention']['confirm_sum'] += $order_count['confirm_sum'];
                        $array_full_data['Retention']['pending_sum'] += $order_count['pending_sum'];
                        $array_full_data['Retention']['pending_count'] += $order_count['pending_count'];
                        $array_full_data['Retention']['awb_assign_number'] += $order_count['awb_assign_number'];
                        $array_full_data['Retention']['awb_assign_sum'] += $order_count['awb_assign_sum'];
                        $array_full_data['Retention']['dispatch_number'] += $order_count['dispatch_number'];
                        $array_full_data['Retention']['dispatch_sum'] += $order_count['dispatch_sum'];
                        $array_full_data['Retention']['delivered_order_count'] += $order_count['delivered_order_count'];
                        $array_full_data['Retention']['delivered_order_sum'] += $order_count['delivered_order_sum'];
                     }else{
                 
                if (substr_count($order_count['it_easy_marketer_publisher'], 'ONLINE') && substr_count($order_count['it_easy_marketer_publisher'], 'facebook') && substr_count($order_count['it_easy_marketer_publisher'], 'Shopflo')){
                    $array_full_data['sfo']['it_easy_marketer_publisher'] = 'Shopflo_Facebook_ONLINE';
                    if(!isset($array_full_data['sfo']['total_order_number'])){
                        $array_full_data['sfo']['total_order_number'] = 0;
                        $array_full_data['sfo']['sum_assign_total'] = 0;
                        $array_full_data['sfo']['confirm_count'] = 0;
                        $array_full_data['sfo']['confirm_sum'] = 0;
                        $array_full_data['sfo']['pending_count'] = 0;
                        $array_full_data['sfo']['pending_sum'] = 0;
                        $array_full_data['sfo']['awb_assign_number'] = 0;
                        $array_full_data['sfo']['awb_assign_sum'] = 0;
                        $array_full_data['sfo']['dispatch_number'] = 0;
                        $array_full_data['sfo']['dispatch_sum'] = 0;
                        $array_full_data['sfo']['delivered_order_count'] = 0;
                        $array_full_data['sfo']['delivered_order_sum'] = 0;
                    }
                    
                    $array_full_data['sfo']['total_order_number'] += $order_count['total_order_number'];
                    $array_full_data['sfo']['sum_assign_total'] += $order_count['sum_assign_total'];
                    $array_full_data['sfo']['confirm_count'] += $order_count['confirm_count'];
                    $array_full_data['sfo']['confirm_sum'] += $order_count['confirm_sum'];
                    $array_full_data['sfo']['pending_sum'] += $order_count['pending_sum'];
                    $array_full_data['sfo']['pending_count'] += $order_count['pending_count'];
                    $array_full_data['sfo']['awb_assign_number'] += $order_count['awb_assign_number'];
                    $array_full_data['sfo']['awb_assign_sum'] += $order_count['awb_assign_sum'];
                    $array_full_data['sfo']['dispatch_number'] += $order_count['dispatch_number'];
                    $array_full_data['sfo']['dispatch_sum'] += $order_count['dispatch_sum'];
                    $array_full_data['sfo']['delivered_order_count'] += $order_count['delivered_order_count'];
                    $array_full_data['sfo']['delivered_order_sum'] += $order_count['delivered_order_sum'];
                }else if (substr_count($order_count['it_easy_marketer_publisher'], 'COD') && substr_count($order_count['it_easy_marketer_publisher'], 'facebook') && substr_count($order_count['it_easy_marketer_publisher'], 'Shopflo')){    
                    $array_full_data['sfc']['it_easy_marketer_publisher'] = 'Shopflo_Facebook_COD';
                    if(!isset($array_full_data['sfc']['total_order_number'])){
                        $array_full_data['sfc']['total_order_number'] = 0;
                        $array_full_data['sfc']['sum_assign_total'] = 0;
                        $array_full_data['sfc']['confirm_count'] = 0;
                        $array_full_data['sfc']['confirm_sum'] = 0;
                        $array_full_data['sfc']['pending_count'] = 0;
                        $array_full_data['sfc']['pending_sum'] = 0;
                        $array_full_data['sfc']['awb_assign_number'] = 0;
                        $array_full_data['sfc']['awb_assign_sum'] = 0;
                        $array_full_data['sfc']['dispatch_number'] = 0;
                        $array_full_data['sfc']['dispatch_sum'] = 0;
                        $array_full_data['sfc']['delivered_order_count'] = 0;
                        $array_full_data['sfc']['delivered_order_sum'] = 0;
                    }
                    $array_full_data['sfc']['total_order_number'] += $order_count['total_order_number'];
                    $array_full_data['sfc']['sum_assign_total'] += $order_count['sum_assign_total'];
                    $array_full_data['sfc']['confirm_count'] += $order_count['confirm_count'];
                    $array_full_data['sfc']['confirm_sum'] += $order_count['confirm_sum'];
                    $array_full_data['sfc']['pending_sum'] += $order_count['pending_sum'];
                    $array_full_data['sfc']['pending_count'] += $order_count['pending_count'];
                    $array_full_data['sfc']['awb_assign_number'] += $order_count['awb_assign_number'];
                    $array_full_data['sfc']['awb_assign_sum'] += $order_count['awb_assign_sum'];
                    $array_full_data['sfc']['dispatch_number'] += $order_count['dispatch_number'];
                    $array_full_data['sfc']['dispatch_sum'] += $order_count['dispatch_sum'];
                    $array_full_data['sfc']['delivered_order_count'] += $order_count['delivered_order_count'];
                    $array_full_data['sfc']['delivered_order_sum'] += $order_count['delivered_order_sum'];
                    
                }else if (substr_count($order_count['it_easy_marketer_publisher'], 'ONLINE') &&  substr_count($order_count['it_easy_marketer_publisher'], 'Shopflo')){
                    $array_full_data['so']['it_easy_marketer_publisher'] = 'Shopflo_ONLINE';
                    if(!isset($array_full_data['so']['total_order_number'])){
                        $array_full_data['so']['total_order_number'] = 0;
                        $array_full_data['so']['sum_assign_total'] = 0;
                        $array_full_data['so']['confirm_count'] = 0;
                        $array_full_data['so']['confirm_sum'] = 0;
                        $array_full_data['so']['pending_count'] = 0;
                        $array_full_data['so']['pending_sum'] = 0;
                        $array_full_data['so']['awb_assign_number'] = 0;
                        $array_full_data['so']['awb_assign_sum'] = 0;
                        $array_full_data['so']['dispatch_number'] = 0;
                        $array_full_data['so']['dispatch_sum'] = 0;
                        $array_full_data['so']['delivered_order_count'] = 0;
                        $array_full_data['so']['delivered_order_sum'] = 0;
                    }
                    $array_full_data['so']['total_order_number'] += $order_count['total_order_number'];
                    $array_full_data['so']['sum_assign_total'] += $order_count['sum_assign_total'];
                    $array_full_data['so']['confirm_count'] += $order_count['confirm_count'];
                    $array_full_data['so']['confirm_sum'] += $order_count['confirm_sum'];
                    $array_full_data['so']['pending_sum'] += $order_count['pending_sum'];
                    $array_full_data['so']['pending_count'] += $order_count['pending_count'];
                    $array_full_data['so']['awb_assign_number'] += $order_count['awb_assign_number'];
                    $array_full_data['so']['awb_assign_sum'] += $order_count['awb_assign_sum'];
                    $array_full_data['so']['dispatch_number'] += $order_count['dispatch_number'];
                    $array_full_data['so']['dispatch_sum'] += $order_count['dispatch_sum'];
                    $array_full_data['so']['delivered_order_count'] += $order_count['delivered_order_count'];
                    $array_full_data['so']['delivered_order_sum'] += $order_count['delivered_order_sum'];
                }else if (substr_count($order_count['it_easy_marketer_publisher'], 'Funnelish')){
                    $array_full_data['f']['it_easy_marketer_publisher'] = 'Funnelish';
                    if(!isset($array_full_data['f']['total_order_number'])){
                        $array_full_data['f']['total_order_number'] = 0;
                        $array_full_data['f']['sum_assign_total'] = 0;
                        $array_full_data['f']['confirm_count'] = 0;
                        $array_full_data['f']['confirm_sum'] = 0;
                        $array_full_data['f']['pending_count'] = 0;
                        $array_full_data['f']['pending_sum'] = 0;
                        $array_full_data['f']['awb_assign_number'] = 0;
                        $array_full_data['f']['awb_assign_sum'] = 0;
                        $array_full_data['f']['dispatch_number'] = 0;
                        $array_full_data['f']['dispatch_sum'] = 0;
                        $array_full_data['f']['delivered_order_count'] = 0;
                        $array_full_data['f']['delivered_order_sum'] = 0;
                    }
                    $array_full_data['f']['total_order_number'] += $order_count['total_order_number'];
                    $array_full_data['f']['sum_assign_total'] += $order_count['sum_assign_total'];
                    $array_full_data['f']['confirm_count'] += $order_count['confirm_count'];
                    $array_full_data['f']['confirm_sum'] += $order_count['confirm_sum'];
                    $array_full_data['f']['pending_sum'] += $order_count['pending_sum'];
                    $array_full_data['f']['pending_count'] += $order_count['pending_count'];
                    $array_full_data['f']['awb_assign_number'] += $order_count['awb_assign_number'];
                    $array_full_data['f']['awb_assign_sum'] += $order_count['awb_assign_sum'];
                    $array_full_data['f']['dispatch_number'] += $order_count['dispatch_number'];
                    $array_full_data['f']['dispatch_sum'] += $order_count['dispatch_sum'];
                    $array_full_data['f']['delivered_order_count'] += $order_count['delivered_order_count'];
                    $array_full_data['f']['delivered_order_sum'] += $order_count['delivered_order_sum'];
                }else if($order_count['it_easy_marketer_publisher'] == 'google'){
                    $array_full_data['g']['it_easy_marketer_publisher'] = 'GOOGLE';
                    if(!isset($array_full_data['g']['total_order_number'])){
                        $array_full_data['g']['total_order_number'] = 0;
                        $array_full_data['g']['sum_assign_total'] = 0;
                        $array_full_data['g']['confirm_count'] = 0;
                        $array_full_data['g']['confirm_sum'] = 0;
                        $array_full_data['g']['pending_count'] = 0;
                        $array_full_data['g']['pending_sum'] = 0;
                        $array_full_data['g']['awb_assign_number'] = 0;
                        $array_full_data['g']['awb_assign_sum'] = 0;
                        $array_full_data['g']['dispatch_number'] = 0;
                        $array_full_data['g']['dispatch_sum'] = 0;
                        $array_full_data['g']['delivered_order_count'] = 0;
                        $array_full_data['g']['delivered_order_sum'] = 0;
                    }
                    $array_full_data['g']['total_order_number'] += $order_count['total_order_number'];
                    $array_full_data['g']['sum_assign_total'] += $order_count['sum_assign_total'];
                    $array_full_data['g']['confirm_count'] += $order_count['confirm_count'];
                    $array_full_data['g']['confirm_sum'] += $order_count['confirm_sum'];
                    $array_full_data['g']['pending_sum'] += $order_count['pending_sum'];
                    $array_full_data['g']['pending_count'] += $order_count['pending_count'];
                    $array_full_data['g']['awb_assign_number'] += $order_count['awb_assign_number'];
                    $array_full_data['g']['awb_assign_sum'] += $order_count['awb_assign_sum'];
                    $array_full_data['g']['dispatch_number'] += $order_count['dispatch_number'];
                    $array_full_data['g']['dispatch_sum'] += $order_count['dispatch_sum'];
                    $array_full_data['g']['delivered_order_count'] += $order_count['delivered_order_count'];
                    $array_full_data['g']['delivered_order_sum'] += $order_count['delivered_order_sum'];
                }else if($order_count['it_easy_marketer_publisher'] == 'Direct'){
                    $array_full_data['d']['it_easy_marketer_publisher'] = 'Direct';
                    if(!isset($array_full_data['d']['total_order_number'])){
                        $array_full_data['d']['total_order_number'] = 0;
                        $array_full_data['d']['sum_assign_total'] = 0;
                        $array_full_data['d']['confirm_count'] = 0;
                        $array_full_data['d']['confirm_sum'] = 0;
                        $array_full_data['d']['pending_count'] = 0;
                        $array_full_data['d']['pending_sum'] = 0;
                        $array_full_data['d']['awb_assign_number'] = 0;
                        $array_full_data['d']['awb_assign_sum'] = 0;
                        $array_full_data['d']['dispatch_number'] = 0;
                        $array_full_data['d']['dispatch_sum'] = 0;
                        $array_full_data['d']['delivered_order_count'] = 0;
                        $array_full_data['d']['delivered_order_sum'] = 0;
                    }
                    $array_full_data['d']['total_order_number'] += $order_count['total_order_number'];
                    $array_full_data['d']['sum_assign_total'] += $order_count['sum_assign_total'];
                    $array_full_data['d']['confirm_count'] += $order_count['confirm_count'];
                    $array_full_data['d']['confirm_sum'] += $order_count['confirm_sum'];
                    $array_full_data['d']['pending_sum'] += $order_count['pending_sum'];
                    $array_full_data['d']['pending_count'] += $order_count['pending_count'];
                    $array_full_data['d']['awb_assign_number'] += $order_count['awb_assign_number'];
                    $array_full_data['d']['awb_assign_sum'] += $order_count['awb_assign_sum'];
                    $array_full_data['d']['dispatch_number'] += $order_count['dispatch_number'];
                    $array_full_data['d']['dispatch_sum'] += $order_count['dispatch_sum'];
                    $array_full_data['d']['delivered_order_count'] += $order_count['delivered_order_count'];
                    $array_full_data['d']['delivered_order_sum'] += $order_count['delivered_order_sum'];
                }else if($order_count['it_easy_marketer_publisher'] == 'COD_Shopflo'){
                    $array_full_data['cs']['it_easy_marketer_publisher'] = 'COD_Shopflo';
                    if(!isset($array_full_data['cs']['total_order_number'])){
                        $array_full_data['cs']['total_order_number'] = 0;
                        $array_full_data['cs']['sum_assign_total'] = 0;
                        $array_full_data['cs']['confirm_count'] = 0;
                        $array_full_data['cs']['confirm_sum'] = 0;
                        $array_full_data['cs']['pending_count'] = 0;
                        $array_full_data['cs']['pending_sum'] = 0;
                        $array_full_data['cs']['awb_assign_number'] = 0;
                        $array_full_data['cs']['awb_assign_sum'] = 0;
                        $array_full_data['cs']['dispatch_number'] = 0;
                        $array_full_data['cs']['dispatch_sum'] = 0;
                        $array_full_data['cs']['delivered_order_count'] = 0;
                        $array_full_data['cs']['delivered_order_sum'] = 0;
                    }
                    $array_full_data['cs']['total_order_number'] += $order_count['total_order_number'];
                    $array_full_data['cs']['sum_assign_total'] += $order_count['sum_assign_total'];
                    $array_full_data['cs']['confirm_count'] += $order_count['confirm_count'];
                    $array_full_data['cs']['confirm_sum'] += $order_count['confirm_sum'];
                    $array_full_data['cs']['pending_sum'] += $order_count['pending_sum'];
                    $array_full_data['cs']['pending_count'] += $order_count['pending_count'];
                    $array_full_data['cs']['awb_assign_number'] += $order_count['awb_assign_number'];
                    $array_full_data['cs']['awb_assign_sum'] += $order_count['awb_assign_sum'];
                    $array_full_data['cs']['dispatch_number'] += $order_count['dispatch_number'];
                    $array_full_data['cs']['dispatch_sum'] += $order_count['dispatch_sum'];
                    $array_full_data['cs']['delivered_order_count'] += $order_count['delivered_order_count'];
                    $array_full_data['cs']['delivered_order_sum'] += $order_count['delivered_order_sum'];
                }else{
                    $array_full_data[$key]['it_easy_marketer_publisher'] = $order_count['it_easy_marketer_publisher'];
                    if(!isset($array_full_data[$key]['total_order_number'])){
                        $array_full_data[$key]['total_order_number'] = 0;
                        $array_full_data[$key]['sum_assign_total'] = 0;
                        $array_full_data[$key]['confirm_count'] = 0;
                        $array_full_data[$key]['confirm_sum'] = 0;
                        $array_full_data[$key]['pending_count'] = 0;
                        $array_full_data[$key]['pending_sum'] = 0;
                        $array_full_data[$key]['awb_assign_number'] = 0;
                        $array_full_data[$key]['awb_assign_sum'] = 0;
                        $array_full_data[$key]['dispatch_number'] = 0;
                        $array_full_data[$key]['dispatch_sum'] = 0;
                        $array_full_data[$key]['delivered_order_count'] = 0;
                        $array_full_data[$key]['delivered_order_sum'] = 0;
                    }    
                     $array_full_data[$key]['total_order_number'] += $order_count['total_order_number'];
                    $array_full_data[$key]['sum_assign_total'] += $order_count['sum_assign_total'];
                    $array_full_data[$key]['confirm_count'] += $order_count['confirm_count'];
                    $array_full_data[$key]['confirm_sum'] += $order_count['confirm_sum'];
                    $array_full_data[$key]['pending_sum'] += $order_count['pending_sum'];
                    $array_full_data[$key]['pending_count'] += $order_count['pending_count'];
                    $array_full_data[$key]['awb_assign_number'] += $order_count['awb_assign_number'];
                    $array_full_data[$key]['awb_assign_sum'] += $order_count['awb_assign_sum'];
                    $array_full_data[$key]['dispatch_number'] += $order_count['dispatch_number'];
                    $array_full_data[$key]['dispatch_sum'] += $order_count['dispatch_sum'];
                    $array_full_data[$key]['delivered_order_count'] += $order_count['delivered_order_count'];
                    $array_full_data[$key]['delivered_order_sum'] += $order_count['delivered_order_sum'];
                }
                
                 }
                    
                
                }
                
                $key_a = $count_array + 1;
                if(!isset($total_order_number)){
                    $total_order_number = 0;
                    $sum_assign_total = 0;
                    $confirm_count = 0;
                    $confirm_sum = 0;
                    $pending_count = 0;
                    $pending_sum = 0;
                    $awb_assign_number = 0;
                    $awb_assign_sum = 0;
                    $dispatch_number = 0;
                    $dispatch_sum = 0;
                    $delivered_order_count = 0;
                    $delivered_order_sum = 0;
                } 
                    $it_easy_marketer_publisher = 'Total Numbers';
                    $total_order_number += $order_count['total_order_number'];
                    $sum_assign_total += $order_count['sum_assign_total'];
                    $confirm_count += $order_count['confirm_count'];
                    $confirm_sum += $order_count['confirm_sum'];
                    $pending_sum += $order_count['pending_sum'];
                    $pending_count += $order_count['pending_count'];
                    $awb_assign_number += $order_count['awb_assign_number'];
                    $awb_assign_sum += $order_count['awb_assign_sum'];
                    $dispatch_number += $order_count['dispatch_number'];
                    $dispatch_sum += $order_count['dispatch_sum'];
                    $delivered_order_count += $order_count['delivered_order_count'];
                    $delivered_order_sum += $order_count['delivered_order_sum'];
            }
            $array_full_data['Total']['it_easy_marketer_publisher'] = $it_easy_marketer_publisher;
            $array_full_data['Total']['total_order_number'] = $total_order_number;
            $array_full_data['Total']['sum_assign_total'] = $sum_assign_total;
            $array_full_data['Total']['confirm_count'] = $confirm_count;
            $array_full_data['Total']['confirm_sum'] = $confirm_sum;
            $array_full_data['Total']['pending_sum'] = $pending_sum;
            $array_full_data['Total']['pending_count'] = $pending_count;
            $array_full_data['Total']['awb_assign_number'] = $awb_assign_number;
            $array_full_data['Total']['awb_assign_sum'] = $awb_assign_sum;
            $array_full_data['Total']['dispatch_number'] = $dispatch_number;
            $array_full_data['Total']['dispatch_sum'] = $dispatch_sum;
            $array_full_data['Total']['delivered_order_count'] = $delivered_order_count;
            $array_full_data['Total']['delivered_order_sum'] = $delivered_order_sum;
            // echo "<pre>"; print_r($array_full_data); die;
            $dataProvider = new ArrayDataProvider([
                'allModels' => $array_full_data,
            ]);
            $dataProvider->pagination->pageSize = 500;
            

            if(isset($this->request->queryParams)){
              
              if(isset($this->request->queryParams['ItEasyOrderSearch']['it_easy_first_status'])){
                $searchModel->it_easy_first_status = $this->request->queryParams['ItEasyOrderSearch']['it_easy_first_status'];
              }
              if(isset($this->request->queryParams['ItEasyOrderSearch']['date_type_filter'])){
                $searchModel->date_type_filter = $this->request->queryParams['ItEasyOrderSearch']['date_type_filter'];
              }
              if(isset($this->request->queryParams['ItEasyOrderSearch']['date_to_date'])){
                $searchModel->date_to_date = $this->request->queryParams['ItEasyOrderSearch']['date_to_date'];
              }
              if(isset($this->request->queryParams['ItEasyOrderSearch']['date_from_date'])){
                $searchModel->date_from_date = $this->request->queryParams['ItEasyOrderSearch']['date_from_date'];
              }
            } 
            // echo "<pre>"; print_r($searchModel); die;
            return $this->render('report_proper', [
                'searchModel' => $searchModel,
                'dataProvider' => $dataProvider,
            ]);
        }else{
            throw new \yii\web\HttpException(404, 'The requested Item could not be found.');
        }
    }
    
    

    public function actionExport()
    {   
        set_time_limit(0);
  	    ini_set('max_execution_time', 0);
  	    ini_set("memory_limit", "-1");
        $searchModel = new ItEasyOrderSearch();
        $query = $searchModel->search($this->request->queryParams);
        $data_fetch = $query->asArray()->all();
        
        //echo $query->createCommand()->rawSql; die;
        
        
        $array = []; 
        $r = 0;
        
         //echo "<pre>"; print_r($data_fetch); die;
        foreach ($data_fetch as $key1 => $value1) {
            $product = ItEasyOrder::GrtOrderProducts($value1['order_id']);
            foreach ($product as $key => $value) {
                if($key  == 0){
                    $array[$r] =$value1;
                    $array[$r]['variation_name'] =$value['it_easy_variation_name'];
                    $array[$r]['product_name'] =$value['it_easy_product_name'];
                    $array[$r]['quantity'] =$value['it_easy_product_quantity'];
                    $array[$r]['without_GST'] =$value['it_easy_product_price'];
                    $array[$r]['product_total_price'] =$value['it_easy_product_total'];
                    $array[$r]['product_tax'] =$value['it_easy_product_tax'];

                }else{
                    $array[$r]['platform_name'] = '';
                    $array[$r]['order_number'] = '';
                    $array[$r]['transaction_id'] = '';
                    $array[$r]['other_order_id'] = '';
                    $array[$r]['invoice_number'] = '';
                    $array[$r]['order_type'] = '';
                    $array[$r]['payment_type'] = '';
                    $array[$r]['payment_method'] = '';
                    
                    
                  	$array[$r]['awb_number'] = '';
                  	$array[$r]['courier_name'] = '';
                    $array[$r]['total_price'] = '';
                    $array[$r]['GST_Price'] = '';
                    $array[$r]['First_Status'] = '';
                    $array[$r]['Status_Name'] = $value1['Status_Name'];
                    $array[$r]['Disposition_Name'] = '';
                    $array[$r]['customer'] = '';
                    $array[$r]['mobile_number'] = '';
                    $array[$r]['Address_1'] = '';
                    $array[$r]['Address_2'] = '';
                    $array[$r]['City'] = '';
                    $array[$r]['State'] = '';
                    $array[$r]['Pincode'] = '';
                    $array[$r]['TL_username'] = '';
                    $array[$r]['Agent_Username'] = '';
                    $array[$r]['Confirmation_username'] = '';
        
                    $array[$r]['Marketer_Publisher'] = '';
                    $array[$r]['Click_ID'] = '';
                    $array[$r]['Created_Time'] = '';
                    $array[$r]['Updated_Time'] = '';
                    $array[$r]['lead_Assigned_Time'] = '';
                    $array[$r]['Assigned_Time'] = '';
                    $array[$r]['Placed_Time'] = '';
                    $array[$r]['order_place_time'] = '';
                    $array[$r]['Confirmation_Time'] = '';
                    $array[$r]['variation_name'] =$value['it_easy_variation_name'];
                    $array[$r]['product_name'] =$value['it_easy_product_name'];
                    $array[$r]['quantity'] =$value['it_easy_product_quantity'];
                    $array[$r]['without_GST'] =$value['it_easy_product_price'];
                    $array[$r]['product_total_price'] =$value['it_easy_product_total'];
                    $array[$r]['product_tax'] =$value['it_easy_product_tax'];
                }

                $r++;
            }
         }
        
        
        if(Yii::$app->user->identity->it_easy_dept_id == '8'){
            $exporter = new Spreadsheet([
                'dataProvider' => new ArrayDataProvider([
                    'allModels' => $array,
                ]),
                'columns' => [
                    [   'attribute' => 'platform_name'],
                    [   'attribute' => 'Department_Name'],
                    [   'attribute' => 'order_number'],
                    [   'attribute' => 'transaction_id'],
                    [   'attribute' => 'other_order_id'],
                    [   'attribute' => 'invoice_number'],
                  	[   'attribute' => 'courier_name'],
                  	[   'attribute' => 'payment_type'],
                  	[   'attribute' => 'payment_method'],
                  	[   'attribute' => 'awb_number'],
                    [   'attribute' => 'total_price'],
                    [   'attribute' => 'GST_Price'],
                    [   'attribute' => 'First_Status'],
                    [   'attribute' => 'Status_Name'],
                    [   'attribute' => 'Disposition_Name'],
                    [   'attribute' => 'customer'],
                    [   'attribute' => 'customer_email'],
                    [   'attribute' => "mobile_number"],
                    [   'attribute' => 'Address_1'],
                    [   'attribute' => 'Address_2'],
                    [   'attribute' => 'City'],
                    [   'attribute' => 'State'],
                    [   'attribute' => 'Pincode'],
                    [   'attribute' => 'Confirmation_username'],
                    [   'attribute' => 'TL_username'],
                    [   'attribute' => 'Agent_Username'],
                    [   'attribute' => 'RetentionTL_username'],
                    [   'attribute' => 'RetentionAgent_Username'],
                    [   'attribute' => 'Marketer_Publisher'],
                    [   'attribute' => 'Click_ID'],
                    [   'attribute' => 'Created_Time'],
                    [   'attribute' => 'Updated_Time'],
                    [   'attribute' => 'order_place_time'],
                    [   'attribute' => 'lead_Assigned_Time'],
                    [   'attribute' => 'AWB_Assigned_Time'],
                    [   'attribute' => 'Confirmation_Time'],
                    [   'attribute' => 'Delivered_Time'],
                    [   'attribute' => 'product_name'],
                    [   'attribute' => 'variation_name'],
                    [   'attribute' => 'quantity'],
                    [   'attribute' => 'without_GST'],
                    [   'attribute' => 'product_tax'],
                    [   'attribute' => 'product_total_price'],
                ],
            ]);
        }else{
            $exporter = new Spreadsheet([
                'dataProvider' => new ArrayDataProvider([
                    'allModels' => $data_fetch,
                ]),
                'columns' => [
                    [   'attribute' => 'order_number'],
                    [   'attribute' => 'transaction_id'],
                    [   'attribute' => 'other_order_id'],
                    [   'attribute' => 'invoice_number'],
                  	[   'attribute' => 'courier_name'],
                  	[   'attribute' => 'awb_number'],
                    [   'attribute' => 'total_price'],
                    [   'attribute' => 'GST_Price'],
                    [   'attribute' => 'First_Status'],
                    [   'attribute' => 'Status_Name'],
                    [   'attribute' => 'Disposition_Name'],
                    [   'attribute' => 'customer'],
                    [   'attribute' => 'customer_email'],
                    [   'attribute' => 'Address_1'],
                    [   'attribute' => 'Address_2'],
                    [   'attribute' => 'City'],
                    [   'attribute' => 'State'],
                    [   'attribute' => 'Pincode'],
                    [   'attribute' => 'TL_username'],
                    [   'attribute' => 'Agent_Username'],
                    [   'attribute' => 'Marketer_Publisher'],
                    [   'attribute' => 'Click_ID'],
                    [   'attribute' => 'Created_Time'],
                    [   'attribute' => 'Updated_Time'],
                    [   'attribute' => 'order_place_time'],
                    [   'attribute' => 'Assigned_Time'],
                    [   'attribute' => 'Confirmation_Time'],
                    [   'attribute' => 'Delivered_Time'],
                    [   'attribute' => 'product_name'],
                    [   'attribute' => 'variation_name'],
                    [   'attribute' => 'quantity'],
                    [   'attribute' => 'without_GST'],
                    [   'attribute' => 'product_tax'],
                    [   'attribute' => 'product_total_price'],
                ],
            ]);
        }
        return $exporter->send('Order-Export.xlsx');
        
    }

    
    public function actionCreate()
    {
        $model = new ItEasyOrder();
        $product_model = new ItEasyOrderProduct();
        if ($this->request->isPost) {
            if ($model->load($this->request->post())) {
                $post = $this->request->post();
                // echo "<pre>"; print_r($post); die;
                $model->it_easy_platform = $post['ItEasyOrder']['it_easy_platform'];
                $ipaddress = ItEasyOrder::getIpaddress();
                $get_device = ItEasyOrder::getDevicename();
                $browser = ItEasyOrder::getBrowsername();
                $get_financial_year = ItEasyFinancialYear::getFinancialrealyear();
                $model->it_easy_financial_year = $get_financial_year;
                $model->it_easy_store_id = ItEasyStore::getStorename()->it_easy_id;
                $model->it_easy_store_name = ItEasyStore::getStorename()->it_easy_store_name;
                $get_state_data = ItEasyState::getStatedatabyId($post['ItEasyOrder']['it_easy_state_id']);
                $get_paymentmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode($post['ItEasyOrder']['it_easy_payment_method']);
                $get_shippingmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode($post['ItEasyOrder']['it_easy_shipping_method']);
                $post['ItEasyOrder']['it_easy_state'] = $get_state_data->it_easy_state_name;
                $model->it_easy_abondoned_type = $post['ItEasyOrder']['it_easy_abondoned_type'];
                $model->it_easy_state = $get_state_data->it_easy_state_name;
                $model->it_easy_shipping_state = $get_state_data->it_easy_state_name;
                $model->it_easy_billing_state = $get_state_data->it_easy_state_name;
                $model->it_easy_billing_lastname = $post['ItEasyOrder']['it_easy_billing_lastname'];
                $model->it_easy_payment_method = $get_paymentmethod->it_easy_method_name;
                $model->it_easy_payment_code = $get_paymentmethod->it_easy_method_code;
                $model->it_easy_shipping_method = $get_shippingmethod->it_easy_method_name;
                $model->it_easy_shipping_code = $get_shippingmethod->it_easy_method_code;
                $model->it_easy_country = 'IN';
                $model->it_easy_shipping_country = 'IN';
                $model->it_easy_billing_country = 'IN';
                $model->it_easy_first_status = 'Lead';
                if(Yii::$app->user->identity->it_easy_dept_id == '9' && Yii::$app->user->identity->it_easy_type_id == '3'){
                    $model->it_easy_assigned_by = '1';
                    $model->it_easy_retention_TLid = Yii::$app->user->identity->id;
                    $model->it_easy_assigned_to = Yii::$app->user->identity->id;
                    $model->it_easy_retention_AGENTid = '0';
                }else if(Yii::$app->user->identity->it_easy_dept_id == '9' && ( Yii::$app->user->identity->it_easy_type_id == '4' ||  Yii::$app->user->identity->it_easy_type_id == '5')){
                    $model->it_easy_assigned_by = '1';
                    $model->it_easy_retention_TLid = '1';
                    $model->it_easy_assigned_to = Yii::$app->user->identity->id;
                    $model->it_easy_retention_AGENTid = Yii::$app->user->identity->id;
                }else{
                    $model->it_easy_assigned_by = '1';
                    $model->it_easy_assigned_to = Yii::$app->user->identity->id;
                    
                }
                $model->it_easy_read_status = '0';
                $model->it_easy_server_ip = $ipaddress;
                $model->it_easy_device = $get_device;
                $model->it_easy_browser = $browser;
                
                $model->it_easy_department_id = Yii::$app->user->identity->it_easy_dept_id;
              	$explode_disease = implode(',', $post['ItEasyOrder']['it_easy_disease_name']);
                $model->it_easy_disease_name = $explode_disease;
                $model->created_by = Yii::$app->user->identity->id;
                $model->it_easy_created_time = date('Y-m-d H:i:s');
                $model->it_easy_updated_time = date('Y-m-d H:i:s');
                $find_customer_data = ItEasyCustomer::FindCustomerbyMobile($post['ItEasyOrder']['it_easy_mobile_number']);
                // echo "<pre>"; print_r($find_customer_data); die;
                $address_model = new ItEasyOrder();
                $f_name = $model->it_easy_shipping_firstname.' '.$model->it_easy_lastname;
                $f_address = $model->it_easy_shipping_address_1.' '.$model->it_easy_shipping_address_2.' '.$model->it_easy_shipping_city;
                $address_validator = $address_model->getAddressValidator($f_name, $model->it_easy_shipping_email, $f_address, $model->it_easy_shipping_state, $model->it_easy_shipping_pincode, 'new-order');
                
                if(!empty($address_validator)){
                    if($address_validator->meta->status == '200'){
                        $model->address_validator_response =     $address_validator->result->address_category.'-'.$address_validator->result->pincode_rto_risk.'-'.$address_validator->result->address_incomplete_reason;
                    }
                }
                
                
                $model->save(false);
                $recommand =  ItEasyOrder::FindRecommandClickpost($model->it_easy_order_id,$post['ItEasyOrder']['it_easy_pincode'], $model->it_easy_payment_code);
                                      	
              	$model->it_easy_order_serviceable = $recommand;
                
                if(empty($find_customer_data)){
                    $find_customer_data = ItEasyCustomer::SavecustomerModelFromMobile($post['ItEasyOrder'], $model->it_easy_order_id);
                    $model->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
                }else{

                    $model->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
                    if(!empty($find_customer_data->it_easy_order_ids)){
                        $customer_it_easy_order_ids = explode(',', $find_customer_data->it_easy_order_ids);
                        if (!in_array($model->it_easy_order_id, $customer_it_easy_order_ids)){
                            $find_customer_data->it_easy_order_ids = $find_customer_data->it_easy_order_ids.','.$model->it_easy_order_id;
                          	$explode_disease = implode(',', $post['ItEasyOrder']['it_easy_disease_name']);
                            $find_customer_data->it_easy_disease_name = $explode_disease;
                            $find_customer_data->save();
                        }
                    }
                }
                
                $addOrderStatusHistory = ItEasyOrder::addOrderStatusHistory($model->it_easy_order_id, $model->it_easy_order_status_id, $post['ItEasyOrder']['it_easy_order_status_comment']);
                $addDispositionStatusHistory = ItEasyOrder::addDispositionStatusHistory($model->it_easy_order_id, $model->it_easy_order_disposition_id, $post['ItEasyOrder']['it_easy_order_disposition_comment']);
                
                if($model->it_easy_order_disposition_id == '3'){
              	    $model->it_easy_order_place_time = date('Y-m-d H:i:s');
              	}
                
                
                
                $quantity_order = 0;
                $it_easy_total_price = 0;
                $it_easy_gst_price = 0;

                foreach ($post['ItEasyOrderProduct'] as $key => $value) {
                        if(isset($value['it_easy_product_id'])){
                            $quantity_order +=$value['it_easy_product_quantity'];
                            
                            $product_variation = ItEasyOrder::getProductVariationData($value['it_easy_product_id'], $value['it_easy_variation_id']);
                            $product_taxe = $value['it_easy_product_quantity'] * $product_variation['it_easy_tax_price'];
                            $t_product_price = $product_variation['it_easy_varation_price'] * $value['it_easy_product_quantity'];
                            $it_easy_total_price +=  $t_product_price;
                            $it_easy_gst_price += $product_taxe;
                            $orderProductModel = new ItEasyOrderProduct();
                            $orderProductModel->it_easy_order_id = $model->it_easy_order_id;
                            $orderProductModel->it_easy_product_id = $product_variation['it_easy_product_id'];
                            $orderProductModel->it_easy_product_name = $product_variation['it_easy_product_name'];
                            $orderProductModel->it_easy_product_sku = $product_variation['it_easy_product_name'];
                            $orderProductModel->it_easy_variation_name = $product_variation['it_easy_variation_name']; 
                            $orderProductModel->it_easy_variation_id = $product_variation['it_easy_variation_id'];
                            $orderProductModel->it_easy_product_quantity = $value['it_easy_product_quantity'];
                            $orderProductModel->it_easy_product_total = $product_variation['it_easy_varation_price'] * $value['it_easy_product_quantity'];
                            $orderProductModel->it_easy_product_price = $product_variation['it_easy_price_without_tax'] * $value['it_easy_product_quantity'];
                            $orderProductModel->it_easy_product_tax = $value['it_easy_product_quantity'] * $product_variation['it_easy_tax_price'];
                            $orderProductModel->created_time = date('Y-m-d H:i:s');
                            $orderProductModel->save();
                        } 
                }

                if(!empty($model->it_easy_coupon_id)){
                    $coupon_model = new ItEasyCouponHistory();
                    $get_coupon_data = ItEasyOrder::getCoouponbyid($model->it_easy_coupon_id);
                        
                    if($get_coupon_data->it_easy_coupon_type == 'Flat'){
                        $dis_coupon_value = $get_coupon_data->it_easy_discount;
                        $it_easy_total_price = $it_easy_total_price - $get_coupon_data->it_easy_discount;
                    }else{
                        $dis_coupon_value = $it_easy_total_price * $get_coupon_data->it_easy_discount /  100;
                        $it_easy_total_price = $it_easy_total_price - $dis_coupon_value;
                    }    
                    $coupon_model->it_easy_order_id = $model->it_easy_order_id;
                    $coupon_model->it_easy_coupon_id = $model->it_easy_coupon_id;
                    $coupon_model->it_easy_customer_id  = $model->it_easy_customer_id;
                    $coupon_model->it_easy_table_name = 'it_easy_order_'.$get_financial_year;
                    $coupon_model->it_easy_coupon_code = $get_coupon_data->it_easy_coupon_code;
                    $coupon_model->it_easy_coupon_discount = $dis_coupon_value;
                    $coupon_model->it_easy_created_time = date('Y-m-d H:i:s');
                    $coupon_model->save();
                }
                if(!empty($get_shippingmethod->it_easy_method_value)){
                    if($get_shippingmethod->it_easy_add_value_type == 'Flat'){
                        if($get_shippingmethod->it_easy_method_value_type == 'Add-Amount'){
                            $it_easy_total_price = $it_easy_total_price + $get_shippingmethod->it_easy_method_value;
                        }else{
                            $it_easy_total_price = $it_easy_total_price - $get_shippingmethod->it_easy_method_value;
                        }
                    }else{
                        if($get_shippingmethod->it_easy_method_value_type == 'Add-Amount'){
                            $get_percentage_value = $it_easy_total_price * $get_shippingmethod->it_easy_method_value / 100;
                            $it_easy_total_price = $it_easy_total_price + $get_percentage_value;
                        }else{
                            $get_percentage_value = $it_easy_total_price * $get_shippingmethod->it_easy_method_value / 100;
                            $it_easy_total_price = $it_easy_total_price - $get_percentage_value;
                        }
                    }
                }
                 
                if(!empty($get_paymentmethod->it_easy_method_value)){
                    if($get_paymentmethod->it_easy_add_value_type == 'Flat'){
                        if($get_paymentmethod->it_easy_method_value_type == 'Add-Amount'){
                             
                            $it_easy_total_price = $it_easy_total_price + $get_paymentmethod->it_easy_method_value;
                        }else{
                            $it_easy_total_price = $it_easy_total_price - $get_paymentmethod->it_easy_method_value;
                        }
                    }else{
                        if($get_paymentmethod->it_easy_method_value_type == 'Add-Amount'){
                            $get_percentage_value = $it_easy_total_price * $get_paymentmethod->it_easy_method_value / 100;
                            $it_easy_total_price = $it_easy_total_price + $get_percentage_value;
                        }else{
                            $get_percentage_value = $it_easy_total_price * $get_paymentmethod->it_easy_method_value / 100;
                            $it_easy_total_price = $it_easy_total_price - $get_percentage_value;
                        }
                    }
                }   
                
                $model->it_easy_total_price = $it_easy_total_price;
                $model->it_easy_gst_price = $it_easy_gst_price;
                $model->it_easy_product_quantity = $quantity_order;
                $model->it_easy_order_number = 'NH'.$model->it_easy_order_id;
                $model->it_easy_invoice_number = 'NH-'.$get_financial_year.'-'.$model->it_easy_order_id;
                $model->save(false);  
                
                $this->sendOrderCreatedWebhook($model);
                
                Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');   
                return $this->redirect(['index']);
            }
        } else {
            $model->loadDefaultValues();
        }

        $stateList = ItEasyState::getStateallData();
        $statedata = ArrayHelper::map($stateList, 'it_easy_id', 'it_easy_state_name');
        $order_status_list = ItEasyOrder::getAHelperOrderStatusForAgentsw();    
        $order_statusdata = ArrayHelper::map($order_status_list, 'it_easy_order_status_id', 'it_easy_order_status_name');
        $disposition_status_list = ItEasyOrder::getAHelperDispositionStatusForAgent();
        $order_dispositiondata = ArrayHelper::map($disposition_status_list, 'it_easy_order_disposition_id', 'it_easy_order_disposition_name');
        $shippingmethod_list_data = ItEasyOrder::getAHelperShippingMethod();
        $shipping_method = ArrayHelper::map($shippingmethod_list_data, 'it_easy_method_code', 'it_easy_method_name' );
        $payemntmethod_list_data = ItEasyOrder::getAHelperPaymentMethod();
        $payment_method = ArrayHelper::map($payemntmethod_list_data, 'it_easy_method_code', 'it_easy_method_name' );

        return $this->render('_form', [
            'model' => $model,
            'product_model' => $product_model,
            'statedata' => $statedata,
            'order_status_list' => $order_status_list,
            'order_dispositiondata' => $order_dispositiondata,
            'shipping_method' => $shipping_method,
            'payment_method' => $payment_method,
            'order_dispositiondata' => $order_dispositiondata,
            'order_statusdata' => $order_statusdata
        ]);
    }

    /**
     * Updates an existing ItEasyOrder model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_order_id It Easy Order ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_order_id)
    {
        $model = $this->findModel($it_easy_order_id);
        $product_model = new ItEasyOrderProduct();
        $statusmodel = new ItEasyOrderStatusHistory();
        $dispositionmodel = new ItEasyOrderDispositionHistory();
        $commentmodel = new ItEasyOrderHistory();

        if(Yii::$app->user->identity->it_easy_dept_id == '4'){
            if($model->it_easy_read_status == '0'){
                $model->it_easy_read_status = '1';
                $model->save();
            }
        }
        
        if(Yii::$app->user->identity->id == '1'){
            // $post = $this->request->post();
            // echo "<pre>"; print_r($post); die;
            
        }


        if ($this->request->isPost && $model->load($this->request->post())) {
            $post = $this->request->post();
            // echo "<pre>"; print_r($post); die;
            if(isset($post['ItEasyOrder']) && !isset($post['ItEasyOrderDispositionHistory']) && !isset($post['ItEasyOrderStatusHistory']) && !isset($post['ItEasyOrderHistory'])){
            $ipaddress = ItEasyOrder::getIpaddress();
            $get_device = ItEasyOrder::getDevicename();
            $browser = ItEasyOrder::getBrowsername();
            $get_financial_year = ItEasyFinancialYear::getFinancialyear();
            $get_realfinancial_year = ItEasyFinancialYear::getFinancialrealyear();
            if(isset($post['ItEasyOrder']['it_easy_state_id'])){
                $get_state_data = ItEasyState::getStatedatabyId($post['ItEasyOrder']['it_easy_state_id']);
                $model->it_easy_billing_lastname = $post['ItEasyOrder']['it_easy_billing_lastname'];
                $model->it_easy_shipping_lastname = $post['ItEasyOrder']['it_easy_shipping_lastname'];
              	
                $model->it_easy_state = $get_state_data->it_easy_state_name;
                $post['ItEasyOrder']['it_easy_state'] =$get_state_data->it_easy_state_name;
                $find_customer_data = ItEasyCustomer::FindCustomerbyMobile($post['ItEasyOrder']['it_easy_mobile_number']);
                // echo "<pre>"; print_r($post['ItEasyOrder']); die;
                if(empty($find_customer_data)){
                    $find_customer_data = ItEasyCustomer::SavecustomerModelFromMobile($post['ItEasyOrder'], $model->it_easy_order_id);
                    $model->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
                }else{
                    $model->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
                    if(!empty($find_customer_data->it_easy_order_ids)){
                        $customer_it_easy_order_ids = explode(',', $find_customer_data->it_easy_order_ids);
                        if (!in_array($model->it_easy_order_id, $customer_it_easy_order_ids)){
                            $find_customer_data->it_easy_order_ids = $find_customer_data->it_easy_order_ids.','.$model->it_easy_order_id;
                          	
                            $find_customer_data->save();
                        }
                    }
                }
                
                $model->it_easy_shipping_state = $get_state_data->it_easy_state_name;
                $model->it_easy_billing_state = $get_state_data->it_easy_state_name;
                
                $address_model = new ItEasyOrder();
                $f_name = $model->it_easy_shipping_firstname.' '.$model->it_easy_lastname;
                $f_address = $model->it_easy_shipping_address_1.' '.$model->it_easy_shipping_address_2.' '.$model->it_easy_shipping_city;
                $address_validator = $address_model->getAddressValidator($f_name, $model->it_easy_shipping_email, $f_address, $model->it_easy_shipping_state, $model->it_easy_shipping_pincode, $model->it_easy_order_id);
                
                if(!empty($address_validator)){
                    if($address_validator->meta->status == '200'){
                        $model->address_validator_response =     $address_validator->result->address_category.'-'.$address_validator->result->pincode_rto_risk.'-'.$address_validator->result->address_incomplete_reason;
                    }
                }
                
                
                
                $model->save(false);
                // echo "<pre>"; print_r($model); die;
                Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
                return $this->redirect(['update', 'it_easy_order_id' => $model->it_easy_order_id]);
            }

            $quantity_order = 0;
            $it_easy_total_price = 0;
            $it_easy_gst_price = 0;
            // echo "<pre>"; print_R($post); die; 
            if(isset($post['ItEasyOrderProduct'])){
                
            
                // echo "<pre>"; print_r($post); die;
                $p_id_with_mix = [];
                foreach ($post['ItEasyOrderProduct'] as $key => $p_mix) {
                    if(!empty($p_mix['it_easy_id'])){
                        $p_id_with_mix[] = $p_mix['it_easy_id'];
                    }
                }
                // echo "<pre>"; print_r($p_id_with_mix); die;
                $dks = ItEasyOrderProduct::deleteAll([ 'and', ['and',
                    ['not in', 'it_easy_id', $p_id_with_mix]
                    ],
                    [ 'it_easy_order_id'=> $model->it_easy_order_id]]
                );
            
                $prouct_array_id = [];
                $variation_array_id = [];
            foreach ($post['ItEasyOrderProduct'] as $key => $value) {
                    if(isset($value['it_easy_product_id'])){
                        $prouct_array_id[$key] = $value['it_easy_product_id'];
                        $variation_array_id[$key] = $value['it_easy_variation_id'];
                        $quantity_order +=$value['it_easy_product_quantity'];
                        
                        $product_variation = ItEasyOrder::getProductVariationData($value['it_easy_product_id'], $value['it_easy_variation_id']);
                        
                        
                        $p_data = ItEasyOrder::FindProductbyid($value['it_easy_product_id']);
                        // echo "<pre>"; print_r($p_data); die;
                        $p_data_tax_percentage = $p_data->it_easy_product_tax;
                        if(!empty($p_data_tax_percentage)){
                            $tax_price_p = ROUND(($value['it_easy_product_total'] * $p_data_tax_percentage )/100, 2);
                        }else{
                            $tax_price_p = ROUND(($value['it_easy_product_total'] * 12 )/100, 2);
                        }
                        
                        // echo "<pre>"; print_r($p_data_tax_percentage); die;
                        $product_taxe = $value['it_easy_product_quantity'] * $tax_price_p;
                        $t_product_price = $value['it_easy_product_total'] * $value['it_easy_product_quantity'];
                        $it_easy_total_price +=  $t_product_price;
                        $it_easy_gst_price += $product_taxe;
                        $check_product_model = ItEasyOrder::getOrderProductbyOrderId($model->it_easy_order_id, $value['it_easy_product_id'], $value['it_easy_variation_id']);
                        if(empty($check_product_model)){
                            $orderProductModel = new ItEasyOrderProduct();
                            $orderProductModel->it_easy_order_id = $model->it_easy_order_id;
                            $orderProductModel->created_time = date('Y-m-d H:i:s');
                        }else{
                            $orderProductModel = $check_product_model;
                        }
                        $orderProductModel->it_easy_product_id = $value['it_easy_product_id'];
                        $orderProductModel->it_easy_product_name = $product_variation['it_easy_product_name'];
                        $orderProductModel->it_easy_product_sku = $product_variation['it_easy_product_name'];
                        $orderProductModel->it_easy_variation_name = $product_variation['it_easy_variation_name']; 
                        $orderProductModel->it_easy_variation_id = $value['it_easy_variation_id'];
                        $orderProductModel->it_easy_product_quantity = $value['it_easy_product_quantity'];
                        $orderProductModel->it_easy_product_total = $t_product_price;
                        $orderProductModel->it_easy_product_price = $t_product_price - $product_taxe;
                        $orderProductModel->it_easy_product_tax = $product_taxe;
                        $orderProductModel->updated_time = date('Y-m-d H:i:s');
                        $orderProductModel->save();
                    } 
            }
            // if(Yii::$app->user->identity->id == '1'){
                // echo "<pre>"; print_R($post); die; 
                // echo "<pre>"; print_r($variation_array_id);
                // echo "<pre>"; print_r($prouct_array_id); 
                
            //     // ItEasyProductVariation::deleteAll(['AND', ['it_easy_product_id'  => $model->it_easy_product_id], ['NOT IN', 'it_easy_id',$array_build_material ] ]);
                
            //     $query_data =  ItEasyOrderProduct::find()->where(['it_easy_order_id'=> $model->it_easy_order_id])->andWhere([])->andWhere(['and', ['not in', 'it_easy_product_id', $prouct_array_id],
            //     ['not in', 'it_easy_variation_id', $variation_array_id]])->createCommand()->rawSql;
            //     echo $query_data; die;
            // // $dks = ItEasyOrderProduct::findAll(['and',
            // //     [ 'it_easy_order_id'=> $model->it_easy_order_id]]
            // // );
            
            // echo "<pre>"; print_r($prouct_array_id); die;
            }
            
            
            // }
            if(isset($post['ItEasyOrder']['it_easy_disease_name']) && !empty($post['ItEasyOrder']['it_easy_disease_name'])){
                $explode_disease = implode(',', $post['ItEasyOrder']['it_easy_disease_name']);
            }else{
                $explode_disease = 'Other';
            }
            $model->it_easy_disease_name = $explode_disease;
            $find_customer_id = ItEasyCustomer::find()->where(['it_easy_customer_id' => $model->it_easy_customer_id])->One();
            $find_customer_id->it_easy_disease_name = $explode_disease;
            if(isset($post['ItEasyOrder']['it_easy_age']) && !empty($post['ItEasyOrder']['it_easy_age'])){
            $find_customer_id->it_easy_age = $post['ItEasyOrder']['it_easy_age'];
            }
            $find_customer_id->save(false);

            $model->save(false);
            
            
            if(!empty($model->it_easy_coupon_id)){
                $coupon_model = ItEasyCouponHistory::findOne(['it_easy_order_id' => $model->it_easy_order_id]);
                if(empty($coupon_model)){
                    $coupon_model = new ItEasyCouponHistory();
                }
                $get_coupon_data = ItEasyOrder::getCoouponbyid($model->it_easy_coupon_id);
                    
                if($get_coupon_data->it_easy_coupon_type == 'Flat'){
                    $dis_coupon_value = $get_coupon_data->it_easy_discount;
                    $it_easy_total_price = $it_easy_total_price - $get_coupon_data->it_easy_discount;
                }else{
                    $dis_coupon_value = $it_easy_total_price * $get_coupon_data->it_easy_discount /  100;
                    $it_easy_total_price = $it_easy_total_price - $dis_coupon_value;
                }    
                $coupon_model->it_easy_order_id = $model->it_easy_order_id;
                $coupon_model->it_easy_coupon_id = $model->it_easy_coupon_id;
                $coupon_model->it_easy_customer_id  = $model->it_easy_customer_id;
                $coupon_model->it_easy_table_name = 'it_easy_order_'.$get_financial_year;
                $coupon_model->it_easy_coupon_code = $get_coupon_data->it_easy_coupon_code;
                $coupon_model->it_easy_coupon_discount = $dis_coupon_value;
                $coupon_model->it_easy_created_time = date('Y-m-d H:i:s');
                $coupon_model->save();
            }else{
                if(!empty($post['ItEasyOrder']['coupon_id_last'])){
                    $model->it_easy_coupon_id = $post['ItEasyOrder']['coupon_id_last'];
                    $model->save(false);
                }else{
                    ItEasyCouponHistory::deleteAll(['it_easy_order_id'=> $model->it_easy_order_id]);
                    $model->it_easy_coupon_id = '';
                    $model->save(false);
                }
            }
            if(isset($post['ItEasyOrder']['it_easy_payment_code'])){
            $get_paymentmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode($post['ItEasyOrder']['it_easy_payment_code']);
            if(Yii::$app->user->identity->id == '1'){
                // $post = $this->request->post();
                // echo "<pre>"; print_r($get_paymentmethod); die;
                
            }
            $model->it_easy_payment_method = $get_paymentmethod->it_easy_method_name;
            $get_shippingmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode($post['ItEasyOrder']['it_easy_shipping_code']);
            
            $model->it_easy_shipping_method = $get_shippingmethod->it_easy_method_name;
            if(!empty($get_shippingmethod->it_easy_method_value)){
                if($get_shippingmethod->it_easy_add_value_type == 'Flat'){
                    if($get_shippingmethod->it_easy_method_value_type == 'Add-Amount'){
                        $it_easy_total_price = $it_easy_total_price + $get_shippingmethod->it_easy_method_value;
                    }else{
                        $it_easy_total_price = $it_easy_total_price - $get_shippingmethod->it_easy_method_value;
                    }
                }else{
                    if($get_shippingmethod->it_easy_method_value_type == 'Add-Amount'){
                        $get_percentage_value = $it_easy_total_price * $get_shippingmethod->it_easy_method_value / 100;
                        $it_easy_total_price = $it_easy_total_price + $get_percentage_value;
                    }else{
                        $get_percentage_value = $it_easy_total_price * $get_shippingmethod->it_easy_method_value / 100;
                        $it_easy_total_price = $it_easy_total_price - $get_percentage_value;
                    }
                }
            }
             
            if(!empty($get_paymentmethod->it_easy_method_value)){
                if($get_paymentmethod->it_easy_add_value_type == 'Flat'){
                    if($get_paymentmethod->it_easy_method_value_type == 'Add-Amount'){
                         
                        $it_easy_total_price = $it_easy_total_price + $get_paymentmethod->it_easy_method_value;
                    }else{
                        $it_easy_total_price = $it_easy_total_price - $get_paymentmethod->it_easy_method_value;
                    }
                }else{
                    if($get_paymentmethod->it_easy_method_value_type == 'Add-Amount'){
                        $get_percentage_value = $it_easy_total_price * $get_paymentmethod->it_easy_method_value / 100;
                        $it_easy_total_price = $it_easy_total_price + $get_percentage_value;
                    }else{
                        $get_percentage_value = $it_easy_total_price * $get_paymentmethod->it_easy_method_value / 100;
                        $it_easy_total_price = $it_easy_total_price - $get_percentage_value;
                    }
                }
            }
            
            }
            $model->it_easy_server_ip = $ipaddress;
            $model->it_easy_device = $get_device;
            $model->it_easy_browser = $browser; 
            $model->updated_by = Yii::$app->user->identity->id;
            $model->it_easy_updated_time = date('Y-m-d H:i:s');  
            $model->it_easy_total_price = $it_easy_total_price;
            $model->it_easy_gst_price = $it_easy_gst_price;
            $model->it_easy_product_quantity = $quantity_order;
            $model->it_easy_order_number = 'NH'.$model->it_easy_order_id;
            $model->it_easy_invoice_number = 'NH-'.$get_realfinancial_year.'-'.$model->it_easy_order_id;
            $model->it_easy_abondoned_type = $post['ItEasyOrder']['it_easy_abondoned_type'];
            $model->save(false);
            Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
            return $this->redirect(['index', 'it_easy_order_id' => $model->it_easy_order_id]);
            }
        }
        
    
        if ($this->request->isPost && $statusmodel->load($this->request->post())) {
            $post = $this->request->post();
            if(isset($post['ItEasyOrderStatusHistory']['it_easy_order_status_id'])){
              	if($model->it_easy_order_status_id != $post['ItEasyOrderStatusHistory']['it_easy_order_status_id']){
                  if($post['ItEasyOrderStatusHistory']['it_easy_order_status_id'] == '1'){
                    	$model->it_easy_converted_time = date('Y-m-d H:i:s');
                  }
                }
              			$model->it_easy_order_status_id = $post['ItEasyOrderStatusHistory']['it_easy_order_status_id'];
              			$model->it_easy_updated_time = date('Y-m-d H:i:s');
              			$model->save(false);
                $addOrderStatusHistory = ItEasyOrder::addOrderStatusHistory($model->it_easy_order_id, $post['ItEasyOrderStatusHistory']['it_easy_order_status_id'], $post['ItEasyOrderStatusHistory']['it_easy_comment']);
                Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
                $this->sendOrderCreatedWebhook($model);
                return $this->redirect(['update', 'it_easy_order_id' => $model->it_easy_order_id]);
            }
        }
        
        
        if ($this->request->isPost && $dispositionmodel->load($this->request->post())) {
            $post = $this->request->post();
            // echo "<pre>"; print_r($post); die;
            if(isset($post['ItEasyOrderDispositionHistory']['it_easy_order_disposition_id'])){
                $addOrderStatusHistory = ItEasyOrder::addDispositionStatusHistory($model->it_easy_order_id, $post['ItEasyOrderDispositionHistory']['it_easy_order_disposition_id'], $post['ItEasyOrderDispositionHistory']['it_easy_comment']);
              
              	$model->it_easy_order_disposition_id = $post['ItEasyOrderDispositionHistory']['it_easy_order_disposition_id'];
              	if($model->it_easy_order_disposition_id == '3'){
              	    $model->it_easy_order_place_time = date('Y-m-d H:i:s');
              	}
              	if(!empty($post['ItEasyOrder']['it_easy_disposition_time'])){
              	    $model->it_easy_disposition_time = $post['ItEasyOrder']['it_easy_disposition_time'];
              	}
                $model->it_easy_updated_time = date('Y-m-d H:i:s');
                $model->save(false);
                
                
                Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
                  $this->sendOrderCreatedWebhook($model);
                return $this->redirect(['update', 'it_easy_order_id' => $model->it_easy_order_id]);
            }
        }
        if ($this->request->isPost && $commentmodel->load($this->request->post())) {
            $post = $this->request->post();
            if(isset($post['ItEasyOrderHistory']['it_easy_comment'])){
                $addOrderStatusHistory = ItEasyOrder::addOrderSHistory($model->it_easy_order_id, $post['ItEasyOrderHistory']['it_easy_comment']);
              	$model->it_easy_comment = $post['ItEasyOrderHistory']['it_easy_comment'];
                $model->it_easy_updated_time = date('Y-m-d H:i:s');
                $model->save(false);
                Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
                return $this->redirect(['update', 'it_easy_order_id' => $model->it_easy_order_id]);
            }
        }
        $prod_model = $this->findProductModel($it_easy_order_id);
        $get_coupon_data = ItEasyOrder::getCoouponbyidArrayHelper($model->it_easy_coupon_id);
        $coupon_data = ArrayHelper::map($get_coupon_data, 'it_easy_id', 'it_easy_coupon_code');
        $get_paymentmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode($model->it_easy_payment_code);
        $get_shippingmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode($model->it_easy_shipping_code);
        if(!empty($model->it_easy_coupon_id)){
            $get_coupon_data = ItEasyOrder::getCoouponHistorybyOrderid($model->it_easy_order_id);
        }
        $order_status_history = ItEasyOrder::getOrderStatusHistorybyOrderId($model->it_easy_order_id);
        $order_disposition_history = ItEasyOrder::getOrderDispositionHistorybyOrderId($model->it_easy_order_id);
        $order_history = ItEasyOrder::getOrderHistorybyOrderId($model->it_easy_order_id);

        $stateList = ItEasyState::getStateallData();
        $statedata = ArrayHelper::map($stateList, 'it_easy_id', 'it_easy_state_name');
        $order_status_list = ItEasyOrder::getAHelperOrderStatusForAgentsw();    
        $order_statusdata = ArrayHelper::map($order_status_list, 'it_easy_order_status_id', 'it_easy_order_status_name');
        $disposition_status_list = ItEasyOrder::getAHelperDispositionStatusForAgent();
        $order_dispositiondata = ArrayHelper::map($disposition_status_list, 'it_easy_order_disposition_id', 'it_easy_order_disposition_name');
        $shippingmethod_list_data = ItEasyOrder::getAHelperShippingMethod();
        $shipping_method = ArrayHelper::map($shippingmethod_list_data, 'it_easy_method_code', 'it_easy_method_name' );
        $payemntmethod_list_data = ItEasyOrder::getAHelperPaymentMethod();
        $payment_method = ArrayHelper::map($payemntmethod_list_data, 'it_easy_method_code', 'it_easy_method_name' );
      
      	$order_dispatch_details = ItEasyOrderDispatch::findOne(['it_easy_order_id' => $model->it_easy_order_id]);
      
      	if(!empty($order_dispatch_details)){
          	$trackModel = ItEasyOrderTrack::find()->andWhere(['or', ['it_easy_awb_number' => $order_dispatch_details->it_easy_awb_number], ['it_easy_sec_awb_number' => $order_dispatch_details->it_easy_return_awb ] ])->orderBy(['it_easy_courier_time' => SORT_DESC])->all();
        }else{
         	$trackModel = []; 
          	$order_dispatch_details = [];
        }

        return $this->render('update', [
            'model' => $model,
            'product_model' => $product_model,
            'coupon_data' => $coupon_data,
            'statedata' => $statedata,
            'prod_model' => $prod_model,
            'get_paymentmethod' => $get_paymentmethod,
            'get_shippingmethod' => $get_shippingmethod,
            'get_coupon_data' => $get_coupon_data,
            'order_status_history' => $order_status_history,
            'order_history' => $order_history,
            'order_disposition_history' => $order_disposition_history,
            'statusmodel' => $statusmodel,
            'dispositionmodel' => $dispositionmodel,
            'commentmodel' => $commentmodel,
            'order_statusdata' => $order_statusdata,
            'order_dispositiondata' => $order_dispositiondata,
            'shipping_method' => $shipping_method,
            'payment_method' => $payment_method,
          	
          	'order_dispatch_details' => $order_dispatch_details,
          	'trackModel' => $trackModel,
        ]);
    }

    public function actionBuyvariation(){
        
        $post = Yii::$app->request->post();
        // echo "<pre>"; print_r($post); die;
        $productid = $post['product_id']; 
        $data = ItEasyProductVariation::find()->where(['it_easy_product_id' => $productid])->asArray()->all();
        $redata = '';
        $redata .= "<option value=''>Select</option>";
        foreach ($data as $key => $value) {
           $redata .= "<option value=".$value['it_easy_variation_id'].">".$value['it_easy_variation_name']."</option>";
        }
        echo $redata;
    }
  
  
  public function actionAssignAgentTl(){
        $url = Yii::$app->request->get()['url'];
        $tl = Yii::$app->request->get()['ItEasyOrderSearch']['it_easy_assigned_by'];
        $agent = Yii::$app->request->get()['ItEasyOrderSearch']['it_easy_assigned_to'];
        $order_id = Yii::$app->request->get()['selection'];
        $agent_name = User::findOne(['id' => $agent]);
        $check_array = [];
        foreach($order_id as $order){
            $order_id_check =  ItEasyOrder::find()->where(['it_easy_order_id' => $order])->andWhere(['it_easy_assigned_to' => '231'])->one();
            if(empty($order_id_check)){
                ItEasyOrder::addOrderStatusHistory($order,45,'Leads Assign to '.$agent_name->it_easy_username);
                $check_array[] = $order;
            }
        }
        if(Yii::$app->user->identity->it_easy_dept_id == '9'){
            ItEasyOrder::updateAll(['it_easy_retention_TLid' =>$tl,'it_easy_retention_AGENTid'=>$agent, 'it_easy_retention_assign_time' => date('Y-m-d H:i:s')], ['in','it_easy_order_id',$check_array]);
            Yii::$app->session->setFlash('success', "Record has been assigned successfuly");
        }else{
            ItEasyOrder::updateAll(['it_easy_assigned_by' =>$tl,'it_easy_assigned_to'=>$agent, 'it_easy_lead_assign' => date('Y-m-d H:i:s')], ['in','it_easy_order_id',$check_array]);
            
            Yii::$app->session->setFlash('success', "Record has been assigned successfuly.");
        }
        
        return $this->redirect($url);
    }

   public function actionConfirmDissapproved(){
        date_default_timezone_set("Asia/Kolkata");
        $create_date=date("Y-m-d H:i:s");
        $type = $_REQUEST['type'];
        $order_id = $_REQUEST['order_id'];
        if($type == 1){
        ItEasyOrder::updateAll(['it_easy_order_status_id' =>'1' , 'it_easy_confirmation_id' => Yii::$app->user->identity->it_easy_username,'it_easy_converted_time' => $create_date , 'it_easy_updated_time' => $create_date],['it_easy_order_id'=>$order_id]);
        ItEasyOrder::addOrderStatusHistory($order_id,1,'Confirm');
        
        return 'Order Verified Successfuly';
        }else{
        ItEasyOrder::updateAll(['it_easy_order_status_id' =>'7','it_easy_converted_time' => $create_date , 'it_easy_updated_time' => $create_date], ['it_easy_order_id'=>$order_id]);
        ItEasyOrder::addOrderStatusHistory($order_id,7,'disapproved');
        Yii::$app->session->setFlash('success', "Order Disapproved successfuly");
        return 'Order Disapproved Successfuly';
        }
       
    }


    public function actionVieworder(){
       
        
        ItEasyOrder::vieworderdata($_REQUEST['setid']);
       
    }

    public function actionAddorderhistory(){
        // addDispositionStatusHistory
        date_default_timezone_set("Asia/Kolkata");
        $create_date=date("Y-m-d H:i:s");
       $order_id = $_REQUEST['setid'];
       $statusid = $_REQUEST['statusid']; 
       $comment = $_REQUEST['comment']; 
       ItEasyOrder::addOrderStatusHistory($order_id,$statusid,$comment);
       $update_status = ItEasyOrder::find()->where(['it_easy_order_id' => $order_id])->One();
       $update_status->it_easy_order_status_id = $statusid;
       if($statusid == '1'){
           $update_status->it_easy_confirmation_id = Yii::$app->user->identity->username;
           $update_status->it_easy_converted_time = $create_date;
       }
       $update_status->it_easy_updated_time = $create_date;
       $update_status->save(false);
       $get_last_record = ItEasyOrderStatusHistory::find()->from(['ohs' => ItEasyOrderStatusHistory::tablename()])->select(['ohs.*','os.it_easy_order_status_name as statusname'])
        ->leftJoin(ItEasyOrderStatus::tablename().' as os', 'os.it_easy_order_status_id = ohs.it_easy_order_status_id')
       ->where(['it_easy_id' => ItEasyOrderStatusHistory::find()->max('it_easy_id')])->asArray()->one();
       
       return json_encode($get_last_record);
    }


     public function actionAdddispohistory(){
       
        date_default_timezone_set("Asia/Kolkata");
        $create_date=date("Y-m-d H:i:s");
       $order_id = $_REQUEST['setid'];
       $statusid = $_REQUEST['statusid']; 
       $comment = $_REQUEST['comment']; 

       ItEasyOrder::addDispositionStatusHistory($order_id,$statusid,$comment);
       $update_status = ItEasyOrder::find()->where(['it_easy_order_id' => $order_id])->One();
       $update_status->it_easy_order_disposition_id = $statusid;
       
       if($update_status->it_easy_order_disposition_id == '3'){
      	    $update_status->it_easy_order_place_time = date('Y-m-d H:i:s');
      	}
       $update_status->it_easy_updated_time = $create_date;
       $update_status->save(false);

       $get_last_record = ItEasyOrderDispositionHistory::find()->from(['odh' => ItEasyOrderDispositionHistory::tablename()])->select(['odh.*','od.it_easy_order_disposition_name as statusname'])
        ->leftJoin(ItEasyOrderDisposition::tablename().' as od', 'od.it_easy_order_disposition_id = odh.it_easy_order_disposition_id')
       ->where(['it_easy_id' => ItEasyOrderDispositionHistory::find()->max('it_easy_id')])->asArray()->one();
       
       return json_encode($get_last_record);
    }

    protected function findModel($it_easy_order_id)
    {
        if (($model = ItEasyOrder::findOne(['it_easy_order_id' => $it_easy_order_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


    protected function findProductModel($it_easy_order_id)
    {
        if (($model = ItEasyOrderProduct::findAll(['it_easy_order_id' => $it_easy_order_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
  
    public function actionCallback()
    {
        $searchModel=new ItEasyOrderSearch();
        $dataProvider=$searchModel->search3($this->request->queryParams);
        return $this->render('callback',[ 
        'searchModel' => $searchModel,
        'dataProvider' => $dataProvider,]);

    }
    public function actionCalldone($orderid){
        $model=ItEasyOrder::Calldones($orderid);
        Yii::$app->session->setFlash('success', 'Call Done is updated!!');
        return $this->redirect(['callback']);
        
    }
     public function actionPrintDuplicateorder(){
        ItEasyOrder::duplicateorderdata($_REQUEST['mobile']);
       
    }
    public function actionSearchOrder()
    {   

        $searchModel = new ItEasyOrderSearch();
        $model = new ItEasyOrder();
        $dataProvider = $searchModel->searchorder($this->request->queryParams);
        $payemntmethod_list_data = ItEasyOrder::getAHelperPaymentMethod();
        
        $order_status_list = ItEasyOrder::getAHelperOrderStatusForAgentsw();    
        $order_statusdata = ArrayHelper::map($order_status_list, 'it_easy_order_status_id', 'it_easy_order_status_name');
        
        $dataProvider->pagination->pageSize = 50;
        return $this->render('search-order', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'model'=>$model,
            'order_statusdata' => $order_statusdata
         
        ]);
    }
    
    public function actionAgentwiseExport()
    {   
  
        $searchModel = new ItEasyOrderSearch();
        $query = $searchModel->getAgentdata($this->request->queryParams);
        $agent = $query->asArray()->all();
        $array = []; 
        $r = 0;
        foreach ($agent as $key1 => $value1) {
            $agent_data = ItEasyOrderSearch::agentWiseexport($this->request->queryParams,$value1['id']);
            // echo "<pre>";print_r($agent_data);
            foreach ($agent_data as $key => $value) {
                    $array[$r]['agent'] = $value1['it_easy_username'];
                    $array[$r]['average_ticket_size'] = $value['average_ticket_size'];
                    $array[$r]['order_confirmation_percentage'] = $value['percentage'];
                    $array[$r]['order_number'] = $value['order_number'];
                    $array[$r]['order_amount'] = $value['order_sum'];
                    $array[$r]['order_placed'] = $value['order_placed_count'];
                    $array[$r]['order_placed_sum'] = $value['order_placed_sum'];
                    $array[$r]['callback'] = $value['callback_req_count'];
                    $array[$r]['callback_sum'] = $value['callback_req_sum'];
                    $array[$r]['not_connect'] = $value['not_connected_count'];
                    $array[$r]['not_connect_sum'] = $value['not_connected_sum'];
                    $array[$r]['not_interested'] = $value['not_intrested_count'];
                    $array[$r]['not_interested_sum'] = $value['not_intrested_sum'];
                    $array[$r]['duplicate'] = $value['duplicate_count'];
                    $array[$r]['duplicate_sum'] = $value['duplicate_sum'];
                    $array[$r]['fake'] = $value['fake_order_count'];
                    $array[$r]['fake_sum'] = $value['fake_order_sum'];
                    $array[$r]['NotService'] = $value['area_not_ser_count'];
                    $array[$r]['NotService_sum'] = $value['area_not_ser_sum'];
                    $array[$r]['call_disconnect'] = $value['call_disconnected_count'];
                    $array[$r]['call_disconnect_sum'] = $value['call_disconnected_sum'];
                    $array[$r]['promise_order'] = $value['promise_To_order_count'];
                    $array[$r]['promise_order_sum'] = $value['promise_To_order_sum'];
                    $array[$r]['medical'] = $value['medical_condition_count'];
                    $array[$r]['medical_sum'] = $value['medical_condition_sum'];
                    $array[$r]['language'] = $value['language_barrier'];
                    $array[$r]['language_sum'] = $value['language_barrier_sum'];
              

                $r++;
            }
         }
         // die;
        // echo "<pre>";print_r($array);die;
        $exporter = new Spreadsheet([
            'dataProvider' => new ArrayDataProvider([
                'allModels' => $array,
            ]),
            'columns' => [
                [   'attribute' => 'agent'],
                [   'attribute' => 'average_ticket_size'],
                [   'attribute' => 'order_confirmation_percentage'],
                [   'attribute' => 'order_number'],
                [   'attribute' => 'order_amount'],
                [   'attribute' => 'order_placed'],
                [   'attribute' => 'order_placed_sum'],
                [   'attribute' => 'callback'],
                [   'attribute' => 'callback_sum'],
                [   'attribute' => 'not_connect'],
                [   'attribute' => 'not_connect_sum'],
                [   'attribute' => 'not_interested'],
                [   'attribute' => 'not_interested_sum'],
                [   'attribute' => 'duplicate'],
                [   'attribute' => 'duplicate_sum'],
                [   'attribute' => 'fake'],
                [   'attribute' => 'fake_sum'],
                [   'attribute' => 'NotService'],
                [   'attribute' => 'NotService_sum'],
                [   'attribute' => 'call_disconnect'],
                [   'attribute' => 'call_disconnect_sum'],
                [   'attribute' => 'promise_order'],
                [   'attribute' => 'promise_order_sum'],
                [   'attribute' => 'medical'],
                [   'attribute' => 'medical_sum'],
                [   'attribute' => 'language'],
                [   'attribute' => 'language_sum'],
               
            ],
        ]);
        return $exporter->send('Order-Export.xlsx');
        
    }
    
     public function actionTest()
    {
       $orderId = 374694; // example order ID
       

// Load the order with its related product
$order = ItEasyOrder::find()->where(['it_easy_order_id' => $orderId])->with('orderproduct')->one();
echo "<pre>";
print_r($order);die;

if ($order && $order->orderproduct) {
    echo "Product Name: " . $order->orderproduct->it_easy_product_name;
} else {
    echo "No product found for this order.";
}
        echo "<pre>";
        print_r($order);die;
        
    }
    
    
    //status update function from panel order create
    
    public function actionSendOrderCreatedWebhook()
{
        

    $orderId = 404742;  // your static order ID
$order =ItEasyOrder::findOne($orderId);



    // Prepare customer name
    $customer_name = $order->it_easy_shipping_firstname . ' ' . $order->it_easy_lastname;

    // Load related products
    $order_products = \backend\models\ItEasyOrderProduct::find()
        ->where(['it_easy_order_id' => $order->it_easy_order_id])
        ->all();

    $order_summary = [];
    foreach ($order_products as $product) {
        $order_summary[] = $product->it_easy_product_name 
        . ' (' . $product->it_easy_variation_name . ')' // added variation
        . ' (Qty: ' . $product->it_easy_product_quantity . ')';
    }
 //$stage="order_created";
 $stage="order_verified";
 $order_summary=implode(', ', $order_summary);
 $order_id=$order->it_easy_order_id;
 $total_amount=$order->it_easy_total_price;
 $customer_phone = $order->it_easy_mobile_number; 
  
    // // Prepare payload
    // $payload = [
    //     'order_id' => $order->it_easy_order_id,
    //     'customer_name' => $customer_name,
    //     'total_amount' => $order->it_easy_total_price,
    //     'order_summary' => implode(', ', $order_summary),
    // ];
    // echo "<pre>";
    // print_R($order_summary);die;
    
     $result = webhookSender::sendOrderStageWebhook_test($stage,$customer_name, $order_id,$order_summary,$total_amount,$customer_phone,$order);
     if(isset($result['status'])){
     return $this->asJson([
            'status' => $result['status'],
            'response' => $result['response'],
            'message' => 'Test webhook sent using WebhookSender component.',
        ]);
     }else{
         echo "sooryy";
     }
    //return true;

    
}
//fucntion end




  private function sendOrderCreatedWebhook($order)
{

    // Prepare customer name
    $customer_name = $order->it_easy_shipping_firstname . ' ' . $order->it_easy_lastname;

    // Load related products
    $order_products = \backend\models\ItEasyOrderProduct::find()
        ->where(['it_easy_order_id' => $order->it_easy_order_id])
        ->all();

    $order_summary = [];
    foreach ($order_products as $product) {
        $order_summary[] = $product->it_easy_product_name . ' (Qty: ' . $product->it_easy_product_quantity . ')';
    }
 $stage="order_created";
 $order_summary=implode(', ', $order_summary);
 $order_id=$order->it_easy_order_id;
 $total_amount=$order->it_easy_total_price;
 $customer_phone = $order->it_easy_mobile_number; 
  
    // // Prepare payload
    // $payload = [
    //     'order_id' => $order->it_easy_order_id,
    //     'customer_name' => $customer_name,
    //     'total_amount' => $order->it_easy_total_price,
    //     'order_summary' => implode(', ', $order_summary),
    // ];
    
     $result = webhookSender::sendOrderStageWebhook($stage,$customer_name, $order_id,$order_summary,$total_amount,$customer_phone,$order);
     
     
   
    return true;

    
}//private function create


  
}//controller end
