<?php

namespace backend\controllers;

use Yii;
use backend\models\ApiCall;
use backend\models\ItEasyOrderSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use backend\models\ItEasyOrder;
use yii\helpers\ArrayHelper;
use yii\data\ArrayDataProvider;
use backend\models\ItEasyState;
use backend\models\ItEasyShippingApi;
use backend\models\ItEasyOrderDispatch;
use backend\models\ItEasyOrderProduct;
use backend\models\ItEasyProductVariation;
use backend\models\ItEasyXpressbeesPincodes;
use backend\models\ItEasyClickpostCourier;
use backend\models\CallAwbService1;
use backend\models\ItEasyFinancialYear;
use backend\models\ItEasyCustomer;
use backend\models\ItEasyStore;
use backend\models\ItEasyUser;
use backend\models\ItEasyCoupon;
use backend\models\ItEasyShippingPaymentMethod;
use yii2tech\spreadsheet\Spreadsheet;
use yii\web\UploadedFile;
use yii\db\Expression;
/**
 * UserTypeController implements the CRUD actions for ItEasyUserType model.
 */
class OrderDispatchController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyUserType models.
     *
     * @return string
     */
  
  
    public function actionAssign()
    {   
        $model = new ItEasyOrder();
        $searchModel = new ItEasyOrderSearch();
        $dataProvider = $searchModel->search2($this->request->queryParams);
      	$order_status_list_view = ItEasyOrder::getAHelperOrderStatusForAgentLogistic();
        $order_statusdata_view = ArrayHelper::map($order_status_list_view, 'it_easy_order_status_id', 'it_easy_order_status_name');
        
        $order_status_list = ItEasyOrder::getAHelperOrderStatusForAgent();
        $order_statusdata = ArrayHelper::map($order_status_list, 'it_easy_order_status_id', 'it_easy_order_status_name');
		$payemntmethod_list_data = ItEasyOrder::getAHelperPaymentMethod();
		$array_helper_courier = ItEasyOrder::ArrayHelperCourierData();
        $payment_method = ArrayHelper::map($payemntmethod_list_data, 'it_easy_method_code', 'it_easy_method_name' );
      	$dataProvider->pagination->pageSize = 50;
      	$stateList = ItEasyState::getStateallData();
        $statedata = ArrayHelper::map($stateList, 'it_easy_id', 'it_easy_state_name');
        return $this->render('assign', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'model'=>$model,
          	'order_statusdata' => $order_statusdata,
          	'order_statusdata_view' => $order_statusdata_view,
          	'payment_method' => $payment_method,
          	'array_helper_courier' => $array_helper_courier,
          	'statedata' => $statedata
        ]);
    }
  
  
  	public function actionManifest()
    {   
        $model = new ItEasyOrder();
        $searchModel = new ItEasyOrderSearch();
        $dataProvider = $searchModel->search2($this->request->queryParams);
        
        $order_counts = $searchModel->getordermanifest3($this->request->queryParams);
        // 
        $dataProvider->pagination->pageSize = 50;
      	
      	$array_helper_courier = ItEasyOrder::ArrayHelperCourierData();
        
        
        $order_status_list_view = ItEasyOrder::getAHelperOrderStatusForAgentLogistic();
        $order_statusdata_view = ArrayHelper::map($order_status_list_view, 'it_easy_order_status_id', 'it_easy_order_status_name');
        
        $order_status_list = ItEasyOrder::getAHelperOrderStatusForAgent();
        $order_statusdata = ArrayHelper::map($order_status_list, 'it_easy_order_status_id', 'it_easy_order_status_name');
        
        
		$payemntmethod_list_data = ItEasyOrder::getAHelperPaymentMethod();
        $payment_method = ArrayHelper::map($payemntmethod_list_data, 'it_easy_method_code', 'it_easy_method_name' );
      	$stateList = ItEasyState::getStateallData();
        $statedata = ArrayHelper::map($stateList, 'it_easy_id', 'it_easy_state_name');
        return $this->render('manifest', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'model'=>$model,
          	'order_statusdata' => $order_statusdata,
          	'order_statusdata_view' => $order_statusdata_view,
          	'payment_method' => $payment_method,
          	'array_helper_courier' => $array_helper_courier,
          	'statedata' => $statedata, 
          	'order_counts' => $order_counts
          	
        ]);
    }
    
    
    public function actionNonServiceable()
    {   
        $model = new ItEasyOrder();
        $searchModel = new ItEasyOrderSearch();
        $dataProvider = $searchModel->nonserviceablesearch($this->request->queryParams);
        
        $order_counts = $searchModel->getordermanifest3($this->request->queryParams);
        // 
        $dataProvider->pagination->pageSize = 100;
      	
      	$array_helper_courier = ItEasyOrder::ArrayHelperCourierData();
        
        
        $order_status_list_view = ItEasyOrder::getAHelperOrderStatusForAgentLogistic();
        $order_statusdata_view = ArrayHelper::map($order_status_list_view, 'it_easy_order_status_id', 'it_easy_order_status_name');
        
        $order_status_list = ItEasyOrder::getAHelperOrderStatusForAgent();
        $order_statusdata = ArrayHelper::map($order_status_list, 'it_easy_order_status_id', 'it_easy_order_status_name');
        
        
		$payemntmethod_list_data = ItEasyOrder::getAHelperPaymentMethod();
        $payment_method = ArrayHelper::map($payemntmethod_list_data, 'it_easy_method_code', 'it_easy_method_name' );
      	$stateList = ItEasyState::getStateallData();
        $statedata = ArrayHelper::map($stateList, 'it_easy_id', 'it_easy_state_name');
        return $this->render('non-serviceable', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'model'=>$model,
          	'order_statusdata' => $order_statusdata,
          	'order_statusdata_view' => $order_statusdata_view,
          	'payment_method' => $payment_method,
          	'array_helper_courier' => $array_helper_courier,
          	'statedata' => $statedata, 
          	'order_counts' => $order_counts
          	
        ]);
    }
    
    
    public function actionMarkNonserviceable(){
        set_time_limit(0);
  	    ini_set('max_execution_time', 0);
  	    ini_set("memory_limit", "-1");
        $model = new ItEasyOrder();
        if(!empty(Yii::$app->request->post()['selection'])){
            $order_seletion = Yii::$app->request->post()['selection'];
            Yii::$app->db->createCommand()
            ->update(ItEasyOrder::tableName(), 
                ['it_easy_order_status_id' => "17"], 
                ['it_easy_order_id' => $order_seletion]   
            )
            ->execute();
             foreach ($order_seletion as $value) {
                ItEasyOrder::addOrderStatusHistory($value, "17", 'Non-Serviceable mark after address verify');
             }
             
            Yii::$app->session->setFlash('success', 'Your Orders has been marked as Non-serviceable orders!!');
            Yii::$app->response->redirect(['order-dispatch/non-serviceable']);
        }
    }
  

	public function actionRefreshApi()
    {	$get = Yii::$app->request->get();
     	if(isset($get['order_id'])){
          	$get_order_data = ItEasyOrder::find()->where(['it_easy_order_id' => $get['order_id']])->all();
        }else{
          	$get_order_data = ItEasyOrder::find()->limit(5000)->orderBy(['it_easy_order_id' => SORT_DESC])->all();
        }
        // echo "<pre>"; print_r($get_order_data); die;
     	
     	if(!empty($get_order_data)){
          foreach($get_order_data as $key => $orders){
            	//$orders->it_easy_order_serviceable = ItEasyOrder::FindRecommandClickpost($orders->it_easy_order_id, $orders->it_easy_pincode, $orders->it_easy_payment_code);
            	$orders->it_easy_order_serviceable = ItEasyOrder::getServicealAPIbyPincode($orders->it_easy_pincode);
            // 	echo "<pre>"; print_r($orders); die;
            	$orders->save(false);
          }
        }
     	Yii::$app->session->setFlash('success', 'Your Serviceable api has been updated successfully.');
     	return $this->redirect(Yii::$app->request->referrer);
    }
    
    
    public function actionUploadAwb()
    {
        $model = new ItEasyOrder();

        if ($model->load(Yii::$app->request->post())) {
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');
            // echo "<pre>"; print_r(); die;
            $model->file = UploadedFile::getInstance($model, 'file');
            $post = Yii::$app->request->post();
        
            if ($model->file) {
                $get_value = [];
                $time = time();
                $model->file->saveAs('csv/' . $time . '.' . $model->file->extension);
                $model->file = 'csv/' . $time . '.' . $model->file->extension;
                $getdata = fopen($model->file, "r");
                $cnount = 0;
                while (($fileopen = fgetcsv($getdata, 1000, ",")) !== false) {
                    if ($cnount != 0) {
                        
                        // echo "<pre>"; print_r($fileopen); die;
                        $order_id= trim($fileopen[0]);
                        $order_id= str_replace("NH", "", $order_id);
                        $awb_number= trim($fileopen[1]);
                        $shipid= trim($fileopen[2]);
                        if(!empty($order_id)){
                        // echo $courier_id; die;
                            
                            $findAWB = ItEasyOrderDispatch::find()->where(['it_easy_order_id' =>  $order_id])->asArray()->one();
                            if(empty($findAWB)){
                                $findOrder = ItEasyOrder::find()->where(['it_easy_order_id' =>  $order_id])->asArray()->one();
                                // echo "<pre>"; print_r($findOrder); die;
                                if(!empty($findOrder)){
                                    $shiping_data =  ItEasyShippingApi::find()->asArray()->where(['it_easy_ship_id'=>$shipid])->One();
                                    
                                    $ApiCall = new ApiCall();
                                    $ApiCall->updateAwbResponce($findOrder['it_easy_order_id'],$findOrder['it_easy_customer_id'],$shipid,$awb_number,'manual update awb','success',$currentDateTime);
                                    
                                    $ApiCall->addOrderDispatch($findOrder,$shipid,$shiping_data, $awb_number);
                                    $dispatch_model = ItEasyOrderDispatch::find()->where(['it_easy_order_id' => $order_id])->one();
                                  	$dispatch_model->it_easy_order_status          = 'Order Manifested';
                                  	$dispatch_model->it_easy_label_generated          = '1';
                                  	$dispatch_model->it_easy_placed_time = date('Y-m-d H:i:s');
                                  	$dispatch_model->it_easy_status_updated_at  = date('Y-m-d H:i:s');
                                  	$dispatch_model->save(false);
                                    $order_Model = ItEasyOrder::findOne(['it_easy_order_id' => $findOrder['it_easy_order_id']]);
                                    $order_Model->it_easy_order_status_id = $post['ItEasyOrder']['it_easy_order_status_id'];
                                  	$order_Model->it_easy_updated_time = date('Y-m-d H:i:s');
                                  	$addOrderStatusHistory = ItEasyOrder::addOrderStatusHistory($order_id, $post['ItEasyOrder']['it_easy_order_status_id'], "upload by excel");
                                    $order_Model->save(false);
                                    $xb_value = array('order_id' => $findOrder['it_easy_order_id'], 'awb_number' => $awb_number ,'responce'=> 'success');
                                    
                                   
                                    $get_value[] = $xb_value;
                                }
                            }
                        }
                    }
                    $cnount++;
                }
                // die;
                $param = json_encode($get_value);
                Yii::$app->response->redirect(['order-dispatch/responce','params' => $param]);
            }
        } else {
            return $this->render('upload-awb', [
                'model' => $model,
            ]);
        }
    }
    
    
    public function actionUploadTransaction()
    {
        $model = new ItEasyOrder();

        if ($model->load(Yii::$app->request->post())) {
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');
            // echo "<pre>"; print_r(); die;
            $model->file = UploadedFile::getInstance($model, 'file');
            $post = Yii::$app->request->post();
        
            if ($model->file) {
                $get_value = [];
                $time = time();
                $model->file->saveAs('csv/' . $time . '.' . $model->file->extension);
                $model->file = 'csv/' . $time . '.' . $model->file->extension;
                $getdata = fopen($model->file, "r");
                $cnount = 0;
                while (($fileopen = fgetcsv($getdata, 1000, ",")) !== false) {
                    if ($cnount != 0) {
                        
                        
                        $awb_number= trim($fileopen[0]);
                        $transaction_id= trim($fileopen[1]);
                        if(!empty($awb_number)){
                        // echo $courier_id; die;
                            
                            $findAWB = ItEasyOrderDispatch::find()->where(['it_easy_awb_number' =>  $awb_number])->asArray()->one();
                            // echo "<pre>"; print_r($findAWB); die;
                            if(!empty($findAWB)){
                                // echo "<pre>"; print_r($findOrder); die;
                                $findOrder = ItEasyOrder::find()->where(['it_easy_order_status_id' =>  '3'])->andWhere(['it_easy_order_id' => $findAWB['it_easy_order_id']  ])->one();
                                if(!empty($findOrder)){
                                    
                                    $findOrder->it_easy_order_status_id = $post['ItEasyOrder']['it_easy_order_status_id'];
                                    $findOrder->it_easy_transaction_id = $transaction_id;
                                    $addOrderStatusHistory = ItEasyOrder::addOrderStatusHistory($findAWB['it_easy_order_id'], $post['ItEasyOrder']['it_easy_order_status_id'], "upload ".$transaction_id);
                                  	$findOrder->it_easy_updated_time = date('Y-m-d H:i:s');
                                    $findOrder->save(false);
                                    $xb_value = array('order_id' => $findOrder->it_easy_order_id, 'awb_number' => $awb_number ,'responce'=> 'success');
                                    
                                   
                                    $get_value[] = $xb_value;
                                }else{
                                    $xb_value = array('order_id' => $findOrder->it_easy_order_id, 'awb_number' => $awb_number ,'responce'=> 'check order status');
                                }
                            }else{
                                $xb_value = array('order_id' => $findOrder->it_easy_order_id, 'awb_number' => $awb_number ,'responce'=> 'AWB number not found.');
                            }
                        }
                    }
                    $cnount++;
                }
                // die;
                $param = json_encode($get_value);
                Yii::$app->response->redirect(['order-dispatch/responce','params' => $param]);
            }
        } else {
            return $this->render('upload-transaction', [
                'model' => $model,
            ]);
        }
    }
    
    
//     public function actionUploadSalesforcematch()
//     {
//         $model = new ItEasyOrder();

//         if ($model->load(Yii::$app->request->post())) {
//             date_default_timezone_set('Asia/kolkata');
//             $currentDateTime = date('Y-m-d H:i:s');
      
//             $model->file = UploadedFile::getInstance($model, 'file');
        
//             if ($model->file) {
//                 $get_value = [];
//                 $time = time();
//                 $model->file->saveAs('csv/' . $time . '.' . $model->file->extension);
//                 $model->file = 'csv/' . $time . '.' . $model->file->extension;
//                 $getdata = fopen($model->file, "r");
//                 $cnount = 0;
//                 $deleted_array = [];
                
//                 while (($fileopen = fgetcsv($getdata, 1000, ",")) !== false) {
//                     if ($cnount != 0) {
                        
//                         $s_order_id = str_replace('#','',$fileopen[1]);
//                         $s_order_id = str_replace('s','',$s_order_id);
//                         $findOrder = ItEasyOrder::find()->andWhere(['=', new Expression('SUBSTRING(it_easy_other_order_id , 2)'), $s_order_id])->one();
                        
                        
//                         if(!empty($findOrder)){
//                             if (!in_array($findOrder->it_easy_order_id, $deleted_array)){
//                                 $dks = ItEasyOrderProduct::deleteAll([ 'it_easy_order_id'=> $findOrder->it_easy_order_id]
//                                         );
//                                 $deleted_array[] =  $findOrder->it_easy_order_id;         
//                             }
//                             $order_status_array = ['2','3','4','5','6','9','10','14','15','16','22','23','26','27','28','29','30','31'];
//                             if(!in_array($findOrder->it_easy_order_status_id , $order_status_array)){
//                                 $findOrder->it_easy_firstname = $fileopen[3];
                                
//                                 $findOrder->it_easy_page_url = $fileopen[0];
//                                 $findOrder->it_easy_lastname = $fileopen[3];
//                                 $findOrder->it_easy_shipping_firstname = $fileopen[3];
//                                 $findOrder->it_easy_shipping_lastname = $fileopen[3];
//                                 $findOrder->it_easy_billing_firstname = $fileopen[3];
//                                 $findOrder->it_easy_billing_lastname = $fileopen[3];
//                                 $findOrder->it_easy_order_status_id = '24';
//                                 $findOrder->it_easy_total_price = $fileopen[6];
//                                 $findOrder->it_easy_billing_state = $fileopen[7];
//                                 $findOrder->it_easy_shipping_state = $fileopen[7];
//                                 $findOrder->it_easy_state  = $fileopen[7];
//                                 $state_id = ItEasyState::findOne(['it_easy_state_name' => $fileopen[7] ]);
//                                 if(!empty($state_id)){
//                                     $findOrder->it_easy_state_id = $state_id->it_easy_id;
//                                     $findOrder->it_easy_shipping_state_id = $state_id->it_easy_id;
//                                     $findOrder->it_easy_billing_state_id = $state_id->it_easy_id;
//                                 }
//                                 $findOrder->it_easy_pincode = $fileopen[8];
//                                 $findOrder->it_easy_shipping_pincode = $fileopen[8];
//                                 $findOrder->it_easy_billing_pincode = $fileopen[8];
//                                 $findOrder->it_easy_address_1 = $fileopen[9];
//                                 $findOrder->it_easy_address_2 = $fileopen[10];
//                                 $findOrder->it_easy_shipping_address_1 = $fileopen[9];
//                                 $findOrder->it_easy_shipping_address_2 = $fileopen[10];
//                                 $findOrder->it_easy_billing_address_1 = $fileopen[9];
//                                 $findOrder->it_easy_billing_address_2 = $fileopen[10];
//                                 $findOrder->it_easy_city = $fileopen[11];
//                                 $findOrder->it_easy_shipping_city = $fileopen[11];
//                                 $findOrder->it_easy_billing_city = $fileopen[11];
//                                 $findOrder->it_easy_mobile_number  = $fileopen[12];
//                                 $findOrder->it_easy_shipping_mobile_number = $fileopen[12];
//                                 $findOrder->it_easy_billing_mobile = $fileopen[12];
//                                 $findOrder->it_easy_payment_code  = $fileopen[19];
//                                 if($fileopen[19] == 'COD'){
//                                     $findOrder->it_easy_payment_method = "Cash on Delivery";
//                                 }else{
//                                     $findOrder->it_easy_payment_code  = 'Prepaid';
//                                     $findOrder->it_easy_payment_method = "Razor Pay/Payment Gateway";
//                                 }
//                                 $findOrder->it_easy_converted_time = date('Y-m-d H:i:s', strtotime($fileopen[20]));
//                                 $findOrder->it_easy_updated_time  = date('Y-m-d H:i:s');
//                                 $findOrder->save(false);
//                                 // echo "<pre>"; print_r($findOrder); die;
// $product_variation_id = ItEasyProductVariation::findOne(['shopify_veriant_id' => $fileopen[2]]);
// if(empty($product_variation_id)){
//     echo "<pre>"; print_r($fileopen);
//     echo "<pre>"; print_r($findOrder); die;
// }
//                             $productModel = new ItEasyOrderProduct();
//                             $productModel->it_easy_order_id  = $findOrder->it_easy_order_id;
//                             $productModel->it_easy_product_id  = $product_variation_id->it_easy_product_id;
//                             $productModel->it_easy_product_name  = $product_variation_id->it_easy_product_name;
//                             $productModel->it_easy_variation_id  = $product_variation_id->it_easy_variation_id;
//                             $productModel->it_easy_variation_name  = $product_variation_id->it_easy_variation_name;
//                             $productModel->it_easy_product_price  = $fileopen[16]/$fileopen[15];
//                             $productModel->it_easy_product_quantity  = $fileopen[15];
//                             $productModel->it_easy_product_sku  = $product_variation_id->it_easy_variation_name;
//                             $productModel->it_easy_product_total  = $fileopen[16];
//                             $productModel->it_easy_product_tax  = '0';
//                             $productModel->created_time  = date('Y-m-d H:i:s');
//                             $productModel->save(false);
//                             }          
//                         }
                        
//                     }
//                     $cnount++;
//                 }
//                 // die;
//                 Yii::$app->session->setFlash('success', 'Your data has been updated successfully.');
//                 Yii::$app->response->redirect(['order-dispatch/upload-salesforcematch']);
//             }
//         } else {
//             return $this->render('upload-salesforcematch', [
//                 'model' => $model,
//             ]);
//         }
//     }
    
    
    public function actionUploadSalesforcematch()
    {
        $model = new ItEasyOrder();

        if ($model->load(Yii::$app->request->post())) {
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');
      
            $model->file = UploadedFile::getInstance($model, 'file');
        
            if ($model->file) {
                $get_value = [];
                $time = time();
                $model->file->saveAs('csv/' . $time . '.' . $model->file->extension);
                $model->file = 'csv/' . $time . '.' . $model->file->extension;
                $getdata = fopen($model->file, "r");
                $cnount = 0;
                $deleted_array = [];
                
                while (($fileopen = fgetcsv($getdata, 1000, ",")) !== false) {
                    
                    if ($cnount != 0) {
                        
                        $s_order_id = $fileopen[29];
                        
                        $findAWB = ItEasyOrderDispatch::find()->andWhere(['it_easy_awb_number' =>  $fileopen[1]])->one();
                        if(empty($findAWB)){
                        
                        $findModel = ItEasyOrderDispatch::find()->andWhere(['it_easy_mobile' =>  $fileopen[9]])->one();
                        
                        
                        if(empty($findModel)){
                            
                            $model = ItEasyOrder::find()->where(['like', 'it_easy_mobile_number', '%'.$fileopen[9] . '%', false])->orderBy(['it_easy_created_time' => SORT_DESC ])->one();
                            
                            if(empty($model)){
    $model = new ItEasyOrder();  
    $ipaddress = ItEasyOrder::getIpaddress();
    $get_device = ItEasyOrder::getDevicename();
    $browser = ItEasyOrder::getBrowsername();                        
    $get_financial_year = ItEasyFinancialYear::getFinancialyear();
    $model->it_easy_financial_year = $get_financial_year;
    $model->it_easy_store_id = ItEasyStore::getStorename()->it_easy_id;
    $model->it_easy_store_name = ItEasyStore::getStorename()->it_easy_store_name;
    $model->it_easy_country = 'IN';
    $model->it_easy_shipping_country = 'IN';
    $model->it_easy_billing_country = 'IN';
    $model->it_easy_first_status = 'Retention';
    
    $model->it_easy_server_ip = $ipaddress;
    $model->it_easy_device = $get_device;
    $model->it_easy_browser = $browser;
    
    $model->it_easy_firstname = $fileopen[8];
  	$model->it_easy_shipping_firstname = $fileopen[8];
  	$model->it_easy_billing_firstname = $fileopen[8];
    $model->it_easy_lastname = $fileopen[8];
  	$model->it_easy_shipping_lastname = $fileopen[8];
  	$model->it_easy_billing_lastname = $fileopen[8];
  	$model->it_easy_address_1 = $fileopen[10];
  	$model->it_easy_shipping_address_1 = $fileopen[10];
  	$model->it_easy_billing_address_1 = $fileopen[10];
    $model->it_easy_address_2 = $fileopen[10];
  	$model->it_easy_shipping_address_2 = $fileopen[10];
  	$model->it_easy_billing_address_2 = $fileopen[10];
  	$model->it_easy_city = $fileopen[12];
    $model->it_easy_shipping_city = $fileopen[12];
    $model->it_easy_billing_city = $fileopen[12];
    $get_state_data = ItEasyState::getStatedatabyStateName($fileopen[13]);
    $model->it_easy_state_id = $get_state_data->it_easy_id ;
    $model->it_easy_shipping_state_id = $get_state_data->it_easy_id;
    $model->it_easy_billing_state_id = $get_state_data->it_easy_id;
    $payment_mode = $fileopen[19];
    $model->it_easy_pincode = $fileopen[11];
  	$recommand =  ItEasyOrder::FindRecommandClickpost($model->it_easy_order_id, $model->it_easy_pincode, $payment_mode);
    $model->it_easy_shipping_pincode = $fileopen[11];
    $model->it_easy_billing_pincode = $fileopen[11];
    $model->it_easy_billing_email = $fileopen[30];
  	$model->it_easy_shipping_email = $fileopen[30];
  	$model->it_easy_mobile_number  = $fileopen[9];
    $model->it_easy_shipping_mobile_number = $fileopen[9];
  	$model->it_easy_billing_mobile = $fileopen[9];
  	$model->it_easy_email = $fileopen[30];
    $get_paymentmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode($fileopen[19]);
    $get_shippingmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode('Free Shipping');
    $model->it_easy_state = $fileopen[13];
    $model->it_easy_shipping_state = $fileopen[13];
    $model->it_easy_billing_state = $fileopen[13];
    $model->it_easy_payment_method = $get_paymentmethod->it_easy_method_name;
    $model->it_easy_payment_code = $get_paymentmethod->it_easy_method_code;
    $model->it_easy_shipping_method = $get_shippingmethod->it_easy_method_name;
    $model->it_easy_shipping_code = $get_shippingmethod->it_easy_method_code;
    $model->it_easy_first_status = 'COD';

    
    $model->it_easy_read_status = '0';
    
    
    if($fileopen[34]  == 'Sales'){
        $model->it_easy_department_id = '4';
        
        $find_agent_name = ItEasyUser::findOne(['it_easy_username' => $fileopen[32]]);
        $find_tl_name = ItEasyUser::findOne(['it_easy_username' => $fileopen[33]]);
        if(empty($find_agent_name)){
            $model->it_easy_assigned_to = 0;
        }else{
           $model->it_easy_assigned_to = $find_agent_name->id; 
        }
        if(empty($find_tl_name)){
            $model->it_easy_assigned_by = 0;
        }else{
            $model->it_easy_assigned_by = $find_tl_name->id;
        }
        
        
        $model->it_easy_retention_TLid = '';
        $model->it_easy_retention_AGENTid = '';
    }else{
        
        $find_agent_name = ItEasyUser::findOne(['it_easy_username' => $fileopen[32]]);
        //echo "<pre>"; print_r($fileopen[32]); 
        //echo "<pre>"; print_r($find_agent_name); 
        $find_tl_name = ItEasyUser::findOne(['it_easy_username' => $fileopen[33]]);
        
        $model->it_easy_department_id = '9';
        $model->it_easy_assigned_by = '';
        $model->it_easy_assigned_to = '';
        
        if(empty($find_agent_name)){
            $model->it_easy_retention_AGENTid = 0;
        }else{
            $model->it_easy_retention_AGENTid = $find_tl_name->id;
        }
        
        if(empty($find_tl_name)){
            $model->it_easy_retention_TLid = 0;
        }else{
            $model->it_easy_retention_TLid = $find_tl_name->id;
        }
    }
    
    $model->it_easy_disease_name = '1';
    $model->created_by = Yii::$app->user->identity->id;
    if(!empty($fileopen[6])){
    
       $date_time_order = explode(" ",$fileopen[6]);
       $date_array = explode("-",$date_time_order[0]);
       $date_updated_excel = $date_array[2].'-'.$date_array[1].'-'.$date_array[1].' '.$date_time_order[1].':00';
    }else{
       $date_updated_excel = '';
    }
    
    if(!empty($fileopen[27])){
       $date_time_orderss = explode(" ",$fileopen[27]);
       $date_array_2 = explode("-",$date_time_orderss[0]);
       $date_updated_excel_convert = $date_array_2[2].'-'.$date_array_2[1].'-'.$date_array_2[1].' '.$date_time_orderss[1].':00';
    }else{
       $date_updated_excel_convert = '';
    }
    
    if(!empty($fileopen[24])){
       $date_time_orderdeli = explode(" ",$fileopen[24]);
       $date_array_deliv = explode("-",$date_time_orderdeli[0]);
       $date_updated_excel_delivered = $date_array_deliv[2].'-'.$date_array_deliv[1].'-'.$date_array_deliv[1].' '.$date_time_orderdeli[1].':00';
    }else{
       $date_updated_excel_delivered = '';
    }
    
    if(!empty($fileopen[3])){
       $date_time_placed = explode(" ",$fileopen[3]);
       $date_array_placed = explode("-",$date_time_placed[0]);
       $date_updated_excel_placed = $date_array_placed[2].'-'.$date_array_placed[1].'-'.$date_array_placed[1].' '.$date_time_placed[1].':00';
    }else{
       $date_updated_excel_placed = '';
    }
    if(!empty($fileopen[2])){
       $date_time_assign= explode(" ",$fileopen[2]);
       $date_array_assign= explode("-",$date_time_assign[0]);
       $date_updated_excel_assign = $date_array_assign[2].'-'.$date_array_assign[1].'-'.$date_array_assign[1].' '.$date_time_assign[1].':00';
    }else{
       $date_updated_excel_assign = '';
    }
    $model->it_easy_updated_time = $date_updated_excel;
    $model->it_easy_converted_time = $date_updated_excel_convert;
    $model->it_easy_placed_time  = $date_updated_excel_placed;
    $model->it_easy_assign_time  = $date_updated_excel_assign; 
    $model->it_easy_delivered_time = $date_updated_excel_delivered;
    $find_customer_data = ItEasyCustomer::FindCustomerbyMobile($fileopen[9]);
                            // echo "<pre>"; print_r($find_customer_data); die;
                            
    if($fileopen[4] == 'Awb Registered'){
        $model->it_easy_order_status_id = '2';
    }else if($fileopen[4] == 'Cancelled'){
        $model->it_easy_order_status_id = '8';
    }else if($fileopen[4] == 'Delivered'){
        $model->it_easy_order_status_id = '3';
    }else if($fileopen[4] == 'DestinationHubIn'){
        $model->it_easy_order_status_id = '27';
    }else if($fileopen[4] == 'FailedDelivery'){
        $model->it_easy_order_status_id = '9';
    }else if($fileopen[4] == 'InTransit'){
        $model->it_easy_order_status_id = '27';
    }else if($fileopen[4] == 'OrderPlaced'){
        $model->it_easy_order_status_id = '4';
    }else if($fileopen[4] == 'OriginCityIn'){
        $model->it_easy_order_status_id = '27';
    }else if($fileopen[4] == 'OriginCityOut'){
        $model->it_easy_order_status_id = '27';
    }else if($fileopen[4] == 'OutForDelivery'){
        $model->it_easy_order_status_id = '30';
    }else if($fileopen[4] == 'OutForPickup'){
        $model->it_easy_order_status_id = '4';
    }else if($fileopen[4] == 'PickedUp'){
        $model->it_easy_order_status_id = '29';
    }else if($fileopen[4] == 'PickupFailed'){
        $model->it_easy_order_status_id = '31';
    }else if($fileopen[4] == 'PickupPending'){
        $model->it_easy_order_status_id = '4';
    }else if($fileopen[4] == 'RTO-Delivered'){
        $model->it_easy_order_status_id = '47';
    }else if($fileopen[4] == 'RTO-InTransit'){
        $model->it_easy_order_status_id = '26';
    }else if($fileopen[4] == 'RTO-Marked'){
        $model->it_easy_order_status_id = '26';
    }else if($fileopen[4] == 'RTO-OutForDelivery'){
        $model->it_easy_order_status_id = '26';
    }else if($fileopen[4] == 'RTO-Requested'){
        $model->it_easy_order_status_id = '26';
    }else if($fileopen[4] == 'ShipmentDelayed'){
        $model->it_easy_order_status_id = '9';
    }                         
    $model->save(false);
    $recommand =  ItEasyOrder::FindRecommandClickpost($model->it_easy_order_id,$fileopen[11], $model->it_easy_payment_code);
                                      	
              	$model->it_easy_order_serviceable = $recommand;
    //echo "<pre>"; print_r($fileopen); die;
    
    if(empty($find_customer_data)){
        $find_customer_data = ItEasyCustomer::SavecustomerModelFromMobile($model, $model->it_easy_order_id);
        $model->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
    }else{

        $model->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
        
    }
    
    $order_status = $fileopen[4];
    $response2 = 'success';
    $smart_route_code = '';
    $shiping_data = ItEasyClickpostCourier::find()->where(['account_name' => $fileopen[28] ])->asArray()->one();
    $ApiCall = new ApiCall();
    $ApiCall->updateAwbResponce($model->it_easy_order_id, $model->it_easy_customer_id ,$shiping_data['cp_id'], $fileopen[1],'Clickpost Success',$response2,$date_updated_excel_assign);
    $ApiCall = new ApiCall();
    
    $ApiCall->addOrderDispatchclickpostcustom($model,$shiping_data['cp_id'],$shiping_data,$fileopen[1],$fileopen[0],$smart_route_code, $order_status);
    
    
    $addOrderStatusHistory = ItEasyOrder::addOrderStatusHistory($model->it_easy_order_id, $model->it_easy_order_status_id, 'Direct Upload Via Manural because of data crash');
    $addDispositionStatusHistory = ItEasyOrder::addDispositionStatusHistory($model->it_easy_order_id, '3', 'Direct Upload Via Manural because of data crash');
      
    
    $model->it_easy_total_price = $fileopen[21];
    $model->it_easy_gst_price = '0';
    $model->it_easy_product_quantity = $fileopen[15];
    $model->it_easy_order_number = 'NH'.$model->it_easy_order_id;
    $model->it_easy_invoice_number = $fileopen[17];
    
    
    
    $orderProductModel = new ItEasyOrderProduct();
    $orderProductModel->it_easy_order_id = $model->it_easy_order_id;
    $orderProductModel->it_easy_product_id = '755';
    $orderProductModel->it_easy_product_name = $fileopen[14];
    $orderProductModel->it_easy_product_sku = $fileopen[14];
    $orderProductModel->it_easy_variation_name = '15 Gram'; 
    $orderProductModel->it_easy_variation_id = '755';
    $orderProductModel->it_easy_product_quantity = $fileopen[15];
    $orderProductModel->it_easy_product_total =$fileopen[21];
    $orderProductModel->it_easy_product_price = $fileopen[21]/$fileopen[15];
    $orderProductModel->it_easy_product_tax = '0';
    $orderProductModel->created_time = $date_updated_excel;
    
    
    $orderProductModel->save();
    
    
    $model->save(false);
                            }
                            
    $get_financial_year = ItEasyFinancialYear::getFinancialyear();
    $model->it_easy_financial_year = $get_financial_year;
    $model->it_easy_store_id = ItEasyStore::getStorename()->it_easy_id;
    $model->it_easy_store_name = ItEasyStore::getStorename()->it_easy_store_name;
    
    $model->it_easy_firstname = $fileopen[8];
  	$model->it_easy_shipping_firstname = $fileopen[8];
  	$model->it_easy_billing_firstname = $fileopen[8];

  	$model->it_easy_address_1 = $fileopen[10];
  	$model->it_easy_shipping_address_1 = $fileopen[10];
  	$model->it_easy_billing_address_1 = $fileopen[10];
    $model->it_easy_address_2 = $fileopen[10];
  	$model->it_easy_shipping_address_2 = $fileopen[10];
  	$model->it_easy_billing_address_2 = $fileopen[10];
  	$model->it_easy_city = $fileopen[12];
    $model->it_easy_shipping_city = $fileopen[12];
    $model->it_easy_billing_city = $fileopen[12];
    $get_state_data = ItEasyState::getStatedatabyStateName($fileopen[13]);
    $model->it_easy_state_id = $get_state_data->it_easy_id ;
    $model->it_easy_shipping_state_id = $get_state_data->it_easy_id;
    $model->it_easy_billing_state_id = $get_state_data->it_easy_id;
    $payment_mode = $fileopen[19];
    $model->it_easy_pincode = $fileopen[11];
  	$recommand =  ItEasyOrder::FindRecommandClickpost($model->it_easy_order_id, $model->it_easy_pincode, $payment_mode);
    $model->it_easy_shipping_pincode = $fileopen[11];
    $model->it_easy_billing_pincode = $fileopen[11];
    $model->it_easy_billing_email = $fileopen[30];
  	$model->it_easy_shipping_email = $fileopen[30];
  	$model->it_easy_email = $fileopen[30];
    $get_paymentmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode($fileopen[19]);
    $get_shippingmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode('Free Shipping');
    $model->it_easy_state = $fileopen[13];
    $model->it_easy_shipping_state = $fileopen[13];
    $model->it_easy_billing_state = $fileopen[13];
    $model->it_easy_payment_method = $get_paymentmethod->it_easy_method_name;
    $model->it_easy_payment_code = $get_paymentmethod->it_easy_method_code;
    $model->it_easy_shipping_method = $get_shippingmethod->it_easy_method_name;
    $model->it_easy_shipping_code = $get_shippingmethod->it_easy_method_code;
    $model->it_easy_first_status = 'COD';

    
    $model->it_easy_read_status = '0';
    if($fileopen[34]  == 'Sales'){
        $model->it_easy_department_id = '4';
        
        $find_agent_name = ItEasyUser::findOne(['it_easy_username' => $fileopen[32]]);
        $find_tl_name = ItEasyUser::findOne(['it_easy_username' => $fileopen[33]]);
        if(empty($find_agent_name)){
            $model->it_easy_assigned_to = 0;
        }else{
           $model->it_easy_assigned_to = $find_agent_name->id; 
        }
        if(empty($find_tl_name)){
            $model->it_easy_assigned_by = 0;
        }else{
            $model->it_easy_assigned_by = $find_tl_name->id;
        }
        
        
        $model->it_easy_retention_TLid = '';
        $model->it_easy_retention_AGENTid = '';
    }else{
        
        $find_agent_name = ItEasyUser::findOne(['it_easy_username' => $fileopen[32]]);
        //echo "<pre>"; print_r($fileopen[32]); 
        //echo "<pre>"; print_r($find_agent_name); 
        $find_tl_name = ItEasyUser::findOne(['it_easy_username' => $fileopen[33]]);
        
        $model->it_easy_department_id = '9';
        $model->it_easy_assigned_by = '';
        $model->it_easy_assigned_to = '';
        
        if(empty($find_agent_name)){
            $model->it_easy_retention_AGENTid = 0;
        }else{
            $model->it_easy_retention_AGENTid = $find_tl_name->id;
        }
        
        if(empty($find_tl_name)){
            $model->it_easy_retention_TLid = 0;
        }else{
            $model->it_easy_retention_TLid = $find_tl_name->id;
        }
    }
    
    $model->it_easy_disease_name = '1';
    $model->created_by = Yii::$app->user->identity->id;
    if(!empty($fileopen[6])){
    
       $date_time_order = explode(" ",$fileopen[6]);
       $date_array = explode("-",$date_time_order[0]);
       $date_updated_excel = $date_array[2].'-'.$date_array[1].'-'.$date_array[1].' '.$date_time_order[1].':00';
    }else{
       $date_updated_excel = '';
    }
    
    if(!empty($fileopen[27])){
       $date_time_orderss = explode(" ",$fileopen[27]);
       $date_array_2 = explode("-",$date_time_orderss[0]);
       $date_updated_excel_convert = $date_array_2[2].'-'.$date_array_2[1].'-'.$date_array_2[1].' '.$date_time_orderss[1].':00';
    }else{
       $date_updated_excel_convert = '';
    }
    
    if(!empty($fileopen[24])){
       $date_time_orderdeli = explode(" ",$fileopen[24]);
       $date_array_deliv = explode("-",$date_time_orderdeli[0]);
       $date_updated_excel_delivered = $date_array_deliv[2].'-'.$date_array_deliv[1].'-'.$date_array_deliv[1].' '.$date_time_orderdeli[1].':00';
    }else{
       $date_updated_excel_delivered = '';
    }
    
    if(!empty($fileopen[3])){
       $date_time_placed = explode(" ",$fileopen[3]);
       $date_array_placed = explode("-",$date_time_placed[0]);
       $date_updated_excel_placed = $date_array_placed[2].'-'.$date_array_placed[1].'-'.$date_array_placed[1].' '.$date_time_placed[1].':00';
    }else{
       $date_updated_excel_placed = '';
    }
    if(!empty($fileopen[2])){
       $date_time_assign= explode(" ",$fileopen[2]);
       $date_array_assign= explode("-",$date_time_assign[0]);
       $date_updated_excel_assign = $date_array_assign[2].'-'.$date_array_assign[1].'-'.$date_array_assign[1].' '.$date_time_assign[1].':00';
    }else{
       $date_updated_excel_assign = '';
    }
    $model->it_easy_updated_time = $date_updated_excel;
    $model->it_easy_converted_time = $date_updated_excel_convert;
    $model->it_easy_placed_time  = $date_updated_excel_placed;
    $model->it_easy_assign_time  = $date_updated_excel_assign; 
    $model->it_easy_delivered_time = $date_updated_excel_delivered;
    $find_customer_data = ItEasyCustomer::FindCustomerbyMobile($fileopen[9]);
                            // echo "<pre>"; print_r($find_customer_data); die;
                            
    if($fileopen[4] == 'Awb Registered'){
        $model->it_easy_order_status_id = '2';
    }else if($fileopen[4] == 'Cancelled'){
        $model->it_easy_order_status_id = '8';
    }else if($fileopen[4] == 'Delivered'){
        $model->it_easy_order_status_id = '3';
    }else if($fileopen[4] == 'DestinationHubIn'){
        $model->it_easy_order_status_id = '27';
    }else if($fileopen[4] == 'FailedDelivery'){
        $model->it_easy_order_status_id = '9';
    }else if($fileopen[4] == 'InTransit'){
        $model->it_easy_order_status_id = '27';
    }else if($fileopen[4] == 'OrderPlaced'){
        $model->it_easy_order_status_id = '4';
    }else if($fileopen[4] == 'OriginCityIn'){
        $model->it_easy_order_status_id = '27';
    }else if($fileopen[4] == 'OriginCityOut'){
        $model->it_easy_order_status_id = '27';
    }else if($fileopen[4] == 'OutForDelivery'){
        $model->it_easy_order_status_id = '30';
    }else if($fileopen[4] == 'OutForPickup'){
        $model->it_easy_order_status_id = '4';
    }else if($fileopen[4] == 'PickedUp'){
        $model->it_easy_order_status_id = '29';
    }else if($fileopen[4] == 'PickupFailed'){
        $model->it_easy_order_status_id = '31';
    }else if($fileopen[4] == 'PickupPending'){
        $model->it_easy_order_status_id = '4';
    }else if($fileopen[4] == 'RTO-Delivered'){
        $model->it_easy_order_status_id = '47';
    }else if($fileopen[4] == 'RTO-InTransit'){
        $model->it_easy_order_status_id = '26';
    }else if($fileopen[4] == 'RTO-Marked'){
        $model->it_easy_order_status_id = '26';
    }else if($fileopen[4] == 'RTO-OutForDelivery'){
        $model->it_easy_order_status_id = '26';
    }else if($fileopen[4] == 'RTO-Requested'){
        $model->it_easy_order_status_id = '26';
    }else if($fileopen[4] == 'ShipmentDelayed'){
        $model->it_easy_order_status_id = '9';
    }                         
    $model->save(false);
    
    //echo "<pre>"; print_r($fileopen); die;
    
    if(empty($find_customer_data)){
        $find_customer_data = ItEasyCustomer::SavecustomerModelFromMobile($model, $model->it_easy_order_id);
        $model->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
    }else{

        $model->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
        
    }
    
    $order_status = $fileopen[4];
    $response2 = 'success';
    $smart_route_code = '';
    $shiping_data = ItEasyClickpostCourier::find()->where(['account_name' => $fileopen[28] ])->asArray()->one();
    $ApiCall = new ApiCall();
    $ApiCall->updateAwbResponce($model->it_easy_order_id, $model->it_easy_customer_id ,$shiping_data['cp_id'], $fileopen[1],'Clickpost Success',$response2,$date_updated_excel_assign);
    $ApiCall = new ApiCall();
    
    $ApiCall->addOrderDispatchclickpostcustom($model,$shiping_data['cp_id'],$shiping_data,$fileopen[1],$fileopen[0],$smart_route_code, $order_status);
    
    
    $addOrderStatusHistory = ItEasyOrder::addOrderStatusHistory($model->it_easy_order_id, $model->it_easy_order_status_id, 'Direct Upload Via Manural because of data crash');
    $addDispositionStatusHistory = ItEasyOrder::addDispositionStatusHistory($model->it_easy_order_id, '3', 'Direct Upload Via Manural because of data crash');
      
    
    $model->it_easy_total_price = $fileopen[21];
    $model->it_easy_gst_price = '0';
    $model->it_easy_product_quantity = $fileopen[15];
    $model->it_easy_order_number = 'NH'.$model->it_easy_order_id;
    $model->save(false);  
                            
                            
                     
                            
                        }else{
                            if($fileopen[34] == 'Retention'){
            $model = ItEasyOrder::find()->andWhere(['it_easy_mobile_number' =>  $fileopen[9]])->andWhere(['>', 'it_easy_created_time', '2024-05-13 10:00:00'])->orderBy(['it_easy_created_time' => SORT_DESC ])->one();  
            
            if(empty($model)){
                
              $model = new ItEasyOrder();  
    $ipaddress = ItEasyOrder::getIpaddress();
    $get_device = ItEasyOrder::getDevicename();
    $browser = ItEasyOrder::getBrowsername();                        
    $get_financial_year = ItEasyFinancialYear::getFinancialyear();
    $model->it_easy_financial_year = $get_financial_year;
    $model->it_easy_store_id = ItEasyStore::getStorename()->it_easy_id;
    $model->it_easy_store_name = ItEasyStore::getStorename()->it_easy_store_name;
    $model->it_easy_country = 'IN';
    $model->it_easy_shipping_country = 'IN';
    $model->it_easy_billing_country = 'IN';
    $model->it_easy_first_status = 'Retention';
    
    $model->it_easy_server_ip = $ipaddress;
    $model->it_easy_device = $get_device;
    $model->it_easy_browser = $browser;
    
    $model->it_easy_firstname = $fileopen[8];
  	$model->it_easy_shipping_firstname = $fileopen[8];
  	$model->it_easy_billing_firstname = $fileopen[8];
    $model->it_easy_lastname = $fileopen[8];
  	$model->it_easy_shipping_lastname = $fileopen[8];
  	$model->it_easy_billing_lastname = $fileopen[8];
  	$model->it_easy_address_1 = $fileopen[10];
  	$model->it_easy_shipping_address_1 = $fileopen[10];
  	$model->it_easy_billing_address_1 = $fileopen[10];
    $model->it_easy_address_2 = $fileopen[10];
  	$model->it_easy_shipping_address_2 = $fileopen[10];
  	$model->it_easy_billing_address_2 = $fileopen[10];
  	$model->it_easy_city = $fileopen[12];
    $model->it_easy_shipping_city = $fileopen[12];
    $model->it_easy_billing_city = $fileopen[12];
    $get_state_data = ItEasyState::getStatedatabyStateName($fileopen[13]);
    $model->it_easy_state_id = $get_state_data->it_easy_id ;
    $model->it_easy_shipping_state_id = $get_state_data->it_easy_id;
    $model->it_easy_billing_state_id = $get_state_data->it_easy_id;
    $payment_mode = $fileopen[19];
    $model->it_easy_pincode = $fileopen[11];
  	$recommand =  ItEasyOrder::FindRecommandClickpost($model->it_easy_order_id, $model->it_easy_pincode, $payment_mode);
    $model->it_easy_shipping_pincode = $fileopen[11];
    $model->it_easy_billing_pincode = $fileopen[11];
    $model->it_easy_billing_email = $fileopen[30];
  	$model->it_easy_shipping_email = $fileopen[30];
  	$model->it_easy_mobile_number  = $fileopen[9];
    $model->it_easy_shipping_mobile_number = $fileopen[9];
  	$model->it_easy_billing_mobile = $fileopen[9];
  	$model->it_easy_email = $fileopen[30];
    $get_paymentmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode($fileopen[19]);
    $get_shippingmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode('Free Shipping');
    $model->it_easy_state = $fileopen[13];
    $model->it_easy_shipping_state = $fileopen[13];
    $model->it_easy_billing_state = $fileopen[13];
    $model->it_easy_payment_method = $get_paymentmethod->it_easy_method_name;
    $model->it_easy_payment_code = $get_paymentmethod->it_easy_method_code;
    $model->it_easy_shipping_method = $get_shippingmethod->it_easy_method_name;
    $model->it_easy_shipping_code = $get_shippingmethod->it_easy_method_code;
    $model->it_easy_first_status = 'COD';

    
    $model->it_easy_read_status = '0';
    if($fileopen[34]  == 'Sales'){
        $model->it_easy_department_id = '4';
        
        $find_agent_name = ItEasyUser::findOne(['it_easy_username' => $fileopen[32]]);
        $find_tl_name = ItEasyUser::findOne(['it_easy_username' => $fileopen[33]]);
        if(empty($find_agent_name)){
            $model->it_easy_assigned_to = 0;
        }else{
           $model->it_easy_assigned_to = $find_agent_name->id; 
        }
        if(empty($find_tl_name)){
            $model->it_easy_assigned_by = 0;
        }else{
            $model->it_easy_assigned_by = $find_tl_name->id;
        }
        
        
        $model->it_easy_retention_TLid = '';
        $model->it_easy_retention_AGENTid = '';
    }else{
        
        $find_agent_name = ItEasyUser::findOne(['it_easy_username' => $fileopen[32]]);
        //echo "<pre>"; print_r($fileopen[32]); 
        //echo "<pre>"; print_r($find_agent_name); 
        $find_tl_name = ItEasyUser::findOne(['it_easy_username' => $fileopen[33]]);
        
        $model->it_easy_department_id = '9';
        $model->it_easy_assigned_by = '';
        $model->it_easy_assigned_to = '';
        
        if(empty($find_agent_name)){
            $model->it_easy_retention_AGENTid = 0;
        }else{
            $model->it_easy_retention_AGENTid = $find_tl_name->id;
        }
        
        if(empty($find_tl_name)){
            $model->it_easy_retention_TLid = 0;
        }else{
            $model->it_easy_retention_TLid = $find_tl_name->id;
        }
    }
    
    $model->it_easy_disease_name = '1';
    $model->created_by = Yii::$app->user->identity->id;
    if(!empty($fileopen[6])){
    
       $date_time_order = explode(" ",$fileopen[6]);
       $date_array = explode("-",$date_time_order[0]);
       $date_updated_excel = $date_array[2].'-'.$date_array[1].'-'.$date_array[1].' '.$date_time_order[1].':00';
    }else{
       $date_updated_excel = '';
    }
    
    if(!empty($fileopen[27])){
       $date_time_orderss = explode(" ",$fileopen[27]);
       $date_array_2 = explode("-",$date_time_orderss[0]);
       $date_updated_excel_convert = $date_array_2[2].'-'.$date_array_2[1].'-'.$date_array_2[1].' '.$date_time_orderss[1].':00';
    }else{
       $date_updated_excel_convert = '';
    }
    
    if(!empty($fileopen[24])){
       $date_time_orderdeli = explode(" ",$fileopen[24]);
       $date_array_deliv = explode("-",$date_time_orderdeli[0]);
       $date_updated_excel_delivered = $date_array_deliv[2].'-'.$date_array_deliv[1].'-'.$date_array_deliv[1].' '.$date_time_orderdeli[1].':00';
    }else{
       $date_updated_excel_delivered = '';
    }
    
    if(!empty($fileopen[3])){
       $date_time_placed = explode(" ",$fileopen[3]);
       $date_array_placed = explode("-",$date_time_placed[0]);
       $date_updated_excel_placed = $date_array_placed[2].'-'.$date_array_placed[1].'-'.$date_array_placed[1].' '.$date_time_placed[1].':00';
    }else{
       $date_updated_excel_placed = '';
    }
    if(!empty($fileopen[2])){
       $date_time_assign= explode(" ",$fileopen[2]);
       $date_array_assign= explode("-",$date_time_assign[0]);
       $date_updated_excel_assign = $date_array_assign[2].'-'.$date_array_assign[1].'-'.$date_array_assign[1].' '.$date_time_assign[1].':00';
    }else{
       $date_updated_excel_assign = '';
    }
    $model->it_easy_updated_time = $date_updated_excel;
    $model->it_easy_converted_time = $date_updated_excel_convert;
    $model->it_easy_placed_time  = $date_updated_excel_placed;
    $model->it_easy_assign_time  = $date_updated_excel_assign; 
    $model->it_easy_delivered_time = $date_updated_excel_delivered;
    $find_customer_data = ItEasyCustomer::FindCustomerbyMobile($fileopen[9]);
                            // echo "<pre>"; print_r($find_customer_data); die;
                            
    if($fileopen[4] == 'Awb Registered'){
        $model->it_easy_order_status_id = '2';
    }else if($fileopen[4] == 'Cancelled'){
        $model->it_easy_order_status_id = '8';
    }else if($fileopen[4] == 'Delivered'){
        $model->it_easy_order_status_id = '3';
    }else if($fileopen[4] == 'DestinationHubIn'){
        $model->it_easy_order_status_id = '27';
    }else if($fileopen[4] == 'FailedDelivery'){
        $model->it_easy_order_status_id = '9';
    }else if($fileopen[4] == 'InTransit'){
        $model->it_easy_order_status_id = '27';
    }else if($fileopen[4] == 'OrderPlaced'){
        $model->it_easy_order_status_id = '4';
    }else if($fileopen[4] == 'OriginCityIn'){
        $model->it_easy_order_status_id = '27';
    }else if($fileopen[4] == 'OriginCityOut'){
        $model->it_easy_order_status_id = '27';
    }else if($fileopen[4] == 'OutForDelivery'){
        $model->it_easy_order_status_id = '30';
    }else if($fileopen[4] == 'OutForPickup'){
        $model->it_easy_order_status_id = '4';
    }else if($fileopen[4] == 'PickedUp'){
        $model->it_easy_order_status_id = '29';
    }else if($fileopen[4] == 'PickupFailed'){
        $model->it_easy_order_status_id = '31';
    }else if($fileopen[4] == 'PickupPending'){
        $model->it_easy_order_status_id = '4';
    }else if($fileopen[4] == 'RTO-Delivered'){
        $model->it_easy_order_status_id = '47';
    }else if($fileopen[4] == 'RTO-InTransit'){
        $model->it_easy_order_status_id = '26';
    }else if($fileopen[4] == 'RTO-Marked'){
        $model->it_easy_order_status_id = '26';
    }else if($fileopen[4] == 'RTO-OutForDelivery'){
        $model->it_easy_order_status_id = '26';
    }else if($fileopen[4] == 'RTO-Requested'){
        $model->it_easy_order_status_id = '26';
    }else if($fileopen[4] == 'ShipmentDelayed'){
        $model->it_easy_order_status_id = '9';
    }                         
    $model->save(false);
    $recommand =  ItEasyOrder::FindRecommandClickpost($model->it_easy_order_id,$fileopen[11], $model->it_easy_payment_code);
                                      	
              	$model->it_easy_order_serviceable = $recommand;
    //echo "<pre>"; print_r($fileopen); die;
    
    if(empty($find_customer_data)){
        $find_customer_data = ItEasyCustomer::SavecustomerModelFromMobile($model, $model->it_easy_order_id);
        $model->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
    }else{

        $model->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
        
    }
    
    $order_status = $fileopen[4];
    $response2 = 'success';
    $smart_route_code = '';
    $shiping_data = ItEasyClickpostCourier::find()->where(['account_name' => $fileopen[28] ])->asArray()->one();
    $ApiCall = new ApiCall();
    $ApiCall->updateAwbResponce($model->it_easy_order_id, $model->it_easy_customer_id ,$shiping_data['cp_id'], $fileopen[1],'Clickpost Success',$response2,$date_updated_excel_assign);
    $ApiCall = new ApiCall();
    
    $ApiCall->addOrderDispatchclickpostcustom($model,$shiping_data['cp_id'],$shiping_data,$fileopen[1],$fileopen[0],$smart_route_code, $order_status);
    
    
    $addOrderStatusHistory = ItEasyOrder::addOrderStatusHistory($model->it_easy_order_id, $model->it_easy_order_status_id, 'Direct Upload Via Manural because of data crash');
    $addDispositionStatusHistory = ItEasyOrder::addDispositionStatusHistory($model->it_easy_order_id, '3', 'Direct Upload Via Manural because of data crash');
      
    
    $model->it_easy_total_price = $fileopen[21];
    $model->it_easy_gst_price = '0';
    $model->it_easy_product_quantity = $fileopen[15];
    $model->it_easy_order_number = 'NH'.$model->it_easy_order_id;
    $model->it_easy_invoice_number = $fileopen[17];
    
    
    
    $orderProductModel = new ItEasyOrderProduct();
    $orderProductModel->it_easy_order_id = $model->it_easy_order_id;
    $orderProductModel->it_easy_product_id = '755';
    $orderProductModel->it_easy_product_name = $fileopen[14];
    $orderProductModel->it_easy_product_sku = $fileopen[14];
    $orderProductModel->it_easy_variation_name = '15 Gram'; 
    $orderProductModel->it_easy_variation_id = '755';
    $orderProductModel->it_easy_product_quantity = $fileopen[15];
    $orderProductModel->it_easy_product_total =$fileopen[21];
    $orderProductModel->it_easy_product_price = $fileopen[21]/$fileopen[15];
    $orderProductModel->it_easy_product_tax = '0';
    $orderProductModel->created_time = $date_updated_excel;
    
    
    $orderProductModel->save();
    
    
    $model->save(false);
                
                
                
            }else{
                
                $model = ItEasyOrder::find()->andWhere(['it_easy_mobile_number' =>  $fileopen[9]])->orderBy(['it_easy_created_time' => SORT_DESC ])->one();
                            
    $get_financial_year = ItEasyFinancialYear::getFinancialyear();
    $model->it_easy_financial_year = $get_financial_year;
    $model->it_easy_store_id = ItEasyStore::getStorename()->it_easy_id;
    $model->it_easy_store_name = ItEasyStore::getStorename()->it_easy_store_name;
    
    $model->it_easy_firstname = $fileopen[8];
  	$model->it_easy_shipping_firstname = $fileopen[8];
  	$model->it_easy_billing_firstname = $fileopen[8];

  	$model->it_easy_address_1 = $fileopen[10];
  	$model->it_easy_shipping_address_1 = $fileopen[10];
  	$model->it_easy_billing_address_1 = $fileopen[10];
    $model->it_easy_address_2 = $fileopen[10];
  	$model->it_easy_shipping_address_2 = $fileopen[10];
  	$model->it_easy_billing_address_2 = $fileopen[10];
  	$model->it_easy_city = $fileopen[12];
    $model->it_easy_shipping_city = $fileopen[12];
    $model->it_easy_billing_city = $fileopen[12];
    $get_state_data = ItEasyState::getStatedatabyStateName($fileopen[13]);
    $model->it_easy_state_id = $get_state_data->it_easy_id ;
    $model->it_easy_shipping_state_id = $get_state_data->it_easy_id;
    $model->it_easy_billing_state_id = $get_state_data->it_easy_id;
    $payment_mode = $fileopen[19];
    $model->it_easy_pincode = $fileopen[11];
  	$recommand =  ItEasyOrder::FindRecommandClickpost($model->it_easy_order_id, $model->it_easy_pincode, $payment_mode);
    $model->it_easy_shipping_pincode = $fileopen[11];
    $model->it_easy_billing_pincode = $fileopen[11];
    $model->it_easy_billing_email = $fileopen[30];
  	$model->it_easy_shipping_email = $fileopen[30];
  	$model->it_easy_email = $fileopen[30];
    $get_paymentmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode($fileopen[19]);
    $get_shippingmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode('Free Shipping');
    $model->it_easy_state = $fileopen[13];
    $model->it_easy_shipping_state = $fileopen[13];
    $model->it_easy_billing_state = $fileopen[13];
    $model->it_easy_payment_method = $get_paymentmethod->it_easy_method_name;
    $model->it_easy_payment_code = $get_paymentmethod->it_easy_method_code;
    $model->it_easy_shipping_method = $get_shippingmethod->it_easy_method_name;
    $model->it_easy_shipping_code = $get_shippingmethod->it_easy_method_code;
    $model->it_easy_first_status = 'COD';

    
    $model->it_easy_read_status = '0';
    if($fileopen[34]  == 'Sales'){
        $model->it_easy_department_id = '4';
        
        $find_agent_name = ItEasyUser::findOne(['it_easy_username' => $fileopen[32]]);
        $find_tl_name = ItEasyUser::findOne(['it_easy_username' => $fileopen[33]]);
        if(empty($find_agent_name)){
            $model->it_easy_assigned_to = 0;
        }else{
           $model->it_easy_assigned_to = $find_agent_name->id; 
        }
        if(empty($find_tl_name)){
            $model->it_easy_assigned_by = 0;
        }else{
            $model->it_easy_assigned_by = $find_tl_name->id;
        }
        
        
        $model->it_easy_retention_TLid = '';
        $model->it_easy_retention_AGENTid = '';
    }else{
        
        $find_agent_name = ItEasyUser::findOne(['it_easy_username' => $fileopen[32]]);
        //echo "<pre>"; print_r($fileopen[32]); 
        //echo "<pre>"; print_r($find_agent_name); 
        $find_tl_name = ItEasyUser::findOne(['it_easy_username' => $fileopen[33]]);
        
        $model->it_easy_department_id = '9';
        $model->it_easy_assigned_by = '';
        $model->it_easy_assigned_to = '';
        
        if(empty($find_agent_name)){
            $model->it_easy_retention_AGENTid = 0;
        }else{
            $model->it_easy_retention_AGENTid = $find_tl_name->id;
        }
        
        if(empty($find_tl_name)){
            $model->it_easy_retention_TLid = 0;
        }else{
            $model->it_easy_retention_TLid = $find_tl_name->id;
        }
    }
    
    $model->it_easy_disease_name = '1';
    $model->created_by = Yii::$app->user->identity->id;
    if(!empty($fileopen[6])){
    
       $date_time_order = explode(" ",$fileopen[6]);
       $date_array = explode("-",$date_time_order[0]);
       $date_updated_excel = $date_array[2].'-'.$date_array[1].'-'.$date_array[1].' '.$date_time_order[1].':00';
    }else{
       $date_updated_excel = '';
    }
    
    if(!empty($fileopen[27])){
       $date_time_orderss = explode(" ",$fileopen[27]);
       $date_array_2 = explode("-",$date_time_orderss[0]);
       $date_updated_excel_convert = $date_array_2[2].'-'.$date_array_2[1].'-'.$date_array_2[1].' '.$date_time_orderss[1].':00';
    }else{
       $date_updated_excel_convert = '';
    }
    
    if(!empty($fileopen[24])){
       $date_time_orderdeli = explode(" ",$fileopen[24]);
       $date_array_deliv = explode("-",$date_time_orderdeli[0]);
       $date_updated_excel_delivered = $date_array_deliv[2].'-'.$date_array_deliv[1].'-'.$date_array_deliv[1].' '.$date_time_orderdeli[1].':00';
    }else{
       $date_updated_excel_delivered = '';
    }
    
    if(!empty($fileopen[3])){
       $date_time_placed = explode(" ",$fileopen[3]);
       $date_array_placed = explode("-",$date_time_placed[0]);
       $date_updated_excel_placed = $date_array_placed[2].'-'.$date_array_placed[1].'-'.$date_array_placed[1].' '.$date_time_placed[1].':00';
    }else{
       $date_updated_excel_placed = '';
    }
    if(!empty($fileopen[2])){
       $date_time_assign= explode(" ",$fileopen[2]);
       $date_array_assign= explode("-",$date_time_assign[0]);
       $date_updated_excel_assign = $date_array_assign[2].'-'.$date_array_assign[1].'-'.$date_array_assign[1].' '.$date_time_assign[1].':00';
    }else{
       $date_updated_excel_assign = '';
    }
    $model->it_easy_updated_time = $date_updated_excel;
    $model->it_easy_converted_time = $date_updated_excel_convert;
    $model->it_easy_placed_time  = $date_updated_excel_placed;
    $model->it_easy_assign_time  = $date_updated_excel_assign; 
    $model->it_easy_delivered_time = $date_updated_excel_delivered;
    $find_customer_data = ItEasyCustomer::FindCustomerbyMobile($fileopen[9]);
                            // echo "<pre>"; print_r($find_customer_data); die;
                            
    if($fileopen[4] == 'Awb Registered'){
        $model->it_easy_order_status_id = '2';
    }else if($fileopen[4] == 'Cancelled'){
        $model->it_easy_order_status_id = '8';
    }else if($fileopen[4] == 'Delivered'){
        $model->it_easy_order_status_id = '3';
    }else if($fileopen[4] == 'DestinationHubIn'){
        $model->it_easy_order_status_id = '27';
    }else if($fileopen[4] == 'FailedDelivery'){
        $model->it_easy_order_status_id = '9';
    }else if($fileopen[4] == 'InTransit'){
        $model->it_easy_order_status_id = '27';
    }else if($fileopen[4] == 'OrderPlaced'){
        $model->it_easy_order_status_id = '4';
    }else if($fileopen[4] == 'OriginCityIn'){
        $model->it_easy_order_status_id = '27';
    }else if($fileopen[4] == 'OriginCityOut'){
        $model->it_easy_order_status_id = '27';
    }else if($fileopen[4] == 'OutForDelivery'){
        $model->it_easy_order_status_id = '30';
    }else if($fileopen[4] == 'OutForPickup'){
        $model->it_easy_order_status_id = '4';
    }else if($fileopen[4] == 'PickedUp'){
        $model->it_easy_order_status_id = '29';
    }else if($fileopen[4] == 'PickupFailed'){
        $model->it_easy_order_status_id = '31';
    }else if($fileopen[4] == 'PickupPending'){
        $model->it_easy_order_status_id = '4';
    }else if($fileopen[4] == 'RTO-Delivered'){
        $model->it_easy_order_status_id = '47';
    }else if($fileopen[4] == 'RTO-InTransit'){
        $model->it_easy_order_status_id = '26';
    }else if($fileopen[4] == 'RTO-Marked'){
        $model->it_easy_order_status_id = '26';
    }else if($fileopen[4] == 'RTO-OutForDelivery'){
        $model->it_easy_order_status_id = '26';
    }else if($fileopen[4] == 'RTO-Requested'){
        $model->it_easy_order_status_id = '26';
    }else if($fileopen[4] == 'ShipmentDelayed'){
        $model->it_easy_order_status_id = '9';
    }                         
    $model->save(false);
    
    //echo "<pre>"; print_r($fileopen); die;
    
    if(empty($find_customer_data)){
        $find_customer_data = ItEasyCustomer::SavecustomerModelFromMobile($model, $model->it_easy_order_id);
        $model->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
    }else{

        $model->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
        
    }
    
    $order_status = $fileopen[4];
    $response2 = 'success';
    $smart_route_code = '';
    $shiping_data = ItEasyClickpostCourier::find()->where(['account_name' => $fileopen[28] ])->asArray()->one();
    $ApiCall = new ApiCall();
    $ApiCall->updateAwbResponce($model->it_easy_order_id, $model->it_easy_customer_id ,$shiping_data['cp_id'], $fileopen[1],'Clickpost Success',$response2,$date_updated_excel_assign);
    $ApiCall = new ApiCall();
    
    $ApiCall->addOrderDispatchclickpostcustom($model,$shiping_data['cp_id'],$shiping_data,$fileopen[1],$fileopen[0],$smart_route_code, $order_status);
    
    
    $addOrderStatusHistory = ItEasyOrder::addOrderStatusHistory($model->it_easy_order_id, $model->it_easy_order_status_id, 'Direct Upload Via Manural because of data crash');
    $addDispositionStatusHistory = ItEasyOrder::addDispositionStatusHistory($model->it_easy_order_id, '3', 'Direct Upload Via Manural because of data crash');
      
    
    $model->it_easy_total_price = $fileopen[21];
    $model->it_easy_gst_price = '0';
    $model->it_easy_product_quantity = $fileopen[15];
    $model->it_easy_order_number = 'NH'.$model->it_easy_order_id;
    $model->save(false);
                
                
                
            }
                                
                                
                            }else{
    $model = ItEasyOrder::find()->andWhere(['it_easy_mobile_number' =>  $fileopen[9]])->orderBy(['it_easy_created_time' => SORT_DESC ])->one();
                            
    $get_financial_year = ItEasyFinancialYear::getFinancialyear();
    $model->it_easy_financial_year = $get_financial_year;
    $model->it_easy_store_id = ItEasyStore::getStorename()->it_easy_id;
    $model->it_easy_store_name = ItEasyStore::getStorename()->it_easy_store_name;
    
    $model->it_easy_firstname = $fileopen[8];
  	$model->it_easy_shipping_firstname = $fileopen[8];
  	$model->it_easy_billing_firstname = $fileopen[8];

  	$model->it_easy_address_1 = $fileopen[10];
  	$model->it_easy_shipping_address_1 = $fileopen[10];
  	$model->it_easy_billing_address_1 = $fileopen[10];
    $model->it_easy_address_2 = $fileopen[10];
  	$model->it_easy_shipping_address_2 = $fileopen[10];
  	$model->it_easy_billing_address_2 = $fileopen[10];
  	$model->it_easy_city = $fileopen[12];
    $model->it_easy_shipping_city = $fileopen[12];
    $model->it_easy_billing_city = $fileopen[12];
    $get_state_data = ItEasyState::getStatedatabyStateName($fileopen[13]);
    $model->it_easy_state_id = $get_state_data->it_easy_id ;
    $model->it_easy_shipping_state_id = $get_state_data->it_easy_id;
    $model->it_easy_billing_state_id = $get_state_data->it_easy_id;
    $payment_mode = $fileopen[19];
    $model->it_easy_pincode = $fileopen[11];
  	$recommand =  ItEasyOrder::FindRecommandClickpost($model->it_easy_order_id, $model->it_easy_pincode, $payment_mode);
    $model->it_easy_shipping_pincode = $fileopen[11];
    $model->it_easy_billing_pincode = $fileopen[11];
    $model->it_easy_billing_email = $fileopen[30];
  	$model->it_easy_shipping_email = $fileopen[30];
  	$model->it_easy_email = $fileopen[30];
    $get_paymentmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode($fileopen[19]);
    $get_shippingmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode('Free Shipping');
    $model->it_easy_state = $fileopen[13];
    $model->it_easy_shipping_state = $fileopen[13];
    $model->it_easy_billing_state = $fileopen[13];
    $model->it_easy_payment_method = $get_paymentmethod->it_easy_method_name;
    $model->it_easy_payment_code = $get_paymentmethod->it_easy_method_code;
    $model->it_easy_shipping_method = $get_shippingmethod->it_easy_method_name;
    $model->it_easy_shipping_code = $get_shippingmethod->it_easy_method_code;
    $model->it_easy_first_status = 'COD';

    
    $model->it_easy_read_status = '0';
    if($fileopen[34]  == 'Sales'){
        $model->it_easy_department_id = '4';
        
        $find_agent_name = ItEasyUser::findOne(['it_easy_username' => $fileopen[32]]);
        $find_tl_name = ItEasyUser::findOne(['it_easy_username' => $fileopen[33]]);
        if(empty($find_agent_name)){
            $model->it_easy_assigned_to = 0;
        }else{
           $model->it_easy_assigned_to = $find_agent_name->id; 
        }
        if(empty($find_tl_name)){
            $model->it_easy_assigned_by = 0;
        }else{
            $model->it_easy_assigned_by = $find_tl_name->id;
        }
        
        
        $model->it_easy_retention_TLid = '';
        $model->it_easy_retention_AGENTid = '';
    }else{
        
        $find_agent_name = ItEasyUser::findOne(['it_easy_username' => $fileopen[32]]);
        //echo "<pre>"; print_r($fileopen[32]); 
        //echo "<pre>"; print_r($find_agent_name); 
        $find_tl_name = ItEasyUser::findOne(['it_easy_username' => $fileopen[33]]);
        
        $model->it_easy_department_id = '9';
        $model->it_easy_assigned_by = '';
        $model->it_easy_assigned_to = '';
        
        if(empty($find_agent_name)){
            $model->it_easy_retention_AGENTid = 0;
        }else{
            $model->it_easy_retention_AGENTid = $find_tl_name->id;
        }
        
        if(empty($find_tl_name)){
            $model->it_easy_retention_TLid = 0;
        }else{
            $model->it_easy_retention_TLid = $find_tl_name->id;
        }
    }
    
    $model->it_easy_disease_name = '1';
    $model->created_by = Yii::$app->user->identity->id;
    if(!empty($fileopen[6])){
    
       $date_time_order = explode(" ",$fileopen[6]);
       $date_array = explode("-",$date_time_order[0]);
       $date_updated_excel = $date_array[2].'-'.$date_array[1].'-'.$date_array[1].' '.$date_time_order[1].':00';
    }else{
       $date_updated_excel = '';
    }
    
    if(!empty($fileopen[27])){
       $date_time_orderss = explode(" ",$fileopen[27]);
       $date_array_2 = explode("-",$date_time_orderss[0]);
       $date_updated_excel_convert = $date_array_2[2].'-'.$date_array_2[1].'-'.$date_array_2[1].' '.$date_time_orderss[1].':00';
    }else{
       $date_updated_excel_convert = '';
    }
    
    if(!empty($fileopen[24])){
       $date_time_orderdeli = explode(" ",$fileopen[24]);
       $date_array_deliv = explode("-",$date_time_orderdeli[0]);
       $date_updated_excel_delivered = $date_array_deliv[2].'-'.$date_array_deliv[1].'-'.$date_array_deliv[1].' '.$date_time_orderdeli[1].':00';
    }else{
       $date_updated_excel_delivered = '';
    }
    
    if(!empty($fileopen[3])){
       $date_time_placed = explode(" ",$fileopen[3]);
       $date_array_placed = explode("-",$date_time_placed[0]);
       $date_updated_excel_placed = $date_array_placed[2].'-'.$date_array_placed[1].'-'.$date_array_placed[1].' '.$date_time_placed[1].':00';
    }else{
       $date_updated_excel_placed = '';
    }
    if(!empty($fileopen[2])){
       $date_time_assign= explode(" ",$fileopen[2]);
       $date_array_assign= explode("-",$date_time_assign[0]);
       $date_updated_excel_assign = $date_array_assign[2].'-'.$date_array_assign[1].'-'.$date_array_assign[1].' '.$date_time_assign[1].':00';
    }else{
       $date_updated_excel_assign = '';
    }
    $model->it_easy_updated_time = $date_updated_excel;
    $model->it_easy_converted_time = $date_updated_excel_convert;
    $model->it_easy_placed_time  = $date_updated_excel_placed;
    $model->it_easy_assign_time  = $date_updated_excel_assign; 
    $model->it_easy_delivered_time = $date_updated_excel_delivered;
    $find_customer_data = ItEasyCustomer::FindCustomerbyMobile($fileopen[9]);
                            // echo "<pre>"; print_r($find_customer_data); die;
                            
    if($fileopen[4] == 'Awb Registered'){
        $model->it_easy_order_status_id = '2';
    }else if($fileopen[4] == 'Cancelled'){
        $model->it_easy_order_status_id = '8';
    }else if($fileopen[4] == 'Delivered'){
        $model->it_easy_order_status_id = '3';
    }else if($fileopen[4] == 'DestinationHubIn'){
        $model->it_easy_order_status_id = '27';
    }else if($fileopen[4] == 'FailedDelivery'){
        $model->it_easy_order_status_id = '9';
    }else if($fileopen[4] == 'InTransit'){
        $model->it_easy_order_status_id = '27';
    }else if($fileopen[4] == 'OrderPlaced'){
        $model->it_easy_order_status_id = '4';
    }else if($fileopen[4] == 'OriginCityIn'){
        $model->it_easy_order_status_id = '27';
    }else if($fileopen[4] == 'OriginCityOut'){
        $model->it_easy_order_status_id = '27';
    }else if($fileopen[4] == 'OutForDelivery'){
        $model->it_easy_order_status_id = '30';
    }else if($fileopen[4] == 'OutForPickup'){
        $model->it_easy_order_status_id = '4';
    }else if($fileopen[4] == 'PickedUp'){
        $model->it_easy_order_status_id = '29';
    }else if($fileopen[4] == 'PickupFailed'){
        $model->it_easy_order_status_id = '31';
    }else if($fileopen[4] == 'PickupPending'){
        $model->it_easy_order_status_id = '4';
    }else if($fileopen[4] == 'RTO-Delivered'){
        $model->it_easy_order_status_id = '47';
    }else if($fileopen[4] == 'RTO-InTransit'){
        $model->it_easy_order_status_id = '26';
    }else if($fileopen[4] == 'RTO-Marked'){
        $model->it_easy_order_status_id = '26';
    }else if($fileopen[4] == 'RTO-OutForDelivery'){
        $model->it_easy_order_status_id = '26';
    }else if($fileopen[4] == 'RTO-Requested'){
        $model->it_easy_order_status_id = '26';
    }else if($fileopen[4] == 'ShipmentDelayed'){
        $model->it_easy_order_status_id = '9';
    }                         
    $model->save(false);
    
    //echo "<pre>"; print_r($fileopen); die;
    
    if(empty($find_customer_data)){
        $find_customer_data = ItEasyCustomer::SavecustomerModelFromMobile($model, $model->it_easy_order_id);
        $model->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
    }else{

        $model->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
        
    }
    
    $order_status = $fileopen[4];
    $response2 = 'success';
    $smart_route_code = '';
    $shiping_data = ItEasyClickpostCourier::find()->where(['account_name' => $fileopen[28] ])->asArray()->one();
    $ApiCall = new ApiCall();
    $ApiCall->updateAwbResponce($model->it_easy_order_id, $model->it_easy_customer_id ,$shiping_data['cp_id'], $fileopen[1],'Clickpost Success',$response2,$date_updated_excel_assign);
    $ApiCall = new ApiCall();
    
    $ApiCall->addOrderDispatchclickpostcustom($model,$shiping_data['cp_id'],$shiping_data,$fileopen[1],$fileopen[0],$smart_route_code, $order_status);
    
    
    $addOrderStatusHistory = ItEasyOrder::addOrderStatusHistory($model->it_easy_order_id, $model->it_easy_order_status_id, 'Direct Upload Via Manural because of data crash');
    $addDispositionStatusHistory = ItEasyOrder::addDispositionStatusHistory($model->it_easy_order_id, '3', 'Direct Upload Via Manural because of data crash');
      
    
    $model->it_easy_total_price = $fileopen[21];
    $model->it_easy_gst_price = '0';
    $model->it_easy_product_quantity = $fileopen[15];
    $model->it_easy_order_number = 'NH'.$model->it_easy_order_id;
    $model->save(false); 
    
    
                            }
                        }
                        }
                        
                    }
                    $cnount++;
                }
                // die;
                Yii::$app->session->setFlash('success', 'Your data has been updated successfully.');
                Yii::$app->response->redirect(['order-dispatch/upload-salesforcematch']);
            }
        } else {
            return $this->render('upload-salesforcematch', [
                'model' => $model,
            ]);
        }
    }
  
    public function actionGetApiname(){
        set_time_limit(0);
  	    ini_set('max_execution_time', 0);
  	    ini_set("memory_limit", "-1");
        $model = new ItEasyOrder();
        $api_call = new ApiCall();
        $shiping_id = Yii::$app->request->post()['ItEasyOrder']['it_easy_ship_id'];
        $order_seletion = Yii::$app->request->post()['selection'];
        $get_order_data =  ItEasyOrder::find()->asArray()->where(['in', 'it_easy_order_id', $order_seletion])->All();

        $get_value = [];
         foreach ($get_order_data as $value) {
            
            switch($shiping_id) {
                case 1:   // Delhivery//   
                       
                        $delhivery = $api_call->getDelhiVery($value,$shiping_id);
                        $get_value[] = $delhivery;
                break;
                case 2:   // EcomExpress//   
                       
                        $ecom = $api_call->getEcomExpress($value,$shiping_id);
                        $get_value[] = $ecom;   
                break;
    
                case 6:   // EcomExpress AIR//   
                       
                        $ecom = $api_call->getEcomExpressair($value,$shiping_id);
                        $get_value[] = $ecom;   
                break;
    
                case 3:   // Xpressbees//    
    
                        $xb_value = $api_call->getXpressbees($value,$shiping_id);
                        $get_value[] = $xb_value;
                        
                break;
                  
                case 4:   // shipdelight//    
                  
                        $xb_value = $api_call->getShipdelight($value,$shiping_id);
                        $get_value[] = $xb_value;
                        
                break; 
    
    
                case 7:   // smartship// 
                        // echo "<pre>";print_r($shiping_id);die;
                        $post = array('username' =>'finance@heebs.com', 'password'=>'f6de7bf592c7074d7b4e6503c07ff64c','client_id' =>'WIU7XKIS4H7W7322KBLGS','client_secret'=>'8OUX4%0I85Y24H6$T6OS^' , 'grant_type' =>'password');
                        $json = json_encode($post);
                        $url = 'http://oauth.smartship.in/loginToken.php';
                        $ch = curl_init();
                        curl_setopt($ch, CURLOPT_URL, $url);
                        curl_setopt($ch, CURLOPT_POST, true);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                        $curl_exicute = curl_exec($ch);  
                        // echo $curl_exicute; die;
                        $decodedata = json_decode($curl_exicute, true);
                      
                        curl_close($ch);          
                       // $token = '4c748c367699c5f8b99f0c8ab28ca560da07b02b';
                        $xb_value = $api_call->getSmartship($value,$shiping_id,$decodedata['access_token']);
                        // $xb_value = $api_call->getSmartship($value,$shiping_id,$token);
                        $get_value[] = $xb_value;
                        
                break; 
                
                case 8:   // Bluedart//   
                
                        $url = "https://apigateway.bluedart.com/in/transportation/token/v1/login";
                        

                        $curl = curl_init($url);
                        curl_setopt($curl, CURLOPT_URL, $url);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                        
                        $headers = array(
                          "ClientID: IIbLPYByHXhToj3qetfR7b7jRxgB59kM",
                          "clientSecret: YbL9nwZZaRzLdQMk",
                        //   "ClientID: Fgc2iCdompSUtzpxdmEnGbGkhjRJG6ex",
                        //   "clientSecret: fTu05JRg0JWDZiJi",
                           
                        );
                        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                        $resp = curl_exec($curl);
                        $result = json_decode($resp);
                        // echo "<pre>"; print_r($result); die;
                        $access_token = $result->JWTToken;
                        $awbcall = new CallAwbService1();
                        $bluedart = $awbcall->getCallAwbService($value,$shiping_id, $access_token);
                        $get_value[] = $bluedart;   
                break;
                
                
                case 9:   // smartr// 
                                 
                        
                        $url = "https://api.smartr.in/api/v1/get-token/";
    
                        $curl = curl_init($url);
                        curl_setopt($curl, CURLOPT_URL, $url);
                        curl_setopt($curl, CURLOPT_POST, true);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                        
                        $headers = array(
                           "Content-Type: application/json",
                        );
                        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                        
                        $data['username'] = "DELNUTRI001";
                        $data['password'] = "8VkKDIgaZizXfAQYxgM";
                        
                        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
                        
                        $resp = curl_exec($curl);
                        $result = json_decode($resp);
                        
                        curl_close($curl);
                        // echo "<pre>"; print_r($result); die;
                        if(isset($result->data->access_token)){
                            $token = $result->data->access_token;
                        }else{
                            echo "<pre>"; print_r($result); die;
                        }
                        
                        
                        $xb_value = $api_call->getSmartr($value,$shiping_id,$token);
                        
                        $get_value[] = $xb_value;
                        
                break;
                
                case 10:   // shipdelight//    
                  
                        $xb_value = $api_call->getIthink($value,$shiping_id);
                        $get_value[] = $xb_value;
                        
                break; 
                
                case 11:   // Rapidsyp//    
                  
                        $xb_value = $api_call->getRapidsyp($value,$shiping_id);
                        $get_value[] = $xb_value;
                        
                break; 
                
                case 12:   // shiprocket// 
                        $url = "https://apiv2.shiprocket.in/v1/external/auth/login";

                        $curl = curl_init($url);
                        curl_setopt($curl, CURLOPT_URL, $url);
                        curl_setopt($curl, CURLOPT_POST, true);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                        
                        $headers = array(
                           "Content-Type: application/json",
                        );
                        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                        
                        $data['email'] = "sunil@spunkads.com";
                        $data['password'] = 'L!z7$SxNDtHxp*9cCRq6yQZ6fJ$Oc#ni';
                        
                        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
                        
                        
                        $resp = curl_exec($curl);
                        $decodedata = json_decode($resp, true);
                        // echo "<pre>"; print_r($decodedata); die;
                        curl_close($curl);          
                       // $token = '4c748c367699c5f8b99f0c8ab28ca560da07b02b';
                        $xb_value = $api_call->getShiprocket($value,$shiping_id,$decodedata['token']);
                        // $xb_value = $api_call->getSmartship($value,$shiping_id,$token);
                        $get_value[] = $xb_value;
                        
                break;
                
                
                case 13:   // pickndel// 
                
                        $url = "https://api.pikndel.com/backoffice/api/account/login";
                        $data = [];
                        $data['Control']['RequestId'] = Yii::$app->security->generateRandomString(32);
                        $data['Control']['Source'] = 3;
                        $data['Control']['RequestTime'] = time();
                        $data['Control']['Version'] = "1.3";
                        $data['Data']['Username'] = "nutriherbs";
                        $data['Data']['Password'] = "Pikndel@123";
                        $data['Data']['GrantType'] = "password";
                        $curl = curl_init($url);
                        curl_setopt($curl, CURLOPT_URL, $url);
                        curl_setopt($curl, CURLOPT_POST, true);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                        
                        $headers = array(
                           "Content-Type: application/json",
                        );
                        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                        
                    
                        
                        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
                        
                        
                        $resp = curl_exec($curl);    
            
                        $decodedata = json_decode($resp, true);
                        // echo "<pre>"; print_r($decodedata); die;
                        curl_close($curl);          
                       // $token = '4c748c367699c5f8b99f0c8ab28ca560da07b02b';
                        $xb_value = $api_call->getPickndel($value,$shiping_id,$decodedata['Data']['Token']);
                        // $xb_value = $api_call->getSmartship($value,$shiping_id,$token);
                        $get_value[] = $xb_value;
                        
                break;
                
                case 14:   // Professional//    
                        //echo "<pre>"; print_r($value); die;
                        $xb_value = $api_call->getProfessional($value,$shiping_id);
                        $get_value[] = $xb_value;
                        
                break;
                
                
                case 15:   // Blitz// 
                
                        $url = "https://oyvm2iv4xj.execute-api.ap-south-1.amazonaws.com/v1/auth";
                        $data = [];
                        $data['request_type'] = "authenticate";
                        // $data['payload']['username'] = "NRy1JI7hD7Mf";
                        $data['payload']['username'] = "ekUUKKzJr0Rj";
                        $data['payload']['password'] = "0rGKZnZl*5~Zn";
                            
                        
                        //$data['payload']['password'] = "L0{we2N-|7]Zg";
                        $curl = curl_init($url);
                        curl_setopt($curl, CURLOPT_URL, $url);
                        curl_setopt($curl, CURLOPT_POST, true);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                        
                        $headers = array(
                           "Content-Type: application/json",
                        );
                        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                        
                    
                        
                        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
                        
                        
                        $resp = curl_exec($curl);    
            
                        $decodedata = json_decode($resp, true);
                        // echo "<pre>"; print_r($decodedata); die;
                        curl_close($curl);          
                       // $token = '4c748c367699c5f8b99f0c8ab28ca560da07b02b';
                        $xb_value = $api_call->getBlitz($value,$shiping_id,$decodedata['id_token']);
                        // $xb_value = $api_call->getSmartship($value,$shiping_id,$token);
                        $get_value[] = $xb_value;
                        
                break;
                
                
                case 16:   // DTDC//    
                  
                        $xb_value = $api_call->getDtdc($value,$shiping_id);
                        $get_value[] = $xb_value;
                        
                break;
                
                case 17:   // Prozo//    
                
                        $curl = curl_init();

                        curl_setopt_array($curl, array(
                          CURLOPT_URL => 'https://proship.prozo.com/api/auth/signin',
                          CURLOPT_RETURNTRANSFER => true,
                          CURLOPT_ENCODING => '',
                          CURLOPT_MAXREDIRS => 10,
                          CURLOPT_TIMEOUT => 0,
                          CURLOPT_FOLLOWLOCATION => true,
                          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                          CURLOPT_CUSTOMREQUEST => 'POST',
                          CURLOPT_POSTFIELDS =>'{
                            "username":"gurneet@nutriherbs.in",
                            "password":"NUTRi!!)0900"
                        }',
                          CURLOPT_HTTPHEADER => array(
                            'Content-Type: application/json'
                          ),
                        ));
                        
                        $response = curl_exec($curl);
                        $decodedata = json_decode($response, true);
                        // echo "<pre>"; print_r($decodedata); die;
                        curl_close($curl);
                    
                        $xb_value = $api_call->getProzo($value,$shiping_id, $decodedata['accessToken']);
                        $get_value[] = $xb_value;
                        
                break;
                
                case 19:   // Quickshift//    
                  
                        $xb_value = $api_call->getQuickshift($value,$shiping_id);
                        $get_value[] = $xb_value;
                        
                break; 
                
                case 20:   // Ekart// 
                        $curl = curl_init();

                        curl_setopt_array($curl, array(
                          CURLOPT_URL => 'https://api.ekartlogistics.com/auth/token',
                          CURLOPT_RETURNTRANSFER => true,
                          CURLOPT_ENCODING => '',
                          CURLOPT_MAXREDIRS => 10,
                          CURLOPT_TIMEOUT => 0,
                          CURLOPT_FOLLOWLOCATION => true,
                          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                          CURLOPT_CUSTOMREQUEST => 'POST',
                          CURLOPT_HTTPHEADER => array(
                            'HTTP_X_MERCHANT_CODE: SKG',
                            'Authorization: Basic c2t5Z2FpbnNrZzprNm43NUozT0RKMGw4YUQ4',
                            'Content-Type: application/json'
                          ),
                        ));
                        
                        $response = curl_exec($curl);
                        
                        $decodedata = json_decode($response, true);
                      
                        curl_close($curl); 
                        $xb_value = $api_call->getEkart($value,$shiping_id,$decodedata['Authorization']);
                        $get_value[] = $xb_value;
                        
                break;
                
                case 21:   // Urbanbolt// 
                        // $post_data['username'] = "UBC0119_TNEKxzElkv5N3Q_prod_api";
                        // $post_data['password'] = "jkqaBooqp3ocBKxjw8rX3g";
                        $post_data['username'] = "Gurneet Singh";
                        $post_data['password'] = "NUTRi#@10101";
                        $curl = curl_init();

                        curl_setopt_array($curl, array(
                          CURLOPT_URL => 'https://api.urbanebolt.in/api/v1/auth/getToken/',
                          CURLOPT_RETURNTRANSFER => true,
                          CURLOPT_ENCODING => '',
                          CURLOPT_MAXREDIRS => 10,
                          CURLOPT_TIMEOUT => 0,
                          CURLOPT_FOLLOWLOCATION => true,
                          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                          CURLOPT_CUSTOMREQUEST => 'POST',
                          CURLOPT_POSTFIELDS => json_encode($post_data),
                          CURLOPT_HTTPHEADER => array(
                            'Content-Type: application/json',
                            'Cookie: csrftoken=SuZfjeJQJQNlDaNxRJgaMqylRWlqogsL; csrftoken=xCmYoWZ7t4OOj3wekRymGL1fENoqklQj; sessionid=0j97z96157wx1po5saryvd5l9yo3a7ot; csrftoken=VOGH379uEECz8RnM2M6fRcUKDTyPT7m1; sessionid=h2e2tsro313lbp25lb306i3ryp62jyl1'
                          ),
                        ));
                        
                        $response = curl_exec($curl);
                        
                        $decodedata = json_decode($response, true);
                        //echo "<pre>"; print_r($decodedata); die;
                        curl_close($curl); 
                        $xb_value = $api_call->getUrbanbolt($value,$shiping_id,$decodedata['access_token']);
                        $get_value[] = $xb_value;
                        
                break;
                case 22:   // Delhivery one //   
                       
                        $delhivery = $api_call->getDelhiVeryOne($value,$shiping_id);
                        $get_value[] = $delhivery;
                break;
                
                 case 23:   // Zippy Delhivery // 
                       


                        $curl = curl_init();
                        
                        curl_setopt_array($curl, array(
                          CURLOPT_URL => 'https://sellingpartnerapi-in.zippyy.ai/v1/external/auth/login',
                          CURLOPT_RETURNTRANSFER => true,
                          CURLOPT_ENCODING => '',
                          CURLOPT_MAXREDIRS => 10,
                          CURLOPT_TIMEOUT => 0,
                          CURLOPT_FOLLOWLOCATION => true,
                          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                          CURLOPT_CUSTOMREQUEST => 'POST',
                          CURLOPT_POSTFIELDS =>'{
                          "emailAddress": "gurneet@Nutriherbs.in",
                          "password": "Heeb$@250611"
                        }',
                          CURLOPT_HTTPHEADER => array(
                              'x-api-version: 1',
                              'Content-Type: application/json'
                          ),
                        ));
                        
                        $response = curl_exec($curl);
                        
                        curl_close($curl);
                      // echo $response;
                       
                        $decodedata = json_decode($response, true);
                        // echo "<pre>"; print_r($decodedata); die;
                        curl_close($curl);          
                     
                        $zippy_value = $api_call->getZippy($value,$shiping_id,$decodedata['accessToken']);
                       
                        $get_value[] = $zippy_value;
                        
                break;
                
                
                 case 25:   // Zippy Ats // 
                       


                        $curl = curl_init();
                        
                        curl_setopt_array($curl, array(
                          CURLOPT_URL => 'https://sellingpartnerapi-in.zippyy.ai/v1/external/auth/login',
                          CURLOPT_RETURNTRANSFER => true,
                          CURLOPT_ENCODING => '',
                          CURLOPT_MAXREDIRS => 10,
                          CURLOPT_TIMEOUT => 0,
                          CURLOPT_FOLLOWLOCATION => true,
                          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                          CURLOPT_CUSTOMREQUEST => 'POST',
                          CURLOPT_POSTFIELDS =>'{
                          "emailAddress": "gurneet@Nutriherbs.in",
                          "password": "Heeb$@250611"
                        }',
                          CURLOPT_HTTPHEADER => array(
                              'x-api-version: 1',
                              'Content-Type: application/json'
                          ),
                        ));
                        
                        $response = curl_exec($curl);
                        
                        curl_close($curl);
                      // echo $response;
                       
                        $decodedata = json_decode($response, true);
                        // echo "<pre>"; print_r($decodedata); die;
                        curl_close($curl);          
                     
                        $zippy_value = $api_call->getZippy($value,$shiping_id,$decodedata['accessToken']);
                       
                        $get_value[] = $zippy_value;
                        
                break;
                
                case 26:   // Zippy Dtdc // 
                       


                        $curl = curl_init();
                        
                        curl_setopt_array($curl, array(
                          CURLOPT_URL => 'https://sellingpartnerapi-in.zippyy.ai/v1/external/auth/login',
                          CURLOPT_RETURNTRANSFER => true,
                          CURLOPT_ENCODING => '',
                          CURLOPT_MAXREDIRS => 10,
                          CURLOPT_TIMEOUT => 0,
                          CURLOPT_FOLLOWLOCATION => true,
                          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                          CURLOPT_CUSTOMREQUEST => 'POST',
                          CURLOPT_POSTFIELDS =>'{
                          "emailAddress": "gurneet@Nutriherbs.in",
                          "password": "Heeb$@250611"
                        }',
                          CURLOPT_HTTPHEADER => array(
                              'x-api-version: 1',
                              'Content-Type: application/json'
                          ),
                        ));
                        
                        $response = curl_exec($curl);
                        
                        curl_close($curl);
                      // echo $response;
                       
                        $decodedata = json_decode($response, true);
                        // echo "<pre>"; print_r($decodedata); die;
                        curl_close($curl);          
                     
                        $zippy_value = $api_call->getZippy($value,$shiping_id,$decodedata['accessToken']);
                       
                        $get_value[] = $zippy_value;
                        
                break;
                
                case 27:   // Zippy Ekart // 
                       


                        $curl = curl_init();
                        
                        curl_setopt_array($curl, array(
                          CURLOPT_URL => 'https://sellingpartnerapi-in.zippyy.ai/v1/external/auth/login',
                          CURLOPT_RETURNTRANSFER => true,
                          CURLOPT_ENCODING => '',
                          CURLOPT_MAXREDIRS => 10,
                          CURLOPT_TIMEOUT => 0,
                          CURLOPT_FOLLOWLOCATION => true,
                          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                          CURLOPT_CUSTOMREQUEST => 'POST',
                          CURLOPT_POSTFIELDS =>'{
                          "emailAddress": "gurneet@Nutriherbs.in",
                          "password": "Heeb$@250611"
                        }',
                          CURLOPT_HTTPHEADER => array(
                              'x-api-version: 1',
                              'Content-Type: application/json'
                          ),
                        ));
                        
                        $response = curl_exec($curl);
                        
                        curl_close($curl);
                      // echo $response;
                       
                        $decodedata = json_decode($response, true);
                        // echo "<pre>"; print_r($decodedata); die;
                        curl_close($curl);          
                     
                        $zippy_value = $api_call->getZippy($value,$shiping_id,$decodedata['accessToken']);
                       
                        $get_value[] = $zippy_value;
                        
                break;
                
                
                case 28:   // Zippy Xpressbees // 
                       


                        $curl = curl_init();
                        
                        curl_setopt_array($curl, array(
                          CURLOPT_URL => 'https://sellingpartnerapi-in.zippyy.ai/v1/external/auth/login',
                          CURLOPT_RETURNTRANSFER => true,
                          CURLOPT_ENCODING => '',
                          CURLOPT_MAXREDIRS => 10,
                          CURLOPT_TIMEOUT => 0,
                          CURLOPT_FOLLOWLOCATION => true,
                          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                          CURLOPT_CUSTOMREQUEST => 'POST',
                          CURLOPT_POSTFIELDS =>'{
                          "emailAddress": "gurneet@Nutriherbs.in",
                          "password": "Heeb$@250611"
                        }',
                          CURLOPT_HTTPHEADER => array(
                              'x-api-version: 1',
                              'Content-Type: application/json'
                          ),
                        ));
                        
                        $response = curl_exec($curl);
                        
                        curl_close($curl);
                      // echo $response;
                       
                        $decodedata = json_decode($response, true);
                        // echo "<pre>"; print_r($decodedata); die;
                        curl_close($curl);          
                     
                        $zippy_value = $api_call->getZippy($value,$shiping_id,$decodedata['accessToken']);
                       
                        $get_value[] = $zippy_value;
                        
                break;
                
                
                 //  case 24:   // Testing // 
                       


                //         $curl = curl_init();
                        
                //         curl_setopt_array($curl, array(
                //           CURLOPT_URL => 'https://api.nimbuspost.com/v1/users/login',
                //           CURLOPT_RETURNTRANSFER => true,
                //           CURLOPT_ENCODING => '',
                //           CURLOPT_MAXREDIRS => 10,
                //           CURLOPT_TIMEOUT => 0,
                //           CURLOPT_FOLLOWLOCATION => true,
                //           CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                //           CURLOPT_CUSTOMREQUEST => 'POST',
                //           CURLOPT_POSTFIELDS =>'{
                //           "emailAddress": "logistics+2887@nutriherbs.in",
                //           "password": "uN5PTud1Em"
                //         }',
                //           CURLOPT_HTTPHEADER => array(
                //               'x-api-version: 1',
                //               'Content-Type: application/json'
                //           ),
                //         ));
                        
                //         $response = curl_exec($curl);
                        
                //         curl_close($curl);
                //       // echo $response;
                       
                //         $decodedata = json_decode($resp, true);
                //         // echo "<pre>"; print_r($decodedata); die;
                //         curl_close($curl);          
                     
                //         $zippy_value = $api_call->getNimbus($value,$shiping_id,$decodedata['accessToken']);
                       
                //         $get_value[] = $zippy_value;
                        
                // break;
                
                
                
                

            } 
         }
            $param = json_encode($get_value);
            Yii::$app->response->redirect(['order-dispatch/responce','params' => $param]);
   	}
   	
   	
   	public function actionGetClickposapiname(){
        set_time_limit(0);
  	    ini_set('max_execution_time', 0);
  	    ini_set("memory_limit", "-1");
        $model = new ItEasyOrder();
        $api_call = new ApiCall();
        $shiping_id = Yii::$app->request->post()['ItEasyOrder']['it_easy_ship_id'];
        $order_seletion = Yii::$app->request->post()['selection'];
        $get_order_data =  ItEasyOrder::find()->asArray()->where(['in', 'it_easy_order_id', $order_seletion])->All();

        $get_value = [];
        foreach ($get_order_data as $value) {
            $click_post_courier = ItEasyClickpostCourier::find()->where(['cp_id' => $shiping_id])->one();
            $xb_value = $api_call->getClickpost($value,$shiping_id,$click_post_courier->account_name);
            $get_value[] = $xb_value;
        }
        $param = json_encode($get_value);
        Yii::$app->response->redirect(['order-dispatch/responce','params' => $param]);
   	}
    
    
    public function actionGenerateClickpostmanifest(){
        set_time_limit(0);
  	    ini_set('max_execution_time', 0);
  	    ini_set("memory_limit", "-1");
        $model = new ItEasyOrder();
        $api_call = new ApiCall();
        if(!empty(Yii::$app->request->post()['selection'])){
            $order_seletion = Yii::$app->request->post()['selection'];
            $get_order_data =  ItEasyOrderDispatch::find()->asArray()->where(['in', 'it_easy_order_id', $order_seletion])->All();
            // echo "<pre>"; print_r($get_order_data); die;
            $get_value = [];
             foreach ($get_order_data as $value) {
                $xb_value = $api_call->generateClickpost($value);
                $get_value[] = $xb_value;
             }
             
            $param = json_encode($get_value);
            Yii::$app->response->redirect(['order-dispatch/responce','params' => $param]);
        }
    }
    
    
    
  
  	public function actionGenerateManifest(){
  	    set_time_limit(0);
  	    ini_set('max_execution_time', 0);
  	    ini_set("memory_limit", "-1");
        $model = new ItEasyOrder();
        $api_call = new ApiCall();
        if(!empty(Yii::$app->request->post()['selection'])){
        $order_seletion = Yii::$app->request->post()['selection'];
        $get_order_data =  ItEasyOrderDispatch::find()->asArray()->where(['in', 'it_easy_order_id', $order_seletion])->All();
        // echo "<pre>"; print_r($get_order_data); die;
        $get_value = [];
         foreach ($get_order_data as $value) {
            
            switch($value['it_easy_shipping_id']) {
                case 1:   // Delhivery//   
                       
                        $delhivery = $api_call->generateDelhiVery($value);
                        $get_value[] = $delhivery;
                break;
                case 2:   // EcomExpress//   
                       
                        $ecom = $api_call->generateEcomExpress($value);
                        $get_value[] = $ecom;   
                break;
    
                case 6:   // EcomExpress AIR//   
                       
                        $ecom = $api_call->generateEcomExpressair($value);
                        $get_value[] = $ecom;   
                break;
    
                case 3:   // Xpressbees//    
    
                        $xb_value = $api_call->generateXpressbees($value);
                        $get_value[] = $xb_value;
                        
                break;
                  
                case 4:   // shipdelight//    
    
                        $xb_value = $api_call->generateShipdelight($value);
                        $get_value[] = $xb_value;
                        
                break;  
                
                case 5:   // indiapost//    
    
                        $xb_value = $api_call->generateShipdelight($value);
                        $get_value[] = $xb_value;
                        
                break;
    
                 case 7:   // Smartship//    
    
                        //  $post = array('username' =>'finance@heebs.com', 'password'=>'686852e4b456193680ded782274a57fc','client_id' =>'WIU7XKIS4H7W7322KBLGS','client_secret'=>'8OUX4%0I85Y24H6$T6OS^' , 'grant_type' =>'password');
                        // $json = json_encode($post);
                        // $url = 'http://oauth.smartship.in/loginToken.php';
                        // $ch = curl_init();
                        // curl_setopt($ch, CURLOPT_URL, $url);
                        // curl_setopt($ch, CURLOPT_POST, true);
                        // curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
                        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                        // curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                        // $curl_exicute = curl_exec($ch);  
                        // $decodedata = json_decode($curl_exicute, true);
                        // curl_close($ch);
                        
                        $xb_value = $api_call->generateSmartship($value);
                        $get_value[] = $xb_value;
    
                        
                break;
                
                case 8:
                    $url = "https://apigateway.bluedart.com/in/transportation/token/v1/login";

                    $curl = curl_init($url);
                    curl_setopt($curl, CURLOPT_URL, $url);
                    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                    
                    $headers = array(
                    "ClientID: IIbLPYByHXhToj3qetfR7b7jRxgB59kM",
                          "clientSecret: YbL9nwZZaRzLdQMk",
                    //   "ClientID: Fgc2iCdompSUtzpxdmEnGbGkhjRJG6ex",
                    //       "clientSecret: fTu05JRg0JWDZiJi",
                    );
                    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                    $resp = curl_exec($curl);
                    $result = json_decode($resp);
                    //echo "<pre>"; print_r($result); die;
                    $access_token = $result->JWTToken;
                    $awbcall = new CallAwbService1();
                    $bluedart = $awbcall->getCallAwbServicegenerate($value,$access_token);
                    $get_value[] = $bluedart;
                break;
                
                case 9: 
                    $xb_value = $api_call->generateSmartr($value);
                    $get_value[] = $xb_value;
                break;
                
                case 10:   // shipdelight//    
    
                        $xb_value = $api_call->generateIthink($value);
                        $get_value[] = $xb_value;
                        
                        
                case 11:   // Rapidsyp//    
    
                
                        
                        $xb_value = $api_call->generateRapidsyp($value);
                        $get_value[] = $xb_value;
    
                        
                break;
                
                
                case 12:   // shiprocket// 
                        $shiping_id = $value['it_easy_shipping_id'];
                        $url = "https://apiv2.shiprocket.in/v1/external/auth/login";

                        $curl = curl_init($url);
                        curl_setopt($curl, CURLOPT_URL, $url);
                        curl_setopt($curl, CURLOPT_POST, true);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                        
                        $headers = array(
                           "Content-Type: application/json",
                        );
                        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                        
                        $data['email'] = "sunil@spunkads.com";
                        $data['password'] = 'L!z7$SxNDtHxp*9cCRq6yQZ6fJ$Oc#ni';
                        
                        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
                        
                        
                        $resp = curl_exec($curl);
                        $decodedata = json_decode($resp, true);
                        // echo "<pre>"; print_r($decodedata); die;
                        curl_close($curl);          
                       // $token = '4c748c367699c5f8b99f0c8ab28ca560da07b02b';
                        $xb_value = $api_call->generateShiprocket($value,$shiping_id,$decodedata['token']);
                        // $xb_value = $api_call->getSmartship($value,$shiping_id,$token);
                        $get_value[] = $xb_value;
                        
                break;
                
                
                case 13:   // pickndel//    
    
                       
                        
                        $xb_value = $api_call->generatePickndel($value);
                        $get_value[] = $xb_value;
    
                        
                break;
                
                case 14:   // Professional//
                        $xb_value = $api_call->generateSmartship($value);
                        $get_value[] = $xb_value;
    
                        
                break;
                
                case 15:   // Blitz//    

                        $xb_value = $api_call->generateSmartship($value);
                        $get_value[] = $xb_value;
    
                        
                break;
                
                case 16:   // DTDC//    

                        $xb_value = $api_call->generateDtdc($value);
                        $get_value[] = $xb_value;
    
                        
                break;
                
                case 19:   // Quickshift//    

                        $xb_value = $api_call->generateQuickshift($value);
                        $get_value[] = $xb_value;
    
                        
                break;
                
                case 17:   // Prozo//    

                        $xb_value = $api_call->generateProzo($value);
                        $get_value[] = $xb_value;
    
                        
                break;
                
                case 20:   // Ekart//    

                        $xb_value = $api_call->generateEkart($value);
                        $get_value[] = $xb_value;
    
                        
                break;
                
                case 21:   // Urbanbolt//    

                        $xb_value = $api_call->generateUrbanbolt($value);
                        $get_value[] = $xb_value;
    
                        
                break;
                
                case 22:   // Delhivery one//   
                       
                        $delhivery = $api_call->generateDelhiVeryOne($value);
                        $get_value[] = $delhivery;
                break;
                
                
                 case 23:   // Zippy Delhivery//    

                        $zippy_value = $api_call->generateZippy($value);
                        $get_value[] = $zippy_value;
    
                        
                break;
                
                
                 case 25:   // Zippy ATS //    

                        $zippy_value = $api_call->generateZippy($value);
                        $get_value[] = $zippy_value;
    
                        
                break;
                
                case 26:   // Zippy Dtdc//    

                        $zippy_value = $api_call->generateZippy($value);
                        $get_value[] = $zippy_value;
    
                        
                break;
                
                 case 27:   // Zippy Ekart//    

                        $zippy_value = $api_call->generateZippy($value);
                        $get_value[] = $zippy_value;
    
                        
                break;
                  case 28:   // Zippy Ekart//    

                        $zippy_value = $api_call->generateZippy($value);
                        $get_value[] = $zippy_value;
    
                        
                break;
                
                 //  case 24:   // Nimbus n//    

                //         $nimbus_value = $api_call->generateNimbus($value);
                //         $get_value[] = $nimbus_value;
    
                        
                // break;
                
                        
                break;  

            } 
         }
            $param = json_encode($get_value);
            Yii::$app->response->redirect(['order-dispatch/responce','params' => $param]);
  	}
   	}


    public function actionResponce()
    {   
            $params = json_decode(Yii::$app->request->queryParams['params']);
            $dataProvider = $params;
            $provider = new ArrayDataProvider([
            'allModels' => $dataProvider,
            ]);
            return $this->render('responce', [
                'dataProvider' => $provider,
                
            ]);
    }

    public function actionCancel(){
            if (Yii::$app->request->post()){
            $model = ItEasyOrder::find()->where(['it_easy_order_id'=>$_REQUEST['ItEasyOrder']['it_easy_order_id']])->One();
                date_default_timezone_set('Asia/kolkata');
                $currentDateTime = date('Y-m-d H:i:s');
                $model->it_easy_order_status_id = $_REQUEST['ItEasyOrder']['it_easy_order_status_id'];
                $model->updated_by  = Yii::$app->user->identity->id;
                $model->it_easy_updated_time  = $currentDateTime;
                $model->save(false);
                // save status history data here
                ItEasyOrder::addOrderStatusHistory($_REQUEST['ItEasyOrder']['it_easy_order_id'],$_REQUEST['ItEasyOrder']['it_easy_order_status_id'],$_REQUEST['ItEasyOrder']['it_easy_comment']);
                Yii::$app->session->setFlash('success', "Order History cancelled successfully");
                return $this->redirect(['assign']);
            }
    }

        public function actionReturn(){
           
            if (Yii::$app->request->post()){
            $model = ItEasyOrder::find()->where(['it_easy_order_id'=>$_REQUEST['ItEasyOrder']['it_easy_order_id']])->One();
                date_default_timezone_set('Asia/kolkata');
                $currentDateTime = date('Y-m-d H:i:s');
                $model->it_easy_order_status_id = $_REQUEST['ItEasyOrder']['it_easy_order_status_id'];
                $model->updated_by  = Yii::$app->user->identity->id;
                $model->it_easy_updated_time  = $currentDateTime;
                $model->save(false);
                // save status history data here
                ItEasyOrder::addOrderStatusHistory($_REQUEST['ItEasyOrder']['it_easy_order_id'],$_REQUEST['ItEasyOrder']['it_easy_order_status_id'],$_REQUEST['ItEasyOrder']['it_easy_comment']);
                Yii::$app->session->setFlash('success', "Order History Returned successfully");
                return $this->redirect(['assign']);
            }
    }
  
          public function actionViewprintlabel(){
            $this->layout = false;
            $model = new ItEasyOrder();
             $order_id = json_decode(Yii::$app->request->queryParams['params']);
             $get_label_print = $model->GetlabelData1($order_id);
            //  
             
             return $this->render('printlabel3', [
                'params' => $get_label_print
            ]);

        }
        
        public function actionViewprintlabel2(){
            $this->layout = false;
            $model = new ItEasyOrder();
            if (isset(Yii::$app->request->queryParams['params'])) {
        $order_id = json_decode(Yii::$app->request->queryParams['params']);
    } else {
       echo "order id not provide";
    }

           $order_id = 468440;
             $get_label_print = $model->GetlabelData1($order_id);
          
            //  
             
             return $this->render('printlabel3', [
                'params' => $get_label_print
            ]);

        }
        
        public function actionUpdatelabelPrintstatus(){
            $order_id = $_REQUEST['order_id'];
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');
            ItEasyOrderDispatch::updateAll(['it_easy_label_generated' =>'1', 'it_easy_label_time' => $currentDateTime],['and', ['IN','it_easy_order_id',$order_id], ['it_easy_label_generated' => '0'] ]);
        }


            public function actionPrintInvoice(){
            $this->layout = false;
            $model = new ItEasyOrder();
             $order_id = json_decode(Yii::$app->request->queryParams['params']);
             $get_invoice_data = $model->GetInvoiceData($order_id);
            //  return $this->render('invoice3', [
            //     'params' => $get_invoice_data,
            // ]);
             return $this->render('invoice4', [
                'params' => $get_invoice_data,
            ]);

        }
        
         public function actionPrintInvoice21(){
            $this->layout = false;
            $model = new ItEasyOrder();
             $order_id = 485820;
             $get_invoice_data = $model->GetInvoiceData($order_id);
            //  echo "<pre>";
            //  print_r($get_invoice_data);die;
             return $this->render('invoice2', [
                'params' => $get_invoice_data,
            ]);

        }
        
        public function actionGenerateOrderManifest(){
            $this->layout = false;
            $model = new ItEasyOrder();
             $order_id = json_decode(Yii::$app->request->queryParams['params']);
             $get_order_manifest = $model->GetOrderManifestData($order_id);
             return $this->render('order_manifest', [
                'get_order_manifest' => $get_order_manifest,
            ]);

        }
  
    public function actionExport()
    {   
         set_time_limit(0);
  	    ini_set('max_execution_time', 0);
  	    ini_set("memory_limit", "-1");
        $searchModel = new ItEasyOrderSearch();
        $query = $searchModel->manifestexport($this->request->queryParams);
        // echo $query->createCommand()->getRawSql(); die;
        $data_fetch = $query->asArray()->all();
  
        $array = []; 
        $r = 0;
        foreach ($data_fetch as $key1 => $value1) {
            $product = ItEasyOrder::GrtOrderProducts($value1['order_id']);
            $counpon_data = ItEasyCoupon::findOne(['it_easy_id' => $value1['it_easy_coupon_id']]);
            if(empty($counpon_data)){
                $discount = '0';
            }else{
                $discount = $counpon_data->it_easy_discount;
            }
            foreach ($product as $key => $value) {
                if($key  == 0){
                    $array[$r] =$value1;
                    $array[$r]['coupon_value'] = $discount;
                    $array[$r]['variation_name'] =$value['it_easy_variation_name'];
                    $array[$r]['product_name'] =$value['it_easy_product_name'];
                    $array[$r]['quantity'] =$value['it_easy_product_quantity'];
                    $array[$r]['without_GST'] =$value['it_easy_product_price'];
                    $array[$r]['product_total_price'] =$value['it_easy_product_total'];
                    $array[$r]['product_tax'] =$value['it_easy_product_tax'];

                }else{
                    $array[$r]['order_number'] = '';
                    $array[$r]['coupon_value'] = '';
                    $array[$r]['other_order_id'] = '';
                    $array[$r]['invoice_number'] = '';
                    $array[$r]['order_type'] = '';
                    
                  	$array[$r]['awb_number'] = '';
                  	$array[$r]['courier_name'] = '';
                    $array[$r]['total_price'] = '';
                    $array[$r]['GST_Price'] = '';
                    $array[$r]['First_Status'] = '';
                    $array[$r]['Status_Name'] = $value1['Status_Name'];
                    $array[$r]['Disposition_Name'] = '';
                    $array[$r]['customer'] = '';
                    //$array[$r]['mobile_number'] = '';
                    $array[$r]['Address_1'] = '';
                    $array[$r]['Address_2'] = '';
                    $array[$r]['City'] = '';
                    $array[$r]['State'] = '';
                    $array[$r]['Pincode'] = '';
                    $array[$r]['TL_username'] = '';
                    $array[$r]['Agent_Username'] = '';
                    $array[$r]['Marketer_Publisher'] = '';
                    $array[$r]['Click_ID'] = '';
                    $array[$r]['Created_Time'] = '';
                    $array[$r]['Updated_Time'] = '';
                    $array[$r]['Assigned_Time'] = '';
                    $array[$r]['Placed_Time'] = '';
                    $array[$r]['Confirmation_Time'] = '';
                    $array[$r]['variation_name'] =$value['it_easy_variation_name'];
                    $array[$r]['product_name'] =$value['it_easy_product_name'];
                    $array[$r]['quantity'] =$value['it_easy_product_quantity'];
                    $array[$r]['without_GST'] =$value['it_easy_product_price'];
                    $array[$r]['product_total_price'] =$value['it_easy_product_total'];
                    $array[$r]['product_tax'] =$value['it_easy_product_tax'];
                    
                }
                

                $r++;
            }
         }
        // echo "<pre>";print_r($array);die;
        if(Yii::$app->user->identity->it_easy_dept_id == '8'){
            $exporter = new Spreadsheet([
                'dataProvider' => new ArrayDataProvider([
                    'allModels' => $array,
                ]),
                'columns' => [
                    [   'attribute' => 'order_number'],
                    [   'attribute' => 'other_order_id'],
                    [   'attribute' => 'invoice_number'],
                    [   'attribute' => 'order_type'],
                  	[   'attribute' => 'courier_name'],
                  	[   'attribute' => 'awb_number'],
                    [   'attribute' => 'total_price'],
                    [   'attribute' => 'GST_Price'],
                    [   'attribute' => 'First_Status'],
                    [   'attribute' => 'Status_Name'],
                    [   'attribute' => 'Disposition_Name'],
                    [   'attribute' => 'customer'],
                    [   'attribute' => 'customer_email'],
                    //[   'attribute' => 'mobile_number'],
                    [   'attribute' => 'Address_1'],
                    [   'attribute' => 'Address_2'],
                    [   'attribute' => 'City'],
                    [   'attribute' => 'State'],
                    [   'attribute' => 'Pincode'],
                    [   'attribute' => 'TL_username'],
                    [   'attribute' => 'Agent_Username'],
                    [   'attribute' => 'Marketer_Publisher'],
                    [   'attribute' => 'Click_ID'],
                    [   'attribute' => 'Created_Time'],
                    [   'attribute' => 'Updated_Time'],
                    [   'attribute' => 'Assigned_Time'],
                    [   'attribute' => 'Confirmation_Time'],
                    [   'attribute' => 'product_name'],
                    [   'attribute' => 'variation_name'],
                    [   'attribute' => 'quantity'],
                    [   'attribute' => 'without_GST'],
                    [   'attribute' => 'product_tax'],
                    [   'attribute' => 'product_total_price'],
                    [   'attribute' => 'coupon_value'],
               
                ],
            ]);
        }else{
            $exporter = new Spreadsheet([
                'dataProvider' => new ArrayDataProvider([
                    'allModels' => $array,
                ]),
                'columns' => [
                    [   'attribute' => 'order_number'],
                    [   'attribute' => 'other_order_id'],
                    [   'attribute' => 'invoice_number'],
                    [   'attribute' => 'order_type'],
                  	[   'attribute' => 'courier_name'],
                  	[   'attribute' => 'awb_number'],
                    [   'attribute' => 'total_price'],
                    [   'attribute' => 'GST_Price'],
                    [   'attribute' => 'First_Status'],
                    [   'attribute' => 'Status_Name'],
                    [   'attribute' => 'Disposition_Name'],
                    [   'attribute' => 'customer'],
                    [   'attribute' => 'Address_1'],
                    [   'attribute' => 'Address_2'],
                    [   'attribute' => 'City'],
                    [   'attribute' => 'State'],
                    [   'attribute' => 'Pincode'],
                    [   'attribute' => 'TL_username'],
                    [   'attribute' => 'Agent_Username'],
                    [   'attribute' => 'Marketer_Publisher'],
                    [   'attribute' => 'Click_ID'],
                    [   'attribute' => 'Created_Time'],
                    [   'attribute' => 'Updated_Time'],
                    [   'attribute' => 'Assigned_Time'],
                    [   'attribute' => 'Confirmation_Time'],
                    [   'attribute' => 'product_name'],
                    [   'attribute' => 'variation_name'],
                    [   'attribute' => 'quantity'],
                    [   'attribute' => 'without_GST'],
                    [   'attribute' => 'product_tax'],
                    [   'attribute' => 'product_total_price'],
                    [   'attribute' => 'coupon_value'],
               
                ],
            ]);
        }
        return $exporter->send('Order-Export.xlsx');
        
    }
    
    
    public function actionNonserviceexport()
    {   
         set_time_limit(0);
  	    ini_set('max_execution_time', 0);
  	    ini_set("memory_limit", "-1");
        $searchModel = new ItEasyOrderSearch();
        $query = $searchModel->nonserviceexport($this->request->queryParams);
        // echo $query->createCommand()->getRawSql(); die;
        $data_fetch = $query->asArray()->all();
  
        $array = []; 
        $r = 0;
        foreach ($data_fetch as $key1 => $value1) {
            $product = ItEasyOrder::GrtOrderProducts($value1['order_id']);
            $counpon_data = ItEasyCoupon::findOne(['it_easy_id' => $value1['it_easy_coupon_id']]);
            if(empty($counpon_data)){
                $discount = '0';
            }else{
                $discount = $counpon_data->it_easy_discount;
            }
            foreach ($product as $key => $value) {
                if($key  == 0){
                    $array[$r] =$value1;
                    $array[$r]['coupon_value'] = $discount;
                    $array[$r]['variation_name'] =$value['it_easy_variation_name'];
                    $array[$r]['product_name'] =$value['it_easy_product_name'];
                    $array[$r]['quantity'] =$value['it_easy_product_quantity'];
                    $array[$r]['without_GST'] =$value['it_easy_product_price'];
                    $array[$r]['product_total_price'] =$value['it_easy_product_total'];
                    $array[$r]['product_tax'] =$value['it_easy_product_tax'];

                }else{
                    $array[$r]['order_number'] = '';
                    $array[$r]['coupon_value'] = '';
                    $array[$r]['other_order_id'] = '';
                    $array[$r]['invoice_number'] = '';
                    $array[$r]['order_type'] = '';
                    
                  	$array[$r]['awb_number'] = '';
                  	$array[$r]['courier_name'] = '';
                    $array[$r]['total_price'] = '';
                    $array[$r]['GST_Price'] = '';
                    $array[$r]['First_Status'] = '';
                    $array[$r]['Status_Name'] = $value1['Status_Name'];
                    $array[$r]['Disposition_Name'] = '';
                    $array[$r]['customer'] = '';
                    //$array[$r]['mobile_number'] = '';
                    $array[$r]['Address_1'] = '';
                    $array[$r]['Address_2'] = '';
                    $array[$r]['City'] = '';
                    $array[$r]['State'] = '';
                    $array[$r]['Pincode'] = '';
                    $array[$r]['TL_username'] = '';
                    $array[$r]['Agent_Username'] = '';
                    $array[$r]['Marketer_Publisher'] = '';
                    $array[$r]['Click_ID'] = '';
                    $array[$r]['Created_Time'] = '';
                    $array[$r]['Updated_Time'] = '';
                    $array[$r]['Assigned_Time'] = '';
                    $array[$r]['Placed_Time'] = '';
                    $array[$r]['Confirmation_Time'] = '';
                    $array[$r]['variation_name'] =$value['it_easy_variation_name'];
                    $array[$r]['product_name'] =$value['it_easy_product_name'];
                    $array[$r]['quantity'] =$value['it_easy_product_quantity'];
                    $array[$r]['without_GST'] =$value['it_easy_product_price'];
                    $array[$r]['product_total_price'] =$value['it_easy_product_total'];
                    $array[$r]['product_tax'] =$value['it_easy_product_tax'];
                    
                }
                

                $r++;
            }
         }
        // echo "<pre>";print_r($array);die;
        if(Yii::$app->user->identity->it_easy_dept_id == '8'){
            $exporter = new Spreadsheet([
                'dataProvider' => new ArrayDataProvider([
                    'allModels' => $array,
                ]),
                'columns' => [
                    [   'attribute' => 'order_number'],
                    [   'attribute' => 'other_order_id'],
                    [   'attribute' => 'invoice_number'],
                    [   'attribute' => 'order_type'],
                  	[   'attribute' => 'courier_name'],
                  	[   'attribute' => 'awb_number'],
                    [   'attribute' => 'total_price'],
                    [   'attribute' => 'GST_Price'],
                    [   'attribute' => 'First_Status'],
                    [   'attribute' => 'Status_Name'],
                    [   'attribute' => 'Disposition_Name'],
                    [   'attribute' => 'customer'],
                    [   'attribute' => 'customer_email'],
                    //[   'attribute' => 'mobile_number'],
                    [   'attribute' => 'Address_1'],
                    [   'attribute' => 'Address_2'],
                    [   'attribute' => 'City'],
                    [   'attribute' => 'State'],
                    [   'attribute' => 'Pincode'],
                    [   'attribute' => 'TL_username'],
                    [   'attribute' => 'Agent_Username'],
                    [   'attribute' => 'Marketer_Publisher'],
                    [   'attribute' => 'Click_ID'],
                    [   'attribute' => 'Created_Time'],
                    [   'attribute' => 'Updated_Time'],
                    [   'attribute' => 'Assigned_Time'],
                    [   'attribute' => 'Confirmation_Time'],
                    [   'attribute' => 'product_name'],
                    [   'attribute' => 'variation_name'],
                    [   'attribute' => 'quantity'],
                    [   'attribute' => 'without_GST'],
                    [   'attribute' => 'product_tax'],
                    [   'attribute' => 'product_total_price'],
                    [   'attribute' => 'coupon_value'],
               
                ],
            ]);
        }else{
            $exporter = new Spreadsheet([
                'dataProvider' => new ArrayDataProvider([
                    'allModels' => $array,
                ]),
                'columns' => [
                    [   'attribute' => 'order_number'],
                    [   'attribute' => 'other_order_id'],
                    [   'attribute' => 'invoice_number'],
                    [   'attribute' => 'order_type'],
                  	[   'attribute' => 'courier_name'],
                  	[   'attribute' => 'awb_number'],
                    [   'attribute' => 'total_price'],
                    [   'attribute' => 'GST_Price'],
                    [   'attribute' => 'First_Status'],
                    [   'attribute' => 'Status_Name'],
                    [   'attribute' => 'Disposition_Name'],
                    [   'attribute' => 'customer'],
                    [   'attribute' => 'Address_1'],
                    [   'attribute' => 'Address_2'],
                    [   'attribute' => 'City'],
                    [   'attribute' => 'State'],
                    [   'attribute' => 'Pincode'],
                    [   'attribute' => 'TL_username'],
                    [   'attribute' => 'Agent_Username'],
                    [   'attribute' => 'Marketer_Publisher'],
                    [   'attribute' => 'Click_ID'],
                    [   'attribute' => 'Created_Time'],
                    [   'attribute' => 'Updated_Time'],
                    [   'attribute' => 'Assigned_Time'],
                    [   'attribute' => 'Confirmation_Time'],
                    [   'attribute' => 'product_name'],
                    [   'attribute' => 'variation_name'],
                    [   'attribute' => 'quantity'],
                    [   'attribute' => 'without_GST'],
                    [   'attribute' => 'product_tax'],
                    [   'attribute' => 'product_total_price'],
                    [   'attribute' => 'coupon_value'],
               
                ],
            ]);
        }
        return $exporter->send('Order-Export.xlsx');
        
    }
    
    
    public function actionSalesforceexport()
    {   
         set_time_limit(0);
  	    ini_set('max_execution_time', 0);
  	    ini_set("memory_limit", "-1");
        $searchModel = new ItEasyOrderSearch();
        $query = $searchModel->salesforceexport($this->request->queryParams);
        // echo $query->createCommand()->getRawSql(); die;
        $data_fetch = $query->asArray()->all();
  
        $array = []; 
        $r = 0;
        foreach ($data_fetch as $key1 => $value1) {
            $product = ItEasyOrder::GrtOrderProducts($value1['order_id']);
            foreach ($product as $key => $value) {
                    $array[$r]['order_number'] = $value1['order_number'];
                    $array[$r]['shopify_order_number'] = str_replace('s', '',$value1['shopify_order_number']); 
                    $product_shopify = ItEasyProductVariation::find()->where(['it_easy_product_id' => $value['it_easy_product_id'] ])->andWhere(['it_easy_variation_id' => $value['it_easy_variation_id']])->one();
                    // echo "<pre>"; print_r($product_shopify); die;
                    if(!empty($product_shopify)){
                        $array[$r]['shopify_variant_id'] = $product_shopify->shopify_veriant_id;
                    }else{
                        $array[$r]['shopify_variant_id'] = '';
                    }
                    $array[$r]['account_name'] = $value1['account_name'];
                    $array[$r]['status'] = $value1['Status_Name'];
                    if($value1['payment_method'] == 'COD'){
                        $payment_method= 'COD';
                        $collectable = $value1['total_price'] ;
                    }else{
                        $collectable = '0';
                        $payment_method= 'Online';
                    }
                    $array[$r]['total_collectable_amount'] = $collectable;
                    $array[$r]['total_price'] = $value1['total_price'];
                    $array[$r]['shipping_State'] = $value1['shipping_State'];
                    $array[$r]['shipping_Pincode'] = $value1['shipping_Pincode'];
                    $array[$r]['shipping_Address_1'] = $value1['shipping_Address_1'];
                    $array[$r]['shipping_Address_2'] = $value1['shipping_Address_2'];
                    $array[$r]['shipping_City'] = $value1['shipping_City'];
                    $array[$r]['Aaccount_owner_name'] = $value1['Aaccount_owner_name'];
                    $array[$r]['product_Variant_name'] = $value['it_easy_product_name']." ".$value['it_easy_variation_name'];
                    $array[$r]['quantity'] = $value['it_easy_product_quantity'];
                    $array[$r]['product_price'] = $value['it_easy_product_total'];
                    $array[$r]['disposition_reason'] = $value1['Disposition_reason'];
                    $array[$r]['state'] = $value1['shipping_State'];
                    $array[$r]['payment_method'] = $payment_method;
                    $array[$r]['Order_Confirmed_date'] = $value1['Order_Confirmed_date'];
                    $array[$r]['courier_name'] = $value1['courier_name'];
                    $array[$r]['awb_number'] = $value1['awb_number'];
                $r++;
            }
         }
        // echo "<pre>";print_r($array);die;
        if(Yii::$app->user->identity->it_easy_dept_id == '8'){
            $exporter = new Spreadsheet([
                'dataProvider' => new ArrayDataProvider([
                    'allModels' => $array,
                ]),
                'columns' => [
                    [   'attribute' => 'order_number'],
                    [   'attribute' => 'shopify_order_number'],
                    [   'attribute' => 'shopify_variant_id'],
                    [   'attribute' => 'account_name'],
                  	[   'attribute' => 'status'],
                  	[   'attribute' => 'total_collectable_amount'],
                    [   'attribute' => 'total_price'],
                    [   'attribute' => 'shipping_State'],
                    [   'attribute' => 'shipping_Pincode'],
                    [   'attribute' => 'Status_Name'],
                    [   'attribute' => 'shipping_Address_1'],
                    [   'attribute' => 'shipping_Address_2'],
                    [   'attribute' => 'shipping_City'],
                    [   'attribute' => 'Aaccount_owner_name'],
                    [   'attribute' => 'product_Variant_name'],
                    [   'attribute' => 'quantity'],
                    [   'attribute' => 'product_price'],
                    [   'attribute' => 'disposition_reason'],
                    [   'attribute' => 'state'],
                    [   'attribute' => 'payment_method'],
                    [   'attribute' => 'Order_Confirmed_date'],
                    [   'attribute' => 'courier_name'],
                    [   'attribute' => 'awb_number'],
               
                ],
            ]);
        }else{
            $exporter = new Spreadsheet([
                'dataProvider' => new ArrayDataProvider([
                    'allModels' => $array,
                ]),
                'columns' => [
                    [   'attribute' => 'order_number'],
                    [   'attribute' => 'shopify_order_number'],
                    [   'attribute' => 'shopify_variant_id'],
                    [   'attribute' => 'account_name'],
                  	[   'attribute' => 'status'],
                  	[   'attribute' => 'total_collectable_amount'],
                    [   'attribute' => 'total_price'],
                    [   'attribute' => 'shipping_State'],
                    [   'attribute' => 'shipping_Pincode'],
                    [   'attribute' => 'Status_Name'],
                    [   'attribute' => 'shipping_Address_1'],
                    [   'attribute' => 'shipping_Address_2'],
                    [   'attribute' => 'shipping_City'],
                    [   'attribute' => 'Aaccount_owner_name'],
                    [   'attribute' => 'product_Variant_name'],
                    [   'attribute' => 'quantity'],
                    [   'attribute' => 'product_price'],
                    [   'attribute' => 'disposition_reason'],
                    [   'attribute' => 'state'],
                    [   'attribute' => 'payment_method'],
                    [   'attribute' => 'Order_Confirmed_date'],
                    [   'attribute' => 'courier_name'],
                    [   'attribute' => 'awb_number'],
               
                ],
            ]);
        }
        return $exporter->send('Order-Export.xlsx');
        
    }
    
    public function actionTest(){
          $api_call = new ApiCall();
        $api_call->test(350166,'gen_awb');
        
    }
    
}
