<?php

namespace backend\controllers;

use Yii;
use backend\models\ApiCall;
use backend\models\ItEasyOrderSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use backend\models\ItEasyOrder;
use yii\helpers\ArrayHelper;
use yii\data\ArrayDataProvider;
use backend\models\ItEasyState;
use backend\models\ItEasyOrderDispatch;
use yii2tech\spreadsheet\Spreadsheet;
/**
 * UserTypeController implements the CRUD actions for ItEasyUserType model.
 */
class OrderDispatchController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyUserType models.
     *
     * @return string
     */
  
  
    public function actionAssign()
    {   
        $model = new ItEasyOrder();
        $searchModel = new ItEasyOrderSearch();
        $dataProvider = $searchModel->search2($this->request->queryParams);
      	$order_status_list = ItEasyOrder::getAHelperOrderStatusForAgent();
        $order_statusdata = ArrayHelper::map($order_status_list, 'it_easy_order_status_id', 'it_easy_order_status_name');
		$payemntmethod_list_data = ItEasyOrder::getAHelperPaymentMethod();
		$array_helper_courier = ItEasyOrder::ArrayHelperCourierData();
        $payment_method = ArrayHelper::map($payemntmethod_list_data, 'it_easy_method_code', 'it_easy_method_name' );
      	$dataProvider->pagination->pageSize = 100;
        return $this->render('assign', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'model'=>$model,
          	'order_statusdata' => $order_statusdata,
          	'payment_method' => $payment_method,
          	'array_helper_courier' => $array_helper_courier
          	
        ]);
    }
  
  
  	public function actionManifest()
    {   
        $model = new ItEasyOrder();
        $searchModel = new ItEasyOrderSearch();
        $dataProvider = $searchModel->search2($this->request->queryParams);
        
        $order_counts = $searchModel->getordermanifest3($this->request->queryParams);
        // 
        $dataProvider->pagination->pageSize = 100;
      	$order_status_list = ItEasyOrder::getAHelperOrderStatusForAgent();
      	$array_helper_courier = ItEasyOrder::ArrayHelperCourierData();
        $order_statusdata = ArrayHelper::map($order_status_list, 'it_easy_order_status_id', 'it_easy_order_status_name');
		$payemntmethod_list_data = ItEasyOrder::getAHelperPaymentMethod();
        $payment_method = ArrayHelper::map($payemntmethod_list_data, 'it_easy_method_code', 'it_easy_method_name' );
      	$stateList = ItEasyState::getStateallData();
        $statedata = ArrayHelper::map($stateList, 'it_easy_id', 'it_easy_state_name');
        return $this->render('manifest', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'model'=>$model,
          	'order_statusdata' => $order_statusdata,
          	'payment_method' => $payment_method,
          	'array_helper_courier' => $array_helper_courier,
          	'statedata' => $statedata, 
          	'order_counts' => $order_counts
          	
        ]);
    }
  

	public function actionRefreshApi()
    {	$get = Yii::$app->request->get();
     	if(isset($get['order_id'])){
          	$get_order_data = ItEasyOrder::find()->where(['it_easy_order_id' => $get['order_id']])->all();
        }else{
          	$get_order_data = ItEasyOrder::find()->limit(5000)->orderBy(['it_easy_order_id' => SORT_DESC])->all();
        }
        // echo "<pre>"; print_r($get_order_data); die;
     	
     	if(!empty($get_order_data)){
          foreach($get_order_data as $key => $orders){
            	$orders->it_easy_order_serviceable = ItEasyOrder::getServicealAPIbyPincode($orders->it_easy_pincode);
            // 	echo "<pre>"; print_r($orders); die;
            	$orders->save(false);
          }
        }
     	Yii::$app->session->setFlash('success', 'Your Serviceable api has been updated successfully.');
     	return $this->redirect(Yii::$app->request->referrer);
    }
  
  
    public function actionGetApiname(){
        $model = new ItEasyOrder();
        $api_call = new ApiCall();
        $shiping_id = Yii::$app->request->post()['ItEasyOrder']['it_easy_ship_id'];
        $order_seletion = Yii::$app->request->post()['selection'];
        $get_order_data =  ItEasyOrder::find()->asArray()->where(['in', 'it_easy_order_id', $order_seletion])->All();
        $get_value = [];
         foreach ($get_order_data as $value) {
            
            switch($shiping_id) {
            case 1:   // Delhivery//   
                   
                    $delhivery = $api_call->getDelhiVery($value,$shiping_id);
                    $get_value[] = $delhivery;
            break;
            case 2:   // EcomExpress//   
                   
                    $ecom = $api_call->getEcomExpress($value,$shiping_id);
                    $get_value[] = $ecom;   
            break;

            case 6:   // EcomExpress AIR//   
                   
                    $ecom = $api_call->getEcomExpress($value,$shiping_id);
                    $get_value[] = $ecom;   
            break;

            case 3:   // Xpressbees//    

                    $xb_value = $api_call->getXpressbees($value,$shiping_id);
                    $get_value[] = $xb_value;
                    
            break;
              
            case 4:   // shipdelight//    

                    $xb_value = $api_call->getShipdelight($value,$shiping_id);
                    $get_value[] = $xb_value;
                    
            break;  

                } 
         }
            $param = json_encode($get_value);
            Yii::$app->response->redirect(['order-dispatch/responce','params' => $param]);
   	}
  
  
  	public function actionGenerateManifest(){
  	    set_time_limit(0);
  	    ini_set('max_execution_time', 0);
  	    ini_set("memory_limit", "-1");
        $model = new ItEasyOrder();
        $api_call = new ApiCall();
        if(!empty(Yii::$app->request->post()['selection'])){
        $order_seletion = Yii::$app->request->post()['selection'];
        $get_order_data =  ItEasyOrderDispatch::find()->asArray()->where(['in', 'it_easy_order_id', $order_seletion])->All();
        $get_value = [];
         foreach ($get_order_data as $value) {
            
            switch($value['it_easy_shipping_id']) {
            case 1:   // Delhivery//   
                   
                    $delhivery = $api_call->generateDelhiVery($value);
                    $get_value[] = $delhivery;
            break;
            case 2:   // EcomExpress//   
                   
                    $ecom = $api_call->generateEcomExpress($value);
                    $get_value[] = $ecom;   
            break;

            case 6:   // EcomExpress AIR//   
                   
                    $ecom = $api_call->generateEcomExpress($value);
                    $get_value[] = $ecom;   
            break;

            case 3:   // Xpressbees//    

                    $xb_value = $api_call->generateXpressbees($value);
                    $get_value[] = $xb_value;
                    
            break;
              
            case 4:   // shipdelight//    

                    $xb_value = $api_call->generateShipdelight($value);
                    $get_value[] = $xb_value;
                    
            break;  
            
            case 5:   // indiapost//    

                    $xb_value = $api_call->generateShipdelight($value);
                    $get_value[] = $xb_value;
                    
            break;  

                } 
         }
            $param = json_encode($get_value);
            Yii::$app->response->redirect(['order-dispatch/responce','params' => $param]);
  	}
   	}


    public function actionResponce()
    {   
            $params = json_decode(Yii::$app->request->queryParams['params']);
            $dataProvider = $params;
            $provider = new ArrayDataProvider([
            'allModels' => $dataProvider,
            ]);
            return $this->render('responce', [
                'dataProvider' => $provider,
                
            ]);
    }

    public function actionCancel(){
            if (Yii::$app->request->post()){
            $model = ItEasyOrder::find()->where(['it_easy_order_id'=>$_REQUEST['ItEasyOrder']['it_easy_order_id']])->One();
                date_default_timezone_set('Asia/kolkata');
                $currentDateTime = date('Y-m-d H:i:s');
                $model->it_easy_order_status_id = $_REQUEST['ItEasyOrder']['it_easy_order_status_id'];
                $model->updated_by  = Yii::$app->user->identity->id;
                $model->it_easy_updated_time  = $currentDateTime;
                $model->save(false);
                // save status history data here
                ItEasyOrder::addOrderStatusHistory($_REQUEST['ItEasyOrder']['it_easy_order_id'],$_REQUEST['ItEasyOrder']['it_easy_order_status_id'],$_REQUEST['ItEasyOrder']['it_easy_comment']);
                Yii::$app->session->setFlash('success', "Order History cancelled successfully");
                return $this->redirect(['assign']);
            }
    }

        public function actionReturn(){
           
            if (Yii::$app->request->post()){
            $model = ItEasyOrder::find()->where(['it_easy_order_id'=>$_REQUEST['ItEasyOrder']['it_easy_order_id']])->One();
                date_default_timezone_set('Asia/kolkata');
                $currentDateTime = date('Y-m-d H:i:s');
                $model->it_easy_order_status_id = $_REQUEST['ItEasyOrder']['it_easy_order_status_id'];
                $model->updated_by  = Yii::$app->user->identity->id;
                $model->it_easy_updated_time  = $currentDateTime;
                $model->save(false);
                // save status history data here
                ItEasyOrder::addOrderStatusHistory($_REQUEST['ItEasyOrder']['it_easy_order_id'],$_REQUEST['ItEasyOrder']['it_easy_order_status_id'],$_REQUEST['ItEasyOrder']['it_easy_comment']);
                Yii::$app->session->setFlash('success', "Order History Returned successfully");
                return $this->redirect(['assign']);
            }
    }
  
          public function actionViewprintlabel(){
            $this->layout = false;
            $model = new ItEasyOrder();
             $order_id = json_decode(Yii::$app->request->queryParams['params']);
             $get_label_print = $model->GetlabelData($order_id);
             return $this->render('printlabel', [
                'params' => $get_label_print,
            ]);

        }
        
        public function actionUpdatelabelPrintstatus(){
            $order_id = $_REQUEST['order_id'];
            ItEasyOrderDispatch::updateAll(['it_easy_label_generated' =>'1'],['IN','it_easy_order_id',$order_id]);
        }


            public function actionPrintInvoice(){
            $this->layout = false;
            $model = new ItEasyOrder();
             $order_id = json_decode(Yii::$app->request->queryParams['params']);
             $get_invoice_data = $model->GetInvoiceData($order_id);
             return $this->render('invoice', [
                'params' => $get_invoice_data,
            ]);

        }
        
           public function actionGenerateOrderManifest(){
            $this->layout = false;
            $model = new ItEasyOrder();
             $order_id = json_decode(Yii::$app->request->queryParams['params']);
             $get_order_manifest = $model->GetOrderManifestData($order_id);
             return $this->render('order_manifest', [
                'get_order_manifest' => $get_order_manifest,
            ]);

        }
  
         public function actionExport()
    {   
  
        $searchModel = new ItEasyOrderSearch();
        $query = $searchModel->manifestexport($this->request->queryParams);
        $data_fetch = $query->asArray()->all();
  
        $array = []; 
        $r = 0;
        foreach ($data_fetch as $key1 => $value1) {
            $product = ItEasyOrder::GrtOrderProducts($value1['order_id']);
            foreach ($product as $key => $value) {
                if($key  == 0){
                    $array[$r] =$value1;
                    $array[$r]['variation_name'] =$value['it_easy_variation_name'];
                    $array[$r]['product_name'] =$value['it_easy_product_name'];
                    $array[$r]['quantity'] =$value['it_easy_product_quantity'];
                    $array[$r]['without_GST'] =$value['it_easy_product_price'];
                    $array[$r]['product_total_price'] =$value['it_easy_product_total'];
                    $array[$r]['product_tax'] =$value['it_easy_product_tax'];

                }else{
                    $array[$r]['order_number'] = '';
                    $array[$r]['other_order_id'] = '';
                    $array[$r]['invoice_number'] = '';
                    $array[$r]['order_type'] = '';
                    
                  	$array[$r]['awb_number'] = '';
                  	$array[$r]['courier_name'] = '';
                    $array[$r]['total_price'] = '';
                    $array[$r]['GST_Price'] = '';
                    $array[$r]['First_Status'] = '';
                    $array[$r]['Status_Name'] = '';
                    $array[$r]['Disposition_Name'] = '';
                    $array[$r]['customer'] = '';
                    $array[$r]['mobile_number'] = '';
                    $array[$r]['Address_1'] = '';
                    $array[$r]['Address_2'] = '';
                    $array[$r]['City'] = '';
                    $array[$r]['State'] = '';
                    $array[$r]['Pincode'] = '';
                    $array[$r]['TL_username'] = '';
                    $array[$r]['Agent_Username'] = '';
                    $array[$r]['Marketer_Publisher'] = '';
                    $array[$r]['Click_ID'] = '';
                    $array[$r]['Created_Time'] = '';
                    $array[$r]['Updated_Time'] = '';
                    $array[$r]['Assigned_Time'] = '';
                    $array[$r]['Placed_Time'] = '';
                    $array[$r]['Confirmation_Time'] = '';
                    $array[$r]['variation_name'] =$value['it_easy_variation_name'];
                    $array[$r]['product_name'] =$value['it_easy_product_name'];
                    $array[$r]['quantity'] =$value['it_easy_product_quantity'];
                    $array[$r]['without_GST'] =$value['it_easy_product_price'];
                    $array[$r]['product_total_price'] =$value['it_easy_product_total'];
                    $array[$r]['product_tax'] =$value['it_easy_product_tax'];
                }

                $r++;
            }
         }
        // echo "<pre>";print_r($array);die;
        $exporter = new Spreadsheet([
            'dataProvider' => new ArrayDataProvider([
                'allModels' => $array,
            ]),
            'columns' => [
                [   'attribute' => 'order_number'],
                [   'attribute' => 'other_order_id'],
                [   'attribute' => 'invoice_number'],
                [   'attribute' => 'order_type'],
              	[   'attribute' => 'courier_name'],
              	[   'attribute' => 'awb_number'],
                [   'attribute' => 'total_price'],
                [   'attribute' => 'GST_Price'],
                [   'attribute' => 'First_Status'],
                [   'attribute' => 'Status_Name'],
                [   'attribute' => 'Disposition_Name'],
                [   'attribute' => 'customer'],
                [   'attribute' => 'mobile_number'],
                [   'attribute' => 'Address_1'],
                [   'attribute' => 'Address_2'],
                [   'attribute' => 'City'],
                [   'attribute' => 'State'],
                [   'attribute' => 'Pincode'],
                [   'attribute' => 'TL_username'],
                [   'attribute' => 'Agent_Username'],
                [   'attribute' => 'Marketer_Publisher'],
                [   'attribute' => 'Click_ID'],
                [   'attribute' => 'Created_Time'],
                [   'attribute' => 'Updated_Time'],
                [   'attribute' => 'Assigned_Time'],
                [   'attribute' => 'Confirmation_Time'],
                [   'attribute' => 'product_name'],
                [   'attribute' => 'variation_name'],
                [   'attribute' => 'quantity'],
                [   'attribute' => 'without_GST'],
                [   'attribute' => 'product_tax'],
                [   'attribute' => 'product_total_price'],
           
            ],
        ]);
        return $exporter->send('Order-Export.xlsx');
        
    }
    
}
