<?php

namespace backend\controllers;

use backend\models\ItEasyOrderDisposition;
use backend\models\ItEasyOrderDispositionSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use yii\filters\AccessControl;
/**
 * OrderDispositionController implements the CRUD actions for ItEasyOrderDisposition model.
 */
class OrderDispositionController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyOrderDisposition models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyOrderDispositionSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ItEasyOrderDisposition model.
     * @param int $it_easy_order_disposition_id It Easy Order Disposition ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */

    /**
     * Creates a new ItEasyOrderDisposition model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new ItEasyOrderDisposition();

        if ($model->load(Yii::$app->request->post())) {
            $post = Yii::$app->request->post();
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d  H:i:s');
            $time = time();
            $model->created_by = Yii::$app->user->identity->id;
            $model->created_time = $currentDateTime;
             
            $model->save();

            Yii::$app->session->setFlash('success', 'Form has been created');
            return $this->redirect(['index', 'it_easy_order_disposition_id' => $model->it_easy_order_disposition_id]);
        }
        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing ItEasyOrderDisposition model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_order_disposition_id It Easy Order Disposition ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_order_disposition_id)
    {
        $model = $this->findModel($it_easy_order_disposition_id);

       
        if ($model->load(Yii::$app->request->post())) {
            $post = Yii::$app->request->post();
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');
            $time = time();
            $model->updated_by = Yii::$app->user->identity->id;
            $model->updated_time = $currentDateTime;

            $model->save();

            Yii::$app->session->setFlash('success', 'Form has been updated');
            return $this->redirect(['index', 'it_easy_order_disposition_id' => $model->it_easy_order_disposition_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing ItEasyOrderDisposition model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $it_easy_order_disposition_id It Easy Order Disposition ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */


    /**
     * Finds the ItEasyOrderDisposition model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_order_disposition_id It Easy Order Disposition ID
     * @return ItEasyOrderDisposition the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_order_disposition_id)
    {
        if (($model = ItEasyOrderDisposition::findOne(['it_easy_order_disposition_id' => $it_easy_order_disposition_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    public function actionOrderDisposition()
{
    $model = new \backend\models\ItEasyOrderDisposition();

    if ($model->load(Yii::$app->request->post())) {
        if ($model->validate()) {
            // form inputs are valid, do something here
            return;
        }
    }

    return $this->render('OrderDisposition', [
        'model' => $model,
    ]);
}
}
