<?php

namespace backend\controllers;

use backend\models\ItEasyOrderStatus;
use backend\models\ItEasyOrderStatusSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use yii\filters\AccessControl;
/**
 * OrderStatusController implements the CRUD actions for ItEasyOrderStatus model.
 */
class OrderStatusController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyOrderStatus models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyOrderStatusSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ItEasyOrderStatus model.
     * @param int $it_easy_order_status_id It Easy Order Status ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    

    /**
     * Creates a new ItEasyOrderStatus model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new ItEasyOrderStatus();

        if ($model->load(Yii::$app->request->post())) {
            $post = Yii::$app->request->post();
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d  H:i:s');
            $time = time();
            $model->created_by = Yii::$app->user->identity->id;
            $model->created_time = $currentDateTime;
             
            $model->save();

            Yii::$app->session->setFlash('success', 'Your data has been created');
            return $this->redirect(['index', 'it_easy_order_status_id' => $model->it_easy_order_status_id]);
        }
        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing ItEasyOrderStatus model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_order_status_id It Easy Order Status ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_order_status_id)
    {
        $model = $this->findModel($it_easy_order_status_id);

        if ($model->load(Yii::$app->request->post())) {
            $post = Yii::$app->request->post();
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');
            $time = time();
            $model->updated_by = Yii::$app->user->identity->id;
            $model->updated_time = $currentDateTime;

            $model->save();

            Yii::$app->session->setFlash('success', 'Your data has been updated');
            return $this->redirect(['index', 'it_easy_order_status_id' => $model->it_easy_order_status_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing ItEasyOrderStatus model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $it_easy_order_status_id It Easy Order Status ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */


    /**
     * Finds the ItEasyOrderStatus model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_order_status_id It Easy Order Status ID
     * @return ItEasyOrderStatus the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_order_status_id)
    {
        if (($model = ItEasyOrderStatus::findOne(['it_easy_order_status_id' => $it_easy_order_status_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    public function actionOrderStatus()
{
    $model = new \backend\models\ItEasyOrderStatus();

    if ($model->load(Yii::$app->request->post())) {
        if ($model->validate()) {
            // form inputs are valid, do something here
            return;
        }
    }

    return $this->render('Order-status', [
        'model' => $model,
    ]);
}
}
