<?php

namespace backend\controllers;

use Yii;
use backend\models\ApiCall;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use backend\models\ItEasyOrderVerify;
use backend\models\ItEasyOrderVerifySearch;
use backend\models\ItEasyOrder;
use yii\helpers\ArrayHelper;
use yii\data\ArrayDataProvider;
use backend\components\webhookSender;
/**
 * UserTypeController implements the CRUD actions for ItEasyUserType model.
 */
class OrderVerifyController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyUserType models.
     *
     * @return string
     */
    public function actionIndex()
    {   
        $model = new ItEasyOrderVerify();
        $searchModel = new ItEasyOrderVerifySearch();
        $dataProvider = $searchModel->search($this->request->queryParams);
        $order_status_list = ItEasyOrder::getAHelperOrderStatusForAgent();    
        $order_statusdata = ArrayHelper::map($order_status_list, 'it_easy_order_status_id', 'it_easy_order_status_name');
        $payemntmethod_list_data = ItEasyOrder::getAHelperPaymentMethod();
        $payment_method = ArrayHelper::map($payemntmethod_list_data, 'it_easy_method_code', 'it_easy_method_name' );
        $array_helper_courier = ItEasyOrder::ArrayHelperCourierData();
        $dataProvider->pagination->pageSize = 100;
        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'model'=>$model,
            'payment_method' => $payment_method,
            'order_statusdata' => $order_statusdata,
            'array_helper_courier' => $array_helper_courier
        ]);
    }


    public function actionGetOrderdata(){
                $model = new ItEasyOrderVerify();
                $order_id = $_REQUEST['order_id'];
                $model->getOrderData($order_id);
    }

      public function actionUpdateOrder()
    {
 
        $model = $this->findModel($_REQUEST['ItEasyOrderVerify']['it_easy_order_id']);
         if ($model->load(Yii::$app->request->post())){
                date_default_timezone_set('Asia/kolkata');
                $currentDateTime = date('Y-m-d H:i:s');
                $model->updated_by  = Yii::$app->user->identity->id;
                $model->it_easy_updated_time  = $currentDateTime;
                $model->save(false);
                Yii::$app->session->setFlash('success', "Your data has been saved!");
                return $this->redirect(['index']);
            }
    }

        protected function findModel($it_easy_order_id)
    {
        if (($model = ItEasyOrderVerify::findOne(['it_easy_order_id' => $it_easy_order_id])) !== null) {
            return $model;
        }

       
    }
 
    public function actionCancelOrder()
    {
 
        $model = $this->findModelcancel($_REQUEST['ItEasyOrderVerify']['it_easy_order_id']);
         if ($model->load(Yii::$app->request->post())){
                date_default_timezone_set('Asia/kolkata');
                $currentDateTime = date('Y-m-d H:i:s');
                $model->it_easy_comment = $_REQUEST['ItEasyOrderVerify']['it_easy_comment'];
                $model->it_easy_order_status_id = $_REQUEST['ItEasyOrderVerify']['it_easy_order_status_id'];
                $model->updated_by  = Yii::$app->user->identity->id;
                $model->it_easy_updated_time  = $currentDateTime;
                $model->save(false);
                Yii::$app->session->setFlash('success', "Your data has been saved!");
                return $this->redirect(['index']);
            }
    }

        protected function findModelcancel($it_easy_order_id)
    {
        if (($model = ItEasyOrderVerify::findOne(['it_easy_order_id' => $it_easy_order_id])) !== null) {
            return $model;
        }

       
    }


    public function actionVerifyOrder()
    {
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $get_all_orderid = $_REQUEST['selection'];
        if(!empty($get_all_orderid) && isset($get_all_orderid)){ 
        Yii::$app->db->createCommand()
        ->update(ItEasyOrderVerify::tableName(), ['it_easy_order_status_id' => '24','it_easy_updated_time'=>$currentDateTime], ['in', 'it_easy_order_id', $get_all_orderid])->execute();
        
        
         foreach ($get_all_orderid as $orderId) {
        $order = ItEasyOrder::findOne($orderId);

        // if ($order === null) {
        //     Yii::warning("Order ID $orderId not found.", __METHOD__);
        //     continue; // Skip this order
        // }

        $customer_name = $order->it_easy_shipping_firstname . ' ' . $order->it_easy_lastname;
        $order_id = $order->it_easy_order_id;
        $total_amount = $order->it_easy_total_price;
        $customer_phone = $order->it_easy_mobile_number;
        $stage = 'order_verified'; // Customize per use case

        // Fetch order summary
        $order_products = \backend\models\ItEasyOrderProduct::find()
            ->where(['it_easy_order_id' => $order_id])
            ->all();

        $order_summary = [];
        foreach ($order_products as $product) {
            $order_summary[] = $product->it_easy_product_name . ' (Qty: ' . $product->it_easy_product_quantity . ')';
        }

        $order_summary = implode(', ', $order_summary);

        // Send webhook
        webhookSender::sendOrderStageWebhook(
            $stage,
            $customer_name,
            $order_id,
            $order_summary,
            $total_amount,
            $customer_phone,
            $order
        );
    }//end change sunil
        
        

        Yii::$app->session->setFlash('success', "Your data has been saved!");
        return $this->redirect(['index']);

        }
    }//multiple verify order
    
    
        public function actionIndvidualVerifyOrder()
    {
        date_default_timezone_set('Asia/kolkata');
        $currentDateTime = date('Y-m-d H:i:s');
        $get_all_orderid = $_REQUEST['params'];
        if(!empty($get_all_orderid) && isset($get_all_orderid)){ 
        Yii::$app->db->createCommand()
        ->update(ItEasyOrderVerify::tableName(), ['it_easy_order_status_id' => '24','it_easy_updated_time'=>$currentDateTime], ['it_easy_order_id'=>$get_all_orderid])->execute();
        
        $order =ItEasyOrder::findOne($get_all_orderid);
    
    if ($order !== null) {
        // 3. Prepare data for WhatsApp webhook
        $customer_name = $order->it_easy_shipping_firstname . ' ' . $order->it_easy_lastname;
        $order_id = $order->it_easy_order_id;
        $total_amount = $order->it_easy_total_price;
        $customer_phone = $order->it_easy_mobile_number;
        $stage = 'order_verified'; // or whatever stage you're using

        // 4. Prepare order summary
        $order_products = \backend\models\ItEasyOrderProduct::find()
            ->where(['it_easy_order_id' => $order_id])
            ->all();

        $order_summary = [];
        foreach ($order_products as $product) {
            $order_summary[] = $product->it_easy_product_name . ' (Qty: ' . $product->it_easy_product_quantity . ')';
        }
        $order_summary = implode(', ', $order_summary);

        // 5. Send webhook via your component
        webhookSender::sendOrderStageWebhook($stage, $customer_name, $order_id, $order_summary, $total_amount, $customer_phone,$order);
    }
      
        
        Yii::$app->session->setFlash('success', "Your data has been saved!");
        return $this->redirect(['index']);

        }
    }
    
    //testign function
    
     public function actionIndvidualVerifyOrder1($params = null)
    {
        date_default_timezone_set('Asia/Kolkata');

        if (empty($params)) {
            return ['success' => false, 'message' => 'Order ID is required'];
        }

        $currentDateTime = date('Y-m-d H:i:s');

        // Update order status
        Yii::$app->db->createCommand()
            ->update(ItEasyOrderVerify::tableName(), [
                'it_easy_order_status_id' => '24',
                'it_easy_updated_time' => $currentDateTime,
            ], ['it_easy_order_id' => $params])
            ->execute();

        $order = ItEasyOrder::findOne($params);

        if (!$order) {
            return ['success' => false, 'message' => 'Order not found'];
        }

        // Prepare WhatsApp webhook data
        $customer_name = $order->it_easy_shipping_firstname . ' ' . $order->it_easy_lastname;
        $order_id = $order->it_easy_order_id;
        $total_amount = $order->it_easy_total_price;
        $customer_phone = $order->it_easy_mobile_number;
        $stage = 'order_verified';

        $order_products = \backend\models\ItEasyOrderProduct::find()
            ->where(['it_easy_order_id' => $order_id])
            ->all();

        $order_summary = [];
        foreach ($order_products as $product) {
            $order_summary[] = $product->it_easy_product_name . ' (Qty: ' . $product->it_easy_product_quantity . ')';
        }
        $order_summary = implode(', ', $order_summary);

        // Call the webhook sender
        webhookSender::sendOrderStageWebhook(
            $stage,
            $customer_name,
            $order_id,
            $order_summary,
            $total_amount,
            $customer_phone,
            $order
        );

        return [
            'success' => true,
            'message' => 'Order verified and webhook sent successfully',
            'order_id' => $order_id
        ];
    }
    
    
    
}//controller 
