<?php

namespace backend\controllers;

use backend\models\ItEasyPaymentGateway;
use backend\models\ItEasyPaymentGatewaySearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use yii\filters\AccessControl;
/**
 * PaymentGatewayController implements the CRUD actions for ItEasyPaymentGateway model.
 */
class PaymentGatewayController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyPaymentGateway models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyPaymentGatewaySearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ItEasyPaymentGateway model.
     * @param int $it_easy_id It Easy ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($it_easy_id)
    {
        return $this->render('view', [
            'model' => $this->findModel($it_easy_id),
        ]);
    }

    /**
     * Creates a new ItEasyPaymentGateway model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new ItEasyPaymentGateway();

        if ($model->load(Yii::$app->request->post())){
            $post = Yii::$app->request->post();
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');
            $time = time();
            $model->it_easy_created_by = Yii::$app->user->identity->id;
            $model->it_easy_created_time = $currentDateTime;
          
            $model->save(false);
            Yii::$app->session->setFlash('success', "Your data has been saved!");
            return $this->redirect(['index']);
    }

    return $this->render('create', [
        'model' => $model,
    ]);
    }

    /**
     * Updates an existing ItEasyPaymentGateway model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_id It Easy ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_id)
    {
        $model = $this->findModel($it_easy_id);

        if ($model->load(Yii::$app->request->post())){
            $post = Yii::$app->request->post();
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');
            $time = time();
            $model->it_easy_created_by = Yii::$app->user->identity->id;
            $model->it_easy_created_time = $currentDateTime; 
            $model->save(false);
            Yii::$app->session->setFlash('success', "Your data has been saved!");
            return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing ItEasyPaymentGateway model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $it_easy_id It Easy ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($it_easy_id)
    {
        $this->findModel($it_easy_id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the ItEasyPaymentGateway model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_id It Easy ID
     * @return ItEasyPaymentGateway the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_id)
    {
        if (($model = ItEasyPaymentGateway::findOne(['it_easy_id' => $it_easy_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
public function actionPaymentGateway()
{
    $model = new \backend\models\ItEasyPaymentGateway();

    if ($model->load(Yii::$app->request->post())) {
        if ($model->validate()) {
            // form inputs are valid, do something here
            return;
        }
    }

    return $this->render('payment-gateway', [
        'model' => $model,
    ]);
}
}
