<?php

namespace backend\controllers;

use backend\models\ItEasyCoupon;
use backend\models\ItEasyCouponSearch;
use backend\models\ItEasyShippingPaymentMethod;
use backend\models\ItEasyCustomer;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use yii\filters\AccessControl;
use yii\db\Query;
use backend\models\ItEasyProduct;
use backend\models\ItEasyProductVariation;
use backend\models\ItEasyOrder;
use backend\models\ApiCall;
use backend\models\RazorPayment;
use backend\models\ItEasyOrderStatusHistory;

/**
 * CouponController implements the CRUD actions for ItEasyCoupon model.
 */
class PaymentPageController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }
  
public function actionIndex($orderid){
        $this->layout = false;
        $model = new ItEasyOrder();
        $get_product_data = $model->GetPaymentData($orderid);
        return $this->render('index',['get_product_data'=>$get_product_data,'orderid'=>$orderid]);

    }


    public function actionAddpayment()
    {   

        date_default_timezone_set("Asia/Kolkata");
        $request_id = $_REQUEST['razorpay_payment_id'];
        $request_url = "https://api.razorpay.com/v1/payments/".$request_id;
      
        $request_handle = curl_init($request_url);
        curl_setopt($request_handle, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($request_handle, CURLOPT_USERPWD, API_KEY . ":" . API_SECRET); 
        curl_setopt($request_handle, CURLOPT_RETURNTRANSFER, true);
        $request_result = curl_exec($request_handle);
        $data_val = json_decode($request_result); //post variable in index.php checkout.js
        $order_model = new ItEasyOrder();
        $paymentModel = new RazorPayment();
        $paymentModel->user_id = Yii::$app->user->identity->id;
        $paymentModel->order_id = $_REQUEST['order_id'];
        $paymentModel->contact_number =  $data_val->contact;
        $paymentModel->payment_type = 'Razor-Pay';
        $paymentModel->contact_email  = $data_val->email;
        $paymentModel->payment_amount    = $data_val->amount / 100;
        $paymentModel->payment_method = $data_val->method;
        $paymentModel->pay_id = $data_val->id;
        $paymentModel->payment_string_response = $data_val->status;
        $paymentModel->created_time     = date('Y-m-d H:i:s');
        $paymentModel->pro_id    = '0';
        $paymentModel->save(false);
        $comment = 'razorpay payment'.'('.$data_val->id.')';
        if(!empty($data_val)){
                $orderModel = ItEasyOrder::findOne(['it_easy_order_id' => $_REQUEST['order_id']]);
                $orderModel->it_easy_payment_method = 'Razor Pay/Payment Gateway';
                $orderModel->it_easy_payment_code = 'Prepaid';
                $orderModel->it_easy_order_status_id = '12';
                $orderModel->it_easy_updated_time = date('Y-m-d H:i:s');;
                $orderModel->save(false);
                $status_history_model = new ItEasyOrderStatusHistory();
                $status_history_model->it_easy_order_id = $_REQUEST['order_id'];
                $status_history_model->it_easy_order_status_id = '12';
                $status_history_model->it_easy_comment = $comment;
                $status_history_model->it_easy_created_time = date('Y-m-d H:i:s');  
                $status_history_model->save(false);
                echo $paymentModel->pay_id;
        }else{
                echo "error";
        }
        die;
        
    }

    public function actionThankyou(){
        $this->layout = false;
        $tr_id = $_REQUEST['trid'];
        return $this->render('thankyou',['tr_id'=>$tr_id]);
    }
    


}
