<?php

namespace backend\controllers;

use Yii;
use backend\models\ItEasyProduct;
use backend\models\ItEasyProductSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\web\UploadedFile;
use backend\models\ItEasyProductVariation;
use backend\models\ItEasyProductVariationAttribute;
use backend\models\ItEasyUserPermissionGroup;
use backend\models\ItEasyProductUnitMaterial;
use backend\models\ItEasyBuildIngredient;


/**
 * ProductController implements the CRUD actions for ItEasyProduct model.
 */
class ProductController extends Controller
{
    /**
     * @inheritDoc
     */
   public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyProduct models.
     *
     * @return string
     */
    public function actionIndex()
    {	if(Yii::$app->user->identity->it_easy_dept_id == '8' || Yii::$app->user->identity->it_easy_dept_id == '2' || Yii::$app->user->identity->it_easy_dept_id == '4' || Yii::$app->user->identity->it_easy_dept_id == '7'){
      		
      		if(Yii::$app->user->identity->it_easy_dept_id == '8'){
      			$permission[] = 'Product';
                
            }else if(Yii::$app->user->identity->it_easy_dept_id == '2'){
              	$permission = ItEasyUserPermissionGroup::getProcurementPermission();
            }else if(Yii::$app->user->identity->it_easy_dept_id == '4'){
              	$permission = ItEasyUserPermissionGroup::getSalesPermission();
            }else if(Yii::$app->user->identity->it_easy_dept_id == '4'){
              	$permission = ItEasyUserPermissionGroup::getNDRPermission();
            }
      		if (in_array("Product", $permission)){
                $searchModel = new ItEasyProductSearch();
                $dataProvider = $searchModel->search($this->request->queryParams);
                $dataProvider->pagination->pageSize = 60;
                return $this->render('index', [
                  'searchModel' => $searchModel,
                  'dataProvider' => $dataProvider,
                ]);
            }else{
              throw new NotFoundHttpException('The requested page does not exist.');
            }
      
      			
    	}else{
          throw new NotFoundHttpException('The requested page does not exist.');
      	}
    }


    /**
     * Creates a new ItEasyProduct model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {	
      	if(Yii::$app->user->identity->it_easy_dept_id == '8' || Yii::$app->user->identity->it_easy_dept_id == '2'){
            $model = new ItEasyProduct();
            $model2 = new ItEasyProductVariation();
            if ($model->load(Yii::$app->request->post())){
                    $post = Yii::$app->request->post();

                    date_default_timezone_set('Asia/kolkata');
                    $currentDateTime = date('Y-m-d H:i:s');
                    $time = time();
                    $model->it_easy_product_image = UploadedFile::getInstance($model,'it_easy_product_image');  
                        if(!empty($model->it_easy_product_image)){
                            $name = $model->it_easy_product_image->name;
                            if($name){
                                $name = str_replace(" ","_",$name);
                            }
                            $model->it_easy_product_image->saveAs('uploads/'.$time.'-'.$name);
                            $model->it_easy_product_image = $time.'-'.$name;
                        }
                            $price=$post['ItEasyProduct']['it_easy_product_price'];
                            $taxRate=$post['ItEasyProduct']['it_easy_product_tax'];

                            if($post['ItEasyProduct']['it_easy_product_included_exclude_tax'] == 'exclude'){
                            $tax=$price*$taxRate/100;
                            $model->it_easy_tax_price = $tax;
                            $model->it_easy_price_without_tax = $price;
                            }else{
                            $caltax  = 100+$taxRate;
                            $onepercentvalue=$price/$caltax;
                            $onepercentvalue = number_format($onepercentvalue , 2,'.','');
                            $wtaxp = $onepercentvalue*100;
                            $taxp =  $onepercentvalue*$taxRate;
                            $model->it_easy_tax_price = $taxp;
                            $model->it_easy_price_without_tax = $wtaxp;
                            }
                    $model->it_easy_product_approved_by = Yii::$app->user->identity->id;
                    $model->created_by = Yii::$app->user->identity->id;
                    $model->created_time = $currentDateTime;
                    $model->save(false);
                    // echo "<pre>";print_r($_POST['ItEasyProductVariation']);die;
                        if(!empty($_POST['ItEasyProductVariation'])){
                        foreach($_POST['ItEasyProductVariation'] as $key => $value){
                            $variationmodel = new ItEasyProductVariation();
                            $variationmodel->it_easy_product_id = $model->it_easy_product_id;
                            $variationmodel->it_easy_product_name = $model->it_easy_product_name;

                            $variationmodel->it_easy_variation_id = !empty($value['it_easy_variation_id']) ? $value['it_easy_variation_id'] : '';
                            $variation_attribute = ItEasyProductVariationAttribute::findOne(['it_easy_id' => $variationmodel->it_easy_variation_id]); 
                            $variationmodel->it_easy_variation_name = $variation_attribute->it_easy_variation_name;
                            $variationmodel->it_easy_varation_mrp = !empty($value['it_easy_varation_mrp']) ? $value['it_easy_varation_mrp'] : '';
                            $variationmodel->it_easy_varation_price = !empty($value['it_easy_varation_price']) ? $value['it_easy_varation_price'] : '';
                            $variationmodel->it_easy_product_weight = !empty($value['it_easy_product_weight']) ? $value['it_easy_product_weight'] : '';
                            
                            $variationmodel->shopify_product_id = !empty($value['shopify_product_id']) ? $value['shopify_product_id'] : '';
                            $variationmodel->shopify_veriant_id = !empty($value['shopify_veriant_id']) ? $value['shopify_veriant_id'] : '';
                            $variationmodel->created_by = Yii::$app->user->identity->id;

                            $variation_price = $variationmodel->it_easy_varation_price;
                            $taxRate=$model->it_easy_product_tax;

                            if($model->it_easy_product_included_exclude_tax == 'exclude'){
                                $tax=$variation_price*$taxRate/100;
                                $variationmodel->it_easy_tax_price = $tax;
                                $variationmodel->it_easy_price_without_tax = $variation_price;
                                $variationmodel->it_easy_varation_price = $variation_price + $tax;
                                $variationmodel->it_easy_product_tax = $taxRate;
                            }else{
                                $caltax  = 100+$taxRate;
                                $onepercentvalue=$variation_price/$caltax;
                                $onepercentvalue = number_format($onepercentvalue , 2,'.','');
                                $wtaxp = $onepercentvalue*100;
                                $taxp =  $onepercentvalue*$taxRate;
                                $variationmodel->it_easy_tax_price = $taxp;
                                $variationmodel->it_easy_price_without_tax = $wtaxp;
                                $variationmodel->it_easy_product_tax = $taxRate; 

                            }
                            $variationmodel->created_time = $currentDateTime;
                            $variationmodel->save(false);
                        }
                    }
                    Yii::$app->session->setFlash('success', "Your data has been saved!");
                    return $this->redirect(['index']);
            }

            return $this->render('create', [
                'model' => $model,
                'model2'=>$model2,
            ]);
          
        }else{
          throw new NotFoundHttpException('The requested page does not exist.');
      	}  
    }

    /**
     * Updates an existing ItEasyProduct model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_product_id It Easy Product ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_product_id)
    {	
      	if(Yii::$app->user->identity->it_easy_dept_id == '8' || Yii::$app->user->identity->it_easy_dept_id == '2'){
            $model = $this->findModel($it_easy_product_id);

            $unoqueNumber = $this->generateRandom(6);
            $model2 = ItEasyProductVariation::findAll(['it_easy_product_id' => $it_easy_product_id]);

            // echo "<pre>";print_r($model2);die;
                    if ($model->load(Yii::$app->request->post())){
                    $post = Yii::$app->request->post();
                    // echo "<pre>"; print_r($post); die;
                    date_default_timezone_set('Asia/kolkata');
                    $currentDateTime = date('Y-m-d H:i:s');
                    $time = time();
                    $model->it_easy_product_image = UploadedFile::getInstance($model,'it_easy_product_image');  
                    if(!empty($model->it_easy_product_image)){
                        $name = $model->it_easy_product_image->name;
                        if($name){
                            $name = str_replace(" ","_",$name);
                        }
                            $model->it_easy_product_image->saveAs('products/'.$time.'-'.$name);
                            $model->it_easy_product_image = $time.'-'.$name;
                    }else{
                        unset($model->it_easy_product_image);
                    }
                    $model->update_by = Yii::$app->user->identity->id;
                    $model->updated_time = $currentDateTime;
                    $model->save();

                     if(!empty($_POST['ItEasyProductVariation'])){

                        $array_build_material = [];
                        foreach($_POST['ItEasyProductVariation'] as $key => $value){
                            // echo "<pre>"; print_r($value); die;
                            if(isset($value['it_easy_id'])){
                                $modelVariation = $this->findModel2($value['it_easy_id']);
                            }else if(!isset($value['it_easy_id'])){
                              $modelVariation = new ItEasyProductVariation();  
                            }
                            if(isset($value['it_easy_variation_id']) && isset($value['it_easy_varation_mrp']) && isset($value['it_easy_varation_price']) ){
                                    $modelVariation->shopify_product_id = !empty($value['shopify_product_id']) ? $value['shopify_product_id'] : '';
                                    $modelVariation->shopify_veriant_id = !empty($value['shopify_veriant_id']) ? $value['shopify_veriant_id'] : '';
                                    $modelVariation->it_easy_product_id = $model->it_easy_product_id;
                                    $modelVariation->it_easy_variation_id  = !empty($value['it_easy_variation_id']) ? $value['it_easy_variation_id'] : '';
                                    $variation_attribute = ItEasyProductVariationAttribute::findOne(['it_easy_id' => $modelVariation->it_easy_variation_id]); 
                                    
                                    $modelVariation->it_easy_product_name = $model->it_easy_product_name;
                                     $modelVariation->it_easy_variation_name = $variation_attribute->it_easy_variation_name;
                                    $modelVariation->it_easy_varation_mrp = !empty($value['it_easy_varation_mrp']) ? $value['it_easy_varation_mrp'] : '';
                                    $modelVariation->it_easy_varation_price = !empty($value['it_easy_varation_price']) ? $value['it_easy_varation_price'] : '';
                                    
                                    $modelVariation->it_easy_product_weight = !empty($value['it_easy_product_weight']) ? $value['it_easy_product_weight'] : '';
                                    $variation_price = $modelVariation->it_easy_varation_price;
                                    $taxRate=$model->it_easy_product_tax;

                                    if($model->it_easy_product_included_exclude_tax == 'exclude'){
                                      $tax=$variation_price*$taxRate/100;
                                      $modelVariation->it_easy_tax_price = $tax;
                                      $modelVariation->it_easy_price_without_tax = $variation_price;
                                      $modelVariation->it_easy_varation_price = $variation_price + $tax;
                                      $modelVariation->it_easy_product_tax = $taxRate;
                                    }else{
                                      $caltax  = 100+$taxRate;
                                      $onepercentvalue=$variation_price/$caltax;
                                      $onepercentvalue = number_format($onepercentvalue , 2,'.','');
                                      $wtaxp = $onepercentvalue*100;
                                      $taxp =  $onepercentvalue*$taxRate;
                                      $modelVariation->it_easy_tax_price = $taxp;
                                      $modelVariation->it_easy_price_without_tax = $wtaxp;
                                      $modelVariation->it_easy_product_tax = $taxRate; 
                                    }


                                    $model->created_time = $currentDateTime;
                                    $modelVariation->save(false);
                                    $array_build_material[] = $modelVariation->it_easy_id;
                            }
                        }
                        //echo "<pre>"; print_r($array_build_material); die;
                        if(!empty($array_build_material)){
                            ItEasyProductVariation::deleteAll(['AND', ['it_easy_product_id'  => $model->it_easy_product_id], ['NOT IN', 'it_easy_id',$array_build_material ] ]);
                        }
                    }

                    Yii::$app->session->setFlash('success', "Your data has been saved!");
                    return $this->redirect(['index']);
            }

            return $this->render('update', [
                'model' => $model,
                'unoqueNumber'=>$unoqueNumber,
                'model2'=>$model2,
            ]);
       }else{
          throw new NotFoundHttpException('The requested page does not exist.');
        }    
    }
    
        public function actionUnitmaterial($it_easy_product_id){
      $model = $this->findModel($it_easy_product_id);
      $unoqueNumber = $this->generateRandom(6);
      $unit_model = new ItEasyProductUnitMaterial();
      $model2 = ItEasyProductVariation::findAll(['it_easy_product_id' => $it_easy_product_id]);
     if ($unit_model->load(Yii::$app->request->post())){
                $post = Yii::$app->request->post();
                date_default_timezone_set('Asia/kolkata');
                $currentDateTime = date('Y-m-d H:i:s');
                $time = time();
                   // echo "<pre>";print_r($post);die;
                // $r = 0;
                foreach ($post['ItEasyProductUnitMaterial'] as $key => $value) {
                  foreach ($value as $key1 => $value1) {
                  // echo "<pre>";print_r($value1);die;
                      $unit_model = ItEasyProductUnitMaterial::find()->where(['it_easy_product_id'=>$it_easy_product_id])->andWhere(['it_easy_variation_id'=>$key])->andWhere(['it_easy_material_id'=>$value1['it_easy_material_id']])->one();

                      if(empty($unit_model)){
                          $unit_model = new ItEasyProductUnitMaterial();
                          $unit_model->it_easy_product_id = $it_easy_product_id;
                          $unit_model->it_easy_variation_id = $key;
                          $unit_model->it_easy_material_id = $value1['it_easy_material_id'];
                          $unit_model->it_easy_quantity = $value1['it_easy_quantity'];
                          $unit_model->it_easy_weight_type = $value1['it_easy_weight_type'];
                          $unit_model->created_by = Yii::$app->user->identity->id;
                          $unit_model->created_time = $currentDateTime;
                          $unit_model->save(false);
                          $it_easy_material_id[] = $unit_model->it_easy_material_id;
                      }else{
                          $unit_model->it_easy_product_id = $it_easy_product_id;
                          $unit_model->it_easy_variation_id = $key;
                          $unit_model->it_easy_material_id = $value1['it_easy_material_id'];
                          $unit_model->it_easy_quantity = $value1['it_easy_quantity'];
                          $unit_model->it_easy_weight_type = $value1['it_easy_weight_type'];
                          $unit_model->created_by = Yii::$app->user->identity->id;
                          $unit_model->created_time = $currentDateTime;
                          $unit_model->save(false);
                          $it_easy_material_id[] = $unit_model->it_easy_material_id;
                        
                      }

                  }
                   $query = ItEasyProductUnitMaterial::deleteAll(['AND', ['it_easy_product_id'  => $it_easy_product_id, 'it_easy_variation_id' => $key], ['NOT IN', 'it_easy_material_id', $it_easy_material_id] ]);

              }
           
                Yii::$app->session->setFlash('success', "Your data has been saved!");
                return $this->redirect(['index']);
      }

              
 
       return $this->render('unit-material', [
                'model' => $model,
                'unoqueNumber'=>$unoqueNumber,
                'model2'=>$model2,
                'unit_model'=>$unit_model,
            ]);
    }

     public function actionUnitmaterialhtml(){
       
        $this->layout = false;
        $model2 = new ItEasyBuildIngredient();
        $materialdata = $model2->getMaterialData();
        $unoqueNumber = $this->generateRandom(6);
        $getid = $_GET['getid'];
        $varid = $_GET['varid'];
        return $this->renderPartial("unitmaterialhtml", ['unoqueNumber' => $unoqueNumber, 'materialdata' => $materialdata,'fetchid'=>$getid,'varid'=>$varid]);
    }


    public function actionDeleteImage($it_easy_product_id,$image)
    {  

        $model = $this->findModel($it_easy_product_id);
        if (!empty($model->it_easy_product_image)){    
                $model->it_easy_product_image = '';
            }
             $model->save(false); 
             return $this->redirect(['update', 'it_easy_product_id' => $model->it_easy_product_id]);  
    }

        public function actionVariationhtml(){
          
        $this->layout = false;
        $model2 = new ItEasyProductVariation();
        $variationdata = $model2->getVariationData();
        $unoqueNumber = $this->generateRandom(6);
        $getid = $this->request->queryParams['getid'];
        return $this->renderPartial("variation", ['unoqueNumber' => $unoqueNumber, 'variationdata' => $variationdata,'fetchid'=>$getid]);
    }

    public function generateRandom($length = 8){
        $intMin = (10 ** $length) / 10; // 100...
        $intMax = (10 ** $length) - 1;  // 999...
        $codeRandom = mt_rand($intMin, $intMax);
        return $codeRandom;
    }



    /**
     * Finds the ItEasyProduct model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_product_id It Easy Product ID
     * @return ItEasyProduct the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_product_id)
    {
        if (($model = ItEasyProduct::findOne(['it_easy_product_id' => $it_easy_product_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

     protected function findModel2($it_easy_id)
    {
        if (($model = ItEasyProductVariation::findOne(['it_easy_id' => $it_easy_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
