<?php

namespace backend\controllers;

use Yii;
use backend\models\ItEasyProductVariationAttribute;
use backend\models\ItEasyProductVariationAttributeSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
/**
 * ProductVariationAttributeController implements the CRUD actions for ItEasyProductVariationAttribute model.
 */
class ProductVariationAttributeController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }


    /**
     * Lists all ItEasyProductVariationAttribute models.
     *
     * @return string
     */
    public function actionIndex()
    {	if(Yii::$app->user->identity->it_easy_dept_id == '8' || Yii::$app->user->identity->it_easy_dept_id == '2'){
            $searchModel = new ItEasyProductVariationAttributeSearch();
            $dataProvider = $searchModel->search($this->request->queryParams);

            return $this->render('index', [
                'searchModel' => $searchModel,
                'dataProvider' => $dataProvider,
            ]);
      	}else{
          throw new NotFoundHttpException('The requested page does not exist.');
      	}
    }



    /**
     * Creates a new ItEasyProductVariationAttribute model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {	
      	if(Yii::$app->user->identity->it_easy_dept_id == '8' || Yii::$app->user->identity->it_easy_dept_id == '2'){
            $model = new ItEasyProductVariationAttribute();

           if ($model->load(Yii::$app->request->post())){
                    $post = Yii::$app->request->post();
                    date_default_timezone_set('Asia/kolkata');
                    $currentDateTime = date('Y-m-d H:i:s');
                    $time = time();
                    $model->created_by = Yii::$app->user->identity->id;
                    $model->created_time = $currentDateTime; 
                    $model->save();
                    Yii::$app->session->setFlash('success', "Your data has been saved!");
                    return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
            }

            return $this->render('create', [
                'model' => $model,
            ]);
        }else{
          throw new NotFoundHttpException('The requested page does not exist.');
      	}  
    }

    /**
     * Updates an existing ItEasyProductVariationAttribute model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_id It Easy ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_id)
    {	if(Yii::$app->user->identity->it_easy_dept_id == '8' || Yii::$app->user->identity->it_easy_dept_id == '2'){
          $model = $this->findModel($it_easy_id);

         if ($model->load(Yii::$app->request->post())){
              $post = Yii::$app->request->post();
              date_default_timezone_set('Asia/kolkata');
              $currentDateTime = date('Y-m-d H:i:s');
              $time = time();
              $model->updated_by = Yii::$app->user->identity->id;
              $model->updated_time = $currentDateTime; 
              $model->save();
              Yii::$app->session->setFlash('success', "Your data has been saved!");
              return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
          }

          return $this->render('update', [
              'model' => $model,
          ]);
      	}else{
          throw new NotFoundHttpException('The requested page does not exist.');
      	} 
    }



    /**
     * Finds the ItEasyProductVariationAttribute model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_id It Easy ID
     * @return ItEasyProductVariationAttribute the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_id)
    {
        if (($model = ItEasyProductVariationAttribute::findOne(['it_easy_id' => $it_easy_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
