<?php

namespace backend\controllers;

use backend\models\ItEasyCoupon;
use backend\models\ItEasyCouponSearch;
use backend\models\Pincodecity;
use backend\models\ItEasyShippingPaymentMethod;
use backend\models\ItEasyCustomer;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use yii\filters\AccessControl;
use yii\db\Query;
use backend\models\ItEasyProduct;
use backend\models\ItEasyProductVariation;
use backend\models\ItEasyOrder;
use backend\models\ItEasyCouponHistory;
use backend\models\CallAwbService1;
use backend\models\ItEasyClickpostCourier;
use backend\models\ApiCall;
use backend\models\ItEasyClickpostTracking;
use backend\models\ItEasyOrderDispatch;


/**
 * CouponController implements the CRUD actions for ItEasyCoupon model.
 */
class QueryGetController extends Controller
{
    public function beforeAction($action) {
        Yii::$app->request->enableCsrfValidation = false;
        return parent::beforeAction($action);
    }
    
    public function actionIndex(){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: *');
        $this->enableCsrfValidation = false;
        $track_data = json_decode(file_get_contents("php://input"), true);
        if(isset($track_data['waybill']) && !empty($track_data['waybill'])){
            $dispatch_model = ItEasyOrderDispatch::findOne(['it_easy_awb_number' => $track_data['waybill']]);
            
            if(!empty($dispatch_model)){
                $order_model = ItEasyOrder::findOne(['it_easy_order_id' => $dispatch_model->it_easy_order_id ]);
                
                if(!empty($order_model)){
                    $time_stamp= str_replace("T"," ",$track_data['additional']['latest_status']['timestamp']);
                    $time_stamp= str_replace("Z","",$time_stamp);
                    
                    $model = new ItEasyClickpostTracking();
                    $model->order_id = $dispatch_model->it_easy_order_id;
                    $model->awb_number = $track_data['waybill'];
                    $model->cp_id = $track_data['cp_id'];
                    $model->remark = $track_data['additional']['latest_status']['remark'];
                    $model->status_code = $track_data['additional']['latest_status']['clickpost_status_code'];
                    $model->reference_number = $track_data['additional']['latest_status']['reference_number'];
                    $model->timestamp = $track_data['additional']['latest_status']['timestamp'];
                    $model->status_description_bucket = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                    $model->location = $track_data['additional']['latest_status']['location'];
                    $model->status_description = $track_data['additional']['latest_status']['clickpost_status_description'];
                    $model->query = json_encode($track_data);
                    $model->status_time = date('Y-m-d H:i:s');
                    
                    if($track_data['additional']['latest_status']['clickpost_status_code'] == '2'){
                        $order_model->it_easy_order_status_id = '31';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '3'){
                        $order_model->it_easy_order_status_id = '31';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '4'){
                        $order_model->it_easy_placed_time = $time_stamp;
                        $order_model->it_easy_order_status_id = '29';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_pickup_time = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '5'){
                        $order_model->it_easy_order_status_id = '27';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '6'){
                        if(empty($dispatch_model->it_easy_first_scan_date)){
                            $dispatch_model->it_easy_first_scan_date = date('Y-m-d H:i:s');
                            $dispatch_model->save(false);
                        }
                        
                        if(empty($dispatch_model->it_easy_last_scan_date)){
                            $dispatch_model->it_easy_last_scan_date = date('Y-m-d H:i:s');
                            $dispatch_model->it_easy_attempt_count = '1';
                            $dispatch_model->save(false);
                        }else{
                            if(date('Y-m-d') != date('Y-m-d', strtotime($dispatch_model->it_easy_last_scan_date))){
                                $dispatch_model->it_easy_last_scan_date = date('Y-m-d H:i:s');
                                $dispatch_model->it_easy_attempt_count = $dispatch_model->it_easy_attempt_count +1;
                                $dispatch_model->save(false);
                            }
                        }
                        
                        
                        
                        $order_model->it_easy_order_status_id = '30';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '7'){
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '8'){
                        
                        $order_model->it_easy_order_status_id = '3';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->it_easy_delivered_time = $time_stamp;
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = 'Delivered';
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_delivery_date = $time_stamp;
                        $dispatch_model->save(false);
                        echo "<pre>"; print_r($dispatch_model); die;
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '9'){
                        $order_model->it_easy_order_status_id = '9';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '10'){
                        $order_model->it_easy_order_status_id = '8';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '11'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '12'){
                        $order_model->it_easy_order_status_id = '47';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_auto_rto_date =$time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '13'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '14'){
                        $order_model->it_easy_order_status_id = '47';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_auto_rto_date =$time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '15'){
                        $order_model->it_easy_order_status_id = '28';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '16'){
                        $order_model->it_easy_order_status_id = '14';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '17'){
                        $order_model->it_easy_order_status_id = '14';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '18'){
                        $order_model->it_easy_order_status_id = '9';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '19'){
                        $order_model->it_easy_order_status_id = '27';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '20'){
                        $order_model->it_easy_order_status_id = '9';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '25'){
                        $order_model->it_easy_order_status_id = '4';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '26'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '27'){
                        $order_model->it_easy_order_status_id = '28';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '1004'){
                        $order_model->it_easy_order_status_id = '27';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '1005'){
                        $order_model->it_easy_order_status_id = '27';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['additional']['latest_status']['clickpost_status_code'] == '1006'){
                        $order_model->it_easy_order_status_id = '27';
                        $order_model->it_easy_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['additional']['latest_status']['clickpost_status_description'];
                        $dispatch_model->it_easy_courier_comment = $track_data['additional']['latest_status']['clickpost_status_bucket_description'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }
                    $model->save(false);
                }else{
                    $json['code'] = '407';
                    $json['message'] = "ORDER ID didn't match in system";
                    echo json_encode($json);
                }
            }else{
                $json['code'] = '405';
                $json['message'] = "This ".$track_data['waybill']."AWB Number didn't find in system";
                echo json_encode($json);
            }
        }else{
            $json['code'] = '406';
            $json['message'] = "AWB NUMBER hasn't found";
            echo json_encode($json);
        }
        die;
    }
}
