<?php

namespace backend\controllers;

use backend\models\ItEasyRaiseRequest;
use backend\models\ItEasyRaiseRequestSearch;
use backend\models\ItEasyUser;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use Yii;
/**
 * RaiseRequestController implements the CRUD actions for ItEasyRaiseRequest model.
 */
class RaiseRequestController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }


    /**
     * Lists all ItEasyRaiseRequest models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyRaiseRequestSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);
        $model2 = new ItEasyRaiseRequest();
        if ($this->request->isPost) {
            if ($model2->load(Yii::$app->request->post())){
                 date_default_timezone_set("Asia/Kolkata");
                 $create_date=date("Y-m-d H:i:s");
                 $model2->it_easy_user_id = Yii::$app->user->identity->id;
                 $model2->it_easy_created_time = $create_date; 
                 $model2->it_easy_created_by = Yii::$app->user->identity->id;
                 
                 $model2->save();
                 Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
                 return $this->redirect(['index']);
            }
        }

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'model2' => $model2
        ]);
    }
  
  
  	     public function actionRaiseRequest(){
        $model2 = new ItEasyRaiseRequest();
        if ($this->request->isPost) {
            if ($model2->load(Yii::$app->request->post())) {
                date_default_timezone_set("Asia/Kolkata");
                $create_date = date("Y-m-d H:i:s");
                $model2->it_easy_user_id = Yii::$app->user->identity->id;
                $model2->it_easy_created_time = $create_date;
                $model2->it_easy_created_by = Yii::$app->user->identity->id;

                $model2->save();
                Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');
                return $this->redirect(['agentwise']);
            }
        }

        // echo "<pre>"; print_r($agentwise_total_report); die;

        return $this->render('raiserequest', [
            'model2' => $model2,
        ]);
    }

    
    public function actionUpdate($it_easy_id)
    {
        $model = $this->findModel($it_easy_id);
        
        $model2=ItEasyUser::findOne(['id'=>$it_easy_id]);
      
        if ($this->request->isPost && $model->load($this->request->post())) {
            
            date_default_timezone_set("Asia/Kolkata");
            $create_date=date("Y-m-d H:i:s");
           $solvedcoment=$model->it_easy_raise_comment;
            
            $model->it_easy_updated_time=$create_date;
           
            $model->it_easy_solved_by=Yii::$app->user->identity->id;
            $model->it_easy_updated_by=Yii::$app->user->identity->id;
            $model->save();
           
            return $this->redirect(['index']);
        }

        return $this->render('update', [
            'model' => $model,
            'model2' => $model2
        ]);
    }

    
    protected function findModel($it_easy_id)
    {
        if (($model = ItEasyRaiseRequest::findOne(['it_easy_id' => $it_easy_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
