<?php

namespace backend\controllers;

use backend\models\ItEasyShippingApi;
use backend\models\ItEasyShippingApiSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii;
use yii\filters\AccessControl;
/**
 * ShippingApiController implements the CRUD actions for ItEasyShippingApi model.
 */
class ShippingApiController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }
    /**
     * Lists all ItEasyShippingApi models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyShippingApiSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ItEasyShippingApi model.
     * @param int $it_easy_ship_id It Easy Ship ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */


    /**
     * Creates a new ItEasyShippingApi model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new ItEasyShippingApi();

        if ($model->load(Yii::$app->request->post())) {
            $post = Yii::$app->request->post();
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d  H:i:s');
            $time = time();
            $model->created_by = Yii::$app->user->identity->id;
            $model->created_time = $currentDateTime;
             
            $model->save();
           

            Yii::$app->session->setFlash('success', 'Your data has been submitted!!');
            return $this->redirect(['index', 'it_easy_ship_id' => $model->it_easy_ship_id]);
        }
        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing ItEasyShippingApi model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_ship_id It Easy Ship ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_ship_id)
    {
        $model = $this->findModel($it_easy_ship_id);

        if ($model->load(Yii::$app->request->post())) {
            $post = Yii::$app->request->post();
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');
            $time = time();
            $model->updated_by = Yii::$app->user->identity->id;
            $model->updated_time = $currentDateTime;

            $model->save();

            Yii::$app->session->setFlash('success', 'Your data has been submitted!!');
            return $this->redirect(['index', 'it_easy_ship_id' => $model->it_easy_ship_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing ItEasyShippingApi model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $it_easy_ship_id It Easy Ship ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */


    /**
     * Finds the ItEasyShippingApi model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_ship_id It Easy Ship ID
     * @return ItEasyShippingApi the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_ship_id)
    {
        if (($model = ItEasyShippingApi::findOne(['it_easy_ship_id' => $it_easy_ship_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    public function actionShippingApi()
{
    $model = new \backend\models\ItEasyShippingApi();

    if ($model->load(Yii::$app->request->post())) {
        if ($model->validate()) {
            // form inputs are valid, do something here
            return;
        }
    }

    return $this->render('ShippingApi', [
        'model' => $model,
    ]);
}
}
