<?php

namespace backend\controllers;

use backend\models\ItEasyShippingPaymentMethod;
use backend\models\ItEasyShippingPaymentMethodSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;

/**
 * ShippingPaymentMethodController implements the CRUD actions for ItEasyShippingPaymentMethod model.
 */
class ShippingPaymentMethodController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all ItEasyShippingPaymentMethod models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyShippingPaymentMethodSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ItEasyShippingPaymentMethod model.
     * @param int $it_easy_id It Easy ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($it_easy_id)
    {
        return $this->render('view', [
            'model' => $this->findModel($it_easy_id),
        ]);
    }

    /**
     * Creates a new ItEasyShippingPaymentMethod model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new ItEasyShippingPaymentMethod();

        if ($model->load(Yii::$app->request->post())){
            $post = Yii::$app->request->post();
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');
            $time = time();
            $model->created_by = Yii::$app->user->identity->id;
            $model->created_time = $currentDateTime; 
            $model->save();
            Yii::$app->session->setFlash('success', "Your data has been saved!");
            return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
    }

    return $this->render('create', [
        'model' => $model,
    ]);
    }

    /**
     * Updates an existing ItEasyShippingPaymentMethod model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_id It Easy ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_id)
    {
        $model = $this->findModel($it_easy_id);

        if ($model->load(Yii::$app->request->post())){
            $post = Yii::$app->request->post();
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');
            $time = time();
            $model->updated_by = Yii::$app->user->identity->id;
            $model->updated_time = $currentDateTime; 
            $model->save();
            Yii::$app->session->setFlash('success', "Your data has been saved!");
            return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing ItEasyShippingPaymentMethod model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $it_easy_id It Easy ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    

    /**
     * Finds the ItEasyShippingPaymentMethod model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_id It Easy ID
     * @return ItEasyShippingPaymentMethod the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_id)
    {
        if (($model = ItEasyShippingPaymentMethod::findOne(['it_easy_id' => $it_easy_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    public function actionShippingPaymentMethod()
    {
        $model = new \backend\models\ItEasyShippingPaymentMethod();
    
        if ($model->load(Yii::$app->request->post())) {
            if ($model->validate()) {
                // form inputs are valid, do something here
                return;
            }
        }
    
        return $this->render('state', [
            'model' => $model,
        ]);
    }

}
