<?php

namespace backend\controllers;

use backend\models\ItEasyShiprocketPincodes;
use backend\models\ItEasyShiprocketPincodesSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii;
use yii\filters\AccessControl;
use yii\web\UploadedFile;
use yii2tech\spreadsheet\Spreadsheet;
use yii\data\ArrayDataProvider;

/**
 * ShipdelightPincodesController implements the CRUD actions for ItEasyShiprocketPincodes model.
 */
class ShiprocketPincodesController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyShiprocketPincodes models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyShiprocketPincodesSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ItEasyShiprocketPincodes model.
     * @param int $it_easy_id It Easy ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionExport()
    {
        $data = ItEasyShiprocketPincodes::find()->groupBy(['it_easy_pincode'])->asArray()->all();
        
        $exporter = new Spreadsheet([
                'dataProvider' => new ArrayDataProvider([
                    'allModels' => $data,
                ]),
                'columns' => [
                    [   'attribute' => 'it_easy_pincode'],
                    [   'attribute' => 'it_easy_city'],
                    [   'attribute' => 'it_easy_state'],
                    [   'attribute' => 'it_easy_cod'],
                  	[   'attribute' => 'it_easy_prepaid'],
                ],
            ]);
            return $exporter->send('SHIPROCKET-pincode.xlsx');
    }
    /**
     * Creates a new ItEasyShiprocketPincodes model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new ItEasyShiprocketPincodes();

        if ($model->load(Yii::$app->request->post())) {
            date_default_timezone_set('Asia/Kolkata');
        
            // Delete all old records
            ItEasyShiprocketPincodes::deleteAll();
            
            $currentDateTime = date('Y-m-d H:i:s');
            $uploadedFile = UploadedFile::getInstance($model, 'file');
        
            if ($uploadedFile) {
                $time = time();
                $filePath = 'csv/' . $time . '.' . $uploadedFile->extension;
        
                // Make sure the 'csv' directory exists
                if (!is_dir('csv')) {
                    mkdir('csv', 0777, true);
                }
        
                if ($uploadedFile->saveAs($filePath)) {
                    $getdata = fopen($filePath, "r");
        
                    if ($getdata) {
                        $row = 0;
                        while (($data = fgetcsv($getdata, 1000, ",")) !== false) {
                            if ($row != 0) {
                                $entry = new ItEasyShiprocketPincodes();
                                $entry->it_easy_pincode = trim($data[0]);
                                $entry->it_easy_city = trim($data[1]);
                                $entry->it_easy_state = trim($data[2]);
                                $entry->it_easy_cod = trim($data[4]);
                                $entry->it_easy_prepaid = trim($data[3]);
                                $entry->created_by = Yii::$app->user->identity->id;
                                $entry->it_easy_date_added = $currentDateTime;
                                $entry->save(false);
                            }
                            $row++;
                        }
                        fclose($getdata);
        
                        return $this->redirect(['index', 'it_easy_id' => $entry->it_easy_id]);
                    } else {
                        Yii::$app->session->setFlash('error', 'Failed to open CSV file for reading.');
                    }
                } else {
                    Yii::$app->session->setFlash('error', 'File could not be saved to server.');
                }
            } else {
                Yii::$app->session->setFlash('error', 'No file uploaded.');
            }
        
            return $this->redirect(['create']); // Optional: show error
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing ItEasyShiprocketPincodes model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_id It Easy ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_id)
    {
        $model = $this->findModel($it_easy_id);

        if ($model->load(Yii::$app->request->post())) {
            $post = Yii::$app->request->post();
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');
            $time = time();
            $model->updated_by = Yii::$app->user->identity->id;
            $model->updated_time = $currentDateTime;
            
            $model->save(false);
            

            Yii::$app->session->setFlash('success', 'Form has been updated');
            return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }
    
    
    public function actionDelete($it_easy_id)
    {
        $this->findModel($it_easy_id)->delete();

        return $this->redirect(['index']);
    }
    
    /**
     * Deletes an existing ItEasyShiprocketPincodes model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $it_easy_id It Easy ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */

    /**
     * Finds the ItEasyShiprocketPincodes model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_id It Easy ID
     * @return ItEasyShiprocketPincodes the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_id)
    {
        if (($model = ItEasyShiprocketPincodes::findOne(['it_easy_id' => $it_easy_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    public function actionShipdelightPincodes()
{
    $model = new \backend\models\ItEasyShiprocketPincodes();

    if ($model->load(Yii::$app->request->post())) {
        if ($model->validate()) {
            // form inputs are valid, do something here
            return;
        }
    }

    return $this->render('ShipdelightPincodes', [
        'model' => $model,
    ]);
}
}
