<?php

namespace backend\controllers;

use common\models\LoginForm;
use Yii;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use backend\models\ItEasyUser;
use backend\models\ItEasyOrder;
use backend\models\ItEasyOrderSearch;
use backend\models\ItEasyUserPermissionGroup;
/**
 * Site controller
 */
class SiteController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['logout', 'index'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::class,
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => \yii\web\ErrorAction::class,
            ],
        ];
    }

    /**
     * Displays homepage.
     *
     * @return string
     */
    public function actionIndex()
    {   
        
        

// $permission_check = ItEasyUserPermissionGroup::find()->where(['name' => 'Sales Admin'])->asArray()->one();
//   $array_permission_array = explode(",",$permission_check['permission_menu']);
//   $salemanager_permission_check = ItEasyUserPermissionGroup::find()->where(['name' => 'Sales Manager'])->asArray()->one();
//   $salemanager_array_permission_array = explode(",",$salemanager_permission_check['permission_menu']);
//   $saletlpermission_check = ItEasyUserPermissionGroup::find()->where(['name' => 'Sales TL'])->asArray()->one();
//   $saletlarray_permission_array = explode(",",$saletlpermission_check['permission_menu']);
//   $saleagentpermission_check = ItEasyUserPermissionGroup::find()->where(['name' => 'Sales Agent'])->asArray()->one();
//   $saleagentarray_permission_array = explode(",",$saleagentpermission_check['permission_menu']);
  
  
//   echo "<pre>"; print_R($array_permission_array);
//   echo "<pre>"; print_R($salemanager_array_permission_array);
//   echo "<pre>"; print_R($saletlarray_permission_array);
//   echo "<pre>"; print_R($saleagentarray_permission_array); die;
        
        
        $searchModel = new ItEasyOrderSearch();

        $today_report = ItEasyOrder::MainDashboardnumbers($this->request->queryParams);

        $month_report_ticket = ItEasyOrder::MainDashboardnumbersPrapaidThisMonth($this->request->queryParams);
            if(isset($this->request->queryParams['ItEasyOrderSearch']['it_easy_assigned_by'])){
              $searchModel->it_easy_assigned_by = $this->request->queryParams['ItEasyOrderSearch']['it_easy_assigned_by'];
            }
            if(isset($this->request->queryParams['ItEasyOrderSearch']['it_easy_department_id'])){
              $searchModel->it_easy_department_id = $this->request->queryParams['ItEasyOrderSearch']['it_easy_department_id'];
            }
            if(isset($this->request->queryParams['ItEasyOrderSearch']['it_easy_assigned_to'])){
              $searchModel->it_easy_assigned_to = $this->request->queryParams['ItEasyOrderSearch']['it_easy_assigned_to'];
            }
            // if(isset($this->request->queryParams['ItEasyOrderSearch']['it_easy_first_status'])){
            //   $searchModel->it_easy_first_status = $this->request->queryParams['ItEasyOrderSearch']['it_easy_first_status'];
            // }
            
            if(isset($this->request->queryParams['ItEasyOrderSearch']['it_easy_platform'])){
              $searchModel->it_easy_platform = $this->request->queryParams['ItEasyOrderSearch']['it_easy_platform'];
            }
            if(isset($this->request->queryParams['ItEasyOrderSearch']['date_type_filter'])){
              $searchModel->date_type_filter = $this->request->queryParams['ItEasyOrderSearch']['date_type_filter'];
            }
            if(isset($this->request->queryParams['ItEasyOrderSearch']['date_to_date'])){
              $searchModel->date_to_date = $this->request->queryParams['ItEasyOrderSearch']['date_to_date'];
            }
            if(isset($this->request->queryParams['ItEasyOrderSearch']['date_from_date'])){
              $searchModel->date_from_date = $this->request->queryParams['ItEasyOrderSearch']['date_from_date'];
            }
          

        if(isset($this->request->queryParams)){} 
        // echo "<pre>"; print_r($today_report); die;
        return $this->render('index', ['searchModel' => $searchModel,'today_report' => $today_report, 'month_report_ticket' => $month_report_ticket]);
    }

    /**
     * Login action.
     *
     * @return string|Response
     */
    public function actionLogin()
    {
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $this->layout = 'blank';
		
        $model = new LoginForm();
      
        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            return $this->goBack();
        }

        $model->password = '';

        return $this->render('login', [
            'model' => $model,
        ]);
    }

    /**
     * Logout action.
     *
     * @return Response
     */
    public function actionLogout()
    {   
        if(isset(Yii::$app->user->identity->id) && !empty(Yii::$app->user->identity->id)){
            $userModel = ItEasyUser::findOne(['id' => Yii::$app->user->identity->id]);
            $userModel->login_status = '0';
            $userModel->save();   
        }
        Yii::$app->user->logout();


        return $this->goHome();
    }
}
