<?php

namespace backend\controllers;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use yii\filters\AccessControl;
use yii\db\Query;
use backend\models\ItEasyOrderTrack;
use backend\models\ItEasyOrderDispatch;


/**
 * CouponController implements the CRUD actions for ItEasyCoupon model.
 */
class SmartshipTrackingController extends Controller
{
    public $enableCsrfValidation = false;
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
    
        ];
    }
  
  
 public function actionIndex(){
    $access_token = '8t0Tm6aylcjYkQ6W2GjU5cHDFlEuzRGk';
     header("Access-Control-Allow-Origin: *");
    header("Content-Type: application/json; charset=UTF-8");
    header("Access-Control-Allow-Methods: POST");
    header("Access-Control-Max-Age: 3600");
    header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
    header("Access-Auth-Token: $access_token");

    
    echo "<pre>";print_r(json_encode(apache_request_headers()));die;
    $data = json_decode(file_get_contents('php://input'), true);
    date_default_timezone_set('Asia/kolkata');
    $currentDateTime = date('Y-m-d H:i:s');
    if(!empty($data['awbno']) && isset($data['awbno'])){
        $get_dispatch_data =  ItEasyOrderDispatch::find()->where(['it_easy_awb_number' => $data['awbno']])->asArray()->one();
        // echo "<pre>";print_r($get_dispatch_data);die;
          if(!empty($get_dispatch_data) && isset($get_dispatch_data)){
        $it_easy_vendor_id = $get_dispatch_data['it_easy_user_id'];
        $it_easy_order_id = $get_dispatch_data['it_easy_order_id'];
        $it_easy_order_awb = $get_dispatch_data['it_easy_order_number'];
        $it_easy_shipping_id = $get_dispatch_data['it_easy_shipping_id'];
        $it_easy_awb_number = $get_dispatch_data['it_easy_awb_number'];
        $it_easy_order_status = $data['status_description'];
        $it_easy_courier_comment = $data['comments'];
        $it_easy_location = $data['current_location'];
        $it_easy_status_code = $data['status_code'];
        $statusUpdateDate = $data['statusUpdateDate'];
        $statusUpdateTime = $data['statusUpdateTime'];
        $it_easy_courier_time = $statusUpdateDate.' '.$statusUpdateTime;

        if(empty($it_easy_order_status) && !isset($it_easy_order_status)){
            $Status_desc = [
           "data" => [
                 "message" => [
                    "success" => false, 
                    "description" => "Status description can't be null" 
                 ] 
              ] 
        ];
        return json_encode($Status_desc);
         die;

        }elseif (empty($it_easy_courier_comment) && !isset($it_easy_courier_comment)) {
             $c_comment = [
           "data" => [
                 "message" => [
                    "success" => false, 
                    "description" => "Courier Commen can't be null" 
                 ] 
              ] 
        ];
        return json_encode($c_comment);
         die;
        }elseif (empty($it_easy_location) && !isset($it_easy_location)) {
             $current_location = [
           "data" => [
                 "message" => [
                    "success" => false, 
                    "description" => "Current Location can't be null" 
                 ] 
              ] 
        ];
        return json_encode($current_location);
         die;
        }elseif (empty($it_easy_status_code) && !isset($it_easy_status_code)) {
             $S_code = [
           "data" => [
                 "message" => [
                    "success" => false, 
                    "description" => "Status Code can't be null" 
                 ] 
              ] 
        ];
        return json_encode($S_code);
         die;
        }elseif (empty($statusUpdateDate) && !isset($statusUpdateDate)) {
            $date = [
           "data" => [
                 "message" => [
                    "success" => false, 
                    "description" => "Status update date and time can't be null" 
                 ] 
              ] 
        ];
        return json_encode($date);
         die;
        }else{

        Yii::$app->db->createCommand()->insert(ItEasyOrderTrack::tableName(),[
                        'it_easy_vendor_id' => $it_easy_vendor_id,
                        'it_easy_order_id' => $it_easy_order_id ,
                        'it_easy_order_awb' => $it_easy_order_awb,
                        'it_easy_shipping_id' => $it_easy_shipping_id,
                        'it_easy_awb_number' => $it_easy_awb_number,
                        'it_easy_order_status' => $it_easy_order_status,
                        'it_easy_courier_comment' => $it_easy_courier_comment,
                        'it_easy_location' => $it_easy_location,
                        'it_easy_status_code' => $it_easy_status_code,
                        'it_easy_courier_time' => $it_easy_courier_time,
                        'created_time' => $currentDateTime,  
                    ])->execute();

                     $rerun_true = [
           "data" => [
                 "message" => [
                    "success" => true, 
                    "description" => "Created successfully" 
                 ] 
              ] 
        ];

        return json_encode($rerun_true);
         die;
    }
        }else{
             $awb_not_found_in_database = [
                   "data" => [
                         "message" => [
                            "success" => false, 
                            "description" => "This AWB number not found in the system" 
                         ] 
                      ] 
                ];

                return json_encode($awb_not_found_in_database);
                 die;
        }
            }else{
                $rerun_false = [
                   "data" => [
                         "message" => [
                            "success" => false, 
                            "description" => "Faield, AWB number can't be null." 
                         ] 
                      ] 
                ];

                return json_encode($rerun_false);
                 die;
            }


 }

}
