<?php

namespace backend\controllers;

use backend\models\ItEasyStore;
use backend\models\ItEasyStoreSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use yii\filters\AccessControl;
use yii\web\UploadedFile;

/**
 * StoreController implements the CRUD actions for ItEasyStore model.
 */
class StoreController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyStore models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyStoreSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ItEasyStore model.
     * @param int $it_easy_id It Easy ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */


    /**
     * Creates a new ItEasyStore model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new ItEasyStore();

        if ($model->load(Yii::$app->request->post())) {
            $post = Yii::$app->request->post();
            $time = time();
            $model->it_easy_store_logo = UploadedFile::getInstance($model, 'it_easy_store_logo');
            if (!empty($model->it_easy_store_logo)) {
                $name = $model->it_easy_store_logo->name;
                if ($name) {
                    $name = str_replace(" ", "_", $name);
                }
                $model->it_easy_store_logo->saveAs('logo/' . $time . '-' . $name);
                $model->it_easy_store_logo = $time . '-' . $name;
            }
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d  H:i:s');
            $model->created_by = Yii::$app->user->identity->id;
            $model->created_time = $currentDateTime;
            $model->save(false);
            Yii::$app->session->setFlash('success', 'Form has been created');
            return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
        }
        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing ItEasyStore model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_id It Easy ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_id)
    {
        $model = $this->findModel($it_easy_id);


        if ($model->load(Yii::$app->request->post())) {
            $post = Yii::$app->request->post();
            $time = time();
            $model->it_easy_store_logo = UploadedFile::getInstance($model, 'it_easy_store_logo');
            if (!empty($model->it_easy_store_logo)) {
                $name = $model->it_easy_store_logo->name;
                if ($name) {
                    $name = str_replace(" ", "_", $name);
                }
                $model->it_easy_store_logo->saveAs('logo/' . $time . '-' . $name);
                $model->it_easy_store_logo = $time . '-' . $name;
            } else {
                unset($model->it_easy_store_logo);
            }
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');

            $model->updated_by = Yii::$app->user->identity->id;
            $model->updated_time = $currentDateTime;

            $model->save();

            Yii::$app->session->setFlash('success', 'Form has been updated');
            return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing ItEasyStore model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $it_easy_id It Easy ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    /**
     * Finds the ItEasyStore model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_id It Easy ID
     * @return ItEasyStore the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_id)
    {
        if (($model = ItEasyStore::findOne(['it_easy_id' => $it_easy_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    public function actionDeleteImage($it_easy_product_id, $image)
    {

        $model = $this->findModel($it_easy_product_id);
        if (!empty($model->it_easy_store_logo)) {
            $model->it_easy_store_logo = '';
        }
        $model->save(false);
        return $this->redirect(['update', 'it_easy_product_id' => $model->it_easy_product_id]);
    }
    public function actionStore()
    {
        $model = new \backend\models\ItEasyStore();

        if ($model->load(Yii::$app->request->post())) {
            if ($model->validate()) {
                // form inputs are valid, do something here
                return;
            }
        }

        return $this->render('Store', [
            'model' => $model,
        ]);
    }
}
