<?php

namespace backend\controllers;

use backend\models\ItEasyTax;
use backend\models\ItEasyTaxSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use yii\filters\AccessControl;

/**
 * TaxController implements the CRUD actions for ItEasyTax model.
 */
class TaxController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyTax models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyTaxSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ItEasyTax model.
     * @param int $it_easy_tax_id It Easy Tax ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    

    /**
     * Creates a new ItEasyTax model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new ItEasyTax();

       

        if($model->load(Yii::$app->request->post())){
            $post=Yii::$app->request->post();
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime=date('Y-m-d  H:i:s');
            $time=time();
            $model->created_by=Yii::$app->user->identity->id;
            $model->created_time=$currentDateTime;
            $model->save();
            
            Yii::$app->session->setFlash('success','Form has been created');
            return $this->redirect(['index','it_easy_tax_id'=>$model->it_easy_tax_id]);

        }
        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing ItEasyTax model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_tax_id It Easy Tax ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_tax_id)
    {
        $model = $this->findModel($it_easy_tax_id);

      
        if($model->load(Yii::$app->request->post())){
            $post=Yii::$app->request->post();
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime=date('Y-m-d H:i:s');
            $time=time();
            $model->updated_by=Yii::$app->user->identity->id;
            $model->updated_time=$currentDateTime;
          
            $model->save();
           
            Yii::$app->session->setFlash('success','Form has been updated');
            return $this->redirect(['index','it_easy_tax_id'=>$model->it_easy_tax_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing ItEasyTax model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $it_easy_tax_id It Easy Tax ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
  

    /**
     * Finds the ItEasyTax model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_tax_id It Easy Tax ID
     * @return ItEasyTax the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_tax_id)
    {
        if (($model = ItEasyTax::findOne(['it_easy_tax_id' => $it_easy_tax_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    public function actionTax()
{
    $model = new \backend\models\ItEasyTax();

    if ($model->load(Yii::$app->request->post())) {
        if ($model->validate()) {
            // form inputs are valid, do something here
            return;
        }
    }

    return $this->render('tax', [
        'model' => $model,
    ]);
}
}
