<?php

namespace backend\controllers;

use Yii;
use backend\models\ItEasyApi;
use backend\models\ItEasyQueryTracking;
use backend\models\ItEasyOrderDispatch;
use backend\models\ItEasyOrder;
use backend\models\ItEasyApiSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use backend\components\webhookSender;

/**
 * ApiController implements the CRUD actions for ItEasyApi model.
 */
class TrackingApiController extends Controller
{
    public function beforeAction($action) {
        Yii::$app->request->enableCsrfValidation = false;
        return parent::beforeAction($action);
    }
     
    public function actionTrackinsppurser(){
        // Set your secret API key
        $validApiKey = "UdfcAsjqaAOJHaSEHpx2N60UA9BZ49Eg";
        
        // Get headers
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: *');
        
        $this->enableCsrfValidation = false;
        $track_data = json_decode(file_get_contents("php://input"), true);
        
    
        $providedApiKey = '';

        if (isset($_SERVER['HTTP_X_API_KEY'])) {
            $providedApiKey = $_SERVER['HTTP_X_API_KEY'];
        } elseif (isset($_SERVER['REDIRECT_HTTP_X_API_KEY'])) {
            $providedApiKey = $_SERVER['REDIRECT_HTTP_X_API_KEY'];
        } elseif (function_exists('apache_request_headers')) {
            $providedApiKey = apache_request_headers();
            if (isset($headers['x-api-key'])) {
                $providedApiKey = $headers['x-api-key'];
            }
        }
        
        
        
        // Validate API key
        if ($providedApiKey !== $validApiKey) {
            http_response_code(401);
            echo json_encode(['error' => 'Unauthorized: Invalid API key']);
            exit;
        }else{
            //echo json_encode(['error' => 'success']);
        }
    
        
        
        if(isset($track_data['awb']) && !empty($track_data['awb'])){
            $dispatch_model = ItEasyOrderDispatch::findOne(['it_easy_awb_number' => $track_data['awb']]);
            
            if(!empty($dispatch_model)){
                $order_model = ItEasyOrder::findOne(['it_easy_order_id' => $dispatch_model->it_easy_order_id ]);
                
                if(!empty($order_model)){
                    
                    $time_stamp= date("Y-m-d H:i:s", strtotime($track_data['current_timestamp']));
                    $track_count = count($track_data['scans']) - 1;
                    $model = new ItEasyQueryTracking();
                    $model->courier_name = 'Shiprocket';
                    $model->order_id = $dispatch_model->it_easy_order_id;
                    $model->awb_number = $track_data['awb'];
                    $model->cp_id = $track_data['sr_order_id'];
                    $model->remark = $track_data['scans'][$track_count]['activity'];
                    $model->status_code = $track_data['current_status'];
                    $model->reference_number = $track_data['order_id'];
                    $model->timestamp = $time_stamp;
                    $model->status_description_bucket = $track_data['current_status'];
                    $model->location = $track_data['scans'][$track_count]['location'];
                    $model->status_description = $track_data['current_status'];
                    $model->query = json_encode($track_data);
                    $model->status_time = date('Y-m-d H:i:s');
                    
                    if($track_data['shipment_status_id'] == '72' || $track_data['shipment_status_id'] == '20' || $track_data['shipment_status_id'] == '13'){
                        $order_model->it_easy_order_status_id = '31';
                        $order_model->it_easy_comment = $track_data['scans'][$track_count]['activity'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['scans'][$track_count]['activity'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['shipment_status_id'] == '6'){
                        $order_model->it_easy_placed_time = $time_stamp;
                        $order_model->it_easy_order_status_id = '29';
                        $order_model->it_easy_comment = $track_data['scans'][$track_count]['activity'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['scans'][$track_count]['activity'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_pickup_time = date('Y-m-d H:i:s');
                        $dispatch_model->save(false);
                    }else if($track_data['shipment_status_id'] == '18' || $track_data['shipment_status_id'] == '38'  || $track_data['shipment_status_id'] == '48' || $track_data['shipment_status_id'] == '49' || $track_data['shipment_status_id'] == '50' || $track_data['shipment_status_id'] == '51' || $track_data['shipment_status_id'] == '54' || $track_data['shipment_status_id'] == '55' || $track_data['shipment_status_id'] == '56' || $track_data['shipment_status_id'] == '57' || $track_data['shipment_status_id'] == '68' || $track_data['shipment_status_id'] == '60' || $track_data['shipment_status_id'] == '77'){
                        $order_model->it_easy_order_status_id = '27';
                        $order_model->it_easy_comment = $track_data['scans'][$track_count]['activity'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['scans'][$track_count]['activity'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['shipment_status_id'] == '17'){
                        if(empty($dispatch_model->it_easy_first_scan_date)){
                            $dispatch_model->it_easy_first_scan_date = $track_data['scans'][$track_count]['date'];
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->second_attempt_date)){
                            $dispatch_model->second_attempt_date = $track_data['scans'][$track_count]['date'];
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->third_attempt_date)){
                            $dispatch_model->third_attempt_date = $track_data['scans'][$track_count]['date'];
                            $dispatch_model->save(false);
                        }
                        
                        if(empty($dispatch_model->it_easy_last_scan_date)){
                            $dispatch_model->it_easy_last_scan_date = $track_data['scans'][$track_count]['date'];
                            $dispatch_model->it_easy_attempt_count = '1';
                            $dispatch_model->save(false);
                        }else{
                            if(date('Y-m-d') != date('Y-m-d', strtotime($dispatch_model->it_easy_last_scan_date))){
                                $dispatch_model->it_easy_last_scan_date = $track_data['scans'][$track_count]['date'];
                                $dispatch_model->it_easy_attempt_count = $dispatch_model->it_easy_attempt_count +1;
                                $dispatch_model->save(false);
                            }
                        }
                        
                        
                        
                        $order_model->it_easy_order_status_id = '30';
                        $order_model->it_easy_comment = $track_data['scans'][$track_count]['activity'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['scans'][$track_count]['activity'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['shipment_status_id'] == '7'){
                        
                        $order_model->it_easy_order_status_id = '3';
                        $order_model->it_easy_comment = $track_data['scans'][$track_count]['activity'];
                        $order_model->it_easy_delivered_time = $time_stamp;
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = 'Delivered';
                        $dispatch_model->it_easy_courier_comment = $track_data['scans'][$track_count]['activity'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_delivery_date = $time_stamp;
                        $dispatch_model->save(false);
                        $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['shipment_status_id'] == '21' || $track_data['shipment_status_id'] == '39'){
                        
                        if(empty($dispatch_model->first_ndr_reason)){
                            $dispatch_model->first_ndr_reason = $track_data['scans'][$track_count]['activity'];
                            $order_model->it_easy_ndr_tl = '0';
                            $order_model->it_easy_ndr_agent = '0';
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->second_ndr_reason)){
                            $dispatch_model->second_ndr_reason = $track_data['scans'][$track_count]['activity'];
                            $order_model->it_easy_ndr_tl = '0';
                            $order_model->it_easy_ndr_agent = '0';
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->third_ndr_reason)){
                            $dispatch_model->third_ndr_reason = $track_data['scans'][$track_count]['activity'];
                            $order_model->it_easy_ndr_tl = '0';
                            $order_model->it_easy_ndr_agent = '0';
                            $dispatch_model->save(false);
                        }
                        
                        if(empty($dispatch_model->last_ndr_reason)){
                            $dispatch_model->last_ndr_reason = $track_data['scans'][$track_count]['activity'];
                            $dispatch_model->save(false);
                        }
                        
                        
                        
                        $order_model->it_easy_order_status_id = '9';
                        $order_model->it_easy_comment = $track_data['scans'][$track_count]['activity'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['scans'][$track_count]['activity'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                         $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['shipment_status_id'] == '8' || $track_data['shipment_status_id'] == '16'  || $track_data['shipment_status_id'] == '45'){
                        $order_model->it_easy_order_status_id = '8';
                        $order_model->it_easy_comment = $track_data['scans'][$track_count]['activity'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['scans'][$track_count]['activity'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['shipment_status_id'] ==  '14' || $track_data['shipment_status_id'] ==  '9'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['scans'][$track_count]['activity'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->rto_initiate_date = $track_data['scans'][$track_count]['date'];
                        $dispatch_model->it_easy_courier_comment = $track_data['scans'][$track_count]['activity'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['shipment_status_id'] == '46' || $track_data['shipment_status_id'] ==  '75' || $track_data['shipment_status_id'] ==  '41'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['scans'][$track_count]['activity'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['scans'][$track_count]['activity'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['shipment_status_id'] == '10'){
                        $order_model->it_easy_order_status_id = '47';
                        $order_model->it_easy_comment = $track_data['scans'][$track_count]['activity'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['scans'][$track_count]['activity'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_auto_rto_date =$time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['shipment_status_id'] == '40'){
                        $order_model->it_easy_order_status_id = '28';
                        $order_model->it_easy_comment = $track_data['scans'][$track_count]['activity'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['scans'][$track_count]['activity'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['shipment_status_id'] == '24' || $track_data['shipment_status_id'] == '25'  || $track_data['shipment_status_id'] == '12'  || $track_data['shipment_status_id'] == '76' ){
                        $order_model->it_easy_order_status_id = '14';
                        $order_model->it_easy_comment = $track_data['scans'][$track_count]['activity'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['scans'][$track_count]['activity'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['shipment_status_id'] == '22'){
                        $order_model->it_easy_order_status_id = '9';
                        $order_model->it_easy_comment = $track_data['scans'][$track_count]['activity'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['scans'][$track_count]['activity'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                         $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['shipment_status_id'] == '15' || $track_data['shipment_status_id'] == '27'  || $track_data['shipment_status_id'] == '52' || $track_data['shipment_status_id'] == '61'  || $track_data['shipment_status_id'] == '67'){
                        $order_model->it_easy_order_status_id = '4';
                        $order_model->it_easy_comment = $track_data['scans'][$track_count]['activity'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['scans'][$track_count]['activity'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['shipment_status_id'] == '42'){
                        $order_model->it_easy_order_status_id = '29';
                        $order_model->it_easy_comment = $track_data['scans'][$track_count]['activity'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['scans'][$track_count]['activity'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_pickup_time=date('Y-m-d H:i:s');
                        $dispatch_model->save(false);
                    }
                    $model->save(false);
                    $json['code'] = '200';
                    $json['message'] = "Saved Successfully";
                    echo json_encode($json);
                }else{
                    $json['code'] = '407';
                    $json['message'] = "ORDER ID didn't match in system";
                    echo json_encode($json);
                }
            }else{
                $json['code'] = '405';
                $json['message'] = "This ".$track_data['awb']."AWB Number didn't find in system";
                echo json_encode($json);
            }
        }else{
            $json['code'] = '406';
            $json['message'] = "AWB NUMBER hasn't found";
            echo json_encode($json);
        }
        die;
        
    } 
    
    public function actionTester(){
        phpinfo();   
    }
    
    public function actionRapisyypculr(){
       
        // Get headers
        $headers = getallheaders();
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: *');
        
        $expected_token = "UdfcAsjqaAOJHaSEHpx2N60UA9BZ49Eg";
        
        $auth_header = '';

        if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
            $auth_header = $_SERVER['HTTP_AUTHORIZATION'];
        } elseif (isset($_SERVER['REDIRECT_HTTP_AUTHORIZATION'])) {
            $auth_header = $_SERVER['REDIRECT_HTTP_AUTHORIZATION'];
        } elseif (function_exists('apache_request_headers')) {
            $headers = apache_request_headers();
            if (isset($headers['Authorization'])) {
                $auth_header = $headers['Authorization'];
            }
        }
        
        // Check for Bearer token format
        if (preg_match('/Bearer\s(\S+)/', $auth_header, $matches)) {
            $sent_token = $matches[1];
        
            if ($sent_token === $expected_token) {
                
            } else {
                http_response_code(401);
                echo json_encode([
                    "success" => false,
                    "message" => "Unauthorized: Invalid token."
                ]);
                die;
            }
        } else {
            http_response_code(401);
            echo json_encode([
                "success" => false,
                "message" => "Unauthorized: Bearer token not provided."
            ]);
            die;
        }

        $this->enableCsrfValidation = false;
        $track_datas = json_decode(file_get_contents("php://input"), true);
        
        if(isset($track_datas['records']) && !empty($track_datas['records'])){
            foreach($track_datas['records'] as $key => $track_data){
            
            $dispatch_model = ItEasyOrderDispatch::findOne(['it_easy_awb_number' => $track_data['shipment_details'][0]['awb']]);
            
            if(!empty($dispatch_model)){
                $order_model = ItEasyOrder::findOne(['it_easy_order_id' => $dispatch_model->it_easy_order_id ]);
                
                if(!empty($order_model)){
                    $time_stamp= date('Y-m-d H:i:s', strtotime($track_data['shipment_details'][0]['current_status_date']));
                    $track_count = count($track_data['shipment_details'][0]['track_scans']) - 1;
                    $model = new ItEasyQueryTracking();
                    $model->courier_name = 'Rapidsyp';
                    $model->order_id = $dispatch_model->it_easy_order_id;
                    $model->awb_number = $track_data['shipment_details'][0]['awb'];
                    $model->cp_id = $track_data['shipment_details'][0]['shipment_id'];
                    $model->remark = $track_data['shipment_details'][0]['latest_ndr_reason_desc'];
                    $model->status_code = $track_data['current_status'];
                    $model->reference_number = $track_data['seller_order_id'];
                    $model->timestamp = $track_data['shipment_details'][0]['current_status_date'];
                    $model->status_description_bucket = $track_data['current_status'];
                    $model->location = $track_data['shipment_details'][0]['track_scans'][$track_count]['scan_location'];
                    $model->status_description = $track_data['current_status'];
                    $model->query = json_encode($track_datas);
                    $model->status_time = date('Y-m-d H:i:s');
                    
                    if( $track_data['current_status'] == 'Pick up Exception' || $track_data['current_status'] == 'Pickup Cancelled'){
                        $order_model->it_easy_order_status_id = '31';
                        $order_model->it_easy_comment = $track_data['current_status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['current_status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['current_status'] == 'Pickup Completed' || $track_data['current_status']  == 'Shipped/Dispatched'){
                        $order_model->it_easy_placed_time = $time_stamp;
                        $order_model->it_easy_order_status_id = '29';
                        $order_model->it_easy_comment = $track_data['current_status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['current_status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_pickup_time=date('Y-m-d H:i:s');
                        $dispatch_model->save(false);
                    }else if($track_data['current_status'] == 'In Transit' || $track_data['current_status'] == 'Reached at Destination' || $track_data['current_status'] == 'Delivery Delayed'){
                        $order_model->it_easy_order_status_id = '27';
                        $order_model->it_easy_comment = $track_data['current_status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['current_status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['current_status'] == 'Out for Delivery'){
                        if(empty($dispatch_model->it_easy_first_scan_date)){
                            $dispatch_model->it_easy_first_scan_date = date('Y-m-d H:i:s');
                            $dispatch_model->save(false);
                        }
                        
                        if(empty($dispatch_model->it_easy_last_scan_date)){
                            $dispatch_model->it_easy_last_scan_date = date('Y-m-d H:i:s');
                            $dispatch_model->it_easy_attempt_count = '1';
                            $dispatch_model->save(false);
                        }else{
                            if(date('Y-m-d') != date('Y-m-d', strtotime($dispatch_model->it_easy_last_scan_date))){
                                $dispatch_model->it_easy_last_scan_date = date('Y-m-d H:i:s');
                                $dispatch_model->it_easy_attempt_count = $dispatch_model->it_easy_attempt_count +1;
                                $dispatch_model->save(false);
                            }
                        }
                        
                        
                        
                        $order_model->it_easy_order_status_id = '30';
                        $order_model->it_easy_comment = $track_data['current_status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['current_status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['current_status'] == 'Delivered'){
                        
                        $order_model->it_easy_order_status_id = '3';
                        $order_model->it_easy_comment = $track_data['current_status'];
                        $order_model->it_easy_delivered_time = $time_stamp;
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = 'Delivered';
                        $dispatch_model->it_easy_courier_comment = $track_data['current_status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_delivery_date = $time_stamp;
                        $dispatch_model->save(false);
                          $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['current_status'] == 'Undelivered'){
                        $order_model->it_easy_order_status_id = '9';
                        $order_model->it_easy_comment = $track_data['current_status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['current_status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                         $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['current_status'] == 'Shipment Cancelled' || $track_data['current_status'] ==  'Shipment Disposed-Off'){
                        $order_model->it_easy_order_status_id = '8';
                        $order_model->it_easy_comment = $track_data['current_status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['current_status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['current_status'] == 'RTO Requested' || $track_data['current_status'] == 'RTO Confirmed' || $track_data['current_status'] == 'RTO In Transit' || $track_data['current_status'] == 'RTO - Reached at Destination'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['current_status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['current_status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['current_status'] == 'RTO Delivered'){
                        $order_model->it_easy_order_status_id = '47';
                        $order_model->it_easy_comment = $track_data['current_status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['current_status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_auto_rto_date =$time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['current_status'] == 'RTO Undelivered'){
                        $order_model->it_easy_order_status_id = '28';
                        $order_model->it_easy_comment = $track_data['current_status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['current_status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['current_status'] == 'Shipment On Hold'){
                        $order_model->it_easy_order_status_id = '14';
                        $order_model->it_easy_comment = $track_data['current_status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['current_status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['current_status'] == 'Shipment Lost' || $track_data['current_status'] == 'Shipment Damaged' || $track_data['current_status'] == 'Shipment Misrouted'){
                        $order_model->it_easy_order_status_id = '14';
                        $order_model->it_easy_comment = $track_data['current_status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['current_status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['current_status'] == 'Shipment Booked' || $track_data['current_status'] == 'Pickup Scheduled' || $track_data['current_status'] == 'Out for Pickup'){
                        $order_model->it_easy_order_status_id = '4';
                        $order_model->it_easy_comment = $track_data['current_status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['current_status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['current_status'] == 'RTO In Transit'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['current_status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['current_status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['current_status'] == 'RTO Undelivered'){
                        $order_model->it_easy_order_status_id = '28';
                        $order_model->it_easy_comment = $track_data['current_status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['current_status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['current_status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }
                    $model->save(false);
                    $json['code'] = '200';
                    $json['message'] = "Saved Successfully";
                    echo json_encode($json);
                }else{
                    $json['code'] = '407';
                    $json['message'] = "ORDER ID didn't match in system";
                    echo json_encode($json);
                }
                }else{
                    $json['code'] = '405';
                    $json['message'] = "This ".$track_data['shipment_details'][0]['awb']."AWB Number didn't find in system";
                    echo json_encode($json);
                }
            }
        }else{
            $json['code'] = '406';
            $json['message'] = "AWB NUMBER hasn't found";
            echo json_encode($json);
        }
        die;
        
    } 
    
    
    
    public function actionPikndeltracking(){
       
        // Get headers
        $headers = getallheaders();
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: *');
        
        // $expected_token = "UdfcAsjqaAOJHaSEHpx2N60UA9BZ49Eg";
        
        // $auth_header = '';

        // if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        //     $auth_header = $_SERVER['HTTP_AUTHORIZATION'];
        // } elseif (isset($_SERVER['REDIRECT_HTTP_AUTHORIZATION'])) {
        //     $auth_header = $_SERVER['REDIRECT_HTTP_AUTHORIZATION'];
        // } elseif (function_exists('apache_request_headers')) {
        //     $headers = apache_request_headers();
        //     if (isset($headers['Authorization'])) {
        //         $auth_header = $headers['Authorization'];
        //     }
        // }
        
        // // Check for Bearer token format
        // if (preg_match('/Bearer\s(\S+)/', $auth_header, $matches)) {
        //     $sent_token = $matches[1];
        
        //     if ($sent_token === $expected_token) {
                
        //     } else {
        //         http_response_code(401);
        //         echo json_encode([
        //             "success" => false,
        //             "message" => "Unauthorized: Invalid token."
        //         ]);
        //         die;
        //     }
        // } else {
        //     http_response_code(401);
        //     echo json_encode([
        //         "success" => false,
        //         "message" => "Unauthorized: Bearer token not provided."
        //     ]);
        //     die;
        // }

        $this->enableCsrfValidation = false;
        $track_data = json_decode(file_get_contents("php://input"), true);
    
        
        if(isset($track_data['AWB']) && !empty($track_data['AWB'])){
            //foreach($track_datas['records'] as $key => $track_data){
            
            $dispatch_model = ItEasyOrderDispatch::findOne(['it_easy_awb_number' => $track_data['AWB']]);
            
            if(!empty($dispatch_model)){
                $order_model = ItEasyOrder::findOne(['it_easy_order_id' => $dispatch_model->it_easy_order_id ]);
                
                if(!empty($order_model)){
                    $time_stamp= date('Y-m-d H:i:s', strtotime($track_data['Time']));
                    
                    $model = new ItEasyQueryTracking();
                    $model->courier_name = 'Pikndel';
                    $model->order_id = $dispatch_model->it_easy_order_id;
                    $model->awb_number = $track_data['AWB'];
                    $model->cp_id = $track_data['ClientUniqueNo'];
                    $model->remark = $track_data['Message'];
                    $model->status_code = $track_data['OrderStatus'];
                    $model->reference_number = $track_data['ClientUniqueNo'];
                    $model->timestamp = $time_stamp;
                    $model->status_description_bucket = $track_data['Message'];
                    $model->location = $track_data['ReportingCity'];
                    $model->status_description = $track_data['Message'];
                    $model->query = json_encode($track_data);
                    $model->status_time = date('Y-m-d H:i:s');
                    
                    if( $track_data['OrderStatus'] == 'PCN'){
                        $order_model->it_easy_order_status_id = '31';
                        $order_model->it_easy_comment = $track_data['Message'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Message'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Message'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['OrderStatus'] == 'PCK'){
                        $order_model->it_easy_placed_time = $time_stamp;
                        $order_model->it_easy_order_status_id = '29';
                        $order_model->it_easy_comment = $track_data['Message'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Message'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Message'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_pickup_time=date('Y-m-d H:i:s');
                        $dispatch_model->save(false);
                    }else if($track_data['OrderStatus'] == 'ITR' || $track_data['OrderStatus'] == 'DTH' || $track_data['OrderStatus'] == 'RAH' || $track_data['OrderStatus'] == 'RAD' || $track_data['OrderStatus'] == 'ARD'  || $track_data['OrderStatus'] == 'PEN'){
                        $order_model->it_easy_order_status_id = '27';
                        $order_model->it_easy_comment = $track_data['Message'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Message'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Message'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['OrderStatus'] == 'OFD' || $track_data['OrderStatus'] == 'RCH'){
                        
                        if(empty($dispatch_model->it_easy_first_scan_date)){
                            $dispatch_model->it_easy_first_scan_date = $track_data['Time'];
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->second_attempt_date)){
                            $dispatch_model->second_attempt_date = $track_data['Time'];
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->third_attempt_date)){
                            $dispatch_model->third_attempt_date = $track_data['Time'];
                            $dispatch_model->save(false);
                        }
                        
                        if(empty($dispatch_model->it_easy_last_scan_date)){
                            $dispatch_model->it_easy_last_scan_date = $track_data['Time'];
                            $dispatch_model->it_easy_attempt_count = '1';
                            $dispatch_model->save(false);
                        }else{
                            if(date('Y-m-d') != date('Y-m-d', strtotime($dispatch_model->it_easy_last_scan_date))){
                                $dispatch_model->it_easy_last_scan_date = $track_data['Time'];
                                $dispatch_model->it_easy_attempt_count = $dispatch_model->it_easy_attempt_count +1;
                                $dispatch_model->save(false);
                            }
                        }
                        
                        
                        
                        $order_model->it_easy_order_status_id = '30';
                        $order_model->it_easy_comment = $track_data['Message'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Message'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Message'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['OrderStatus'] == 'DLD'){
                        
                        $order_model->it_easy_order_status_id = '3';
                        $order_model->it_easy_comment = $track_data['Message'];
                        $order_model->it_easy_delivered_time = $time_stamp;
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = 'Delivered';
                        $dispatch_model->it_easy_courier_comment = $track_data['Message'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_delivery_date = $time_stamp;
                        $dispatch_model->save(false);
                          $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['OrderStatus'] == 'CAN' || $track_data['OrderStatus'] == 'CBD' || $track_data['OrderStatus'] == 'CDD' || $track_data['OrderStatus'] == 'ANT' || $track_data['OrderStatus'] == 'CLJ' || $track_data['OrderStatus'] == 'CNA' || $track_data['OrderStatus'] == 'ER' || $track_data['OrderStatus'] == 'IDR' || $track_data['OrderStatus'] == 'IWA' || $track_data['OrderStatus'] == 'LOC' || $track_data['OrderStatus'] == 'NSP' || $track_data['OrderStatus'] == 'NSA' || $track_data['OrderStatus'] == 'PNM' || $track_data['OrderStatus'] == 'RTA' || $track_data['OrderStatus'] == 'SHI' || $track_data['OrderStatus'] == 'POS' || $track_data['OrderStatus'] == 'CROC' || $track_data['OrderStatus'] == 'TAFC' || $track_data['OrderStatus'] == 'LSV' || $track_data['OrderStatus'] == 'CTZ' || $track_data['OrderStatus'] == 'COV' || $track_data['OrderStatus'] == 'CLD' || $track_data['OrderStatus'] == 'GDL' || $track_data['OrderStatus'] == 'WFH' || $track_data['OrderStatus'] == 'CNR' || $track_data['OrderStatus'] == 'OSA'){
                        
                        
                        if(empty($dispatch_model->first_ndr_reason)){
                            $dispatch_model->first_ndr_reason = $track_data['Message'];
                            $order_model->it_easy_ndr_tl = '0';
                            $order_model->it_easy_ndr_agent = '0';
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->second_ndr_reason)){
                            $dispatch_model->second_ndr_reason = $track_data['Message'];
                            $order_model->it_easy_ndr_tl = '0';
                            $order_model->it_easy_ndr_agent = '0';
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->third_ndr_reason)){
                            $dispatch_model->third_ndr_reason = $track_data['Message'];
                            $order_model->it_easy_ndr_tl = '0';
                            $order_model->it_easy_ndr_agent = '0';
                            $dispatch_model->save(false);
                        }
                        
                        if(empty($dispatch_model->last_ndr_reason)){
                            $dispatch_model->last_ndr_reason = $track_data['Message'];
                            $dispatch_model->save(false);
                        }
                        
                        
                        $order_model->it_easy_order_status_id = '9';
                        $order_model->it_easy_comment = $track_data['Message'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Message'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Message'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                         $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['OrderStatus'] == 'CBH' || $track_data['OrderStatus'] == 'CRD'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['Message'];
                        $order_model->save(false);
                        if(!empty($dispatch_model->rto_initiate_date)){
                        $dispatch_model->rto_initiate_date = $track_data['Time'];
                        }
                        $dispatch_model->it_easy_order_status = $track_data['Message'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Message'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['OrderStatus'] == 'RTO'){
                        $order_model->it_easy_order_status_id = '47';
                        $order_model->it_easy_comment = $track_data['Message'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Message'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Message'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_auto_rto_date =$time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['OrderStatus'] == 'RTU'){
                        $order_model->it_easy_order_status_id = '28';
                        $order_model->it_easy_comment = $track_data['Message'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Message'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Message'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['OrderStatus'] == 'LPI'){
                        $order_model->it_easy_order_status_id = '14';
                        $order_model->it_easy_comment = $track_data['Message'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Message'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Message'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['OrderStatus'] == 'NEW' || $track_data['OrderStatus'] == 'RAP' || $track_data['OrderStatus'] == 'ARP' || $track_data['OrderStatus'] == 'OFP' || $track_data['OrderStatus'] == 'ARV'){
                        $order_model->it_easy_order_status_id = '4';
                        $order_model->it_easy_comment = $track_data['Message'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Message'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Message'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['OrderStatus'] == 'CBH' || $track_data['OrderStatus'] == 'CRD'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['Message'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Message'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Message'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['OrderStatus'] == 'RTU'){
                        $order_model->it_easy_order_status_id = '28';
                        $order_model->it_easy_comment = $track_data['Message'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Message'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Message'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }
                    $model->save(false);
                    $json['code'] = '200';
                    $json['message'] = "Saved Successfully";
                    echo json_encode($json);
                }else{
                    $json['code'] = '407';
                    $json['message'] = "ORDER ID didn't match in system";
                    echo json_encode($json);
                }
                }else{
                    $json['code'] = '405';
                    $json['message'] = "This ".$track_data['AWB']."AWB Number didn't find in system";
                    echo json_encode($json);
                }
            //}
        }else{
            $json['code'] = '406';
            $json['message'] = "AWB NUMBER hasn't found";
            echo json_encode($json);
        }
        die;
        
    }
    
    
    public function actionProfessionaltracking(){
       
        // Get headers
        $headers = getallheaders();
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: *');
        
        // $expected_token = "UdfcAsjqaAOJHaSEHpx2N60UA9BZ49Eg";
        
        // $auth_header = '';

        // if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        //     $auth_header = $_SERVER['HTTP_AUTHORIZATION'];
        // } elseif (isset($_SERVER['REDIRECT_HTTP_AUTHORIZATION'])) {
        //     $auth_header = $_SERVER['REDIRECT_HTTP_AUTHORIZATION'];
        // } elseif (function_exists('apache_request_headers')) {
        //     $headers = apache_request_headers();
        //     if (isset($headers['Authorization'])) {
        //         $auth_header = $headers['Authorization'];
        //     }
        // }
        
        // // Check for Bearer token format
        // if (preg_match('/Bearer\s(\S+)/', $auth_header, $matches)) {
        //     $sent_token = $matches[1];
        
        //     if ($sent_token === $expected_token) {
                
        //     } else {
        //         http_response_code(401);
        //         echo json_encode([
        //             "success" => false,
        //             "message" => "Unauthorized: Invalid token."
        //         ]);
        //         die;
        //     }
        // } else {
        //     http_response_code(401);
        //     echo json_encode([
        //         "success" => false,
        //         "message" => "Unauthorized: Bearer token not provided."
        //     ]);
        //     die;
        // }
        
        $this->enableCsrfValidation = false;
        $track_datas = json_decode(file_get_contents("php://input"), true);
        
        
        if(isset($track_datas[0]['POD_NO']) && !empty($track_datas[0]['POD_NO'])){
            foreach($track_datas as $key => $track_data){
            
            $dispatch_model = ItEasyOrderDispatch::findOne(['it_easy_awb_number' => $track_data['POD_NO']]);
            
            if(!empty($dispatch_model)){
                $order_model = ItEasyOrder::findOne(['it_easy_order_id' => $dispatch_model->it_easy_order_id ]);
                
                if(!empty($order_model)){
                    $time_stamp= $track_data['Sys_Dt'].' '.$track_data['Sys_Tm'];
            
                    $model = new ItEasyQueryTracking();
                    $model->courier_name = 'Professional';
                    $model->order_id = $dispatch_model->it_easy_order_id;
                    $model->awb_number = $track_data['POD_NO'];
                    $model->cp_id = $track_data['id'];
                    $model->remark = $track_data['Remarks'];
                    $model->status_code = $track_data['Type'];
                    $model->reference_number = $track_data['Way_Number'];
                    $model->timestamp = $track_data['Type'];
                    $model->status_description_bucket = $track_data['Type'];
                    $model->location = $track_data['Area'];
                    $model->status_description = $track_data['Type'];
                    $model->query = json_encode($track_datas);
                    $model->status_time = date('Y-m-d H:i:s');
                    
                    if( $track_data['Status_code'] == 'PC' || $track_data['Status_code'] == 'PX' || $track_data['Status_code'] == 'PX' || $track_data['Status_code'] == 'PG' || $track_data['Status_code'] == 'NN' || $track_data['Status_code'] == 'AW' || $track_data['Status_code'] == 'SU' || $track_data['Status_code'] == 'SA'){
                        $order_model->it_easy_order_status_id = '31';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Type'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['Status_code'] == 'PU'){
                        $order_model->it_easy_placed_time = $time_stamp;
                        $order_model->it_easy_order_status_id = '29';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Type'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_pickup_time=date('Y-m-d H:i:s');
                        $dispatch_model->save(false);
                    }else if($track_data['Status_code'] == 'DX' || $track_data['Status_code'] == 'ND' || $track_data['Status_code'] == 'AC' || $track_data['Status_code'] == 'AW' || $track_data['Status_code'] == 'BW' || $track_data['Status_code'] == 'BI' || $track_data['Status_code'] == 'BU' || $track_data['Status_code'] == 'CE' || $track_data['Status_code'] == 'EA' || $track_data['Status_code'] == 'FA' || $track_data['Status_code'] == 'FD' || $track_data['Status_code'] == 'LA' || $track_data['Status_code'] == 'UC'){
                        $order_model->it_easy_order_status_id = '27';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Type'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['Status_code'] == 'TD' || $track_data['Status_code'] == 'OA'){
                        if(empty($dispatch_model->it_easy_first_scan_date)){
                            $dispatch_model->it_easy_first_scan_date = $track_data['Sys_Dt'].' '.$track_data['Sys_Tm'];
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->second_attempt_date)){
                            $dispatch_model->second_attempt_date = $track_data['Sys_Dt'].' '.$track_data['Sys_Tm'];
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->third_attempt_date)){
                            $dispatch_model->third_attempt_date = $track_data['Sys_Dt'].' '.$track_data['Sys_Tm'];
                            $dispatch_model->save(false);
                        }
                        
                        if(empty($dispatch_model->it_easy_last_scan_date)){
                            $dispatch_model->it_easy_last_scan_date = $track_data['Sys_Dt'].' '.$track_data['Sys_Tm'];
                            $dispatch_model->it_easy_attempt_count = '1';
                            $dispatch_model->save(false);
                        }else{
                            if(date('Y-m-d') != date('Y-m-d', strtotime($dispatch_model->it_easy_last_scan_date))){
                                $dispatch_model->it_easy_last_scan_date = $track_data['Sys_Dt'].' '.$track_data['Sys_Tm'];
                                $dispatch_model->it_easy_attempt_count = $dispatch_model->it_easy_attempt_count +1;
                                $dispatch_model->save(false);
                            }
                        }
                        
                        
                        
                        $order_model->it_easy_order_status_id = '30';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Type'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['Status_code'] == 'DE' || $track_data['Status_code'] == 'DB' || $track_data['Status_code'] == 'CR' || $track_data['Status_code'] == 'HB' || $track_data['Status_code'] == 'OD' || $track_data['Status_code'] == 'RP' || $track_data['Status_code'] == 'VW'){
                        
                        $order_model->it_easy_order_status_id = '3';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->it_easy_delivered_time = $time_stamp;
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = 'Delivered';
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_delivery_date = $time_stamp;
                        $dispatch_model->save(false);
                          $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['Status_code'] == 'WN' || $track_data['Status_code'] == 'VI' || $track_data['Status_code'] == 'TU' || $track_data['Status_code'] == 'TN' || $track_data['Status_code'] == 'SP' || $track_data['Status_code'] == 'CQ' || $track_data['Status_code'] == 'CP' || $track_data['Status_code'] == 'DV' || $track_data['Status_code'] == 'SN' || $track_data['Status_code'] == 'SD' || $track_data['Status_code'] == 'RD' || $track_data['Status_code'] == 'RG' || $track_data['Status_code'] == 'RF' || $track_data['Status_code'] == 'RA' || $track_data['Status_code'] == 'PP' || $track_data['Status_code'] == 'PB' || $track_data['Status_code'] == 'PT' || $track_data['Status_code'] == 'PS' || $track_data['Status_code'] == 'RT' || $track_data['Status_code'] == 'PR' || $track_data['Status_code'] == 'PO' || $track_data['Status_code'] == 'PL' || $track_data['Status_code'] == 'PO' || $track_data['Status_code'] == 'PN' || $track_data['Status_code'] == 'PE' || $track_data['Status_code'] == 'OI' || $track_data['Status_code'] == 'TO' || $track_data['Status_code'] == 'OH' || $track_data['Status_code'] == 'NL' || $track_data['Status_code'] == 'NT' || $track_data['Status_code'] == 'NP' || $track_data['Status_code'] == 'NC' || $track_data['Status_code'] == 'NB' || $track_data['Status_code'] == 'NS' || $track_data['Status_code'] == 'NR' || $track_data['Status_code'] == 'NE' || $track_data['Status_code'] == 'NI' || $track_data['Status_code'] == 'MS' || $track_data['Status_code'] == 'MR' || $track_data['Status_code'] == 'LT' || $track_data['Status_code'] == 'LR' || $track_data['Status_code'] == 'LD' || $track_data['Status_code'] == 'LM' || $track_data['Status_code'] == 'LF' || $track_data['Status_code'] == 'LA' || $track_data['Status_code'] == 'IS' || $track_data['Status_code'] == 'IT' || $track_data['Status_code'] == 'VS' || $track_data['Status_code'] == 'IA' || $track_data['Status_code'] == 'HL' || $track_data['Status_code'] == 'HR' || $track_data['Status_code'] == 'HP' || $track_data['Status_code'] == 'HO' || $track_data['Status_code'] == 'HU' || $track_data['Status_code'] == 'HN' || $track_data['Status_code'] == 'AR' || $track_data['Status_code'] == 'CO' || $track_data['Status_code'] == 'HD' || $track_data['Status_code'] == 'FD' || $track_data['Status_code'] == 'FA' || $track_data['Status_code'] == 'FO' || $track_data['Status_code'] == 'EP' || $track_data['Status_code'] == 'EA' || $track_data['Status_code'] == 'DL' || $track_data['Status_code'] == 'DA' || $track_data['Status_code'] == 'SS' || $track_data['Status_code'] == 'RN' || $track_data['Status_code'] == 'CF' || $track_data['Status_code'] == 'CW' || $track_data['Status_code'] == 'CV' || $track_data['Status_code'] == 'CA' || $track_data['Status_code'] == 'CN' || $track_data['Status_code'] == 'PI' || $track_data['Status_code'] == 'CT' || $track_data['Status_code'] == 'CS' || $track_data['Status_code'] == 'LK' || $track_data['Status_code'] == 'CC' || $track_data['Status_code'] == 'CL' || $track_data['Status_code'] == 'CT' || $track_data['Status_code'] == 'BU' || $track_data['Status_code'] == 'AI' || $track_data['Status_code'] == 'AN'){
                        
                        if(empty($dispatch_model->first_ndr_reason)){
                            $dispatch_model->first_ndr_reason = $track_data['Remarks'];
                            $order_model->it_easy_ndr_tl = '0';
                            $order_model->it_easy_ndr_agent = '0';
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->second_ndr_reason)){
                            $dispatch_model->second_ndr_reason = $track_data['Remarks'];
                            $order_model->it_easy_ndr_tl = '0';
                            $order_model->it_easy_ndr_agent = '0';
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->third_ndr_reason)){
                            $dispatch_model->third_ndr_reason = $track_data['Remarks'];
                            $order_model->it_easy_ndr_tl = '0';
                            $order_model->it_easy_ndr_agent = '0';
                            $dispatch_model->save(false);
                        }
                        
                        if(empty($dispatch_model->last_ndr_reason)){
                            $dispatch_model->last_ndr_reason = $track_data['Remarks'];
                            $dispatch_model->save(false);
                        }
                        $order_model->it_easy_order_status_id = '9';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Remarks'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Type'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                         $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['Status_code'] == 'AW' || $track_data['Status_code'] ==  'BC' || $track_data['Status_code'] ==  'PC'){
                        $order_model->it_easy_order_status_id = '8';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Type'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['Status_code'] == 'RC' || $track_data['Status_code'] == 'RB' || $track_data['Status_code'] == 'RR'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        if(empty($dispatch_model->rto_initiate_date)){
                            $dispatch_model->rto_initiate_date = $track_data['Sys_Dt'].' '.$track_data['Sys_Tm'];
                        }
                        $dispatch_model->it_easy_order_status = $track_data['Type'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['Status_code'] == 'RE' || $track_data['Status_code'] == 'RO' || $track_data['Status_code'] == 'RS'){
                        $order_model->it_easy_order_status_id = '47';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Type'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_auto_rto_date =$time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['Status_code'] == 'HD'){
                        $order_model->it_easy_order_status_id = '14';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Type'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['Status_code'] == 'DC' || $track_data['Status_code'] == 'LO' || $track_data['Status_code'] == 'LM' || $track_data['Status_code'] == 'MR'){
                        $order_model->it_easy_order_status_id = '14';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Type'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['Status_code'] == 'OP' || $track_data['Status_code'] == 'SU'){
                        $order_model->it_easy_order_status_id = '4';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Type'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['Status_code'] == 'RB' || $track_data['Status_code'] == 'RC'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        if(empty($dispatch_model->rto_initiate_date)){
                            $dispatch_model->rto_initiate_date = $track_data['Sys_Dt'].' '.$track_data['Sys_Tm'];
                        }
                        $dispatch_model->it_easy_order_status = $track_data['Type'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }
                    $model->save(false);
                    $json['code'] = '200';
                    $json['message'] = "Saved Successfully";
                    echo json_encode($json);
                }else{
                    $json['code'] = '407';
                    $json['message'] = "ORDER ID didn't match in system";
                    echo json_encode($json);
                }
                }else{
                    $json['code'] = '405';
                    $json['message'] = "This ".$track_datas[0]['POD_NO']."AWB Number didn't find in system";
                    echo json_encode($json);
                }
            }
        }else{
            $json['code'] = '406';
            $json['message'] = "AWB NUMBER hasn't found";
            echo json_encode($json);
        }
        die;
        
    }
    
    
    
    public function actionXpressbeestracking(){
       
        // Get headers
        $headers = getallheaders();
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: *');
        
        // $expected_token = "UdfcAsjqaAOJHaSEHpx2N60UA9BZ49Eg";
        
        // $auth_header = '';

        // if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        //     $auth_header = $_SERVER['HTTP_AUTHORIZATION'];
        // } elseif (isset($_SERVER['REDIRECT_HTTP_AUTHORIZATION'])) {
        //     $auth_header = $_SERVER['REDIRECT_HTTP_AUTHORIZATION'];
        // } elseif (function_exists('apache_request_headers')) {
        //     $headers = apache_request_headers();
        //     if (isset($headers['Authorization'])) {
        //         $auth_header = $headers['Authorization'];
        //     }
        // }
        
        // // Check for Bearer token format
        // if (preg_match('/Bearer\s(\S+)/', $auth_header, $matches)) {
        //     $sent_token = $matches[1];
        
        //     if ($sent_token === $expected_token) {
                
        //     } else {
        //         http_response_code(401);
        //         echo json_encode([
        //             "success" => false,
        //             "message" => "Unauthorized: Invalid token."
        //         ]);
        //         die;
        //     }
        // } else {
        //     http_response_code(401);
        //     echo json_encode([
        //         "success" => false,
        //         "message" => "Unauthorized: Bearer token not provided."
        //     ]);
        //     die;
        // }
        $this->enableCsrfValidation = false;
        $track_data = json_decode(file_get_contents("php://input"), true);
        
        // $model = new ItEasyQueryTracking();
        // $model->courier_name = 'Xpressbees';
        // $model->order_id = '11111';
        // $model->awb_number = '888888888';
        // $model->cp_id = '88';
        // $model->remark = 'Delivered';
        // $model->status_code = 'Delivered';
        // $model->reference_number = 'Delivered';
        // $model->timestamp = date('Y-m-d H:i:s');
        // $model->status_description_bucket = 'Delivered';
        // $model->location = 'Delivered';
        // $model->status_description = 'Delivered';
        // $model->query = json_encode($track_data);
        // $model->status_time = date('Y-m-d H:i:s');
        // $model->save(false);
        // die;
        
        if(isset($track_data['AWBNO']) && !empty($track_data['AWBNO'])){
            //foreach($track_datas as $key => $track_data){
            
            $dispatch_model = ItEasyOrderDispatch::find()->where(['it_easy_awb_number' => $track_data['AWBNO']])->andWhere(['!=', 'it_easy_order_status', 'Delivered'])->one();
            
            if(!empty($dispatch_model)){
                $order_model = ItEasyOrder::findOne(['it_easy_order_id' => $dispatch_model->it_easy_order_id ]);
                
                if(!empty($order_model)){
                    $time_stamp= date('Y-m-d', strtotime($track_data['StatusDate'])).' '.date('H:i:s');
                    
                    $model = new ItEasyQueryTracking();
                    $model->courier_name = 'Xpressbees';
                    $model->order_id = $dispatch_model->it_easy_order_id;
                    $model->awb_number = $track_data['AWBNO'];
                    $model->cp_id = $track_data['AWBNO'];
                    $model->remark = $track_data['Remarks'];
                    $model->status_code = $track_data['StatusCode'];
                    $model->reference_number = $track_data['AWBNO'];
                    $model->timestamp = $time_stamp;
                    $model->status_description_bucket = $track_data['Remarks'];
                    $model->location = $track_data['CurrentLocation'];
                    $model->status_description = $track_data['Remarks'];
                    $model->query = json_encode($track_data);
                    $model->status_time = date('Y-m-d H:i:s');
                    
                    
                    if( $track_data['StatusCode'] == 'PND'){
                        $order_model->it_easy_order_status_id = '31';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Remarks'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['StatusCode'] == 'PUD' || $track_data['StatusCode']  == 'PKD'){
                        $order_model->it_easy_placed_time = $time_stamp;
                        $order_model->it_easy_order_status_id = '29';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Remarks'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_pickup_time=date('Y-m-d H:i:s');
                        $dispatch_model->save(false);
                    }else if($track_data['StatusCode'] == 'IT' || $track_data['StatusCode'] == 'RAD' || $track_data['StatusCode'] == 'STD'){
                        $order_model->it_easy_order_status_id = '27';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Remarks'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['StatusCode'] == 'OFD'){
                        
                        
                        if(empty($dispatch_model->it_easy_first_scan_date)){
                            $dispatch_model->it_easy_first_scan_date = date('Y-m-d H:i:s');
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->second_attempt_date)){
                            $dispatch_model->second_attempt_date = date('Y-m-d H:i:s');
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->third_attempt_date)){
                            $dispatch_model->third_attempt_date = date('Y-m-d H:i:s');
                            $dispatch_model->save(false);
                        }
                        
                        if(empty($dispatch_model->it_easy_last_scan_date)){
                            $dispatch_model->it_easy_last_scan_date = date('Y-m-d H:i:s');
                            $dispatch_model->it_easy_attempt_count = '1';
                            $dispatch_model->save(false);
                        }else{
                            if(date('Y-m-d') != date('Y-m-d', strtotime($dispatch_model->it_easy_last_scan_date))){
                                $dispatch_model->it_easy_last_scan_date = date('Y-m-d H:i:s');
                                $dispatch_model->it_easy_attempt_count = $dispatch_model->it_easy_attempt_count +1;
                                $dispatch_model->save(false);
                            }
                        }
                        
                        
                        
                        $order_model->it_easy_order_status_id = '30';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Remarks'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['StatusCode'] == 'DLVD'){
                        
                        $order_model->it_easy_order_status_id = '3';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->it_easy_delivered_time = $time_stamp;
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = 'Delivered';
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_delivery_date = $time_stamp;
                        $dispatch_model->save(false);
                          $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['StatusCode'] == 'UD'){
                        if(empty($dispatch_model->first_ndr_reason)){
                            $dispatch_model->first_ndr_reason = $track_data['Remarks'];
                            $order_model->it_easy_ndr_tl = '0';
                            $order_model->it_easy_ndr_agent = '0';
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->second_ndr_reason)){
                            $dispatch_model->second_ndr_reason = $track_data['Remarks'];
                            $order_model->it_easy_ndr_tl = '0';
                            $order_model->it_easy_ndr_agent = '0';
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->third_ndr_reason)){
                            $dispatch_model->third_ndr_reason = $track_data['Remarks'];
                            $order_model->it_easy_ndr_tl = '0';
                            $order_model->it_easy_ndr_agent = '0';
                            $dispatch_model->save(false);
                        }
                        if(empty($dispatch_model->last_ndr_reason)){
                            $dispatch_model->last_ndr_reason = $track_data['Remarks'];
                            $dispatch_model->save(false);
                        }
                        
                        $order_model->it_easy_order_status_id = '9';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Remarks'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                         $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['StatusCode'] == 'RTON' || $track_data['StatusCode'] == 'RTO-IT' || $track_data['StatusCode'] == 'RAO'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        if(empty($dispatch_model->rto_initiate_date)){
                            $dispatch_model->rto_initiate_date = date('Y-m-d H:i:s');
                        }
                        $dispatch_model->it_easy_order_status = $track_data['Remarks'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['StatusCode'] == 'RTD'){
                        $order_model->it_easy_order_status_id = '47';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Remarks'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_auto_rto_date =$time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['StatusCode'] == 'RTU'){
                        $order_model->it_easy_order_status_id = '28';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Remarks'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['StatusCode'] == 'Shipment LOST' || $track_data['StatusCode'] == 'STG'){
                        $order_model->it_easy_order_status_id = '14';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Remarks'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['StatusCode'] == 'DRC' || $track_data['StatusCode'] == 'OFP'){
                        $order_model->it_easy_order_status_id = '4';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Remarks'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['StatusCode'] == 'RTO-STG' || $track_data['StatusCode'] == 'RTO'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        if(empty($dispatch_model->rto_initiate_date)){
                            $dispatch_model->rto_initiate_date = date('Y-m-d H:i:s');
                        }
                        $dispatch_model->it_easy_order_status = $track_data['Remarks'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['StatusCode'] == 'RTU'){
                        $order_model->it_easy_order_status_id = '28';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Remarks'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['StatusCode'] == 'PUD'){
                        $order_model->it_easy_order_status_id = '29';
                        $order_model->it_easy_comment = $track_data['Remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['Remarks'];
                        $dispatch_model->it_easy_courier_comment = $track_data['Remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_pickup_time=date('Y-m-d H:i:s');
                        $dispatch_model->save(false);
                    }
                    $model->save(false);
                    $json['code'] = '200';
                    $json['message'] = "Saved Successfully";
                    echo json_encode($json);
                }else{
                    $json['code'] = '407';
                    $json['message'] = "ORDER ID didn't match in system";
                    echo json_encode($json);
                }
                }else{
                    $json['code'] = '405';
                    $json['message'] = "This ".$track_data['shipment_details'][0]['awb']."AWB Number didn't find in system";
                    echo json_encode($json);
                }
            // }
        }else{
            $json['code'] = '406';
            $json['message'] = "AWB NUMBER hasn't found";
            echo json_encode($json);
        }
        die;
        
    }
     
    
    public function actionBlitztracking(){
       
        // Get headers
        $headers = getallheaders();
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: *');
        
    

        $this->enableCsrfValidation = false;
        $track_data = json_decode(file_get_contents("php://input"), true);
        
        
        
        
        if(isset($track_data['awb']) && !empty($track_data['awb'])){
            //foreach($track_datas['records'] as $key => $track_data){
            
            $dispatch_model = ItEasyOrderDispatch::findOne(['it_easy_awb_number' => $track_data['awb']]);
            
            if(!empty($dispatch_model)){
                $order_model = ItEasyOrder::findOne(['it_easy_order_id' => $dispatch_model->it_easy_order_id ]);
                
                if(!empty($order_model)){
                    if(isset($track_data['updateTime']) && !empty($track_data['updateTime'])){
                        $time_date = explode('T', $track_data['updateTime']);
                        $time_time = explode('.', $time_date[1]);
                        $time_stamp = $time_date[0].' '.$time_time[0];
                    }else{
                        $time_stamp = date('Y-m-d H:i:s');
                    }
                    $model = new ItEasyQueryTracking();
                    $model->courier_name = 'Blitz';
                    $model->order_id = $dispatch_model->it_easy_order_id;
                    $model->awb_number = $track_data['awb'];
                    $model->cp_id = $track_data['shipmentId'];
                    $model->remark = $track_data['remarks'];
                    $model->status_code = $track_data['status'];
                    $model->reference_number = $track_data['shopOrderNumber'];
                    $model->timestamp = $time_stamp;
                    $model->status_description_bucket = $track_data['status'];
                    $model->location = $track_data['location'];
                    $model->status_description = $track_data['status'];
                    $model->query = json_encode($track_data);
                    $model->status_time = date('Y-m-d H:i:s');
                    
                    if( $track_data['status'] == 'Pickup Failed'){
                        $order_model->it_easy_order_status_id = '31';
                        $order_model->it_easy_comment = $track_data['remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['status'] == 'Picked-up'){
                        $order_model->it_easy_placed_time = $time_stamp;
                        $order_model->it_easy_order_status_id = '29';
                        $order_model->it_easy_comment = $track_data['remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_pickup_time=date('Y-m-d H:i:s');
                        $dispatch_model->save(false);
                    }else if($track_data['status'] == 'In-Transit' || $track_data['status'] == 'Packed' || $track_data['status'] == 'Picked from Rack' || $track_data['status'] == 'Reached Nearest Hub' || $track_data['status'] == 'Reached Destination City'){
                        $order_model->it_easy_order_status_id = '27';
                        $order_model->it_easy_comment = $track_data['remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['status'] == 'Out for Delivery'){
                        if(empty($dispatch_model->it_easy_first_scan_date)){
                            $dispatch_model->it_easy_first_scan_date = date('Y-m-d H:i:s');
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->second_attempt_date)){
                            $dispatch_model->second_attempt_date = date('Y-m-d H:i:s');
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->third_attempt_date)){
                            $dispatch_model->third_attempt_date = date('Y-m-d H:i:s');
                            $dispatch_model->save(false);
                        }
                        
                        if(empty($dispatch_model->it_easy_last_scan_date)){
                            $dispatch_model->it_easy_last_scan_date = date('Y-m-d H:i:s');
                            $dispatch_model->it_easy_attempt_count = '1';
                            $dispatch_model->save(false);
                        }else{
                            if(date('Y-m-d') != date('Y-m-d', strtotime($dispatch_model->it_easy_last_scan_date))){
                                $dispatch_model->it_easy_last_scan_date = date('Y-m-d H:i:s');
                                $dispatch_model->it_easy_attempt_count = $dispatch_model->it_easy_attempt_count +1;
                                $dispatch_model->save(false);
                            }
                        }
                        
                        
                        
                        $order_model->it_easy_order_status_id = '30';
                        $order_model->it_easy_comment = $track_data['remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['status'] == 'Delivered'){
                        
                        $order_model->it_easy_order_status_id = '3';
                        $order_model->it_easy_comment = $track_data['remarks'];
                        $order_model->it_easy_delivered_time = $time_stamp;
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = 'Delivered';
                        $dispatch_model->it_easy_courier_comment = $track_data['remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_delivery_date = $time_stamp;
                        $dispatch_model->save(false);
                          $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['status'] == 'Delivery Delay' || $track_data['status'] == 'Failed Delivered' || $track_data['status'] == 'NDR Initiated' || $track_data['status'] == 'Inventory not available'){
                        
                        
                        if(empty($dispatch_model->first_ndr_reason)){
                            $dispatch_model->first_ndr_reason = $track_data['remarks'];
                            $order_model->it_easy_ndr_tl = '0';
                            $order_model->it_easy_ndr_agent = '0';
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->second_ndr_reason)){
                            $dispatch_model->second_ndr_reason = $track_data['remarks'];
                            $order_model->it_easy_ndr_tl = '0';
                            $order_model->it_easy_ndr_agent = '0';
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->third_ndr_reason)){
                            $dispatch_model->third_ndr_reason = $track_data['remarks'];
                            $order_model->it_easy_ndr_tl = '0';
                            $order_model->it_easy_ndr_agent = '0';
                            $dispatch_model->save(false);
                        }
                        if(empty($dispatch_model->last_ndr_reason)){
                            $dispatch_model->last_ndr_reason = $track_data['remarks'];
                            $dispatch_model->save(false);
                        }
                        
                        $order_model->it_easy_order_status_id = '9';
                        $order_model->it_easy_comment = $track_data['remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                         $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['status'] == 'Cancelled' || $track_data['status'] == 'Shipment Failed'){
                        $order_model->it_easy_order_status_id = '8';
                        $order_model->it_easy_comment = $track_data['remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['status'] == 'RTO Initiated' || $track_data['status'] == 'RTO Freeze'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['remarks'];
                        $order_model->save(false);
                        if(empty($dispatch_model->rto_initiate_date)){
                            $dispatch_model->rto_initiate_date = date('Y-m-d H:i:s');
                        }
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['status'] == 'RTO Delivered'){
                        $order_model->it_easy_order_status_id = '47';
                        $order_model->it_easy_comment = $track_data['remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_auto_rto_date =$time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['status'] == 'RTO Delivery Delay' || $track_data['status'] == 'RTO Failed Delivered'){
                        $order_model->it_easy_order_status_id = '28';
                        $order_model->it_easy_comment = $track_data['remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['status'] == 'Damaged' || $track_data['status'] == 'Lost'){
                        $order_model->it_easy_order_status_id = '14';
                        $order_model->it_easy_comment = $track_data['remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['status'] == 'To be Picked' || $track_data['status'] == 'Shipment Created' || $track_data['status'] == 'Out for Pickup'){
                        $order_model->it_easy_order_status_id = '4';
                        $order_model->it_easy_comment = $track_data['remarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['status'] == 'RTO In-Transit'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['remarks'];
                        $order_model->save(false);
                        if(empty($dispatch_model->rto_initiate_date)){
                            $dispatch_model->rto_initiate_date = date('Y-m-d H:i:s');
                        }
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['status'] == 'RTO Out for Delivery'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['remarks'];
                        $order_model->save(false);
                        if(empty($dispatch_model->rto_initiate_date)){
                            $dispatch_model->rto_initiate_date = date('Y-m-d H:i:s');
                        }
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }
                    $model->save(false);
                    $json['code'] = '200';
                    $json['message'] = "Saved Successfully";
                    echo json_encode($json);
                }else{
                    $json['code'] = '407';
                    $json['message'] = "ORDER ID didn't match in system";
                    echo json_encode($json);
                }
                }else{
                    $json['code'] = '405';
                    $json['message'] = "This ".$track_data['awb']."AWB Number didn't find in system";
                    echo json_encode($json);
                }
            //}
        }else{
            $json['code'] = '406';
            $json['message'] = "AWB NUMBER hasn't found";
            echo json_encode($json);
        }
        die;
        
    }
    
    
    public function actionBluedarttracking(){
       
        // Get headers
        $headers = getallheaders();
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: *');
        
    

        $this->enableCsrfValidation = false;
        $track_data = json_decode(file_get_contents("php://input"), true);
        
        $validApiKey = "UdfcAsjqaAOJHaSEHpx2N60UA9BZ49Eg";

        $providedApiKey = '';

        if (isset($_SERVER['HTTP_X_API_KEY'])) {
            $providedApiKey = $_SERVER['HTTP_X_API_KEY'];
        } elseif (isset($_SERVER['REDIRECT_HTTP_X_API_KEY'])) {
            $providedApiKey = $_SERVER['REDIRECT_HTTP_X_API_KEY'];
        } elseif (function_exists('apache_request_headers')) {
            $providedApiKey = apache_request_headers();
            if (isset($headers['x-api-key'])) {
                $providedApiKey = $headers['x-api-key'];
            }
        }
        
        
        
        // Validate API key
        if ($providedApiKey !== $validApiKey) {
            http_response_code(401);
            echo json_encode(['error' => 'Unauthorized: Invalid API key']);
            exit;
        }else{
            //echo json_encode(['error' => 'success']);
        }
        
        if(isset($track_data['statustracking'][0]['Shipment']['WaybillNo']) && !empty($track_data['statustracking'][0]['Shipment']['WaybillNo'])){
            //foreach($track_datas['records'] as $key => $track_data){
            
            $dispatch_model = ItEasyOrderDispatch::findOne(['it_easy_awb_number' => $track_data['statustracking'][0]['Shipment']['WaybillNo']]);
            
            if(!empty($dispatch_model)){
                $order_model = ItEasyOrder::findOne(['it_easy_order_id' => $dispatch_model->it_easy_order_id ]);
                
                if(!empty($order_model)){
                    if(isset($track_data['updateTime']) && !empty($track_data['updateTime'])){
                        $scanDate = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['ScanDate'];
                        $scanTime = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['ScanTime'];
                        $hour = substr($scanTime, 0, 2);
                        $minute = substr($scanTime, 2, 2);
                        $formattedTime = $hour . ":" . $minute . ":00";
                        $time_stamp = \DateTime::createFromFormat('d-m-Y H:i:s', $scanDate . ' ' . $formattedTime);
                    }else{
                        $time_stamp = date('Y-m-d H:i:s');
                    }
                    $model = new ItEasyQueryTracking();
                    $model->courier_name = 'Bluedart';
                    $model->order_id = $dispatch_model->it_easy_order_id;
                    $model->awb_number = $track_data['statustracking'][0]['Shipment']['WaybillNo'];
                    $model->cp_id = $track_data['statustracking'][0]['Shipment']['RefNo'];
                    $model->remark = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                    $model->status_code = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['ScanCode'];
                    $model->reference_number = $track_data['statustracking'][0]['Shipment']['RefNo'];
                    $model->timestamp = $time_stamp;
                    $model->status_description_bucket = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                    $model->location = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['ScannedLocationCity'];
                    $model->status_description = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                    $model->query = json_encode($track_data);
                    $model->status_time = date('Y-m-d H:i:s');
                    
                    if($track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'P/U MISSED-OPS REACHED LATE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'P/U MISSED-PROMISED REATTEMPT BY OPS' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'P/U MISSED-PICKUP NOT PASED BY C.S.' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'REGISTERED FOR COUNTER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'P/U MISSED-CALL NOT RECD FROM P/U STAFF' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'P/U MISSED-STAFF MET WITH AN ACCIDENT' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'P/U MISSED-STAFF VEHICLE BROKE DOWN' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'P/U MISSED-VEHICLE REQMT NOT CONVEYED-CS' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'P/U DECLINED - PROHIBITED ITEM' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'P/U NOT DONE - INCOMPLETE PAPERWORK' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'P/U NOT DONE/PINCODE NOT SERVED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'PICKUP WRONGLY REGISTERED BY SHIPPER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'P/U UNSUCCESSFUL; DOOR CLOSED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPMENT NOT READY-SENT TO COUNTER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPMENT NOT READY-NEXT DAY P/U REQUEST' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'NO SHIPMENT TODAY' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'PICKUP CANCELLED BY SHIPPER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'HOLIDAY - SHIPPER CLOSED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'NO SHPTS; SHIPPER WITH MULTIPLE A/C CODE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'E-COM SHPT P/U AND SENT TO CPU FOR CONX' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'ETAIL REVERSE-PU HANDED TO OTHR COURIER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'NO PACKAGE AVAILABLE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'PICKUP NOT DONE/REMOTE AREA' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'P/U ADDRESS INCOMPLETE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'ETAIL REVERSE-SHPT PICKED UP ON DIFF AWB' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'RE-SCHEDULED BY CONSIGNEE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'COUNTER DROP BY CALL' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'NOT REACHED BY CALL' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'AUTO DIALER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'PICKUP CANCELLED; QUALITY CHECK FAILED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'DATA REJECTED. PICKUP NOT REGISTERED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'Shipment changed from Closed to Open RVP' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'FAILED IN RVP TYPE CONVERSION' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'PRE CALL: INCORRECT PHONE NUMBER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'EXCHANGE: FORWARD SHIPMENT DELAYED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'Inscan Rejected- Not allowed'){

                        
                        $order_model->it_easy_order_status_id = '31';
                        $order_model->it_easy_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $dispatch_model->it_easy_courier_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'PICK UP SCAN ON FIELD'){
                        $order_model->it_easy_placed_time = $time_stamp;
                        $order_model->it_easy_order_status_id = '29';
                        $order_model->it_easy_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $dispatch_model->it_easy_courier_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_pickup_time = $time_stamp;
                        $dispatch_model->save(false);
                    }else if(($track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPMENT SCAN TALLIED/ SLAH TALLY' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPMENT INSCAN' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPMENT OUTSCANNED TO NETWORK' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'PLASTIC BAG INSCAN' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'COMPANY ON STRIKE, CANNOT DELIVER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'POD SLIP INSCAN' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'HOLIDAY:DELIVERY ON NEXT WORKING DAY' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'CANVAS BAG CONSOLIDATED SCAN'   || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPT MANIFESTED;NOT RECD BY DESTINATION' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'SHIPMENT-AUTOSCAN' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'TRANSIT CONNECTION SCAN' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'PLASTIC BAG - AUTO TALLY' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'DIRECT CANVAS BAG SCANNED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'MIXED CANVAS BAG SCANNED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'CANVAS BAG IN SCAN AT DESTINATION LOC' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'CLUBBED CANVAS BAG SCAN' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'DISTURBANCE/NATURAL DISASTER/STRIKE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'BD FLIGHT DELAYED; BAD WEATHER/TECH SNAG' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'SHIPMENT REDIRECTED ON FRESH AWB' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'DELIVERY  SCHEDULED FOR NEXT WORKING DAY' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'PROCEDURAL DELAY IN DELIVERY EXPECTED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'APX/SFC AWB RECD,SHIPMENT NOT RECEIVED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'HANDED OVER TO AD-HOC/AGENT/SUB-COURIER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'LATE ARRIVAL/SCHED. FOR NEXT WORKING DAY' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'HELD AT PUD/HUB;REGULATORY PAPERWORK REQ' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'MISSED CONNECTION' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'NOT CONNECTED AS PER CUTOFF' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'SHIPMENT OFF-LOADED BY AIRLINE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'FLIGHT CANCELLED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'MISROUTE;WRONG PIN/ZIP BY SHIPPER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'COMM FLIGHT,VEH/TRAIN; DELAYED/CANCELLED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'TIME CONSTRAINT;UNABLE TO DELIVER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'TRANSPORT STRIKE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'MISROUTE/OVERCARRIED IN NETWORK' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'UNABLE TO DELIVER:DUE NATURAL DISASTER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'CCU HUB;TRANSHIPMENT PERMIT AWAITED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'PACKAGE INTERCHANGED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'SHP IMPOUNDED BY REGULATORY AUTHORITY' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'NOT CONNECTED, SPACE CONSTRAINT' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'DOD SHIPMENT DELIVERED, DD PENDING DELY' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'DOD SHIPMENT DELIVERED, DD PENDING DELY' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'CANVAS BAG RECEIVED AS OVERAGE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'SHIPMENT CANT TRAVEL ON DESIRED MODE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'APEX CONNECTED ON COMMERCIAL FLIGHT' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHPT CAN'T TRAVEL ON DESIRED MODE" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'LINEHAUL DELAYED; ACCIDENT/TRAFFIC-JAM' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'LINEHAUL DELAYED;TRAFFICJAM ENROUTE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "DETAINED AT ORIGIN" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SECURITY CLEARED" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "CHANGE IN MODE/NEW AWB CUT" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "APEX TRANSIT ON COMM FLT;CCU HUB" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "AWB WRONGLY INSCANNED" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "AWB WRONGLY INSCANNED" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "UNDER SECURITY INVESTIGATION" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "DP DUTS HELD AT CCU W/H" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "PLEASE CONTACT CUSTOMER SERVICE"  ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'CORRECTION OF WRONG POD DETAILS'
                      || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'AWAITING CNEE FEEDBACK TO SORRY CARD' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHPT DETAINED/SEIZED BY REGULATORY" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHIPMENT RECEIVED;PAPERWORK NOT RECEIVED" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'SHIPMENT KEPT IN PARCEL LOCKER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHIPMENT RETRIEVED FROM PARCEL LOCKER" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHIPMENT KEPT IN PARCEL SHOP FOR COLLECT" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "DG SHIPMENT SCAN IN LOCATION" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "LOAD ON HOLD;SPACE CONSTRAINT-DELVRY LOC" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "LOAD ON HOLD;SPACE CONSTRAINT IN NET VEH" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "LOAD ON HOLD;SPACE CONSTRAINT-COMML FLT" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "LOAD ON HOLD; EMBARGO ON COMML UPLIFT" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "LOAD ON HOLD; SPACE CONSTRAINT IN TRAIN" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "UNDELIVERED INSCAN" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "PAPER WORK INSCAN" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "IN TRANSIT" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "PKG HELD FOR TAXES" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "TRAFFIC JAM ENROUTE" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "CAUGHT FIRE INSIDE VEHICLE" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "DETAINED AT CHECK-POST" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "DELAYED BY ENROUTE SECTOR" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "HEAVY RAIN" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "ENDORSEMENT NOT DONE AT CHECK-POST" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "DETAINED BY SALES TAX" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "VEHICLE BREAK-DOWN ENROUTE" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "HEAVY FOG" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "CAPACITY CONSTRAINT; BULK DESPATCH" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "LOAD/VEHICLE ARRIVED AT DELIVERY LOC" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "ACCIDENT ENROUTE" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "POLITICAL DISTURBANCE" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "VENDOR FAULT" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "ANY OTHER CONTROLABLE REASON" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "OVERAGE DELETED" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "TRANSIT SCAN" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "APEX / SFC SHPT OVERCARRIED IN NETWORK" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "CHANGE IN WEIGHT EFFECTED" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHIPMENT UNDER COOLING BY AIRLINE" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "DC DESCREPANCY" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "DC RECEIVED FROM CNEE" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "ADMIN OVER-RIDE OF DC COUNT" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "POD/DC COPY SENT" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "POD/DC ACCURACY" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHIPMENT MOVED TO MOBILE OFFICE" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "UD SHPT SENDING BACK TO BDE FOR PROCESS" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "GSTN SITE NOT WORKING" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "UD SHPT RCVD FRM ASSOCIATE FOR PROCESSNG" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHPT RCD IN TRANSIT LOC; BEING CONNECTED" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHPT RCVD AT DESTN LOC FOR DLVRY ATTEMPT" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "ANY OTHER NON-CONTROLABLE REASON" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHIPMENT HANDED OVER TO ASSOCIATE" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHIPMENT BOOKED FOR EMBARGO LOCATION" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "DELIVERY BY APPOINTMENT" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "PLASTIC BAG / SHPT RECD W/O DESTN CODING" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "BAG ID MISMATCH" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "OTP GENERATED SUCCESSFULLY" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "LOAD/VEHICLE ARRIVAL AT TRANSIT HUB" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "GPS RUN ARRIVAL AT DESTINATION LOCATION" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "GPS RUN ARRIVAL AT TRANSIT HUB" || 
                    $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHIPMENT CONNX ON ADDITIONAL DAY BD FLT" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "BAG RECEIVED WITH INCORRECT BARCODE TAG;"  || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHIPMENT SNATCHED ON FIELD"  || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "BAG ID MISMATCH"  || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "UNDELIVERED SHIPMENT HELD AT LOCATION" ) && ($track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['ScanGroupType'] == "RS" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['ScanGroupType'] == "RT" ) ){
                        
                        
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = "IN-Transit";
                        $dispatch_model->it_easy_courier_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if(($track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPMENT SCAN TALLIED/ SLAH TALLY' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPMENT INSCAN' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPMENT OUTSCANNED TO NETWORK' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'PLASTIC BAG INSCAN' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'COMPANY ON STRIKE, CANNOT DELIVER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'POD SLIP INSCAN' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'HOLIDAY:DELIVERY ON NEXT WORKING DAY' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'CANVAS BAG CONSOLIDATED SCAN'   || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPT MANIFESTED;NOT RECD BY DESTINATION' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'SHIPMENT-AUTOSCAN' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'TRANSIT CONNECTION SCAN' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'PLASTIC BAG - AUTO TALLY' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'DIRECT CANVAS BAG SCANNED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'MIXED CANVAS BAG SCANNED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'CANVAS BAG IN SCAN AT DESTINATION LOC' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'CLUBBED CANVAS BAG SCAN' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'DISTURBANCE/NATURAL DISASTER/STRIKE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'BD FLIGHT DELAYED; BAD WEATHER/TECH SNAG' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'SHIPMENT REDIRECTED ON FRESH AWB' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'DELIVERY  SCHEDULED FOR NEXT WORKING DAY' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'PROCEDURAL DELAY IN DELIVERY EXPECTED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'APX/SFC AWB RECD,SHIPMENT NOT RECEIVED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'HANDED OVER TO AD-HOC/AGENT/SUB-COURIER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'LATE ARRIVAL/SCHED. FOR NEXT WORKING DAY' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'HELD AT PUD/HUB;REGULATORY PAPERWORK REQ' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'MISSED CONNECTION' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'NOT CONNECTED AS PER CUTOFF' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'SHIPMENT OFF-LOADED BY AIRLINE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'FLIGHT CANCELLED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'MISROUTE;WRONG PIN/ZIP BY SHIPPER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'COMM FLIGHT,VEH/TRAIN; DELAYED/CANCELLED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'TIME CONSTRAINT;UNABLE TO DELIVER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'TRANSPORT STRIKE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'MISROUTE/OVERCARRIED IN NETWORK' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'UNABLE TO DELIVER:DUE NATURAL DISASTER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'CCU HUB;TRANSHIPMENT PERMIT AWAITED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'PACKAGE INTERCHANGED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'SHP IMPOUNDED BY REGULATORY AUTHORITY' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'NOT CONNECTED, SPACE CONSTRAINT' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'DOD SHIPMENT DELIVERED, DD PENDING DELY' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'DOD SHIPMENT DELIVERED, DD PENDING DELY' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'CANVAS BAG RECEIVED AS OVERAGE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'SHIPMENT CANT TRAVEL ON DESIRED MODE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'APEX CONNECTED ON COMMERCIAL FLIGHT' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHPT CAN'T TRAVEL ON DESIRED MODE" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'LINEHAUL DELAYED; ACCIDENT/TRAFFIC-JAM' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'LINEHAUL DELAYED;TRAFFICJAM ENROUTE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "DETAINED AT ORIGIN" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SECURITY CLEARED" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "CHANGE IN MODE/NEW AWB CUT" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "APEX TRANSIT ON COMM FLT;CCU HUB" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "AWB WRONGLY INSCANNED" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "AWB WRONGLY INSCANNED" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "UNDER SECURITY INVESTIGATION" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "DP DUTS HELD AT CCU W/H" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "PLEASE CONTACT CUSTOMER SERVICE"  ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'CORRECTION OF WRONG POD DETAILS'
                      || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'AWAITING CNEE FEEDBACK TO SORRY CARD' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHPT DETAINED/SEIZED BY REGULATORY" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHIPMENT RECEIVED;PAPERWORK NOT RECEIVED" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'SHIPMENT KEPT IN PARCEL LOCKER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHIPMENT RETRIEVED FROM PARCEL LOCKER" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHIPMENT KEPT IN PARCEL SHOP FOR COLLECT" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "DG SHIPMENT SCAN IN LOCATION" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "LOAD ON HOLD;SPACE CONSTRAINT-DELVRY LOC" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "LOAD ON HOLD;SPACE CONSTRAINT IN NET VEH" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "LOAD ON HOLD;SPACE CONSTRAINT-COMML FLT" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "LOAD ON HOLD; EMBARGO ON COMML UPLIFT" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "LOAD ON HOLD; SPACE CONSTRAINT IN TRAIN" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "UNDELIVERED INSCAN" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "PAPER WORK INSCAN" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "IN TRANSIT" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "PKG HELD FOR TAXES" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "TRAFFIC JAM ENROUTE" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "CAUGHT FIRE INSIDE VEHICLE" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "DETAINED AT CHECK-POST" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "DELAYED BY ENROUTE SECTOR" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "HEAVY RAIN" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "ENDORSEMENT NOT DONE AT CHECK-POST" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "DETAINED BY SALES TAX" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "VEHICLE BREAK-DOWN ENROUTE" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "HEAVY FOG" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "CAPACITY CONSTRAINT; BULK DESPATCH" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "LOAD/VEHICLE ARRIVED AT DELIVERY LOC" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "ACCIDENT ENROUTE" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "POLITICAL DISTURBANCE" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "VENDOR FAULT" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "ANY OTHER CONTROLABLE REASON" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "OVERAGE DELETED" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "TRANSIT SCAN" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "APEX / SFC SHPT OVERCARRIED IN NETWORK" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "CHANGE IN WEIGHT EFFECTED" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHIPMENT UNDER COOLING BY AIRLINE" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "DC DESCREPANCY" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "DC RECEIVED FROM CNEE" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "ADMIN OVER-RIDE OF DC COUNT" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "POD/DC COPY SENT" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "POD/DC ACCURACY" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHIPMENT MOVED TO MOBILE OFFICE" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "UD SHPT SENDING BACK TO BDE FOR PROCESS" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "GSTN SITE NOT WORKING" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "UD SHPT RCVD FRM ASSOCIATE FOR PROCESSNG" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHPT RCD IN TRANSIT LOC; BEING CONNECTED" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHPT RCVD AT DESTN LOC FOR DLVRY ATTEMPT" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "ANY OTHER NON-CONTROLABLE REASON" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHIPMENT HANDED OVER TO ASSOCIATE" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHIPMENT BOOKED FOR EMBARGO LOCATION" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "DELIVERY BY APPOINTMENT" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "PLASTIC BAG / SHPT RECD W/O DESTN CODING" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "BAG ID MISMATCH" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "OTP GENERATED SUCCESSFULLY" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "LOAD/VEHICLE ARRIVAL AT TRANSIT HUB" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "GPS RUN ARRIVAL AT DESTINATION LOCATION" ||  $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "GPS RUN ARRIVAL AT TRANSIT HUB" || 
                    $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHIPMENT CONNX ON ADDITIONAL DAY BD FLT" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "BAG RECEIVED WITH INCORRECT BARCODE TAG;"  || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHIPMENT SNATCHED ON FIELD"  || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "BAG ID MISMATCH"  || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "UNDELIVERED SHIPMENT HELD AT LOCATION" )){
                        
                        
                        $order_model->it_easy_order_status_id = '27';
                        $order_model->it_easy_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = "IN-Transit";
                        $dispatch_model->it_easy_courier_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPMENT OUTSCAN' ){
                        if(empty($dispatch_model->it_easy_first_scan_date)){
                            $dispatch_model->it_easy_first_scan_date = $time_stamp;
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->second_attempt_date)){
                            $dispatch_model->second_attempt_date = $time_stamp;
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->third_attempt_date)){
                            $dispatch_model->third_attempt_date = $time_stamp;
                            $dispatch_model->save(false);
                        }
                        
                        if(empty($dispatch_model->it_easy_last_scan_date)){
                            $dispatch_model->it_easy_last_scan_date = $time_stamp;
                            $dispatch_model->it_easy_attempt_count = '1';
                            $dispatch_model->save(false);
                        }else{
                            if(date('Y-m-d') != date('Y-m-d', strtotime($dispatch_model->it_easy_last_scan_date))){
                                $dispatch_model->it_easy_last_scan_date = $time_stamp;
                                $dispatch_model->it_easy_attempt_count = $dispatch_model->it_easy_attempt_count +1;
                                $dispatch_model->save(false);
                            }
                        }
                        
                        
                        
                        $order_model->it_easy_order_status_id = '30';
                        $order_model->it_easy_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = "OUT FOR DELIVERY";
                        $dispatch_model->it_easy_courier_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if( ($track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPMENT OUTSCAN' ) && ($track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['ScanGroupType'] == "RS" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['ScanGroupType'] == "RT" )){
                        
                        
                        
                        
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = "RTO-OFD";
                        $dispatch_model->it_easy_courier_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if( ($track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPMENT DELIVERED' ) && ($track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['ScanGroupType'] == "RS" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['ScanGroupType'] == "RT" ) ){
                        
                        $order_model->it_easy_order_status_id = '47';
                        $order_model->it_easy_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $order_model->it_easy_delivered_time = $time_stamp;
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = 'RTO Delivered via Couriers';
                        $dispatch_model->it_easy_courier_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_delivery_date = $time_stamp;
                        $dispatch_model->save(false);
                        $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPMENT DELIVERED'){
                        
                        $order_model->it_easy_order_status_id = '3';
                        $order_model->it_easy_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $order_model->it_easy_delivered_time = $time_stamp;
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = 'Delivered';
                        $dispatch_model->it_easy_courier_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_delivery_date = $time_stamp;
                        $dispatch_model->save(false);
                          $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'CUSTOMER ASKED FUTURE DELIVERY: HAL' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'OUT OF DELIVERY AREA' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'RESIDENCE/OFFICE CLOSED;CANT DELIVER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'ADDRESS UNLOCATABLE; CANNOT DELIVER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'ADDRESS INCOMPLETE, CANNOT DELIVER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPMENT SHORTAGE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'ADDRESS INCOMPLETE/ INCORRECT' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'CONSIGNEE REFUSED TO ACCEPT' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'NO SUCH CO./CNEE AT GIVEN ADDRESS' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'CONSIGNEE NOT AVAILABLE;CANT DELIVER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'CONSIGNEE NOT YET CHECKED IN' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'CONSIGNEE OUT OF STATION' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPMENT DESTROYED/ABANDONED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'CONSIGNEE REFUSING COLLETABLE AMOUNT' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'HELD FOR CLARITY ON HANDLING CHARGES' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'MISROUTE DUE TO SHIPPER FAULT/WRONG PIN' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'MISROUTE DUE TO BDE FAULT' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'COLLECTABLE AMOUNT NOT READY' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'CNEE REFUSED ID/OTP NOT SHARED-INCORRECT' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'DELIVERY AREA NOT ACCESSIBLE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'NEED DEPT NAME/EXTN.NO:UNABLE TO DELIVER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SPECIAL SHIPPER ODA DELV-DELAY EXPECTED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SPECIAL SHIPPER ODA DELV-DELAY EXPECTED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'ATTEMPT AT SECONDARY ADDRESS'  || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  ==  "CONSIGNEE NOT AVAILABLE; CAN'T DELIVER"  || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  ==  "E-TAIL; REFUSED TO ACCEPT SHIPMENT" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  ==  "E-TAIL; REFUSED - SHPTS ORDERED IN BULK" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  ==  "E-TAIL; REFUSED-OPEN DELIVERY REQUEST" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  ==  "E-TAIL; REFUSED-WRONG PROD DESP/NOT ORDE"  || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  ==  "E-TAIL: FAKE  BOOKING/FAKE ADDRESS"  || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "NO ENTRY" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "CONSIGNEE HAS GIVEN BDE HAL ADDRESS" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "CONSIGNEE ADD IS EDUCATIONAL INSTITUTION" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "DEMURRAGE CHARGES NOT READY" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "CONSIGNEE REFUSED SHIPMENT DUE TO GST" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "CNEE NAME / SURNAME MIS-MATCH" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "P.O. BOX ADDRESS,UNABLE TO DELIVER" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHIPMENT UNTRACEABLE" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "CUSTOMER NOT READY WITH EXCHANGE" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "REFUSAL CONFIRMATION CODE VERIFIED" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "REFUSAL CONFIRMATION CODE VERIFIED" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "NATURAL DISASTER/DISTURBANCE/STRIKE" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "P/U NOT GIVEN BY CUSTOMER - HIGH RATE" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == "ADDRESS INCOMPLETE, CANNOT DELIVER" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'P/U NOT GIVEN BY CUSTOMER - HIGH RATE'){
                        
                        if(empty($dispatch_model->first_ndr_reason)){
                            $dispatch_model->first_ndr_reason = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                            $order_model->it_easy_ndr_tl = '0';
                            $order_model->it_easy_ndr_agent = '0';
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->second_ndr_reason)){
                            $dispatch_model->second_ndr_reason = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                            $order_model->it_easy_ndr_tl = '0';
                            $order_model->it_easy_ndr_agent = '0';
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->third_ndr_reason)){
                            $dispatch_model->third_ndr_reason = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                            $order_model->it_easy_ndr_tl = '0';
                            $order_model->it_easy_ndr_agent = '0';
                            $dispatch_model->save(false);
                        }
                        if(empty($dispatch_model->last_ndr_reason)){
                            $dispatch_model->last_ndr_reason = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                            $dispatch_model->save(false);
                        }


                        
                        $order_model->it_easy_order_status_id = '9';
                        $order_model->it_easy_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = "Undelivered";
                        $dispatch_model->it_easy_courier_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                         $this->sendOrderCreatedWebhook($order_model);
                    }else if(($track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'CUSTOMER ASKED FUTURE DELIVERY: HAL' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'OUT OF DELIVERY AREA' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'RESIDENCE/OFFICE CLOSED;CANT DELIVER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'ADDRESS UNLOCATABLE; CANNOT DELIVER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'ADDRESS INCOMPLETE, CANNOT DELIVER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPMENT SHORTAGE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'ADDRESS INCOMPLETE/ INCORRECT' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'CONSIGNEE REFUSED TO ACCEPT' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'NO SUCH CO./CNEE AT GIVEN ADDRESS' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'CONSIGNEE NOT AVAILABLE;CANT DELIVER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'CONSIGNEE NOT YET CHECKED IN' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'CONSIGNEE OUT OF STATION' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPMENT DESTROYED/ABANDONED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'CONSIGNEE REFUSING COLLETABLE AMOUNT' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'HELD FOR CLARITY ON HANDLING CHARGES' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'MISROUTE DUE TO SHIPPER FAULT/WRONG PIN' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'MISROUTE DUE TO BDE FAULT' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'COLLECTABLE AMOUNT NOT READY' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'CNEE REFUSED ID/OTP NOT SHARED-INCORRECT' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'DELIVERY AREA NOT ACCESSIBLE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'NEED DEPT NAME/EXTN.NO:UNABLE TO DELIVER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SPECIAL SHIPPER ODA DELV-DELAY EXPECTED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SPECIAL SHIPPER ODA DELV-DELAY EXPECTED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == 'ATTEMPT AT SECONDARY ADDRESS'  || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  ==  "CONSIGNEE NOT AVAILABLE; CAN'T DELIVER"  || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  ==  "E-TAIL; REFUSED TO ACCEPT SHIPMENT" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  ==  "E-TAIL; REFUSED - SHPTS ORDERED IN BULK" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  ==  "E-TAIL; REFUSED-OPEN DELIVERY REQUEST" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  ==  "E-TAIL; REFUSED-WRONG PROD DESP/NOT ORDE"  || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  ==  "E-TAIL: FAKE  BOOKING/FAKE ADDRESS"  || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "NO ENTRY" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "CONSIGNEE HAS GIVEN BDE HAL ADDRESS" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "CONSIGNEE ADD IS EDUCATIONAL INSTITUTION" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "DEMURRAGE CHARGES NOT READY" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "CONSIGNEE REFUSED SHIPMENT DUE TO GST" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "CNEE NAME / SURNAME MIS-MATCH" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "P.O. BOX ADDRESS,UNABLE TO DELIVER" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "SHIPMENT UNTRACEABLE" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "CUSTOMER NOT READY WITH EXCHANGE" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "REFUSAL CONFIRMATION CODE VERIFIED" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "REFUSAL CONFIRMATION CODE VERIFIED" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "NATURAL DISASTER/DISTURBANCE/STRIKE" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan']  == "P/U NOT GIVEN BY CUSTOMER - HIGH RATE" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == "ADDRESS INCOMPLETE, CANNOT DELIVER" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'P/U NOT GIVEN BY CUSTOMER - HIGH RATE') && ($track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['ScanGroupType'] == "RS" || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['ScanGroupType'] == "RT" ) ){
                        
                        


                        
                        $order_model->it_easy_order_status_id = '28';
                        $order_model->it_easy_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = "RTO Undelivered";
                        $dispatch_model->it_easy_courier_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                        $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'PICKUP CANCELLED BY ETAILER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'Shipment Failed' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'PICKUP CANCELLED BY CALL' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'EXCHANGE FAIL: CANCELLED WITH TOP UP' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'EXCHANGE FAIL: CANCELLED WITHOUT TOP UP' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPMNT CANCELLED AFTER DEFINED ATTEMPTS'){
                        $order_model->it_easy_order_status_id = '8';
                        $order_model->it_easy_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = "Pickup Cancel";
                        $dispatch_model->it_easy_courier_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'AWB REJECTED ON FIELD' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'Rejected AWB Inscanned' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'RTO TO SHIPPER ON FIELD' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPPER INSTRUCTED TO RTO THE SHIPMENT' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'RTO FROM ORIGIN S.C. ON SAME AWB'  || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'RTO SHPT HAL AS PER CUSTOMERS REQUEST' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHPT REDIRECTED ON SAME AWB' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'REDIRECTED ON SAME AWB TO SHIPPER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'RTO FROM HUB ON FRESH AWB' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHPT RETRIEVED FROM PARCEL SHOP FOR RTO' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'DETAINED BY RTO' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'RTO at Origin outscan for Delivery'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = 'RTO In-Transit';
                        $dispatch_model->it_easy_courier_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        
                        if(empty($dispatch_model->rto_initiate_date)){
                            $dispatch_model->rto_initiate_date = date('Y-m-d H:i:s');
                        }
                        
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPMENT RETURNED BACK TO SHIPPER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'DELIVERED BACK TO SHIPPER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'RETURN TO SHIPPER'){
                        $order_model->it_easy_order_status_id = '47';
                        $order_model->it_easy_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $dispatch_model->it_easy_courier_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_auto_rto_date =$time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'APX/SFC SHPT MISPLACED AT DST/WAREHOUSE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'DAMAGED SHIPMENT, CASE CLOSED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHPT/PACKAGE RECD.IN DAMAGED CONDITION' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'LOST SHIPMENT' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'SHIPMENT SHORTAGE' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'PICKUP SENT TO WRONG BD LOCATION'){
                        $order_model->it_easy_order_status_id = '14';
                        $order_model->it_easy_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = 'Lost/Damage/Misroute';
                        $dispatch_model->it_easy_courier_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'PICKUP HAS BEEN REGISTERED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'PICKUP EMPLOYEE IS OUT TO P/U SHIPMENT' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'AUTO PICKUP REGISTERED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'PICKUP CONFIRMED BY CALL' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'PICKUP RE-SCHEDULED BY CALL' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'STAFF OUT FOR PICKUP FROM CUSTOMER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'PICKUP REGISTERED' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'PRE CALL: INCORRECT PHONE NUMBER' || $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'] == 'P/U RESCHEDULED : CAPACITY CONSTRAINT') {
                        $order_model->it_easy_order_status_id = '4';
                        $order_model->it_easy_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $dispatch_model->it_easy_courier_comment = $track_data['statustracking'][0]['Shipment']['Scans']['ScanDetail'][0]['Scan'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }
                    $model->save(false);
                    $json['code'] = '200';
                    $json['message'] = "Saved Successfully";
                    echo json_encode($json);
                }else{
                    $json['code'] = '407';
                    $json['message'] = "ORDER ID didn't match in system";
                    echo json_encode($json);
                }
                }else{
                    $json['code'] = '405';
                    $json['message'] = "This ".$track_data['statustracking'][0]['Shipment']['WaybillNo']."AWB Number didn't find in system";
                    echo json_encode($json);
                }
            //}
        }else{
            $json['code'] = '406';
            $json['message'] = "AWB NUMBER hasn't found";
            echo json_encode($json);
        }
        die;
        
    }
    
    
    public function actionQuickshifttracking(){
       
        // Get headers
        $headers = getallheaders();
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: *');
        
    

        $this->enableCsrfValidation = false;
        $track_data = json_decode(file_get_contents("php://input"), true);
        
        $validApiKey = "UdfcAsjqaAOJHaSEHpx2N60UA9BZ49Eg";

        $providedApiKey = '';

        if (isset($_SERVER['HTTP_X_API_KEY'])) {
            $providedApiKey = $_SERVER['HTTP_X_API_KEY'];
        } elseif (isset($_SERVER['REDIRECT_HTTP_X_API_KEY'])) {
            $providedApiKey = $_SERVER['REDIRECT_HTTP_X_API_KEY'];
        } elseif (function_exists('apache_request_headers')) {
            $providedApiKey = apache_request_headers();
            if (isset($headers['x-api-key'])) {
                $providedApiKey = $headers['x-api-key'];
            }
        }
        
        
        
        // Validate API key
        // if ($providedApiKey !== $validApiKey) {
        //     http_response_code(401);
        //     echo json_encode(['error' => 'Unauthorized: Invalid API key']);
        //     exit;
        // }else{
        //     //echo json_encode(['error' => 'success']);
        // }
        $model = new ItEasyQueryTracking();
        $model->courier_name = 'Quickshift';
        $model->order_id = '11254565';
        $model->awb_number = '451100215';
        $model->cp_id = '1111';
        $model->remark = '54112664';
        $model->status_code = 'test';
        $model->reference_number = '7754458878';
        $model->timestamp = date('Y-m-d H:i:s');
        $model->status_description_bucket = '7421w455';
        $model->location = 'Delhi';
        $model->status_description = '451112545';
        $model->query = json_encode($track_data);
        $model->status_time = date('Y-m-d H:i:s');
        $model->save(false);
        $json['code'] = '200';
        $json['message'] = "Saved Successfully";
        echo json_encode($json);
        die;
        if(isset($track_data['awb']) && !empty($track_data['awb'])){
            //foreach($track_datas['records'] as $key => $track_data){
            
            $dispatch_model = ItEasyOrderDispatch::findOne(['it_easy_awb_number' => $track_data['awb']]);
            
            if(!empty($dispatch_model)){
                $order_model = ItEasyOrder::findOne(['it_easy_order_id' => $dispatch_model->it_easy_order_id ]);
                
                if(!empty($order_model)){
                    $count = count($track_data['history_scans']) - 1;
                    if(isset($track_data['history_scans'][$count]['time']) && !empty($track_data['history_scans'][$count]['time'])){
                        $time_stamp = $track_data['history_scans'][$count]['time'];
                    }else{
                        $time_stamp = date('Y-m-d H:i:s');
                    }
                    $model = new ItEasyQueryTracking();
                    $model->courier_name = 'Quickshift';
                    $model->order_id = $dispatch_model->it_easy_order_id;
                    $model->awb_number = $track_data['awb'];
                    $model->cp_id = $track_data['awb'];
                    $model->remark = $track_data['history_scans'][$count]['scan'];
                    $model->status_code = $track_data['history_scans'][$count]['status'];
                    $model->reference_number = $track_data['awb'];
                    $model->timestamp = $time_stamp;
                    $model->status_description_bucket = $track_data['history_scans'][$count]['scan'];
                    $model->location = $track_data['history_scans'][$count]['location'];
                    $model->status_description = $track_data['history_scans'][$count]['scan'];
                    $model->query = json_encode($track_data);
                    $model->status_time = date('Y-m-d H:i:s');
                    
                    if( $track_data['history_scans'][$count]['scan'] == 'Shipment not ready for pickup'){
                        $order_model->it_easy_order_status_id = '31';
                        $order_model->it_easy_comment = $track_data['history_scans'][$count]['scan'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['history_scans'][$count]['scan'];
                        $dispatch_model->it_easy_courier_comment = $track_data['history_scans'][$count]['scan'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['history_scans'][$count]['scan'] == 'Shipment picked up'){
                        $order_model->it_easy_placed_time = $time_stamp;
                        $order_model->it_easy_order_status_id = '29';
                        $order_model->it_easy_comment = $track_data['history_scans'][$count]['scan'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['history_scans'][$count]['scan'];
                        $dispatch_model->it_easy_courier_comment = $track_data['history_scans'][$count]['scan'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_pickup_time = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['history_scans'][$count]['scan'] == 'Shipment Recieved at Origin Center' || $track_data['history_scans'][$count]['scan'] == 'System weight captured' || $track_data['history_scans'][$count]['scan'] == 'Added to Bag' || $track_data['history_scans'][$count]['scan'] == 'Unexpected scan' || $track_data['history_scans'][$count]['scan'] == 'Added to Bag' || $track_data['history_scans'][$count]['scan'] == 'Bag Added To Trip' || $track_data['history_scans'][$count]['scan'] == 'Trip Arrived' || $track_data['history_scans'][$count]['scan'] == 'Bag Received at Facility' || $track_data['history_scans'][$count]['scan'] == 'Shipment Received at Facility'){
                        $order_model->it_easy_order_status_id = '27';
                        $order_model->it_easy_comment = $track_data['history_scans'][$count]['scan'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = "In-Transit";
                        $dispatch_model->it_easy_courier_comment = $track_data['history_scans'][$count]['scan'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['history_scans'][$count]['scan'] == 'Out for delivery'){
                        if(empty($dispatch_model->it_easy_first_scan_date)){
                            $dispatch_model->it_easy_first_scan_date = $time_stamp;
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->second_attempt_date)){
                            $dispatch_model->second_attempt_date = $time_stamp;
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->third_attempt_date)){
                            $dispatch_model->third_attempt_date = $time_stamp;
                            $dispatch_model->save(false);
                        }
                        
                        if(empty($dispatch_model->it_easy_last_scan_date)){
                            $dispatch_model->it_easy_last_scan_date = $time_stamp;
                            $dispatch_model->it_easy_attempt_count = '1';
                            $dispatch_model->save(false);
                        }else{
                            if(date('Y-m-d') != date('Y-m-d', strtotime($dispatch_model->it_easy_last_scan_date))){
                                $dispatch_model->it_easy_last_scan_date = $time_stamp;
                                $dispatch_model->it_easy_attempt_count = $dispatch_model->it_easy_attempt_count +1;
                                $dispatch_model->save(false);
                            }
                        }
                        
                        
                        
                        $order_model->it_easy_order_status_id = '30';
                        $order_model->it_easy_comment = $track_data['history_scans'][$count]['scan'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['history_scans'][$count]['scan'];
                        $dispatch_model->it_easy_courier_comment = $track_data['history_scans'][$count]['scan'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['history_scans'][$count]['status'] == 'Delivered'){
                        
                        $order_model->it_easy_order_status_id = '3';
                        $order_model->it_easy_comment = $track_data['history_scans'][$count]['scan'];
                        $order_model->it_easy_delivered_time = $time_stamp;
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = 'Delivered';
                        $dispatch_model->it_easy_courier_comment = $track_data['history_scans'][$count]['scan'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_delivery_date = $time_stamp;
                        $dispatch_model->save(false);
                          $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['status'] == 'Delivery Delay' || $track_data['status'] == 'Failed Delivered' || $track_data['status'] == 'NDR Initiated' || $track_data['status'] == 'Inventory not available'){
                        $order_model->it_easy_order_status_id = '9';
                        $order_model->it_easy_comment = $track_data['status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                         $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['status'] == 'Cancelled' || $track_data['status'] == 'Shipment Failed'){
                        $order_model->it_easy_order_status_id = '8';
                        $order_model->it_easy_comment = $track_data['status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['status'] == 'RTO Initiated' || $track_data['status'] == 'RTO Freeze'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['status'] == 'RTO Delivered'){
                        $order_model->it_easy_order_status_id = '47';
                        $order_model->it_easy_comment = $track_data['status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_auto_rto_date =$time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['status'] == 'RTO Delivery Delay' || $track_data['status'] == 'RTO Failed Delivered'){
                        $order_model->it_easy_order_status_id = '28';
                        $order_model->it_easy_comment = $track_data['status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['status'] == 'Damaged' || $track_data['status'] == 'Lost'){
                        $order_model->it_easy_order_status_id = '14';
                        $order_model->it_easy_comment = $track_data['status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['status'] == 'To be Picked' || $track_data['status'] == 'Shipment Created' || $track_data['status'] == 'Out for Pickup'){
                        $order_model->it_easy_order_status_id = '4';
                        $order_model->it_easy_comment = $track_data['status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['status'] == 'RTO In-Transit'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['status'] == 'RTO Out for Delivery'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['status'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['status'];
                        $dispatch_model->it_easy_courier_comment = $track_data['status'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }
                    $model->save(false);
                    $json['code'] = '200';
                    $json['message'] = "Saved Successfully";
                    echo json_encode($json);
                }else{
                    $json['code'] = '407';
                    $json['message'] = "ORDER ID didn't match in system";
                    echo json_encode($json);
                }
                }else{
                    $json['code'] = '405';
                    $json['message'] = "This ".$track_data['awb']."AWB Number didn't find in system";
                    echo json_encode($json);
                }
            //}
        }else{
            $json['code'] = '406';
            $json['message'] = "AWB NUMBER hasn't found";
            echo json_encode($json);
        }
        die;
        
    }
    
    
    public function actionDtdctracking(){
       
        // Get headers
        $headers = getallheaders();
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: *');
        
    

        $this->enableCsrfValidation = false;
        $track_data = json_decode(file_get_contents("php://input"), true);
        
        // $validApiKey = "UdfcAsjqaAOJHaSEHpx2N60UA9BZ49Eg";

        // $providedApiKey = '';

        // if (isset($_SERVER['HTTP_X_API_KEY'])) {
        //     $providedApiKey = $_SERVER['HTTP_X_API_KEY'];
        // } elseif (isset($_SERVER['REDIRECT_HTTP_X_API_KEY'])) {
        //     $providedApiKey = $_SERVER['REDIRECT_HTTP_X_API_KEY'];
        // } elseif (function_exists('apache_request_headers')) {
        //     $providedApiKey = apache_request_headers();
        //     if (isset($headers['x-api-key'])) {
        //         $providedApiKey = $headers['x-api-key'];
        //     }
        // }
        
        
        
        // // Validate API key
        // if ($providedApiKey !== $validApiKey) {
        //     http_response_code(401);
        //     echo json_encode(['error' => 'Unauthorized: Invalid API key']);
        //     exit;
        // }else{
        //     //echo json_encode(['error' => 'success']);
        // }
        
        if(isset($track_data['shipment']['strShipmentNo']) && !empty($track_data['shipment']['strShipmentNo'])){
            //foreach($track_datas['records'] as $key => $track_data){
            
            $dispatch_model = ItEasyOrderDispatch::findOne(['it_easy_awb_number' => $track_data['shipment']['strShipmentNo']]);
            
            if(!empty($dispatch_model)){
                $order_model = ItEasyOrder::findOne(['it_easy_order_id' => $dispatch_model->it_easy_order_id ]);
                
                if(!empty($order_model)){
                    if(isset($track_data['shipmentStatus'][0]['strActionDate']) && !empty($track_data['shipmentStatus'][0]['strActionDate'])){
                        
                        $dateObj = \DateTime::createFromFormat('dmY', $track_data['shipmentStatus'][0]['strActionDate']);
                        
                        if ($dateObj) {
                            $time_date = $dateObj->format('Y-m-d');
                        
                        } else {
                            echo "Invalid date format: " . $dateString; die;
                        }
                        
                        
                        
                        $time_time = \DateTime::createFromFormat('His', $track_data['shipmentStatus'][0]['strActionTime'])->format('H:i:s');
                        $time_stamp = $time_date.' '.$time_time;
                    }else{
                        $time_stamp = date('Y-m-d H:i:s');
                    }
                    $model = new ItEasyQueryTracking();
                    $model->courier_name = 'DTDC';
                    $model->order_id = $dispatch_model->it_easy_order_id;
                    $model->awb_number = $track_data['shipment']['strShipmentNo'];
                    $model->cp_id = $track_data['shipment']['strRefNo'];
                    $model->remark = $track_data['shipmentStatus'][0]['strRemarks'];
                    $model->status_code = $track_data['shipmentStatus'][0]['strActionDesc'];
                    $model->reference_number = $track_data['shipment']['strRefNo'];
                    $model->timestamp = $time_stamp;
                    $model->status_description_bucket = $track_data['shipmentStatus'][0]['strActionDesc'];
                    $model->location = $track_data['shipmentStatus'][0]['strOrigin'];
                    $model->status_description = $track_data['shipmentStatus'][0]['strActionDesc'];
                    $model->query = json_encode($track_data);
                    $model->status_time = date('Y-m-d H:i:s');
                    
                    if( $track_data['shipmentStatus'][0]['strAction'] == 'PCNO'){
                        $order_model->it_easy_order_status_id = '31';
                        $order_model->it_easy_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['shipmentStatus'][0]['strActionDesc'];
                        $dispatch_model->it_easy_courier_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['shipmentStatus'][0]['strAction'] == 'PCUP'){
                        $order_model->it_easy_placed_time = $time_stamp;
                        $order_model->it_easy_order_status_id = '29';
                        $order_model->it_easy_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['shipmentStatus'][0]['strActionDesc'];
                        $dispatch_model->it_easy_courier_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_pickup_time = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['shipmentStatus'][0]['strAction'] == 'IPMF' || $track_data['shipmentStatus'][0]['strAction'] == 'OPMF' || $track_data['shipmentStatus'][0]['strAction'] == 'ORMF' || $track_data['shipmentStatus'][0]['strAction'] == 'IBMD' || $track_data['shipmentStatus'][0]['strAction'] == 'OBMD'  || $track_data['shipmentStatus'][0]['strAction'] == 'IBMN' || $track_data['shipmentStatus'][0]['strAction'] == 'OBMN'  || $track_data['shipmentStatus'][0]['strAction'] == 'IMBM' || $track_data['shipmentStatus'][0]['strAction'] == 'OMBM'  || $track_data['shipmentStatus'][0]['strAction'] == 'IRBO' || $track_data['shipmentStatus'][0]['strAction'] == 'ORBO' || $track_data['shipmentStatus'][0]['strAction'] == 'CDIN' || $track_data['shipmentStatus'][0]['strAction'] == 'CDOUT' || $track_data['shipmentStatus'][0]['strAction'] == 'ARAP' || $track_data['shipmentStatus'][0]['strAction'] == 'LNRC' || $track_data['shipmentStatus'][0]['strAction'] == 'CSCL' || $track_data['shipmentStatus'][0]['strAction'] == 'CHLD' || $track_data['shipmentStatus'][0]['strAction'] == 'HLDUP' || $track_data['shipmentStatus'][0]['strAction'] == 'CHLD' || $track_data['shipmentStatus'][0]['strAction'] == 'PREPERD' || $track_data['shipmentStatus'][0]['strAction'] == 'DRAW' || $track_data['shipmentStatus'][0]['strAction'] == 'DRSC' || $track_data['shipmentStatus'][0]['strAction'] == 'DRCOM' || $track_data['shipmentStatus'][0]['strAction'] == 'DRCAN' || $track_data['shipmentStatus'][0]['strAction'] == 'RADCDIN' || $track_data['shipmentStatus'][0]['strAction'] == 'RELHLD'){
                        $order_model->it_easy_order_status_id = '27';
                        $order_model->it_easy_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['shipmentStatus'][0]['strActionDesc'];
                        $dispatch_model->it_easy_courier_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['shipmentStatus'][0]['strAction'] == 'OUTDLV'){
                        if(empty($dispatch_model->it_easy_first_scan_date)){
                            $dispatch_model->it_easy_first_scan_date = $time_stamp;
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->second_attempt_date)){
                            $dispatch_model->second_attempt_date = $time_stamp;
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->third_attempt_date)){
                            $dispatch_model->third_attempt_date = $time_stamp;
                            $dispatch_model->save(false);
                        }
                        
                        if(empty($dispatch_model->it_easy_last_scan_date)){
                            $dispatch_model->it_easy_last_scan_date = $time_stamp;
                            $dispatch_model->it_easy_attempt_count = '1';
                            $dispatch_model->save(false);
                        }else{
                            if(date('Y-m-d') != date('Y-m-d', strtotime($dispatch_model->it_easy_last_scan_date))){
                                $dispatch_model->it_easy_last_scan_date = $time_stamp;
                                $dispatch_model->it_easy_attempt_count = $dispatch_model->it_easy_attempt_count +1;
                                $dispatch_model->save(false);
                            }
                        }
                        
                        
                        
                        $order_model->it_easy_order_status_id = '30';
                        $order_model->it_easy_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['shipmentStatus'][0]['strActionDesc'];
                        $dispatch_model->it_easy_courier_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['shipmentStatus'][0]['strAction'] == 'DLV'){
                        
                        $order_model->it_easy_order_status_id = '3';
                        $order_model->it_easy_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $order_model->it_easy_delivered_time = $time_stamp;
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = 'Delivered';
                        $dispatch_model->it_easy_courier_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_delivery_date = $time_stamp;
                        $dispatch_model->save(false);
                          $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['shipmentStatus'][0]['strAction'] == 'NONDLV' || $track_data['shipmentStatus'][0]['strAction'] == 'HELDUP' || $track_data['shipmentStatus'][0]['strAction'] == 'ADR' || $track_data['shipmentStatus'][0]['strAction'] == 'CAD' || $track_data['shipmentStatus'][0]['strAction'] == 'CAN' || $track_data['shipmentStatus'][0]['strAction'] == 'COC' || $track_data['shipmentStatus'][0]['strAction'] == 'CWP' || $track_data['shipmentStatus'][0]['strAction'] == 'DLK' || $track_data['shipmentStatus'][0]['strAction'] == 'DNM' || $track_data['shipmentStatus'][0]['strAction'] == 'DTD' || $track_data['shipmentStatus'][0]['strAction'] == 'LDO' || $track_data['shipmentStatus'][0]['strAction'] == 'MIS' || $track_data['shipmentStatus'][0]['strAction'] == 'NSP' || $track_data['shipmentStatus'][0]['strAction'] == 'NSR' || $track_data['shipmentStatus'][0]['strAction'] == 'PCC' || $track_data['shipmentStatus'][0]['strAction'] == 'PNA' || $track_data['shipmentStatus'][0]['strAction'] == 'PRF' || $track_data['shipmentStatus'][0]['strAction'] == 'PSF' || $track_data['shipmentStatus'][0]['strAction'] == 'REA' || $track_data['shipmentStatus'][0]['strAction'] == 'LST' || $track_data['shipmentStatus'][0]['strAction'] == 'UAT' || $track_data['shipmentStatus'][0]['strAction'] == 'COL' || $track_data['shipmentStatus'][0]['strAction'] == 'RWO' || $track_data['shipmentStatus'][0]['strAction'] == 'RRT' || $track_data['shipmentStatus'][0]['strAction'] == 'LHL' || $track_data['shipmentStatus'][0]['strAction'] == 'PWR' || $track_data['shipmentStatus'][0]['strAction'] == 'CNA' || $track_data['shipmentStatus'][0]['strAction'] == 'PWR' || $track_data['shipmentStatus'][0]['strAction'] == 'IRMF'){
                        
                        if(empty($dispatch_model->first_ndr_reason)){
                            $dispatch_model->first_ndr_reason = $track_data['shipmentStatus'][0]['strRemarks'];
                            $order_model->it_easy_ndr_tl = '0';
                            $order_model->it_easy_ndr_agent = '0';
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->second_ndr_reason)){
                            $dispatch_model->second_ndr_reason = $track_data['shipmentStatus'][0]['strRemarks'];
                            $order_model->it_easy_ndr_tl = '0';
                            $order_model->it_easy_ndr_agent = '0';
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->third_ndr_reason)){
                            $dispatch_model->third_ndr_reason = $track_data['shipmentStatus'][0]['strRemarks'];
                            $order_model->it_easy_ndr_tl = '0';
                            $order_model->it_easy_ndr_agent = '0';
                            $dispatch_model->save(false);
                        }
                        if(empty($dispatch_model->last_ndr_reason)){
                            $dispatch_model->last_ndr_reason = $track_data['shipmentStatus'][0]['strRemarks'];
                            $dispatch_model->save(false);
                        }
                        
                        
                        $order_model->it_easy_order_status_id = '9';
                        $order_model->it_easy_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['shipmentStatus'][0]['strActionDesc'];
                        $dispatch_model->it_easy_courier_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                         $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['shipmentStatus'][0]['strAction'] == 'STOPDLV' || $track_data['shipmentStatus'][0]['strAction'] == 'REVOKESTOPDLV'){
                        $order_model->it_easy_order_status_id = '8';
                        $order_model->it_easy_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['shipmentStatus'][0]['strActionDesc'];
                        $dispatch_model->it_easy_courier_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['shipmentStatus'][0]['strAction'] == 'SETRTO' || $track_data['shipmentStatus'][0]['strAction'] == 'IRTO' || $track_data['shipmentStatus'][0]['strAction'] == 'RTO' || $track_data['shipmentStatus'][0]['strAction'] == 'RTOOPMF' || $track_data['shipmentStatus'][0]['strAction'] == 'RTOIPMF' || $track_data['shipmentStatus'][0]['strAction'] == 'RTOIRMF' || $track_data['shipmentStatus'][0]['strAction'] == 'RTOOBMD' || $track_data['shipmentStatus'][0]['strAction'] == 'RTOIBMD' || $track_data['shipmentStatus'][0]['strAction'] == 'RTOOBMN' || $track_data['shipmentStatus'][0]['strAction'] == 'RTOIBMN' || $track_data['shipmentStatus'][0]['strAction'] == 'RTOOMBM' || $track_data['shipmentStatus'][0]['strAction'] == 'RTOIMBM' || $track_data['shipmentStatus'][0]['strAction'] == 'RTOORBO' || $track_data['shipmentStatus'][0]['strAction'] == 'RTOCDOUT' || $track_data['shipmentStatus'][0]['strAction'] == 'RTOCDIN' || $track_data['shipmentStatus'][0]['strAction'] == 'RTOINSCAN' || $track_data['shipmentStatus'][0]['strAction'] == 'RTOW' || $track_data['shipmentStatus'][0]['strAction'] == 'RTOINSCAN' || $track_data['shipmentStatus'][0]['strAction'] == 'RTORADCDIN' || $track_data['shipmentStatus'][0]['strAction'] == 'RTOBKD'){
                        
                        
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['shipmentStatus'][0]['strActionDesc'];
                        $dispatch_model->it_easy_courier_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        if(empty($dispatch_model->rto_initiate_date)){
                            $dispatch_model->rto_initiate_date = $time_stamp;
                        }
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['shipmentStatus'][0]['strAction'] == 'RTODLV' || $track_data['shipmentStatus'][0]['strAction'] == 'RTODLV'){
                        $order_model->it_easy_order_status_id = '47';
                        $order_model->it_easy_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['shipmentStatus'][0]['strActionDesc'];
                        $dispatch_model->it_easy_courier_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_auto_rto_date =$time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['shipmentStatus'][0]['strAction'] == 'RTONONDLV' || $track_data['shipmentStatus'][0]['strAction'] == 'RTOORMF' || $track_data['shipmentStatus'][0]['strAction'] == 'RETURND' || $track_data['shipmentStatus'][0]['strAction'] == 'RTORETURND'){
                        $order_model->it_easy_order_status_id = '28';
                        $order_model->it_easy_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['shipmentStatus'][0]['strActionDesc'];
                        $dispatch_model->it_easy_courier_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['shipmentStatus'][0]['strAction'] == 'LST'){
                        $order_model->it_easy_order_status_id = '14';
                        $order_model->it_easy_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['shipmentStatus'][0]['strActionDesc'];
                        $dispatch_model->it_easy_courier_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['shipmentStatus'][0]['strAction'] == 'PCAW' || $track_data['shipmentStatus'][0]['strAction'] == 'PCAN' || $track_data['shipmentStatus'][0]['strAction'] == 'BKD' || $track_data['shipmentStatus'][0]['strAction'] == 'PCSC' || $track_data['shipmentStatus'][0]['strAction'] == 'SPL' || $track_data['shipmentStatus'][0]['strAction'] == 'PCRA'){
                        $order_model->it_easy_order_status_id = '4';
                        $order_model->it_easy_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['shipmentStatus'][0]['strActionDesc'];
                        $dispatch_model->it_easy_courier_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['shipmentStatus'][0]['strAction'] == 'RTOOUTDLV'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['shipmentStatus'][0]['strActionDesc'];
                        $dispatch_model->it_easy_courier_comment = $track_data['shipmentStatus'][0]['strRemarks'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }
                    $model->save(false);
                    $json['code'] = '200';
                    $json['message'] = "Saved Successfully";
                    echo json_encode($json);
                }else{
                    $json['code'] = '407';
                    $json['message'] = "ORDER ID didn't match in system";
                    echo json_encode($json);
                }
                }else{
                    $json['code'] = '405';
                    $json['message'] = "This ".$track_data['awb']."AWB Number didn't find in system";
                    echo json_encode($json);
                }
            //}
        }else{
            $json['code'] = '406';
            $json['message'] = "AWB NUMBER hasn't found";
            echo json_encode($json);
        }
        die;
        
    }
    
    
    
    public function actionProshiptracking(){
       
        // Get headers
        $headers = getallheaders();
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: *');
        
    

        $this->enableCsrfValidation = false;
        $track_data = json_decode(file_get_contents("php://input"), true);
        
        $validApiKey = "UdfcAsjqaAOJHaSEHpx2N60UA9BZ49Eg";

        $providedApiKey = '';

        if (isset($_SERVER['HTTP_X_API_KEY'])) {
            $providedApiKey = $_SERVER['HTTP_X_API_KEY'];
        } elseif (isset($_SERVER['REDIRECT_HTTP_X_API_KEY'])) {
            $providedApiKey = $_SERVER['REDIRECT_HTTP_X_API_KEY'];
        } elseif (function_exists('apache_request_headers')) {
            $providedApiKey = apache_request_headers();
            if (isset($headers['x-api-key'])) {
                $providedApiKey = $headers['x-api-key'];
            }
        }
        
        
        
        // Validate API key
        // if ($providedApiKey !== $validApiKey) {
        //     http_response_code(401);
        //     echo json_encode(['error' => 'Unauthorized: Invalid API key']);
        //     exit;
        // }else{
        //     //echo json_encode(['error' => 'success']);
        // }
        
        if(isset($track_data['waybill']) && !empty($track_data['waybill'])){
            //foreach($track_datas['records'] as $key => $track_data){
            
            $dispatch_model = ItEasyOrderDispatch::findOne(['it_easy_awb_number' => $track_data['waybill']]);
            
            if(!empty($dispatch_model)){
                $order_model = ItEasyOrder::findOne(['it_easy_order_id' => $dispatch_model->it_easy_order_id ]);
                
                if(!empty($order_model)){
                    
                    if(isset($track_data['timestamp']) && !empty($track_data['timestamp'])){
                        $date = \DateTime::createFromFormat("Y-m-d\TH:i:s.u\Z", $track_data['timestamp']);

                        // Convert to MySQL datetime
                        $time_stamp = $date->format('Y-m-d H:i:s');
                
                    }else{
                        $time_stamp = date('Y-m-d H:i:s');
                    }
                    $model = new ItEasyQueryTracking();
                    $model->courier_name = 'Prozo';
                    $model->order_id = $dispatch_model->it_easy_order_id;
                    $model->awb_number = $track_data['waybill'];
                    $model->cp_id = $track_data['reference'];
                    $model->remark = $track_data['remark'];
                    $model->status_code = $track_data['orderStatusEnum'];
                    $model->timestamp = $time_stamp;
                    $model->status_description_bucket = $track_data['orderStatusDescription'];
                    $model->location = $track_data['currentLocation'];
                    $model->status_description = $track_data['orderStatusEnum'];
                    $model->query = json_encode($track_data);
                    $model->status_time = date('Y-m-d H:i:s');
                    
                    if( $track_data['orderStatusCode'] == '3' || $track_data['orderStatusCode'] == '7'){
                        $order_model->it_easy_order_status_id = '31';
                        $order_model->it_easy_comment = $track_data['remark'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['orderStatusEnum'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remark'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['orderStatusCode'] == '4'){
                        $order_model->it_easy_placed_time = $time_stamp;
                        $order_model->it_easy_order_status_id = '29';
                        $order_model->it_easy_comment = $track_data['remark'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['orderStatusEnum'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remark'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_pickup_time = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['orderStatusCode'] == '5' || $track_data['orderStatusCode'] == '18'  || $track_data['orderStatusCode'] == '19'  || $track_data['orderStatusCode'] == '20'  || $track_data['orderStatusCode'] == '31'){
                        $order_model->it_easy_order_status_id = '27';
                        $order_model->it_easy_comment = $track_data['remark'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = "In-Transit";
                        $dispatch_model->it_easy_courier_comment = $track_data['remark'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['orderStatusCode'] == '6'){
                        if(empty($dispatch_model->it_easy_first_scan_date)){
                            $dispatch_model->it_easy_first_scan_date = $time_stamp;
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->second_attempt_date)){
                            $dispatch_model->second_attempt_date = $time_stamp;
                            $dispatch_model->save(false);
                        }else if(empty($dispatch_model->third_attempt_date)){
                            $dispatch_model->third_attempt_date = $time_stamp;
                            $dispatch_model->save(false);
                        }
                        
                        if(empty($dispatch_model->it_easy_last_scan_date)){
                            $dispatch_model->it_easy_last_scan_date = $time_stamp;
                            $dispatch_model->it_easy_attempt_count = '1';
                            $dispatch_model->save(false);
                        }else{
                            if(date('Y-m-d') != date('Y-m-d', strtotime($dispatch_model->it_easy_last_scan_date))){
                                $dispatch_model->it_easy_last_scan_date = $time_stamp;
                                $dispatch_model->it_easy_attempt_count = $dispatch_model->it_easy_attempt_count +1;
                                $dispatch_model->save(false);
                            }
                        }
                        
                        
                        
                        $order_model->it_easy_order_status_id = '30';
                        $order_model->it_easy_comment = $track_data['remark'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['orderStatusEnum'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remark'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['orderStatusCode'] == '8'){
                        
                        $order_model->it_easy_order_status_id = '3';
                        $order_model->it_easy_comment = $track_data['remark'];
                        $order_model->it_easy_delivered_time = $time_stamp;
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = 'Delivered';
                        $dispatch_model->it_easy_courier_comment = $track_data['remark'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_delivery_date = $time_stamp;
                        $dispatch_model->save(false);
                          $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['orderStatusCode'] == '9'){
                        $order_model->it_easy_order_status_id = '9';
                        $order_model->it_easy_comment = $track_data['remark'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['orderStatusEnum'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remark'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                         $this->sendOrderCreatedWebhook($order_model);
                    }else if($track_data['orderStatusCode'] == '10'){
                        $order_model->it_easy_order_status_id = '8';
                        $order_model->it_easy_comment = $track_data['remark'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['orderStatusEnum'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remark'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['orderStatusCode'] == '11' || $track_data['orderStatusCode'] == '12'  || $track_data['orderStatusCode'] == '26'  || $track_data['orderStatusCode'] == '27'  || $track_data['orderStatusCode'] == '101' || $track_data['orderStatusCode'] == '21'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['remark'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['orderStatusEnum'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remark'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['orderStatusCode'] == '14'){
                        $order_model->it_easy_order_status_id = '47';
                        $order_model->it_easy_comment = $track_data['remark'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['orderStatusEnum'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remark'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->it_easy_auto_rto_date =$time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['orderStatusCode'] == '15' || $track_data['orderStatusCode'] == '27'){
                        $order_model->it_easy_order_status_id = '28';
                        $order_model->it_easy_comment = $track_data['remark'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['orderStatusEnum'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remark'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['orderStatusCode'] == '16' || $track_data['orderStatusCode'] == '17'){
                        $order_model->it_easy_order_status_id = '14';
                        $order_model->it_easy_comment = $track_data['remark'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['orderStatusEnum'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remark'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['orderStatusCode'] == '1' || $track_data['orderStatusCode'] == '2' || $track_data['orderStatusCode'] == '25' || $track_data['orderStatusCode'] == '33'){
                        $order_model->it_easy_order_status_id = '4';
                        $order_model->it_easy_comment = $track_data['remark'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['orderStatusEnum'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remark'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }else if($track_data['orderStatusCode'] == '13'){
                        $order_model->it_easy_order_status_id = '26';
                        $order_model->it_easy_comment = $track_data['remark'];
                        $order_model->save(false);
                        $dispatch_model->it_easy_order_status = $track_data['orderStatusEnum'];
                        $dispatch_model->it_easy_courier_comment = $track_data['remark'];
                        $dispatch_model->it_easy_status_updated_at = $time_stamp;
                        $dispatch_model->save(false);
                    }
                    $model->save(false);
                    $json['code'] = '200';
                    $json['message'] = "Saved Successfully";
                    echo json_encode($json);
                }else{
                    $json['code'] = '407';
                    $json['message'] = "ORDER ID didn't match in system";
                    echo json_encode($json);
                }
                }else{
                    $json['code'] = '405';
                    $json['message'] = "This ".$track_data['waybill']."AWB Number didn't find in system";
                    echo json_encode($json);
                }
            //}
        }else{
            $json['code'] = '406';
            $json['message'] = "AWB NUMBER hasn't found";
            echo json_encode($json);
        }
        die;
        
    }
    
    
    //test function for urbanbolt
public function actionUrbanbolttracking()
{
    \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
    \Yii::$app->response->headers->add('Access-Control-Allow-Origin', '*');

    // Get the Authorization header reliably
    $authHeader = '';
    if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $authHeader = $_SERVER['HTTP_AUTHORIZATION'];
    } elseif (isset($_SERVER['REDIRECT_HTTP_AUTHORIZATION'])) {
        $authHeader = $_SERVER['REDIRECT_HTTP_AUTHORIZATION'];
    } elseif (function_exists('getallheaders')) {
        $headers = getallheaders();
        if (isset($headers['Authorization'])) {
            $authHeader = $headers['Authorization'];
        } elseif (isset($headers['authorization'])) {
            $authHeader = $headers['authorization'];
        }
    }

    // Extract Bearer token
    $providedToken = '';
    if (preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
        $providedToken = $matches[1];
    }

    $validToken = 'UdfcAsjqaAOJHaSEHpx2N60UA9BZ49Eg';

    if ($providedToken !== $validToken) {
        return [
            'status' => 'error',
            'message' => 'Unauthorized: Invalid token',
            'received_header' => $authHeader
        ];
    }

    // Get raw input
    $rawData = file_get_contents('php://input');
    $data = json_decode($rawData, true);

    // Log incoming request
    file_put_contents(
        Yii::getAlias('@runtime/logs/urbanbolt_log.txt'),
        date('Y-m-d H:i:s') . " | " . $rawData . PHP_EOL,
        FILE_APPEND
    );

    // Return response
    
    
    return [
        'status' => 'Success',
        'message' => 'Data Received and Logged',
        'awb' => isset($data['awb']) ? $data['awb'] : null,
        'received_header' => $authHeader
    ];
}






public function actionUrbanbolttracking1()
{
    \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
    \Yii::$app->response->headers->add('Access-Control-Allow-Origin', '*');

    // Get the Authorization header reliably
    $authHeader = '';
    if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $authHeader = $_SERVER['HTTP_AUTHORIZATION'];
    } elseif (isset($_SERVER['REDIRECT_HTTP_AUTHORIZATION'])) {
        $authHeader = $_SERVER['REDIRECT_HTTP_AUTHORIZATION'];
    } elseif (function_exists('getallheaders')) {
        $headers = getallheaders();
        if (isset($headers['Authorization'])) {
            $authHeader = $headers['Authorization'];
        } elseif (isset($headers['authorization'])) {
            $authHeader = $headers['authorization'];
        }
    }

    // Extract Bearer token
    $providedToken = '';
    if (preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
        $providedToken = $matches[1];
    }

    $validToken = 'UdfcAsjqaAOJHaSEHpx2N60UA9BZ49Eg';

    if ($providedToken !== $validToken) {
        return [
            'status' => 'error',
            'message' => 'Unauthorized: Invalid token',
            'received_header' => $authHeader
        ];
    }

    // Get raw input
    $rawData = file_get_contents('php://input');
    $data = json_decode($rawData, true);

    // Log incoming request
    file_put_contents(
        Yii::getAlias('@runtime/logs/urbanbolt_log.txt'),
        date('Y-m-d H:i:s') . " | " . $rawData . PHP_EOL,
        FILE_APPEND
    );

    // Return response
    
    // Map UrbanBolt status codes to internal system status IDs
    $statusMapping = [
        'MAN' => 4,   // Manifested
        'PKA' => 5, 'PKU' => 5, 'PKD' => 5, 'PKF' => 5, 'IND' => 5, // Pickup done
        'INT' => 27, 'BGD' => 27, 'DBG' => 27, 'DPD' => 27, 'ARD' => 27, 'RDC' => 27, 'RTL' => 27, // In transit
        'OFD' => 30,  // Out For Delivery
        'UDD' => 9,   // Undelivered
        'DDL' => 3,   // Delivered
        'CAN' => 8,   // Cancelled
        'RTO' => 26,  // RTO in transit
        'RTD' => 47,  // RTO Delivered
    ];

    // Handle single or multiple payloads
    $track_data = isset($track_data[0]) ? $track_data : [$track_data];

    foreach ($track_data as $tracking) {
        $awbNumber = trim($tracking['awb'] ?? '');
        if (!$awbNumber) continue;

        // Find Dispatch
        $dispatch_model = ItEasyOrderDispatch::findOne(['it_easy_awb_number' => $awbNumber]);
        if (empty($dispatch_model)) continue;

        // Find Order
        $order_model = ItEasyOrder::findOne(['it_easy_order_id' => $dispatch_model->it_easy_order_id]);
        if (empty($order_model)) continue;

        // Extract data
        $currentStatus = strtoupper($tracking['status_code'] ?? '');
        $statusDesc = $tracking['status_description'] ?? '';
        $remark = $tracking['remarks'] ?? '';
        $location = $tracking['event_location'] ?? '';
        $timestamp = isset($tracking['event_date']) ? date('Y-m-d H:i:s', strtotime($tracking['event_date'])) : date('Y-m-d H:i:s');

        // Save Tracking Log
        $log = new ItEasyQueryTracking();
        $log->courier_name = 'Urbanbolt';
        $log->order_id = $dispatch_model->it_easy_order_id;
        $log->awb_number = $awbNumber;
        $log->cp_id = $tracking['order_number'] ?? '';
        $log->remark = $remark;
        $log->status_code = $currentStatus;
        $log->status_description = $statusDesc;
        $log->status_description_bucket = $statusDesc;
        $log->location = $location;
        $log->timestamp = $timestamp;
        $log->status_time = $timestamp;
        $log->query = json_encode($tracking);
        $log->save(false);

        // Internal status update
        $internalStatusId = $statusMapping[$currentStatus] ?? 27;
        $order_model->it_easy_order_status_id = $internalStatusId;
        $order_model->it_easy_comment = $remark;

        // Update Dispatch & Order
        switch ($currentStatus) {
            case 'MAN': // Manifested
                $dispatch_model->it_easy_order_status = $statusDesc;
                $dispatch_model->it_easy_courier_comment = $remark;
                $dispatch_model->it_easy_status_updated_at = $timestamp;
                $order_model->it_easy_placed_time = $timestamp;
                break;

            case 'PKA':
            case 'PKU':
            case 'PKD':
            case 'PKF':
            case 'IND':
                $dispatch_model->it_easy_order_status = $statusDesc;
                $dispatch_model->it_easy_pickup_time = $timestamp;
                $dispatch_model->it_easy_courier_comment = $remark;
                $dispatch_model->it_easy_status_updated_at = $timestamp;
                break;

            case 'INT':
            case 'BGD':
            case 'DBG':
            case 'DPD':
            case 'ARD':
            case 'RDC':
            case 'RTL':
                $dispatch_model->it_easy_order_status = 'In Transit';
                $dispatch_model->it_easy_courier_comment = $remark;
                $dispatch_model->it_easy_status_updated_at = $timestamp;
                break;

            case 'OFD':
                $dispatch_model->it_easy_order_status = 'Out For Delivery';
                $dispatch_model->it_easy_last_scan_date = $timestamp;
                if (empty($dispatch_model->it_easy_first_scan_date)) {
                    $dispatch_model->it_easy_first_scan_date = $timestamp;
                }
                $dispatch_model->it_easy_attempt_count = ($dispatch_model->it_easy_attempt_count ?? 0) + 1;
                $dispatch_model->it_easy_courier_comment = $remark;
                break;

            case 'DDL': // Delivered
                $dispatch_model->it_easy_order_status = 'Delivered';
                $dispatch_model->it_easy_delivery_date = $timestamp;
                $order_model->it_easy_delivered_time = $timestamp;
                $dispatch_model->it_easy_courier_comment = 'Delivered successfully';
                break;

            case 'UDD': // Undelivered
            case 'CAN': // Cancelled
            case 'RTO': // RTO
            case 'RTD': // RTO Delivered
                $dispatch_model->it_easy_order_status = $statusDesc;
                $dispatch_model->it_easy_courier_comment = $remark;
                $dispatch_model->it_easy_status_updated_at = $timestamp;
                break;

            default:
                $dispatch_model->it_easy_order_status = $statusDesc ?: 'In Transit';
                $dispatch_model->it_easy_courier_comment = $remark;
                $dispatch_model->it_easy_status_updated_at = $timestamp;
                break;
        }

        // Save updates
        $order_model->save(false);
        $dispatch_model->save(false);
    }
    return [
        'status' => 'Success',
        'message' => 'Data Received and Logged',
        'awb' => isset($data['awb']) ? $data['awb'] : null,
        'received_header' => $authHeader
    ];
}




public function actionDelhiveryOneWebhook()
{
    Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
    $this->enableCsrfValidation = false;

    // Allow Delhivery servers
    header('Access-Control-Allow-Origin: *');
    header('Content-Type: application/json');

    // --- Validate Authorization Token ---
  $headers = array_change_key_case(getallheaders(), CASE_LOWER);
$auth = $headers['x-auth-token'] ?? '';

$expectedToken = 'DLVRY-9f73a21c-45b6-4b90-8d4c-9aa27e2025WH';

if ($auth !== $expectedToken && $auth !== 'Bearer ' . $expectedToken) {
    file_put_contents('delhivery_one_webhook_log.txt', date('Y-m-d H:i:s') . " | Unauthorized access attempt | Token: {$auth}" . PHP_EOL, FILE_APPEND);
    Yii::$app->response->statusCode = 401;
    return ['code' => 401, 'message' => 'Unauthorized: Invalid or missing token'];
}


    // Read incoming JSON payload
    $rawData = file_get_contents('php://input');
    $data = json_decode($rawData, true);

    // Log raw data for debugging
    file_put_contents('delhivery_one_webhook_log.txt', date('Y-m-d H:i:s') . " | Payload: " . $rawData . PHP_EOL, FILE_APPEND);

    // Basic validation
    if (empty($data['Shipment']['AWB'])) {
        return ['code' => 406, 'message' => 'AWB number missing'];
    }

    // --- Extract fields based on Delhivery documentation ---
    $awb        = $data['Shipment']['AWB'];
    $status     = $data['Shipment']['Status']['Status'] ?? '';
    $statusType = $data['Shipment']['Status']['StatusType'] ?? '';
    $statusDate = $data['Shipment']['Status']['StatusDateTime'] ?? date('Y-m-d H:i:s');
    $remarks    = $data['Shipment']['Status']['Instructions'] ?? '';
    $location   = $data['Shipment']['Status']['StatusLocation'] ?? '';
//   return [
//     'status' => 'success',
//     'message' => 'Webhook received successfully',
//     'awb' => $awb,
//     'current_status' => $status,
//     'status_time' => $statusDate
// ];

    // --- Find related models ---
    $dispatch_model = ItEasyOrderDispatch::findOne(['it_easy_awb_number' => $awb]);
    if (empty($dispatch_model)) {
        return ['code' => 405, 'message' => "AWB Number ($awb) not found in system"];
    }

    $order_model = ItEasyOrder::findOne(['it_easy_order_id' => $dispatch_model->it_easy_order_id]);
    if (empty($order_model)) {
        return ['code' => 407, 'message' => 'Order ID not found for this AWB'];
    }

    // --- Create tracking log ---
    $tracking = new ItEasyQueryTracking();
    $tracking->courier_name = 'Delhivery One';
    $tracking->order_id = $dispatch_model->it_easy_order_id;
    $tracking->awb_number = $awb;
    $tracking->remark = $remarks;
    $tracking->status_code = $status;
    $tracking->status_description_bucket = $statusType;
    $tracking->status_description = $status;
    $tracking->location = $location;
    $tracking->timestamp = $statusDate;
    $tracking->query = json_encode($data);
    $tracking->status_time = date('Y-m-d H:i:s');

    // --- Map Delhivery statuses ---
    switch (strtolower($status)) {
        // case 'manifested':
        //     $order_model->it_easy_order_status_id = 4; // Manifested
        //     break;
        case 'not picked':
            $order_model->it_easy_order_status_id = 31; // Not Picked
            break;
        case 'in transit':
            $order_model->it_easy_order_status_id = 27; // In Transit
            break;
        case 'pending':
            $order_model->it_easy_order_status_id = 29; // Pending
            break;
        case 'dispatched':
            $order_model->it_easy_order_status_id = 30; // Out for delivery
            break;
        case 'delivered':
            $order_model->it_easy_order_status_id = 3; // Delivered
            $order_model->it_easy_delivered_time = $statusDate;
            $dispatch_model->it_easy_delivery_date = $statusDate;
            break;
        case 'rto':
            $order_model->it_easy_order_status_id = 26; // RTO Initiated
            $dispatch_model->rto_initiate_date = $statusDate;
            break;
        case 'dto':
            $order_model->it_easy_order_status_id = 47; // Return Delivered
            break;
        case 'canceled':
            $order_model->it_easy_order_status_id = 8; // Cancelled
            break;
        default:
            $order_model->it_easy_order_status_id = 27; // Default In Transit
            break;
    }

    // --- Update remarks and save models ---
    $order_model->it_easy_comment = $remarks;
    $order_model->save(false);

    $dispatch_model->it_easy_order_status = ucfirst($status);
    $dispatch_model->it_easy_courier_comment = $remarks;
    $dispatch_model->it_easy_status_updated_at = $statusDate;
    $dispatch_model->save(false);

    $tracking->save(false);

    // --- Optional: trigger order sync to another system ---
    if (in_array(strtolower($status), ['delivered', 'rto', 'dto'])) {
        $this->sendOrderCreatedWebhook($order_model);
    }

    // --- Respond quickly (<500 ms) ---
    return ['code' => 200, 'message' => 'Delhivery Webhook processed successfully'];
}




    
    
    //end
    
    
    //zippy tracking code work
    
    public function actionZippyWebhook()
{
    Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
    $this->enableCsrfValidation = false;

    header('Access-Control-Allow-Origin: *');
    header('Content-Type: application/json');

    /* ===============================
     * 1. AUTH VALIDATION (OPTIONAL)
     * =============================== */
    $headers = array_change_key_case(getallheaders(), CASE_LOWER);
    $auth = $headers['x-zippy-key'] ?? '';

    $expectedToken = 'ZIPPY-9f73a21c-45b6-4b90-8d4c-9aa27e2025WH'; // change if provided by Zippyy

    if ($auth !== $expectedToken) {
        Yii::$app->response->statusCode = 401;
        return [
            'code' => 401,
            'message' => 'Unauthorized webhook'
        ];
    }

    /* ===============================
     * 2. READ RAW PAYLOAD
     * =============================== */
    $rawData = file_get_contents('php://input');
    $data = json_decode($rawData, true);

    file_put_contents(
        'zippyy_webhook_log.txt',
        date('Y-m-d H:i:s') . " | Payload: " . $rawData . PHP_EOL,
        FILE_APPEND
    );

    if (empty($data['awb'])) {
        return ['code' => 406, 'message' => 'AWB missing'];
    }

    /* ===============================
     * 3. EXTRACT ZIPPYY FIELDS
     * =============================== */
    $awb        = $data['awb'];
    $status    = strtolower($data['status'] ?? '');
    $subStatus = strtolower($data['subStatus'] ?? '');
    $remarks   = $data['remarks'] ?? '';
    $location  = $data['location'] ?? '';
    $statusAt  = !empty($data['statusAt'])
        ? date('Y-m-d H:i:s', $data['statusAt'] / 1000)
        : date('Y-m-d H:i:s');

    /* ===============================
     * 4. FIND ORDER & DISPATCH
     * =============================== */
    $dispatch_model = ItEasyOrderDispatch::findOne(['it_easy_awb_number' => $awb]);
    if (!$dispatch_model) {
        return ['code' => 405, 'message' => "AWB ($awb) not found"];
    }

    $order_model = ItEasyOrder::findOne([
        'it_easy_order_id' => $dispatch_model->it_easy_order_id
    ]);
    if (!$order_model) {
        return ['code' => 407, 'message' => 'Order not found'];
    }

    /* ===============================
     * 5. SAVE TRACKING LOG
     * =============================== */
    $tracking = new ItEasyQueryTracking();
    $tracking->courier_name = 'Zippyy';
    $tracking->order_id = $order_model->it_easy_order_id;
    $tracking->awb_number = $awb;
    $tracking->remark = $remarks;
    $tracking->status_code = $subStatus;
    $tracking->status_description_bucket = $status;
    $tracking->status_description = $subStatus;
    $tracking->location = $location;
    $tracking->timestamp = $statusAt;
    $tracking->query = json_encode($data);
    $tracking->status_time = date('Y-m-d H:i:s');

    /* ===============================
     * 6. STATUS MAPPING (GODASH)
     * =============================== */
    switch ($status) {

        case 'pre_transit':
            $order_model->it_easy_order_status_id = 31; // Pickup Awaited
            break;

        case 'in_transit':
            $order_model->it_easy_order_status_id = 27; // In Transit
            break;

        case 'out_for_delivery':
            $order_model->it_easy_order_status_id = 30; // Out for Delivery
            break;

        case 'delivered':
            $order_model->it_easy_order_status_id = 3; // Delivered
            $order_model->it_easy_delivered_time = $statusAt;
            $dispatch_model->it_easy_delivery_date = $statusAt;
            break;

        case 'cancelled':
            $order_model->it_easy_order_status_id = 8; // Cancelled
            break;

        case 'exception':
            $order_model->it_easy_order_status_id = 29; // Exception
            break;

        case 'rto':
            $order_model->it_easy_order_status_id = 26; // RTO
            if (in_array($subStatus, ['rto_delivered'])) {
                $order_model->it_easy_order_status_id = 47; // RTO Delivered
            }
            break;

        case 'return_to_sender':
            $order_model->it_easy_order_status_id = 47; // Return to Sender
            break;

        default:
            $order_model->it_easy_order_status_id = 27; // Default In Transit
            break;
    }

    /* ===============================
     * 7. UPDATE MODELS
     * =============================== */
    $order_model->it_easy_comment = $remarks;
    $order_model->save(false);

    $dispatch_model->it_easy_order_status = strtoupper($status);
    $dispatch_model->it_easy_courier_comment = $remarks;
    $dispatch_model->it_easy_status_updated_at = $statusAt;
    $dispatch_model->save(false);

    $tracking->save(false);

    /* ===============================
     * 8. FINAL WEBHOOK TRIGGER
     * =============================== */
    if (in_array($status, ['delivered', 'rto', 'return_to_sender'])) {
        $this->sendOrderCreatedWebhook($order_model);
    }

    /* ===============================
     * 9. RESPONSE
     * =============================== */
    return [
        'code' => 200,
        'message' => 'Zippyy webhook processed',
        'awb' => $awb,
        'status' => $status,
        'sub_status' => $subStatus
    ];
}


//end zippy
    
    
    
    
    
      public function sendOrderCreatedWebhook($order)
{

    // Prepare customer name
    $customer_name = $order->it_easy_shipping_firstname . ' ' . $order->it_easy_lastname;

    // Load related products
    $order_products = \backend\models\ItEasyOrderProduct::find()
        ->where(['it_easy_order_id' => $order->it_easy_order_id])
        ->all();

    $order_summary = [];
    foreach ($order_products as $product) {
       $order_summary[] = $product->it_easy_product_name 
        . ' (' . $product->it_easy_variation_name . ')' // added variation
        . ' (Qty: ' . $product->it_easy_product_quantity . ')';
    }
//     $stage = "";
// if ($order->it_easy_order_status_id == 3) {
//     $stage = 'delivery_success';
// } if ($order->it_easy_order_status_id == 9) {
//     $stage = 'delivery_failed';
// }

$stage = null; // explicitly null
if ($order->it_easy_order_status_id == 3) {
    $stage = 'delivery_success';
} elseif ($order->it_easy_order_status_id == 9) {
    $stage = 'delivery_failed';
}

// Optional: skip webhook if $stage is null
if (!$stage) {
    return false; // or just skip sending
}


 $order_summary=implode(', ', $order_summary);
 $order_id=$order->it_easy_order_id;
 $total_amount=$order->it_easy_total_price;
 $customer_phone = $order->it_easy_mobile_number; 
  
    // // Prepare payload
    // $payload = [
    //     'order_id' => $order->it_easy_order_id,
    //     'customer_name' => $customer_name,
    //     'total_amount' => $order->it_easy_total_price,
    //     'order_summary' => implode(', ', $order_summary),
    // ];
    
     $result = webhookSender::sendOrderStageWebhook($stage,$customer_name, $order_id,$order_summary,$total_amount,$customer_phone,$order);
     
     
   
    return true;

    
}//private function create

// public function actionTrackTest(){
    
//     $orderId = 350166;  // your static order ID
// $order_model =ItEasyOrder::findOne($orderId);
//      $this->sendOrderCreatedWebhook($order_model); 
// }

public function actionSendUrbanboltTest()
{
    $this->enableCsrfValidation = false;
    header('Content-Type: application/json');
    header('Access-Control-Allow-Origin: *');

    // The URL of your webhook endpoint
    $webhookUrl = 'https://rootpanel.skygainnutricare.com/backend/web/tracking-api/urbanbolttracking';

    // Example payload (Urbanbolt format)
    $payload = [
        [
            "awb" => "TEST123456",
            "edd" => date('Y-m-d H:i:s'),
            "lat" => 0,
            "lng" => 0,
            "pieces" => 1,
            "weight" => "0.2",
            "pod_url" => "",
            "remarks" => "Test payload",
            "customer" => "CS_TEST",
            "isReturn" => false,
            "event_date" => date('Y-m-d H:i:s'),
            "reason_code" => "",
            "status_code" => "DDL",
            "order_number" => "TESTORDER001",
            "otp_verified" => "No",
            "product_type" => "PPD",
            "reference_awb" => "",
            "event_location" => "TEST_LOC",
            "status_description" => "Delivered"
        ]
    ];

    // Bearer token for testing
    $bearerToken = 'UdfcAsjqaAOJHaSEHpx2N60UA9BZ49Eg';

    // Initialize cURL
    $ch = curl_init($webhookUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $bearerToken
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

    // Execute the request
    $response = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);

    // Return result
    if ($error) {
        return $this->asJson([
            'code' => 500,
            'message' => 'cURL Error: ' . $error
        ]);
    } else {
        return $this->asJson([
            'code' => 200,
            'message' => 'Test payload sent successfully',
            'response' => $response
        ]);
    }
}


public function actionDelsendWebhookTest()
{
    $url = "https://rootpanel.skygainnutricare.com/backend/web/tracking-api/delhivery-one-webhook";

    // ✅ The same token you expect in your webhook function
    $token = "Bearer DLVRY-9f73a21c-45b6-4b90-8d4c-9aa27e2025WH"; //DLVRY-9f73a21c-45b6-4b90-8d4c-9aa27e2025WH

    // ✅ Payload as per Delhivery documentation
    $payload = [
        "Shipment" => [
            "Status" => [
                "Status" => "Manifested",
                "StatusDateTime" => "2019-01-09T17:10:42.767",
                "StatusType" => "UD",
                "StatusLocation" => "Chandigarh_Raiprkln_C (Chandigarh)",
                "Instructions" => "Manifest uploaded"
            ],
            "PickUpDate" => "2019-01-09 17:10:42.543",
            "NSLCode" => "X-UCI",
            "Sortcode" => "IXC/MDP",
            "ReferenceNo" => "28",
            "AWB" => "DLVTEST123456789"
        ]
    ];

    // ✅ Initialize cURL
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
   curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'X-Auth-Token: ' . $token
]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

    // ✅ Execute and capture response
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

   Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
return [
    'response_code' => $httpCode,
    'response_body' => json_decode($response, true) ?: $response,
];
}


//new test
public function actionDelhiveryWebhookCurlTest()
{
    $url = "https://rootpanel.skygainnutricare.com/backend/web/tracking-api/delhivery-one-webhook";

    // Token with Bearer (same as your curl command)
    $token = "Bearer DLVRY-9f73a21c-45b6-4b90-8d4c-9aa27e2025WH";

    // Payload same as Delhivery documentation
    $payload = [
        "Shipment" => [
            "Status" => [
                "Status" => "Manifested",
                "StatusDateTime" => "2019-01-09T17:10:42.767",
                "StatusType" => "UD",
                "StatusLocation" => "Chandigarh_Raiprkln_C (Chandigarh)",
                "Instructions" => "Manifest uploaded"
            ],
            "PickUpDate" => "2019-01-09T17:10:42.543",
            "NSLCode" => "X-UCI",
            "Sortcode" => "IXC/MDP",
            "ReferenceNo" => "28",
            "AWB" => "XXXXXXXXXXXX"
        ]
    ];

    // Initialize cURL
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'X-Auth-Token: ' . $token
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

    // Execute
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);

    // Return JSON response
    Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
    return [
        'request_url' => $url,
        'response_code' => $httpCode,
        'curl_error' => $error ?: 'none',
        'response_body' => json_decode($response, true) ?: $response,
    ];
}




}

