<?php

namespace backend\controllers;



use backend\models\ItEasyUndelivered;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\data\ArrayDataProvider;
use yii2tech\spreadsheet\Spreadsheet;
/**
 * DepartmentController implements the CRUD actions for ItEasyDepartment model.
 */
class UndeliveredController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyDepartment models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyUndelivered();
        
        $dataProvider = $searchModel->search($this->request->queryParams);
        $dataProvider->pagination->pageSize = 100;
        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

  
    public function actionExport4()
    {

        $searchModel = new ItEasyUndelivered();
        
        $query = $searchModel->search($this->request->queryParams);

        $data_fetch = $query->asArray()->all();
    
        $exporter = new Spreadsheet([
            'dataProvider' => new ArrayDataProvider([
                'allModels' => $data_fetch,
            ]),
            'columns' => [
                ['attribute' => 'Order_Number'],
                ['attribute' => 'Firstname'],
                ['attribute' => 'Lastname'],
                ['attribute' => 'Mobile_Number'],
                ['attribute' => 'Email'],
                ['attribute' => 'City'],
                ['attribute' => 'State'],
                ['attribute' => 'Pincode'],
                ['attribute' => 'NDR_Agent'],
                ['attribute' => 'Created_time'],
                ['attribute' => 'Placed_time'],
              
            ],
        ]);
        return $exporter->send('Order-Export.xlsx');
    }
   
}
