<?php

namespace backend\controllers;

use Yii;
use yii\web\Controller;
use yii\web\Response;
use yii\db\ActiveRecord;
use yii\db\Connection;

class UrbanboltTestController extends Controller
{
    public $enableCsrfValidation = false;

    // Define DB connection for this controller only
    private $db;

    public function init()
    {
       parent::init();
        $this->db = new Connection([
            'dsn' => 'mysql:host=localhost;dbname=offernutriherbs_test',
            'username' => 'offernutriherbs_stest',
            'password' => 'sunil@321',
            'charset' => 'utf8mb4',
        ]);
        $this->db->open();
    }

    // Define AR model dynamically using this DB
    private function getOrderModelClass()
    {
        return new class extends ActiveRecord {
            public static $db;
            public static function getDb()
            {
                return self::$db;
            }
            public static function tableName()
            {
                return 'it_easy_order_2023_2024';
            }
        };
    }

    private function getDispatchModelClass()
    {
        return new class extends ActiveRecord {
            public static $db;
            public static function getDb()
            {
                return self::$db;
            }
            public static function tableName()
            {
                return 'it_easy_order_dispatch_2023_2024';
            }
        };
    }

    private function getQueryTrackingModelClass()
    {
        return new class extends ActiveRecord {
            public static $db;
            public static function getDb()
            {
                return self::$db;
            }
            public static function tableName()
            {
                return 'it_easy_query_tracking';
            }
        };
    }

    public function actionUrbanbolttracking()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: *');
        Yii::$app->response->format = Response::FORMAT_JSON;

        $track_data = json_decode(file_get_contents("php://input"), true);

        $validApiKey = "UdfcAsjqaAOJHaSEHpx2N60UA9BZ49Eg";
        $providedApiKey = $_SERVER['HTTP_X_API_KEY'] ?? $_SERVER['REDIRECT_HTTP_X_API_KEY'] ?? '';

        if (function_exists('apache_request_headers')) {
            $headersArr = apache_request_headers();
            if (isset($headersArr['x-api-key'])) $providedApiKey = $headersArr['x-api-key'];
        }

        if ($providedApiKey !== $validApiKey) {
            http_response_code(401);
            return ['error' => 'Unauthorized: Invalid API key'];
        }

        if (empty($track_data['data'][0]['awbNumber'])) {
            return ['code' => 406, 'message' => "AWB NUMBER hasn't found"];
        }

        $awbNumber = $track_data['data'][0]['awbNumber'];

        // Assign DB connection to models
        $OrderModel = $this->getOrderModelClass();
        $DispatchModel = $this->getDispatchModelClass();
        $QueryModel = $this->getQueryTrackingModelClass();

        $OrderModel::$db = $this->db;
        $DispatchModel::$db = $this->db;
        $QueryModel::$db = $this->db;

        $dispatch_model = $DispatchModel::findOne(['it_easy_awb_number' => $awbNumber]);
        if (!$dispatch_model) return ['code'=>405,'message'=>"AWB Number $awbNumber didn't find"];

        $order_model = $OrderModel::findOne(['it_easy_order_id' => $dispatch_model->it_easy_order_id]);
        if (!$order_model) return ['code'=>407,'message'=>"ORDER ID didn't match"];

        $currentStatus = strtoupper($track_data['data'][0]['currentStatusCode'] ?? '');
        $currentStatusDesc = $track_data['data'][0]['currentStatusCodeDescription'] ?? '';
        $remark = $track_data['data'][0]['remarks'] ?? '';
        $currentLocation = $track_data['data'][0]['currentLocation'] ?? '';
        $date = \DateTime::createFromFormat("d M Y, H:i", $track_data['data'][0]['currentStatusDateTime']);
        $time_stamp = $date ? $date->format('Y-m-d H:i:s') : date('Y-m-d H:i:s');

        $statusMapping = [
            'MAN'=>4,'PKA'=>5,'PKU'=>5,'PKD'=>5,'PKF'=>5,'IND'=>5,
            'INT'=>27,'BGD'=>27,'DBG'=>27,'DPD'=>27,'ARD'=>27,'RDC'=>27,'RTL'=>27,
            'OFD'=>30,'UDD'=>9,'DDL'=>3,'CAN'=>8,'RTO'=>26,'RTD'=>47
        ];
        $orderStatusId = $statusMapping[$currentStatus] ?? 27;

        // Save to query tracking
        $model = new $QueryModel();
        $model->courier_name = 'Urbanbolt';
        $model->order_id = $dispatch_model->it_easy_order_id;
        $model->awb_number = $awbNumber;
        $model->cp_id = $track_data['data'][0]['orderNumber'] ?? '';
        $model->remark = $remark;
        $model->status_code = $currentStatus;
        $model->timestamp = $time_stamp;
        $model->status_description_bucket = $currentStatusDesc;
        $model->location = $currentLocation;
        $model->status_description = $currentStatusDesc;
        $model->query = json_encode($track_data);
        $model->status_time = date('Y-m-d H:i:s');
        $model->save(false);

        return [
            'code'=>200,
            'message'=>"Saved Successfully (Test DB)",
            'awbNumber'=>$awbNumber,
            'orderStatusMapped'=>$orderStatusId
        ];
    }
}
