<?php

namespace backend\controllers;



use yii;
use backend\models\ItEasyUserConnectedStatus;
use backend\models\ItEasyUserConnectedStatusSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;


/**
 * UserConnectedStatusController implements the CRUD actions for ItEasyUserConnectedStatus model.
 */
class UserConnectedStatusController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyUserConnectedStatus models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyUserConnectedStatusSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ItEasyUserConnectedStatus model.
     * @param int $it_easy_id It Easy ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    

    /**
     * Creates a new ItEasyUserConnectedStatus model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new ItEasyUserConnectedStatus();

        if ($this->request->isPost) {

            // echo"<pre>";print_r($post);die;
         
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');
            $time = time();
           
          

            if ($model->load($this->request->post())){
                $post = Yii::$app->request->post();
            //   echo"<pre>";print_r($post);die;
                $example = implode(',',$post['ItEasyUserConnectedStatus']['it_easy_status_id']);
                $example2 = implode(',',$post['ItEasyUserConnectedStatus']['it_easy_disposition_id']);   
                
                // echo"<pre>";print_r($example);die;
                $model->it_easy_status_id = $example;
                $model->it_easy_disposition_id = $example2;
              
                $model->save();
                Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');    
                return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
            }
        } else {
            $model->loadDefaultValues();
        }
       
        return $this->render('create', [
            'model' => $model,
        ]);
    } 


    /**
     * Updates an existing ItEasyUserConnectedStatus model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_id It Easy ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_id)
    {
        $model = $this->findModel($it_easy_id);

        if ($this->request->isPost) {

            // echo"<pre>";print_r($post);die;
         
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');
            $time = time();
           
          

            if ($model->load($this->request->post())){
                $post = Yii::$app->request->post();
            //   echo"<pre>";print_r($post);die;
                $example = implode(',',$post['ItEasyUserConnectedStatus']['it_easy_status_id']);
                $example2 = implode(',',$post['ItEasyUserConnectedStatus']['it_easy_disposition_id']);   
                
                // echo"<pre>";print_r($example);die;
                $model->it_easy_status_id = $example;
                $model->it_easy_disposition_id = $example2;
              
                $model->save();
                Yii::$app->session->setFlash('success', 'Your Data has been saved successfully.');    
                return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    
    protected function findModel($it_easy_id)
    {
        if (($model = ItEasyUserConnectedStatus::findOne(['it_easy_id' => $it_easy_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
