<?php

namespace backend\controllers;

use backend\models\ItEasyUser;
use backend\models\ItEasyUserSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use yii\filters\AccessControl;

/**
 * UserController implements the CRUD actions for ItEasyUser model.
 */
class UserController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyUser models.
     *
     * @return string
     */
    public function actionIndex()
    {   
        if(Yii::$app->user->identity->it_easy_dept_id == '8'){
            $searchModel = new ItEasyUserSearch();
            $dataProvider = $searchModel->search($this->request->queryParams);

            return $this->render('index', [
                'searchModel' => $searchModel,
                'dataProvider' => $dataProvider,
            ]);
        }else{
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    public function actionLiveIndex()
    {
        $searchModel = new ItEasyUserSearch();
        $dataProvider = $searchModel->livesearch($this->request->queryParams);
        

        return $this->render('live-index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    
    public function actionCreate()
    {   
        if(Yii::$app->user->identity->it_easy_dept_id == '8'){
            $model = new ItEasyUser();

            if ($this->request->isPost) {
                if ($model->load($this->request->post()) ) {
                    
                    $data = Yii::$app->request->post('ItEasyUser');
                    // echo "<pre>"; print_r($data); die;        
                    $password = $data['it_easy_password_hash'];
                    date_default_timezone_set("Asia/Kolkata");
                    $create_date=date("Y-m-d H:i:s");
                    $model->auth_key = Yii::$app->security->generateRandomString();
                    
                    $model->created_time = $create_date; 
                    $model->created_at = Yii::$app->user->identity->id;
                    $model->login_status = '0';
                    if(!empty($password)) { 
                     $model->it_easy_password_hash = Yii::$app->security->generatePasswordHash($password);
                    }
                    if (is_array($model->it_easy_platform)) {
                        // Convert array to comma-separated string
                        $model->it_easy_platform = implode(',', $model->it_easy_platform);
                    }
                    $model->save();
                    Yii::$app->session->setFlash('success','Your data has been created');
                    return $this->redirect(['index','id'=>$model->id]);
                }
            } else {
                $model->loadDefaultValues();
            }

            return $this->render('create', [
                'model' => $model,
            ]);
        }else{
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    /**
     * Updates an existing ItEasyUser model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $id ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load($this->request->post()) ) {
                
            $data = Yii::$app->request->post('ItEasyUser');
            // echo "<pre>"; print_r($data); die;        
            $password = $data['it_easy_password_hash'];
            date_default_timezone_set("Asia/Kolkata");
            $create_date=date("Y-m-d H:i:s");
            $model->updated_time = $create_date; 
            $model->updated_at = Yii::$app->user->identity->id;
            if(!empty($password)) { 
                $model->it_easy_password_hash = Yii::$app->security->generatePasswordHash($password);
            }else{
                unset($model->it_easy_password_hash);
            }
            if (is_array($model->it_easy_platform)) {
                // Convert array to comma-separated string
                $model->it_easy_platform = implode(',', $model->it_easy_platform);
            }
            $model->save();
            Yii::$app->session->setFlash('success','Your data has been created');
            return $this->redirect(['index','id'=>$model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    
    protected function findModel($id)
    {
        if (($model = ItEasyUser::findOne(['id' => $id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
