<?php

namespace backend\controllers;

use backend\models\ItEasyUserPermissionGroup;
use backend\models\ItEasyUserPermissionGroupSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use Yii;
/**
 * UserPermissionGroupController implements the CRUD actions for ItEasyUserPermissionGroup model.
 */
class UserPermissionGroupController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyUserPermissionGroup models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyUserPermissionGroupSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ItEasyUserPermissionGroup model.
     * @param int $id ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */


    /**
     * Creates a new ItEasyUserPermissionGroup model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new ItEasyUserPermissionGroup();

        if($model->load(Yii::$app->request->post())){
            $post=Yii::$app->request->post();
            date_default_timezone_set('Asia/kolkata');
            if($model->permission_menu){
                $data=$model->permission_menu;
              
                $model->permission_menu=implode(",",$data);
            }
         
            $currentDateTime=date('Y-m-d  H:i:s');
            $time=time();
            $model->created_by=Yii::$app->user->identity->id;
            $model->created_time=$currentDateTime;
           
            $model->save();
            
            Yii::$app->session->setFlash('success','Form has been created');
            return $this->redirect(['index','id'=>$model->id]);

        }
        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing ItEasyUserPermissionGroup model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $id ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if($model->load(Yii::$app->request->post())){
            $post=Yii::$app->request->post();
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime=date('Y-m-d H:i:s');
            $time=time();
            $model->updated_by=Yii::$app->user->identity->id;
            $model->updated_time=$currentDateTime;
            if($model->permission_menu){
                $data=$model->permission_menu;
              
                $model->permission_menu=implode(",",$data);
            }
            $model->save();
           
            Yii::$app->session->setFlash('success','Form has been updated');
            return $this->redirect(['index','id'=>$model->id]);
        }
else{
   
        $data=$model->permission_menu;
      
        $model->permission_menu=explode(",",$data);
    
}
        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing ItEasyUserPermissionGroup model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $id ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */

    /**
     * Finds the ItEasyUserPermissionGroup model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $id ID
     * @return ItEasyUserPermissionGroup the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = ItEasyUserPermissionGroup::findOne(['id' => $id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    public function actionUserPermissionGroup()
{
    $model = new \backend\models\ItEasyUserPermissionGroup();

    if ($model->load(Yii::$app->request->post())) {
        if ($model->validate()) {
            // form inputs are valid, do something here
            return;
        }
    }

    return $this->render('UserPermissionGroup', [
        'model' => $model,
    ]);
}
}