<?php

namespace backend\controllers;

use backend\models\ItEasyWarehouse;
use backend\models\ItEasyWarehouseSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * WarehouseController implements the CRUD actions for ItEasyWarehouse model.
 */
class WarehouseController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all ItEasyWarehouse models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyWarehouseSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ItEasyWarehouse model.
     * @param int $it_easy_warehouse_id It Easy Warehouse ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($it_easy_warehouse_id)
    {
        return $this->render('view', [
            'model' => $this->findModel($it_easy_warehouse_id),
        ]);
    }

    /**
     * Creates a new ItEasyWarehouse model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new ItEasyWarehouse();

        if ($this->request->isPost) {
            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['view', 'it_easy_warehouse_id' => $model->it_easy_warehouse_id]);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing ItEasyWarehouse model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_warehouse_id It Easy Warehouse ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_warehouse_id)
    {
        $model = $this->findModel($it_easy_warehouse_id);

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'it_easy_warehouse_id' => $model->it_easy_warehouse_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing ItEasyWarehouse model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $it_easy_warehouse_id It Easy Warehouse ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($it_easy_warehouse_id)
    {
        $this->findModel($it_easy_warehouse_id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the ItEasyWarehouse model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_warehouse_id It Easy Warehouse ID
     * @return ItEasyWarehouse the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_warehouse_id)
    {
        if (($model = ItEasyWarehouse::findOne(['it_easy_warehouse_id' => $it_easy_warehouse_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
