<?php

namespace backend\controllers;

use Yii;
use backend\models\ItEasyWarehouseHistory;
use backend\models\ItEasyWarehouseHistorySearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use backend\models\ItEasyWarehouse;
use backend\models\ItEasyProduct;
use backend\models\ItEasyWarehouseProductQuantity;
use backend\models\ItEasyWarehouseProductQuantitySearch;
use backend\models\ItEasyAddWarehouseHistory;
use yii\filters\AccessControl;
use backend\models\ItEasyProductVariationAttribute;
use backend\models\ItEasyAddWarehouseHistorySearch;
/**
 * WarehouseHistoryController implements the CRUD actions for ItEasyWarehouseHistory model.
 */
class WarehouseHistoryController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyWarehouseHistory models.
     *
     * @return string
     */
    
  	public function actionProductIndex()
    {
        $searchModel = new ItEasyWarehouseProductQuantitySearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('product-index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }
  
  	public function actionIndex()
    {
        $searchModel = new ItEasyAddWarehouseHistorySearch();
        $dataProvider = $searchModel->search($this->request->queryParams);
        

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            
        ]);
    }


    /**
     * Creates a new ItEasyWarehouseHistory model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new ItEasyWarehouseHistory();
        $addwarehouse_history = new ItEasyAddWarehouseHistory();
        $model_quantity = new ItEasyWarehouseProductQuantity();
         if ($model->load(Yii::$app->request->post())){
                $post = Yii::$app->request->post();
           
                date_default_timezone_set('Asia/kolkata');
                $currentDateTime = date('Y-m-d H:i:s');
                $time = time();
                $model->created_by = Yii::$app->user->identity->id;
                $model->created_time = $currentDateTime; 
                $model->save(false);

                if(!empty($_POST['ItEasyAddWarehouseHistory'])){
                 $all_quantity = 0;
                foreach($_POST['ItEasyAddWarehouseHistory'] as $key => $value){
                $addwarehouse_history = new ItEasyAddWarehouseHistory();
                $all_quantity += !empty($value['it_easy_product_quantity']) ? $value['it_easy_product_quantity'] : ''; 
                $addwarehouse_history->it_easy_warehouse_history_id  = $model->it_easy_id;
                $addwarehouse_history->it_easy_product_id   = !empty($value['it_easy_product_id']) ? $value['it_easy_product_id'] : '';
                $addwarehouse_history->it_easy_variation_id = !empty($value['it_easy_variation_id']) ? $value['it_easy_variation_id'] : '';
                $addwarehouse_history->it_easy_product_quantity = !empty($value['it_easy_product_quantity']) ? $value['it_easy_product_quantity'] : '';

                $addwarehouse_history->it_easy_warehouse_name = ItEasyWarehouse::find()->select(['it_easy_warehouse_name'])->where(['it_easy_warehouse_id' => $model->it_easy_warehouse_id])->asArray()->One()['it_easy_warehouse_name'];

                $addwarehouse_history->it_easy_product_name = ItEasyProduct::find()->select(['it_easy_product_name'])->where(['it_easy_product_id' => $value['it_easy_product_id']])->asArray()->One()['it_easy_product_name']; 

                $addwarehouse_history->it_easy_variation_name = ItEasyProductVariationAttribute::find()->select(['it_easy_variation_name'])->where(['it_easy_id' => $value['it_easy_variation_id']])->asArray()->One()['it_easy_variation_name']; 
               
                
                $addwarehouse_history->it_easy_received_by = $model->it_easy_received_by;
                $addwarehouse_history->it_easy_received_date = $model->it_easy_received_date;
                $addwarehouse_history->created_by = Yii::$app->user->identity->id;
                $addwarehouse_history->created_time = $currentDateTime;
                $addwarehouse_history->save(false);
                 
                $check_quanity = ItEasyWarehouseProductQuantity::find()->where(['warehouse_id' => $model->it_easy_warehouse_id])->andWhere(['product_id'=>$value['it_easy_product_id']])->andWhere(['variation_id'=>$value['it_easy_variation_id']])->One();
                if(!empty($check_quanity)){
                    $quan_new = $check_quanity->quantity + $value['it_easy_product_quantity'];
                    $check_quanity->quantity = $quan_new;
                    $check_quanity->save(false);
                }else{
                    $check_quanity = new ItEasyWarehouseProductQuantity();
                    $check_quanity->quantity = $value['it_easy_product_quantity'];
                    $check_quanity->warehouse_id = $model->it_easy_warehouse_id;
                    $check_quanity->product_id  = $addwarehouse_history->it_easy_product_id;
                    $check_quanity->variation_id = $addwarehouse_history->it_easy_variation_id;
                    $check_quanity->last_update_time = $currentDateTime;
                    $check_quanity->save(false);
                }

            }

                $check_warehouse_quanity = ItEasyWarehouse::find()->where(['it_easy_warehouse_id' => $model->it_easy_warehouse_id])->One();
                if(!empty($check_warehouse_quanity && isset($check_warehouse_quanity))){
                    $quan_new = $check_warehouse_quanity->it_easy_product_quantity + $all_quantity;
                    $check_warehouse_quanity->it_easy_product_quantity = $quan_new;
                    $check_warehouse_quanity->save(false);
                    // echo "<pre>";print_r($check_warehouse_quanity);die;
                }
                
        }

                


                Yii::$app->session->setFlash('success', "Your data has been saved!");
                return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
        }

        return $this->render('create', [
            'model' => $model,
            'addwarehouse_history'=>$addwarehouse_history,
        ]);
    }

    /**
     * Updates an existing ItEasyWarehouseHistory model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_id It Easy ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_id)
    {
        $model = $this->findModel($it_easy_id);

        if ($model->load(Yii::$app->request->post())){
                $post = Yii::$app->request->post();
                date_default_timezone_set('Asia/kolkata');
                $currentDateTime = date('Y-m-d H:i:s');
                $time = time();

                $warehoseid = $post['ItEasyWarehouseHistory']['it_easy_warehouse_id'];
                $productid = $post['ItEasyWarehouseHistory']['it_easy_product_id'];
                $variation_id = $post['ItEasyWarehouseHistory']['it_easy_variation_id'];

                $model->it_easy_warehouse_name = ItEasyWarehouse::find()->select(['it_easy_warehouse_name'])->where(['it_easy_warehouse_id' => $warehoseid])->asArray()->One()['it_easy_warehouse_name'];

                $model->it_easy_product_name = ItEasyProduct::find()->select(['it_easy_product_name'])->where(['it_easy_product_id' => $productid])->asArray()->One()['it_easy_product_name'];

                $quantity = $post['ItEasyWarehouseHistory']['it_easy_product_quantity'];

                $check_quanity = ItEasyWarehouseProductQuantity::find()->where(['warehouse_id' => $warehoseid])->andWhere(['product_id'=>$productid])->andWhere(['variation_id'=>$variation_id])->One();

                $oldattribute = $model->oldAttributes['it_easy_product_quantity'];

                $model->updated_by = Yii::$app->user->identity->id;
                $model->updated_time = $currentDateTime; 
                $model->save(false);
                // echo $quantity; echo "<br>";
                // echo $oldattribute; die;


                switch (true) {
                    case $quantity == $oldattribute:
                        Yii::$app->session->setFlash('success', "Your data has been saved!");
                        return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
                        break;
                    case $quantity > $oldattribute:
                        $get_actual = $quantity - $oldattribute;
                        $get_act = $get_actual + $check_quanity->quantity;
                        $check_quanity->quantity = $get_act;
                        $check_quanity->save(false);
                        // echo "<pre>"; print_r($check_quanity); die;
                        Yii::$app->session->setFlash('success', "Your data has been saved!");
                        return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
                        break;
                        
                    case $quantity < $oldattribute:
                        $get_actual = $quantity - $oldattribute;
                        $get_act = $get_actual + $check_quanity->quantity;
                        if ($get_act < 0){
                            Yii::$app->session->setFlash('error', "Please check your quantity!");
                            return $this->redirect(['update', 'it_easy_id' => $model->it_easy_id]);
                        }else{
                            $check_quanity->quantity = $get_act;
                            $check_quanity->save(false);
                            Yii::$app->session->setFlash('success', "Your data has been saved!");
                            return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
                        }
                        break;
                    
                }
                
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }


       public function actionVariationName(){
        $model = new ItEasyWarehouseHistory();
        $productid = $_REQUEST['setid'];
        $model->getVaritionData($productid);

    }

    public function actionAddwarehousehtml(){
       
        $this->layout = false;
       
        $model2 = new ItEasyWarehouseHistory();
        $getProductName = $model2->getProductName();
        $getVariation = $model2->getVariation();
        $unoqueNumber = $this->generateRandom(6);
        $getid = $_GET['getid'];
        return $this->renderPartial("addwarehousehistoryhtml", ['getProductName'=>$getProductName,'getVariation'=>$getVariation,'unoqueNumber' => $unoqueNumber,'fetchid'=>$getid]);
    }

    public function generateRandom($length = 8){
        $intMin = (10 ** $length) / 10; // 100...
        $intMax = (10 ** $length) - 1;  // 999...
        $codeRandom = mt_rand($intMin, $intMax);
        return $codeRandom;
    }

    /**
     * Finds the ItEasyWarehouseHistory model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_id It Easy ID
     * @return ItEasyWarehouseHistory the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_id)
    {
        if (($model = ItEasyWarehouseHistory::findOne(['it_easy_id' => $it_easy_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
