<?php
namespace backend\controllers;

use Yii;
use yii\web\Controller;
use yii\web\Response;
use yii\web\BadRequestHttpException;
use backend\models\ItEasyOrder; // ✅ Your actual model
use  backend\components\webhookSender;
use backend\models\AddressChangeLog;
use backend\models\AddressUpdateToken;
use yii\filters\Cors;
use backend\models\Pincodecity;





class WebhookTestController extends Controller
{
    
    
   public $enableCsrfValidation = false;

    // Optional: Define a secret key to validate webhook source
    private const SECURITY_KEY = 'b7cf1c0c9dd8d5fcb88e7d9c3f8e67e76312b8cc94f09a7e1e2f486e2a0f9fdc';
    
    
    public function behaviors()
{
    $behaviors = parent::behaviors();

    $behaviors['corsFilter'] = [
        'class' => Cors::class,
        'cors' => [
            'Origin' => ['https://offer.nutriherbs.in','https://update.nutriherbs.in'], // allow your domain
            'Access-Control-Request-Method' => ['GET', 'POST', 'OPTIONS'],
            'Access-Control-Allow-Credentials' => true,
            'Access-Control-Allow-Headers' => ['*'],
        ],
    ];

    return $behaviors;
}
  
   public function actionUpdateConfirmation()
    {
        Yii::$app->response->format = Response::FORMAT_JSON;

        // ✅ Verify method and security key
        if (!Yii::$app->request->isPost) {
            throw new BadRequestHttpException('Invalid method');
        }

        $headers = Yii::$app->request->headers;
        if ($headers->get('X-Security-Key') !== self::SECURITY_KEY) {
            return ['error' => 'Unauthorized'];
        }

        // ✅ Parse request
        $data = json_decode(Yii::$app->request->getRawBody(), true);
       
        $orderId = $data['order_id'] ?? null;
        $new_address = $data['new_address'] ?? null;
         $want_to_change = $data['want_to_change'] ?? null;
        
      
        
      
 // ✅ Validate required inputs
        if (empty($orderId) || empty($new_address) ) {
            return ['error' => 'Missing or invalid input', 'received' => $data];
        }

        $order = ItEasyOrder::findOne($orderId);
   
                            if (!$order) {
                                return ['error' => 'Order not found'];
                            }
        
        $old_address= $order->it_easy_shipping_address_1;
        $response=[];
        
        if($want_to_change=='1'){ 
            //request for change address
            
        
                  $order->updateAttributes([
                    'it_easy_shipping_address_1' => $new_address
                    
                    
                ]);//address updated then log table
                
                $log = new AddressChangeLog();
                $log->order_id = $order->it_easy_order_id;
                $log->old_address = $old_address;
                $log->new_address = $new_address;
                $log->change_status = 1; // or any meaning like '1 = manual update'
                $log->created_at = date('Y-m-d H:i:s'); // Or use Yii::$app->formatter->asDatetime(time())
            
                $log->save(false); // Set to `true` if you want validation
                if ($log->save(false))
                {
                    $response['status'] = 'success';
                    $response['message'] = 'Address changed and log saved.';
                     $response['add_change'] = '1';
                } else {
                    $response['status'] = 'error';
                    $response['message'] = 'Failed to save address change log.';
                }
            
               
        } //first if yes=1
        
        if($want_to_change=='0')
        {
                    $log = new AddressChangeLog();
            $log->order_id = $order->it_easy_order_id;
            $log->old_address = $old_address;
            $log->new_address = "Default No Change";
            $log->change_status = 0; // or any meaning like '1 = manual update'
            $log->created_at = date('Y-m-d H:i:s'); // Or use Yii::$app->formatter->asDatetime(time())
        
            $log->save(false); // Set to `true` if you want validation
            if ($log->save(false)) {
                $response['status'] = 'success';
                $response['message'] = 'Address Will Remains Same.';
                 $response['add_change'] = '0';
            } else {
                $response['status'] = 'error';
                $response['message'] = 'Failed to save address change log.';
            }
        }
               

        // ✅ If confirmed, send webhook
        if ($response['status']=='success' && $response['add_change']=='1') {
            $stage="add_verified";
            $resp=1;
            
          //  return $stage;
        $webhookResponse = $this->sendOrderCreatedWebhook($order,$stage,$resp,$old_address,$new_address);
    return array_merge($response, $webhookResponse);
          
            
        }
         // ✅ If confirmed, send webhook
        if ($response['status']=='success' && $response['add_change']=='0') {
            $stage="add_verified";
            $resp=0;
             // return $stage;
            
        $webhookResponse = $this->sendOrderCreatedWebhook($order,$stage,$resp,$old_address,$new_address);
    return array_merge($response, $webhookResponse);
          
            
        }
      return $response; 

      
    }
  
 

//testing

  public function sendOrderCreatedWebhook($order,$stage,$resp,$old_address,$new_address)
{
    //  return [
    //     'success' => true,
    //     'message' => 'Webhook sent successfully',
    //     'order_id' => $order->order_id ?? null,
    //     'stage' => $stage,
    //     'old_address' => $old_address,
    //     'new_address' => $new_address,
    // ];

    // Prepare customer name
    $customer_name = $order->it_easy_shipping_firstname . ' ' . $order->it_easy_lastname;

    // Load related products
    $order_products = \backend\models\ItEasyOrderProduct::find()
        ->where(['it_easy_order_id' => $order->it_easy_order_id])
        ->all();

    $order_summary = [];
    foreach ($order_products as $product) {
        $order_summary[] = $product->it_easy_product_name . ' (Qty: ' . $product->it_easy_product_quantity . ')';
    }

 $order_summary=implode(', ', $order_summary);
 $order_id=$order->it_easy_order_id;
 $total_amount=$order->it_easy_total_price;
 $customer_phone = $order->it_easy_mobile_number; 
  
    // // Prepare payload
    // $payload = [
    //     'order_id' => $order->it_easy_order_id,
    //     'customer_name' => $customer_name,
    //     'total_amount' => $order->it_easy_total_price,
    //     'order_summary' => implode(', ', $order_summary),
    // ];
   
        $result = webhookSender::testSend($stage,$customer_name, $order_id,$order_summary,$total_amount,$customer_phone,$order,$resp,$old_address,$new_address); 
   
    
    
     
     
   
   return $result;

    
}//private function create


// private function sendOrderCreatedWebhook($order, $stage, $resp)
// {
//     // Do your logic, send webhook, etc.

//     // Return structured response:
//     return [
//         'success' => true,
//         'message' => 'Webhook sent successfully',
//         'order_id' => $order->order_id ?? null,
//         'stage' => $stage,
     
//     ];
// }

public function actionTrackTest(){
    
//     $orderId = 350166;  // your static order ID
//     $stage="order_created";
// $order_model =ItEasyOrder::findOne($orderId);
//      $this->sendOrderCreatedWebhook($order_model,$stage,$resp="",$old_address="",$new_address=""); 
$payload="test";
$firstName="sunil";
$lastName="kumar";
$phone="8368702694";


//webhookSender::sendThanks($payload,$firstName,$lastName,$phone); 


}

//test status
 public function actionTestData()
{
  

  Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

    // Handle JSON body
    $rawBody = Yii::$app->request->getRawBody();
    $data = json_decode($rawBody, true);

    $orderId = $data['order_id'] ?? null;
//$orderId="#352469";

    if (!$orderId) {
        return [
            'status' => 400,
            'message' => 'Missing order_id in request body.',
        ];
    }

    // Now continue your logic
    //$order = ItEasyOrder::findOne($orderId);
     //change
    
 $inputOrderId =$orderId;
$normalizedOrderId = 's' . ltrim($inputOrderId, '#');
//echo $normalizedOrderId;die;

// Now use it to find the order
$order = ItEasyOrder::findOne(['it_easy_other_order_id' => $normalizedOrderId]);


//end
    
//print_r($order);die;
    if (!$order) {
        return [
            'status' => 404,
            'message' => 'Order not found.',
        ];
    }
    // Example: get an existing order by ID (replace with your actual order id)
    //$orderId = 350166; // Replace this with dynamic value or parameter
    // ItEasyOrder::findOne($orderId);

    // if (!$order) {
    //     return [
    //         'status' => 404,
    //         'message' => 'Order not found.',
    //     ];
    // }
    
   $token = Yii::$app->security->generateRandomString(40);

$model = new AddressUpdateToken();
$model->order_id = $order->it_easy_other_order_id;
$model->token = $token;
$model->expires_at = date('Y-m-d H:i:s', strtotime('+1 day')); // 24 hours from now

// $model->expires_at = date('Y-m-d H:i:s', strtotime('+2 days')); // optional expiry
$model->save(false);

// Send this public URL to the user
// $publicUrl = Yii::$app->urlManager->createAbsoluteUrl([
//     '/webhook-test/address-update', 'token' => $token
// ]); 

// New Code (custom public domain link)
// $publicUrl = 'https://offer.nutriherbs.in/verify-address/update-address.php?token=' . urlencode($token);
$publicUrl = 'https://update.nutriherbs.in/verify-address/update-address.php?token=' . urlencode($token);

    
    
    
     Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

    // your logic here...

    return [
        'status' => 200,
        'message' => 'Public address update link generated.',
        'update_link' => $publicUrl,
        'token' => $token,
    ];

    // return [
    //     'status' => 200,
    //     'message' => 'Address changed and log saved.',
    //     'link' => "https://www.google.com", // use full URL
    //     'add_change' => '1',
    //     'response' => 'success',
    //     'error' => '',
    // ];
}//end function


public function actionAddressUpdate($token)
{
  
    $this->layout = false;  // Disable layout
    
   

    Yii::$app->response->format = \yii\web\Response::FORMAT_HTML;

    $tokenModel = AddressUpdateToken::find()
        ->where(['token' => $token, 'is_used' => 0])
        ->andWhere(['>', 'expires_at', date('Y-m-d H:i:s')])
        ->one();

    if (!$tokenModel) {
        return $this->render('token-expired');
    }

    $order = ItEasyOrder::findOne($tokenModel->order_id);

    if (Yii::$app->request->isPost) {
        $newAddress = Yii::$app->request->post('new_address');

        if (!empty($newAddress)) {
            $oldAddress = $order->it_easy_shipping_address_1;

            // Update address
            $order->it_easy_shipping_address_1 = $newAddress;
            $order->save(false);

            // Log
            $log = new AddressChangeLog();
            $log->order_id = $order->it_easy_order_id;
            $log->old_address = $oldAddress;
            $log->new_address = $newAddress;
            $log->change_status = 1;
            $log->created_at = date('Y-m-d H:i:s');
            $log->save(false);

            // Mark token used
            $tokenModel->is_used = 1;
            $tokenModel->save(false);

           return $this->render('address-update-success', [
        'order' => $order
    ]);
        }
    }

    return $this->render('update-form', [
        'order' => $order,
        'token' => $tokenModel,
    ]);
}

public function actionGoogleSheet()
{
    // Get raw POST data
    $rawData = file_get_contents("php://input");

    // Decode JSON to associative array
    $data = json_decode($rawData, true);

    // Convert data to a readable string
    $logContent = "[" . date('Y-m-d H:i:s') . "] " . print_r($data, true) . PHP_EOL;

    // Define log file path (update the directory as needed)
    $logDirectory = Yii::getAlias('@app/runtime/logs'); // Use your preferred path
    $logFile = $logDirectory . '/google_sheet_webhook_log.txt';

    // Ensure the directory exists
    if (!file_exists($logDirectory)) {
        mkdir($logDirectory, 0775, true);
    }

    // Append log content to the file
    file_put_contents($logFile, $logContent, FILE_APPEND);

    // Optional logging to Yii log system
    Yii::info($data, 'webhook');

    // Return a sample response
    return $this->asJson([
        'status' => 'received',
        'data' => $data
    ]);
}

//today

public function actionGetOrderByToken($token)
{
    Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

    $tokenModel = AddressUpdateToken::find()
        ->where(['token' => $token, 'is_used' => 0])
        ->andWhere(['>', 'expires_at', date('Y-m-d H:i:s')])
        ->one();

    if (!$tokenModel) {
        return ['status' => 404, 'message' => 'Invalid or expired token.'];
    }
    else{
          return [
        'status' => 200, 'message' => 'Valid Token.'];
    }

   
}
//end


public function actionAddressUpdate1($token)
{
    $this->layout = false;
    Yii::$app->response->format = \yii\web\Response::FORMAT_HTML;

    $tokenModel = AddressUpdateToken::find()
        ->where(['token' => $token, 'is_used' => 0])
        ->andWhere(['>', 'expires_at', date('Y-m-d H:i:s')])
        ->one();
        

    if (!$tokenModel) {
        return $this->render('token-expired');
    }

    //$order = ItEasyOrder::findOne($tokenModel->order_id);
    
     //change
    
 $inputOrderId =$tokenModel->order_id;
//$normalizedOrderId = 's' . ltrim($inputOrderId, '#');

// Now use it to find the order
$order = ItEasyOrder::findOne(['it_easy_other_order_id' => $inputOrderId]);

//end

    if (Yii::$app->request->isPost) {
          $order_id_crm=$order->it_easy_order_id;
        $address1 = Yii::$app->request->post('new_address');
        $address2 = Yii::$app->request->post('address2');
        $city     = Yii::$app->request->post('city');
        $state    = Yii::$app->request->post('state');
        $pin      = Yii::$app->request->post('pin');
        $shop_id=$inputOrderId;

        if (!empty($address1) && !empty($address2) && !empty($city) && !empty($state) && !empty($pin)) {
            // Store old values
            $old_input = [
                'order_id_crm'=>$order->it_easy_order_id,
                'address1' => $order->it_easy_shipping_address_1,
                'address2' => $order->it_easy_shipping_address_2,
                'city'     => $order->it_easy_shipping_city,
                'state'    => $order->it_easy_shipping_state,
                'pin'      => $order->it_easy_shipping_pincode,
                'shop_id' => $order->it_easy_other_order_id,
            ];

            // Update order
            $order->it_easy_shipping_address_1 = $address1;
            $order->it_easy_shipping_address_2 = $address2;
            $order->it_easy_shipping_city = $city;
            $order->it_easy_shipping_state = $state;
            $order->it_easy_shipping_pincode = $pin;
            $order->it_easy_order_status_id = '1';
            $order->it_easy_order_disposition_id = '3';
            $order->it_easy_assigned_by = '1';
            $order->it_easy_assigned_to = '231';
            $order->save(false);

            // Save log
            $log = new AddressChangeLog();
            $log->order_id = $order->it_easy_other_order_id;
            $log->old_address = json_encode($old_input);
            $log->new_address = json_encode([
                'order_id_crm'=>$order_id_crm,
                'address1' => $address1,
                'address2' => $address2,
                'city'     => $city,
                'state'    => $state,
                'pin'      => $pin,
                'shop_id' => $shop_id,
                
            ]);
            $log->change_status = 1;
            $log->created_at = date('Y-m-d H:i:s');
            $log->save(false);

            // Mark token used
            $tokenModel->is_used = 1;
            $tokenModel->save(false);

            return $this->render('address-update-success', [
                'order' => $order
            ]);
        }
    }

    return $this->render('update-form', [
        'order' => $order,
        'token' => $tokenModel,
    ]);
}


//end

public function actionGetcity() {
    $get = Yii::$app->request->get();
    $get_value = $get['pincode'] ?? null;

    if (!empty($get_value)) {
        $get_pincode = Pincodecity::find()->where(['pincode' => $get_value])->asArray()->one();
        $get_pincode = !empty($get_pincode) ? json_encode($get_pincode) : '';

        $courier_id = ItEasyOrder::getServicealAPIbyPincode($get_value);
        $get_serviceable_name = ItEasyOrder::GetServiceableCourierName($courier_id);

        $str_serviceable = '';
        if (!empty($get_serviceable_name)) {
            $count_serviceable = count($get_serviceable_name);
            foreach ($get_serviceable_name as $key => $service) {
                $str_serviceable .= ($key + 1) . '. ' . $service->it_easy_name;
                if ($key != $count_serviceable - 1) {
                    $str_serviceable .= ' &nbsp;&nbsp;&nbsp;';
                }
            }
        }

        return $get_pincode . '####' . $str_serviceable;
    }

    return 'Invalid Pincode';
}


//new logic

 public function actionTestData1()
{
  

  Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

    // Handle JSON body
    $rawBody = Yii::$app->request->getRawBody();
    $data = json_decode($rawBody, true);

    $orderId = $data['order_id'] ?? null;
   
       $dataToStore = [
    'first_name' => $data['first_name'] ?? null,
    'last_name'  => $data['last_name'] ?? null,
     'phone'  => $data['phone'] ?? null,
];

  

    
 $inputOrderId =$orderId;
$normalizedOrderId = 's' . ltrim($inputOrderId, '#');
$token = Yii::$app->security->generateRandomString(40);

$model = new AddressUpdateToken();
$model->order_id = $normalizedOrderId;
$model->other_data=json_encode($dataToStore);
$model->token = $token;
// $model->expires_at = date('Y-m-d H:i:s', strtotime('+1 day')); // 24 hours from 
$model->expires_at = date('Y-m-d H:i:s', strtotime('+5 minutes'));
$model->save(false);


$publicUrl = 'https://update.nutriherbs.in/verify-address/update-address.php?token=' . urlencode($token);

    
    
    
     Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

    // your logic here...

    return [
        'status' => 200,
        'message' => 'Public address update link generated.',
        'update_link' => $publicUrl,
        'token' => $token,
    ];

   
}//end function

//saving function

public function actionAddressUpdate2($token)
{
    $this->layout = false;
    Yii::$app->response->format = \yii\web\Response::FORMAT_HTML;

    $tokenModel = AddressUpdateToken::find()
        ->where(['token' => $token, 'is_used' => 0])
        ->andWhere(['>', 'expires_at', date('Y-m-d H:i:s')])
        ->one();
        

    if (!$tokenModel) {
        return $this->render('token-expired');
    }

  
    
 $inputOrderId =$tokenModel->order_id;


    if (Yii::$app->request->isPost) {
         
        $address1 = Yii::$app->request->post('new_address');
        $address2 = Yii::$app->request->post('address2');
        $city     = Yii::$app->request->post('city');
        $state    = Yii::$app->request->post('state');
        $pin      = Yii::$app->request->post('pin');
        $shop_id=$inputOrderId;

        if (!empty($address1) && !empty($address2) && !empty($city) && !empty($state) && !empty($pin)) {
           
           

            // Save log
            $log = new AddressChangeLog();
            $log->order_id = $inputOrderId;
            $log->new_address = json_encode([
               
                'address1' => $address1,
                'address2' => $address2,
                'city'     => $city,
                'state'    => $state,
                'pin'      => $pin,
                'shop_id' => $shop_id,
                
            ]);
            $log->change_status = 0;
            $log->created_at = date('Y-m-d H:i:s');
            $log->save(false);
            
    $payload = json_decode($tokenModel->other_data, true);
            $firstName = $payload['first_name'] ?? '';
            $lastName = $payload['last_name'] ?? '';
            $phone=$payload['phone'] ?? '';
            

            // Mark token used
            $tokenModel->is_used = 1;
            $tokenModel->save(false);
 $result = webhookSender::sendThanks($payload,$firstName, $lastName,$phone); 

            return $this->render('address-update-success', [
                'order' => $shop_id
            ]);
        }
    }

    // return $this->render('update-form', [
    //     'order' => $shop_id,
    //     'token' => $tokenModel,
    // ]);
}//end saving function



 public function actionCronUpdateAddress()
    {
        $pendingLogs = AddressChangeLog::find()
            ->where(['change_status' => 0])
            ->all();

        foreach ($pendingLogs as $log) {
            $order= ItEasyOrder::findOne(['it_easy_other_order_id' =>$log->order_id]);

           

            if ($order) {
                $decodedNew = json_decode($log->new_address, true);

                if ($decodedNew && is_array($decodedNew)) {
                    // Capture current (old) address
                    $oldAddress = [
                'order_id_crm'=>$order->it_easy_order_id,
                'address1' => $order->it_easy_shipping_address_1,
                'address2' => $order->it_easy_shipping_address_2,
                'city'     => $order->it_easy_shipping_city,
                'state'    => $order->it_easy_shipping_state,
                'pin'      => $order->it_easy_shipping_pincode,
                'shop_id' => $order->it_easy_other_order_id,
            ];
                    $log->old_address = json_encode($oldAddress);

                    // Update with new address
                    $order->it_easy_shipping_address_1 = $decodedNew['address1'] ?? '';
                    $order->it_easy_shipping_address_2 = $decodedNew['address2'] ?? '';
                    $order->it_easy_shipping_city      = $decodedNew['city'] ?? '';
                    $order->it_easy_shipping_pincode   = $decodedNew['pincode'] ?? '';
                    $order->it_easy_shipping_state     = $decodedNew['state'] ?? '';
                   

                    // Save changes
                    $order->save(false);
                    $log->change_status = 1;
                    $log->save(false);
 return [
        'status' => 200,
        'message' => 'Old address saved.',
        'order' => $log->order_id,
       
    ];
                   
                } else {
                    return [
        'status' => 200,
        'message' => 'invalid new_address JSON for Order ID.',
        'order' => $log->order_id,
       
    ];
                   
                }
            } else {
                 return [
        'status' => 200,
        'message' => 'ot found in main table yet.',
        'order' => $log->order_id,
       
    ];
              
            }
        }

     
    }//test console function
    
    //testing function
    public function actionTestData2()
{
  

  Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

    // Handle JSON body
    $rawBody = Yii::$app->request->getRawBody();
    $data = json_decode($rawBody, true);

    $orderId = $data['order_id'] ?? null;
    $dataToStore = [
    'first_name' => $data['first_name'] ?? null,
    'last_name'  => $data['last_name'] ?? null,
     'phone'  => $data['phone'] ?? null,
];

   

    
 $inputOrderId =$orderId;
$normalizedOrderId = 's' . ltrim($inputOrderId, '#');
$token = Yii::$app->security->generateRandomString(40);

$model = new AddressUpdateToken();
$model->order_id = $normalizedOrderId;
$model->other_data=json_encode($dataToStore);
$model->token = $token;
// $model->expires_at = date('Y-m-d H:i:s', strtotime('+1 day')); // 24 hours from 
$model->expires_at = date('Y-m-d H:i:s', strtotime('+5 minutes'));
$model->save(false);


$publicUrl = 'https://update.nutriherbs.in/verify-address/update-address.php?token=' . urlencode($token);

    
    
    
     Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

    // your logic here...

    return [
        'status' => 200,
        'message' => 'Public address update link generated.',
        'update_link' => $publicUrl,
        'token' => $token,
    ];

   
}//end function


public function actionAddressUpdate3($token)
{
    $this->layout = false;
    Yii::$app->response->format = \yii\web\Response::FORMAT_HTML;

    $tokenModel = AddressUpdateToken::find()
        ->where(['token' => $token, 'is_used' => 0])
        ->andWhere(['>', 'expires_at', date('Y-m-d H:i:s')])
        ->one();
        

    if (!$tokenModel) {
        return $this->render('token-expired');
    }

  
    
 $inputOrderId =$tokenModel->order_id;


    if (Yii::$app->request->isPost) {
         
        $address1 = Yii::$app->request->post('new_address');
        $address2 = Yii::$app->request->post('address2');
        $city     = Yii::$app->request->post('city');
        $state    = Yii::$app->request->post('state');
        $pin      = Yii::$app->request->post('pin');
        $shop_id=$inputOrderId;

        if (!empty($address1) && !empty($address2) && !empty($city) && !empty($state) && !empty($pin)) {
           
           

            // Save log
            $log = new AddressChangeLog();
            $log->order_id = $inputOrderId;
            $log->new_address = json_encode([
               
                'address1' => $address1,
                'address2' => $address2,
                'city'     => $city,
                'state'    => $state,
                'pin'      => $pin,
                'shop_id' => $shop_id,
                
            ]);
            $log->change_status = 0;
            $log->created_at = date('Y-m-d H:i:s');
            $log->save(false);
            
            $payload = json_decode($tokenModel->other_data, true);
            $firstName = $payload['first_name'] ?? '';
            $lastName = $payload['last_name'] ?? '';
            $phone=$payload['phone'] ?? '';
            

            // Mark token used
            $tokenModel->is_used = 1;
            $tokenModel->save(false);
 $result = webhookSender::sendThanks($payload,$firstName, $lastName,$phone); 
            return $this->render('address-update-success', [
                'order' => $shop_id
            ]);
        }
    }

    // return $this->render('update-form', [
    //     'order' => $shop_id,
    //     'token' => $tokenModel,
    // ]);
}//end saving function














}//controller
