<?php

namespace backend\controllers;

use backend\models\ItEasyXpressbeesPincodes;
use backend\models\ItEasyXpressbeesPincodesSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use yii\filters\AccessControl;
use yii\web\UploadedFile;
use yii2tech\spreadsheet\Spreadsheet;
use yii\data\ArrayDataProvider;
/**
 * XpressbeesPincodesController implements the CRUD actions for ItEasyXpressbeesPincodes model.
 */
class XpressbeesPincodesController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all ItEasyXpressbeesPincodes models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyXpressbeesPincodesSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ItEasyXpressbeesPincodes model.
     * @param int $it_easy_id It Easy ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */


    /**
     * Creates a new ItEasyXpressbeesPincodes model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    
    public function actionExport()
    {
        $data = ItEasyXpressbeesPincodes::find()->asArray()->all();
        
        $exporter = new Spreadsheet([
                'dataProvider' => new ArrayDataProvider([
                    'allModels' => $data,
                ]),
                'columns' => [
                    [   'attribute' => 'it_easy_Pincode'],
                    [   'attribute' => 'it_easy_AreaCode'],
                    [   'attribute' => 'it_easy_HubCity'],
                    [   'attribute' => 'it_easy_HubState'],
                  	[   'attribute' => 'it_easy_COD'],
                  	[   'attribute' => 'it_easy_Prepaid'],
                ],
            ]);
            return $exporter->send('XB-pincode.xlsx');
    }
     
     
    public function actionCreate()
    {
        $model = new ItEasyXpressbeesPincodes();

        if ($model->load(Yii::$app->request->post())) {
            $post = Yii::$app->request->post();
            ItEasyXpressbeesPincodes::deleteAll();
            $model->file = UploadedFile::getInstance($model, 'file');
       
            $time = time();

            $model->file->saveAs('csv/' .$time. '.' . $model->file->extension);
            $model->file = 'csv/' .$time. '.' . $model->file->extension;
            


            date_default_timezone_set('Asia/kolkata');

            $fileHandler = fopen($model->file, "r"); 
           
           
            if ($fileHandler) {
                $count=0;
                while ($line = fgetcsv($fileHandler, 1000)) {
                    if($count!=0){

                        $model = new ItEasyXpressbeesPincodes();
                        $model->it_easy_Pincode = trim($line[0]);
                        $model->it_easy_AreaCode = trim($line[1]);
                        $model->it_easy_process_code = trim($line[1]);
                        $model->it_easy_HubCity = trim($line[2]);
                        $model->it_easy_HubState = trim($line[3]);
                        $model->it_easy_COD =trim($line[5]);
                        $model->it_easy_Prepaid = trim($line[4]);
                        $currentDateTime = date('Y-m-d  H:i:s');
                        $time = time();
                        $model->created_by = Yii::$app->user->identity->id;
                        $model->created_time = $currentDateTime;
                        $model->it_easy_date_added = $currentDateTime;
                        $model->save(false);

                    }
                    $count++;
                   
                }
            }
            Yii::$app->session->setFlash('success', 'Your data has been successfully submitted!');
            return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
        }
        return $this->render('create', [
            'model' => $model,
        ]);
    
    }

    /**
     * Updates an existing ItEasyXpressbeesPincodes model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_id It Easy ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_id)
    {
        $model = $this->findModel($it_easy_id);

        if ($model->load(Yii::$app->request->post())) {
            $post = Yii::$app->request->post();
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');
            $time = time();
            $model->updated_by = Yii::$app->user->identity->id;
            $model->updated_time = $currentDateTime;
            
            $model->save(false);
            

            Yii::$app->session->setFlash('success', 'Form has been updated');
            return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing ItEasyXpressbeesPincodes model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $it_easy_id It Easy ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($it_easy_id)
    {
        $this->findModel($it_easy_id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the ItEasyXpressbeesPincodes model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_id It Easy ID
     * @return ItEasyXpressbeesPincodes the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_id)
    {
        if (($model = ItEasyXpressbeesPincodes::findOne(['it_easy_id' => $it_easy_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    public function actionXpressbeesPincodes()
{
    $model = new \backend\models\ItEasyXpressbeesPincodes();

    if ($model->load(Yii::$app->request->post())) {
        if ($model->validate()) {
            // form inputs are valid, do something here
            return;
        }
    }

    return $this->render('XpressbeesPincodes', [
        'model' => $model,
    ]);
}
}
