<?php

namespace backend\controllers;

use backend\models\ItEasyZonePincode;
use backend\models\ItEasyZonePincodeSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use yii\filters\AccessControl;
use yii\web\UploadedFile;

/**
 * ZonePincodeController implements the CRUD actions for ItEasyZonePincode model.
 */
class ZonePincodeController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }
    /**
     * Lists all ItEasyZonePincode models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new ItEasyZonePincodeSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ItEasyZonePincode model.
     * @param int $it_easy_id It Easy ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */

    /**
     * Creates a new ItEasyZonePincode model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new ItEasyZonePincode();

        if ($model->load(Yii::$app->request->post())) {
            $post = Yii::$app->request->post();
            ItEasyZonePincode::deleteAll();
            $model->file = UploadedFile::getInstance($model, 'file');
       
            $time = time();

            $model->file->saveAs('csv/' .$time. '.' . $model->file->extension);
            $model->file = 'csv/' .$time. '.' . $model->file->extension;
            


            date_default_timezone_set('Asia/kolkata');

            $fileHandler = fopen($model->file, "r"); 
           
           
            if ($fileHandler) {
                $count=0;
                while ($line = fgetcsv($fileHandler, 1000)) {
                    if($count!=0){

                        $model = new ItEasyZonePincode();
                        $model->it_easy_pincode = trim($line[0]);
                      	$model->it_easy_pickup_pincode=trim($line[1]);
                        $model->it_easy_zone_name = trim($line[2]);
                        $model->it_easy_city = trim($line[3]);
                        $model->it_easy_state = trim($line[4]);
                        $currentDateTime = date('Y-m-d  H:i:s');
                        $time = time();
                      
                        $model->save(false);

                    }
                    $count++;
                   
                }
            }



            Yii::$app->session->setFlash('success', 'Form has been created');
            return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
        }
        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing ItEasyZonePincode model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $it_easy_id It Easy ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($it_easy_id)
    {
        $model = $this->findModel($it_easy_id);

        if ($model->load(Yii::$app->request->post())) {
            $post = Yii::$app->request->post();
            date_default_timezone_set('Asia/kolkata');
            $currentDateTime = date('Y-m-d H:i:s');
            $time = time();
           
            
            $model->save(false);
            

            Yii::$app->session->setFlash('success', 'Form has been updated');
            return $this->redirect(['index', 'it_easy_id' => $model->it_easy_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing ItEasyZonePincode model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $it_easy_id It Easy ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($it_easy_id)
    {
        $this->findModel($it_easy_id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the ItEasyZonePincode model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $it_easy_id It Easy ID
     * @return ItEasyZonePincode the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($it_easy_id)
    {
        if (($model = ItEasyZonePincode::findOne(['it_easy_id' => $it_easy_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    public function actionZonpincode()
    {
        $model = new \backend\models\ItEasyZonePincode();

        if ($model->load(Yii::$app->request->post())) {
            if ($model->validate()) {
                // form inputs are valid, do something here
                return;
            }
        }

        return $this->render('zonpincode', [
            'model' => $model,
        ]);
    }
}
